/*
 * VTFileContext.h
 *
 *  Created on: Oct 14, 2012
 *      Author: matthias
 */

#ifndef VTFILECONTEXT_H_
#define VTFILECONTEXT_H_

#include <vector>

using namespace std;

typedef struct
{
	char extension[16];
	int fileFormat;
	int fileType;
} tVTFileTypeEntry;

 /* definition of context structure forwarded to VT file system */
typedef struct {
	int dummy;
	vector<tVTFileTypeEntry> registeredFileTypes;
    vector<string> registeredFileFilterPatterns;
	string internalPlaylistPath;
	int  mMaxDepth;
	int  mSupportedPlaylistRecurseDepth;
	int  mMaxCacheSize;
	bool mShowAllPlaylistEntries;
	int mNumberOfVTCacheElements;
	int mCacheHits;
	int mCacheMisses;
} tVTFileContext;

void VTFSEntrySetContext(void *context);

#endif /* VTFILECONTEXT_H_ */
