/*
 * VTFS.cpp
 *
 *  Created on: Jun 14, 2013
 *      Author: dinesh , matthias
 */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_VT_FILE
#ifdef TARGET_BUILD
#include "trcGenProj/Header/VTFS.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_VT_FILE
#endif
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <string.h>
#include <ctype.h>
#include <memory.h>
#include "Utf8FileName.h"
#include "FastUTF8.h"
#include "FSCursor.h"
#include "VTFS.h"
#include <glib.h>
#include <sqlite3ext.h>

#include "TraceDefinitions.h"
#include "FunctionTracer.h"
#include "Utils.h"

/*lint -save -e1773 */

SQLITE_EXTENSION_INIT1
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

typedef struct _VTFS
{
    void *contextPointer ;
} VTFS;

static VTFS self ;

/* DDL defining the structure of the vtable */
static const char* ddl = "create table vtable (mountpoint text, path text, filename text, type integer, format integer) ";
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

static int VTFSDestructor(sqlite3_vtab *pVtab) // finished: 100%
{
    ENTRY;
    tVTFileSystem *p = (tVTFileSystem*)pVtab; //lint !e826

    sqlite3_free(p);

    return 0;
}

static int VTFSCreate( sqlite3 *db, void *p_aux, int argc, const char * const* argv , sqlite3_vtab **pp_vt,   char **pzErr ) // finished: 100%
{
    ENTRY;

    (void)argc;
    (void)argv;
    (void)pzErr;

    tVTFileSystem *vTabObject;
    int rc;

    /* allocate the virtual table object */
    vTabObject = (tVTFileSystem *)sqlite3_malloc(sizeof(tVTFileSystem));
    if (!vTabObject) return SQLITE_NOMEM;
    memset(vTabObject, 0, sizeof(tVTFileSystem));

    /* declare the table to the sqlite */
    rc = sqlite3_declare_vtab(db, ddl);
    if(rc != SQLITE_OK)
    {
        sqlite3_free(vTabObject);
        return SQLITE_ERROR;
    }

    /* set the user context */
    vTabObject->context = (tVTFileContext *)p_aux;

    /* set the resulting pointer to new vtab struct */
    *pp_vt = (sqlite3_vtab *)vTabObject;

    return SQLITE_OK;
}

static int VTFSConnect( sqlite3 *db, void *p_aux, int argc, const char * const *argv, sqlite3_vtab **pp_vt, char **pzErr ) // finished: 100%
{
    ENTRY;
    return VTFSCreate(db, p_aux, argc, argv, pp_vt, pzErr);
}

static int VTFSDisconnect(sqlite3_vtab *pVtab) // finished: 100%
{
    ENTRY;
    return VTFSDestructor(pVtab);
}

static int VTFSDestroy(sqlite3_vtab *pVtab) // finished: 100%
{
    ENTRY;
    return VTFSDestructor(pVtab);
}

static int VTFSOpen(sqlite3_vtab *pVTab, sqlite3_vtab_cursor **pp_cursor) // finished: 100%
{
    ENTRY;
    tVTFileSystem* p_vt         = (tVTFileSystem*)pVTab; //lint !e826
    p_vt->base.zErrMsg = NULL;

    tVTFileSystemCursor *cursor = (tVTFileSystemCursor*)sqlite3_malloc(sizeof(tVTFileSystemCursor));
    if (cursor == NULL)
    {
        return SQLITE_NOMEM;
    }
    /* reset memory */
    memset(cursor, 0, sizeof(tVTFileSystemCursor));

    /* Initialize the current node */
    tFileSystemNode * currentNode =  (tFileSystemNode*)malloc(sizeof(tFileSystemNode));
    if (currentNode == NULL)
    {
        sqlite3_free (cursor);
        return SQLITE_NOMEM;
    }
    /* reset memory */
    memset(currentNode, 0, sizeof(tFileSystemNode));

    /*attach newly created node to the cursor*/
    cursor->currentNode  = currentNode;

    *pp_cursor = (sqlite3_vtab_cursor*)cursor;

    return SQLITE_OK;
}

/* Cleanup current cursor */
static void VTFSDeallocateCursor(tVTFileSystemCursor *cursor) // finished: 100%
{
    ENTRY;
    if(cursor == NULL)
        return;

    /*delete the node tree*/
    tFileSystemNode* node = cursor->currentNode;
    while(cursor->currentNode->parentNode != NULL)
    {
        node = cursor->currentNode->parentNode;
        FSCursorDeallocateNode(cursor->currentNode);
        cursor->currentNode = node;
    }
    FSCursorDeallocateNode(cursor->currentNode);
    cursor->currentNode = NULL;

    if (cursor->mountPoint != NULL)
    {
        free((void*)cursor->mountPoint);
        cursor->mountPoint = NULL;
    }

    if(cursor->playListEntryPath != NULL)
    {
        free((void*)cursor->playListEntryPath); //lint -e1773
        cursor->playListEntryPath = NULL;
    }
    if(cursor->playListEntryName != NULL)
    {
        free((void*)cursor->playListEntryName); //lint -e1773
        cursor->playListEntryName = NULL;
    }
    sqlite3_free(cursor);
}

static int VTFSClose(sqlite3_vtab_cursor *cur) // finished: 100%
{
    ENTRY;
    tVTFileSystemCursor *cursor = (tVTFileSystemCursor*)cur; //lint !e826

    /* Free all its contents like node , path etc. */
    VTFSDeallocateCursor(cursor);

    return SQLITE_OK;
}

static int VTFSEof(sqlite3_vtab_cursor *cur) // finished: 100%
{
    ENTRY;
    tVTFileSystemCursor *cursor = (tVTFileSystemCursor*)cur; //lint !e826
    return cursor->endOfDataset;
}

static int VTFSNext(sqlite3_vtab_cursor *cur) // finished: 100%
{
    ENTRY;

    /* next element */
    int res = FileSystemCursorNext(cur);

    /* statistics */
    tVTFileSystem *p_vt = (tVTFileSystem *)cur->pVtab; //lint !e826
    tVTFileContext *context = p_vt->context;
    context->mNumberOfVTCacheElements = gNumberOfVTCacheElements;
    context->mCacheHits = gCacheHits;
    context->mCacheMisses = gCacheMisses;

    return res;
}

static int VTFSColumn(sqlite3_vtab_cursor *cur, sqlite3_context *ctx, int i) // finished: 80%
{
    ENTRY;
    tVTFileSystemCursor *cursor = (tVTFileSystemCursor*)cur; //lint !e826
    tFileSystemNode* currentNode = cursor->currentNode;

    /* Fill the DB VT table fields */
    switch (i) {
    case 0: // mountpoint
        sqlite3_result_text(ctx, cursor->mountPoint, strlen_r(cursor->mountPoint), SQLITE_STATIC);
        break;

    case 1: // path
        /* return the path name */
        if (cursor->currentNode->fileType == FILE_TYPE_PLAYLIST)
        {
        	if(cursor->playListEntryPath)
        		sqlite3_result_text(ctx, cursor->playListEntryPath, strlen_r(cursor->playListEntryPath), SQLITE_STATIC);
        	else
        		sqlite3_result_text(ctx, "", 0, SQLITE_STATIC);

        }
        else if ( currentNode->path == NULL)
        {
            sqlite3_result_text(ctx, "", 0, SQLITE_STATIC);
        }
        else
        {
            char *path = currentNode->path;
            sqlite3_result_text(ctx, &path[strlen_r(cursor->mountPoint)+1], strlen_r(&path[strlen_r(cursor->mountPoint)+1]), SQLITE_STATIC);
        }
        break;

    case 2: // name
        /* return the pure file or directory name */
        if (cursor->currentNode->fileType == FILE_TYPE_PLAYLIST)
        {
            if(cursor->playListEntryName)
                sqlite3_result_text(ctx, cursor->playListEntryName, strlen_r(cursor->playListEntryName), SQLITE_STATIC);
            else
            	sqlite3_result_text(ctx, "", 0, SQLITE_STATIC); //lint -e1773
        }
        else
        {
            if (currentNode->entry == NULL ||  strlen_r(currentNode->entry->d_name) == 0)
            {
                sqlite3_result_text(ctx, "", 0, SQLITE_STATIC);
            }
            else
            {
                sqlite3_result_text(ctx, currentNode->entry->d_name, strlen_r(currentNode->entry->d_name), SQLITE_STATIC);
            }
        }
        break;

    case 3: // type
        sqlite3_result_int(ctx,  cursor->fileType);
        break;

    case 4: // format
        sqlite3_result_int(ctx,  cursor->fileFormat);
        break;

    default:
        sqlite3_result_int(ctx, 0);
        break;
    }

    return SQLITE_OK;
}

static int VTFSRowid(sqlite3_vtab_cursor *cur, sqlite_int64 *p_rowid) // finished: 100%
{
    ENTRY;
    tVTFileSystemCursor *cursor = (tVTFileSystemCursor*)cur; //lint !e826

    /* Just use the current row count as the rowid. */
    *p_rowid = cursor->objectCount_rowID;

    return SQLITE_OK;
}

static int VTFSFilter( sqlite3_vtab_cursor *p_vtc, int idxNum, const char *idxStr, int argc, sqlite3_value **argv ) // finished: 80%
{
    ENTRY;

    (void)idxNum;
    (void)idxStr;

    tVTFileSystemCursor *cursor = (tVTFileSystemCursor*)p_vtc; //lint !e826
    const unsigned char *path;



    /* set the mount point, it is the first where-clause-part */
    cursor->mountPoint = strdup( (const char*) (sqlite3_value_text(argv[0])) );
    if (!cursor->mountPoint) return SQLITE_NOMEM;

    /* set the search path, it could be the second where-clause-part */
    if(argc > 1) { // path as where given
        path = sqlite3_value_text(argv[1]);
    } else  { // no path given
        path = (const unsigned char*)"";
    }

    /* count the slashes to get the depth */
    int slashCount;
    slashCount = FastUTF8::Count((unsigned char *)path, (unsigned char *)"/"); //lint -e1773
    tVTFileSystem *p_vt = (tVTFileSystem *)p_vtc->pVtab; //lint !e826
    tVTFileContext *context = p_vt->context;

    /* if depth too high, reject this request */
    if (slashCount > context->mMaxDepth) {
        cursor->endOfDataset = 1;
        return SQLITE_OK;
    }

    // assemble the search path
    cursor->recursive = false;
    cursor->currentNode->path = (char *)malloc(strlen_r(cursor->mountPoint) + 1 + strlen_r((char *)path) + 1); //lint -e1773
    if (!cursor->currentNode->path) return SQLITE_NOMEM;

    if(FastUTF8::StartsWith((FastUTF8::tString)path,(FastUTF8::tString)"//"))
    {
        /*detected internal playlist created by user which will not have any mount point since it is located in the internal flash*/
        strcpy(cursor->currentNode->path, (const char *)path);
    }
    else
    {
        FastUTF8::tString realPath = FastUTF8::StartsWith((FastUTF8::tString)path,(FastUTF8::tString)"recursive:"); //lint -e1773
        if(realPath != NULL)
        {
            cursor->recursive = true;
            path = realPath;
			
            /*Append "/" to the path if it doesnt has it at its end */
            if(NULL == FastUTF8::EndsWithNC((const FastUTF8::tString)path, (const FastUTF8::tString)"/")) //lint !e1773
            {
                strcat((char *)path,(const char*)"/");
            }
        }
        /* regular folder or playlist located in the connected device with a mount point*/
        strcpy(cursor->currentNode->path, cursor->mountPoint);
        if(NULL == FastUTF8::StartsWith((FastUTF8::tString)path,(FastUTF8::tString)"/")) //lint -e1773
        {
            strcat(cursor->currentNode->path, (const char *)"/");
        }
        strcat(cursor->currentNode->path, (const char *)path);
    }

    /* reset cursor values */
    cursor->objectCount_rowID = 0;
    cursor->endOfDataset = 0;
    cursor->currentNode->parentNode = NULL;

    /* start directory scan */
    return FileSystemOpenDir(cursor);
}

static int VTFSHasConstraint(sqlite3_index_info *p_info, int col, int opmask) // finished: 100%
{
    ENTRY_INTERNAL;
    int i;
    for(i = 0; i < p_info->nConstraint; i++)
    {
        if(p_info->aConstraint[i].iColumn == col)
        {
            /* If specific operations are specified */
            if(opmask != 0)
            {
                /* Check that at least one is satisfied */
                if(p_info->aConstraint[i].op & opmask)
                {
                    return i;
                }
            }
            return i;
        }
    }
    return -1;
}

static int VTFSBestIndex(sqlite3_vtab *tab, sqlite3_index_info *pIdxInfo) // finished: 100%
{
    ENTRY_INTERNAL;

    (void) tab;

    int i = 0;
    int ops = SQLITE_INDEX_CONSTRAINT_MATCH | SQLITE_INDEX_CONSTRAINT_EQ;

    // mountpoint in where
    if((i = VTFSHasConstraint(pIdxInfo, 0, ops)) > -1)
    {
        /* Then we want the value to be passed to xFilter() */
        pIdxInfo->aConstraintUsage[i].argvIndex = 1;
    }

    // path in where
    if((i = VTFSHasConstraint(pIdxInfo, 1, ops)) > -1)
    {
        /* Then we want the value to be passed to xFilter() */
        pIdxInfo->aConstraintUsage[i].argvIndex = 2;
    }

    return SQLITE_OK;
}

static int VTFSUpdate(sqlite3_vtab *pVTab,int argc,sqlite3_value **argv,sqlite_int64 *pRowid)
{
    ENTRY;
    (void)pVTab;
    (void)argc;
    (void)argv;
    (void)pRowid;

    // used to delete the cache matching with given mount point
    return SQLITE_OK;
}

static void VTFSMatchFunction(sqlite3_context* ctx, int argc, sqlite3_value** argv) // finished: 100%
{
    ENTRY_INTERNAL;
    (void)argc;
    (void)argv;

    sqlite3_result_int(ctx, 1);
}

static int VTFSFindFunction( sqlite3_vtab *pVtab, int nArg,const char *zName,
                             void (**pxFunc)(sqlite3_context*,int,sqlite3_value**),
                             void **ppArg )
{
    ENTRY_INTERNAL;
    (void)pVtab;
    (void)nArg;
    (void)ppArg;

    if(strcmp(zName, "match") == 0)
    {
        *pxFunc = VTFSMatchFunction;

        return 1;
    }
    return SQLITE_OK;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
static sqlite3_module VTFSModule =
{
    0, /* iVersion */
    VTFSCreate, /* xCreate - create a vtable */
    VTFSConnect, /* xConnect - associate a vtable with a connection */
    VTFSBestIndex, /* xBestIndex - best index */
    VTFSDisconnect, /* xDisconnect - disassociate a vtable with a connection */
    VTFSDestroy, /* xDestroy - destroy a vtable */
    VTFSOpen, /* xOpen - open a cursor */
    VTFSClose, /* xClose - close a cursor */
    VTFSFilter, /* xFilter - configure scan constraints */
    VTFSNext, /* xNext - advance a cursor */
    VTFSEof, /* xEof - inidicate end of result set*/
    VTFSColumn, /* xColumn - read data */
    VTFSRowid, /* xRowid - read data */
    VTFSUpdate, /* xUpdate - write data */
    NULL, /* xBegin - begin transaction */
    NULL, /* xSync - sync transaction */
    NULL, /* xCommit - commit transaction */
    NULL, /* xRollback - rollback transaction */
    VTFSFindFunction, /*  xFindFunction - function overloading */
    NULL,
    NULL,
    NULL,
    NULL
};

int VTFS_register(sqlite3 *db, void *userContext) // finished: 100%
{
    /* init glib types (needed for totem playlist parser) */
    //g_type_init() is deprecated in version 2.36 and higher versions.
    //g_type_init();
    int ret = sqlite3_create_module(db, "FileSystemVT", &VTFSModule, userContext);

    return ret;
}

void VTFSEntrySetContext(void *context)
{
    self.contextPointer = context;
    FSCacheSetLimit(((tVTFileContext*)context)->mMaxCacheSize);
}

extern "C" int sqlite3_extension_init( sqlite3 *db, char **pzErrMsg, const sqlite3_api_routines *pApi ) // finished: 100%
{
    (void)pzErrMsg;

    SQLITE_EXTENSION_INIT2(pApi);

    if(VTFS_register(db, self.contextPointer) != SQLITE_OK)
    {
        return SQLITE_ERROR;
    }
    return SQLITE_OK;
}
