/*
 * FSCache.h
 *
 *  Created on: 19.12.2014
 *      Author: Thömel
 */

#ifndef FSCACHE_H_
#define FSCACHE_H_

#include "VTFS.h"
#include "VTFileTypes.h"

int FSCacheLock();
void FSCacheUnlock();
void FSCacheReset(void);
bool FSCacheDelete(const char *path);
void FSCacheSetLimit(int limit);
DIR *FSCacheOpendir(const char *name);
struct dirent *FSCacheReaddir(DIR *dirp);
int FSCacheClosedir(DIR *dirp);

#ifdef FS_CACHE_CPP_
int gNumberOfVTCacheElements = 0;
int gCacheHits = 0;
int gCacheMisses = 0;
#else
extern int gNumberOfVTCacheElements;
extern int gCacheHits;
extern int gCacheMisses;
#endif

#endif /* FSCACHE_H_ */
