/* -------------------------------------------------------------------------- */
/**
 *   @defgroup VTCDDA VTCDDA.h
 *   @ingroup  MediaPlayer
 *   @author   Stephan Pieper, 2015
 *
 *   Virtual table CDDA to access /dev/cdaudio.
 */
/* -------------------------------------------------------------------------- */
 
#if !defined(VTCDDA_H_INCLUDED)
#define VTCDDA_H_INCLUDED
 
/* -------------------------------------------------------------------------- */

#include <sqlite3.h>

#include <sqlite3ext.h>
SQLITE_EXTENSION_INIT1

#include "RequestResponseSM.h"

/* -------------------------------------------------------------------------- */
// statemachine

class RequestResponseCDDAControl: public RequestResponseSM
{

    int HandleInitRequest()
    {
        tResult res = 0;
        return res;
    }

    int HandleLoopBackMessage(const char *allParameters)
    {
        tResult res = 0;
        return res;
    }

    int HandleEntryWaitingRequest()
    {
        return 0;
    }

    int HandleSuccessRequest(const char *allParameters)
    {

        /* the request/expect state machine has a general SUCCESS_REQUEST message which is not
        // specialized to a service state machine be called, so all kind of parameters must
        // be processed by hand in this method. */
        if(allParameters != NULL)
        {
            tFiles *fileInfoPtr;
            SMF::UnMarshal(allParameters, "p" ,&fileInfoPtr);
            if(NULL != (fileInfoPtr))
            {
                mFileInfo = *fileInfoPtr;
                delete fileInfoPtr;

                /* is EOF signaled? */
                isEOF = mFileInfo.isEOF;
            }
        }
        return 0;
    }

public:

        tFiles  mFileInfo;
        bool    isEOF;
        RequestResponseCDDAControl()
        {
           isEOF = false;
           memset(&mFileInfo, 0, sizeof(mFileInfo));
           mFileInfo.type = FT_UNKNOWN;
           mFileInfo.objectID = OBJECT_ID_NONE;
           mFileInfo.fileFormat = FFT_UNKNOWN;
           mFileInfo.notPlayable = FNP_PLAYABLE;
           mFileInfo.isPlaying = false;
           mFileInfo.trackNumber = -1;
           mFileInfo.isEOF = 1;
        }
};

/* -------------------------------------------------------------------------- */

typedef struct
{
    sqlite3_vtab base;
    sqlite3 *db;
} tVTCDDA;

/* -------------------------------------------------------------------------- */
// cursor;

typedef struct
{
    sqlite3_vtab_cursor          base;
    tIndex                       rowIndex;
    tMountPoint                  mountPoint;
    tPath                        path;
    RequestResponseCDDAControl  *rrCDDAControl;

} tVTCDDACursor;

/* Update cursor to point to next top-level directory to search, if any. */
int CDDACursorNext(tVTCDDACursor *p_cur);

/* -------------------------------------------------------------------------- */

/**
 * @brief register this CDDA VT implementation which have name "CDDAVT".
 * @return SQLITE if succeed, otherwise return error or error code.
 */
int VTCDDA_register(sqlite3 *db);

/* -------------------------------------------------------------------------- */

#endif // VTCDDA_H_INCLUDED

/* -------------------------------------------------------------------------- */
