/*
 * BTCursor.h
 *
 *  Created on: Oct 21, 2013
 *      Author: pee1cob
 */

#ifndef BTCURSOR_H_
#define BTCURSOR_H_

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sqlite3.h>
#include <vector>
#include <string>
#include <list>
#include "RequestResponseSM.h"
#include "VTBluetoothContext.h"
using namespace std;


#define UID_STRING_SIZE 17
// Location of Byte Representing the First Byte of Item Name
#define START_OF_FOLDER_NAME 16
#define START_OF_MEDIAELEMENT_NAME 15

//Length
#define SIZE_OF_ITEM_TYPE_CUM_LENGTH 3
#define FIRST_BATCH_SIZE 20

typedef struct
{
    sqlite3_vtab base;
    sqlite3 *db;
    tVTBluetoothContext *context;
}tVTBluetooth;

class RequestResponseBTControl: public RequestResponseSM
{

    int HandleInitRequest()
    {
        return 0;
    }

    int HandleEntryWaitingRequest()
    {
        return 0;
    }

    int HandleSuccessRequest(const char *allParameters)
    {

        int ByteCount = 0;
        /* the request/expect state machine has a general SUCCESS_REQUEST message which is not
        // specialized to a service state machine be called, so all kind of parameters must
        // be processed by hand in this method. */
        //ETG_TRACE_USR1(("BTTestSM::HandleSuccessRequest allParameters:%s", allParameters));
        if(allParameters != NULL)
        {
            ByteCount = strlen_r(allParameters);
            ParamString = new char[ByteCount+1];
            if(ParamString)
            {
                strncpy_r(ParamString,allParameters,(ByteCount+1));
            }
        }
        return 0;
    }

public:

    	char *ParamString ;

    	RequestResponseBTControl()
    	{
    		ParamString = NULL;
    	}
};
typedef struct
{
    sqlite3_vtab_cursor         base;
    int                         objectCount_rowID;
    int                         endOfDataset;
    char                        *mountPoint;
    char                        *Path;
    char                        *ItemName;
    int                          ItemType;
    RequestResponseBTControl    *rrBTControl;
    int                          AvailableRowCount;
    int                          RequestedRowCount;
    tFileFormat                 FileFormat;
    char                        *ItemUID;
    int                         count;
    int                         listType;
    int                         limit;
    int                         offset;
} tVTBluetoothCursor;
#include "BTCache.h"

/* Update cursor to point to next top-level directory to search, if any. */
//int VTBluetoothCursorNext(tVTBluetoothCursor *cursor,string ReqPath);

int VTBluetoothCursorNext(tVTBluetoothCursor *cursor);
int DoGetFolderItem(tVTBluetoothCursor *cursor,tScope Scope,tStartItem StartItem,tEndItem EndItem);
int DoChangePath(tDirection Direction,tLevelCount LevelUpCount,
				tLevelCount LevelDownCount,
				tItemUIDArray ItemUIDArray,
				tVTBluetoothCursor *cursor,tBTMethodRequestStatus &Status,
				tNumOfItems &NumOfItems,tErrorMessage &ErrorMessage);
unsigned int FindNumberOfDelimiters(const char* param, char deLimiter);
tResult ChangeBrowsePath(tVTBluetoothCursor *cursor,string reqPath);

//Function to setup fields of VTBluetoothCursor with dummy valid values.
//Note: VTBluetoothCursor Fields:mountpoint,listType,path are not changed
void SetupDummyCursor(tVTBluetoothCursor *cursor);

//Function to cleanup fields of VTBluetoothCursor and set to invalid
//Note: VTBluetoothCursor Fields:mountpoint,listType,path are not changed
void SetupInvalidCursor(tVTBluetoothCursor *cursor);

#endif /* BTCURSOR_H_ */
