/*
 * BTCursor.cpp
 *
 *  Created on: Oct 21, 2013
 *      Author: pee1cob
 */
/**
 * Change the Current Browsed Path to the Requested Path and
 * point the cursor to first valid file element of that node using generic call FileSystemCurosrNext
 */
 
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_VT_BTLUETOOTH
#ifdef TARGET_BUILD
#include "trcGenProj/Header/BTCursor.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_VT_BTLUETOOTH
#endif
#endif
 
#include <sqlite3.h>
#include <list>
#include <string>
#include "BTCursor.h"
#include <netinet/in.h>
#include <sstream>
#include "Utf8FileName.h"
#include "FastUTF8.h"
#include "TypeDefinitions.h"
#include "FunctionTracer.h"
//#include "VarTrace.h"
#include "MediaPlayer_ErrorCodes.h"
#include "TimeTrace.h"

/*lint -save -e801 */

using namespace std;

int VTBluetoothCursorNext(tVTBluetoothCursor *cursor)
{
    int res = SQLITE_OK;

    //setup invalid cursor
    SetupInvalidCursor(INOUT cursor);

    if((NULL != cursor->Path) &&
            ((static_cast<tUInt>(cursor->limit) == INDEX_NO_LIMIT) ||
                    ((static_cast<tUInt>(cursor->limit) != INDEX_NO_LIMIT) && (cursor->RequestedRowCount <= (cursor->limit + cursor->offset)))))
    {
        string ReqPath((const char*)cursor->Path);

        bool IsNewFolderPath;
        int result = IsBTNewFolderVisit(IN ReqPath.c_str(),OUT IsNewFolderPath);

        if(SQLITE_ERROR == result) return result;
        if(IsNewFolderPath)
        {
            ETG_TRACE_USR3(("New Folder being  Visited.Setting up Browse Path Now"));
            res = ChangeBrowsePath(IN cursor,IN ReqPath);

            //do nothing
            if(SQLITE_ERROR == res) return res;

            BTStorePath(IN ReqPath);
            if(cursor->listType == LTY_BLUETOOTH_FILELIST_COUNT)
            {

                tNumOfItems TotNumOfItems = 0;
                tNumOfItems ElementsInCache = 0;
                BTGetLevelInfo(IN ReqPath,OUT TotNumOfItems,OUT ElementsInCache);

                cursor->count = TotNumOfItems;
            }
            else if(cursor->listType == LTY_BLUETOOTH_FILELIST)
            {
                ETG_TRACE_USR3(("Slice retreival queried without knowing size"));
                return SQLITE_ERROR;
            }
        }
        else //Folder Revisit
        {
            ETG_TRACE_USR3(("Revisit of the Folder"));

            tNumOfItems TotNumOfItems = 0;
            tNumOfItems ElementsInCache = 0;
            bool ret = BTGetLevelInfo(IN ReqPath,OUT TotNumOfItems,OUT ElementsInCache);
            if(ret)
            {
                if(cursor->listType == LTY_BLUETOOTH_FILELIST_COUNT)
                {
                    cursor->count = TotNumOfItems;
                }
                else if(cursor->listType == LTY_BLUETOOTH_FILELIST)
                {
                    //No need to access cache if the TotNumOfItems is zero.
                    if(!TotNumOfItems)
                    {
                        ETG_TRACE_USR3(("Folder Completely Read.But it is empty!."));
                        return SQLITE_OK;
                    }

                    bool isReqItemIndexvailable = isItemAvailableAtGivenIndex(IN  cursor->RequestedRowCount-1 ,IN ReqPath);
                    if(false == isReqItemIndexvailable)
                    {
                        tStartItem StartItem = cursor->RequestedRowCount-1;
                        tEndItem EndItem = StartItem + (FIRST_BATCH_SIZE-1);

                        if(EndItem >= TotNumOfItems)
                        {
                            EndItem = TotNumOfItems-1;
                        }
                        ETG_TRACE_USR3(("StartItem is %d",StartItem));
                        ETG_TRACE_USR3(("EndItem is %d",EndItem));
                        res = ChangeBrowsePath(IN cursor,IN ReqPath);
                        if(SQLITE_ERROR == res) return res; //TODO:
                        tScope Scope = SCOPE_MP_VFS ;

                        //todo :: Handle DoGetFolderItemFailure Case
                        res = DoGetFolderItem(IN cursor,IN Scope,IN StartItem,IN EndItem);
                        if(res == SQLITE_OK)
                        {
                            ETG_TRACE_USR3(("DoGetFolderItem success"));
                        }
                        else
                        {
                            ETG_TRACE_USR3(("DoGetFolderItem failed.Remaining items will be retrieved during folder Revisit"));
                            return SQLITE_ERROR;
                        }
                    }
                    else
                    {
                        ret = BTCacheRead(INOUT cursor);
                        if(ret)
                        {
                            ETG_TRACE_USR3(("BTCacheRead success"));
                        }
                        else
                        {
                            ETG_TRACE_USR3(("BTCacheRead failed"));
                        }
                        return SQLITE_OK;
                        //Below else if will be entered if All items are not retrieved in one shot.e.gChange Path successful.But get folder item failed.
                        //In this case TotNumOfItems will be non-zeo.ElementsInCache will be lesser than TotNumOfItems.
                        //In this,we need to try retrieving the remaining items.(GMMY17-4562)

                    }
                }
            }
            else
            {
                ETG_TRACE_USR3(("BTGetLevelInfo failed"));
                //TODO(Reenu):If LevelInfo unvailable,Reason may be previous changePath trial Failed!.Hence if levelInfo missing,try to get it now!
                //Cursor preparation failed.Hence set to invalid ROW.as xEOF logic looks for invalid cursor to break the Read,it goes-on infinitely.!!!
            }
        }
    }
    //todo :: Handle DoGetFolderItemFailure Case
    return SQLITE_OK;
}


int DoGetFolderItem(tVTBluetoothCursor *cursor, tScope Scope, tStartItem StartItem, tEndItem EndItem)
{
    tNumOfItems ItemRetrieved = 0; //per batch retrieveal count 
	tNumOfItems TotalItemsRetrieved = 0; //sum of retrieveal count from all batches
    int res = SQLITE_OK;
    char sendMessage[64];
    tAllParameters parameter;
    tNumOfItems TotNumOfItems = 0;
    tNumOfItems ElementsInCache = 0;
    bool ret = false;
    map<tNumOfItems,tBrowseElement> ElementsRetrieved;
    string CursorPath = string((const char*)cursor->Path);

    /* Send AVP_GET_FOLDER_ITEM message to BTControlSM */
    strncpy_r(sendMessage, "BTControlSM::AVP_GET_FOLDER_ITEM",sizeof(sendMessage));

RETRIEVE_FOLDER_ITEMS:

    /* generate the parameters for the request */
    cursor->rrBTControl->Marshal(parameter, sizeof(parameter) - 1,
            "iii",Scope,StartItem,EndItem);
    ETG_TRACE_USR3(("Intereseted Item Index range %d - %d",StartItem,EndItem));

    /* do the request and wait for the answer */
    res = cursor->rrBTControl->DoEventAnswer(sendMessage, parameter, NULL, BT_CTRL_SM_ANSWER_TIMEOUT_MS);

    if (res) { // request did not happen
        return SQLITE_ERROR;
    }

    tBTMethodRequestStatus Status =REQ_NOT_OK;
    tScope Scope_Ret = SCOPE_INVALID;
    tNetworkOrder NetworkOrder = false;
    tByteArray ByteArray = NULL;
    tArrayLength ArrayLength = 0;
    tErrorMessage ErrorMessage = NULL;

    if (cursor->rrBTControl->ParamString != NULL) {
        cursor->rrBTControl->UnMarshal(cursor->rrBTControl->ParamString, tBTMethodRequestStatus_format tScope_format tNetworkOrder_format tByteArray_format tArrayLength_format tErrorMessage_format  ,&Status ,&Scope_Ret ,&NetworkOrder ,&ByteArray ,&ArrayLength ,&ErrorMessage );
    }
    else
    {
        return SQLITE_ERROR;
    }
    tVTBluetooth *p_vt = (tVTBluetooth*) ((sqlite3_vtab_cursor*) cursor)->pVtab;
    tVTBluetoothContext *context = (tVTBluetoothContext*) p_vt->context;
    if(ByteArray != NULL && ArrayLength > 0)
    {
        tByteArray ByteArray_Address = ByteArray;
        if (REQ_OK == Status)
        {

            //Parameters to Parse the ByteArray Received
            struct FolderItem_Item_info *l_spcFolderData = NULL;
            struct MediaElement_Item_info *l_spcMediaElementData = NULL;

            unsigned char* ItemName = NULL;

            tNumOfItems retrievedItemIndex = StartItem;
            if (!context->UseEvolutionBtStack)
            {
                do
                {
                    tBrowseElement item;
                    item.type = (tBTItemType)*ByteArray;
                    ByteArray++;
                    ArrayLength--;

                    /*Before Parsing the ByteArray to collect Information of FolderItem or MediaItem,
                     * Ensure the data of Expected size available for FolderItem or MediaItem respectively
                     */
                    if(((item.type == MEDIA_ELEMENT) && (ArrayLength >= sizeof(struct MediaElement_Item_info))) ||
                            ((item.type == FOLDER) &&(ArrayLength >= sizeof(struct FolderItem_Item_info))))
                    {
                        //Retrieving the Item-type,length,UID,SubType,CharSetId into a structure.
                        if(MEDIA_ELEMENT == item.type)
                        {
                            l_spcMediaElementData = new struct MediaElement_Item_info ;
                            if(l_spcMediaElementData)
                            {
                                memcpy(l_spcMediaElementData,ByteArray,sizeof(struct MediaElement_Item_info));
                                if((l_spcMediaElementData->Item_Sub_Type == AUDIO_FILE) || (l_spcMediaElementData->Item_Sub_Type == VIDEO_FILE))
                                    item.type = (tBTItemType)l_spcMediaElementData->Item_Sub_Type;

                                ETG_TRACE_USR3(("l_spcMediaElementData UID :%d,%d,%d,%d,%d,%d,%d,%d",l_spcMediaElementData->Item_UID[0],l_spcMediaElementData->Item_UID[1],l_spcMediaElementData->Item_UID[2],l_spcMediaElementData->Item_UID[3],l_spcMediaElementData->Item_UID[4],l_spcMediaElementData->Item_UID[5],l_spcMediaElementData->Item_UID[6],l_spcMediaElementData->Item_UID[7]));
                            }

                            //As MEDIA_ELEMENT information parsing over,decrement the arrayLength
                            ArrayLength = ArrayLength - sizeof(struct MediaElement_Item_info);
                            ByteArray= ByteArray+ START_OF_MEDIAELEMENT_NAME;
                        }
                        else if(FOLDER == item.type)
                        {
                            //l_spcFolderData=(struct FolderItem_Item_info *)ByteArray;
                            l_spcFolderData = new struct FolderItem_Item_info;
                            if(l_spcFolderData)
                            {
                                memcpy(l_spcFolderData,ByteArray,sizeof(struct FolderItem_Item_info));

                                ETG_TRACE_USR3(("l_spcFolderData UID :%d,%d,%d,%d,%d,%d,%d,%d",l_spcFolderData->Item_UID[0],l_spcFolderData->Item_UID[1],l_spcFolderData->Item_UID[2],l_spcFolderData->Item_UID[3],l_spcFolderData->Item_UID[4],l_spcFolderData->Item_UID[5],l_spcFolderData->Item_UID[6],l_spcFolderData->Item_UID[7]));
                            }

                            //As FOLDER information parsing over,decrement the arrayLength
                            ArrayLength = ArrayLength - sizeof(struct FolderItem_Item_info);
                            ByteArray = ByteArray + START_OF_FOLDER_NAME;
                        }

                        if(NetworkOrder)
                        {
                            if((FOLDER == item.type) && (l_spcFolderData != NULL))
                            {
                                l_spcFolderData->Item_Length=ntohs(l_spcFolderData->Item_Length);
                                l_spcFolderData->Item_Name_Length=ntohs(l_spcFolderData->Item_Name_Length);
                            }
                            else if(( VIDEO_FILE == item.type || AUDIO_FILE == item.type) && (l_spcMediaElementData != NULL))
                            {
                                l_spcMediaElementData->Item_Length=ntohs(l_spcMediaElementData->Item_Length);
                                l_spcMediaElementData->Item_Name_Length=ntohs(l_spcMediaElementData->Item_Name_Length);
                            }
                        }

                        /*find and set item name*/
                        if(FOLDER == item.type)
                        {
                            if(l_spcFolderData != NULL)
                            {
                                ETG_TRACE_USR3(("l_spcFolderData Itemlength:%d , name_length:%d",l_spcFolderData->Item_Length,l_spcFolderData->Item_Name_Length));

                                //If ItemName Length and Array available to parse are Non-zero,then parse and prepare name.Else,let the name be Empty
                                if(l_spcFolderData->Item_Name_Length && ArrayLength)
                                {
                                    ItemName = new unsigned char[(l_spcFolderData->Item_Name_Length)+1];

                                    if(ItemName != NULL)
                                    {
                                        //Validate the byteArray available to find ItemName is atleast of size of  Item Name Length
                                        if(ArrayLength >= l_spcFolderData->Item_Name_Length)
                                        {
                                            memcpy(ItemName,ByteArray,l_spcFolderData->Item_Name_Length);
                                            ItemName[l_spcFolderData->Item_Name_Length]='\0';

                                            ArrayLength = ArrayLength - (l_spcFolderData->Item_Name_Length);
                                            ByteArray += l_spcFolderData->Item_Name_Length;
                                        }
                                        else //Prepare the ItemName with available ByteArray eventhough it is lesser size
                                        {
                                            memcpy(ItemName,ByteArray,ArrayLength);
                                            ItemName[ArrayLength]='\0';
                                            ArrayLength = 0 ;
                                        }
                                        item.name = string((const char*)ItemName);
                                        delete[] ItemName;
                                        ItemName = NULL;
                                    }
                                }
                                ETG_TRACE_USR3(("Folder Item name is %s",item.name.c_str()));
                                ETG_TRACE_USR3(("ArrayLength Now is %d",ArrayLength));
                            }
                        }
                        else if(VIDEO_FILE == item.type || AUDIO_FILE == item.type)
                        {
                            if(l_spcMediaElementData != NULL)
                            {
                                ETG_TRACE_USR3(("l_spcMediaElementData Itemlength:%d , name_length:%d",l_spcMediaElementData->Item_Length,l_spcMediaElementData->Item_Name_Length));

                                //If ItemName Length and Array available to parse are Non-zero,then parse and prepare name.Else,let the name be Empty
                                if(l_spcMediaElementData->Item_Name_Length && ArrayLength)
                                {
                                    ItemName = new unsigned char[(l_spcMediaElementData->Item_Name_Length)+1];

                                    if(ItemName!= NULL )
                                    {
                                        //Validate the byteArray available to find ItemName is atleast of size of  Item Name Length
                                        if(ArrayLength >= l_spcMediaElementData->Item_Name_Length)
                                        {
                                            memcpy(ItemName,ByteArray,l_spcMediaElementData->Item_Name_Length);
                                            ItemName[l_spcMediaElementData->Item_Name_Length]='\0';

                                            ArrayLength = ArrayLength-(l_spcMediaElementData->Item_Name_Length);
                                            ByteArray += l_spcMediaElementData->Item_Name_Length;

                                            //If MediaElement Present,then zero is sent additionally .So Parsing that byte.
                                            if(ArrayLength)
                                            {
                                                ArrayLength--;
                                                ByteArray++;
                                            }
                                        }
                                        else //Prepare the ItemName with available ByteArray eventhough it is lesser size
                                        {
                                            memcpy(ItemName,ByteArray,ArrayLength);
                                            ItemName[ArrayLength]='\0';
                                            ArrayLength = 0;
                                        }

                                        item.name = string((const char*)ItemName);
                                        delete[] ItemName;
                                        ItemName = NULL;
                                    }
                                    ETG_TRACE_USR3(("Media Item name is %s",item.name.c_str()));
                                    ETG_TRACE_USR3(("ArrayLength Now is %d",ArrayLength));
                                }
                            }
                        }

                        /*copy uid*/
                        if(FOLDER == item.type)
                        {
                            if(l_spcFolderData)
                            {
                                memcpy(item.uid,l_spcFolderData->Item_UID,sizeof(item.uid));
                                item.isPlayable = (tBoolean)l_spcFolderData->IsPlayable;

                                delete l_spcFolderData;
                                l_spcFolderData = NULL;
                            }
                        }
                        else if(VIDEO_FILE == item.type || AUDIO_FILE == item.type)
                        {
                            if(l_spcMediaElementData)
                            {
                                memcpy(item.uid,l_spcMediaElementData->Item_UID,sizeof(item.uid));
                                item.isPlayable = true;

                                delete l_spcMediaElementData;
                                l_spcMediaElementData = NULL;
                                
                            }
                        }

                        ETG_TRACE_USR3(("Prepared new item type:%d,name:%s",item.type,item.name.c_str()));
                        ETG_TRACE_USR3(("Prepared new item playable:%d",item.isPlayable));
                        ETG_TRACE_USR3(("Prepared new item uid: %d,%d,%d,%d,%d,%d,%d,%d",item.uid[0],item.uid[1],item.uid[2],item.uid[3],item.uid[4],item.uid[5],item.uid[6],item.uid[7]));

                        ElementsRetrieved[retrievedItemIndex] =item;
                        ItemRetrieved ++;
                        retrievedItemIndex++;
                    }
                    else
                    {
                        //Parsing the received data may lead to errors.Just Exit
                        break;
                    }
                }
                while (ArrayLength != 0);
            }
            else
            {

                int literalCount = 0;
                string divisionSlash;
                divisionSlash.append(1,char(226));
                divisionSlash.append(1,char(136));
                divisionSlash.append(1,char(149));
                char *ptr = (char*) strchr((char*) ByteArray,IPC_DBUS_PARAM_DELIMITER_INT);
                while (ptr != NULL) {
                    ptr = strchr((char*) ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
                    literalCount++;
                }
                ETG_TRACE_USR3(("iliteralCount :%d",literalCount));
                std::string strFromChar;
                strFromChar.append((char*) ByteArray);
                std::istringstream ss(strFromChar);
                std::string token[literalCount];
                for (int index = 0; index < literalCount; index++)
                {
                    std::getline(ss, token[index],IPC_DBUS_PARAM_DELIMITER_CHAR);
                }
                for (int index = 0; index < literalCount; )
                {
                    //Check the string is a Media Item object path.
                    //If so Create a new  tBrowseElement and fill all other filed by iterating through the available string array.
                    if ((token[index].find("/org/bluez/hci1/") != string::npos) && ((token[index].find("/Filesystem/item") != string::npos) || (token[index].find("/NowPlaying/item") != string::npos)) )
                    {

                        tBrowseElement item;
                        item.isPlayable = false;
                        item.objectPath = token[index];
                        ETG_TRACE_USR3(("item.objectPath :%s",item.objectPath.c_str()));
                        ETG_TRACE_USR3((" DoGetFolderItem index :%d",index));
                        int itemindex = index + 1;

                        //Iterate through the next items in the string array to find the neccessary informations.
                        for (itemindex; itemindex < literalCount;itemindex++)
                        {
                            //Check the string is Media Item object path.
                            //If so end parsing the substrings for the Browse element.It will be startinf of the new media object.
                            if ((token[itemindex].find("/org/bluez/hci1/") != string::npos) && ((token[itemindex].find("/Filesystem/item") != string::npos) || (token[itemindex].find("/NowPlaying/item") != string::npos)))
                            {
                                break;
                            }
                            else if (token[itemindex].compare("Type") == 0)
                            {
                                if((itemindex + 1) < literalCount)
                                {
                                    if (!strcmp(token[itemindex + 1].c_str(), "Folder"))
                                    {
                                        item.type = FOLDER;
                                        item.isPlayable = false;
                                        itemindex++;
                                    }
                                    else if (!strcmp(token[itemindex + 1].c_str(), "Audio"))
                                    {
                                        item.type = AUDIO_FILE;
                                        item.isPlayable = true;
                                        itemindex++;
                                    }
                                    else if (!strcmp(token[itemindex + 1].c_str(), "Video"))
                                    {
                                        item.type = VIDEO_FILE;
                                        item.isPlayable = false;
                                        itemindex++;
                                    }
                                    ETG_TRACE_USR3(("item.type :%d",item.type));
                                    ETG_TRACE_USR3(("item.isPlayable :%d",item.isPlayable));
                                }
                            }
                            else if (token[itemindex].compare("Name") == 0)
                            {
                                if((itemindex + 1) < literalCount)
                                {
                                    item.name.append(token[itemindex + 1].c_str());
                                    ETG_TRACE_USR3(("item.name before replace slash :%s",item.name.c_str()));
                                    if(string::npos != item.objectPath.find(item.player))
                                    {
                                    //Separate the name of the item with Number Of Slashes are
                                        int FirstPlayerIndex = static_cast<int>(item.objectPath.find_first_of(item.player));
                                    string newPath;
                                    //If Player not available in the object Path , leave the name as it is
                                    if(static_cast<int>(string::npos) != FirstPlayerIndex)
                                    {
                                        newPath.append(item.objectPath.substr((item.player.length())).c_str());
                                        int DelimitersInPath = FindNumberOfDelimiters(IN newPath.c_str(),IN '/');
                                        //Based on number of slashes in the object path(excluding the player name), separate the item name
                                        for(int i=1;i<=DelimitersInPath;i++)
                                        {
                                            int firstindex = 0;
                                            firstindex = item.name.find_first_of('/');
                                            item.name = item.name.substr(firstindex+1);
                                        }
                                        int found = item.name.find_first_of('/');
                                        //if '/' (U+002F) available in name, replace with division slash '/' (U+2215) for NCG3D-57448
                                        //if item name is playlist/new separate playlist , / and new
                                        //then append playlist+multi-byte division slash+new
                                            while (found != string::npos)
                                            { // While our position in the sting is in range.
                                                string name;
                                                if((item.name).length() > found+1)
                                                {
                                                    name = item.name.substr(found+1);
                                                }
                                                else
                                                {
                                                    name= "";
                                                }
                                                //Replace the single byte character '/' with the multi byte character '/'
                                                item.name = item.name.substr(0,found);
                                                item.name.append(divisionSlash);
                                                item.name.append(name);
                                                found = static_cast<int>(item.name.find_first_of('/'));
                                            }
                                        }
                                    }
                                    else //Modify the item name by removing the characters till last "/"
                                    {
                                        int lastIndex = static_cast<int>(item.name.find_last_of("/"));
                                        if(static_cast<int>(string::npos) != lastIndex)
                                        {
                                            item.name = item.name.substr(lastIndex + 1);
                                        }
                                    }
                                    ETG_TRACE_USR3(("item.name :%s",item.name.c_str()));
                                    itemindex++;
                                }
                            }
                            else if(token[itemindex].compare("Title") == 0)
                            {
                                if((itemindex + 1) < literalCount)
                                {
                                    if(item.name.empty())
                                    {
                                        item.name.append(token[itemindex + 1].c_str());
                                        int found = item.name.find_first_of('/');
                                        while (found != string::npos)
                                        { // While our position in the sting is in range.
                                            string name;
                                            if((item.name).length() > found+1)
                                            {
                                                name = item.name.substr(found+1);
                                            }
                                            else
                                            {
                                                name= "";
                                            }
                                            item.name = item.name.substr(0,found);
                                            //Replace the single byte character '/' with the multi byte character '/'
                                            item.name.append(divisionSlash);
                                            item.name.append(name);
                                            found = item.name.find_first_of('/');
                                        }


                                    }
                                    itemindex++;
                                    ETG_TRACE_USR3(("item.name :%s",item.name.c_str()));
                                }

                            }
                            else if(token[itemindex].compare("Player") == 0)
                            {
                                if((itemindex + 1) < literalCount)
                                {
                                    item.player.append(token[itemindex + 1].c_str());
                                    itemindex++;
                                    ETG_TRACE_USR3(("item.player :%s",item.player.c_str()));
                                }
                            }
                        }
                        index = itemindex;
                        ItemRetrieved++;
                        ElementsRetrieved[retrievedItemIndex]= item;
                        retrievedItemIndex++;
                    }
                    else
                    {
                        index++;
                    }
                }
                ret = BTGetLevelInfo(IN CursorPath,OUT TotNumOfItems,OUT ElementsInCache);
                //The TotNumOfItems is overwritten with the Items retrieved and the ElementsInCache , since the ItemRetrieved is less than the items requested.
                if(ItemRetrieved < ((EndItem-StartItem)+1))
                {
#if 0
                    // In NowPlaying Path arbitrary value 2000 is used. To find the total number of elements , this check is included.
                    TotNumOfItems =   ItemRetrieved + ElementsInCache;
                    BTUpdateBrowseLevelInfo(CursorPath,TotNumOfItems);
#endif
                }
            }

            ETG_TRACE_USR3(("ItemRetrieved in this batch read is :%d",ItemRetrieved));

            delete[] ByteArray_Address;
            ByteArray_Address = NULL;

            if(cursor->rrBTControl->ParamString)
            {
                delete[] cursor->rrBTControl->ParamString;
                cursor->rrBTControl->ParamString = NULL;
            }
            res = SQLITE_OK;


            //If any item retrieved,then push to Cache
            if(false == ElementsRetrieved.empty())
            {
                BTCacheWrite(IN CursorPath,IN ElementsRetrieved);
                ElementsRetrieved.clear();
				
				//add the per batch retrival count to total retrieval count
				TotalItemsRetrieved += ItemRetrieved;

                //Prepare cursor if found invalid.It is only possible on the first getfolderItem (label :RETRIEVE_FOLDER_ITEMS).
                if(cursor->ItemType == INVALID)
                {
                    ret = BTCacheRead(INOUT cursor);
                    if(ret)
                    {
                        ETG_TRACE_USR3(("BTCacheRead success"));
                    }
                    else
                    {
                        ETG_TRACE_USR3(("BTCacheRead failed"));
                    }

                }
                ret = BTGetLevelInfo(IN CursorPath,OUT TotNumOfItems,OUT ElementsInCache);
                if(TotNumOfItems)
                {
                    if(ItemRetrieved < ((EndItem-StartItem)+1))
                    {
                        StartItem = retrievedItemIndex;
                        ItemRetrieved = 0; //clear the earlier batch info
                        goto RETRIEVE_FOLDER_ITEMS;
                    }
                    else
                    {
                        ETG_TRACE_USR3(("Requested ItemIndex Range completely retrieved !"));
                    }
                }
            }
            else
            {
                //if elements retrieved empty do not try  goto RETRIEVE_FOLDER_ITEMS. It may lead to indefinite looping.
                //eg : For /Nowplaying  the getFolderItem success but byte count will come as 0.
				
				if(0 == TotalItemsRetrieved) //Error!:no item retrieved in First Batch itself.
				{
					res = SQLITE_ERROR;
				}
            }
        }
        else
        {
            if(cursor->rrBTControl->ParamString)
            {
                delete[] cursor->rrBTControl->ParamString;
                cursor->rrBTControl->ParamString = NULL;
            }

            delete[] ByteArray_Address;
            ByteArray_Address = NULL;


            cursor->limit = StartItem - cursor->offset;
            res = SQLITE_ERROR;
        }
    }
    else
    {
        ETG_TRACE_USR4(("ByteArray Info Received is Empty"));
        if(cursor->rrBTControl->ParamString)
        {
            delete[] cursor->rrBTControl->ParamString;
            cursor->rrBTControl->ParamString = NULL;
        }
        return SQLITE_ERROR;
    }
    return res;
}
int DoChangePath(tDirection Direction,tLevelCount LevelUpCount,
        tLevelCount LevelDownCount,tItemUIDArray ItemUIDArray,
        tVTBluetoothCursor *cursor,tBTMethodRequestStatus &Status,
        tNumOfItems &NumOfItems,tErrorMessage &ErrorMessage)
{
    ETG_TRACE_USR3(("Invoking ChangePath To reach the New Requested Path!"));

    char sendMessage[64];
    tAllParameters parameter;
    tSize size = sizeof(tBTMethodRequestStatus) + sizeof(tNumOfItems) + sizeof(tErrorMessage) + 10;
    char* timeoutAnsParameter = NULL ;
    timeoutAnsParameter = new char[size];
    int SqliteResult = SQLITE_OK;

    /* Send AVP_CHANGE_PATH message to BTControlSM */
    strncpy_r(sendMessage, "BTControlSM::AVP_CHANGE_PATH",sizeof(sendMessage));

    /* generate the parameters for the request */
    cursor->rrBTControl->Marshal(parameter, sizeof(parameter) - 1,
            "iiip",Direction,LevelUpCount,
            LevelDownCount,ItemUIDArray);

    if(timeoutAnsParameter)
    {
        cursor->rrBTControl->Marshal(OUT timeoutAnsParameter,IN size,"iip",IN REQ_ACTION_TIMEOUT ,IN 0,IN NULL);
    }
    /* do the request and wait for the answer */
    SqliteResult = cursor->rrBTControl->DoEventAnswer(sendMessage, parameter, NULL, BT_CTRL_SM_ANSWER_TIMEOUT_MS,timeoutAnsParameter);

    if (cursor->rrBTControl->ParamString != NULL) {
        cursor->rrBTControl->UnMarshal(cursor->rrBTControl->ParamString, tBTMethodRequestStatus_format tNumOfItems_format tErrorMessage_format  ,&Status ,&NumOfItems ,&ErrorMessage );

        ETG_TRACE_USR3(("MethodRequestStatus is %d",Status));
        ETG_TRACE_USR3(("NumOfItems is %d",NumOfItems));
        ETG_TRACE_USR3(("ErrorMessage is %s",ErrorMessage));
        if(cursor->rrBTControl->ParamString)
        {
            delete[] cursor->rrBTControl->ParamString;
            cursor->rrBTControl->ParamString = NULL;
        }
    }
    else
    {
        ETG_TRACE_USR3(("ParamString is NULL"));

        SqliteResult = SQLITE_ERROR;

    }
    if(timeoutAnsParameter) 
    {
        delete[] timeoutAnsParameter;
    }
    return SqliteResult;
}
unsigned int FindNumberOfDelimiters(const char* param , char deLimiter)
{
    unsigned int literalCount = 0;
    char *ptr = (char*) strchr(param,deLimiter);
    while (ptr != NULL)
    {
        ptr = strchr((char*) ptr + 1,deLimiter);
        literalCount++;
    }
    return  literalCount;
}

tResult ChangeBrowsePath(tVTBluetoothCursor *cursor,string reqPath)
{
    tResult res  = SQLITE_ERROR;
    tDirection Direction = LEVEL_CHANGE_INVALID;
    tLevelCount LevelUpCount = 0;
    tLevelCount LevelDownCount = 0;
    tBTMethodRequestStatus Status = REQ_NOT_OK;
    tNumOfItems NumOfItems = 0;
    tErrorMessage ErrorMessage = NULL;
    tItemUIDArray ItemUIDArray = NULL;
    ItemUIDArray = (tItemUIDArray)const_cast<char*>(reqPath.c_str());
    res = DoChangePath(IN Direction,IN LevelUpCount,IN LevelDownCount,IN ItemUIDArray,INOUT cursor,
            OUT Status,OUT NumOfItems,OUT ErrorMessage);
    if(SQLITE_OK == res)
    {
        if(REQ_NOT_OK == Status )
        {
            if(ErrorMessage != NULL)
            {
                ETG_TRACE_USR3(("ErrorMessage is %s",ErrorMessage));
                delete[] ErrorMessage;
            }
            else
            {
                //do nothing
            }
            ETG_TRACE_USR3(("ChangePath Failed.So Returning!"));

            //Issue Fix:ChangePath failed for "/NowPlaying" + SQLITE_OK == res caused List with size = 0 as current List in PlayerManager.
            res  = SQLITE_ERROR;
        }
        else if(REQ_ACTION_TIMEOUT == Status)
        {
            ETG_TRACE_USR3(("DoChangePath Failed due to ANSWR_TIMEOUT.So Returning!!"));

            res  = SQLITE_ERROR;
        }
        else
        {
            ETG_TRACE_USR3(("DoChangePath was successful!"));
            ETG_TRACE_USR3(("NumOfItems is %d",NumOfItems));
            BTStoreBrowseLevelInfo(IN reqPath,IN NumOfItems);
            res = SQLITE_OK;
        }
    }
    else
    {
        ETG_TRACE_USR3(("DoChangePath Failed!"));
    }
    return res;
}

void SetupDummyCursor(tVTBluetoothCursor *cursor)
{
	ENTRY_INTERNAL
	
	if(cursor)
	{
		//prepare a cursor to represent the now playing
		//cursor->endOfDataset = 0x01;
		//cursor->RequestedRowCount = 1;	

		//Note:mountpoint,path,listType of the Cursor are setup - setup done in xFilter.
		
		cursor->count = 1;
		cursor->ItemName = strdup(" ");
		cursor->ItemUID = new char[UID_STRING_SIZE];
		int i;
		for(i=0;i<16;i++)
		{
			cursor->ItemUID[i] = '0';
		}
		cursor->ItemUID[16] = '\0';
		
		cursor->ItemType = AUDIO_FILE;
		cursor->FileFormat = FFT_MP3;
	}
}

void SetupInvalidCursor(tVTBluetoothCursor *cursor)
{
	ENTRY_INTERNAL
	
	if(cursor)
	{
		//clean cursor param: count,itemname,uid,type
		
		//Note:mountpoint,path,listType of the Cursor are not cleared - will be cleaned up upon xClose.
		//As they are common for all cursor read,they are not freed upon whenever cursor advanced to next row.
		
		cursor->count = 0;
	
		if(cursor->ItemName != NULL)
		{
			free(cursor->ItemName);
			cursor->ItemName = NULL;
		}
		
		if(cursor->ItemUID != NULL)
		{
			delete[] cursor->ItemUID;
			cursor->ItemUID = NULL;
		}
		
		cursor->ItemType = INVALID;
		cursor->FileFormat = FFT_UNKNOWN;				
	}
}
