/*
 * BTCache.cpp
 *
 *  Created on: Dec 10, 2013
 *      Author: pee1cob
 */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_VT_BTLUETOOTH
#ifdef TARGET_BUILD
#include "trcGenProj/Header/BTCache.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_VT_BTLUETOOTH
#endif
#endif

#include "BTCache.h"
#include "FunctionTracer.h"
//#include "VarTrace.h"
#include "MediaPlayer_ErrorCodes.h"
#include "TimeTrace.h"
#include "Dispatcher.h"
#include "BTControlSM.h"

typedef struct
{
    tNumOfItems elementsInCache;
    tNumOfItems totalElements;
}tBrowseLevelInfo;


typedef struct _BTCache
{
    map<string , tBrowseLevelInfo> mBrowseLevelInfo;
    map<string , map<unsigned int,tBrowseElement>> mBrowseElements;
    vector<string> knownPaths;
}BTCache;

static BTCache BTSelf;

Lock m_CacheMutex;

int IsBTNewFolderVisit(const char *path,bool &isNewFolder)
{
    ENTRY_INTERNAL
    vector<string>::iterator iter;
    string ReqPath = string(path);
	
	ETG_TRACE_USR3(("ReqPath is %s",ReqPath.c_str()));
	if(BTSelf.knownPaths.size())
	{
		for(iter=BTSelf.knownPaths.begin();iter!= BTSelf.knownPaths.end();iter++)
		{
			ETG_TRACE_USR3(("*iter is %s",(*iter).c_str()));
			if(*iter == ReqPath)
			{
				ETG_TRACE_USR3(("Folder Revisit"));
                isNewFolder =  false;
                return SQLITE_OK;
			}
			else
			{
			   //Check with next element in the vector
			}
		}
        // Not found in the BTSelf.knownPaths
        isNewFolder = true;
	}
	else
	{
	    if((PATH_DELIMITER == ReqPath) || (NOW_PLAYING_PATH == ReqPath))
        {
            isNewFolder = true;
        }
        else
        {
            ETG_TRACE_USR3(("BTSelf.knownPaths is empty but ReqPath is other than ROOT"));
            return SQLITE_ERROR;           
	}
    }
    return SQLITE_OK;
}
void BTCacheWrite(string CursorPath,map<unsigned int,tBrowseElement> &ElementsRetrieved)
{
    ENTRY_INTERNAL
    Locker locker(&m_CacheMutex);
    map<string,map<unsigned int,tBrowseElement> >::iterator it;
    it = BTSelf.mBrowseElements.find(CursorPath);
    if(it == BTSelf.mBrowseElements.end())
    {
        ETG_TRACE_USR3(("It is the First time CacheWrite for the path %s",CursorPath.c_str()));

        BTSelf.mBrowseElements[CursorPath] = ElementsRetrieved;
    }
    else
    {
        ETG_TRACE_USR3(("Appending to the Cache of the path %s",CursorPath.c_str()));
        BTSelf.mBrowseElements[CursorPath].insert(ElementsRetrieved.begin(),ElementsRetrieved.end());
    }

    BTSelf.mBrowseLevelInfo[CursorPath].elementsInCache = BTSelf.mBrowseElements[CursorPath].size();
    ETG_TRACE_USR3(("Size of the Cache is %d",BTSelf.mBrowseElements[CursorPath].size()));
    if(CursorPath == "/NowPlaying")
    {
        BTUpdateBrowseLevelInfo(CursorPath,BTSelf.mBrowseElements[CursorPath].size());
    }
}

bool BTCacheRead(tVTBluetoothCursor *cursor)
{
    ENTRY_INTERNAL
	Locker locker(&m_CacheMutex);
    bool res = false;
    map<string,map<unsigned int,tBrowseElement> >::iterator it;
    map<unsigned int,tBrowseElement>::iterator iter;

    string CursorPath = string((const char*)cursor->Path);
    ETG_TRACE_USR3(("cursor->RequestedRowCount is %d",cursor->RequestedRowCount));
    //ETG_TRACE_USR3(("cursor->AvailableRowCount is %d",cursor->AvailableRowCount)); //TODO(Reenu):When this available row count is updated ?

    //if(cursor->RequestedRowCount <= cursor->AvailableRowCount)
  //  {
    	it = BTSelf.mBrowseElements.find(CursorPath);
    	if(it == BTSelf.mBrowseElements.end())
    	{
    		ETG_TRACE_USR3(("Info of Req Path Not fond in BTSelf.mBrowseElements Map!"));
			cursor->ItemType = INVALID;
    		return res;
    	}
    	else
    	{
    		iter = it->second.find(cursor->RequestedRowCount-1);

    		//Requested Index item not found in map
    		if(iter == BTSelf.mBrowseElements[CursorPath].end())
    		{
    			ETG_TRACE_USR3(("Item with index:%d Not fond in BTSelf.mBrowseElements Map!",cursor->RequestedRowCount));
				cursor->ItemType = INVALID;
    		}
    		else
    		{
    			tBrowseElement BrowseElement = iter->second;

    			cursor->ItemName = strdup(BrowseElement.name.c_str());
    			cursor->ItemType = BrowseElement.type;
    			tVTBluetooth *p_vt = (tVTBluetooth*) ((sqlite3_vtab_cursor*) cursor)->pVtab;
    			tVTBluetoothContext *context = (tVTBluetoothContext*) p_vt->context;
    			if (!context->UseEvolutionBtStack)
    			{
    				cursor->ItemUID = new char[UID_STRING_SIZE];
    				snprintf(cursor->ItemUID,UID_STRING_SIZE,"%02x%02x%02x%02x%02x%02x%02x%02x",BrowseElement.uid[0],
    						BrowseElement.uid[1],
							BrowseElement.uid[2],
							BrowseElement.uid[3],
							BrowseElement.uid[4],
							BrowseElement.uid[5],
							BrowseElement.uid[6],
							BrowseElement.uid[7]);
    			}
    			else
    			{
    				cursor->ItemUID = strdup(BrowseElement.objectPath.c_str());
    			}

    			ETG_TRACE_USR3(("cursor->ItemType is %d,cursor->ItemName is %s",cursor->ItemType,cursor->ItemName));
    			ETG_TRACE_USR3(("cursor->ItemUID is %s",cursor->ItemUID));
    			/* increase the row id */
    			
				//cursor->objectCount_rowID++; (21/1):Commented.Done in xNext(..) 
    			res =true;
    			return res;
    		}
    	}
  //  }
  //  else
   // {
   // 	ETG_TRACE_USR3(("cursor->RequestedRowCount > cursor->AvailableRowCount.Returning Error"));
   // 	return res;
  //  }

    return res;
}
void BTStoreBrowseLevelInfo(string path,tNumOfItems NumOfItems)
{
    ENTRY_INTERNAL
	Locker locker(&m_CacheMutex);
    BTSelf.mBrowseLevelInfo[path].totalElements = NumOfItems;
    BTSelf.mBrowseLevelInfo[path].elementsInCache = 0;
    ETG_TRACE_USR3(("BTSelf.mBrowseLevelInfo : %d",BTSelf.mBrowseLevelInfo[path].totalElements));
}
void BTUpdateBrowseLevelInfo(string path,tNumOfItems NumOfItems)
{
    ENTRY_INTERNAL
	Locker locker(&m_CacheMutex);
    BTSelf.mBrowseLevelInfo[path].totalElements = NumOfItems;
    ETG_TRACE_USR3(("BTSelf.mBrowseLevelInfo : %d",BTSelf.mBrowseLevelInfo[path].totalElements));
}
bool BTGetLevelInfo(string path,tNumOfItems &TotNumOfItems,tNumOfItems &ElementsInCache)
{
    ENTRY_INTERNAL
	Locker locker(&m_CacheMutex);
    bool ret = false;

    map<string,tBrowseLevelInfo>::iterator it;
    it=BTSelf.mBrowseLevelInfo.find(path);

    if(BTSelf.mBrowseLevelInfo.end() != it)
    {
        TotNumOfItems = BTSelf.mBrowseLevelInfo[path].totalElements;
        ElementsInCache = BTSelf.mBrowseLevelInfo[path].elementsInCache;
        ret  = true;
    }
    else
    {
        ETG_TRACE_USR3(("LevelInfo Unavailable"));
    }

    return ret;
}
void BTStorePath(string path)
{
    ENTRY_INTERNAL
	Locker locker(&m_CacheMutex);
    BTSelf.knownPaths.push_back(path);
}
#if 0
tNumOfItems BTGetCacheSize(string CursorPath)
{
    ETG_TRACE_USR3(("Inside:BTGetCacheSize"));

    ETG_TRACE_USR3(("Leaving:BTGetCacheSize"));
    return 0;
}
#endif
tBoolean BTGetFolderUID(unsigned char *ReqPath,unsigned int f_ilevelDownCount,tItemUIDArray ItemUIDArray)
{
    ENTRY_INTERNAL

    ETG_TRACE_USR3(("ReqPath is %s",ReqPath));
    ETG_TRACE_USR3(("f_ilevelDownCount is %d",f_ilevelDownCount));

	tItemUIDArray ItemUIDArray_End_Addr = ItemUIDArray + (f_ilevelDownCount*SIZE_OF_ITEM_UID) -1;
    //memset(ItemUIDArray,0,(f_ilevelDownCount*SIZE_OF_ITEM_UID));
    memset(ItemUIDArray,0,(f_ilevelDownCount*sizeof(tItemUIDArray))); // thoemel: valgrind
    string f_cPath =string((const char*)ReqPath);
    unsigned int foundString;
    string l_cParentFolderPath = "";
    string l_cCurrentFolderName = "";
    string l_cName_Uid_Type = "";
    string l_cName_Uid = "";
    string l_cUid ="";
    unsigned int l_uiCount;

    for(l_uiCount=0;l_uiCount<f_ilevelDownCount;l_uiCount++)
    {
        //Find FolderNames
        foundString = f_cPath.find_last_of("/\\");
        l_cCurrentFolderName = f_cPath.substr(foundString+1);
        l_cParentFolderPath  = f_cPath.substr(0,foundString);

        //Path is Modified to ease the Next Level down UID retrieval
        if(!l_cParentFolderPath.size())
        {
            ETG_TRACE_USR3(("Its Parent Directory is Found to be ROOT directory.Updating Dir Path"));
            l_cParentFolderPath = "/";
        }
        f_cPath = l_cParentFolderPath;

        ETG_TRACE_USR3(("l_cCurrentFolderName is %s",l_cCurrentFolderName.c_str()));
        ETG_TRACE_USR3(("l_cParentFolderPath is %s",l_cParentFolderPath.c_str()));

        map<string,map<unsigned int,tBrowseElement> >::iterator it;
        it = BTSelf.mBrowseElements.find(l_cParentFolderPath);
        if(it == BTSelf.mBrowseElements.end())
        {
            ETG_TRACE_USR3(("Folder Not Found in Map."));
            // thoemel: replaced with following line because of valgrind finding delete[] ItemUIDArray;
            free(ItemUIDArray);
            ItemUIDArray = NULL;
            return false;
        }
        ETG_TRACE_USR3(("Going to read the string Corresponding to the l_cCurrentFolderName from List maintained in l_cParentFolderPath vector"));
        ETG_TRACE_USR3(("BTSelf.mBrowseElements[l_cParentFolderPath].size()is %d",BTSelf.mBrowseElements[l_cParentFolderPath].size()));

		map<unsigned int,tBrowseElement>::iterator iter;
		
        //Search for the Item in the browse element vector of the l_cCurrentFolderName
        bool found = false;;
        for(iter = BTSelf.mBrowseElements[l_cParentFolderPath].begin(); iter !=BTSelf.mBrowseElements[l_cParentFolderPath].end(); iter++)
        {
            string EntryName = iter->second.name;
			ETG_TRACE_USR3(("EntryName is %s",EntryName.c_str()));
            if(EntryName.find(l_cCurrentFolderName) != std::string::npos)
            {
				ETG_TRACE_USR3(("Item found in the vector"));
				ETG_TRACE_USR3(("iter->uid is %d:%d:%d:%d:%d:%d:%d:%d",iter->second.uid[0],iter->second.uid[1],iter->second.uid[2],iter->second.uid[3],iter->second.uid[4],iter->second.uid[5],iter->second.uid[6],iter->second.uid[7]));
                //memcpy(ItemUIDArray,iter->uid,sizeof(iter->uid));
				memcpy(ItemUIDArray_End_Addr-(SIZE_OF_ITEM_UID-1),iter->second.uid,sizeof(iter->second.uid));
                found = true;
                //ItemUIDArray += sizeof(iter->uid);
				ItemUIDArray_End_Addr -= SIZE_OF_ITEM_UID;
                break;
            }
        }
        if(!found)
        {
            ETG_TRACE_USR3(("Error in reading from the List"));
            free(ItemUIDArray);
            ItemUIDArray = NULL;
            return false;
        }
    }
    return true;
}
bool BTCacheDelete(const char *path)
{
    ENTRY_INTERNAL
    (void)path;
    Locker locker(&m_CacheMutex);
    BTSelf.knownPaths.clear();
    BTSelf.mBrowseElements.clear();
    BTSelf.mBrowseLevelInfo.clear();

    return true;
}

bool BTGetMediaItemUID(string Path,tItemUID ItemUID)
{
    ENTRY_INTERNAL

    unsigned int foundString = 0;
    string MediaItemName = "";
    string l_cParentFolderPath = "";

    //Find FolderNames
    foundString = Path.find_last_of("/\\");
    MediaItemName = Path.substr(foundString+1);
    l_cParentFolderPath  = Path.substr(0,foundString);

    map<unsigned int,tBrowseElement>::iterator iter;
    //Search for the Item in the browse element vector of the l_cCurrentFolderName
    bool found = false;

    for(iter = BTSelf.mBrowseElements[l_cParentFolderPath].begin(); iter !=BTSelf.mBrowseElements[l_cParentFolderPath].end(); iter++)
    {
        string EntryName = iter->second.name;
        ETG_TRACE_USR3(("EntryName is %s",EntryName.c_str()));
        if(EntryName.find(MediaItemName) != std::string::npos)
        {
            ETG_TRACE_USR3(("Item found in the vector"));
            ETG_TRACE_USR3(("iter->uid is %d:%d:%d:%d:%d:%d:%d:%d",iter->second.uid[0],iter->second.uid[1],iter->second.uid[2],iter->second.uid[3],iter->second.uid[4],iter->second.uid[5],iter->second.uid[6],iter->second.uid[7]));
            memcpy(ItemUID,iter->second.uid,sizeof(iter->second.uid));
            found = true;
            break;
        }
    }
    if(!found)
    {
        ETG_TRACE_USR3(("Error in reading from the List"));
    }
    else
    {
        ETG_TRACE_USR3(("MediaItemUID found in List"));
    }

    return found;
}
tBoolean IsSelectedItemPlayable(string selectedItemParentPath,string selectedItemName)
{
    ENTRY_INTERNAL

    map<unsigned int,tBrowseElement>::iterator iter;
    for(iter = BTSelf.mBrowseElements[selectedItemParentPath].begin(); iter !=BTSelf.mBrowseElements[selectedItemParentPath].end(); iter++)
    {
        //TODO:Multiple Items in the Same name in a ParentFolder
        string EntryName = iter->second.name;
        if(EntryName == selectedItemName)
        {
            ETG_TRACE_USR3(("Selected Item to Play is found in the vector"));
            return iter->second.isPlayable;
        }
    }
    ETG_TRACE_USR3(("Selected Item to Play not found in the vector"));
    return false;
}
bool BTGetPosItemInFolder(const string item ,int &item_pos)
{
    ENTRY
    ETG_TRACE_USR3(("BTGetItemObjectPath item:%s:",item.c_str()));
    int index=item.find_last_of("/");
    string path;
    if(index==0)
    {
        path.append("/");
    }else
    {
        path=item.substr(0,index);
    }
    ETG_TRACE_USR3(("BTGetItemObjectPath path:%s",path.c_str()));
    string itemName=item.substr(index+1);
    ETG_TRACE_USR3(("BTGetItemObjectPath itemName:%s",itemName.c_str()));
    map<string,map<unsigned int,tBrowseElement> >::iterator it;
    it = BTSelf.mBrowseElements.find(path);
    map<unsigned int,tBrowseElement>::iterator iter;
    for(iter = BTSelf.mBrowseElements[path].begin(); iter !=BTSelf.mBrowseElements[path].end(); iter++)
    {
        if( iter->second.name == itemName)
        {
            item_pos=iter->first;
            ETG_TRACE_USR3(("item found in the map %d:",item_pos));
            return true;
        }
    }
    return false;
}
bool BTGetItemObjectPath(const string item ,string &objectPath)
{
    ENTRY
    ETG_TRACE_USR3(("BTGetItemObjectPath item:%s:",item.c_str()));
    int index=item.find_last_of("/");
    string path;
    if(index==0)
    {
        path.append("/");
    }else
    {
        path=item.substr(0,index);
    }
    ETG_TRACE_USR3(("BTGetItemObjectPath path:%s:",path.c_str()));
    string itemName=item.substr(index+1);
    ETG_TRACE_USR3(("BTGetItemObjectPath itemName:%s:",itemName.c_str()));
    map<string,map<unsigned int,tBrowseElement> >::iterator it;
    it = BTSelf.mBrowseElements.find(path);
    map<unsigned int,tBrowseElement>::iterator iter;
   for(iter = BTSelf.mBrowseElements[path].begin(); iter !=BTSelf.mBrowseElements[path].end(); iter++)
   {
       if( iter->second.name == itemName)
       {
           objectPath=iter->second.objectPath;
           ETG_TRACE_USR3(("item found in the map %s:",objectPath.c_str()));
           return true;
       }
   }
   return false;
}
void BTCacheEraseNowplaying()
{
    ENTRY
	Locker locker(&m_CacheMutex);
    string CursorPath;
    CursorPath = "/NowPlaying";
    for(unsigned int i=0;i<BTSelf.knownPaths.size();i++)
    {
        if(BTSelf.knownPaths[i] == CursorPath)
        {
            map<string,map<unsigned int,tBrowseElement> >::iterator it;
            it = BTSelf.mBrowseElements.find(CursorPath);
            if(it != BTSelf.mBrowseElements.end())
            {
                BTSelf.mBrowseElements.erase(it);
				ETG_TRACE_USR3(("NowPlaying path is cleared "));
            }
            map<string,tBrowseLevelInfo >::iterator it1;
            it1 = BTSelf.mBrowseLevelInfo.find(CursorPath);
            if(it1 != BTSelf.mBrowseLevelInfo.end())
            {
                BTSelf.mBrowseLevelInfo.erase(it1);
				ETG_TRACE_USR3(("NowPlaying path mBrowseLevelInfo is cleared "));
            }
            BTSelf.knownPaths.erase(BTSelf.knownPaths.begin()+i);
            ETG_TRACE_USR3(("NowPlaying path cleared as NowPlaying content has changed"));
            break;
        }
    }
}

void BTCachCheckAndUpdate(string CursorPath,map<unsigned int,tBrowseElement> &ElementsRetrieved,tBoolean& contentUpdated,tBoolean& itemsErased)
{
    ENTRY
    contentUpdated = false;
    itemsErased = false;
    Locker locker(&m_CacheMutex);
    map<string,map<unsigned int,tBrowseElement> >::iterator it;
    it = BTSelf.mBrowseElements.find(CursorPath);
    if(it == BTSelf.mBrowseElements.end())
    {
        ETG_TRACE_USR3(("It is the First time CacheWrite for the path %s",CursorPath.c_str()));
        BTSelf.mBrowseElements[CursorPath] = ElementsRetrieved;
        contentUpdated = true;
    }
    else
    {
        ETG_TRACE_USR3(("Checking and Updating to the Cache in the path %s",CursorPath.c_str()));
        //BTSelf.mBrowseElements[CursorPath].insert(ElementsRetrieved.begin(),ElementsRetrieved.end());
        map<unsigned int,tBrowseElement>::iterator elemIter,caheIter;
        for(elemIter = ElementsRetrieved.begin(); elemIter != ElementsRetrieved.end(); elemIter++)
        {
            caheIter = BTSelf.mBrowseElements[CursorPath].find(elemIter->first);
            if((caheIter != BTSelf.mBrowseElements[CursorPath].end()) && (comparetBrowseElements(elemIter->second,caheIter->second)))
            {
                continue;
            }
            else
            {
                //There is a mismath in cache entry. So clear all the remaining items in hte cache
                if(caheIter != BTSelf.mBrowseElements[CursorPath].end())
                {
                    BTSelf.mBrowseElements[CursorPath].erase(caheIter,BTSelf.mBrowseElements[CursorPath].end());
                    itemsErased = true;
                }
                BTSelf.mBrowseElements[CursorPath].insert(*elemIter);
                contentUpdated = true;
            }
        }
    }
    BTSelf.mBrowseLevelInfo[CursorPath].elementsInCache =static_cast<tNumOfItems>(BTSelf.mBrowseElements[CursorPath].size());
    ETG_TRACE_USR3(("Size of the Cache is %d",BTSelf.mBrowseElements[CursorPath].size()));
    if(CursorPath == "/NowPlaying")
    {
        BTUpdateBrowseLevelInfo(CursorPath,static_cast<tNumOfItems>(BTSelf.mBrowseElements[CursorPath].size()));
    }
}

bool comparetBrowseElements(tBrowseElement element1,tBrowseElement element2)
{
    bool result = false;
#if 0
    ETG_TRACE_USR3(("Element1, Name:%s",element1.name.c_str()));
    ETG_TRACE_USR3(("Element1, objectPath:%s",element1.objectPath.c_str()));
    ETG_TRACE_USR3(("Element1, isPlayable:%d uid:%s ",element1.isPlayable,element1.uid));
    ETG_TRACE_USR3(("Element1, type:%d",element1.type));
    ETG_TRACE_USR3(("Element2, Name:%s",element2.name.c_str()));
    ETG_TRACE_USR3(("Element2, objectPath:%s",element2.objectPath.c_str()));
    ETG_TRACE_USR3(("Element2, isPlayable:%d uid:%s ",element2.isPlayable,element2.uid));
    ETG_TRACE_USR3(("Element2, type:%d",element2.type));
#endif
    if((element1.name.compare(element2.name) == 0)
            && (element1.objectPath.compare(element2.objectPath) == 0)
            &&(element1.isPlayable == element2.isPlayable)
            &&(element1.type == element2.type))
    {
        result = true;
    }
    if(result)
    {
        ETG_TRACE_USR3(("Elements are same"));
    }
    else
    {
        ETG_TRACE_USR3(("Elements are different"));
    }
    return result;
}

bool BTCacheDeleteOtherThanNowPlaying()
{
    ENTRY_INTERNAL

    Locker locker(&m_CacheMutex);
    std::string nowPlaying = "/NowPlaying";
    std::vector<std::string>::iterator pathIter = BTSelf.knownPaths.begin();
    while (pathIter != BTSelf.knownPaths.end())
    {
        if(nowPlaying.compare(*pathIter))
        {
            pathIter = BTSelf.knownPaths.erase(pathIter);
        }
        else
        {
            ++pathIter;
        }
    }

    std::map<std::string , std::map<unsigned int,tBrowseElement>>::iterator elemIter = BTSelf.mBrowseElements.find(nowPlaying);
    bool nowPlayingFoundInBrowseElements = false;
    std::map<unsigned int,tBrowseElement> nowPlayingItems;
    if(elemIter != BTSelf.mBrowseElements.end())
    {
        nowPlayingFoundInBrowseElements = true;
        nowPlayingItems = elemIter->second;
    }
    BTSelf.mBrowseElements.clear();

    if(nowPlayingFoundInBrowseElements)
    {
        BTSelf.mBrowseElements.insert(std::pair<std::string , std::map<unsigned int,tBrowseElement>>(nowPlaying,nowPlayingItems));
    }

    std::map<string , tBrowseLevelInfo>::iterator infoIter = BTSelf.mBrowseLevelInfo.find(nowPlaying);

    bool nowPlayingFoundInBrowseLevelInfo = false;
    tBrowseLevelInfo nowPlayingBrowseLevelInfo;

    if(infoIter != BTSelf.mBrowseLevelInfo.end())
    {
        nowPlayingFoundInBrowseLevelInfo = true;
        nowPlayingBrowseLevelInfo = infoIter->second;
    }

    BTSelf.mBrowseLevelInfo.clear();
    if(nowPlayingFoundInBrowseLevelInfo)
    {
        BTSelf.mBrowseLevelInfo.insert(std::pair<std::string , tBrowseLevelInfo>(nowPlaying,nowPlayingBrowseLevelInfo));
    }

    return true;
}

bool isItemAvailableAtGivenIndex(const tIndex &Index ,const string &path)
{
    bool res = false;
    map<string , map<tNumOfItems,tBrowseElement>>::iterator iter1;
    map<tNumOfItems,tBrowseElement>::iterator iter2;
    iter1 = BTSelf.mBrowseElements.find(path);
    if(iter1 == BTSelf.mBrowseElements.end())
    {
        ETG_TRACE_USR3(("For Requested path,no element available in BTSelf.mBrowseElements Map!"));
    }
    else
    {
        iter2 =iter1->second.find(Index);
        if(iter2 == iter1->second.end())
        {
            ETG_TRACE_USR3(("The requested index element not available in BTSelf.mBrowseElements Map!"));
        }
        else
        {
            res = true;
        }
    }
    return res;
}
