"DROP TABLE IF EXISTS [MAIN].[SchemaVersion];"
"DROP TABLE IF EXISTS [MAIN].[System];"
"DROP TABLE IF EXISTS [MAIN].[DVDStorage];"
""
"DROP TABLE IF EXISTS [MAIN].[MediaObjects];"
""
"DROP TABLE IF EXISTS [MAIN].[Genres];"
"DROP TABLE IF EXISTS [MAIN].[Artists];"
"DROP TABLE IF EXISTS [MAIN].[Albums];"
"DROP TABLE IF EXISTS [MAIN].[Composers];"
"DROP TABLE IF EXISTS [MAIN].[Videos];"
"DROP TABLE IF EXISTS [MAIN].[Podcasts];"
"DROP TABLE IF EXISTS [MAIN].[Audiobooks];"
"DROP TABLE IF EXISTS [MAIN].[Authors];"
"DROP TABLE IF EXISTS [MAIN].[Playlists];"
"DROP TABLE IF EXISTS [MAIN].[Years];"
""
"DROP TABLE IF EXISTS [MAIN].[Favorites];"
"DROP TABLE IF EXISTS [MAIN].[Users];"
"DROP TABLE IF EXISTS [MAIN].[ScanContext];"
"DROP TABLE IF EXISTS [MAIN].[LastMode];"
""
"DROP TABLE IF EXISTS [MAIN].[Objects];"
""
"DROP TABLE IF EXISTS [MAIN].[Devices];"
"DROP TABLE IF EXISTS [MAIN].[VirtualDevices];"
"DROP TABLE IF EXISTS [MAIN].[LiveTags];"
"DROP TABLE IF EXISTS [MAIN].[VideoProperty];"
"DROP TABLE IF EXISTS [MAIN].[DVDVideoProperty];"
"DROP TABLE IF EXISTS [MAIN].[MTPVideoProperty];"
"DROP TABLE IF EXISTS [MAIN].[YomiMetadata];"
"DROP TABLE IF EXISTS [MAIN].[MusicBoxToC];"
"DROP TABLE IF EXISTS [MAIN].[RouteGuidanceDisplayComponents];"

""
"CREATE TABLE IF NOT EXISTS [MAIN].[SchemaVersion]"
"("
"  [Version]                             INTEGER PRIMARY KEY NOT NULL,"
"  [Integrity]                           BOOLEAN NOT NULL"
");"
""
"INSERT OR REPLACE INTO [MAIN].[SchemaVersion]"
"("
"  [Version],"
"  [Integrity]"
")"
"VALUES"
"("
"  24 ," //If the schema version is changed here, make sure to update it in Database.h also
"  1"
");"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[System]"
"("
"  [BTMacAddress]                        TEXT UNIQUE NOT NULL"
");"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[DVDStorage]"
"("
"  [ID]                              INTEGER UNIQUE PRIMARY KEY NOT NULL,"
"  [DVDInfo]                         BLOB"
");"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[Devices]"
"("
"  [ID]                                  INTEGER UNIQUE PRIMARY KEY NOT NULL,"
"  [UUID]                                TEXT,"
"  [SerialNumber]                        TEXT UNIQUE NOT NULL,"
"  [FirmwareVersion]                     TEXT,"
"  [FriendlyName]                        TEXT,"
"  [MountPoint]                          TEXT,"
"  [ConnectionCount]                     INTEGER NOT NULL DEFAULT 0,"
"  [LastConnected]                       TEXT NOT NULL DEFAULT CURRENT_TIMESTAMP,"
"  [CheckSum]                            TEXT NOT NULL DEFAULT '" FINGERPRINT_INVALID"',"
"  [Active]                              BOOLEAN NOT NULL DEFAULT 0,"
"  [RepeatMode]                          INTEGER NOT NULL DEFAULT 0,"
"  [VideoRepeatMode]                     INTEGER NOT NULL DEFAULT 0,"
"  [PlaybackMode]                        INTEGER NOT NULL DEFAULT 0,"
"  [VideoPlaybackMode]                   INTEGER NOT NULL DEFAULT 0,"
"  [DeviceType]                          INTEGER NOT NULL,"
"  [DiscType]                            INTEGER DEFAULT 10,"
"  [IndexingState]                       INTEGER NOT NULL DEFAULT 2, /* IDS_NOT_STARTED */"
"  [ConnectionState]                     INTEGER NOT NULL DEFAULT 1, /* CS_ATTACHED */"
"  [IndexingProgress]                    INTEGER DEFAULT 0,"
"  [FormerConnectionState]               INTEGER NOT NULL DEFAULT 2, /* CS_DISCONNECTED */"
"  [AudioInputDevice]                    TEXT NOT NULL DEFAULT 'invalid',"
"  [DeviceState]                         INTEGER NOT NULL DEFAULT 0, /* DS_NONE */"
"  [FileSystemType]                      INTEGER NOT NULL DEFAULT 0,"
"  [PartitionNumber]                     INTEGER NOT NULL DEFAULT 0,"
"  [TotalSize]                           INTEGER DEFAULT 0,"
"  [FreeSize]                            INTEGER DEFAULT 0,"
"  [ProductID]                           INTEGER DEFAULT 0,"
"  [NumberOfAudioFiles]                  INTEGER DEFAULT -1," //RTC-341485
"  [NumberOfVideoFiles]                  INTEGER DEFAULT -1,"
"  [NumberOfImageFiles]                  INTEGER DEFAULT -1,"
"  [DiPOCapable]                         INTEGER DEFAULT 0,"
"  [DiPOActive]                          INTEGER DEFAULT 0,"
"  [DiPOVersion]                         TEXT,"
"  [ConnectionType]                      INTEGER DEFAULT 0, /* DCT_UNKNOWN */"
"  [DisconnectReason]                    INTEGER DEFAULT 0, /* DR_REMOVED */"
"  [IsShuffleSupported]                  BOOLEAN DEFAULT 1,"
"  [IsRepeatSupported]                   BOOLEAN DEFAULT 1,"
"  [AlbumArtIndexingComplete]            BOOLEAN DEFAULT 0,"
"  [IsNowPlayingListAvailable]           BOOLEAN DEFAULT 0,"
"  [DeviceUUID]                          TEXT NOT NULL DEFAULT 'invalid',"
"  [AppleDeviceMACAddress]               TEXT NOT NULL DEFAULT 'invalid', "
"  [AppleDeviceUSBSerial]                TEXT NOT NULL DEFAULT 'invalid' "
");"
"/* Attention: If this table is changed do the same in table VirtualDevices */"
""
"INSERT INTO [MAIN].[Devices] "
"("
"  ID,DeviceType,UUID,SerialNumber,FirmwareVersion,FriendlyName,MountPoint,IndexingState,ConnectionState,DeviceUUID,AppleDeviceMACAddress"
") VALUES ("
"  0,10,'0','-1','1.0','MyMedia','my-media-mount-point',5,2,'0','0'"
");"
""
"INSERT INTO [MAIN].[Devices] "
"("
"  ID,DeviceType,UUID,SerialNumber,FirmwareVersion,FriendlyName,MountPoint,IndexingState,ConnectionState,DeviceUUID"
") VALUES ("
"  1,15,'musicbox_uuid','musicbox_serial','1.0','MusicBox','/var/opt/bosch/dynamic/media/CDRipping/',5,2,'musicbox_duuid'"
");"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Devices_Before_Update_Active]"
"BEFORE UPDATE OF [Active] ON [Devices]"
"BEGIN"
"  SELECT CASE WHEN"
"    [NEW].[Active] = 1 AND"
"    EXISTS"
"    ("
"      SELECT"
"        [Devices].[Active]"
"      FROM"
"        [Devices]"
"      WHERE"
"        [Devices].[Active] = 1 AND"
"        [Devices].[ID] != [NEW].[ID]"
"    )"
"  THEN"
"    RAISE"
"    ("
"      ABORT,"
"      'Integrity constraint violation: only one device can be active.'"
"    )"
"  END;"
"  SELECT CASE WHEN"
"    [OLD].[Active] = 0 AND [NEW].[Active] = 1 AND [NEW].[ConnectionState] != 0"
"  THEN"
"    RAISE"
"    ("
"      ABORT,"
"      'Integrity constraint violation: device to activate is not connected.'"
"    )"
"  END;"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Devices_Before_Update_ConnectionState]"
"BEFORE UPDATE OF [ConnectionState] ON [Devices]"
"BEGIN"
"  SELECT CASE WHEN"
"    ([OLD].[ConnectionState] = 0 AND [NEW].[ConnectionState] = 1) OR"  // old:0=connected -> new:1=attached
"    ([OLD].[ConnectionState] = 3 AND [NEW].[ConnectionState] = 1) OR"  // old:3=malfunction -> new:1=attached
"    ([OLD].[ConnectionState] = 7 AND [NEW].[ConnectionState] = 0) OR"  // old:7=onhold -> new:0=connected - BT issue SUZUKI-23242
"    ([OLD].[ConnectionState] = 2 AND [NEW].[ConnectionState] = 0 AND [NEW].[ID] != 0)" // old:2=disconnected -> new:0=connected (not for MyMedia)
"  THEN"
"    RAISE"
"    ("
"      ABORT,"
"      \"IC violation: Invalid state transition.\""
"    )"
"  END; "
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Devices_After_Update_ConnectionState] "
"AFTER UPDATE OF [ConnectionState] ON [Devices] "
"BEGIN"
"   UPDATE Devices SET ConnectionState = "
"      CASE WHEN (SELECT COUNT() FROM Devices WHERE ConnectionState=0 AND IndexingState>1 AND UUID != '0') > 1 OR"
"                ((SELECT COUNT() FROM Devices WHERE ConnectionState=0 AND IndexingState>1 AND UUID != '0') > 0 AND"
"                 EXISTS"
"                 ("
"                   SELECT"
"                     [Devices].[Active]"
"                   FROM"
"                     [Devices]"
"                   WHERE"
"                     [Devices].[Active] = 1 AND"
"                     [Devices].[ID] = 0"
"                 ))"
"      THEN"
"         0"
"      ELSE"
"         2"
"      END "
"   WHERE ID=0 AND IndexingState=5 /* MyMedia ID and IndexingState = Complete (will be switched to not-supported if my media not enabled */;"
"   UPDATE Devices SET LastConnected = "
"      CASE WHEN (datetime('now')) > (SELECT MAX([Devices].[LastConnected]) FROM [Devices])"
"      THEN (datetime('now'))"
"      ELSE (SELECT datetime((SELECT MAX([Devices].[LastConnected]) FROM [Devices]), '+1 seconds'))"
"      END "
"   WHERE ID=NEW.ID AND OLD.ConnectionState!=NEW.ConnectionState AND NEW.ConnectionState=0;"
"   UPDATE Devices SET ConnectionCount = NEW.ConnectionCount + 1"
"   WHERE ID=NEW.ID AND OLD.ConnectionState!=NEW.ConnectionState AND NEW.ConnectionState=0;"
"END;"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[VirtualDevices]"
"("
"  [ID]                                  INTEGER UNIQUE PRIMARY KEY NOT NULL,"
"  [UUID]                                TEXT,"
"  [SerialNumber]                        TEXT UNIQUE NOT NULL,"
"  [FirmwareVersion]                     TEXT,"
"  [FriendlyName]                        TEXT,"
"  [MountPoint]                          TEXT,"
"  [ConnectionCount]                     INTEGER NOT NULL DEFAULT 0,"
"  [LastConnected]                       TEXT NOT NULL DEFAULT CURRENT_TIMESTAMP,"
"  [CheckSum]                            TEXT NOT NULL DEFAULT '" FINGERPRINT_INVALID"',"
"  [Active]                              BOOLEAN NOT NULL DEFAULT 0,"
"  [RepeatMode]                          INTEGER NOT NULL DEFAULT 0,"
"  [VideoRepeatMode]                     INTEGER NOT NULL DEFAULT 0,"
"  [PlaybackMode]                        INTEGER NOT NULL DEFAULT 0,"
"  [VideoPlaybackMode]                   INTEGER NOT NULL DEFAULT 0,"
"  [DeviceType]                          INTEGER NOT NULL,"
"  [DiscType]                            INTEGER DEFAULT 10,"
"  [IndexingState]                       INTEGER NOT NULL DEFAULT 2, /* IDS_NOT_STARTED */"
"  [ConnectionState]                     INTEGER NOT NULL DEFAULT 1, /* CS_ATTACHED */"
"  [IndexingProgress]                    INTEGER DEFAULT 0,"
"  [FormerConnectionState]               INTEGER NOT NULL DEFAULT 2, /* CS_DISCONNECTED */"
"  [AudioInputDevice]                    TEXT NOT NULL DEFAULT 'invalid',"
"  [DeviceState]                         INTEGER NOT NULL DEFAULT 0, /* DS_NONE */"
"  [FileSystemType]                      INTEGER NOT NULL DEFAULT 0,"
"  [PartitionNumber]                     INTEGER NOT NULL DEFAULT 0,"
"  [TotalSize]                           INTEGER DEFAULT 0,"
"  [FreeSize]                            INTEGER DEFAULT 0,"
"  [ProductID]                           INTEGER DEFAULT 0,"
"  [NumberOfAudioFiles]                  INTEGER DEFAULT -1,"
"  [NumberOfVideoFiles]                  INTEGER DEFAULT -1,"
"  [NumberOfImageFiles]                  INTEGER DEFAULT -1,"
"  [DiPOCapable]                         INTEGER DEFAULT 0,"
"  [DiPOActive]                          INTEGER DEFAULT 0,"
"  [DiPOVersion]                         TEXT,"
"  [ConnectionType]                      INTEGER DEFAULT 0, /* DCT_UNKNOWN */"
"  [DisconnectReason]                    INTEGER DEFAULT 0, /* DR_REMOVED */"
"  [IsShuffleSupported]                  BOOLEAN DEFAULT 1,"
"  [IsRepeatSupported]                   BOOLEAN DEFAULT 1,"
"  [AlbumArtIndexingComplete]            BOOLEAN DEFAULT 0,"
"  [IsNowPlayingListAvailable]           BOOLEAN DEFAULT 0,"
"  [DeviceUUID]                          TEXT NOT NULL DEFAULT 'invalid',"
"  [AppleDeviceMACAddress]               TEXT NOT NULL DEFAULT 'invalid', "
"  [AppleDeviceUSBSerial]                TEXT NOT NULL DEFAULT 'invalid' "
");"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[Objects]"
"("
"  [ID]                                  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,"
"  [DeviceID]                            INTEGER,"
"  [CategoryID]                          INTEGER NOT NULL,"
"  FOREIGN KEY ([DeviceID])              REFERENCES [Devices]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE"
");"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[Genres]"
"("
"  [ID]                                  INTEGER UNIQUE,"
"  [Genre]                               TEXT UNIQUE NOT NULL " UNIFY_COLLATE","
"  FOREIGN KEY ([ID])                    REFERENCES [Objects]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE"
");"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Genres_Before_Insert]"
"BEFORE INSERT ON [Genres]"
"BEGIN"
"  INSERT INTO [Objects]"
"  ("
"    [CategoryID]"
"  )"
"  SELECT"
"    1"
"  WHERE"
"    NOT EXISTS"
"    ("
"      SELECT"
"        [Genres].[Genre]"
"      FROM"
"        [Genres]"
"      WHERE"
"        [Genres].[Genre] = [NEW].[Genre]"
"    );"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Genres_After_Insert]"
"AFTER INSERT ON [Genres]"
"BEGIN"
"  UPDATE"
"    [Genres]"
"  SET"
"    [ID] ="
"  ("
"    SELECT"
"      MAX([Objects].[ID])"
"    FROM"
"      [Objects]"
"    WHERE"
"      [Objects].[CategoryID] = 1"
"  )"
"  WHERE"
"    [Genres].[ROWID] = [NEW].[ROWID];"
"END;"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[Artists]"
"("
"  [ID]                                  INTEGER UNIQUE,"
"  [Artist]                              TEXT UNIQUE NOT NULL " UNIFY_COLLATE","
"  FOREIGN KEY ([ID])                    REFERENCES [Objects]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE"
");"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Artists_Before_Insert]"
"BEFORE INSERT ON [Artists]"
"BEGIN"
"  INSERT INTO [Objects]"
"  ("
"    [CategoryID]"
"  )"
"  SELECT"
"    2"
"  WHERE"
"    NOT EXISTS"
"    ("
"      SELECT"
"        [Artists].[Artist]"
"      FROM"
"        [Artists]"
"      WHERE"
"        [Artists].[Artist] = [NEW].[Artist]"
"    );"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Artists_After_Insert]"
"AFTER INSERT ON [Artists]"
"BEGIN"
"  UPDATE"
"    [Artists]"
"  SET"
"    [ID] ="
"  ("
"    SELECT"
"      MAX([Objects].[ID])"
"    FROM"
"      [Objects]"
"    WHERE"
"      [Objects].[CategoryID] = 2"
"  )"
"  WHERE"
"    [Artists].[ROWID] = [NEW].[ROWID];"
"END;"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[Albums]"
"("
"  [ID]                                  INTEGER UNIQUE,"
"  [Album]                               TEXT UNIQUE NOT NULL " UNIFY_COLLATE","
"  FOREIGN KEY ([ID])                    REFERENCES [Objects]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE"
");"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Albums_Before_Insert]"
"BEFORE INSERT ON [Albums]"
"BEGIN"
"  INSERT INTO [Objects]"
"  ("
"    [CategoryID]"
"  )"
"  SELECT"
"    3"
"  WHERE"
"    NOT EXISTS"
"    ("
"      SELECT"
"        [Albums].[Album]"
"      FROM"
"        [Albums]"
"      WHERE"
"        [Albums].[Album] = [NEW].[Album]"
"    );"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Albums_After_Insert]"
"AFTER INSERT ON [Albums]"
"BEGIN"
"  UPDATE"
"    [Albums]"
"  SET"
"    [ID] ="
"  ("
"    SELECT"
"      MAX([Objects].[ID])"
"    FROM"
"      [Objects]"
"    WHERE"
"      [Objects].[CategoryID] = 3"
"  )"
"  WHERE"
"    [Albums].[ROWID] = [NEW].[ROWID];"
"END;"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[Years]"
"("
"  [ID]                                  INTEGER UNIQUE,"
"  [Year]                                INTEGER UNIQUE,"
"  FOREIGN KEY ([ID])                    REFERENCES [Objects]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE"
");"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Years_Before_Insert]"
"BEFORE INSERT ON [Years]"
"BEGIN"
"  INSERT INTO [Objects]"
"  ("
"    [CategoryID]"
"  )"
"  SELECT"
"    21"
"  WHERE"
"    NOT EXISTS"
"    ("
"      SELECT"
"        [Years].[Year]"
"      FROM"
"        [Years]"
"      WHERE"
"        [Years].[Year] = [NEW].[Year]"
"    );"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Years_After_Insert]"
"AFTER INSERT ON [Years]"
"BEGIN"
"  UPDATE"
"    [Years]"
"  SET"
"    [ID] ="
"  ("
"    SELECT"
"      MAX([Objects].[ID])"
"    FROM"
"      [Objects]"
"    WHERE"
"      [Objects].[CategoryID] = 21"
"  )"
"  WHERE"
"    [Years].[ROWID] = [NEW].[ROWID];"
"END;"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[Composers]"
"("
"  [ID]                                  INTEGER UNIQUE,"
"  [Composer]                            TEXT UNIQUE NOT NULL " UNIFY_COLLATE","
"  FOREIGN KEY ([ID])                    REFERENCES [Objects]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE"
");"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Composers_Before_Insert]"
"BEFORE INSERT ON [Composers]"
"BEGIN"
"  INSERT INTO [Objects]"
"  ("
"    [CategoryID]"
"  )"
"  SELECT"
"    5"
"  WHERE"
"    NOT EXISTS"
"    ("
"      SELECT"
"        [Composers].[Composer]"
"      FROM"
"        [Composers]"
"      WHERE"
"        [Composers].[Composer] = [NEW].[Composer]"
"    );"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Composers_After_Insert]"
"AFTER INSERT ON [Composers]"
"BEGIN"
"  UPDATE"
"    [Composers]"
"  SET"
"    [ID] ="
"  ("
"    SELECT"
"      MAX([Objects].[ID])"
"    FROM"
"      [Objects]"
"    WHERE"
"      [Objects].[CategoryID] = 5"
"  )"
"  WHERE"
"    [Composers].[ROWID] = [NEW].[ROWID];"
"END;"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[Videos]"
"("
"  [ID]                                  INTEGER UNIQUE,"
"  [Video]                               TEXT UNIQUE NOT NULL,"
"  FOREIGN KEY ([ID])                    REFERENCES [Objects]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE"
");"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Videos_Before_Insert]"
"BEFORE INSERT ON [Videos]"
"BEGIN"
"  INSERT INTO [Objects]"
"  ("
"    [CategoryID]"
"  )"
"  SELECT"
"    9"
"  WHERE"
"    NOT EXISTS"
"    ("
"      SELECT"
"        [Videos].[Video]"
"      FROM"
"        [Videos]"
"      WHERE"
"        [Videos].[Video] = [NEW].[Video]"
"    );"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Videos_After_Insert]"
"AFTER INSERT ON [Videos]"
"BEGIN"
"  UPDATE"
"    [Videos]"
"  SET"
"    [ID] ="
"  ("
"    SELECT"
"      MAX([Objects].[ID])"
"    FROM"
"      [Objects]"
"    WHERE"
"      [Objects].[CategoryID] = 9"
"  )"
"  WHERE"
"    [Videos].[ROWID] = [NEW].[ROWID];"
"END;"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[Podcasts]"
"("
"  [ID]                                  INTEGER UNIQUE,"
"  [Podcast]                             TEXT UNIQUE NOT NULL,"
"  FOREIGN KEY ([ID])                    REFERENCES [Objects]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE"
");"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Podcasts_Before_Insert]"
"BEFORE INSERT ON [Podcasts]"
"BEGIN"
"  INSERT INTO [Objects]"
"  ("
"    [CategoryID]"
"  )"
"  SELECT"
"    9"
"  WHERE"
"    NOT EXISTS"
"    ("
"      SELECT"
"        [Podcasts].[Podcast]"
"      FROM"
"        [Podcasts]"
"      WHERE"
"        [Podcasts].[Podcast] = [NEW].[Podcast]"
"    );"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Podcasts_After_Insert]"
"AFTER INSERT ON [Podcasts]"
"BEGIN"
"  UPDATE"
"    [Podcasts]"
"  SET"
"    [ID] ="
"  ("
"    SELECT"
"      MAX([Objects].[ID])"
"    FROM"
"      [Objects]"
"    WHERE"
"      [Objects].[CategoryID] = 9"
"  )"
"  WHERE"
"    [Podcasts].[ROWID] = [NEW].[ROWID];"
"END;"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[Playlists]"
"("
"  [ID]                                  INTEGER UNIQUE,"
"  [DeviceID]                            INTEGER,"
"  [Playlist]                            TEXT NOT NULL,"
"  [UUID]                                TEXT,"
"                                        UNIQUE (DeviceID, Playlist, UUID),"
"  FOREIGN KEY ([ID])                    REFERENCES [Objects]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE"
");"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Playlists_Before_Insert]"
"BEFORE INSERT ON [Playlists]"
"BEGIN"
"  INSERT INTO [Objects]"
"  ("
"    [CategoryID]"
"  )"
"  SELECT"
"    11"
"  WHERE"
"    NOT EXISTS"
"    ("
"      SELECT"
"        [Playlists].[Playlist]"
"      FROM"
"        [Playlists]"
"      WHERE"
"        [Playlists].[Playlist] = [NEW].[Playlist] AND"
"         [Playlists].[DeviceID] = [NEW].[DeviceID] AND"
"        [Playlists].[UUID] = [NEW].[UUID]"
"    );"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Playlists_After_Insert]"
"AFTER INSERT ON [Playlists]"
"BEGIN"
"  UPDATE"
"    [Playlists]"
"  SET"
"    [ID] ="
"  ("
"    SELECT"
"      MAX([Objects].[ID])"
"    FROM"
"      [Objects]"
"    WHERE"
"      [Objects].[CategoryID] = 11"
"  )"
"  WHERE"
"    [Playlists].[ROWID] = [NEW].[ROWID];"
"END;"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[Authors]"
"("
"  [ID]                                  INTEGER UNIQUE,"
"  [Author]                              TEXT UNIQUE NOT NULL,"
"  FOREIGN KEY ([ID])                    REFERENCES [Objects]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE"
");"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Authors_Before_Insert]"
"BEFORE INSERT ON [Authors]"
"BEGIN"
"  INSERT INTO [Objects]"
"  ("
"    [CategoryID]"
"  )"
"  SELECT"
"    6"
"  WHERE"
"    NOT EXISTS"
"    ("
"      SELECT"
"        [Authors].[Author]"
"      FROM"
"        [Authors]"
"      WHERE"
"        [Authors].[Author] = [NEW].[Author]"
"    );"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Authors_After_Insert]"
"AFTER INSERT ON [Authors]"
"BEGIN"
"  UPDATE"
"    [Authors]"
"  SET"
"    [ID] ="
"  ("
"    SELECT"
"      MAX([Objects].[ID])"
"    FROM"
"      [Objects]"
"    WHERE"
"      [Objects].[CategoryID] = 6"
"  )"
"  WHERE"
"    [Authors].[ROWID] = [NEW].[ROWID];"
"END;"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[Audiobooks]"
"("
"  [ID]                                  INTEGER UNIQUE,"
"  [Audiobook]                           TEXT UNIQUE NOT NULL,"
"  FOREIGN KEY ([ID])                    REFERENCES [Objects]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE"
");"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Audiobooks_Before_Insert]"
"BEFORE INSERT ON [Audiobooks]"
"BEGIN"
"  INSERT INTO [Objects]"
"  ("
"    [CategoryID]"
"  )"
"  SELECT"
"    7"
"  WHERE"
"    NOT EXISTS"
"    ("
"      SELECT"
"        [Audiobooks].[Audiobook]"
"      FROM"
"        [Audiobooks]"
"      WHERE"
"        [Audiobooks].[Audiobook] = [NEW].[Audiobook]"
"    );"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[Audiobooks_After_Insert]"
"AFTER INSERT ON [Audiobooks]"
"BEGIN"
"  UPDATE"
"    [Audiobooks]"
"  SET"
"    [ID] ="
"  ("
"    SELECT"
"      MAX([Objects].[ID])"
"    FROM"
"      [Objects]"
"    WHERE"
"      [Objects].[CategoryID] = 7"
"  )"
"  WHERE"
"    [Audiobooks].[ROWID] = [NEW].[ROWID];"
"END;"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[FolderHierarchy]"
"("
"  [ID]                                  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,"
"  [ParentID]                            INTEGER NOT NULL,"
"  [ChildID]                             INTEGER NOT NULL,"
"  [Depth]                               INTEGER,"
"  [DeviceID]                            INTEGER NOT NULL,"
"  [Name]                                TEXT,"
"  FOREIGN KEY ([ChildID])               REFERENCES [Objects]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE,"
"  UNIQUE ([Depth], [DeviceID], [Name])"
");"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[FolderHierarchy_After_Insert]"
"AFTER INSERT ON [FolderHierarchy]"
"WHEN [NEW].[Depth] = 0 "
"BEGIN"
"  UPDATE"
"    [FolderHierarchy]"
"  SET"
"    [ChildID] ="
"    ("
"      SELECT"
"        MAX([Objects].[ID])"
"      FROM"
"        [Objects]"
"      WHERE"
"        [Objects].[CategoryID] = 17"
"    ),"
"    [ParentID] ="
"    ("
"      SELECT"
"        MAX([Objects].[ID])"
"      FROM"
"        [Objects]"
"      WHERE"
"        [Objects].[CategoryID] = 17"
"    )"
"  WHERE"
"    ([FolderHierarchy].[ROWID] = [NEW].[ROWID]);"
#if 0
"  INSERT OR IGNORE INTO [FolderHierarchy]"
"  ("
"    [ParentID], [ChildID], [Depth], [DeviceID], [Name]"
"  )"
"  SELECT"
"    p.[ChildID],"
"    c.[ChildID],"
"    c.[Depth]+p.[Depth]+1,"
"    c.[DeviceID],"
"    c.[Name]"
"  FROM"
"    [FolderHierarchy] c, [FolderHierarchy] p"
"  WHERE"
"    (c.[Depth] = 0) AND" //(p.[Depth] = 0) AND" get last entry to increase depth
"    (c.[Name] != p.[Name]) AND"
"    (substr(c.[Name], 1, length(p.[Name])) = p.[Name]);"
#else
"  INSERT OR IGNORE INTO [FolderHierarchy]"
"  ("
"    [ParentID], [ChildID], [Depth], [DeviceID], [Name]"
"  )"
"  SELECT"
"    p.[ChildID],"
"    c.[ChildID],"
"    c.[Depth]+p.[Depth]+1,"
"    c.[DeviceID],"
"    c.[Name]"
"  FROM"
"    [FolderHierarchy] c, [FolderHierarchy] p"
"  WHERE"
"    ([NEW].[Name] = c.[Name]) AND"
"    (c.[Depth] = 0) AND"
"    ([NEW].[Name] != p.[Name]) AND"
"    (substr([NEW].[Name], 1, length(p.[Name])) = p.[Name]);"
#endif
"END;"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[Favorites]"
"("
"  [ID]                                  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,"
"  [ObjectID]                            INTEGER NOT NULL,"
"  [ObjectType]                          INTEGER,"
"  [LabelText]                           TEXT,"
"  [DescriptorText]                      TEXT,"
"  [Active]                              BOOLEAN NOT NULL DEFAULT 0,"
"  [Available]                           BOOLEAN NOT NULL DEFAULT 1,"
"  [UserID]                              INTEGER NOT NULL DEFAULT 0,"
"  FOREIGN KEY ([ObjectID])              REFERENCES [Objects]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE"
");"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[Users]"
"("
"  [ID]                                  INTEGER UNIQUE PRIMARY KEY NOT NULL,"
"  [Active]                              BOOLEAN NOT NULL DEFAULT 0"
");"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[ScanContext]"
"("
"  [ID]                                  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,"
"  [DeviceID]                            INTEGER NOT NULL,"
"  [Deep]                                INTEGER,"
"  [Path]                                TEXT,"
"  [Row]                                 INTEGER,"
"  FOREIGN KEY ([DeviceID])              REFERENCES [Devices]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE"
");"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[LastMode]"
"("
"  [DeviceID]                            INTEGER NOT NULL,"
"  [ListType]                            INTEGER,"
"  [PlayContinuation]                    INTEGER,"
"  [Tag1]                                INTEGER,"
"  [Tag2]                                INTEGER,"
"  [Tag3]                                INTEGER,"
"  [Tag4]                                INTEGER,"
"  [PlayTime]                            INTEGER,"
"  [CurrentObject]                       INTEGER,"
"  [CurrentRow]                          INTEGER,"
"  [Active]                              BOOLEAN NOT NULL DEFAULT 0,"
"  [Path]                                TEXT,"
"  [Streaming]                           BOOLEAN NOT NULL DEFAULT 0,"
"  [MediaContext]                        INTEGER DEFAULT 0,"
"  PRIMARY KEY ([DeviceID], [MediaContext]),"
"  FOREIGN KEY ([DeviceID])              REFERENCES [Devices]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE"
");"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[LastPlaytimes]"
"("
"  [ObjectID]                            INTEGER PRIMARY KEY NOT NULL,"
"  [ElapsedPlaytime]                     INTEGER,"
"  FOREIGN KEY ([ObjectID])              REFERENCES [Objects]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE"
");"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[AlbumArts]"
"("
"  [ID]                                  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,"
"  [DeviceID]                            INTEGER NOT NULL,"
"  [AlbumID]                             INTEGER NOT NULL,"
"  [Title]                               TEXT,"
"  [CoverArtPath]                        TEXT,"
"  [Thumbnail]                           BLOB,"
"  [LastModifiedTime]                    TEXT,"
"  FOREIGN KEY ([DeviceID])              REFERENCES [Devices]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE,"
"  UNIQUE ([DeviceID], [AlbumID])"
");"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[MediaObjects]"
"("
"  [ID]                                  INTEGER UNIQUE,"
"  [DeviceID]                            INTEGER NOT NULL,"
"  [CategoryID]                          INTEGER NOT NULL,"
"  [FilterTag1ID]                        INTEGER,"
"  [FilterTag2ID]                        INTEGER,"
"  [FilterTag3ID]                        INTEGER,"
"  [FilterTag4ID]                        INTEGER,"
"  [UUID]                                TEXT,"
"  [ParentUUID]                          TEXT,"
"  [Path]                                TEXT,"
"  [URL]                                 TEXT NOT NULL,"
"  [AlbumArt]                            TEXT,"
"  [TrackNumber]                         INTEGER,"
"  [TotalPlaytime]                       INTEGER,"
"  [NotPlayable]                         INTEGER DEFAULT 0,"
"  [Title]                               TEXT DEFAULT 'UNKNOWN' " COLLATE","
"  [FilterTag1]                          TEXT " COLLATE","
"  [FilterTag2]                          TEXT " COLLATE","
"  [FilterTag3]                          TEXT " COLLATE","
"  [FilterTag4]                          TEXT " COLLATE","
"  [MetadataConvertFlag]                 INTEGER DEFAULT 0,"
"  [CompilationFlag]                     INTEGER DEFAULT 0,"
"  [LowerFilterTag1]                     TEXT " COLLATE","
"  [LowerFilterTag2]                     TEXT " COLLATE","
"  [LowerFilterTag3]                     TEXT " COLLATE","
"  [LowerFilterTag4]                     TEXT " COLLATE","
"  [InitialTitle]                        TEXT " COLLATE","
"  [InitialFilterTag1]                   TEXT " COLLATE","
"  [InitialFilterTag2]                   TEXT " COLLATE","
"  [InitialFilterTag3]                   TEXT " COLLATE","
"  [InitialFilterTag4]                   TEXT " COLLATE","
"  [FolderID]                            INTEGER DEFAULT 0,"
"  [MediaContent]                        INTEGER DEFAULT 0,"
"  [Size]                                INTEGER DEFAULT 0,"
"  [DateTime]                            TEXT,"
"  [FileMode]                            INTEGER DEFAULT 511,"
"  [UserID]                              INTEGER DEFAULT 0,"
"  [GroupID]                             INTEGER DEFAULT 0,"
"  [Year]                                INTEGER,"
"  [YearID]                              INTEGER,"
"  FOREIGN KEY ([ID])                    REFERENCES [Objects]([ID])"
"                                        ON UPDATE CASCADE"
"                                        ON DELETE CASCADE,"
"  UNIQUE ([DeviceID], [URL])"
");"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[MediaObjects_Before_Insert]"
"BEFORE INSERT ON [MediaObjects]"
"BEGIN"
"  INSERT INTO [Objects]"
"  ("
"    [DeviceID],"
"    [CategoryID]"
"  )"
"  SELECT"
"    [NEW].[DeviceID],"
"    [NEW].[CategoryID]"
"  WHERE"
#if 0
"    NOT EXISTS"
"    ("
"      SELECT"
"        [MediaObjects].[URL]"
"      FROM"
"        [MediaObjects]"
"      WHERE"
"        [MediaObjects].[URL] = [NEW].[URL] AND"
"        [MediaObjects].[DeviceID] = [NEW].[DeviceID]"
"    );"
#else
"    NOT "
"    ("
"       EXISTS"
"       ("
"           SELECT [MediaObjects].[URL] FROM [MediaObjects] WHERE [MediaObjects].[URL] = [NEW].[URL] AND [MediaObjects].[DeviceID] = [NEW].[DeviceID]"
"       )"
"       OR"
"       EXISTS"
"       ("
"           SELECT [LiveTags].[Tag] FROM [LiveTags] WHERE [LiveTags].[Tag] = [NEW].[URL] AND [LiveTags].[DeviceID] = [NEW].[DeviceID]"
"       )"
"    );"
#endif
"  INSERT OR IGNORE INTO [Genres]"
"  ("
"    [Genre]"
"  )"
"  SELECT"
"  [NEW].[FilterTag1]"
"  WHERE"
"    [NEW].[CategoryID] = 4;"
"  INSERT OR IGNORE INTO [Artists]"
"  ("
"    [Artist]"
"  )"
"  SELECT"
"    [NEW].[FilterTag2]"
"  WHERE"
"    [NEW].[CategoryID] = 4;"
"  INSERT OR IGNORE INTO [Albums]"
"  ("
"    [Album]"
"  )"
"  SELECT"
"    [NEW].[FilterTag4]"
"  WHERE"
"    [NEW].[CategoryID] = 4;"
"  INSERT OR IGNORE INTO [Years]"
"  ("
"    [Year]"
"  )"
"  SELECT"
"    [NEW].[Year]"
"  WHERE"
"    [NEW].[CategoryID] = 4;"
"  INSERT OR IGNORE INTO [Composers]"
"  ("
"    [Composer]"
"  )"
"  SELECT"
"    [NEW].[FilterTag3]"
"  WHERE"
"    [NEW].[CategoryID] = 4;"
"  INSERT OR IGNORE INTO [Authors]"
"  ("
"    [Author]"
"  )"
"  SELECT"
"    [NEW].[FilterTag1]"
"  WHERE"
"    [NEW].[CategoryID] = 20;"
"  INSERT OR IGNORE INTO [Audiobooks]"
"  ("
"    [Audiobook]"
"  )"
"  SELECT"
"    [NEW].[FilterTag2]"
"  WHERE"
"    [NEW].[CategoryID] = 20;"
"  INSERT OR IGNORE INTO [Videos]"
"  ("
"    [Video]"
"  )"
"  SELECT"
"    [NEW].[FilterTag1]"
"  WHERE"
"    [NEW].[CategoryID] = 13;"
"  INSERT OR IGNORE INTO [Playlists]"
"  ("
"    [DeviceID], [Playlist], [UUID]"
"  )"
"  SELECT"
"    [NEW].[DeviceID],"
"    [NEW].[FilterTag1],"
"    [NEW].[UUID]"
"  WHERE"
#if 0
"    ([NEW].[CategoryID] IN (11,18)) AND"
"    NOT "
"    ("
"       EXISTS"
"       ("
"           SELECT"
"               [Playlists].[Playlist]"
"           FROM"
"               [Playlists]"
"           WHERE"
"               [Playlists].[Playlist] = [NEW].[FilterTag1] AND"
"               [Playlists].[DeviceID] = [NEW].[DeviceID] AND"
"               [Playlists].[UUID] = [NEW].[UUID] "
"       )"
"    );"
#else
"    ([NEW].[CategoryID] IN (11,18));"
#endif
"  INSERT OR IGNORE INTO [Podcasts]"
"  ("
"    [Podcast]"
"  )"
"  SELECT"
"    [NEW].[FilterTag1]"
"  WHERE"
"    [NEW].[CategoryID] = 12;"
"  INSERT OR IGNORE INTO [FolderHierarchy]"
"  ("
"    [ParentID], [ChildID], [Depth], [DeviceID], [Name]"
"  )"
"  SELECT"
"    [NEW].[ROWID],"
"    [NEW].[ROWID],"
"    0,"
"    [NEW].[DeviceID],"
"    [NEW].[URL]"
"  WHERE"
"    [NEW].[CategoryID] = 17;"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[MediaObjects_After_Insert]"
"AFTER INSERT ON [MediaObjects]"
"BEGIN"
"  UPDATE"
"    [MediaObjects]"
"  SET"
"    [FilterTag1ID] ="
"    ("
"      SELECT"
"        [Genres].[ID]"
"      FROM"
"        [Genres]"
"      WHERE"
"        [Genres].[Genre] = [NEW].[FilterTag1]"
"    ),"
"    [FilterTag2ID] ="
"    ("
"      SELECT"
"        [Artists].[ID]"
"      FROM"
"        [Artists]"
"      WHERE"
"        [Artists].[Artist] = [NEW].[FilterTag2]"
"    ),"
"    [FilterTag4ID] ="
"    ("
"      SELECT"
"        [Albums].[ID]"
"      FROM"
"        [Albums]"
"      WHERE"
"        [Albums].[Album] = [NEW].[FilterTag4]"
"    ),"
"    [FilterTag3ID] ="
"    ("
"      SELECT"
"        [Composers].[ID]"
"      FROM"
"        [Composers]"
"      WHERE"
"        [Composers].[Composer] = [NEW].[FilterTag3]"
"    ),"
"   [YearID] ="
"    ("
"      SELECT"
"        [Years].[ID]"
"      FROM"
"        [Years]"
"      WHERE"
"        [Years].[Year] = [NEW].[Year]"
"    )"
"  WHERE"
"    ([NEW].[CategoryID] = 4) AND"
"    ([MediaObjects].[ROWID] = [NEW].[ROWID]);"
"  UPDATE"
"    [MediaObjects]"
"  SET"
"    [FilterTag1ID] ="
"    ("
"      SELECT"
"        [Authors].[ID]"
"      FROM"
"        [Authors]"
"      WHERE"
"        [Authors].[Author] = [NEW].[FilterTag1]"
"    ),"
"    [FilterTag2ID] ="
"    ("
"      SELECT"
"        [Audiobooks].[ID]"
"      FROM"
"        [Audiobooks]"
"      WHERE"
"        [Audiobooks].[Audiobook] = [NEW].[FilterTag2]"
"    )"
"  WHERE"
"    ([NEW].[CategoryID] = 20) AND"
"    ([MediaObjects].[ROWID] = [NEW].[ROWID]);"
"  UPDATE"
"    [MediaObjects]"
"  SET"
"    [FilterTag1ID] ="
"    ("
"      SELECT"
"        [Videos].[ID]"
"      FROM"
"        [Videos]"
"      WHERE"
"        [Videos].[Video] = [NEW].[FilterTag1]"
"    )"
"  WHERE"
"    ([NEW].[CategoryID] = 13) AND"
"    ([MediaObjects].[ROWID] = [NEW].[ROWID]);"
"  UPDATE"
"    [MediaObjects]"
"  SET"
"    [FilterTag1ID] ="
"    ("
"      SELECT"
"        [Playlists].[ID]"
"      FROM"
"        [Playlists]"
"      WHERE"
"        [Playlists].[Playlist] = [NEW].[FilterTag1] AND"
"         [Playlists].[DeviceID] = [NEW].[DeviceID] AND"
"        [Playlists].[UUID] = [NEW].[UUID]"
"    )"
"  WHERE"
"    ([NEW].[CategoryID] IN (11,18)) AND"
"    ([MediaObjects].[ROWID] = [NEW].[ROWID]);"
"  UPDATE"
"    [MediaObjects]"
"  SET"
"    [FilterTag1ID] ="
"    ("
"      SELECT"
"        [MediaObjects].[ID]"
"      FROM"
"        [MediaObjects]"
"      WHERE"
"        [MediaObjects].[UUID] = [NEW].[ParentUUID] AND"
"        [MediaObjects].[DeviceID] = [NEW].[DeviceID]"
"    ),"
"    [FilterTag1] ="
"    ("
"      SELECT"
"        [MediaObjects].[Title]"
"      FROM"
"        [MediaObjects]"
"      WHERE"
"        [MediaObjects].[UUID] = [NEW].[ParentUUID] AND"
"        [MediaObjects].[DeviceID] = [NEW].[DeviceID]"
"    ),"
"    [Title] ="
"    ("
"      SELECT "
"       CASE WHEN EXISTS"
"       ("
"           SELECT "
"               1 "
"           FROM"
"              [MediaObjects]"
"           WHERE"
"              [MediaObjects].[UUID] = [NEW].[UUID] AND"
"              [MediaObjects].[DeviceID] = [NEW].[DeviceID] AND"
"              [MediaObjects].[CategoryID] <> 14"
"       ) "
"       THEN "
"       (   "
"           SELECT"
"             [MediaObjects].[Title]"
"           FROM"
"             [MediaObjects]"
"           WHERE"
"             [MediaObjects].[UUID] = [NEW].[UUID] AND"
"             [MediaObjects].[DeviceID] = [NEW].[DeviceID] AND"
"             [MediaObjects].[CategoryID] <> 14"
"       )"
"       ELSE "
"       ("
"           [NEW].[Title]"
"       ) "
"       END"
"    )"
"  WHERE"
"    ([NEW].[CategoryID] = 14) AND"
"    ([MediaObjects].[ROWID] = [NEW].[ROWID]);"
"  UPDATE"
"    [MediaObjects]"
"  SET"
"    [FilterTag1ID] ="
"    ("
"      SELECT"
"        [Podcasts].[ID]"
"      FROM"
"        [Podcasts]"
"      WHERE"
"        [Podcasts].[Podcast] = [NEW].[FilterTag1]"
"    )"
"  WHERE"
"    ([NEW].[CategoryID] = 12) AND"
"    ([MediaObjects].[ROWID] = [NEW].[ROWID]);"
"  UPDATE"
"    [MediaObjects]"
"  SET"
"    [ID] ="
"    ("
"      SELECT "
"       CASE WHEN EXISTS"
"       ("
"           SELECT "
"               1 "
"           FROM "
"               [LiveTags] "
"           WHERE [LiveTags].[Tag] = [NEW].[URL] AND [LiveTags].[DeviceID] = [NEW].[DeviceID]"
"       ) "
"       THEN "
"       (   "
"           SELECT "
"               [TagID] "
"           FROM "
"               [LiveTags] "
"           WHERE [LiveTags].[Tag] = [NEW].[URL] AND [LiveTags].[DeviceID] = [NEW].[DeviceID]"
"       )"
"       ELSE "
"       ("
"           SELECT  "
"               MAX([Objects].[ID]) "
"           FROM "
"               [Objects] "
"           WHERE [Objects].[CategoryID] = [NEW].[CategoryID] AND"
"                 [Objects].[DeviceID] = [NEW].[DeviceID]"
"       ) "
"       END"
"    ),"
"    [FolderID] ="
"    ("
"      CASE WHEN length([NEW].[Path]) > 1"
"      THEN"
"      (   "
"        SELECT"
"          [FolderHierarchy].[ChildID]"
"        FROM"
"          [FolderHierarchy]"
"        WHERE"
"          [FolderHierarchy].[Name] = substr([NEW].[Path], 1, length([NEW].[Path])-1) AND"
"          [FolderHierarchy].[DeviceID] = [NEW].[DeviceID]"
"      )"
"      ELSE 0"
"      END"
"    ),"
#if 1
"    [LowerFilterTag1] =  CASE WHEN [NEW].[FilterTag1] = 'UNKNOWN'"
"    THEN '\e'"
"    ELSE (" UNIFY_TAG1")"
"    END,"
"    [LowerFilterTag2] =  CASE WHEN [NEW].[FilterTag2] = 'UNKNOWN'"
"    THEN '\e'"
"    ELSE (" UNIFY_TAG2")"
"    END,"
"    [LowerFilterTag3] =  CASE WHEN [NEW].[FilterTag3] = 'UNKNOWN'"
"    THEN '\e'"
"    ELSE (" UNIFY_TAG3")"
"    END,"
"    [LowerFilterTag4] =  CASE WHEN [NEW].[FilterTag4] = 'UNKNOWN'"
"    THEN '\e'"
"    ELSE (" UNIFY_TAG4")"
"    END,"
#else
"    [LowerFilterTag1] = (" UNIFY_TAG1"),"
"    [LowerFilterTag2] = (" UNIFY_TAG2"),"
"    [LowerFilterTag3] = (" UNIFY_TAG3"),"
"    [LowerFilterTag4] = (" UNIFY_TAG4"),"
#endif
#if 1
"    [InitialTitle] = (" INITIAL_TITLE"),"
"    [InitialFilterTag1] = (" INITIAL_TAG1"),"
"    [InitialFilterTag2] = (" INITIAL_TAG2"),"
"    [InitialFilterTag3] = (" INITIAL_TAG3"),"
"    [InitialFilterTag4] = (" INITIAL_TAG4")"
#else
"    [InitialTitle] = (substr(upper([NEW].[Title]), 1, 1)),"
"    [InitialFilterTag1] = (substr(upper([NEW].[FilterTag1]), 1, 1)),"
"    [InitialFilterTag2] = (substr(upper([NEW].[FilterTag2]), 1, 1)),"
"    [InitialFilterTag3] = (substr(upper([NEW].[FilterTag3]), 1, 1)),"
"    [InitialFilterTag4] = (substr(upper([NEW].[FilterTag4]), 1, 1))"
#endif
"  WHERE"
"    [MediaObjects].[ROWID] = [NEW].[ROWID];"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[MediaObjects_Before_Update]"
"BEFORE UPDATE OF [CategoryID], [FilterTag1], [FilterTag2], [FilterTag3], [FilterTag4] ON [MediaObjects]"
"BEGIN"
"  INSERT OR IGNORE INTO [Genres]"
"  ("
"    [Genre]"
"  )"
"  SELECT"
"  [NEW].[FilterTag1]"
"  WHERE"
"    [NEW].[CategoryID] = 4;"
"  INSERT OR IGNORE INTO [Artists]"
"  ("
"    [Artist]"
"  )"
"  SELECT"
"    [NEW].[FilterTag2]"
"  WHERE"
"    [NEW].[CategoryID] = 4;"
"  INSERT OR IGNORE INTO [Albums]"
"  ("
"    [Album]"
"  )"
"  SELECT"
"    [NEW].[FilterTag4]"
"  WHERE"
"    [NEW].[CategoryID] = 4;"
" INSERT OR IGNORE INTO [Years]"
"  ("
"    [Year]"
"  )"
"  SELECT"
"    [NEW].[Year]"
"  WHERE"
"    [NEW].[CategoryID] = 4;"
"  INSERT OR IGNORE INTO [Composers]"
"  ("
"    [Composer]"
"  )"
"  SELECT"
"    [NEW].[FilterTag3]"
"  WHERE"
"    [NEW].[CategoryID] = 4;"
"  INSERT OR IGNORE INTO [Authors]"
"  ("
"    [Author]"
"  )"
"  SELECT"
"    [NEW].[FilterTag1]"
"  WHERE"
"    [NEW].[CategoryID] = 20;"
"  INSERT OR IGNORE INTO [Audiobooks]"
"  ("
"    [Audiobook]"
"  )"
"  SELECT"
"    [NEW].[FilterTag2]"
"  WHERE"
"    [NEW].[CategoryID] = 20;"
"  INSERT OR IGNORE INTO [Videos]"
"  ("
"    [Video]"
"  )"
"  SELECT"
"    [NEW].[FilterTag1]"
"  WHERE"
"    [NEW].[CategoryID] = 13;"
"  INSERT OR IGNORE INTO [Playlists]"
"  ("
"    [DeviceID], [Playlist], [UUID]"
"  )"
"  SELECT"
"    [NEW].[DeviceID],"
"    [NEW].[FilterTag1],"
"    [NEW].[UUID]"
"  WHERE"
"    [NEW].[CategoryID] IN (11,18);"
"  INSERT OR IGNORE INTO [Podcasts]"
"  ("
"    [Podcast]"
"  )"
"  SELECT"
"    [NEW].[FilterTag1]"
"  WHERE"
"    [NEW].[CategoryID] = 12;"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[MediaObjects_After_Update]"
"AFTER UPDATE OF [CategoryID], [FilterTag1], [FilterTag2], [FilterTag3], [FilterTag4], [UUID], [ParentUUID], [NotPlayable] ON [MediaObjects]"
"BEGIN"
"  UPDATE"
"    [MediaObjects]"
"  SET"
"    [FilterTag1ID] ="
"    ("
"      SELECT"
"        [Genres].[ID]"
"      FROM"
"        [Genres]"
"      WHERE"
"        [Genres].[Genre] = [NEW].[FilterTag1]"
"    ),"
"    [FilterTag2ID] ="
"    ("
"      SELECT"
"        [Artists].[ID]"
"      FROM"
"        [Artists]"
"      WHERE"
"        [Artists].[Artist] = [NEW].[FilterTag2]"
"    ),"
"    [FilterTag4ID] ="
"    ("
"      SELECT"
"        [Albums].[ID]"
"      FROM"
"        [Albums]"
"      WHERE"
"        [Albums].[Album] = [NEW].[FilterTag4]"
"    ),"
"    [FilterTag3ID] ="
"    ("
"      SELECT"
"        [Composers].[ID]"
"      FROM"
"        [Composers]"
"      WHERE"
"        [Composers].[Composer] = [NEW].[FilterTag3]"
"    ),"
"   [YearID] ="
"    ("
"      SELECT"
"        [Years].[ID]"
"      FROM"
"        [Years]"
"      WHERE"
"        [Years].[Year] = [NEW].[Year]"
"    )"
"  WHERE"
"    ([NEW].[CategoryID] = 4) AND"
"    ([MediaObjects].[ROWID] = [NEW].[ROWID]);"
"  UPDATE"
"    [MediaObjects]"
"  SET"
"    [FilterTag1ID] ="
"    ("
"      SELECT"
"        [Authors].[ID]"
"      FROM"
"        [Authors]"
"      WHERE"
"        [Authors].[Author] = [NEW].[FilterTag1]"
"    ),"
"    [FilterTag2ID] ="
"    ("
"      SELECT"
"        [Audiobooks].[ID]"
"      FROM"
"        [Audiobooks]"
"      WHERE"
"        [Audiobooks].[Audiobook] = [NEW].[FilterTag2]"
"    )"
"  WHERE"
"    ([NEW].[CategoryID] = 20) AND"
"    ([MediaObjects].[ROWID] = [NEW].[ROWID]);"
"  UPDATE"
"    [MediaObjects]"
"  SET"
"    [FilterTag1ID] ="
"    ("
"      SELECT"
"        [Videos].[ID]"
"      FROM"
"        [Videos]"
"      WHERE"
"        [Videos].[Video] = [NEW].[FilterTag1]"
"    )"
"  WHERE"
"    ([NEW].[CategoryID] = 13) AND"
"    ([MediaObjects].[ROWID] = [NEW].[ROWID]);"
"  UPDATE"
"    [MediaObjects]"
"  SET"
"    [FilterTag1ID] ="
"    ("
"      SELECT"
"        [Playlists].[ID]"
"      FROM"
"        [Playlists]"
"      WHERE"
"        [Playlists].[Playlist] = [NEW].[FilterTag1] AND"
"         [Playlists].[DeviceID] = [NEW].[DeviceID] AND"
"        [Playlists].[UUID] = [NEW].[UUID]"
"    )"
"  WHERE"
"    ([NEW].[CategoryID] IN (11,18)) AND"
"    ([MediaObjects].[ROWID] = [NEW].[ROWID]);"
"  UPDATE"
"    [MediaObjects]"
"  SET"
"    [FilterTag1ID] ="
"    ("
"      SELECT"
"        [MediaObjects].[FilterTag1ID]"
"      FROM"
"        [MediaObjects]"
"      WHERE"
"        [MediaObjects].[UUID] = [NEW].[ParentUUID] AND"
"        [MediaObjects].[DeviceID] = [NEW].[DeviceID]"
"    ),"
"    [FilterTag1] ="
"    ("
"      SELECT"
"        [MediaObjects].[Title]"
"      FROM"
"        [MediaObjects]"
"      WHERE"
"        [MediaObjects].[UUID] = [NEW].[ParentUUID] AND"
"        [MediaObjects].[DeviceID] = [NEW].[DeviceID]"
"    ),"
"    [Title] ="
"    ("
"      SELECT "
"       CASE WHEN EXISTS"
"       ("
"           SELECT "
"               1 "
"           FROM"
"              [MediaObjects]"
"           WHERE"
"              [MediaObjects].[UUID] = [NEW].[UUID] AND"
"              [MediaObjects].[DeviceID] = [NEW].[DeviceID] AND"
"              [MediaObjects].[CategoryID] <> 14"
"       ) "
"       THEN "
"       (   "
"           SELECT"
"             [MediaObjects].[Title]"
"           FROM"
"             [MediaObjects]"
"           WHERE"
"             [MediaObjects].[UUID] = [NEW].[UUID] AND"
"             [MediaObjects].[DeviceID] = [NEW].[DeviceID] AND"
"             [MediaObjects].[CategoryID] <> 14"
"       )"
"       ELSE "
"       ("
"           [NEW].[Title]"
"       ) "
"       END"
"    )"
"  WHERE"
"    ([NEW].[CategoryID] = 14) AND"
"    ([MediaObjects].[ROWID] = [NEW].[ROWID]);"
"  UPDATE"
"    [MediaObjects]"
"  SET"
"    [FilterTag1ID] ="
"    ("
"      SELECT"
"        [Podcasts].[ID]"
"      FROM"
"        [Podcasts]"
"      WHERE"
"        [Podcasts].[Podcast] = [NEW].[FilterTag1]"
"    )"
"  WHERE"
"    ([NEW].[CategoryID] = 12) AND"
"    ([MediaObjects].[ROWID] = [NEW].[ROWID]);"
"  UPDATE"
"    [MediaObjects]"
"  SET"
#if 1
"    [LowerFilterTag1] =  CASE WHEN [NEW].[FilterTag1] = 'UNKNOWN'"
"    THEN '\e'"
"    ELSE (" UNIFY_TAG1")"
"    END,"
"    [LowerFilterTag2] =  CASE WHEN [NEW].[FilterTag2] = 'UNKNOWN'"
"    THEN '\e'"
"    ELSE (" UNIFY_TAG2")"
"    END,"
"    [LowerFilterTag3] =  CASE WHEN [NEW].[FilterTag3] = 'UNKNOWN'"
"    THEN '\e'"
"    ELSE (" UNIFY_TAG3")"
"    END,"
"    [LowerFilterTag4] =  CASE WHEN [NEW].[FilterTag4] = 'UNKNOWN'"
"    THEN '\e'"
"    ELSE (" UNIFY_TAG4")"
"    END,"
#else
"    [LowerFilterTag1] = (" UNIFY_TAG1"),"
"    [LowerFilterTag2] = (" UNIFY_TAG2"),"
"    [LowerFilterTag3] = (" UNIFY_TAG3"),"
"    [LowerFilterTag4] = (" UNIFY_TAG4"),"
#endif
#if 1
"    [InitialTitle] = (" INITIAL_TITLE"),"
"    [InitialFilterTag1] = (" INITIAL_TAG1"),"
"    [InitialFilterTag2] = (" INITIAL_TAG2"),"
"    [InitialFilterTag3] = (" INITIAL_TAG3"),"
"    [InitialFilterTag4] = (" INITIAL_TAG4")"
#else
"    [InitialTitle] = (substr(upper([NEW].[Title]), 1, 1)),"
"    [InitialFilterTag1] = (substr(upper([NEW].[FilterTag1]), 1, 1)),"
"    [InitialFilterTag2] = (substr(upper([NEW].[FilterTag2]), 1, 1)),"
"    [InitialFilterTag3] = (substr(upper([NEW].[FilterTag3]), 1, 1)),"
"    [InitialFilterTag4] = (substr(upper([NEW].[FilterTag4]), 1, 1))"
#endif
"  WHERE"
"    [MediaObjects].[ROWID] = [NEW].[ROWID];"
"  UPDATE"
"    [Devices]"
"  SET"
"    [NumberOfAudioFiles] = [NumberOfAudioFiles] - 1"
"  WHERE"
"    [NEW].[CategoryID] IN (4,12,20) AND"
"    [OLD].[NotPlayable] != [NEW].[NotPlayable] AND"
"    [NEW].[NotPlayable] <> 0 AND"
"    [Devices].[ID] = [NEW].[DeviceID] AND"
"    [Devices].[NumberOfAudioFiles] > 0 AND"
"    [Devices].[IndexingState] = 5;"
"  UPDATE"
"    [Devices]"
"  SET"
"    [NumberOfVideoFiles] = [NumberOfVideoFiles] - 1"
"  WHERE"
"    [NEW].[CategoryID] = 13 AND"
"    [OLD].[NotPlayable] != [NEW].[NotPlayable] AND"
"    [NEW].[NotPlayable] <> 0 AND"
"    [Devices].[ID] = [NEW].[DeviceID] AND"
"    [Devices].[NumberOfVideoFiles] > 0 AND"
"    [Devices].[IndexingState] = 5;"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[MediaObjects_After_Update_Playlist]"
"AFTER Update ON [MediaObjects]"
"WHEN [OLD].[CategoryID] = 11 "
"BEGIN"
"   DELETE FROM [MediaObjects]"
"   WHERE"
"     [MediaObjects].[CategoryID] = 14 AND"
"     [MediaObjects].[FilterTag1ID] = [OLD].[FilterTag1ID] AND"
"     [MediaObjects].[DeviceID] = [OLD].[DeviceID];"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[MediaObjects_Before_Delete_Playlist]"
"BEFORE DELETE ON [MediaObjects]"
"WHEN [OLD].[CategoryID] = 11 "
"BEGIN"
"   DELETE FROM [Playlists]"
"   WHERE"
"     [Playlists].[ID] = [OLD].[FilterTag1ID];"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[MediaObjects_After_Delete_Playlist]"
"AFTER DELETE ON [MediaObjects]"
"WHEN [OLD].[CategoryID] = 11 "
"BEGIN"
"   DELETE FROM [MediaObjects]"
"   WHERE"
"     [MediaObjects].[CategoryID] = 14 AND"
"     [MediaObjects].[FilterTag1ID] = [OLD].[FilterTag1ID] AND"
"     [MediaObjects].[DeviceID] = [OLD].[DeviceID];"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[MediaObjects_After_Delete_PlayableAudioObject]"
"AFTER DELETE ON [MediaObjects]"
"WHEN [OLD].[CategoryID] IN (4,12,20) "
"BEGIN"
"   UPDATE [Devices]"
"   SET [NumberOfAudioFiles] = [NumberOfAudioFiles] - 1"
"   WHERE"
"     [Devices].[ID] = [OLD].[DeviceID] AND"
"     [Devices].[NumberOfAudioFiles] > 0;"
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[MediaObjects_After_Delete_PlayableVideoObject]"
"AFTER DELETE ON [MediaObjects]"
"WHEN [OLD].[CategoryID] = 13 "
"BEGIN"
"   UPDATE [Devices]"
"   SET [NumberOfVideoFiles] = [NumberOfVideoFiles] - 1"
"   WHERE"
"     [Devices].[ID] = [OLD].[DeviceID] AND"
"     [Devices].[NumberOfVideoFiles] > 0;"
"END;"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[LiveTags]"
"("
"  [TagID]                               INTEGER UNIQUE,"
"  [DeviceID]                            INTEGER NOT NULL,"
"  [CategoryID]                          INTEGER NOT NULL,"
"  [Tag]                                 TEXT NOT NULL,"
"  [NotPlayable]                         INTEGER NOT NULL DEFAULT 0,"
"  UNIQUE ([DeviceID], [CategoryID], [Tag])"
");"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[LiveTags_Before_Insert]"
"BEFORE INSERT ON [LiveTags]"
"WHEN [NEW].[CategoryID] <> 1 AND [NEW].[CategoryID] <> 2 AND [NEW].[CategoryID] <> 3 AND [NEW].[CategoryID] <> 5 "
" AND [NEW].[CategoryID] <> 9 AND [NEW].[CategoryID] <> 6 AND [NEW].[CategoryID] <> 7 "
"BEGIN"
"  INSERT INTO [Objects]"
"  ("
"    [DeviceID],"
"    [CategoryID]"
"  )"
"  SELECT"
"    [NEW].[DeviceID],"
"    [NEW].[CategoryID]"
"  WHERE"
#if 0
"    NOT EXISTS"
"    ("
"      SELECT"
"        [LiveTags].[Tag]"
"      FROM"
"        [LiveTags]"
"      WHERE"
"        [LiveTags].[Tag] = [NEW].[Tag] AND"
"        [LiveTags].[CategoryID] = [NEW].[CategoryID] AND"
"        [LiveTags].[DeviceID] = [NEW].[DeviceID]"
"    );"
#else
"    NOT "
"    ("
"       EXISTS"
"       ("
"           SELECT"
"               [LiveTags].[Tag]"
"           FROM"
"               [LiveTags]"
"           WHERE"
"               [LiveTags].[Tag] = [NEW].[Tag] AND"
"               [LiveTags].[CategoryID] = [NEW].[CategoryID] AND"
"               [LiveTags].[DeviceID] = [NEW].[DeviceID]"
"       )"
"       OR"
"       EXISTS"
"       ("
"           SELECT "
"               [MediaObjects].[URL] "
"           FROM "
"               [MediaObjects] "
"           WHERE "
"               [MediaObjects].[URL] = [NEW].[Tag] AND"
"               [MediaObjects].[CategoryID] = [NEW].[CategoryID] AND"
"               [MediaObjects].[DeviceID] = [NEW].[DeviceID]"
"       )"
"    );"
#endif
"END;"
""
"CREATE TRIGGER IF NOT EXISTS [MAIN].[LiveTags_After_Insert]"
"AFTER INSERT ON [LiveTags]"
"WHEN [NEW].[CategoryID] <> 1 AND [NEW].[CategoryID] <> 2 AND [NEW].[CategoryID] <> 3 AND [NEW].[CategoryID] <> 5 "
" AND [NEW].[CategoryID] <> 9 AND [NEW].[CategoryID] <> 6 AND [NEW].[CategoryID] <> 7 "
"BEGIN"
"  UPDATE"
"    [LiveTags]"
"  SET"
"    [TagID] ="
#if 0
"    ("
"      SELECT"
"        MAX([Objects].[ID])"
"      FROM"
"        [Objects]"
"      WHERE"
"        [Objects].[CategoryID] = [NEW].[CategoryID]"
"    )"
#else
"    ("
"      SELECT "
"       CASE WHEN EXISTS"
"       ("
"           SELECT "
"               1 "
"           FROM "
"               MediaObjects "
"           WHERE URL=[NEW].[Tag] AND DeviceID=[NEW].[DeviceID]"
"       ) "
"       THEN "
"       (   "
"           SELECT "
"               ID "
"           FROM "
"               MediaObjects "
"           WHERE URL=[NEW].[Tag] AND DeviceID=[NEW].[DeviceID]"
"       )"
"       ELSE "
"       ("
"           SELECT  "
"               MAX([Objects].[ID]) "
"           FROM "
"               [Objects] "
"           WHERE [Objects].[CategoryID] = [NEW].[CategoryID]"
"       ) "
"       END"
"   )"
#endif
"  WHERE"
"    [LiveTags].[ROWID] = [NEW].[ROWID];"
"END;"
""
"/*** Trigger to run on insertion of data into livetags table for category = Genre) ***/"
"CREATE TRIGGER IF NOT EXISTS [MAIN].[LiveTags_After_Insert_Genre]"
"AFTER INSERT ON [LiveTags]"
"WHEN [NEW].[CategoryID] = 1 "
"BEGIN"
#if 0
"   DELETE FROM LiveTags WHERE EXISTS(SELECT 1 FROM Genres WHERE Genre = [NEW].[Tag]) AND CategoryID = 1 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
#endif
"   INSERT INTO Genres(Genre) SELECT Tag FROM LiveTags WHERE CategoryID = 1 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
"   UPDATE Livetags SET TagID = (SELECT ID FROM Genres WHERE Genre = [NEW].[Tag]) WHERE CategoryID = 1 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
"END;"
""
"/*** Trigger to run on insertion of data into livetags table for category = Artist) ***/"
"CREATE TRIGGER IF NOT EXISTS [MAIN].[LiveTags_After_Insert_Artist]"
"AFTER INSERT ON [LiveTags]"
"WHEN [NEW].[CategoryID] = 2 "
"BEGIN"
#if 0
"   DELETE FROM LiveTags WHERE EXISTS(SELECT 1 FROM Artists WHERE Artist = [NEW].[Tag]) AND CategoryID = 2 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
#endif
"   INSERT INTO Artists(Artist) SELECT Tag FROM LiveTags WHERE CategoryID = 2 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
"   UPDATE Livetags SET TagID = (SELECT ID FROM Artists WHERE Artist = [NEW].[Tag]) WHERE CategoryID = 2 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
"END;"
""
"/*** Trigger to run on insertion of data into livetags table for category = Composer) ***/"
"CREATE TRIGGER IF NOT EXISTS [MAIN].[LiveTags_After_Insert_Composer]"
"AFTER INSERT ON [LiveTags]"
"WHEN [NEW].[CategoryID] = 5 "
"BEGIN"
#if 0
"   DELETE FROM LiveTags WHERE EXISTS(SELECT 1 FROM Composers WHERE Composer = [NEW].[Tag]) AND CategoryID = 5 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
#endif
"   INSERT INTO Composers(Composer) SELECT Tag FROM LiveTags WHERE CategoryID = 5 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
"   UPDATE Livetags SET TagID = (SELECT ID FROM Composers WHERE Composer = [NEW].[Tag]) WHERE CategoryID = 5 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
"END;"
""
"/*** Trigger to run on insertion of data into livetags table for category = Album) ***/"
"CREATE TRIGGER IF NOT EXISTS [MAIN].[LiveTags_After_Insert_Albums]"
"AFTER INSERT ON [LiveTags]"
"WHEN [NEW].[CategoryID] = 3 "
"BEGIN"
#if 0
"   DELETE FROM LiveTags WHERE EXISTS(SELECT 1 FROM Albums WHERE Album = [NEW].[Tag]) AND CategoryID = 3 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
#endif
"   INSERT INTO Albums(Album) SELECT Tag FROM LiveTags WHERE CategoryID = 3 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
"   UPDATE Livetags SET TagID = (SELECT ID FROM Albums WHERE Album = [NEW].[Tag]) WHERE CategoryID = 3 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
"END;"
""
"/*** Trigger to run on insertion of data into livetags table for category = Name) ***/"
"CREATE TRIGGER IF NOT EXISTS [MAIN].[LiveTags_After_Insert_Videos]"
"AFTER INSERT ON [LiveTags]"
"WHEN [NEW].[CategoryID] = 9 "
"BEGIN"
#if 0
"   DELETE FROM LiveTags WHERE EXISTS(SELECT 1 FROM Videos WHERE Video = [NEW].[Tag]) AND CategoryID = 9 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
#endif
"   INSERT INTO Videos(Video) SELECT Tag FROM LiveTags WHERE CategoryID = 9 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
"   UPDATE Livetags SET TagID = (SELECT ID FROM Videos WHERE Video = [NEW].[Tag]) WHERE CategoryID = 9 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
"END;"
""
"/*** Trigger to run on insertion of data into livetags table for category = Author) ***/"
"CREATE TRIGGER IF NOT EXISTS [MAIN].[LiveTags_After_Insert_Authors]"
"AFTER INSERT ON [LiveTags]"
"WHEN [NEW].[CategoryID] = 6 "
"BEGIN"
#if 0
"   DELETE FROM LiveTags WHERE EXISTS(SELECT 1 FROM Authors WHERE Author = [NEW].[Tag]) AND CategoryID = 6 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
#endif
"   INSERT INTO Authors(Author) SELECT Tag FROM LiveTags WHERE CategoryID = 6 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
"   UPDATE Livetags SET TagID = (SELECT ID FROM Authors WHERE Author = [NEW].[Tag]) WHERE CategoryID = 6 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
"END;"
""
"/*** Trigger to run on insertion of data into livetags table for category = Title) ***/"
"CREATE TRIGGER IF NOT EXISTS [MAIN].[LiveTags_After_Insert_Audiobooks]"
"AFTER INSERT ON [LiveTags]"
"WHEN [NEW].[CategoryID] = 7 "
"BEGIN"
#if 0
"   DELETE FROM LiveTags WHERE EXISTS(SELECT 1 FROM Audiobooks WHERE Audiobook = [NEW].[Tag]) AND CategoryID = 7 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
#endif
"   INSERT INTO Audiobooks(Audiobook) SELECT Tag FROM LiveTags WHERE CategoryID = 7 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
"   UPDATE Livetags SET TagID = (SELECT ID FROM Audiobooks WHERE Audiobook = [NEW].[Tag]) WHERE CategoryID = 7 AND  Tag = [NEW].[Tag] AND DeviceID = [NEW].[DeviceID];"
"END;"
""
"/* -- LTY_GENRE, LTY_PODCAST, LTY_AUTHOR, LTY_VIDEO, LTY_GENRE_COUNT, LTY_PODCAST_COUNT, LTY_AUTHOR_COUNT, LTY_VIDEO_COUNT */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_LowerFilterTag1_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [LowerFilterTag1]" COLLATE
");"
""
"/* -- LTY_GENRE, LTY_PODCAST, LTY_AUTHOR, LTY_VIDEO (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_LowerFilterTag1_Index]"
"ON [MediaObjects]"
"("
"  [LowerFilterTag1]" COLLATE
");"
""
#if 0 //Not used yet, DB is using MediaObjects_FilterTag1_Index instead (don't know why?)
"/* -- LTY_PLAYLIST, LTY_PLAYLIST_INTERNAL */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_FilterTag1_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [FilterTag1]" COLLATE
");"
""
#endif
"/* -- LTY_PLAYLIST, LTY_PLAYLIST_INTERNAL (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_FilterTag1_Index]"
"ON [MediaObjects]"
"("
"  [FilterTag1]" COLLATE
");"
""
"/* -- LTY_ARTIST, LTY_AUDIOBOOK, LTY_ARTIST_COUNT, LTY_AUDIOBOOK_COUNT */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_LowerFilterTag2_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [LowerFilterTag2]" COLLATE
");"
""
"/* -- LTY_ARTIST, LTY_AUDIOBOOK, LTY_GENRE_ARTIST, LTY_AUTHOR_BOOKTITLE (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_LowerFilterTag2_Index]"
"ON [MediaObjects]"
"("
"  [LowerFilterTag2]" COLLATE
");"
""
"/*-- LTY_ALBUM, LTY_ALBUM_COUNT, LTY_COMPILATION, LTY_COMPILATION_COUNT */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_LowerFilterTag4_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [LowerFilterTag4]" COLLATE
");"
""
"/*-- LTY_ALBUM, ..._ALBUM, LTY_COMPILATION (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_LowerFilterTag4_Index]"
"ON [MediaObjects]"
"("
"  [LowerFilterTag4]" COLLATE
");"
""
"/* -- LTY_COMPOSER, LTY_COMPOSER_COUNT */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_LowerFilterTag3_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [LowerFilterTag3]" COLLATE
");"
""
"/*-- LTY_COMPOSER (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_LowerFilterTag3_Index]"
"ON [MediaObjects]"
"("
"  [LowerFilterTag3]" COLLATE
");"
""
"/* -- LTY_SONG, LTY_IMAGE, LTY_EPISODE_OF_VIDEO */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_Title_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [Title]" COLLATE
");"
""
"/* -- LTY_SONG, ..._SONG, ..._EPISODE, ..._CHAPTER, LTY_IMAGE, LTY_EPISODE_OF_VIDEO, LTY_IMAGE_FOLDER_ITEM (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_Title_Index]"
"ON [MediaObjects]"
"("
"  [Title]" COLLATE
");"
""
"/* -- LTY_BROWSELIST, LTY_BROWSELIST_MEDIAOBJECTS, LTY_BROWSELIST_MEDIAOBJECTS_ALL */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_Path_CategoryID_URL_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [Path],"
"  [CategoryID],"
"  [URL]" COLLATE
");"
""
"/* -- LTY_BROWSELIST_MEDIAOBJECTS_WITH_SUBFOLDERS */"
"CREATE INDEX IF NOT EXISTS [MAIN].[FolderHierarchy_Name]"
"ON [FolderHierarchy]"
"("
"  [Name]"
");"
""
"/* -- LTY_BROWSELIST_MEDIAOBJECTS_WITH_SUBFOLDERS */"
"CREATE INDEX IF NOT EXISTS [MAIN].[FolderHierarchy_ChildID_ParentID]"
"ON [FolderHierarchy]"
"("
"  [ChildID],"
"  [ParentID]"
");"
""
"/* -- LTY_BROWSELIST, LTY_BROWSELIST_MEDIAOBJECTS, LTY_BROWSELIST_MEDIAOBJECTS_COUNT_WITH_SUBFOLDERS (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_CategoryID_URL_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [URL]" COLLATE
");"
""
"/* -- LTY_BROWSELIST_MEDIAOBJECTS_WITH_SUBFOLDERS, LTY_BROWSELIST_MEDIAOBJECTS_ALL */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_Path_CategoryID_URL_Index]"
"ON [MediaObjects]"
"("
"  [Path]" COLLATE","
"  [CategoryID],"
"  [URL]" COLLATE
");"
""
#if 0 //Not used yet, DB is using first part of MediaObjects_DeviceID_Path_CategoryIDDesc_Title_Index instead
"/* -- LTY_BROWSELIST_COUNT, LTY_BROWSELIST_MEDIAOBJECTS_COUNT, LTY_BROWSELIST_MEDIAOBJECTS_COUNT_WITH_SUBFOLDERS, LTY_IMAGE_FOLDER_ITEM_COUNT (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_Path_CategoryID_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [Path],"
"  [CategoryID]"
");"
""
#endif
#if 0 //Not used yet, DB is using first part of MediaObjects_DeviceID_CategoryID_FilterTag1ID_TrackNumber_Index instead
"/* -- LTY_PLAYLIST_COUNT, LTY_IMAGE_COUNT, LTY_EPISODE_OF_VIDEO_COUNT, LTY_BROWSELIST_MEDIAOBJECTS_COUNT_ALL (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID]"
");"
""
#endif
#if 0 //Not used yet, DB is using first part of MediaObjects_DeviceID_CategoryID_Path_Title_Index instead
"/* -- LTY_IMAGE_FOLDER, LTY_IMAGE_FOLDER_COUNT */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_Path_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [Path]" COLLATE
");"
""
#endif
"/* -- LTY_IMAGE_FOLDER (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_Path_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [Path]" COLLATE
");"
""
"/* -- LTY_IMAGE_FOLDER_ITEM */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_Path_Title_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [Path]" COLLATE","
"  [Title]" COLLATE
");"
""
"/* -- LTY_MEDIAOBJECTS_BY_UUID */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_UUID_CategoryID_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [UUID],"
"  [CategoryID]"
");"
""
"/* -- LTY_SONG_SEARCH_KEY, LTY_PLAYLIST_SEARCH_KEY */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_InitialTitle_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [InitialTitle]" COLLATE
");"
""
"/* -- LTY_PLAYLIST_SEARCH_KEY (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_InitialTitle_Index]"
"ON [MediaObjects]"
"("
"  [InitialTitle]" COLLATE
");"
""
"/* -- LTY_GENRE_SEARCH_KEY, LTY_VIDEO_SEARCH_KEY, LTY_PODCAST_SEARCH_KEY */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_InitialFilterTag1_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [InitialFilterTag1]" COLLATE
");"
""
"/* -- LTY_ARTIST_SEARCH_KEY, LTY_AUDIOBOOK_SEARCH_KEY */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_InitialFilterTag2_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [InitialFilterTag2]" COLLATE
");"
""
"/* -- LTY_COMPOSER_ALBUM_SEARCH_KEY, LTY_ALBUM_SEARCH_KEY */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_InitialFilterTag4_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [InitialFilterTag4]" COLLATE
");"
""
"/* -- LTY_COMPOSER_SEARCH_KEY */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_InitialFilterTag3_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [InitialFilterTag3]" COLLATE
");"
""
"/* -- LTY_GENRE_ARTIST_SEARCH_KEY */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_FilterTag1ID_InitialFilterTag2_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [FilterTag1ID],"
"  [InitialFilterTag2]" COLLATE
");"
""
"/* -- LTY_GENRE_ALBUM_SEARCH_KEY */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_FilterTag1ID_InitialFilterTag4_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [FilterTag1ID],"
"  [InitialFilterTag4]" COLLATE
");"
""
"/* -- LTY_ARTIST_ALBUM_SEARCH_KEY, LTY_GENRE_ARTIST_ALBUM_SEARCH_KEY */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_FilterTag2ID_InitialFilterTag4_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [FilterTag2ID],"
"  [InitialFilterTag4]" COLLATE
");"
""
"/* -- LTY_GENRE_SONG_SEARCH_KEY, LTY_VIDEO_EPISODE_SEARCH_KEY, LTY_PODCAST_EPISODE_SEARCH_KEY */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_FilterTag1ID_InitialTitle_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [FilterTag1ID],"
"  [InitialTitle]" COLLATE
");"
""
"/* -- LTY_ARTIST_SONG_SEARCH_KEY, LTY_GENRE_ARTIST_SONG_SEARCH_KEY */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_FilterTag2ID_InitialTitle_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [FilterTag2ID],"
"  [InitialTitle]" COLLATE
");"
""
"/* -- LTY_COMPOSER_SONG_SEARCH_KEY */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_FilterTag3ID_InitialTitle_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [FilterTag3ID],"
"  [InitialTitle]" COLLATE
");"
""
"/* -- LTY_GENRE_ARTIST, LTY_AUTHOR_BOOKTITLE, LTY_GENRE_ARTIST_COUNT, LTY_AUTHOR_BOOKTITLE_COUNT */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_FilterTag1ID_LowerFilterTag2_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [FilterTag1ID],"
"  [LowerFilterTag2]" COLLATE
");"
""
"/* -- LTY_GENRE_ALBUM, LTY_GENRE_ARTIST_ALBUM, LTY_GENRE_ALBUM_COUNT */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_FilterTag1ID_LowerFilterTag4_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [FilterTag1ID],"
"  [LowerFilterTag4]" COLLATE
");"
""
"/* -- LTY_GENRE_SONG, LTY_GENRE_ARTIST_SONG, LTY_PODCAST_EPISODE, LTY_AUTHOR_BOOKTITLE_CHAPTER, LTY_VIDEO_EPISODE, */"
"/*    LTY_GENRE_SONG_COUNT, LTY_PODCAST_EPISODE_COUNT, LTY_VIDEO_EPISODE_COUNT */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_FilterTag1ID_Title_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [FilterTag1ID],"
"  [Title]" COLLATE
");"
""
"/* -- LTY_PLAYLIST_SONG, LTY_PLAYLIST_SONG_COUNT, LTY_PLAYLIST_INTERNAL_COUNT */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_FilterTag1ID_TrackNumber_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [FilterTag1ID],"
"  [TrackNumber]"
");"
""
#if 0 //Not used yet, DB is using first part of MediaObjects_TrackNumber_Title_Index instead
"/* -- LTY_PLAYLIST_SONG (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_TrackNumber_Index]"
"ON [MediaObjects]"
"("
"  [TrackNumber]"
");"
""
#endif
"/* -- LTY_ARTIST_ALBUM, LTY_GENRE_ARTIST_ALBUM_COUNT, */"
"/*    LTY_ARTIST_ALBUM_COUNT, LTY_ARTIST_SONG_COUNT, LTY_BOOKTITLE_CHAPTER_COUNT, LTY_AUTHOR_BOOKTITLE_CHAPTER_COUNT */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_FilterTag2ID_LowerFilterTag4_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [FilterTag2ID],"
"  [LowerFilterTag4]" COLLATE
");"
""
"/* -- LTY_ARTIST_SONG, LTY_GENRE_ARTIST_SONG, LTY_BOOKTITLE_CHAPTER, LTY_AUTHOR_BOOKTITLE_CHAPTER, */"
"/*    LTY_ARTIST_SONG_COUNT, LTY_GENRE_ARTIST_SONG_COUNT, LTY_BOOKTITLE_CHAPTER_COUNT, LTY_AUTHOR_BOOKTITLE_CHAPTER_COUNT */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_FilterTag2ID_Title_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [FilterTag2ID],"
"  [Title]" COLLATE
");"
""
"/* -- LTY_ALBUM_SONG, ..._ALBUM_SONG, ..._ALBUM_SONG_COUNT, LTY_COMPILATION_SONG, LTY_COMPILATION_SONG_COUNT */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_FilterTag4ID_TrackNumber_Title_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [FilterTag4ID],"
"  [TrackNumber],"
"  [Title]" COLLATE
");"
""
"/* -- LTY_ALBUM_SONG, ..._ALBUM_SONG, LTY_COMPILATION_SONG (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_TrackNumber_Title_Index]"
"ON [MediaObjects]"
"("
"  [TrackNumber],"
"  [Title]" COLLATE
");"
""
"/* -- LTY_COMPOSER_ALBUM, LTY_COMPOSER_ALBUM_COUNT */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_FilterTag3ID_LowerFilterTag4_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [FilterTag3ID],"
"  [LowerFilterTag4]" COLLATE
");"
""
"/* -- LTY_COMPOSER_SONG, LTY_COMPOSER_SONG_COUNT */"
"CREATE INDEX IF NOT EXISTS [MAIN].[MediaObjects_DeviceID_CategoryID_FilterTag3ID_Title_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [CategoryID],"
"  [FilterTag3ID],"
"  [Title]" COLLATE
");"
""
"CREATE VIEW IF NOT EXISTS [MAIN].[Genre] AS "
"SELECT DISTINCT"
"  [M].[DeviceID] AS [DeviceID],"
"  [G].[Genre] AS [Genre],"
"  [G].[ID] AS [MediaObjID]"
"FROM"
"  [MAIN].[Genres] AS [G], [MAIN].[MediaObjects] AS [M] NOT INDEXED "
"WHERE"
"  [G].[ID] = [M].[FilterTag1ID] AND"
"  [G].[Genre] != 'UNKNOWN';"
""
"CREATE VIEW IF NOT EXISTS [MAIN].[Artist] AS "
"SELECT DISTINCT"
"  [M].[DeviceID] AS [DeviceID],"
"  [A].[Artist] AS [Artistname],"
"  [A].[ID] AS [MediaObjID]"
"FROM"
"  [MAIN].[Artists] AS [A], [MAIN].[MediaObjects] AS [M] NOT INDEXED "
"WHERE"
"  [A].[ID] = [M].[FilterTag2ID] AND"
"  [A].[Artist] != 'UNKNOWN';"
""
"CREATE VIEW IF NOT EXISTS [MAIN].[Album] AS "
"SELECT DISTINCT"
"  [M].[DeviceID] AS [DeviceID],"
"  [A].[Album] AS [Albumname],"
"  [A].[ID] AS [MediaObjID]"
"FROM"
"  [MAIN].[Albums] AS [A], [MAIN].[MediaObjects] AS [M] NOT INDEXED "
"WHERE"
"  [A].[ID] = [M].[FilterTag4ID] AND"
"  [A].[Album] != 'UNKNOWN';"
""
"CREATE VIEW IF NOT EXISTS [MAIN].[Composer] AS "
"SELECT DISTINCT"
"  [M].[DeviceID] AS [DeviceID],"
"  [C].[Composer] AS [Composername],"
"  [C].[ID] AS [MediaObjID]"
"FROM"
"  [MAIN].[Composers] AS [C], [MAIN].[MediaObjects] AS [M] NOT INDEXED "
"WHERE"
"  [C].[ID] = [M].[FilterTag3ID] AND"
"  [C].[Composer] != 'UNKNOWN';"
""
"CREATE VIEW IF NOT EXISTS [MAIN].[Device] AS "
"SELECT DISTINCT"
"  [D].[ID] AS [DeviceID] ,[D].[FriendlyName] AS [Devicename] ,CASE [D].[ConnectionState] WHEN 0 THEN 1 WHEN 1 THEN 0 WHEN 2 THEN 0 WHEN 3 THEN 0 END AS [DeviceConnected] "
"FROM"
"  [MAIN].[Devices] AS [D] "
"WHERE"
"  [D].[IndexingState] > 0;" // thoemel: 0=IDS_NOT_SUPPORTED: this exludes MyMedia if it is not supported by version. Switched by LocalSPM::GetDataProvider().MyMediaSupported() at startup
""
//"CREATE VIEW IF NOT EXISTS [MAIN].[M_Checksum] AS "
//"SELECT DISTINCT [D].[ID] AS [DeviceID] ,[D].[IndexingProgress] AS [CheckSum] "
//"FROM [MAIN].[Devices] AS [D];"
"CREATE VIEW IF NOT EXISTS [MAIN].[M_Checksum] AS "
"SELECT DISTINCT"
"  [M].[DeviceID] AS [DeviceID],"
"  ((COUNT([M].[ID])*10000)+MAX([M].[ID])) AS [CheckSum] "
"FROM"
"  [MAIN].[MediaObjects] AS [M] NOT INDEXED "
"WHERE"
"  [M].[CategoryID] <> 14 "
"GROUP BY [DeviceID];"
""
"CREATE VIEW IF NOT EXISTS [MAIN].[Song] AS "
"SELECT DISTINCT"
"  [M].[DeviceID],"
"  [M].[Title] COLLATE BINARY AS [Songname],"
"  [M].[ID] AS [MediaObjID],"
"  0 AS [UID]"
"FROM"
"  [MAIN].[MediaObjects] AS [M] NOT INDEXED "
"WHERE"
"  [M].[CategoryID] = 4 AND"
"  [Songname] != 'UNKNOWN';"
""
"CREATE VIEW IF NOT EXISTS [MAIN].[Author] AS "
"SELECT DISTINCT"
"  [M].[DeviceID] AS [DeviceID],"
"  [A].[Author] AS [Authorname],"
"  [A].[ID] AS [MediaObjID]"
"FROM"
"  [MAIN].[Authors] AS [A], [MAIN].[MediaObjects] AS [M] NOT INDEXED "
"WHERE"
"  [M].[CategoryID] = 20 AND"
"  [A].[ID] = [M].[FilterTag1ID] AND"
"  [A].[Author] != 'UNKNOWN';"
""
"CREATE VIEW IF NOT EXISTS [MAIN].[AudioBook] AS "
"SELECT DISTINCT"
"  [M].[DeviceID] AS [DeviceID],"
"  [A].[Audiobook] AS [Audiobookname],"
"  [A].[ID] AS [MediaObjID]"
"FROM"
"  [MAIN].[Audiobooks] AS [A], [MAIN].[MediaObjects] AS [M] NOT INDEXED "
"WHERE"
"  [M].[CategoryID] = 20 AND"
"  [A].[ID] = [M].[FilterTag2ID] AND"
"  [A].[Audiobook] != 'UNKNOWN';"
""
"CREATE VIEW IF NOT EXISTS [MAIN].[Audiobookchapter] AS "
"SELECT DISTINCT"
"  [M].[DeviceID] AS [DeviceID],"
"  [M].[Title] COLLATE BINARY AS [Audiobookchapter],"
"  [M].[ID] AS [MediaObjID]"
"FROM"
"  [MAIN].[MediaObjects] AS [M] NOT INDEXED "
"WHERE"
"  [M].[CategoryID] = 20 AND"
"  [Audiobookchapter] != 'UNKNOWN';"
""
"CREATE VIEW IF NOT EXISTS [MAIN].[Podcast] AS "
"SELECT DISTINCT"
"  [M].[DeviceID] AS [DeviceID],"
"  [P].[Podcast] AS [Podcastname],"
"  [P].[ID] AS [MediaObjID]"
"FROM"
"  [MAIN].[Podcasts] AS [P], [MAIN].[MediaObjects] AS [M] NOT INDEXED "
"WHERE"
"  [M].[CategoryID] = 12 AND"
"  [P].[ID] = [M].[FilterTag1ID] AND"
"  [P].[Podcast] != 'UNKNOWN';"
""
"CREATE VIEW IF NOT EXISTS [MAIN].[Video] AS "
"SELECT DISTINCT"
"  [M].[DeviceID] AS [DeviceID],"
"  [V].[Video] AS [Videoname],"
"  [V].[ID] AS [MediaObjID]"
"FROM"
"  [MAIN].[Videos] AS [V], [MAIN].[MediaObjects] AS [M] NOT INDEXED "
"WHERE"
"  [M].[CategoryID] = 13 AND"
"  [V].[ID] = [M].[FilterTag1ID] AND"
"  [V].[Video] != 'UNKNOWN';"
""
"CREATE VIEW IF NOT EXISTS [MAIN].[PlayList] AS "
"SELECT DISTINCT"
"  [M].[DeviceID] AS [DeviceID],"
"  [P].[Playlist] AS [Playlistname],"
"  [P].[ID] AS [MediaObjID]"
"FROM"
"  [MAIN].[Playlists] AS [P], [MAIN].[MediaObjects] AS [M] NOT INDEXED "
"WHERE"
"  ([M].[CategoryID] IN (11,18)) AND"
"  [P].[ID] = [M].[FilterTag1ID] AND"
"  [P].[Playlist] != 'UNKNOWN';"
""
"CREATE VIEW IF NOT EXISTS [MAIN].[EpisodePodcast] AS "
"SELECT DISTINCT"
"  [M].[DeviceID] AS [DeviceID],"
"  1 AS [EpisodeNumber],"
"  [M].[Title] COLLATE BINARY AS [Episodename],"
"  [M].[ID] AS [MediaObjID]"
"FROM"
"  [MAIN].[MediaObjects] AS [M] NOT INDEXED "
"WHERE"
"  [M].[CategoryID] = 12 AND"
"  [Episodename] != 'UNKNOWN';"
""
"CREATE VIEW IF NOT EXISTS [MAIN].[VideoEpisode] AS "
"SELECT DISTINCT"
"  [M].[DeviceID] AS [DeviceID],"
"  1 AS [EpisodeNumber],"
"  [M].[Title] COLLATE BINARY AS [Episodename],"
"  [M].[ID] AS [MediaObjID]"
"FROM"
"  [MAIN].[MediaObjects] AS [M] NOT INDEXED "
"WHERE"
"  [M].[CategoryID] = 13 AND"
"  [Episodename] != 'UNKNOWN';"
""
"CREATE VIEW IF NOT EXISTS [MAIN].[AlbumByArtist] AS "
"SELECT DISTINCT"
"  [M].[DeviceID] AS [DeviceID],"
"  [A].[Album] AS [Albumname],"
"  [B].[Artist] AS [Artistname],"
"  [A].[ID] AS [AlbumObjID],"
"  [B].[ID] AS [ArtistObjID]"
"FROM"
"  [MAIN].[Albums] AS [A], [MAIN].[Artists] AS [B], [MAIN].[MediaObjects] AS [M] NOT INDEXED "
"WHERE"
"  [A].[ID] = [M].[FilterTag4ID] AND"
"  [A].[Album] != 'UNKNOWN' AND"
"  [B].[ID] = [M].[FilterTag2ID];"
""
"CREATE VIEW IF NOT EXISTS [MAIN].[SongByArtist] AS "
"SELECT DISTINCT"
"  [M].[DeviceID],"
"  [M].[Title] COLLATE BINARY AS [Songname],"
"  [B].[Artist] AS [Artistname],"
"  [M].[ID] AS [SongObjID],"
"  [B].[ID] AS [ArtistObjID],"
"  0 AS [UID]"
"FROM"
"  [MAIN].[MediaObjects] AS [M] NOT INDEXED, [MAIN].[Artists] AS [B] "
"WHERE"
"  [M].[CategoryID] = 4 AND"
"  [Songname] != 'UNKNOWN' AND"
"  [B].[ID] = [M].[FilterTag2ID];"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[VideoProperty]"
"("
"  [Brightness]                     INTEGER DEFAULT 100,"
"  [Hue]                            INTEGER DEFAULT 0,"
"  [Saturation]                     INTEGER DEFAULT 100,"
"  [Contrast]                       INTEGER DEFAULT 100,"
"  [BrightnessOffset]               INTEGER DEFAULT 0,"
"  [SaturationOffset]               INTEGER DEFAULT 0,"
"  [HueOffset]                      INTEGER DEFAULT 0"
");"
""
"INSERT INTO [MAIN].[VideoProperty] "
"("
"  Brightness"
") VALUES ("
"  100"
");"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[DVDVideoProperty]"
"("
"  [Brightness]                     INTEGER DEFAULT 100,"
"  [Hue]                            INTEGER DEFAULT 0,"
"  [Saturation]                     INTEGER DEFAULT 100,"
"  [Contrast]                       INTEGER DEFAULT 100,"
"  [BrightnessOffset]               INTEGER DEFAULT 0,"
"  [SaturationOffset]               INTEGER DEFAULT 0,"
"  [HueOffset]                      INTEGER DEFAULT 0"
");"
""
"INSERT INTO [MAIN].[DVDVideoProperty] "
"("
"  Brightness"
") VALUES ("
"  100"
");"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[MTPVideoProperty]"
"("
"  [Brightness]                     INTEGER DEFAULT 100,"
"  [Hue]                            INTEGER DEFAULT 0,"
"  [Saturation]                     INTEGER DEFAULT 100,"
"  [Contrast]                       INTEGER DEFAULT 100,"
"  [BrightnessOffset]               INTEGER DEFAULT 0,"
"  [SaturationOffset]               INTEGER DEFAULT 0,"
"  [HueOffset]                      INTEGER DEFAULT 0"
");"
""
"INSERT INTO [MAIN].[MTPVideoProperty] "
"("
"  Brightness"
") VALUES ("
"  100"
");"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[YomiMetadata]"
"("
"  [DeviceID]                           INTEGER DEFAULT 1,"
"  [MediaObjectTag]                     INTEGER PRIMARY KEY NOT NULL,"
"  [YomiTitle]                          TEXT DEFAULT 'UNKNOWN',"
"  [YomiArtist]                        TEXT DEFAULT 'UNKNOWN',"
"  [YomiAlbum]                          TEXT DEFAULT 'UNKNOWN'"
");"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[MusicBoxProperty]"
"("
"  [AutoRipping]                     BOOLEAN NOT NULL DEFAULT 0,"
"  [EncodingQuality]                 INTEGER DEFAULT 0"
");"
""
"INSERT INTO [MAIN].[MusicBoxProperty] "
"("
"  AutoRipping"
") VALUES ("
"  0"
");"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[MusicBoxToC]"
"("
"  [DeviceID]                      INTEGER DEFAULT 1,"
"  [TOCString]                   TEXT DEFAULT 'UNKNOWN',"
"  [UUID]                        TEXT DEFAULT 'UNKNOWN'"
");"
""
"CREATE TABLE IF NOT EXISTS [MAIN].[RouteGuidanceDisplayComponents]"
"("
"  [DeviceID]                         INTEGER DEFAULT 0,"
"  [Identifier]                       INTEGER UNIQUE PRIMARY KEY NOT NULL,"
"  [Name]                             TEXT DEFAULT 'UNKNOWN',"
"  [CurrentRoadNameLength]            INTEGER DEFAULT 127,"
"  [DestinationNameLength]            INTEGER DEFAULT 127,"
"  [AfterManeuverRoadNameLength]      INTEGER DEFAULT 127,"
"  [ManeuverDescriptionLength]        INTEGER DEFAULT 127,"
"  [GuidanceManeuverCapacity]         INTEGER DEFAULT 1"
");"
""
"CREATE virtual table IPOD using IPODVT;"
"CREATE virtual table FILE using FileSystemVT;"
"CREATE virtual table BT using BluetoothVT;"
"CREATE virtual table MTP using MTPVT;"
"CREATE virtual table CDDA using CDDAVT;"
