"CREATE TABLE IF NOT EXISTS [MyMe].[MediaObjects]"
"("
"  [ID]                                  INTEGER PRIMARY KEY NOT NULL,"
"  [DeviceID]                            INTEGER NOT NULL,"
"  [CategoryID]                          INTEGER NOT NULL,"
"  [FilterTag1ID]                        INTEGER,"
"  [FilterTag2ID]                        INTEGER,"
"  [FilterTag3ID]                        INTEGER,"
"  [FilterTag4ID]                        INTEGER,"
"  [UUID]                                TEXT,"
"  [ParentUUID]                          TEXT,"
"  [Path]                                TEXT,"
"  [URL]                                 TEXT NOT NULL,"
"  [AlbumArt]                            TEXT,"
"  [TrackNumber]                         INTEGER,"
"  [TotalPlaytime]                       INTEGER,"
"  [NotPlayable]                         INTEGER DEFAULT 0,"
"  [Title]                               TEXT DEFAULT 'UNKNOWN' " COLLATE","
"  [FilterTag1]                          TEXT " COLLATE","
"  [FilterTag2]                          TEXT " COLLATE","
"  [FilterTag3]                          TEXT " COLLATE","
"  [FilterTag4]                          TEXT " COLLATE","
"  [MetadataConvertFlag]                 INTEGER DEFAULT 0,"
"  [CompilationFlag]                     INTEGER DEFAULT 0,"
"  [LowerFilterTag1]                     TEXT " COLLATE","
"  [LowerFilterTag2]                     TEXT " COLLATE","
"  [LowerFilterTag3]                     TEXT " COLLATE","
"  [LowerFilterTag4]                     TEXT " COLLATE","
"  [InitialTitle]                        TEXT " COLLATE","
"  [InitialFilterTag1]                   TEXT " COLLATE","
"  [InitialFilterTag2]                   TEXT " COLLATE","
"  [InitialFilterTag3]                   TEXT " COLLATE","
"  [InitialFilterTag4]                   TEXT " COLLATE","
"  [FolderID]                            INTEGER DEFAULT 0,"
"  [MediaContent]                        INTEGER DEFAULT 0,"
"  [Size]                                INTEGER DEFAULT 0,"
"  [DateTime]                            TEXT,"
"  [FileMode]                            INTEGER DEFAULT 511,"
"  [UserID]                              INTEGER DEFAULT 0,"
"  [GroupID]                             INTEGER DEFAULT 0,"
"  [Year]                                INTEGER DEFAULT 0,"
"  [YearID]                              INTEGER DEFAULT 0,"
"  UNIQUE ([DeviceID], [URL])"
");"
""
"/* -- LTY_GENRE, LTY_PODCAST, LTY_AUTHOR, LTY_VIDEO, LTY_GENRE_COUNT, LTY_PODCAST_COUNT, LTY_AUTHOR_COUNT, LTY_VIDEO_COUNT */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_LowerFilterTag1_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [LowerFilterTag1]" COLLATE
");"
""
#if 0 //Not used yet
"/* -- LTY_GENRE, LTY_PODCAST, LTY_AUTHOR, LTY_VIDEO, LTY_PLAYLIST (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_LowerFilterTag1_Index]"
"ON [MediaObjects]"
"("
"  [LowerFilterTag1]" COLLATE
");"
""
#endif
"/* -- LTY_PLAYLIST */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_FilterTag1_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [FilterTag1]" COLLATE
");"
""
"/* -- LTY_ARTIST, LTY_AUDIOBOOK, LTY_ARTIST_COUNT, LTY_AUDIOBOOK_COUNT */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_LowerFilterTag2_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [LowerFilterTag2]" COLLATE
");"
""
#if 0 //Not used yet
"/* -- LTY_ARTIST, LTY_AUDIOBOOK, LTY_GENRE_ARTIST, LTY_AUTHOR_BOOKTITLE (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_LowerFilterTag2_Index]"
"ON [MediaObjects]"
"("
"  [LowerFilterTag2]" COLLATE
");"
""
#endif
"/*-- LTY_ALBUM, LTY_ALBUM_COUNT */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_LowerFilterTag4_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [LowerFilterTag4]" COLLATE
");"
""
#if 0 //Not used yet
"/*-- LTY_ALBUM, ..._ALBUM (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_LowerFilterTag4_Index]"
"ON [MediaObjects]"
"("
"  [LowerFilterTag4]" COLLATE
");"
""
#endif
"/* -- LTY_COMPOSER, LTY_COMPOSER_COUNT */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_LowerFilterTag3_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [LowerFilterTag3]" COLLATE
");"
""
#if 0 //Not used yet
"/*-- LTY_COMPOSER (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_LowerFilterTag3_Index]"
"ON [MediaObjects]"
"("
"  [LowerFilterTag3]" COLLATE
");"
""
#endif
"/* -- LTY_SONG, LTY_ARTIST_SONG, LTY_BOOKTITLE_CHAPTER */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_Title_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [Title]" COLLATE
");"
""
#if 0 //Not used yet
"/* -- LTY_SONG, ..._SONG, ..._EPISODE, ..._CHAPTER (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_Title_Index]"
"ON [MediaObjects]"
"("
"  [Title]" COLLATE
");"
""
#endif
"/* -- LTY_IMAGE_FOLDER, LTY_IMAGE_FOLDER_COUNT */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_DeviceID_Path_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [DeviceID],"
"  [Path]" COLLATE
");"
""
#if 0 //Not used yet
"/* -- LTY_IMAGE_FOLDER (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_DeviceID_Path_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [Path]" COLLATE
");"
""
#endif
"/* -- LTY_MEDIAOBJECTS_BY_UUID */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_DeviceID_UUID_CategoryID_Index]"
"ON [MediaObjects]"
"("
"  [DeviceID],"
"  [UUID],"
"  [CategoryID]"
");"
""
"/* -- LTY_SONG_SEARCH_KEY, LTY_PLAYLIST_SEARCH_KEY, ..._SONG_SEARCH_KEY */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_InitialTitle_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [InitialTitle]" COLLATE
");"
""
#if 0 //Not used yet
"/* -- LTY_PLAYLIST_SEARCH_KEY (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_InitialTitle_Index]"
"ON [MediaObjects]"
"("
"  [InitialTitle]" COLLATE
");"
""
#endif
"/* -- LTY_GENRE_SEARCH_KEY */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_InitialFilterTag1_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [InitialFilterTag1]" COLLATE
");"
""
"/* -- ..._ARTIST_SEARCH_KEY */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_InitialFilterTag2_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [InitialFilterTag2]" COLLATE
");"
""
"/* -- ..._ALBUM_SEARCH_KEY, LTY_SONG_COUNT */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_InitialFilterTag4_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [InitialFilterTag4]" COLLATE
");"
""
"/* -- LTY_COMPOSER_SEARCH_KEY */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_InitialFilterTag3_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [InitialFilterTag3]" COLLATE
");"
""
"/* -- LTY_GENRE_ARTIST, LTY_AUTHOR_BOOKTITLE, LTY_GENRE_ARTIST_COUNT, LTY_AUTHOR_BOOKTITLE_COUNT */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_FilterTag1ID_LowerFilterTag2_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [FilterTag1ID],"
"  [LowerFilterTag2]" COLLATE
");"
""
"/* -- LTY_GENRE_ALBUM, LTY_GENRE_ALBUM_COUNT */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_FilterTag1ID_LowerFilterTag4_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [FilterTag1ID],"
"  [LowerFilterTag4]" COLLATE
");"
""
"/* -- LTY_GENRE_SONG, LTY_GENRE_ARTIST_SONG, LTY_PODCAST_EPISODE, LTY_AUTHOR_BOOKTITLE_CHAPTER, LTY_VIDEO_EPISODE, */"
"/*    LTY_GENRE_SONG_COUNT, LTY_PODCAST_EPISODE_COUNT, LTY_VIDEO_EPISODE_COUNT */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_FilterTag1ID_Title_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [FilterTag1ID],"
"  [Title]" COLLATE
");"
""
"/* -- LTY_PLAYLIST_SONG, LTY_PLAYLIST_SONG_COUNT */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_FilterTag1ID_TrackNumber_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [FilterTag1ID],"
"  [TrackNumber]"
");"
""
#if 0 //Not used yet
"/* -- LTY_PLAYLIST_SONG (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_TrackNumber_Index]"
"ON [MediaObjects]"
"("
"  [TrackNumber]"
");"
""
#endif
"/* -- LTY_ARTIST_ALBUM, LTY_GENRE_ARTIST_ALBUM, LTY_GENRE_ARTIST_ALBUM_COUNT, LTY_GENRE_ARTIST_SONG_COUNT, */"
"/*    LTY_ARTIST_ALBUM_COUNT, LTY_ARTIST_SONG_COUNT, LTY_BOOKTITLE_CHAPTER_COUNT, LTY_AUTHOR_BOOKTITLE_CHAPTER_COUNT */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_FilterTag2ID_LowerFilterTag4_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [FilterTag2ID],"
"  [LowerFilterTag4]" COLLATE
");"
""
"/* -- LTY_ALBUM_SONG, ..._ALBUM_SONG, ..._ALBUM_SONG_COUNT */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_FilterTag4ID_TrackNumber_Title_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [FilterTag4ID],"
"  [TrackNumber],"
"  [Title]" COLLATE
");"
""
#if 0 //Not used yet
"/* -- LTY_ALBUM_SONG, ..._ALBUM_SONG (avoid second b-tree) */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_TrackNumber_Title_Index]"
"ON [MediaObjects]"
"("
"  [TrackNumber],"
"  [Title]" COLLATE
");"
""
#endif
"/* -- LTY_COMPOSER_ALBUM, LTY_COMPOSER_ALBUM_COUNT */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_FilterTag3ID_LowerFilterTag4_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [FilterTag3ID],"
"  [LowerFilterTag4]" COLLATE
");"
""
"/* -- LTY_COMPOSER_SONG, LTY_COMPOSER_SONG_COUNT, LTY_PLAYLIST_COUNT */"
"CREATE INDEX IF NOT EXISTS [MyMe].[MyMe_MediaObjects_CategoryID_FilterTag3ID_Title_Index]"
"ON [MediaObjects]"
"("
"  [CategoryID],"
"  [FilterTag3ID],"
"  [Title]" COLLATE
");"
""
