/*
 * Queries.h
 *
 * File contains all queries of the media player db manager.
 * It is included in the constructor of the Query object
 *
 *  Created on: Dec 4, 2012
 *      Author: Th�mel
 */

#ifndef QUERIES_H_
#define QUERIES_H_

/*
 * define the collation for all ordered lists
 */
#define NO_COLLATE " "
#define SORTLIB_COLLATE " COLLATE SORT_LIB "
#define NOCASE_COLLATE " COLLATE NOCASE "
#define CTY_SORT_BROWSING " (CASE WHEN categoryid=17 THEN 1 WHEN categoryid=11 THEN 2 WHEN categoryid=18 THEN 3 ELSE categoryid END) "
#define FT_SORT_PLAYING " (CASE WHEN type=0 THEN 100 WHEN type=1 THEN 99 ELSE type END) "

/* this switches the collation for all queries underneath */
#define COLLATE SORTLIB_COLLATE

    /* fill the list of known queries */
    tSQLStatement SQLStatement;

#if 0 // switch between new and old select macros

    // Old select macros
#define MEDIAOBJECT_SELECT_COLUMNS \
    "select id, CategoryID, deviceid, url, uuid, title, TrackNumber, filtertag1id, filtertag1, filtertag2id, filtertag2, filtertag3id, filtertag3, filtertag4id, filtertag4, TotalPlaytime, AlbumArt, " \
    "(select FirmwareVersion from [Main].[Devices] where id=deviceid), " \
    "(select MountPoint from [Main].[Devices] where id=deviceid), " \
    "(select DeviceType from [Main].[Devices] where id=deviceid) " \
    "from [Main].[MediaObjects] where rowid in "

#else
    // new select macros
#define MEDIAOBJECT_SELECT_COLUMNS \
    "select mo.id, mo.CategoryID, mo.deviceid, mo.url, mo.uuid, mo.title, mo.TrackNumber, mo.filtertag1id, mo.filtertag1, mo.filtertag2id, mo.filtertag2, mo.filtertag3id, mo.filtertag3, mo.filtertag4id, mo.filtertag4, " \
    "mo.MetadataConvertFlag, mo.CompilationFlag, mo.TotalPlaytime, mo.AlbumArt, mo.Path, mo.NotPlayable, mo.MediaContent, mo.Size, mo.DateTime, mo.FileMode, mo.UserID, mo.GroupID, mo.Year, mo.YearID, " \
    "d.FirmwareVersion, d.MountPoint, d.DeviceType " \
    "from [Main].[MediaObjects] mo , [Main].[Devices] d where mo.deviceid=d.id AND mo.rowid in "

#endif // end:switch between new and old select macros

#define CTY_SONG_CRITERIA "categoryid=4"
//#define CTY_PLAYLIST_CRITERIA "categoryid=11 or categoryid=18"     use IN instead of OR due to sqlite performance reasons
#define CTY_PLAYLIST_CRITERIA "categoryid IN (11,18)"
#define CTY_PLAYLIST_ITEM_CRITERIA "categoryid=14"
#define CTY_NOT_PLAYLIST_ITEM_CRITERIA "categoryid<>14"
#define CTY_PLAYLIST_INTERNAL_CRITERIA "categoryid=18"
#define CTY_VIDEO_CRITERIA "categoryid=13"
#define CTY_PODCAST_CRITERIA "categoryid=12"
#define CTY_AUDIOBOOK_CRITERIA "categoryid=20"
#define CTY_IMAGE_CRITERIA "categoryid=19"
#define CTY_IPOD_UUID_CRITERIA "categoryid IN (4,12,20)"



    SQLStatement.query = "/*01*/""SELECT * FROM [Main].[Objects] WHERE (? OR ID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_OBJECTS] = SQLStatement;

    //----------------------
    //LTY_SONG
    //----------------------
    SQLStatement.query = "/*83*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" "
                         "order by title" COLLATE" limit ? offset ?) " //first ordering is important because of limit and offset
                         "order by title" COLLATE";"; //second ordering is for sorting results
    mSQLStatements[LTY_SONG] = SQLStatement;

    SQLStatement.query = "/*83fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and title LIKE ? "
                         "order by title" COLLATE" limit ? offset ?) " //first ordering is important because of limit and offset
                         "order by title" COLLATE";"; //second ordering is for sorting results
    mSQLStatements[LTY_SONG_SEARCH] = SQLStatement; //Roadmap 160014 'full text search'

    SQLStatement.query = "/*02*/""SELECT COUNT() FROM [Main].[MediaObjects] WHERE (? OR DeviceID=?) AND " CTY_SONG_CRITERIA" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_SONG_COUNT] = SQLStatement;

    SQLStatement.query = "/*02fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and title LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_SONG_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*03*/""SELECT initialtitle, count() FROM [Main].[MediaObjects] "
                         "WHERE (? OR DeviceID=?) AND " CTY_SONG_CRITERIA" "
                         "GROUP BY initialtitle" COLLATE" ORDER BY initialtitle" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_SONG_SEARCH_KEY] = SQLStatement;
    SQLStatement.query = "/*04*/""DELETE FROM [Main].[MediaObjects] WHERE (? OR ID=?) AND (? OR UUID=?) AND (? OR DeviceID=?);";
    mSQLStatements[LTY_SONGS_DELETE] = SQLStatement;

#define INSERT_OR_REPLACE 0 // Attention! same switch as in DBManager.cpp
#if INSERT_OR_REPLACE
    SQLStatement.query = "/*07*/""INSERT OR REPLACE INTO [Main].[MediaObjects] "
#else
    SQLStatement.query = "/*06*/""INSERT OR IGNORE INTO [Main].[MediaObjects] "
#endif
            "("
            "  [DeviceID],"
            "  [CategoryID],"
            "  [URL],"
            "  [UUID],"
            "  [ParentUUID],"
            "  [Title],"
            "  [FilterTag1],"
            "  [FilterTag2],"
            "  [FilterTag3],"
            "  [FilterTag4],"
            "  [MetadataConvertFlag],"
            "  [CompilationFlag],"
            "  [TotalPlaytime],"
            "  [AlbumArt],"
            "  [TrackNumber],"
            "  [Path],"
            "  [NotPlayable],"
            "  [MediaContent],"
            "  [Size],"
            "  [DateTime],"
            "  [FileMode],"
            "  [UserID],"
            "  [GroupID],"
            "  [Year]"
            ") "
            "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
    mSQLStatements[LTY_MEDIAOBJECTS_INSERT] = SQLStatement;

    SQLStatement.query = "/*06a*/SELECT COUNT() FROM [Main].[MediaObjects] "
                         "WHERE (? OR DeviceID=?) AND (? OR CategoryID IN (?,?,?)) AND (? OR NotPlayable=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MEDIAOBJECTS_PLAYABLE_FILTER_COUNT] = SQLStatement;

    SQLStatement.query = "/*06b*/SELECT COUNT() FROM [MyMe].[MediaObjects] "
                         "WHERE (? OR DeviceID=?) AND (? OR CategoryID IN (?,?,?)) AND (? OR NotPlayable=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MEDIAOBJECTS_MYME_PLAYABLE_FILTER_COUNT] = SQLStatement;

    SQLStatement.query = "/*06c*/SELECT DISTINCT deviceid FROM MediaObjects "
                         "WHERE (? OR DeviceID=?) AND (? or ID=?) AND (? or FilterTag1ID=?) AND (? or FilterTag2ID=?) AND (? or FilterTag3ID=?) AND (? or FilterTag4ID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MEDIAOBJECTS_DEVICEID_OBJECTID_FILTER] = SQLStatement;

    SQLStatement.query = "/*59c*/""SELECT url FROM MediaObjects "
                         "WHERE (? OR DeviceID=?) AND (? or ID=?) AND (? or FilterTag1ID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MEDIAOBJECTS_URL] = SQLStatement;

    SQLStatement.query = "/*06d*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? OR DeviceID=?) AND ((ID=?) OR (FilterTag1ID=?) OR (FilterTag2ID=?) OR (FilterTag3ID=?) OR (FilterTag4ID=?)) LIMIT ? OFFSET ?);";
    mSQLStatements[LTY_MEDIAOBJECTS_OBJECTID_FILTER] = SQLStatement;

    SQLStatement.query = "/*06e*/""SELECT FilterTag4ID FROM [Main].[MediaObjects] "
                         "WHERE (? OR DeviceID=?) AND (ID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MEDIAOBJECTS_FILTERTAG4ID_OBJECTID_FILTER] = SQLStatement;
    SQLStatement.query = "/*06f*/""SELECT ID FROM [Main].[MediaObjects] "
                         "WHERE (? OR DeviceID=?) AND (FilterTag4ID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MEDIAOBJECT_BY_ALBUMID] = SQLStatement;

    SQLStatement.query = "/*77*/""INSERT OR REPLACE INTO [MyMe].[MediaObjects]"
    "("
    "  [ID],"
    "  [DeviceID],"
    "  [CategoryID],"
    "  [FilterTag1ID],"
    "  [FilterTag2ID],"
    "  [FilterTag3ID],"
    "  [FilterTag4ID],"
    "  [UUID],"
    "  [ParentUUID],"
    "  [Path],"
    "  [URL],"
    "  [AlbumArt],"
    "  [TrackNumber],"
    "  [TotalPlaytime],"
    "  [NotPlayable],"
    "  [Title],"
    "  [FilterTag1],"
    "  [FilterTag2],"
    "  [FilterTag3],"
    "  [FilterTag4],"
    "  [MetadataConvertFlag],"
    "  [CompilationFlag],"
    "  [LowerFilterTag1],"
    "  [LowerFilterTag2],"
    "  [LowerFilterTag3],"
    "  [LowerFilterTag4],"
    "  [InitialTitle],"
    "  [InitialFilterTag1],"
    "  [InitialFilterTag2],"
    "  [InitialFilterTag3],"
    "  [InitialFilterTag4],"
    "  [FolderID],"
    "  [MediaContent],"
    "  [Size],"
    "  [DateTime],"
    "  [FileMode],"
    "  [UserID],"
    "  [GroupID],"
    "  [Year],"
    "  [YearID]"
    ")"
    "SELECT"
    "  [ID],"
    "  [DeviceID],"
    "  [CategoryID],"
    "  [FilterTag1ID],"
    "  [FilterTag2ID],"
    "  [FilterTag3ID],"
    "  [FilterTag4ID],"
    "  [UUID],"
    "  [ParentUUID],"
    "  [Path],"
    "  [URL],"
    "  [AlbumArt],"
    "  [TrackNumber],"
    "  [TotalPlaytime],"
    "  [NotPlayable],"
    "  [Title],"
    "  [FilterTag1],"
    "  [FilterTag2],"
    "  [FilterTag3],"
    "  [FilterTag4],"
    "  [MetadataConvertFlag],"
    "  [CompilationFlag],"
    "  [LowerFilterTag1],"
    "  [LowerFilterTag2],"
    "  [LowerFilterTag3],"
    "  [LowerFilterTag4],"
    "  [InitialTitle],"
    "  [InitialFilterTag1],"
    "  [InitialFilterTag2],"
    "  [InitialFilterTag3],"
    "  [InitialFilterTag4],"
    "  [FolderID],"
    "  [MediaContent],"
    "  [Size],"
    "  [DateTime],"
    "  [FileMode],"
    "  [UserID],"
    "  [GroupID],"
    "  [Year],"
    "  [YearID]"
    "FROM"
    "  [Main].[MediaObjects]"
    "WHERE"
    "  [Main].[MediaObjects].[ID] = ?;";
    mSQLStatements[LTY_MEDIAOBJECTS_MYME_COPY] = SQLStatement;

    SQLStatement.query = "/*78*/""INSERT OR REPLACE INTO [MyMe].[MediaObjects]"
    "("
    "  [ID],"
    "  [DeviceID],"
    "  [CategoryID],"
    "  [FilterTag1ID],"
    "  [FilterTag2ID],"
    "  [FilterTag3ID],"
    "  [FilterTag4ID],"
    "  [UUID],"
    "  [ParentUUID],"
    "  [Path],"
    "  [URL],"
    "  [AlbumArt],"
    "  [TrackNumber],"
    "  [TotalPlaytime],"
    "  [NotPlayable],"
    "  [Title],"
    "  [FilterTag1],"
    "  [FilterTag2],"
    "  [FilterTag3],"
    "  [FilterTag4],"
    "  [MetadataConvertFlag],"
    "  [CompilationFlag],"
    "  [LowerFilterTag1],"
    "  [LowerFilterTag2],"
    "  [LowerFilterTag3],"
    "  [LowerFilterTag4],"
    "  [InitialTitle],"
    "  [InitialFilterTag1],"
    "  [InitialFilterTag2],"
    "  [InitialFilterTag3],"
    "  [InitialFilterTag4],"
    "  [FolderID],"
    "  [MediaContent],"
    "  [Size],"
    "  [DateTime],"
    "  [FileMode],"
    "  [UserID],"
    "  [GroupID],"
    "  [Year],"
    "  [YearID]"
    ")"
    "SELECT"
    "  [ID],"
    "  [DeviceID],"
    "  [CategoryID],"
    "  [FilterTag1ID],"
    "  [FilterTag2ID],"
    "  [FilterTag3ID],"
    "  [FilterTag4ID],"
    "  [UUID],"
    "  [ParentUUID],"
    "  [Path],"
    "  [URL],"
    "  [AlbumArt],"
    "  [TrackNumber],"
    "  [TotalPlaytime],"
    "  [NotPlayable],"
    "  [Title],"
    "  [FilterTag1],"
    "  [FilterTag2],"
    "  [FilterTag3],"
    "  [FilterTag4],"
    "  [MetadataConvertFlag],"
    "  [CompilationFlag],"
    "  [LowerFilterTag1],"
    "  [LowerFilterTag2],"
    "  [LowerFilterTag3],"
    "  [LowerFilterTag4],"
    "  [InitialTitle],"
    "  [InitialFilterTag1],"
    "  [InitialFilterTag2],"
    "  [InitialFilterTag3],"
    "  [InitialFilterTag4],"
    "  [FolderID],"
    "  [MediaContent],"
    "  [Size],"
    "  [DateTime],"
    "  [FileMode],"
    "  [UserID],"
    "  [GroupID],"
    "  [Year],"
    "  [YearID]"
    "FROM"
    "  [Main].[MediaObjects]"
    "WHERE"
    "  [Main].[MediaObjects].[DeviceID] = ? AND [Main].[MediaObjects].[URL] = ?;";
    mSQLStatements[LTY_MEDIAOBJECTS_MYME_DEV_URL_COPY] = SQLStatement;

    SQLStatement.query = "/*79*/""DELETE FROM [MyMe].[MediaObjects] WHERE (? OR ID=?) AND (? OR UUID=?) AND (? OR DeviceID=?);";
    mSQLStatements[LTY_MEDIAOBJECTS_MYME_DELETE] = SQLStatement;

    SQLStatement.query = "/*08*/""DELETE FROM [Main].[MediaObjects] WHERE DeviceID=? AND URL=?;";
    mSQLStatements[LTY_MEDIAOBJECTS_DELETE] = SQLStatement;
    SQLStatement.query = "/*09*/""SELECT * FROM [Main].[MediaObjects] "
                         "WHERE (? OR DeviceID=?) AND (? OR URL=?) AND (? OR ID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MEDIAOBJECTS] = SQLStatement;

    SQLStatement.query = "/*09a*/""SELECT MediaContent FROM [Main].[MediaObjects] "
                         "WHERE (? OR DeviceID=?) AND (? OR URL=?) AND (? OR ID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MEDIAOBJECTS_GET_MEDIACONTENT] = SQLStatement;

    SQLStatement.query = "/*10*/""SELECT count() FROM [Main].[MediaObjects];";
    mSQLStatements[LTY_MEDIAOBJECTS_COUNT] = SQLStatement;
    SQLStatement.query = "/*11*/""UPDATE OR IGNORE [Main].[MediaObjects] SET "
            "UUID=CASE WHEN ? THEN UUID ELSE ? END,"
            "Title=CASE WHEN ? THEN Title ELSE ? END,"
            "FilterTag1=CASE WHEN ? THEN FilterTag1 ELSE ? END,"
            "FilterTag2=CASE WHEN ? THEN FilterTag2 ELSE ? END,"
            "FilterTag3=CASE WHEN ? THEN FilterTag3 ELSE ? END,"
            "FilterTag4=CASE WHEN ? THEN FilterTag4 ELSE ? END,"
            "MetadataConvertFlag=CASE WHEN ? THEN MetadataConvertFlag ELSE ? END,"
            "CompilationFlag=CASE WHEN ? THEN CompilationFlag ELSE ? END,"
            "TotalPlaytime=CASE WHEN ? THEN TotalPlaytime ELSE ? END,"
            "AlbumArt=CASE WHEN ? THEN AlbumArt ELSE ? END,"
            "TrackNumber=CASE WHEN ? THEN TrackNumber ELSE ? END,"
            "NotPlayable=CASE WHEN ? THEN NotPlayable ELSE ? END,"
            "MediaContent=CASE WHEN ? THEN MediaContent ELSE ? END,"
            "Size=CASE WHEN ? THEN Size ELSE ? END,"
            "DateTime=CASE WHEN ? THEN DateTime ELSE ? END,"
            "FileMode=CASE WHEN ? THEN FileMode ELSE ? END,"
            "UserID=CASE WHEN ? THEN UserID ELSE ? END,"
            "GroupID=CASE WHEN ? THEN GroupID ELSE ? END,"
            "Year=CASE WHEN ? THEN Year ELSE ? END "
            "WHERE (? OR DeviceID=?) AND (? OR URL=?) AND (? OR ID=?) AND (? OR NotPlayable<>?);";
    mSQLStatements[LTY_MEDIAOBJECTS_UPDATE] = SQLStatement;


        SQLStatement.query = "/*11a*/""UPDATE [Main].[MediaObjects] SET "
            "MediaContent= (MediaContent|?) "
            "WHERE (DeviceID=?) AND (URL=?);";
    mSQLStatements[LTY_MEDIAOBJECTS_UPDATE_MEDIACONTENT] = SQLStatement;

    /* only for module test */
    SQLStatement.query = "/*12*/""SELECT * FROM [MyMe].[MediaObjects] LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MEDIAOBJECTS_MYME] = SQLStatement;
    SQLStatement.query = "/*13*/""SELECT count() FROM [MyMe].[MediaObjects] LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MEDIAOBJECTS_MYME_COUNT] = SQLStatement;

    SQLStatement.query = "/*14*/""INSERT INTO [Main].[Favorites] "
                "("
                "  [ObjectID],"
                "  [ObjectType],"
                "  [LabelText],"
                "  [DescriptorText],"
                "  [Active],"
                "  [Available]"
                ") "
                "VALUES (?,?,?,?,?,?);";
    mSQLStatements[LTY_FAVORITES_INSERT] = SQLStatement;
    SQLStatement.query = "/*15*/""DELETE FROM [Main].[Favorites] WHERE (? OR ID=?);";
    mSQLStatements[LTY_FAVORITES_DELETE] = SQLStatement;
    SQLStatement.query = "/*16*/""SELECT * FROM [Main].[Favorites] WHERE (? OR ID=?) AND (? OR ObjectID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_FAVORITES] = SQLStatement;
    SQLStatement.query = "/*17*/""UPDATE [Main].[Favorites] SET "
                         "Available=CASE WHEN ? THEN Available ELSE ? END,"
                         "Active=CASE WHEN ? THEN Active ELSE ? END "
                         "WHERE (? OR ID=?);";
    mSQLStatements[LTY_FAVORITES_UPDATE] = SQLStatement;

    //----------------------
    //LTY_USER_FAVORITES
    //----------------------
    SQLStatement.query = "/*1Userfav*/""SELECT * FROM [Main].[Favorites] WHERE (? OR ID=?) AND (? OR ObjectID=?) AND (? OR UserID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_USER_FAVORITES] = SQLStatement;
    SQLStatement.query = "/*2Userfav*/""INSERT INTO [Main].[Favorites] "
                "("
                "  [ObjectID],"
                "  [ObjectType],"
                "  [LabelText],"
                "  [DescriptorText],"
                "  [Active],"
                "  [Available],"
                "  [UserID]"
                ") "
                "VALUES (?,?,?,?,?,?,?);";
    mSQLStatements[LTY_USER_FAVORITES_INSERT] = SQLStatement;
    SQLStatement.query = "/*2Userfav*/""DELETE FROM [Main].[Favorites] WHERE (? OR ObjectID=?) AND (? OR UserID=?);";
    mSQLStatements[LTY_USER_FAVORITES_DELETE] = SQLStatement;

   //----------------------
    //LTY_USERS
    //----------------------
    SQLStatement.query = "/*1User*/""SELECT * FROM [Main].[Users] WHERE (? OR ID=?) AND (? OR Active=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_USERS] = SQLStatement;
    SQLStatement.query = "/*2User*/""INSERT INTO [Main].[Users] "
                "("
                "  [ID],"
                "  [Active] "
                ") "
                "VALUES (?,?);";
    mSQLStatements[LTY_USERS_INSERT] = SQLStatement;
    SQLStatement.query = "/*3User*/""UPDATE Users SET "
                            "Active=CASE WHEN ? THEN Active ELSE ? END "
                            "WHERE (? OR ID=?);";
    mSQLStatements[LTY_USERS_UPDATE] = SQLStatement;

    SQLStatement.query = "/*4User*/""DELETE FROM [Main].[Users] WHERE (? OR ID=?) AND (? OR Active=?);";
    mSQLStatements[LTY_USERS_DELETE] = SQLStatement;

    SQLStatement.query = "/*5User*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and ( ID IN (select ObjectID from [Main].[Favorites] where (? OR UserID=?)))  and " CTY_SONG_CRITERIA" "
                         "order by title" COLLATE" limit ? offset ?) " //first ordering is important because of limit and offset
                         "order by title" COLLATE";"; //second ordering is for sorting results
    mSQLStatements[LTY_USER_FAVORITES_SONG] = SQLStatement;
    SQLStatement.query = "/*6User*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and ( ID IN (select ObjectID from [Main].[Favorites] where (? OR UserID=?))) limit ? offset ?);";
    mSQLStatements[LTY_USER_FAVORITES_SONG_COUNT] = SQLStatement;

    SQLStatement.query = "/*7User*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and ( ID IN (select ObjectID from [Main].[Favorites] where (? OR UserID=?))) and title LIKE ? "
                         "order by title" COLLATE" limit ? offset ?) " //first ordering is important because of limit and offset
                         "order by title" COLLATE";"; //second ordering is for sorting results
    mSQLStatements[LTY_USER_FAVORITES_SONG_SEARCH] = SQLStatement;

    SQLStatement.query = "/*8User*/""SELECT COUNT() from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and ( ID IN (select ObjectID from [Main].[Favorites] where (? OR UserID=?))) and title LIKE ? LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_USER_FAVORITES_SONG_SEARCH_COUNT] = SQLStatement;

    //----------------------
    //LTY_PAYLIST
    //----------------------
    SQLStatement.query = "/*84*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PLAYLIST_CRITERIA" "
                         "order by filtertag1" COLLATE" limit ? offset ?) "
        "order by filtertag1" COLLATE" ;";
    mSQLStatements[LTY_PLAYLIST] = SQLStatement;

    SQLStatement.query = "/*84fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PLAYLIST_CRITERIA" and filtertag1 LIKE ? "
                         "order by filtertag1" COLLATE" limit ? offset ?) "
        "order by filtertag1" COLLATE" ;";
    mSQLStatements[LTY_PLAYLIST_SEARCH] = SQLStatement;


    SQLStatement.query = "/*18*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PLAYLIST_CRITERIA" limit ? offset ?);";
    mSQLStatements[LTY_PLAYLIST_COUNT] = SQLStatement;

    SQLStatement.query = "/*18fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PLAYLIST_CRITERIA" and filtertag1 LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_PLAYLIST_SEARCH_COUNT] = SQLStatement;


    SQLStatement.query = "/*122*/""select InitialTitle, count() from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PLAYLIST_CRITERIA" "
                         "group by InitialTitle" COLLATE" ORDER BY InitialTitle" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_PLAYLIST_SEARCH_KEY] = SQLStatement;


    //----------------------
    //LTY_PAYLIST_INTERNAL
    //----------------------
    SQLStatement.query = "/*84a*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PLAYLIST_INTERNAL_CRITERIA" "
                         "order by filtertag1" COLLATE" limit ? offset ?) "
            "order by filtertag1" COLLATE" ;";
    mSQLStatements[LTY_PLAYLIST_INTERNAL] = SQLStatement;

    SQLStatement.query = "/*84afts*/" MEDIAOBJECT_SELECT_COLUMNS
                     "(select rowid from [Main].[MediaObjects] "
                     "where (? or deviceid=?) and " CTY_PLAYLIST_INTERNAL_CRITERIA" and filtertag1 LIKE ? "
                     "order by filtertag1" COLLATE" limit ? offset ?) "
        "order by filtertag1" COLLATE" ;";
    mSQLStatements[LTY_PLAYLIST_INTERNAL_SEARCH] = SQLStatement;


    SQLStatement.query = "/*18a*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PLAYLIST_INTERNAL_CRITERIA" limit ? offset ?);";
    mSQLStatements[LTY_PLAYLIST_INTERNAL_COUNT] = SQLStatement;

    SQLStatement.query = "/*18afts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PLAYLIST_INTERNAL_CRITERIA" and filtertag1 LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_PLAYLIST_INTERNAL_SEARCH_COUNT] = SQLStatement;


    //----------------------
    //LTY_PAYLIST_SONG
    //----------------------

    SQLStatement.query = "/*85*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PLAYLIST_ITEM_CRITERIA" and filtertag1id = ? "
                         "order by tracknumber limit ? offset ?) "
                         "order by tracknumber;";
    mSQLStatements[LTY_PLAYLIST_SONG] = SQLStatement;

    //tbd.: check if title LIKE ? is ok here or track num should be used
    SQLStatement.query = "/*85fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PLAYLIST_ITEM_CRITERIA" and filtertag1id = ? and title LIKE ? "
                         "order by tracknumber limit ? offset ?) "
                         "order by tracknumber;";
    mSQLStatements[LTY_PLAYLIST_SONG_SEARCH] = SQLStatement;


    SQLStatement.query = "/*19*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PLAYLIST_ITEM_CRITERIA" and filtertag1id = ? limit ? offset ?);";
    mSQLStatements[LTY_PLAYLIST_SONG_COUNT] = SQLStatement;

    SQLStatement.query = "/*19fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PLAYLIST_ITEM_CRITERIA" and filtertag1id = ? and title LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_PLAYLIST_SONG_SEARCH_COUNT] = SQLStatement;

    //----------------------
    //LTY_VIDEO
    //----------------------
    SQLStatement.query = "/*86*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_VIDEO_CRITERIA" "
                         "group by lowerfiltertag1" COLLATE" order by lowerfiltertag1" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag1" COLLATE" ;";
    mSQLStatements[LTY_VIDEO] = SQLStatement;

    SQLStatement.query = "/*86fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_VIDEO_CRITERIA" and filtertag1 LIKE ? "
                         "group by lowerfiltertag1" COLLATE" order by lowerfiltertag1" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag1" COLLATE" ;";
    mSQLStatements[LTY_VIDEO_SEARCH] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*20*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_VIDEO_CRITERIA" "
                         "group by lowerfiltertag1 limit ? offset ?);";
    mSQLStatements[LTY_VIDEO_COUNT] = SQLStatement;

    SQLStatement.query = "/*20fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_VIDEO_CRITERIA" and filtertag1 LIKE ? "
                         "group by lowerfiltertag1 limit ? offset ?);";
    mSQLStatements[LTY_VIDEO_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'

    //----------------------
    //LTY_VIDEO_EPISODE
    //----------------------

    SQLStatement.query = "/*87*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_VIDEO_CRITERIA" and filtertag1id = ? "
                         "order by title" COLLATE" limit ? offset ?) "
        "order by title" COLLATE" ;";
    mSQLStatements[LTY_VIDEO_EPISODE] = SQLStatement;


    SQLStatement.query = "/*87fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_VIDEO_CRITERIA" and filtertag1id = ? and title LIKE ? "
                         "order by title" COLLATE" limit ? offset ?) "
        "order by title" COLLATE" ;";
    mSQLStatements[LTY_VIDEO_EPISODE_SEARCH] = SQLStatement;


    SQLStatement.query = "/*21*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_VIDEO_CRITERIA" and filtertag1id = ? limit ? offset ?);";
    mSQLStatements[LTY_VIDEO_EPISODE_COUNT] = SQLStatement;

    SQLStatement.query = "/*21fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_VIDEO_CRITERIA" and filtertag1id = ? and title LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_VIDEO_EPISODE_SEARCH_COUNT] = SQLStatement;


    SQLStatement.query = "/*86a*/""SELECT InitialFilterTag1, count(DISTINCT FilterTag1ID) FROM [Main].[MediaObjects] "
                          "WHERE (? OR DeviceID=?) AND " CTY_VIDEO_CRITERIA" "
                          "GROUP BY InitialFilterTag1" COLLATE" ORDER BY InitialFilterTag1" COLLATE" LIMIT ? OFFSET ?;";
     mSQLStatements[LTY_VIDEO_SEARCH_KEY] = SQLStatement;

    SQLStatement.query = "/*86b*/""SELECT initialtitle, count() FROM [Main].[MediaObjects] "
                           "WHERE (? OR DeviceID=?) AND " CTY_VIDEO_CRITERIA" and  filtertag1id = ? "
                           "GROUP BY initialtitle" COLLATE" ORDER BY initialtitle" COLLATE" LIMIT ? OFFSET ?;";
     mSQLStatements[LTY_VIDEO_EPISODE_SEARCH_KEY] = SQLStatement;


    //----------------------
    //LTY_EPISODE_OF_VIDEO
    //----------------------
    SQLStatement.query = "/*87a*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_VIDEO_CRITERIA" "
                         "order by title" COLLATE" limit ? offset ?) "
                         "order by title" COLLATE" ;";
    mSQLStatements[LTY_EPISODE_OF_VIDEO] = SQLStatement;


    SQLStatement.query = "/*87afts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_VIDEO_CRITERIA" and title LIKE ? "
                         "order by title" COLLATE" limit ? offset ?) "
                         "order by title" COLLATE" ;";
    mSQLStatements[LTY_EPISODE_OF_VIDEO_SEARCH] = SQLStatement;


    SQLStatement.query = "/*21a*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_VIDEO_CRITERIA" limit ? offset ?);";
    mSQLStatements[LTY_EPISODE_OF_VIDEO_COUNT] = SQLStatement;

     SQLStatement.query = "/*21afts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_VIDEO_CRITERIA" and title LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_EPISODE_OF_VIDEO_SEARCH_COUNT] = SQLStatement;



    //----------------------
    //LTY_PODCAST
    //----------------------
    SQLStatement.query = "/*88*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PODCAST_CRITERIA" "
                         "group by lowerfiltertag1" COLLATE" order by lowerfiltertag1" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag1" COLLATE" ;";
    mSQLStatements[LTY_PODCAST] = SQLStatement;

    SQLStatement.query = "/*88fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PODCAST_CRITERIA" and filtertag1 LIKE ? "
                         "group by lowerfiltertag1" COLLATE" order by lowerfiltertag1" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag1" COLLATE" ;";
    mSQLStatements[LTY_PODCAST_SEARCH] = SQLStatement;


    SQLStatement.query = "/*22*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PODCAST_CRITERIA" "
                         "group by lowerfiltertag1 limit ? offset ?);";
    mSQLStatements[LTY_PODCAST_COUNT] = SQLStatement;


    SQLStatement.query = "/*22fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PODCAST_CRITERIA" and filtertag1 LIKE ? "
                         "group by lowerfiltertag1 limit ? offset ?);";
    mSQLStatements[LTY_PODCAST_SEARCH_COUNT] = SQLStatement;


    //----------------------
    //LTY_PODCAST_EPISODE
    //----------------------
    SQLStatement.query = "/*89*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PODCAST_CRITERIA" and filtertag1id = ? "
                         "order by title" COLLATE" limit ? offset ?) "
        "order by title" COLLATE" ;";
    mSQLStatements[LTY_PODCAST_EPISODE] = SQLStatement;


    SQLStatement.query = "/*89fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PODCAST_CRITERIA" and filtertag1id = ? and title LIKE ? "
                         "order by title" COLLATE" limit ? offset ?) "
        "order by title" COLLATE" ;";
    mSQLStatements[LTY_PODCAST_EPISODE_SEARCH] = SQLStatement;

    SQLStatement.query = "/*23*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PODCAST_CRITERIA" and filtertag1id = ? limit ? offset ?);";
    mSQLStatements[LTY_PODCAST_EPISODE_COUNT] = SQLStatement;

    SQLStatement.query = "/*23fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_PODCAST_CRITERIA" and filtertag1id = ? and title LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_PODCAST_EPISODE_SEARCH_COUNT] = SQLStatement;

    SQLStatement.query = "/*88a*/""SELECT InitialFilterTag1, count(DISTINCT FilterTag1ID) FROM [Main].[MediaObjects] "
                          "WHERE (? OR DeviceID=?) AND " CTY_PODCAST_CRITERIA" "
                          "GROUP BY InitialFilterTag1" COLLATE" ORDER BY InitialFilterTag1" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_PODCAST_SEARCH_KEY] = SQLStatement;
    SQLStatement.query = "/*88b*/""SELECT initialtitle, count() FROM [Main].[MediaObjects] "
                           "WHERE (? OR DeviceID=?) AND " CTY_PODCAST_CRITERIA" and  filtertag1id = ? "
                           "GROUP BY initialtitle" COLLATE" ORDER BY initialtitle" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_PODCAST_EPISODE_SEARCH_KEY] = SQLStatement;



    //----------------------
    //LTY_AUDIOBOOK
    //----------------------
    SQLStatement.query = "/*90*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" "
                         "group by lowerfiltertag2" COLLATE" order by lowerfiltertag2" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag2" COLLATE" ;";
    mSQLStatements[LTY_AUDIOBOOK] = SQLStatement;

    SQLStatement.query = "/*90fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" and filtertag2 LIKE ? "
                         "group by lowerfiltertag2" COLLATE" order by lowerfiltertag2" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag2" COLLATE" ;";
    mSQLStatements[LTY_AUDIOBOOK_SEARCH] = SQLStatement;


    SQLStatement.query = "/*24*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" "
                         "group by lowerfiltertag2 limit ? offset ?);";
    mSQLStatements[LTY_AUDIOBOOK_COUNT] = SQLStatement;


    SQLStatement.query = "/*24fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" and filtertag2 LIKE ? "
                         "group by lowerfiltertag2 limit ? offset ?);";
    mSQLStatements[LTY_AUDIOBOOK_SEARCH_COUNT] = SQLStatement;


    SQLStatement.query = "/*90a*/""SELECT InitialFilterTag2, count(DISTINCT FilterTag2ID) FROM [Main].[MediaObjects] "
                          "WHERE (? OR DeviceID=?) AND " CTY_AUDIOBOOK_CRITERIA" "
                          "GROUP BY InitialFilterTag2" COLLATE" ORDER BY InitialFilterTag2" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_AUDIOBOOK_SEARCH_KEY] = SQLStatement;


    //-----------------------
    //LTY_AUTHOR
    //-----------------------
    SQLStatement.query = "/*91*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" "
                         "group by lowerfiltertag1" COLLATE" order by lowerfiltertag1" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag1" COLLATE" ;";
    mSQLStatements[LTY_AUTHOR] = SQLStatement;

    SQLStatement.query = "/*91fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" and filtertag1 LIKE ? "
                         "group by lowerfiltertag1" COLLATE" order by lowerfiltertag1" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag1" COLLATE" ;";
    mSQLStatements[LTY_AUTHOR_SEARCH] = SQLStatement;


    SQLStatement.query = "/*25*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" "
                         "group by lowerfiltertag1 limit ? offset ?);";
    mSQLStatements[LTY_AUTHOR_COUNT] = SQLStatement;

    SQLStatement.query = "/*25fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" and filtertag1 LIKE ? "
                         "group by lowerfiltertag1 limit ? offset ?);";
    mSQLStatements[LTY_AUTHOR_SEARCH_COUNT] = SQLStatement;



    //-----------------------
    //LTY_BOOKTITLE_CHAPTER
    //-----------------------
    SQLStatement.query = "/*92*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" and filtertag2id = ? "
                         "order by title" COLLATE" limit ? offset ?) "
        "order by title" COLLATE" ;";
    mSQLStatements[LTY_BOOKTITLE_CHAPTER] = SQLStatement;

    SQLStatement.query = "/*92fts*/" MEDIAOBJECT_SELECT_COLUMNS
                          "(select rowid from [Main].[MediaObjects] "
                          "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" and filtertag2id = ? and title LIKE ? "
                          "order by title" COLLATE" limit ? offset ?) "
         "order by title" COLLATE" ;";
     mSQLStatements[LTY_BOOKTITLE_CHAPTER_SEARCH] = SQLStatement;


    SQLStatement.query = "/*26*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" and filtertag2id = ? limit ? offset ?);";
    mSQLStatements[LTY_BOOKTITLE_CHAPTER_COUNT] = SQLStatement;


    SQLStatement.query = "/*26fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" and filtertag2id = ? and title LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_BOOKTITLE_CHAPTER_SEARCH_COUNT] = SQLStatement;


    //-----------------------
    //LTY_AUTHOR_BOOKTITLE
    //-----------------------
    SQLStatement.query = "/*93*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" and filtertag1id = ? "
                         "group by lowerfiltertag2" COLLATE" order by lowerfiltertag2" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag2" COLLATE" ;";
    mSQLStatements[LTY_AUTHOR_BOOKTITLE] = SQLStatement;

    SQLStatement.query = "/*93fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" and filtertag1id = ? and filtertag2 LIKE ? "
                         "group by lowerfiltertag2" COLLATE" order by lowerfiltertag2" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag2" COLLATE" ;";
    mSQLStatements[LTY_AUTHOR_BOOKTITLE_SEARCH] = SQLStatement;


    SQLStatement.query = "/*27*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" and filtertag1id = ? "
                         "group by lowerfiltertag2 limit ? offset ?);";
    mSQLStatements[LTY_AUTHOR_BOOKTITLE_COUNT] = SQLStatement;


    SQLStatement.query = "/*27fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" and filtertag1id = ? and filtertag2 LIKE ? "
                         "group by lowerfiltertag2 limit ? offset ?);";
    mSQLStatements[LTY_AUTHOR_BOOKTITLE_SEARCH_COUNT] = SQLStatement;

    //-------------------------------
    //LTY_AUTHOR_BOOKTITLE_CHAPTER
    //-------------------------------

    SQLStatement.query = "/*94*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" and filtertag1id = ? and filtertag2id = ? "
                         "order by title" COLLATE" limit ? offset ?) "
        "order by title" COLLATE" ;";
    mSQLStatements[LTY_AUTHOR_BOOKTITLE_CHAPTER] = SQLStatement;

    SQLStatement.query = "/*94fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" and filtertag1id = ? and filtertag2id = ? and title LIKE ? "
                         "order by title" COLLATE" limit ? offset ?) "
        "order by title" COLLATE" ;";
    mSQLStatements[LTY_AUTHOR_BOOKTITLE_CHAPTER_SEARCH] = SQLStatement;


    SQLStatement.query = "/*28*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" and filtertag1id = ? and filtertag2id = ? limit ? offset ?);";
    mSQLStatements[LTY_AUTHOR_BOOKTITLE_CHAPTER_COUNT] = SQLStatement;


    SQLStatement.query = "/*28fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                          "where (? or deviceid=?) and " CTY_AUDIOBOOK_CRITERIA" and filtertag1id = ? and filtertag2id = ? and title LIKE ? limit ? offset ?);";
     mSQLStatements[LTY_AUTHOR_BOOKTITLE_CHAPTER_COUNT] = SQLStatement;

    //----------------------
    //LTY_GENRE
    //----------------------
    SQLStatement.query = "/*95*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" "
                         "group by lowerfiltertag1" COLLATE" order by lowerfiltertag1" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag1" COLLATE" ;";
    mSQLStatements[LTY_GENRE] = SQLStatement;


    SQLStatement.query = "/*95fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1 LIKE ? "
                         "group by lowerfiltertag1" COLLATE" order by lowerfiltertag1" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag1" COLLATE" ;";
    mSQLStatements[LTY_GENRE_SEARCH] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*29*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" "
                         "group by lowerfiltertag1" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_GENRE_COUNT] = SQLStatement;


    SQLStatement.query = "/*29fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1 LIKE ? "
                         "group by lowerfiltertag1" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_GENRE_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'


    //SQLStatement.query = "/*30*/""select InitialFilterTag1, count() from "
    //                     "(select * from [Main].[MediaObjects] "
    //                     "where (? or deviceid=?) and " CTY_SONG_CRITERIA" "
    //                     "group by InitialFilterTag1" COLLATE") "
    //                     "GROUP BY InitialFilterTag1" COLLATE" ORDER BY InitialFilterTag1" COLLATE";";
    SQLStatement.query = "/*31*/""select InitialFilterTag1, count(DISTINCT FilterTag1ID) from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" "
                         "group by InitialFilterTag1" COLLATE" ORDER BY InitialFilterTag1" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_GENRE_SEARCH_KEY] = SQLStatement;


    //-------------------------
    //LTY_IMAGE_FOLDER - fts tbd.
    //-------------------------
    SQLStatement.query = "/*154*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select MIN(rowid) from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_IMAGE_CRITERIA" "
                         "group by deviceid,path" COLLATE" order by deviceid,path" COLLATE" limit ? offset ?) "
                         "order by deviceid,path" COLLATE" ;";
    mSQLStatements[LTY_IMAGE_FOLDER] = SQLStatement;


    SQLStatement.query = "/*155*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_IMAGE_CRITERIA" "
                         "group by deviceid,path" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_IMAGE_FOLDER_COUNT] = SQLStatement;


    //-------------------------------
    //LTY_IMAGE_FOLDER_ITEM - fts tbd.
    //-------------------------------
    SQLStatement.query = "/*156*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "WHERE (? OR deviceid=?) and " CTY_IMAGE_CRITERIA" AND path=? "
                         "ORDER BY title" COLLATE" LIMIT ? OFFSET ?) "
                         "ORDER BY title" COLLATE" ;";
    mSQLStatements[LTY_IMAGE_FOLDER_ITEM] = SQLStatement;
    SQLStatement.query = "/*157*/""select categoryid,count() from (select categoryid,rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_IMAGE_CRITERIA" and path=? limit ? offset ?);";
    mSQLStatements[LTY_IMAGE_FOLDER_ITEM_COUNT] = SQLStatement;



    //-------------------------------
    //LTY_COMPILATION
    //-------------------------------
    SQLStatement.query = "/*158*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and CompilationFlag=1 "
                         "group by lowerfiltertag4" COLLATE" order by lowerfiltertag4" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag4 " COLLATE";";
    mSQLStatements[LTY_COMPILATION] = SQLStatement;

    SQLStatement.query = "/*158fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and CompilationFlag=1 and filtertag4 LIKE ? "
                         "group by lowerfiltertag4" COLLATE" order by lowerfiltertag4" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag4 " COLLATE";";
    mSQLStatements[LTY_COMPILATION_SEARCH] = SQLStatement;


    SQLStatement.query = "/*159*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and CompilationFlag=1 "
                         "group by lowerfiltertag4" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_COMPILATION_COUNT] = SQLStatement;


    SQLStatement.query = "/*159fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                          "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and CompilationFlag=1 and filtertag4 LIKE ? "
                          "group by lowerfiltertag4" COLLATE" limit ? offset ?);";
     mSQLStatements[LTY_COMPILATION_SEARCH_COUNT] = SQLStatement;

    SQLStatement.query = "/*159a*/""select InitialFilterTag4, count(DISTINCT FilterTag4ID) from [Main].[MediaObjects] "
                               "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and CompilationFlag=1 "
                               "group by InitialFilterTag4" COLLATE" ORDER BY InitialFilterTag4" COLLATE" limit ? offset ?;";
    mSQLStatements[LTY_COMPILATION_SEARCH_KEY] = SQLStatement;

    //-------------------------------
    //LTY_COMPILATION_SONG
    //-------------------------------
    SQLStatement.query = "/*160*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and CompilationFlag=1 and filtertag4id = ?"
                         "order by tracknumber,title " COLLATE" limit ? offset ?) "
                         "order by tracknumber,title" COLLATE" ;";
    mSQLStatements[LTY_COMPILATION_SONG] = SQLStatement;

    SQLStatement.query = "/*160fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and CompilationFlag=1 and filtertag4id = ? and title LIKE ? "
                         "order by tracknumber,title " COLLATE" limit ? offset ?) "
                         "order by tracknumber,title" COLLATE" ;";
    mSQLStatements[LTY_COMPILATION_SONG_SEARCH] = SQLStatement;


    SQLStatement.query = "/*161*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and CompilationFlag=1 and filtertag4id = ? limit ? offset ?);";
    mSQLStatements[LTY_COMPILATION_SONG_COUNT] = SQLStatement;

    SQLStatement.query = "/*161fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and CompilationFlag=1 and filtertag4id = ? and title LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_COMPILATION_SONG_SEARCH_COUNT] = SQLStatement;

    //------------------
    //LTY_GENRE_ALBUM
    //------------------
    SQLStatement.query = "/*96*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? "
                         "group by lowerfiltertag4" COLLATE" order by lowerfiltertag4" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag4" COLLATE" ;";
    mSQLStatements[LTY_GENRE_ALBUM] = SQLStatement;

    SQLStatement.query = "/*96fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag4 LIKE ? "
                         "group by lowerfiltertag4" COLLATE" order by lowerfiltertag4" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag4" COLLATE" ;";
    mSQLStatements[LTY_GENRE_ALBUM_SEARCH] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*32*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? "
                         "group by lowerfiltertag4" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_GENRE_ALBUM_COUNT] = SQLStatement;


    SQLStatement.query = "/*32fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                          "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag4 LIKE ? "
                          "group by lowerfiltertag4" COLLATE" limit ? offset ?);";
     mSQLStatements[LTY_GENRE_ALBUM_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'



    SQLStatement.query = "/*117*/""select InitialFilterTag4, count(DISTINCT FilterTag4ID) from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? "
                         "group by InitialFilterTag4" COLLATE" ORDER BY InitialFilterTag4" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_GENRE_ALBUM_SEARCH_KEY] = SQLStatement;


    //-----------------------
    //LTY_GENRE_ALBUM_SONG
    //-----------------------
    SQLStatement.query = "/*97*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag4id = ? "
                         "order by tracknumber,title" COLLATE" limit ? offset ?) "
        "order by tracknumber,title" COLLATE" ;";
    mSQLStatements[LTY_GENRE_ALBUM_SONG] = SQLStatement;


    SQLStatement.query = "/*97fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag4id = ? and title LIKE ? "
                         "order by tracknumber,title" COLLATE" limit ? offset ?) "
        "order by tracknumber,title" COLLATE" ;";
    mSQLStatements[LTY_GENRE_ALBUM_SONG_SEARCH] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*33*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag4id = ? limit ? offset ?);";
    mSQLStatements[LTY_GENRE_ALBUM_SONG_COUNT] = SQLStatement;


    SQLStatement.query = "/*33fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag4id = ? and title LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_GENRE_ALBUM_SONG_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'

    //-----------------
    //LTY_GENRE_SONG
    //----------------
    SQLStatement.query = "/*98*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? "
                         "order by title" COLLATE" limit ? offset ?) "
        "order by title" COLLATE" ;";
    mSQLStatements[LTY_GENRE_SONG] = SQLStatement;

    SQLStatement.query = "/*98fts*/" MEDIAOBJECT_SELECT_COLUMNS
                          "(select rowid from [Main].[MediaObjects] "
                          "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and title LIKE ? "
                          "order by title" COLLATE" limit ? offset ?) "
         "order by title" COLLATE" ;";
     mSQLStatements[LTY_GENRE_SONG_SEARCH] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*34*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? limit ? offset ?);";
    mSQLStatements[LTY_GENRE_SONG_COUNT] = SQLStatement;

    SQLStatement.query = "/*34fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                          "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and title LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_GENRE_SONG_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*35*/""select InitialTitle, count() from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? "
                         "group by InitialTitle" COLLATE" ORDER BY InitialTitle" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_GENRE_SONG_SEARCH_KEY] = SQLStatement;


    //-----------------
    //LTY_COMPOSER
    //----------------
    SQLStatement.query = "/*99*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" "
                         "group by lowerfiltertag3" COLLATE" order by lowerfiltertag3" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag3" COLLATE" ;";
    mSQLStatements[LTY_COMPOSER] = SQLStatement;

    SQLStatement.query = "/*99fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag3 LIKE ? "
                         "group by lowerfiltertag3" COLLATE" order by lowerfiltertag3" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag3" COLLATE" ;";
    mSQLStatements[LTY_COMPOSER_SEARCH] = SQLStatement;


    SQLStatement.query = "/*36*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" "
                         "group by lowerfiltertag3" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_COMPOSER_COUNT] = SQLStatement;

    SQLStatement.query = "/*36fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag3 LIKE ? "
                         "group by lowerfiltertag3" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_COMPOSER_SEARCH_COUNT] = SQLStatement;


    SQLStatement.query = "/*37*/""SELECT InitialFilterTag3, count(DISTINCT FilterTag3ID) FROM [Main].[MediaObjects] "
                         "WHERE (? OR DeviceID=?) AND " CTY_SONG_CRITERIA" "
                         "GROUP BY InitialFilterTag3" COLLATE" ORDER BY InitialFilterTag3" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_COMPOSER_SEARCH_KEY] = SQLStatement;


    //---------------------
    //LTY_COMPOSER_ALBUM
    //---------------------
    SQLStatement.query = "/*100*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag3id = ? "
                         "group by lowerfiltertag4" COLLATE" order by lowerfiltertag4" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag4" COLLATE" ;";
    mSQLStatements[LTY_COMPOSER_ALBUM] = SQLStatement;


    SQLStatement.query = "/*100fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag3id = ? and filtertag4 LIKE ? "
                         "group by lowerfiltertag4" COLLATE" order by lowerfiltertag4" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag4" COLLATE" ;";
    mSQLStatements[LTY_COMPOSER_ALBUM_SEARCH] = SQLStatement;


    SQLStatement.query = "/*38*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag3id = ? "
                         "group by lowerfiltertag4" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_COMPOSER_ALBUM_COUNT] = SQLStatement;


    SQLStatement.query = "/*38fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag3id = ? and filtertag4 LIKE ? "
                         "group by lowerfiltertag4" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_COMPOSER_ALBUM_SEARCH_COUNT] = SQLStatement;


    SQLStatement.query = "/*121*/""select InitialFilterTag4, count(DISTINCT FilterTag4ID) from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA"  and filtertag3id = ? "
                         "group by InitialFilterTag4" COLLATE" ORDER BY InitialFilterTag4" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_COMPOSER_ALBUM_SEARCH_KEY] = SQLStatement;


    //---------------------------
    //LTY_COMPOSER_ALBUM_SONG
    //---------------------------
    SQLStatement.query = "/*101*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag3id = ? and filtertag4id = ? "
                         "order by tracknumber,title" COLLATE" limit ? offset ?) "
        "order by tracknumber,title" COLLATE" ;";
    mSQLStatements[LTY_COMPOSER_ALBUM_SONG] = SQLStatement;

    SQLStatement.query = "/*101fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag3id = ? and filtertag4id = ? and title LIKE ? "
                         "order by tracknumber,title" COLLATE" limit ? offset ?) "
        "order by tracknumber,title" COLLATE" ;";
    mSQLStatements[LTY_COMPOSER_ALBUM_SONG_SEARCH] = SQLStatement;


    SQLStatement.query = "/*39*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag3id = ? and filtertag4id = ? limit ? offset ?);";
    mSQLStatements[LTY_COMPOSER_ALBUM_SONG_COUNT] = SQLStatement;

    SQLStatement.query = "/*39*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag3id = ? and filtertag4id = ? and title LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_COMPOSER_ALBUM_SONG_SEARCH_COUNT] = SQLStatement;


    //--------------------------
    //LTY_COMPOSER_ALBUM_SONG
    //--------------------------
    SQLStatement.query = "/*102*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag3id = ? "
                         "order by title" COLLATE" limit ? offset ?) "
        "order by title" COLLATE" ;";
    mSQLStatements[LTY_COMPOSER_SONG] = SQLStatement;

    SQLStatement.query = "/*102fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag3id = ? and title LIKE ? "
                         "order by title" COLLATE" limit ? offset ?) "
        "order by title" COLLATE" ;";
    mSQLStatements[LTY_COMPOSER_SONG_SEARCH] = SQLStatement;


    SQLStatement.query = "/*40*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag3id = ? limit ? offset ?);";
    mSQLStatements[LTY_COMPOSER_SONG_COUNT] = SQLStatement;


    SQLStatement.query = "/*40*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag3id = ? and title LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_COMPOSER_SONG_SEARCH_COUNT] = SQLStatement;


    SQLStatement.query = "/*120*/""select InitialTitle, count() from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA"  and filtertag3id = ? "
                         "group by InitialTitle" COLLATE" ORDER BY InitialTitle" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_COMPOSER_SONG_SEARCH_KEY] = SQLStatement;

    //---------------
    //LTY_ARTIST
    //---------------
    SQLStatement.query = "/*103*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" "
                         "group by lowerfiltertag2" COLLATE" order by lowerfiltertag2" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag2" COLLATE" ;";
    mSQLStatements[LTY_ARTIST] = SQLStatement;


    SQLStatement.query = "/*103fts*/" MEDIAOBJECT_SELECT_COLUMNS /*Roadmap 16014 Full text Search (ts)*/
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag2 LIKE ? "
                         "group by lowerfiltertag2" COLLATE" order by lowerfiltertag2" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag2" COLLATE" ;";
    mSQLStatements[LTY_ARTIST_SEARCH] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*41*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" "
                         "group by lowerfiltertag2" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_ARTIST_COUNT] = SQLStatement;


    SQLStatement.query = "/*41fts*/""select count() from (select rowid from [Main].[MediaObjects] " /*Roadmap 16014 Full text Search (ts) doe not count all but at least one*/
                            "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag2 LIKE ? "
                            "group by lowerfiltertag2" COLLATE" limit ? offset ? );";
    mSQLStatements[LTY_ARTIST_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'


    //SQLStatement.query = "/*42*/""select InitialFilterTag2, count() from "
    //                     "(select * from [Main].[MediaObjects] "
    //                     "where (? or deviceid=?) and " CTY_SONG_CRITERIA" "
    //                     "group by InitialFilterTag2" COLLATE" ) "
    //                     "GROUP BY InitialFilterTag2" COLLATE" ORDER BY InitialFilterTag2" COLLATE";";
    SQLStatement.query = "/*43*/""select InitialFilterTag2, count(DISTINCT FilterTag2ID) from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" "
                         "group by InitialFilterTag2" COLLATE" ORDER BY InitialFilterTag2" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_ARTIST_SEARCH_KEY] = SQLStatement;


    //----------------------
    //LTY_ALBUM
    //----------------------
    SQLStatement.query = "/*104*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" "
                         "group by lowerfiltertag4" COLLATE" order by lowerfiltertag4" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag4 " COLLATE";";
    mSQLStatements[LTY_ALBUM] = SQLStatement;

    SQLStatement.query = "/*104a*/""select DISTINCT FilterTag4ID FROM [Main].[MediaObjects] WHERE deviceid=? AND " CTY_SONG_CRITERIA" "
                         "ORDER BY lowerfiltertag4" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_ALBUM_POSITION] = SQLStatement;

    SQLStatement.query = "/*104fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag4 LIKE ? "
                         "group by lowerfiltertag4" COLLATE" order by lowerfiltertag4" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag4 " COLLATE";";
    mSQLStatements[LTY_ALBUM_SEARCH] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*44*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" "
                         "group by lowerfiltertag4" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_ALBUM_COUNT] = SQLStatement;

    SQLStatement.query = "/*44fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag4 LIKE ? "
                         "group by lowerfiltertag4" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_ALBUM_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*46*/""select InitialFilterTag4, count(DISTINCT FilterTag4ID) from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" "
                         "group by InitialFilterTag4" COLLATE" ORDER BY InitialFilterTag4" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_ALBUM_SEARCH_KEY] = SQLStatement;
    SQLStatement.query = "/*82*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(SELECT rowid FROM [Main].[MediaObjects] "
                         "WHERE (? OR DeviceID=?) AND " CTY_SONG_CRITERIA" AND "
                         "NOT EXISTS (SELECT 1 FROM [Main].[AlbumArts] WHERE (([Main].[AlbumArts].AlbumID = [Main].[MediaObjects].FilterTag4ID) AND ([Main].[AlbumArts].DeviceID = [Main].[MediaObjects].DeviceID))) "
                         "GROUP BY LowerFilterTag4 ORDER BY LowerFilterTag4" COLLATE" LIMIT ? OFFSET ?) "
                         "ORDER BY LowerFilterTag4 " COLLATE";";
    mSQLStatements[LTY_ALBUM_UNKNOWN_ALBUMART] = SQLStatement;
    SQLStatement.query = "/*82a*/""SELECT COUNT() FROM (SELECT rowid FROM [Main].[MediaObjects] "
                         "WHERE (? OR DeviceID=?) and " CTY_SONG_CRITERIA" AND "
                         "NOT EXISTS (SELECT 1 FROM [Main].[AlbumArts] WHERE (([Main].[AlbumArts].AlbumID = [Main].[MediaObjects].FilterTag4ID) AND ([Main].[AlbumArts].DeviceID = [Main].[MediaObjects].DeviceID))) "
                         "GROUP BY LowerFilterTag4" COLLATE" LIMIT ? OFFSET ?);";
    mSQLStatements[LTY_ALBUM_UNKNOWN_ALBUMART_COUNT] = SQLStatement;

//----------------------
    //LTY_YEAR
    //----------------------

    SQLStatement.query = "/*333a*/" MEDIAOBJECT_SELECT_COLUMNS
                           "(select rowid from [Main].[MediaObjects] "
                           "where (? or deviceid=?) and " CTY_SONG_CRITERIA" "
                           "group by Year order by Year ASC limit ? offset ?) "
                           "order by Year ASC;";
      mSQLStatements[LTY_YEAR] = SQLStatement;


    SQLStatement.query = "/*333b*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" "
                         "group by Year  limit ? offset ?);";
    mSQLStatements[LTY_YEAR_COUNT] = SQLStatement;

// LTY_YEAR_ALBUM
    SQLStatement.query = "/*333c*/" MEDIAOBJECT_SELECT_COLUMNS
                           "(select rowid from [Main].[MediaObjects] "
                           "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and YearID = ? "
                    "group by lowerfiltertag4 " COLLATE" order by lowerfiltertag4 " COLLATE" limit ? offset ?) "
                           "order by lowerfiltertag4" COLLATE" ;";
      mSQLStatements[LTY_YEAR_ALBUM] = SQLStatement;


      SQLStatement.query = "/*333d*/""select count() from (select rowid from [Main].[MediaObjects] "
                           "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and YearID = ? "
                           "group by lowerfiltertag4" COLLATE" limit ? offset ?);";
      mSQLStatements[LTY_YEAR_ALBUM_COUNT] = SQLStatement;


      SQLStatement.query = "/*333e*/" MEDIAOBJECT_SELECT_COLUMNS
                   "(select rowid from [Main].[MediaObjects] "
                   "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and YearID = ? and filtertag4 LIKE ? "
                   "group by lowerfiltertag4" COLLATE" order by lowerfiltertag4" COLLATE" limit ? offset ?) "
                   "order by lowerfiltertag4" COLLATE" ;";
      mSQLStatements[LTY_YEAR_ALBUM_SEARCH] = SQLStatement;//Roadmap 160014 'full text search'


      SQLStatement.query = "/*333f*/""select count() from (select rowid from [Main].[MediaObjects] "
                    "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and YearID = ? and filtertag4 LIKE ? "
                    "group by lowerfiltertag4" COLLATE" limit ? offset ?);";
      mSQLStatements[LTY_YEAR_ALBUM_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'

      SQLStatement.query = "/*333g*/""select InitialFilterTag4, count(DISTINCT FilterTag4ID) from [Main].[MediaObjects] "
                           "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and YearID = ? "
                           "group by InitialFilterTag4" COLLATE" ORDER BY InitialFilterTag4" COLLATE" LIMIT ? OFFSET ?;";
      mSQLStatements[LTY_YEAR_ALBUM_SEARCH_KEY] = SQLStatement;

      //LTY_YEAR_ALBUM_SONG
      SQLStatement.query = "/*333h*/" MEDIAOBJECT_SELECT_COLUMNS
                           "(select rowid from [Main].[MediaObjects] "
                           "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and YearID = ? and filtertag4id = ? "
                           "order by tracknumber,title" COLLATE" limit ? offset ?) "
          "order by tracknumber,title" COLLATE" ;";
      mSQLStatements[LTY_YEAR_ALBUM_SONG] = SQLStatement;

      SQLStatement.query = "/*333i*/" MEDIAOBJECT_SELECT_COLUMNS
                           "(select rowid from [Main].[MediaObjects] "
                           "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and YearID = ? and filtertag4id = ? and title LIKE ? "
                           "order by tracknumber,title" COLLATE" limit ? offset ?) "
          "order by tracknumber,title" COLLATE" ;";
      mSQLStatements[LTY_YEAR_ALBUM_SONG_SEARCH] = SQLStatement;


      SQLStatement.query = "/*333j*/""select count() from (select rowid from [Main].[MediaObjects] "
                           "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and YearID = ? and filtertag4id = ? limit ? offset ?);";
      mSQLStatements[LTY_YEAR_ALBUM_SONG_COUNT] = SQLStatement;

      SQLStatement.query = "/*333k*/""select count() from (select rowid from [Main].[MediaObjects] "
                           "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and YearID = ? and filtertag4id = ? and title LIKE ? limit ? offset ?);";
      mSQLStatements[LTY_YEAR_ALBUM_SONG_SEARCH_COUNT] = SQLStatement;

    //-----------------
    //LTY_GENRE_ARTIST
    //-----------------
    SQLStatement.query = "/*105*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? "
                         "group by lowerfiltertag2" COLLATE" order by lowerfiltertag2" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag2" COLLATE" ;";
    mSQLStatements[LTY_GENRE_ARTIST] = SQLStatement;

    SQLStatement.query = "/*105fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag2 LIKE ? "
                         "group by lowerfiltertag2" COLLATE" order by lowerfiltertag2" COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag2" COLLATE" ;";
    mSQLStatements[LTY_GENRE_ARTIST_SEARCH] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*47*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? "
                         "group by lowerfiltertag2" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_GENRE_ARTIST_COUNT] = SQLStatement;

    SQLStatement.query = "/*47fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag2 LIKE? "
                         "group by lowerfiltertag2" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_GENRE_ARTIST_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*114*/""select InitialFilterTag2, count(DISTINCT FilterTag2ID) from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA"  and filtertag1id = ? "
                         "group by InitialFilterTag2" COLLATE" ORDER BY InitialFilterTag2" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_GENRE_ARTIST_SEARCH_KEY] = SQLStatement;

    //-------------------------------
    //LTY_GENRE_ARTIST_ALBUM
    //-------------------------------
    SQLStatement.query = "/*106*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag2id = ?"
                  "group by lowerfiltertag4 " COLLATE" order by lowerfiltertag4 " COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag4" COLLATE" ;";
    mSQLStatements[LTY_GENRE_ARTIST_ALBUM] = SQLStatement;

    SQLStatement.query = "/*106fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag2id = ? and filtertag4 LIKE ? "
                  "group by lowerfiltertag4 " COLLATE" order by lowerfiltertag4 " COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag4" COLLATE" ;";
    mSQLStatements[LTY_GENRE_ARTIST_ALBUM_SEARCH] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*48*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag2id = ? "
                         "group by lowerfiltertag4" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_GENRE_ARTIST_ALBUM_COUNT] = SQLStatement;

    SQLStatement.query = "/*48fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                           "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag2id = ? and filtertag4 LIKE ? "
                           "group by lowerfiltertag4" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_GENRE_ARTIST_ALBUM_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'



    SQLStatement.query = "/*115*/""select InitialFilterTag4, count(DISTINCT FilterTag3ID) from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag2id = ? "
                         "group by InitialFilterTag4" COLLATE" ORDER BY InitialFilterTag4" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_GENRE_ARTIST_ALBUM_SEARCH_KEY] = SQLStatement;

    //-------------------------------
    //LTY_GENRE_ARTIST_ALBUM
    //-------------------------------
    SQLStatement.query = "/*107*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag2id = ? and filtertag4id = ? "
                  "order by tracknumber,title " COLLATE" limit ? offset ?) "
        "order by tracknumber,title" COLLATE" ;";
    mSQLStatements[LTY_GENRE_ARTIST_ALBUM_SONG] = SQLStatement;

    SQLStatement.query = "/*107fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag2id = ? and filtertag4id = ? and title LIKE ? "
                  "order by tracknumber,title " COLLATE" limit ? offset ?) "
        "order by tracknumber,title" COLLATE" ;";
    mSQLStatements[LTY_GENRE_ARTIST_ALBUM_SONG_SEARCH] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*49*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag2id = ? and filtertag4id = ? limit ? offset ?);";
    mSQLStatements[LTY_GENRE_ARTIST_ALBUM_SONG_COUNT] = SQLStatement;

    SQLStatement.query = "/*49fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag2id = ? and filtertag4id = ? and title LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_GENRE_ARTIST_ALBUM_SONG_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'


    //---------------------------
    //LTY_GENRE_ARTIST_SONG
    //---------------------------
    SQLStatement.query = "/*108*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag2id = ? "
                  "order by title " COLLATE" limit ? offset ?) "
        "order by title" COLLATE" ;";
    mSQLStatements[LTY_GENRE_ARTIST_SONG] = SQLStatement;

    SQLStatement.query = "/*108fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag2id = ? and title LIKE ? "
                  "order by title " COLLATE" limit ? offset ?) "
        "order by title" COLLATE" ;";
    mSQLStatements[LTY_GENRE_ARTIST_SONG_SEARCH] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*50*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag2id = ? limit ? offset ?);";
    mSQLStatements[LTY_GENRE_ARTIST_SONG_COUNT] = SQLStatement;

    SQLStatement.query = "/*50fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag2id = ? and title LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_GENRE_ARTIST_SONG_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*116*/""select InitialTitle, count() from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag1id = ? and filtertag2id = ? "
                         "group by InitialTitle" COLLATE" ORDER BY InitialTitle" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_GENRE_ARTIST_SONG_SEARCH_KEY] = SQLStatement;

    //-------------------
    //LTY_ARTIST_ALBUM
    //-------------------
    SQLStatement.query = "/*109*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag2id = ? "
                  "group by lowerfiltertag4 " COLLATE" order by lowerfiltertag4 " COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag4" COLLATE" ;";
    mSQLStatements[LTY_ARTIST_ALBUM] = SQLStatement;

    SQLStatement.query = "/*109fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag2id = ? and filtertag4 LIKE ? "
                  "group by lowerfiltertag4 " COLLATE" order by lowerfiltertag4 " COLLATE" limit ? offset ?) "
                         "order by lowerfiltertag4" COLLATE" ;";
    mSQLStatements[LTY_ARTIST_ALBUM_SEARCH] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*51*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag2id = ? "
                         "group by lowerfiltertag4" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_ARTIST_ALBUM_COUNT] = SQLStatement;


    SQLStatement.query = "/*51fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag2id = ? and filtertag4 LIKE ? "
                         "group by lowerfiltertag4" COLLATE" limit ? offset ?);";
    mSQLStatements[LTY_ARTIST_ALBUM_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'

    SQLStatement.query = "/*118*/""select InitialFilterTag4, count(DISTINCT FilterTag4ID) from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag2id = ? "
                         "group by InitialFilterTag4" COLLATE" ORDER BY InitialFilterTag4" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_ARTIST_ALBUM_SEARCH_KEY] = SQLStatement;

    //-------------------
    //LTY_ARTIST_ALBUM
    //-------------------
    SQLStatement.query = "/*110*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag2id = ? and filtertag4id = ? "
                  "order by tracknumber,title " COLLATE" limit ? offset ?) "
        "order by tracknumber,title" COLLATE" ;";
    mSQLStatements[LTY_ARTIST_ALBUM_SONG] = SQLStatement;

    SQLStatement.query = "/*110fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag2id = ? and filtertag4id = ? and filtertag4 LIKE ? "
                  "order by tracknumber,title " COLLATE" limit ? offset ?) "
        "order by tracknumber,title" COLLATE" ;";
    mSQLStatements[LTY_ARTIST_ALBUM_SONG_SEARCH] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*52*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag2id = ? and filtertag4id = ? limit ? offset ?);";
    mSQLStatements[LTY_ARTIST_ALBUM_SONG_COUNT] = SQLStatement;

    SQLStatement.query = "/*52fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag2id = ? and filtertag4id = ? and filtertag4 LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_ARTIST_ALBUM_SONG_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'

    //-----------------
    //LTY_ARTIST_SONG
    //-----------------
    SQLStatement.query = "/*111*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag2id = ? "
              "order by title " COLLATE" limit ? offset ?) "
        "order by title" COLLATE" ;";
    mSQLStatements[LTY_ARTIST_SONG] = SQLStatement;

    SQLStatement.query = "/*111fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag2id = ? and title LIKE ? "
              "order by title " COLLATE" limit ? offset ?) "
        "order by title" COLLATE" ;";
    mSQLStatements[LTY_ARTIST_SONG_SEARCH] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*53*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag2id = ? limit ? offset ?);";
    mSQLStatements[LTY_ARTIST_SONG_COUNT] = SQLStatement;

    SQLStatement.query = "/*53fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag2id = ? and title LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_ARTIST_SONG_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*119*/""select InitialTitle, count() from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag2id = ? "
                         "group by InitialTitle" COLLATE" ORDER BY InitialTitle" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_ARTIST_SONG_SEARCH_KEY] = SQLStatement;

    //----------------
    //LTY_ALBUM_SONG
    //----------------
    SQLStatement.query = "/*112*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag4id = ? "
                  "order by tracknumber,title " COLLATE" limit ? offset ?) "
        "order by tracknumber,title" COLLATE" ;";
    mSQLStatements[LTY_ALBUM_SONG] = SQLStatement;

    SQLStatement.query = "/*112fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag4id = ? and title LIKE ? "
                  "order by tracknumber,title " COLLATE" limit ? offset ?) "
        "order by tracknumber,title" COLLATE" ;";
    mSQLStatements[LTY_ALBUM_SONG_SEARCH] = SQLStatement;//Roadmap 160014 'full text search'


    SQLStatement.query = "/*54*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag4id = ? limit ? offset ?);";
    mSQLStatements[LTY_ALBUM_SONG_COUNT] = SQLStatement;

    SQLStatement.query = "/*54fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_SONG_CRITERIA" and filtertag4id = ? and title LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_ALBUM_SONG_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'

    /*
     * Device table
     * */
    SQLStatement.query = "/*55*/""SELECT * FROM Devices WHERE (? OR ID=?) AND (? OR ConnectionState=?) AND (? OR SerialNumber=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_DEVICES] = SQLStatement;
    SQLStatement.query = "/*56*/""SELECT COUNT() FROM Devices WHERE (? OR ID=?) AND (? OR ConnectionState=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_DEVICES_COUNT] = SQLStatement;
    SQLStatement.query = "/*57*/""INSERT OR REPLACE INTO [Main].[Devices] "
            "("
            "  [ID],"
            "  [UUID],"
            "  [SerialNumber],"
            "  [FirmwareVersion],"
            "  [FriendlyName],"
            "  [MountPoint],"
            "  [DeviceType],"
            "  [DiscType],"
            "  [ConnectionState],"
            "  [AudioInputDevice],"
            "  [FileSystemType],"
            "  [PartitionNumber],"
            "  [TotalSize],"
            "  [FreeSize],"
            "  [ProductID],"
            "  [ConnectionType],"
            "  [DeviceState],"
            "  [AppleDeviceMACAddress]"
            ") "
            "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
    mSQLStatements[LTY_DEVICES_INSERT] = SQLStatement;

    SQLStatement.query = "/*58*/""UPDATE Devices SET "
                         "FirmwareVersion=CASE WHEN ? THEN FirmwareVersion ELSE ? END,"
                         "FriendlyName=CASE WHEN ? THEN FriendlyName ELSE ? END,"
                         "CheckSum=CASE WHEN ? THEN CheckSum ELSE ? END,"
                         "Active=CASE WHEN ? THEN Active ELSE ? END,"
                         "RepeatMode=CASE WHEN ? THEN RepeatMode ELSE ? END,"
                         "PlaybackMode=CASE WHEN ? THEN PlaybackMode ELSE ? END,"
                         "DeviceType=CASE WHEN ? THEN DeviceType ELSE ? END,"
                         "DiscType=CASE WHEN ? THEN DiscType ELSE ? END,"
                         "IndexingState=CASE WHEN ? THEN IndexingState ELSE ? END,"
                         "ConnectionState=CASE WHEN ? THEN ConnectionState ELSE ? END,"
                         "IndexingProgress=CASE WHEN ? THEN IndexingProgress ELSE ? END, "
                         "FormerConnectionState=CASE WHEN ? THEN FormerConnectionState ELSE ? END, "
                         "AudioInputDevice=CASE WHEN ? THEN AudioInputDevice ELSE ? END, "
                         "MountPoint=CASE WHEN ? THEN MountPoint ELSE ? END, "
                         "DeviceState=CASE WHEN ? THEN DeviceState ELSE ? END, "
                         "NumberOfAudioFiles=CASE WHEN ? THEN NumberOfAudioFiles ELSE ? END, "
                         "NumberOfVideoFiles=CASE WHEN ? THEN NumberOfVideoFiles ELSE ? END, "
                         "NumberOfImageFiles=CASE WHEN ? THEN NumberOfImageFiles ELSE ? END, "
                         "DiPOCapable=CASE WHEN ? THEN DiPOCapable ELSE ? END, "
                         "DiPOActive=CASE WHEN ? THEN DiPOActive ELSE ? END, "
                         "DiPOVersion=CASE WHEN ? THEN DiPOVersion ELSE ? END, "
                         "ConnectionType=CASE WHEN ? THEN ConnectionType ELSE ? END, "
                         "DisconnectReason=CASE WHEN ? THEN DisconnectReason ELSE ? END, "
                         "IsShuffleSupported=CASE WHEN ? THEN IsShuffleSupported ELSE ? END, "
                         "IsRepeatSupported=CASE WHEN ? THEN IsRepeatSupported ELSE ? END, "
                         "AlbumArtIndexingComplete=CASE WHEN ? THEN AlbumArtIndexingComplete ELSE ? END, "
                         "IsNowPlayingListAvailable=CASE WHEN ? THEN IsNowPlayingListAvailable ELSE ? END, "
                         "DeviceUUID=CASE WHEN ? THEN DeviceUUID ELSE ? END, "
                         "AppleDeviceMACAddress=CASE WHEN ? THEN AppleDeviceMACAddress ELSE ? END, "
                         "AppleDeviceUSBSerial=CASE WHEN ? THEN AppleDeviceUSBSerial ELSE ? END, "
                         "TotalSize=CASE WHEN ? THEN TotalSize ELSE ? END, "
                         "FreeSize=CASE WHEN ? THEN FreeSize ELSE ? END, "
                         "VideoRepeatMode=CASE WHEN ? THEN VideoRepeatMode ELSE ? END "
                         "WHERE (? OR ID=?);";
    mSQLStatements[LTY_DEVICES_UPDATE] = SQLStatement;

    SQLStatement.query = "/*58a*/""UPDATE Devices SET DeviceState=6 WHERE (ID=? AND ConnectionState=0 AND ConnectionCount=?);";
    mSQLStatements[LTY_DEVICES_UPDATE_COMMUNICATION_ERROR] = SQLStatement;

    SQLStatement.query = "/*58b*/""UPDATE Devices SET ConnectionState=2,FormerConnectionState=2,DeviceState=0,DisconnectReason=0 WHERE (ID=? AND (DeviceState = 6));";
    mSQLStatements[LTY_DEVICES_UPDATE_DEVICE_DISCONNECTED_IN_COMMUNICATION_ERROR] = SQLStatement;

    SQLStatement.query = "/*58c*/""UPDATE Devices SET "
                         "PlaybackMode=CASE WHEN ? THEN PlaybackMode ELSE ? END,"
                         "VideoPlaybackMode=CASE WHEN ? THEN VideoPlaybackMode ELSE ? END "
                         "WHERE (? OR ID=?);";
    mSQLStatements[LTY_DEVICES_UPDATE_PLAYBACKMODE] = SQLStatement;

    SQLStatement.query = "/*59*/""DELETE FROM Devices WHERE (? OR ID=?);";
    mSQLStatements[LTY_DEVICES_DELETE] = SQLStatement;
    /* oldest device , check for device id > 1 , DeviceId 0 is reserved for MyMedia and deviceId 1 is reserved for Musicbox */
    SQLStatement.query = "/*60*/""SELECT * FROM Devices WHERE (ID > 1) AND (ConnectionState = 2) ORDER BY LastConnected;";
    mSQLStatements[LTY_DEVICES_OLDEST] = SQLStatement;

    SQLStatement.query = "/*60a*/""SELECT ID FROM Devices WHERE (? OR DeviceType =?) AND (ConnectionState = 2) ORDER BY LastConnected DESC;";
    mSQLStatements[LTY_LATEST_DISC_EJECTED] = SQLStatement;

    SQLStatement.query = "/*61*/""SELECT SerialNumber, ConnectionState FROM Devices WHERE (? OR ID = ?) AND (? OR SerialNumber LIKE ?) ORDER BY LastConnected DESC LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_DEVICES_LATEST_VALID_PARTITION] = SQLStatement;

    /*
     * Virtual device table
     */
    SQLStatement.query = "/*132*/""SELECT * FROM VirtualDevices WHERE (? OR ID=?) AND (? OR ConnectionState=?) AND (? OR SerialNumber=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_VIRTUAL_DEVICES] = SQLStatement;
    SQLStatement.query = "/*133*/""DELETE FROM VirtualDevices WHERE (? OR ID=?);";
    mSQLStatements[LTY_VIRTUAL_DEVICES_DELETE] = SQLStatement;

    /*
     * ipod vt
     */
    // not song list compatible SQLStatement.query = "/*61*/""SELECT ID, LTY, tag1, tag2, tag3, count, name, url, rowid from IPOD "
    //                     "where (? OR ?) AND mountpoint = ? AND LTY = ? AND tag1 = ? AND tag2 = ? AND tag3 = ?;";
    SQLStatement.query = "/*62*/""SELECT id,name,url,uuid,active,tracknumber from IPOD "
                         "where (? OR ?) AND mountpoint = ? AND LTY = ? AND tag1 = ? AND tag2 = ? AND tag3 = ? AND tag4 = ? AND _LIMIT=? AND _OFFSET=?;";
    mSQLStatements[LTY_IPOD_ACCESS] = SQLStatement;
    SQLStatement.query = "/*63*/""SELECT count from IPOD "
                         "where (? OR ?) AND mountpoint = ? AND LTY = ? AND tag1 = ? AND tag2 = ? AND tag3 = ? AND tag4 = ? AND _LIMIT=? AND _OFFSET=?;";
    mSQLStatements[LTY_IPOD_ACCESS_COUNT] = SQLStatement;

    /*
     * file vt
     */
    SQLStatement.query = "/*67*/""SELECT rowid,mountpoint,path,filename,type,format FROM [Main].[File] "
                         "WHERE (? OR ?) AND mountpoint MATCH ? AND path MATCH ? AND (? OR type IN (?,?,?,?,?)) "
                         "ORDER BY type,filename" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_FILELIST] = SQLStatement;

    SQLStatement.query = "/*45a*/""SELECT rowid,mountpoint,path,filename,type,format FROM [Main].[File] "
                         "WHERE (? OR ?) AND mountpoint MATCH ? AND path MATCH ? AND (? OR type IN (?,?,?,?,?)) "
                         "ORDER BY type DESC,filename" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_FILELIST_SORTED_FOR_INDEXING] = SQLStatement;

    SQLStatement.query = "/*45b*/""SELECT rowid,mountpoint,path,filename,type,format FROM [Main].[File] "
                         "WHERE (? OR ?) AND mountpoint MATCH ? AND path MATCH ? AND type < ? LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_FILELIST_UNSORTED] = SQLStatement;
    SQLStatement.query = "/*68*/""SELECT rowid,mountpoint,path,filename,type,format FROM [Main].[File] "
                         "WHERE (? OR ?) AND mountpoint MATCH ? AND path MATCH ? AND type IN (?,?,?) "
                         "ORDER BY " FT_SORT_PLAYING",filename" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_FILELIST_MEDIAOBJECTS] = SQLStatement;
    SQLStatement.query = "/*69*/""SELECT rowid,mountpoint,path,filename,type,format FROM [Main].[File] "
                         "WHERE (? OR ?) AND mountpoint MATCH ? AND path MATCH ? AND type IN (?,?) "
                         "ORDER BY path" COLLATE"," FT_SORT_PLAYING",filename" COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_FILELIST_MEDIAOBJECTS_WITH_SUBFOLDERS] = SQLStatement;

    SQLStatement.query = "/*67a*/""SELECT type,COUNT() FROM [Main].[File] "
                         "WHERE (? OR ?) AND mountpoint MATCH ? AND path MATCH ? "
                         "GROUP BY type LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_FILELIST_COUNT] = SQLStatement;
    SQLStatement.query = "/*68a*/""SELECT type,COUNT() FROM [Main].[File] "
                         "WHERE (? OR ?) AND mountpoint MATCH ? AND path MATCH ? AND type IN (?,?,?) "
                         "GROUP BY type LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_FILELIST_MEDIAOBJECTS_COUNT] = SQLStatement;
    SQLStatement.query = "/*69a*/""SELECT type,COUNT() FROM [Main].[File] "
                         "WHERE (? OR ?) AND mountpoint MATCH ? AND path MATCH ? AND type IN (?,?) "
                         "GROUP BY type LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_FILELIST_MEDIAOBJECTS_COUNT_WITH_SUBFOLDERS] = SQLStatement;

    /*
    * browse list
    */
#define FILTER_FILE_LIST_VIA_CTY 0 // Attention! same switch as in DBManager.cpp
#define NO_FOLDER_HIERARCHY 0 // Attention! same switch as in DBManager.cpp

    SQLStatement.query = "/*113*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(SELECT rowid FROM [Main].[MediaObjects] "
#if FILTER_FILE_LIST_VIA_CTY
                         "WHERE (? OR deviceid=?) AND path=? AND (? OR categoryid IN (?,?,?,?,?)) "
#else
                         "WHERE (? OR deviceid=?) AND path=? AND (? OR mediacontent&?) "
#endif // #if FILTER_FILE_LIST_VIA_CTY
                         "ORDER BY " CTY_SORT_BROWSING",url" COLLATE" LIMIT ? OFFSET ?) "
                         "ORDER BY " CTY_SORT_BROWSING",url" COLLATE";";
    mSQLStatements[LTY_BROWSELIST] = SQLStatement;

    SQLStatement.query = "/*123*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(SELECT rowid FROM [Main].[MediaObjects] "
#if FILTER_FILE_LIST_VIA_CTY
                         "WHERE (? OR deviceid=?) AND path=? AND categoryid IN (?,?,?) "
#else
                         "WHERE (? OR deviceid=?) AND path=? AND mediacontent&? "
#endif // #if FILTER_FILE_LIST_VIA_CTY
                         "ORDER BY categoryid,url" COLLATE" LIMIT ? OFFSET ?) "
                         "ORDER BY categoryid,url" COLLATE";";
    mSQLStatements[LTY_BROWSELIST_MEDIAOBJECTS] = SQLStatement;

#if NO_FOLDER_HIERARCHY
    SQLStatement.query = "/*124*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(SELECT rowid FROM [Main].[MediaObjects] "
                         "WHERE (? OR deviceid=?) AND (? OR substr(path,1,?)=?) AND categoryid IN (?,?) "
                         "ORDER BY path" COLLATE",categoryid,url" COLLATE" LIMIT ? OFFSET ?) "
                         "ORDER BY path" COLLATE",categoryid,url" COLLATE";";
    mSQLStatements[LTY_BROWSELIST_MEDIAOBJECTS_WITH_SUBFOLDERS] = SQLStatement;
#else
    SQLStatement.query = "/*124*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(SELECT [Main].[MediaObjects].rowid FROM [Main].[FolderHierarchy] JOIN [Main].[MediaObjects] "
                         "ON ([Main].[FolderHierarchy].childid = [Main].[MediaObjects].folderid) "
                         "WHERE ([Main].[FolderHierarchy].parentid = (SELECT [Main].[FolderHierarchy].parentid FROM [Main].[FolderHierarchy] WHERE (? OR deviceid=?) AND ([Main].[FolderHierarchy].name = ?))) "
                         "AND ([Main].[MediaObjects].categoryid IN (?,?)) "
                         "ORDER BY path" COLLATE",categoryid,url" COLLATE" LIMIT ? OFFSET ?) "
                         "ORDER BY path" COLLATE",categoryid,url" COLLATE";";
    mSQLStatements[LTY_BROWSELIST_MEDIAOBJECTS_WITH_SUBFOLDERS] = SQLStatement;
#endif // #if NO_FOLDER_HIERARCHY

    SQLStatement.query = "/*125*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(SELECT rowid FROM [Main].[MediaObjects] "
                         "WHERE (? OR deviceid=?) AND categoryid IN (?,?) "
                         "ORDER BY path" COLLATE",categoryid,url" COLLATE" LIMIT ? OFFSET ?) "
                         "ORDER BY path" COLLATE",categoryid,url" COLLATE";";
    mSQLStatements[LTY_BROWSELIST_MEDIAOBJECTS_ALL] = SQLStatement;

    SQLStatement.query = "/*113a*/""SELECT categoryid,COUNT() FROM [Main].[MediaObjects] "
#if FILTER_FILE_LIST_VIA_CTY
                         "WHERE (? OR deviceid=?) AND path=? AND (? OR categoryid IN (?,?,?,?,?)) "
#else
                         "WHERE (? OR deviceid=?) AND path=? AND (? OR mediacontent&?) "
#endif // #if FILTER_FILE_LIST_VIA_CTY
                         "GROUP BY categoryid LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_BROWSELIST_COUNT] = SQLStatement;

    SQLStatement.query = "/*123a*/""SELECT categoryid,COUNT() FROM [Main].[MediaObjects] "
#if FILTER_FILE_LIST_VIA_CTY
                         "WHERE (? OR deviceid=?) AND path=? AND categoryid IN (?,?,?) "
#else
                         "WHERE (? OR deviceid=?) AND path=? AND mediacontent&? "
#endif // #if FILTER_FILE_LIST_VIA_CTY
                         "GROUP BY categoryid LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_BROWSELIST_MEDIAOBJECTS_COUNT] = SQLStatement;

#if NO_FOLDER_HIERARCHY
    SQLStatement.query = "/*124a*/""SELECT categoryid,COUNT() FROM [Main].[MediaObjects] "
                         "WHERE (? OR deviceid=?) AND (? OR substr(path,1,?)=?) AND categoryid IN (?,?) "
                         "GROUP BY categoryid LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_BROWSELIST_MEDIAOBJECTS_COUNT_WITH_SUBFOLDERS] = SQLStatement;
#else
    SQLStatement.query = "/*124a*/""SELECT categoryid,COUNT() FROM [Main].[FolderHierarchy] JOIN [Main].[MediaObjects] "
                         "ON ([Main].[FolderHierarchy].childid = [Main].[MediaObjects].folderid) "
                         "WHERE ([Main].[FolderHierarchy].parentid = (SELECT [Main].[FolderHierarchy].parentid FROM [Main].[FolderHierarchy] WHERE (? OR deviceid=?) AND ([Main].[FolderHierarchy].name = ?))) "
                         "AND ([Main].[MediaObjects].categoryid IN (?,?)) "
                         "GROUP BY categoryid LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_BROWSELIST_MEDIAOBJECTS_COUNT_WITH_SUBFOLDERS] = SQLStatement;
#endif // #if NO_FOLDER_HIERARCHY

    SQLStatement.query = "/*125a*/""SELECT categoryid,COUNT() FROM [Main].[MediaObjects] "
                         "WHERE (? OR deviceid=?) AND categoryid IN (?,?) "
                         "GROUP BY categoryid LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_BROWSELIST_MEDIAOBJECTS_COUNT_ALL] = SQLStatement;

    /*
    * Album Art:
    */
    SQLStatement.query = "/*162*/""INSERT OR REPLACE INTO AlbumArts "
                         "("
                         "  [DeviceID],"
                         "  [AlbumID],"
                         "  [Title],"
                         "  [CoverArtPath],"
                         "  [Thumbnail],"
                         "  [LastModifiedTime]"
                         ") "
                         "VALUES (?,?,?,?,?,?);";
    mSQLStatements[LTY_ALBUMART_INSERT] = SQLStatement;
    SQLStatement.query = "/*163*/""DELETE FROM AlbumArts WHERE (? OR DeviceID=?);";
    mSQLStatements[LTY_ALBUMART_DELETE] = SQLStatement;
    SQLStatement.query = "/*164*/""SELECT DeviceID,AlbumID,Title,CoverArtPath,Thumbnail,LastModifiedTime FROM AlbumArts WHERE (? OR DeviceID=?) AND (? OR AlbumID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_ALBUMART] = SQLStatement;
    SQLStatement.query = "/*164a*/""SELECT CoverArtPath FROM AlbumArts WHERE (? OR DeviceID=?) AND AlbumID IN (SELECT FilterTag4ID FROM [Main].[MediaObjects] "
                         "WHERE (? OR ID=?)) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_ALBUMART_COVERARTPATH_OBJECTID_FILTER] = SQLStatement;

    /*
     * System:
     */
    SQLStatement.query = "/*64*/""INSERT OR REPLACE INTO System (BTMacAddress) VALUES(?);";
    mSQLStatements[LTY_SYSTEM_INSERT] = SQLStatement;
    SQLStatement.query = "/*65*/""SELECT BTMacAddress FROM System WHERE (? OR ?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_SYSTEM] = SQLStatement;

    /*
     * Last Mode:
     */
    SQLStatement.query = "/*66*/""INSERT OR REPLACE INTO LastMode "
                         "("
                         "  [DeviceID],"
                         "  [ListType],"
                         "  [PlayContinuation],"
                         "  [Tag1],"
                         "  [Tag2],"
                         "  [Tag3],"
                         "  [Tag4],"
                         "  [PlayTime],"
                         "  [CurrentObject],"
                         "  [CurrentRow],"
                         "  [Active],"
                         "  [Path],"
                         "  [Streaming],"
                          " [MediaContext]"
                         ") "
                         "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
    mSQLStatements[LTY_LASTMODE_INSERT] = SQLStatement;
    SQLStatement.query = "/*70*/""SELECT * FROM LastMode WHERE (? OR DeviceID=?) AND (? OR Active=?) AND (? OR MediaContext=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_LASTMODE] = SQLStatement;
    SQLStatement.query = "/*71*/""UPDATE LastMode SET Active=CASE WHEN ? THEN Active ELSE ? END WHERE (? OR DeviceID=?);";
    mSQLStatements[LTY_LASTMODE_UPDATE] = SQLStatement;
    SQLStatement.query = "/*72*/""DELETE FROM LastMode WHERE (? OR DeviceID=?) AND (? OR MediaContext=?);";
    mSQLStatements[LTY_LASTMODE_DELETE] = SQLStatement;

    SQLStatement.query = "/*66a*/""INSERT OR REPLACE INTO LastPlaytimes (ObjectID,ElapsedPlaytime) VALUES(?,?);";
    mSQLStatements[LTY_LAST_PLAYTIME_INSERT] = SQLStatement;
    SQLStatement.query = "/*70a*/""SELECT * FROM LastPlaytimes WHERE (? OR ObjectID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_LAST_PLAYTIME] = SQLStatement;
    SQLStatement.query = "/*72a*/""DELETE FROM LastPlaytimes WHERE (? OR ObjectID=?);";
    mSQLStatements[LTY_LAST_PLAYTIME_DELETE] = SQLStatement;

    /*
     * Scan Contexts:
     */
    SQLStatement.query = "/*73*/""INSERT OR REPLACE INTO ScanContext (DeviceID,Deep,Path,Row) VALUES(?,?,?,?);";
    mSQLStatements[LTY_SCAN_CONTEXT_INSERT] = SQLStatement;
    SQLStatement.query = "/*74*/""SELECT * FROM ScanContext WHERE (? OR DeviceID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_SCAN_CONTEXT] = SQLStatement;
    SQLStatement.query = "/*75*/""DELETE FROM ScanContext WHERE (? OR DeviceID=?);";
    mSQLStatements[LTY_SCAN_CONTEXT_DELETE] = SQLStatement;

    /*
     * for removing the old triggers
     */
    SQLStatement.query = "/*76*/""SELECT * FROM sqlite_master WHERE (? OR ?) AND (? OR type=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_SQLITE_MASTER] = SQLStatement;

    /*
     * for livetags table
     */
    SQLStatement.query = "/*78a*/""INSERT OR IGNORE INTO LiveTags (DeviceID,CategoryID,Tag,NotPlayable) VALUES(?,?,?,?);";
    mSQLStatements[LTY_LIVETAGS_INSERT] = SQLStatement;
    SQLStatement.query = "/*79a*/""DELETE FROM LiveTags WHERE (? OR DeviceID=?);";
    mSQLStatements[LTY_LIVETAGS_DELETE] = SQLStatement;
    SQLStatement.query = "/*80*/""SELECT * FROM LiveTags "
                         "WHERE (? OR DeviceID=?) AND (? OR TagID=?) AND (? OR CategoryID=?) AND (? OR Tag=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_LIVETAGS_SELECT] = SQLStatement;
    SQLStatement.query = "/*80a*/""UPDATE LiveTags SET "
                         "NotPlayable=CASE WHEN ? THEN NotPlayable ELSE ? END "
                         "WHERE (? OR TagID=?);";
    mSQLStatements[LTY_LIVETAGS_UPDATE] = SQLStatement;

    /*
     * Bluetooth vt
    */
    SQLStatement.query = "/*126*/""SELECT rowid,uid,mountpoint,path,filename,type,format from [Main].[BT] "
                         "where (? OR ?) AND mountpoint match ? AND path match ?  AND LTY = ?  AND  type < ? AND _LIMIT = ? AND _OFFSET = ?;";
    mSQLStatements[LTY_BLUETOOTH_FILELIST] = SQLStatement;
    SQLStatement.query = "/*127*/""SELECT count from [Main].[BT] "
                         "where (? OR ?) AND mountpoint match ? AND path match ? AND LTY = ? "
                         "group by type LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_BLUETOOTH_FILELIST_COUNT] = SQLStatement;    /*
     * MTP vt
     */
    SQLStatement.query = "/*128*/""SELECT rowid,itemid,mountpoint,path,filename,type,format from [Main].[MTP] "
                         "where (? OR ?) AND mountpoint match ? AND path match ? AND type < ? "
                         "order by type, filename"  COLLATE" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MTP_FILELIST] = SQLStatement;
    SQLStatement.query = "/*129*/""SELECT type,COUNT() from [Main].[MTP] "
                         "where (? OR ?) AND mountpoint match ? AND path match ? "
                         "group by type LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MTP_FILELIST_COUNT] = SQLStatement;

    /*
     * CDDA vt @@@
     */

    SQLStatement.query = "/*150*/""select itemid,filename,type,format,metadata1,metadata2,metadata3,metadata4,playtime "
                          "from [Main].[CDDA] where (? OR ?) AND mountpoint match ? and path match ? limit ? offset ?;";
    mSQLStatements[LTY_CD] = SQLStatement;
    SQLStatement.query = "/*150*/""select 2/*=FT_AUDIO*/,count() "
                          "from [Main].[CDDA] where (? OR ?) AND mountpoint match ? and path match ? limit ? offset ?;";
    mSQLStatements[LTY_CD_COUNT] = SQLStatement;

    //----------------
    //LTY_IMAGE
    //----------------

    /*
     * PictureViewer
     */
    SQLStatement.query = "/*130*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [MAIN].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_IMAGE_CRITERIA" "
                         "order by title" COLLATE" limit ? offset ?) "
                         "order by title" COLLATE" ;";
    mSQLStatements[LTY_IMAGE] = SQLStatement;

    SQLStatement.query = "/*130fts*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(select rowid from [MAIN].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_IMAGE_CRITERIA" and title LIKE ? "
                         "order by title" COLLATE" limit ? offset ?) "
                         "order by title" COLLATE" ;";
    mSQLStatements[LTY_IMAGE_SEARCH] = SQLStatement;

    SQLStatement.query = "/*131*/""select count() from [MAIN].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_IMAGE_CRITERIA"  limit ? offset ?;";
    mSQLStatements[LTY_IMAGE_COUNT] = SQLStatement;

    SQLStatement.query = "/*131fts*/""select count() from (select rowid from [Main].[MediaObjects] "
                         "where (? or deviceid=?) and " CTY_IMAGE_CRITERIA" and title LIKE ? limit ? offset ?);";
    mSQLStatements[LTY_IMAGE_SEARCH_COUNT] = SQLStatement;//Roadmap 160014 'full text search'
    /*
     * Temporary TrackUIDs
     */


    SQLStatement.query ="/*133*/""SELECT COUNT() FROM (SELECT DISTINCT UUID FROM [Main].[MediaObjects] "
                         "WHERE (? or deviceid=?)  AND (" CTY_SONG_CRITERIA"  OR " CTY_PODCAST_CRITERIA "  OR " CTY_AUDIOBOOK_CRITERIA"));";
    mSQLStatements[LTY_TRACK_COUNT] = SQLStatement;

    SQLStatement.query = "/*134*/""CREATE TEMP TABLE IF NOT EXISTS [TEMP].[TrackUIDTemp] ( [UUID] TEXT );";
    mSQLStatements[LTY_TRACK_TEMP_CREATE] = SQLStatement;

    SQLStatement.query = "/*135*/""INSERT INTO [TEMP].[TrackUIDTemp](UUID) SELECT DISTINCT UUID FROM  [MAIN].[MediaObjects] "
                         "WHERE deviceid=? AND (" CTY_SONG_CRITERIA" OR " CTY_PODCAST_CRITERIA "  OR " CTY_AUDIOBOOK_CRITERIA");";
    mSQLStatements[LTY_TRACK_TEMP_INSERT] = SQLStatement;

    SQLStatement.query = "/*136*/""delete from [TEMP].[TrackUIDTemp] where (? or UUID=?) ;";
    mSQLStatements[LTY_TRACK_TEMP_DELETE] = SQLStatement;

    SQLStatement.query = "/*137*/""delete * from [TEMP].[TrackUIDTemp] ;";
    mSQLStatements[LTY_TRACK_TEMP_DELETE_ALL] = SQLStatement;

    SQLStatement.query = "/*138*/""select UUID from [TEMP].[TrackUIDTemp] ;";
    mSQLStatements[LTY_TRACK_TEMP_SELECT_ALL] = SQLStatement;

    SQLStatement.query = "/*139*/""DROP TABLE IF EXISTS  [TEMP].[TrackUIDTemp] ;";
    mSQLStatements[LTY_TRACK_TEMP_DROP] = SQLStatement;

    SQLStatement.query = "/*140*/""SELECT COUNT() FROM (SELECT ROWID FROM [TEMP].[TrackUIDTemp]);";
    mSQLStatements[LTY_TRACK_TEMP_COUNT] = SQLStatement;

    SQLStatement.query = "/*141*/""CREATE TEMP TABLE IF NOT EXISTS [TEMP].[PlaylistNameTemp] ([Title]  TEXT );";
    mSQLStatements[LTY_PLAYLIST_TEMP_CREATE] = SQLStatement;

    SQLStatement.query = "/*148*/""INSERT INTO [TEMP].[PlaylistNameTemp](Title) SELECT filtertag1 FROM [MAIN].[MediaObjects] "
                         "WHERE ( deviceid=? AND " CTY_PLAYLIST_CRITERIA");";
    mSQLStatements[LTY_PLAYLIST_TEMP_INSERT] = SQLStatement;

    SQLStatement.query = "/*143*/""SELECT COUNT() FROM (SELECT ROWID FROM [TEMP].[PlaylistNameTemp]);";
    mSQLStatements[LTY_PLAYLIST_TEMP_COUNT] = SQLStatement;

    SQLStatement.query = "/*144*/""delete from [TEMP].[PlaylistNameTemp] where rowid =( select rowid from [TEMP].[PlaylistNameTemp] where (? or Title=?) limit 1);";
    mSQLStatements[LTY_PLAYLIST_TEMP_DELETE] = SQLStatement;

    SQLStatement.query = "/*145*/""DROP TABLE IF EXISTS  [TEMP].[PlaylistNameTemp] ;";
    mSQLStatements[LTY_PLAYLIST_TEMP_DROP] = SQLStatement;

    SQLStatement.query = "/*146*/""select Title from [TEMP].[PlaylistNameTemp] ;";
    mSQLStatements[LTY_PLAYLIST_TEMP_SELECT_ALL] = SQLStatement;


    SQLStatement.query = "/*147*/""SELECT COUNT() FROM (SELECT DISTINCT UUID FROM [Main].[MediaObjects] "
                         "WHERE (? or deviceid=?)  AND " CTY_VIDEO_CRITERIA");";
    mSQLStatements[LTY_VIDEO_TRACK_COUNT] = SQLStatement;

    SQLStatement.query = "/*148*/""INSERT INTO [TEMP].[TrackUIDTemp](UUID) SELECT DISTINCT UUID FROM [MAIN].[MediaObjects] "
                         "WHERE (deviceid=? AND " CTY_VIDEO_CRITERIA");";
    mSQLStatements[LTY_VIDEO_TEMP_INSERT] = SQLStatement;

    SQLStatement.query = "/*149*/""SELECT filtertag1 FROM [MAIN].[MediaObjects] WHERE (? OR deviceid=?) AND " CTY_PLAYLIST_CRITERIA";";
    mSQLStatements[LTY_PLAYLIST_TITLE_SELECT_ALL] = SQLStatement;

    SQLStatement.query = "/*150*/""SELECT FilterTag1ID, FilterTag2ID, FilterTag3ID, FilterTag4ID FROM [MAIN].[MediaObjects] "
                         "WHERE (? OR DeviceID=?) AND UUID=? AND " CTY_SONG_CRITERIA" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_SONGS_FILTERTAGIDS_BY_UUID] = SQLStatement;

    SQLStatement.query = "/*151*/""SELECT ID FROM [Main].[MediaObjects] "
                         "WHERE (? OR DeviceID=?) AND UUID=? AND " CTY_SONG_CRITERIA" LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_SONGS_OBJECTID_BY_UUID] = SQLStatement;

    SQLStatement.query = "/*152*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(SELECT rowid FROM [Main].[MediaObjects] "
                         "WHERE (? OR DeviceID=?) AND UUID=? AND " CTY_IPOD_UUID_CRITERIA" LIMIT ? OFFSET ?);";
    mSQLStatements[LTY_IPOD_MEDIAOBJECTS_BY_UUID] = SQLStatement;

    SQLStatement.query = "/*152*/" MEDIAOBJECT_SELECT_COLUMNS
                         "(SELECT rowid FROM [Main].[MediaObjects] "
                         "WHERE (? OR DeviceID=?) AND UUID=? AND " CTY_SONG_CRITERIA" LIMIT ? OFFSET ?);";
    mSQLStatements[LTY_MEDIAOBJECTS_BY_UUID] = SQLStatement;

    SQLStatement.query = "/*153*/""SELECT DeviceID, UUID FROM [Main].[MediaObjects] "
                         "WHERE (? OR ID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MEDIAOBJECTS_DEVICEID_UUID_BY_OBJECTID] = SQLStatement;

    SQLStatement.query = "/*81*/""SELECT ID FROM MediaObjects "
                         "WHERE (? OR DeviceID=?) AND CategoryID=? AND (Filtertag1=? OR Filtertag2=? OR Filtertag3=? OR Filtertag4=? OR Title=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MEDIAOBJECTS_OBJECTID_BY_CATEGORY_FILTER] = SQLStatement;

    SQLStatement.query = "/*81a*/""SELECT ID, CategoryID FROM MediaObjects "
                         "WHERE (? OR DeviceID=?) AND Title=? LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MEDIAOBJECTS_OBJECTID_CATEGORYID_BY_TITLE] = SQLStatement;

    SQLStatement.query = "/*165*/""SELECT parentid,depth FROM [Main].[FolderHierarchy] "
                         "WHERE (? OR [Main].[FolderHierarchy].deviceid=?) AND [Main].[FolderHierarchy].name=? LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_FOLDERHIERARCHY_PARENTID_BY_CHILD_NAME] = SQLStatement;

    SQLStatement.query = "/*999*/"
            "select rowid, 4, 0, \"/\", rowid, name, rowid, rowid, name, rowid, name, rowid, name, rowid, name, 10, \"/\","
            "\"1.0\", \"/tmp\", 0 "
            "from [IndexHelper].[IndexHelper] where rowid in "
                         "(select rowid from [IndexHelper].[IndexHelper] "
                         "where (1 or ? or 1=?) "
                         "order by name" COLLATE" limit ? offset ?) "
                         "order by name" COLLATE" ;";
    mSQLStatements[LTY_END_OF_LTY] = SQLStatement;

    SQLStatement.query = "/*999a*/""select count() from (select rowid from [IndexHelper].[IndexHelper] "
                         "where (1 or ? or 1=?) "
                         "limit ? offset ?);";
    mSQLStatements[LTY_END_OF_LTY_COUNT] = SQLStatement;

    /* set video properties - roadmap-15027 */
    SQLStatement.query = "/*666a*/""SELECT Brightness FROM [Main].[VideoProperty] LIMIT 1 OFFSET 0;";
    mSQLStatements[LTY_VIDEOPROPERTY_BRIGHTNESS] = SQLStatement;

    SQLStatement.query = "/*666b*/""SELECT Hue FROM [Main].[VideoProperty] LIMIT 1 OFFSET 0;";
    mSQLStatements[LTY_VIDEOPROPERTY_HUE] = SQLStatement;

    SQLStatement.query = "/*666c*/""SELECT Saturation FROM [Main].[VideoProperty] LIMIT 1 OFFSET 0;";
    mSQLStatements[LTY_VIDEOPROPERTY_SATURATION] = SQLStatement;

    SQLStatement.query = "/*666d*/""SELECT Contrast FROM [Main].[VideoProperty] LIMIT 1 OFFSET 0;";
    mSQLStatements[LTY_VIDEOPROPERTY_CONTRAST] = SQLStatement;

    SQLStatement.query = "/*666e*/""SELECT BrightnessOffset FROM [Main].[VideoProperty] LIMIT 1 OFFSET 0;";
    mSQLStatements[LTY_VIDEOPROPERTY_BRIGHTNESSOFFSET] = SQLStatement;

    SQLStatement.query = "/*666f*/""SELECT HueOffset FROM [Main].[VideoProperty] LIMIT 1 OFFSET 0;";
    mSQLStatements[LTY_VIDEOPROPERTY_HUEOFFSET] = SQLStatement;

    SQLStatement.query = "/*666g*/""SELECT SaturationOffset FROM [Main].[VideoProperty] LIMIT 1 OFFSET 0;";
    mSQLStatements[LTY_VIDEOPROPERTY_SATURATIONOFFSET] = SQLStatement;

    SQLStatement.query = "/*666h*/""SELECT * FROM [Main].[VideoProperty] LIMIT 1 OFFSET 0;";
    mSQLStatements[LTY_VIDEOPROPERTY] = SQLStatement;

    SQLStatement.query = "/*666i*/""UPDATE [Main].[VideoProperty] SET "
                         "Brightness=CASE WHEN ? THEN Brightness ELSE ? END,"
                         "Hue=CASE WHEN ? THEN Hue ELSE ? END,"
                         "Saturation=CASE WHEN ? THEN Saturation ELSE ? END,"
                         "Contrast=CASE WHEN ? THEN Contrast ELSE ? END,"
                         "BrightnessOffset=CASE WHEN ? THEN BrightnessOffset ELSE ? END,"
                         "HueOffset=CASE WHEN ? THEN HueOffset ELSE ? END,"
                         "SaturationOffset=CASE WHEN ? THEN SaturationOffset ELSE ? END ";
    mSQLStatements[LTY_VIDEOPROPERTY_UPDATE] = SQLStatement;

    /* set DVD video properties  */
       SQLStatement.query = "/*666j*/""SELECT Brightness FROM [Main].[DVDVideoProperty] LIMIT 1 OFFSET 0;";
       mSQLStatements[LTY_DVDVIDEOPROPERTY_BRIGHTNESS] = SQLStatement;

       SQLStatement.query = "/*666k*/""SELECT Hue FROM [Main].[DVDVideoProperty] LIMIT 1 OFFSET 0;";
       mSQLStatements[LTY_DVDVIDEOPROPERTY_HUE] = SQLStatement;

       SQLStatement.query = "/*666l*/""SELECT Saturation FROM [Main].[DVDVideoProperty] LIMIT 1 OFFSET 0;";
       mSQLStatements[LTY_DVDVIDEOPROPERTY_SATURATION] = SQLStatement;

       SQLStatement.query = "/*666m*/""SELECT Contrast FROM [Main].[DVDVideoProperty] LIMIT 1 OFFSET 0;";
       mSQLStatements[LTY_DVDVIDEOPROPERTY_CONTRAST] = SQLStatement;

       SQLStatement.query = "/*666n*/""SELECT BrightnessOffset FROM [Main].[DVDVideoProperty] LIMIT 1 OFFSET 0;";
       mSQLStatements[LTY_DVDVIDEOPROPERTY_BRIGHTNESSOFFSET] = SQLStatement;

       SQLStatement.query = "/*666o*/""SELECT HueOffset FROM [Main].[DVDVideoProperty] LIMIT 1 OFFSET 0;";
       mSQLStatements[LTY_DVDVIDEOPROPERTY_HUEOFFSET] = SQLStatement;

       SQLStatement.query = "/*666p*/""SELECT SaturationOffset FROM [Main].[DVDVideoProperty] LIMIT 1 OFFSET 0;";
       mSQLStatements[LTY_DVDVIDEOPROPERTY_SATURATIONOFFSET] = SQLStatement;

       SQLStatement.query = "/*666q*/""SELECT * FROM [Main].[DVDVideoProperty] LIMIT 1 OFFSET 0;";
       mSQLStatements[LTY_DVDVIDEOPROPERTY] = SQLStatement;

       SQLStatement.query = "/*666r*/""UPDATE [Main].[DVDVideoProperty] SET "
                            "Brightness=CASE WHEN ? THEN Brightness ELSE ? END,"
                            "Hue=CASE WHEN ? THEN Hue ELSE ? END,"
                            "Saturation=CASE WHEN ? THEN Saturation ELSE ? END,"
                            "Contrast=CASE WHEN ? THEN Contrast ELSE ? END,"
                            "BrightnessOffset=CASE WHEN ? THEN BrightnessOffset ELSE ? END,"
                            "HueOffset=CASE WHEN ? THEN HueOffset ELSE ? END,"
                            "SaturationOffset=CASE WHEN ? THEN SaturationOffset ELSE ? END ";
       mSQLStatements[LTY_DVDVIDEOPROPERTY_UPDATE] = SQLStatement;
       /* set MTP video properties  */
             SQLStatement.query = "/*667a*/""SELECT Brightness FROM [Main].[MTPVideoProperty] LIMIT 1 OFFSET 0;";
             mSQLStatements[LTY_MTPVIDEOPROPERTY_BRIGHTNESS] = SQLStatement;

             SQLStatement.query = "/*667b*/""SELECT Hue FROM [Main].[MTPVideoProperty] LIMIT 1 OFFSET 0;";
             mSQLStatements[LTY_MTPVIDEOPROPERTY_HUE] = SQLStatement;

             SQLStatement.query = "/*667c*/""SELECT Saturation FROM [Main].[MTPVideoProperty] LIMIT 1 OFFSET 0;";
             mSQLStatements[LTY_MTPVIDEOPROPERTY_SATURATION] = SQLStatement;

             SQLStatement.query = "/*667d*/""SELECT Contrast FROM [Main].[MTPVideoProperty] LIMIT 1 OFFSET 0;";
             mSQLStatements[LTY_MTPVIDEOPROPERTY_CONTRAST] = SQLStatement;

             SQLStatement.query = "/*667e*/""SELECT BrightnessOffset FROM [Main].[MTPVideoProperty] LIMIT 1 OFFSET 0;";
             mSQLStatements[LTY_MTPVIDEOPROPERTY_BRIGHTNESSOFFSET] = SQLStatement;

             SQLStatement.query = "/*667f*/""SELECT HueOffset FROM [Main].[MTPVideoProperty] LIMIT 1 OFFSET 0;";
             mSQLStatements[LTY_MTPVIDEOPROPERTY_HUEOFFSET] = SQLStatement;

             SQLStatement.query = "/*667g*/""SELECT SaturationOffset FROM [Main].[MTPVideoProperty] LIMIT 1 OFFSET 0;";
             mSQLStatements[LTY_MTPVIDEOPROPERTY_SATURATIONOFFSET] = SQLStatement;

             SQLStatement.query = "/*667h*/""SELECT * FROM [Main].[MTPVideoProperty] LIMIT 1 OFFSET 0;";
             mSQLStatements[LTY_MTPVIDEOPROPERTY] = SQLStatement;

             SQLStatement.query = "/*667i*/""UPDATE [Main].[MTPVideoProperty] SET "
                                  "Brightness=CASE WHEN ? THEN Brightness ELSE ? END,"
                                  "Hue=CASE WHEN ? THEN Hue ELSE ? END,"
                                  "Saturation=CASE WHEN ? THEN Saturation ELSE ? END,"
                                  "Contrast=CASE WHEN ? THEN Contrast ELSE ? END,"
                                  "BrightnessOffset=CASE WHEN ? THEN BrightnessOffset ELSE ? END,"
                                  "HueOffset=CASE WHEN ? THEN HueOffset ELSE ? END,"
                                  "SaturationOffset=CASE WHEN ? THEN SaturationOffset ELSE ? END ";
             mSQLStatements[LTY_MTPVIDEOPROPERTY_UPDATE] = SQLStatement;
    /*
     * dvdInfo:
     */
    SQLStatement.query = "/*333*/""INSERT OR REPLACE INTO DVDStorage (ID , DVDInfo) VALUES(1,?); ";
    mSQLStatements[LTY_DVDINFO_RESUME_INSERT] = SQLStatement;
    SQLStatement.query = "/*334*/""SELECT DVDInfo FROM [Main].[DVDStorage] WHERE ID=1 LIMIT 1 OFFSET 0;";
    mSQLStatements[LTY_DVDINFO_RESUME] = SQLStatement;
    SQLStatement.query = "/*335*/""INSERT OR REPLACE INTO DVDStorage (ID , DVDInfo) VALUES(2,?);";
    mSQLStatements[LTY_DVDINFO_SETUP_INSERT] = SQLStatement;
    SQLStatement.query = "/*336*/""SELECT DVDInfo FROM [Main].[DVDStorage] WHERE ID=2  LIMIT 1 OFFSET 0;";
    mSQLStatements[LTY_DVDINFO_SETUP] = SQLStatement;


    SQLStatement.query = "/*337*/""UPDATE [Main].[MusicBoxProperty] SET "
                         "AutoRipping=CASE WHEN ? THEN AutoRipping ELSE ? END";
    mSQLStatements[LTY_MUSICBOX_PROP_UPDATE_AUTO_RIPPING] = SQLStatement;

    SQLStatement.query = "/*338*/""UPDATE [Main].[MusicBoxProperty] SET "
                                 "EncodingQuality=CASE WHEN ? THEN EncodingQuality ELSE ? END";
    mSQLStatements[LTY_MUSICBOX_PROP_UPDATE_ENC_QUALITY] = SQLStatement;

    SQLStatement.query = "/*339*/""SELECT AutoRipping FROM [Main].[MusicBoxProperty] LIMIT 1 OFFSET 0;";
    mSQLStatements[LTY_MUSICBOX_PROP_GET_AUTO_RIPPING] = SQLStatement;

    SQLStatement.query = "/*340*/""SELECT EncodingQuality FROM [Main].[MusicBoxProperty] LIMIT 1 OFFSET 0;";
    mSQLStatements[LTY_MUSICBOX_PROP_GET_ENC_QUALITY] = SQLStatement;



    SQLStatement.query = "/*666g*/""SELECT SaturationOffset FROM [Main].[VideoProperty] LIMIT 1 OFFSET 0;";
    mSQLStatements[LTY_VIDEOPROPERTY_SATURATIONOFFSET] = SQLStatement;

    SQLStatement.query = "/*666h*/""SELECT * FROM [Main].[VideoProperty] LIMIT 1 OFFSET 0;";
    mSQLStatements[LTY_VIDEOPROPERTY] = SQLStatement;



    SQLStatement.query = "/*166*/SELECT COUNT() FROM [Main].[MediaObjects] "
                         "where (? or deviceid=?) AND UUID=? AND (? OR CategoryID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MEDIAOBJECTS_RIPPED_FILE] = SQLStatement;

    SQLStatement.query = "/*166a*/UPDATE [Main].[MediaObjects] "
                             " SET CategoryID=? WHERE URL = ? AND DeviceID=?;";
    mSQLStatements[LTY_MEDIAOBJECTS_UPDATE_RIPPED_FILE] = SQLStatement;

    SQLStatement.query = "/*166b*/SELECT COUNT() FROM [Main].[MediaObjects] "
                             "where (? or deviceid=?) AND (? OR CategoryID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MEDIAOBJECTS_TOTAL_RIPPED_FILE] = SQLStatement;


    SQLStatement.query = "/*166c*/SELECT  FilterTag1,FilterTag2,FilterTag3,FilterTag4,Title,CompilationFlag,Year FROM [Main].[MediaObjects] "
            "where (? or deviceid=?) AND URL=? LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MEDIAOBJECTS_RIPPED_FILE_METADATA] = SQLStatement;

    SQLStatement.query = "/*166d*/""UPDATE [Main].[MediaObjects] "
                             "SET AlbumArt=? WHERE UUID=? AND DeviceID=?;";
    mSQLStatements[LTY_MEDIAOBJECTS_UPDATE_ALBUMARTSTRING] = SQLStatement;

    SQLStatement.query = "/*166e*/""SELECT AlbumArt FROM [MAIN].[MediaObjects] "
                             "WHERE (? OR DEVICEID=?) AND UUID=? LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MEDIAOBJECTS_ALBUMART_FROM_UUID] = SQLStatement;

    SQLStatement.query = "/*166a*/UPDATE [Main].[Devices] "
                                 " SET NumberOfAudioFiles=?, TotalSize=?, FreeSize=? WHERE ID=?;";
    mSQLStatements[LTY_MEDIAOBJECTS_UPDATE_MUSICBOX_DEVICE] = SQLStatement;

    /*>>--Roadmap CMG3G-10221 : 'Scene Recorder '*/
    SQLStatement.query = "/*166b*/""SELECT COUNT(), SUM(Size) FROM MediaObjects "
                             "WHERE (? OR DeviceID=?) AND Path LIKE ? AND (? OR CategoryID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_TRACK_COUNT_SIZE] = SQLStatement;
    SQLStatement.query = "/*166c*/""SELECT FileMode, Size FROM MediaObjects "
                                "WHERE (? OR DeviceID=?) AND Path LIKE ? AND (? OR CategoryID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_TRACK_COUNT_SIZE_FILEMODE] = SQLStatement;

    SQLStatement.query = "/*166d*/""SELECT id, CategoryID, url FROM MediaObjects "
                                "WHERE (? OR DeviceID=?) AND Path LIKE ? AND (? OR CategoryID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_DIRECTORY_INFO_FROM_FOLDERPATH] = SQLStatement;

    SQLStatement.query = "/*166e*/""SELECT FileMode, UserID, GroupID FROM MediaObjects "
                                "WHERE (? OR DeviceID=?) AND id=? AND (? OR CategoryID=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_FILE_PERMISSION] = SQLStatement;

    SQLStatement.query = "/*166f*/""SELECT TotalPlaytime, Size, DateTime FROM MediaObjects "
                                    "WHERE (? OR DeviceID=?) AND id=? LIMIT ? OFFSET ?;";
        mSQLStatements[LTY_DATETIME_SIZE_LENGTH] = SQLStatement;

    SQLStatement.query = "/*167*/""SELECT COUNT() FROM Devices WHERE (ID > 1) AND (ConnectionState = 2) AND (ConnectionType = 1) AND DeviceType IN(1,2,3,5,6,8,11,14)";
    mSQLStatements[LTY_INDEXABLEDEVICES_COUNT] = SQLStatement;

    /* oldest device , check for device id > 1 , DeviceId 0 is reserved for MyMedia and deviceId 1 is reserved for Musicbox */
    SQLStatement.query = "/*168*/""SELECT * FROM Devices WHERE (ID > 1) AND (ConnectionState = 2) AND (ConnectionType = 1) AND DeviceType IN(1,2,3,5,6,8,11,14) ORDER BY LastConnected;";
    mSQLStatements[LTY_INDEXABLEDEVICES_OLDEST] = SQLStatement;

    /* oldest device , check for device id > 1 , DeviceId 0 is reserved for MyMedia and deviceId 1 is reserved for Musicbox */
    SQLStatement.query = "/*169*/""SELECT * FROM Devices WHERE (ID > 1) AND (ConnectionState = 2) AND (ConnectionType = 2 OR ConnectionType = 5) AND (DeviceType IN(4,5,7,12,13)) ORDER BY LastConnected";
    mSQLStatements[LTY_NONINDEXABLEDEVICES_OLDEST] = SQLStatement;

    /*
     * YomiMetadata
     */
    SQLStatement.query = "/*170*/""INSERT INTO [Main].[YomiMetadata] "
            "("
            "  [MediaObjectTag],"
            "  [YomiTitle],"
            "  [YomiArtist],"
            "  [YomiAlbum]"
            ") "
            "VALUES (?,?,?,?);";
    mSQLStatements[LTY_YOMIMETADATA_INSERT] = SQLStatement;
    SQLStatement.query = "/*170a*/""SELECT YomiTitle,YomiArtist,YomiAlbum FROM YomiMetadata WHERE (? OR DEVICEID=?) AND MediaObjectTag=? LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_YOMIMETADATA] = SQLStatement;
    SQLStatement.query = "/*170b*/""DELETE FROM [Main].[YomiMetadata] WHERE (? OR MediaObjectTag=?);";
    mSQLStatements[LTY_YOMIMETADATA_DELETE] = SQLStatement;
    SQLStatement.query = "/*170c*/""UPDATE OR IGNORE [Main].[YomiMetadata] SET "
                "YomiTitle=CASE WHEN ? THEN YomiTitle ELSE ? END,"
                "YomiArtist=CASE WHEN ? THEN YomiArtist ELSE ? END,"
                "YomiAlbum=CASE WHEN ? THEN YomiAlbum ELSE ? END "
                "WHERE (? OR DeviceID=?) AND (MediaObjectTag=?);";
        mSQLStatements[LTY_YOMIMETADATA_UPDATE] = SQLStatement;

    /*
     * Music Box ToC-UUID Mapping
     */
    SQLStatement.query = "/*171*/""INSERT INTO [Main].[MusicBoxToC] "
            "("
            "  [TOCString],"
            "  [UUID]"
            ") "
            "VALUES (?,?);";
    mSQLStatements[LTY_MUSICBOXTOC_INSERT] = SQLStatement;
    SQLStatement.query = "/*171a*/""SELECT TOCString FROM [Main].[MusicBoxToC] WHERE (? OR DEVICEID=?) AND UUID=? LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_MUSICBOXTOC] = SQLStatement;
    SQLStatement.query = "/*171b*/""DELETE FROM [Main].[MusicBoxToC] WHERE (UUID=?);";
    mSQLStatements[LTY_MUSICBOXTOC_DELETE] = SQLStatement;

    SQLStatement.query = "/*171c*/""SELECT UUID FROM [MAIN].[MediaObjects] "
            "WHERE (? OR DEVICEID=?) AND FilterTag4=? LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_SONGS_ALBUMNAME_BY_UUID] = SQLStatement;
    SQLStatement.query = "/*171d*/""UPDATE OR IGNORE [Main].[MediaObjects] SET "
            "Title=CASE WHEN ? THEN Title ELSE ? END,"
            "FilterTag1=CASE WHEN ? THEN FilterTag1 ELSE ? END,"
            "FilterTag2=CASE WHEN ? THEN FilterTag2 ELSE ? END,"
            "FilterTag3=CASE WHEN ? THEN FilterTag3 ELSE ? END,"
            "FilterTag4=CASE WHEN ? THEN FilterTag4 ELSE ? END,"
            "CompilationFlag=CASE WHEN ? THEN CompilationFlag ELSE ? END "
            "WHERE (? OR DeviceID=?) AND (? OR UUID=?) AND (? OR TrackNumber=?);";
    mSQLStatements[LTY_MEDIAOBJECTS_UPDATE_GNDATA] = SQLStatement;

    SQLStatement.query = "/*175*/""SELECT COUNT() from [Main].[MediaObjects] "
                             "WHERE (? or DeviceID=?) AND " CTY_PLAYLIST_CRITERIA" AND Title=? LIMIT ? OFFSET ?;";
        mSQLStatements[LTY_PLAYLISTNAME_COUNT] = SQLStatement;
    /*<<--Roadmap CMG3G-10221 : 'Scene Recorder '*/

    // CRQ 300254 Support for Folder Up/Down command
    SQLStatement.query = "/*172*/""SELECT DISTINCT ChildID FROM [Main].[FolderHierarchy] "
                         "WHERE (? OR [Main].[FolderHierarchy].deviceid=?) LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_FOLDERHIERARCHY_CHILDID_BY_DEVICEID] = SQLStatement;

    SQLStatement.query = "/*173*/""SELECT childid FROM [Main].[FolderHierarchy] "
                         "WHERE (? OR [Main].[FolderHierarchy].deviceid=?) AND [Main].[FolderHierarchy].name=? LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_FOLDERHIERARCHY_CHILDID_BY_FOLDERPATH] = SQLStatement;

    SQLStatement.query = "/*174*/""SELECT name FROM [Main].[FolderHierarchy] "
                         "WHERE (? OR [Main].[FolderHierarchy].deviceid=?) AND [Main].[FolderHierarchy].childid=? LIMIT ? OFFSET ?;";
    mSQLStatements[LTY_FOLDERHIERARCHY_FOLDERPATH_BY_CHILDID] = SQLStatement;

    //LTY_ROUTEGUIDANCEDISPLAYCOMPONENTS
    SQLStatement.query = "/*175*/""INSERT INTO [Main].[RouteGuidanceDisplayComponents] "
                 "("
                 "  [Identifier],"
                 "  [Name],"
                 "  [CurrentRoadNameLength],"
                 "  [DestinationNameLength],"
                 "  [AfterManeuverRoadNameLength],"
                 "  [ManeuverDescriptionLength],"
                 "  [GuidanceManeuverCapacity]"
                 ") "
                 "VALUES (?,?,?,?,?,?,?);";
     mSQLStatements[LTY_ROUTEGUIDANCEDISPLAYCOMPONENTS_INSERT] = SQLStatement;

     SQLStatement.query = "/*176*/""DELETE FROM [Main].[RouteGuidanceDisplayComponents] WHERE (? OR Identifier=?);";
     mSQLStatements[LTY_ROUTEGUIDANCEDISPLAYCOMPONENTS_DELETE] = SQLStatement;

     SQLStatement.query = "/*178*/""SELECT * FROM [Main].[RouteGuidanceDisplayComponents] WHERE (? OR DeviceID=?) AND (? OR Identifier=?) LIMIT ? OFFSET ?;";
     mSQLStatements[LTY_ROUTEGUIDANCEDISPLAYCOMPONENTS] = SQLStatement;

     SQLStatement.query = "/*179*/""UPDATE [Main].[RouteGuidanceDisplayComponents] SET "
             "Name=CASE WHEN ? THEN Name ELSE ? END,"
             "CurrentRoadNameLength=CASE WHEN ? THEN CurrentRoadNameLength ELSE ? END,"
             "DestinationNameLength=CASE WHEN ? THEN DestinationNameLength ELSE ? END,"
             "AfterManeuverRoadNameLength=CASE WHEN ? THEN AfterManeuverRoadNameLength ELSE ? END,"
             "ManeuverDescriptionLength=CASE WHEN ? THEN ManeuverDescriptionLength ELSE ? END,"
             "GuidanceManeuverCapacity=CASE WHEN ? THEN GuidanceManeuverCapacity ELSE ? END "
             "WHERE (? OR Identifier=?) ;";
     mSQLStatements[LTY_ROUTEGUIDANCEDISPLAYCOMPONENTS_UPDATE] = SQLStatement;

     SQLStatement.query = "/*180*/""SELECT ID FROM Devices WHERE (? OR SerialNumber = ?) ORDER BY LastConnected DESC LIMIT ? OFFSET ?;";
     mSQLStatements[LTY_DEVICEID_BY_SERIALNUMBER] = SQLStatement;

#endif /* QUERIES_H_ */
