/*
 * FavoritesManagerTest.cpp
 *
 *  Created on: Jan 15, 2013
 *      Author: Dinesh
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/FavoritesManagerTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include <string.h>
#include <errno.h>
#include <memory.h>

#include "FavoritesManagerTest.h"
#include "FavoritesManager.h"
#include "RequestResponseSM.h"

#include "VarTrace.h"
#include "FunctionTracer.h"
#include "LocalSPM.h"
#include "TypeDefinitions.h"

#include "CppUnitDefinitions.h"

/*Songs*/

tObjectID FAVORITE_1_OBJECT_ID = OBJECT_ID_NONE;
tObjectID FAVORITE_2_OBJECT_ID = OBJECT_ID_NONE;
tObjectID FAVORITE_3_OBJECT_ID = OBJECT_ID_NONE;
tObjectID FAVORITE_4_OBJECT_ID = OBJECT_ID_NONE;
tObjectID FAVORITE_5_OBJECT_ID = OBJECT_ID_NONE;
tObjectID FAVORITE_6_OBJECT_ID = OBJECT_ID_NONE;
tObjectID FAVORITE_7_OBJECT_ID = OBJECT_ID_NONE;

#define FAVORITE_1_LABEL        "Fix Me Now"
#define FAVORITE_2_LABEL        "to china with love"
#define FAVORITE_3_LABEL        "laurens cathedral"
#define FAVORITE_4_LABEL        "Only Happy When It Rains"
#define FAVORITE_5_LABEL        "Mando Diao"
#define FAVORITE_6_LABEL        "Alternative"
#define FAVORITE_7_LABEL        "Bring Em IN"

#if 0
#define FAVORITE_1_OBJECT_ID    18
#define FAVORITE_2_OBJECT_ID    36
#define FAVORITE_3_OBJECT_ID    43
#define FAVORITE_4_OBJECT_ID    7
#define FAVORITE_5_OBJECT_ID    30
#define FAVORITE_6_OBJECT_ID    2
#define FAVORITE_7_OBJECT_ID    31
#endif

tObjectID findSong(vector<tMediaObject> mediaObjectVector, const int tagNr, const char *searchString)
{
    ENTRY_INTERNAL
    tObjectID res = OBJECT_ID_NONE;

	for(int i=0; i<(int)mediaObjectVector.size(); i++) {

		int result = 0;

		switch(tagNr) {
		case 1:
			result = strcmp(mediaObjectVector[i].MetadataField1, searchString);
			res = mediaObjectVector[i].MetadataTag1;
			break;
		case 2:
			result = strcmp(mediaObjectVector[i].MetadataField2, searchString);
			res = mediaObjectVector[i].MetadataTag2;
			break;
		case 3:
			result = strcmp(mediaObjectVector[i].MetadataField3, searchString);
			res = mediaObjectVector[i].MetadataTag3;
			break;
		case 4:
			result = strcmp(mediaObjectVector[i].MetadataField4, searchString);
			res = mediaObjectVector[i].MetadataTag4;
			break;
		case 5:
			result = strcmp(mediaObjectVector[i].title, searchString);
			res = mediaObjectVector[i].objectID;
			break;
		default:
		    break;
		}

		if (!result) {
			return res;
		}
	}

	return OBJECT_ID_NONE;
};

void FavoritesManagerTest::prepareTestIDs()
{
    ENTRY_TEST

    tResult res;
    tListID listID;
    tListSize listSize;
    tStreaming streaming = false;
    tFilterTag1 tag1;
    tFilterTag2 tag2;
    tFilterTag3 tag3;
    tFilterTag4 tag4;
    tag1.tag = 0;
    tag2.tag = 0;
    tag3.tag = 0;
    tag4.tag = 0;
    res = LocalSPM::GetListControl().CreateMediaPlayerIndexedList(
            OUT listID,
            OUT listSize,
            LTY_SONG,
            IN streaming,
            IN tag1,
            IN tag2,
            IN tag3,
            IN tag4,
            MY_MEDIA);
    CPPUNIT_ASSERT(res == 0);
    vector<tMediaObject> mediaObjectVector;
    res = LocalSPM::GetListControl().RequestMediaPlayerIndexedListSlice(OUT mediaObjectVector, IN listID, 0, IN listSize);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(mediaObjectVector.size() != 0);


    /* search all test ids */
    FAVORITE_1_OBJECT_ID = findSong(IN mediaObjectVector, 5, FAVORITE_1_LABEL);
    CPPUNIT_ASSERT(res != (tResult)OBJECT_ID_NONE);

    FAVORITE_2_OBJECT_ID = findSong(IN mediaObjectVector, 5, FAVORITE_2_LABEL);
    CPPUNIT_ASSERT(res != (tResult)OBJECT_ID_NONE);

    FAVORITE_3_OBJECT_ID = findSong(IN mediaObjectVector, 5, FAVORITE_3_LABEL);
    CPPUNIT_ASSERT(res != (tResult)OBJECT_ID_NONE);

    FAVORITE_4_OBJECT_ID = findSong(IN mediaObjectVector, 5, FAVORITE_4_LABEL);
    CPPUNIT_ASSERT(res != (tResult)OBJECT_ID_NONE);

    FAVORITE_5_OBJECT_ID = findSong(IN mediaObjectVector, 2, FAVORITE_5_LABEL);
    CPPUNIT_ASSERT(res != (tResult)OBJECT_ID_NONE);

    FAVORITE_6_OBJECT_ID = findSong(IN mediaObjectVector, 1, FAVORITE_6_LABEL);
    CPPUNIT_ASSERT(res != (tResult)OBJECT_ID_NONE);

    FAVORITE_7_OBJECT_ID = findSong(IN mediaObjectVector, 4, FAVORITE_7_LABEL);
    CPPUNIT_ASSERT(res != (tResult)OBJECT_ID_NONE);

    LocalSPM::GetListControl().ReleaseList(IN listID);
}

/**********************************************************************
 * Test cases *
 *  test trigger for Store a Favorite , Update it and then delete it
 * - Store 3 favorites
 * - Get all the 3 Favorites and verify its information
 * - Activate Favorite 1
 * - Delete Favorite 2
 * - ResetAllFavorites clears all
 * - RestoreFavorite : again store all the 3 favorites
 * - UpdateFavoriteStatus : update favorite's active or available info and verify
 * - DeactivateAllFavorites : reset available info of all the store favorites
 *********************************************************************/

void FavoritesManagerTest::Allocate()
{
    ENTRY_TEST

    tResult ret = 0;

    /* Call SendAllocate */
    tAudioOutputDevice audioOutputDevice;
    strncpy_r(OUT audioOutputDevice, IN USB_ALSA_DEVICENAME, IN sizeof(audioOutputDevice));

    ret = LocalSPM::GetPlayerManager().SendAllocate(IN audioOutputDevice);
    CPPUNIT_ASSERT(0 == ret);

    sleep(2); //Wait a little bit until IPC is initialized by first Allocate call
}

void FavoritesManagerTest::DeAllocate()
{
    ENTRY_TEST

    tResult ret = 0;

    /* Call SendDeAllocate */
    ret = LocalSPM::GetPlayerManager().SendDeAllocate();
    CPPUNIT_ASSERT(0 == ret);

    sleep(1);
}

void FavoritesManagerTest::SourceActivityOn()
{
    ENTRY_TEST

    tResult ret = 0;

    /* Call SendSourceActivity */
    tSourceActivity sourceActivity = SA_ON;
    ret = LocalSPM::GetPlayerManager().SendSourceActivity(IN sourceActivity);
    CPPUNIT_ASSERT(0 == ret);

    sleep(1);

    tBoolean isActive = FALSE;
    ret = LocalSPM::GetPlayerManager().GetActiveState(OUT isActive);
    CPPUNIT_ASSERT(0 == ret);

    // test result
    CPPUNIT_ASSERT(FALSE != isActive);
}

void FavoritesManagerTest::SourceActivityOff()
{
    ENTRY_TEST

    tResult ret = 0;

    /* Call SendSourceActivity */
    tSourceActivity sourceActivity = SA_OFF;
    ret = LocalSPM::GetPlayerManager().SendSourceActivity(IN sourceActivity);
    CPPUNIT_ASSERT(0 == ret);

    sleep(1);

    tBoolean isActive = TRUE;
    ret = LocalSPM::GetPlayerManager().GetActiveState(OUT isActive);
    CPPUNIT_ASSERT(0 == ret);

    // test result
    CPPUNIT_ASSERT(FALSE == isActive);
}

void FavoritesManagerTest::Triggers()
{
    ENTRY_TEST

    /* use a request / response state machine for testing the trigger */
    class TriggerTestRR : public RequestResponseSM
    {

        int HandleInitRequest()
        {
            return 0;
        }

        int HandleLoopBackMessage(const char *allParameters)
        {
            tResult ret = 0;
            tFavoriteID retFavID;

            switch(mTestPath)
            {
                case 1: // insert trigger test
                {

                    triggerID = LocalSPM::GetDBManager().OnInsertTrigger(IN GetSMNameFull(), IN "SUCCESS_REQUEST", IN "Favorites", IN NULL);
                    ETG_TRACE_USR2(("Favorite Insert triggerID=%d", triggerID));
                    CPPUNIT_ASSERT(triggerID != 0);

                    /*store an known object in the database as favorite*/
                    tObjectID objectID = FAVORITE_4_OBJECT_ID;
                    ret = LocalSPM::GetCustomControl().GetFavoritesManager().StoreFavorite(OUT retFavID,IN objectID);

                    CPPUNIT_ASSERT(ret == 0);         //favorite store success full
                    CPPUNIT_ASSERT(1 == retFavID);    // favorite ID will auto increment with every new store
                    break;
                }

                case 2: // update trigger test
                {
                    triggerID = LocalSPM::GetDBManager().OnUpdateTrigger(IN GetSMNameFull(), IN "SUCCESS_REQUEST", IN "Favorites", IN "Active", IN "WHEN OLD.Active=0 AND NEW.Active=1");
                    ETG_TRACE_USR2(("Favorite Update triggerID=%d", triggerID));
                    CPPUNIT_ASSERT(triggerID != 0);
                    ret = LocalSPM::GetDBManager().UpdateFavoriteStatus(1,1,1);
                    CPPUNIT_ASSERT(ret == 0);
                    break;
                }

                case 3: // delete trigger test
                {
                    triggerID = LocalSPM::GetDBManager().OnDeleteTrigger(IN GetSMNameFull(), IN "SUCCESS_REQUEST", IN "Favorites", IN NULL);
                    ETG_TRACE_USR2(("Favorite Delete triggerID=%d", triggerID));
                    CPPUNIT_ASSERT(triggerID != 0);

                    ret = LocalSPM::GetCustomControl().GetFavoritesManager().DeleteFavorite(retFavID,1);
                    CPPUNIT_ASSERT(ret == 0);
                    break;
                }
                default:
                    break;
            }

            return 0;
        }

        int HandleSuccessRequest(const char *allParameters)
        {
            tResult ret = 0;

            /* check the incoming values */
            ETG_TRACE_USR3(("HandleSuccessRequest(%s)", allParameters));

            /* read out the returned values */
            UnMarshal(allParameters, "ii", &mFavoriteCount, &mFavoriteID);

            /* deregister the trigger */
            ret = LocalSPM::GetDBManager().UnregisterTrigger(IN triggerID);
            CPPUNIT_ASSERT(ret == 0);

            /* do a send answer to unlock the EventAnswer mechanism */
            SendAnswer(NULL);

            return 0;
        }
    public:
        tTriggerID triggerID;
        int mTestPath;

        int mFavoriteID;
        int mFavoriteCount;
    };

    tResult ret = 0;

    /* send LOOP_BACK_MESSAGE to start the tests */
    TriggerTestRR rrTriggerTest;
    char message[128];
    strncpy_r(OUT message, IN rrTriggerTest.GetSMNameFull(), IN sizeof(message));
    strncat_r(OUT message, IN "::LOOP_BACK_MESSAGE", IN sizeof(message));

    // insert trigger test
    ETG_TRACE_USR2(("Insert Trigger Test"));
    rrTriggerTest.mFavoriteCount = 0;
    rrTriggerTest.mFavoriteID = 0;
    rrTriggerTest.mTestPath = 1;
    ret = rrTriggerTest.DoEventAnswer(message, NULL);
    CPPUNIT_ASSERT(ret == 0);

    ETG_TRACE_USR3(("Favorite Trigger (ID:%d) (Count:%d)", rrTriggerTest.mFavoriteID,rrTriggerTest.mFavoriteCount));
    CPPUNIT_ASSERT_MESSAGE("Favorite Insert DB trigger is not working !",rrTriggerTest.mFavoriteCount != 0);
    CPPUNIT_ASSERT(rrTriggerTest.mFavoriteID != 0);
    CPPUNIT_ASSERT(rrTriggerTest.mFavoriteCount == 1);
    CPPUNIT_ASSERT(rrTriggerTest.mFavoriteID == 1);

    // update trigger test
    ETG_TRACE_USR2(("Insert Trigger Test"));
    rrTriggerTest.mFavoriteCount = 0;
    rrTriggerTest.mFavoriteID = 0;
    rrTriggerTest.mTestPath = 2;
    ret = rrTriggerTest.DoEventAnswer(message, NULL);
    CPPUNIT_ASSERT(ret == 0);

    ETG_TRACE_USR3(("Favorite Trigger (ID:%d) (Count:%d)", rrTriggerTest.mFavoriteID,rrTriggerTest.mFavoriteCount));
    CPPUNIT_ASSERT(rrTriggerTest.mFavoriteCount != 0);
    CPPUNIT_ASSERT(rrTriggerTest.mFavoriteID != 0);
    CPPUNIT_ASSERT(rrTriggerTest.mFavoriteCount == 1);
    CPPUNIT_ASSERT(rrTriggerTest.mFavoriteID == 1);

    // update trigger test
    ETG_TRACE_USR2(("Delete Trigger Test"));
    rrTriggerTest.mFavoriteCount = 0;
    rrTriggerTest.mFavoriteID = 0;
    rrTriggerTest.mTestPath = 3;
    ret = rrTriggerTest.DoEventAnswer(message, NULL);
    CPPUNIT_ASSERT(ret == 0);

    ETG_TRACE_USR3(("Favorite Trigger (ID:%d) (Count:%d)", rrTriggerTest.mFavoriteID,rrTriggerTest.mFavoriteCount));
    CPPUNIT_ASSERT(rrTriggerTest.mFavoriteCount == 0);
    CPPUNIT_ASSERT(rrTriggerTest.mFavoriteID != 0);
    CPPUNIT_ASSERT(rrTriggerTest.mFavoriteID == 1);
}

void FavoritesManagerTest::StoreFavorites()
{
    ENTRY_TEST

    tResult ret = 0;
    tFavoriteID retFavID;

    /*store an known object in the database as favorite*/
    tObjectID objectID = FAVORITE_1_OBJECT_ID;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().StoreFavorite(OUT retFavID,IN objectID);

    CPPUNIT_ASSERT(ret == 0);           //favorite store success full
    CPPUNIT_ASSERT(2 == retFavID);      // favorite ID will auto increment with every new store

    /******************************************************************************************************/

    /*store one more object as favorite*/
    objectID = FAVORITE_2_OBJECT_ID;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().StoreFavorite(OUT retFavID,IN objectID);

    CPPUNIT_ASSERT(ret == 0);             //favorite store success full
    CPPUNIT_ASSERT(3 == retFavID); // favorite ID will auto increment with every new store

    /******************************************************************************************************/

    /*store one more object as favorite*/
    objectID = FAVORITE_3_OBJECT_ID;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().StoreFavorite(OUT retFavID,IN objectID);

    CPPUNIT_ASSERT(ret == 0);      //favorite store success full
    CPPUNIT_ASSERT(4 == retFavID); // favorite ID will auto increment with every new store
}

void FavoritesManagerTest::GetFavorite(void)
{
    ENTRY_TEST

    tResult ret = 0;

    tFavoriteInfo favoriteInfo;
    InitFavoriteInfo(OUT favoriteInfo);

    tFavoriteID favoriteID = 2;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(favoriteInfo,favoriteID);
    ETG_TRACE_USR1(("FavoritesManagerTest::GetFavorite -> stored:%128s,expected:%s", favoriteInfo.labelText, FAVORITE_1_LABEL));

    CPPUNIT_ASSERT(ret == 0);

#ifdef TEST_VALIDATE_LABELS
    CPPUNIT_ASSERT(!strcmp(favoriteInfo.labelText, FAVORITE_1_LABEL));
#endif
    VARTRACE(favoriteInfo)

    /******************************************************************************************************/

    favoriteID = 3;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(favoriteInfo,favoriteID);
    ETG_TRACE_USR1(("FavoritesManagerTest::GetFavorite -> stored:%128s,expected:%s", favoriteInfo.labelText, FAVORITE_2_LABEL));

    CPPUNIT_ASSERT(ret == 0);
#ifdef TEST_VALIDATE_LABELS
    CPPUNIT_ASSERT(!strcmp(favoriteInfo.labelText, FAVORITE_2_LABEL));
#endif
    VARTRACE(favoriteInfo)

    /******************************************************************************************************/

    favoriteID = 4;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(favoriteInfo,favoriteID);
    ETG_TRACE_USR1(("FavoritesManagerTest::GetFavorite -> stored:%128s,expected:%s", favoriteInfo.labelText, FAVORITE_3_LABEL));

    CPPUNIT_ASSERT(ret == 0);
#ifdef TEST_VALIDATE_LABELS
    CPPUNIT_ASSERT(!strcmp(favoriteInfo.labelText, FAVORITE_3_LABEL));
#endif
    VARTRACE(favoriteInfo)
}

void FavoritesManagerTest::GetAllFavorites(void)
{
    ENTRY_TEST

    tResult ret = 0;
    vector<tFavoriteInfo> favoritesInfo;

    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetAllFavoriteInfo(favoritesInfo);

    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT(3 == favoritesInfo.size());

    unsigned int iter;
    for(iter=0; iter<favoritesInfo.size(); iter++)
    {
        VARTRACE(favoritesInfo[iter])
    }
    ETG_TRACE_USR1(("FavoritesManagerTest::GetAllFavorites -> stored:%128s,expected:%s", favoritesInfo[0].labelText, FAVORITE_1_LABEL));
    ETG_TRACE_USR1(("FavoritesManagerTest::GetAllFavorites -> stored:%128s,expected:%s", favoritesInfo[1].labelText, FAVORITE_2_LABEL));
    ETG_TRACE_USR1(("FavoritesManagerTest::GetAllFavorites -> stored:%128s,expected:%s", favoritesInfo[2].labelText, FAVORITE_3_LABEL));

#ifdef TEST_VALIDATE_LABELS
    CPPUNIT_ASSERT(!strcmp(favoritesInfo[0].labelText, FAVORITE_1_LABEL));
    CPPUNIT_ASSERT(!strcmp(favoritesInfo[1].labelText, FAVORITE_2_LABEL));
    CPPUNIT_ASSERT(!strcmp(favoritesInfo[2].labelText, FAVORITE_3_LABEL));
#endif
}

void FavoritesManagerTest::ActivateFavorite(void)
{
        ENTRY_TEST

    tResult ret = 0;
    tFavoriteID retFavID;
    tFavoriteID favID = 2;

    ret = LocalSPM::GetCustomControl().GetFavoritesManager().ActivateFavorite(OUT retFavID,IN favID,LC_MAIN_AUDIO,LC_MAIN_AUDIO);

    CPPUNIT_ASSERT(ret == 0);             //favorite activate success full
    CPPUNIT_ASSERT(favID == retFavID);

    tFavoriteInfo favoriteInfo;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo( OUT favoriteInfo, IN favID);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT(FALSE != favoriteInfo.active);    //verify if active flag set on the favorite

    /*wait for playback to start*/
    sleep(2);

    /*Verify if PlayerManager is in Active state*/
    tBoolean isActive = FALSE;
    ret = LocalSPM::GetPlayerManager().GetActiveState(OUT isActive);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT_MESSAGE("PlayerManager is not active ! Is PlayerEngine started late ?", isActive);

    /*Verify if PlayerManager::NowPlaying is same as the requested Favorite is in Active state*/
    tNowPlaying nowPlaying;
    ret = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
    CPPUNIT_ASSERT(ret == 0);
    VARTRACE(nowPlaying);
    CPPUNIT_ASSERT(nowPlaying.objectID == FAVORITE_1_OBJECT_ID);
#ifdef TEST_VALIDATE_LABELS
    CPPUNIT_ASSERT_MESSAGE("Activated Song's title not matching with nowPlaying's title",!strcmp(nowPlaying.object.title, FAVORITE_1_LABEL));    //verify Song name
#endif
}

void FavoritesManagerTest::DeleteFavorite(void)
{
        ENTRY_TEST

    tResult ret = 0;
    tFavoriteID favoriteID = 3;
    tFavoriteID retFavID;

    ret = LocalSPM::GetCustomControl().GetFavoritesManager().DeleteFavorite(OUT retFavID , IN favoriteID);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT(retFavID == favoriteID);

    tFavoriteInfo favoriteInfo;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(favoriteInfo,favoriteID);
    CPPUNIT_ASSERT(ret != 0);           // an attempt to retrieve the deleted favorite should return error
    CPPUNIT_ASSERT(ret == MP_ERR_DB_END_OF_LIST);
}

void FavoritesManagerTest::ResetFavorites(void)
{
        ENTRY_TEST

    tResult ret = 0;

    //reset the favorites which clears all the stored favorites records
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().ResetFavorites();
    CPPUNIT_ASSERT(ret == 0);

    /********************************************************************************************************/
    // verify that all the favorites cleared
    tFavoriteInfo favoriteInfo;
    tFavoriteID favoriteID;

    favoriteID = 2;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(favoriteInfo,favoriteID);
    CPPUNIT_ASSERT(ret != 0);           // an attempt to retrieve the deleted favorite should return error
    CPPUNIT_ASSERT(ret == MP_ERR_DB_END_OF_LIST);

    favoriteID = 4;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(favoriteInfo,favoriteID);
    CPPUNIT_ASSERT(ret != 0);           // an attempt to retrieve the deleted favorite should return error
    CPPUNIT_ASSERT(ret == MP_ERR_DB_END_OF_LIST);

}

void FavoritesManagerTest::ReStoreFavorites(void)
{
        ENTRY_TEST

    tResult ret = 0;
    tFavoriteID retFavID;

    /*store an known object in the database as favorite*/
    tObjectID objectID = FAVORITE_1_OBJECT_ID;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().StoreFavorite(OUT retFavID,IN objectID);

    CPPUNIT_ASSERT(ret == 0);             //favorite store success full
    CPPUNIT_ASSERT(5 == retFavID); // favorite ID will auto increment with every new store

    /******************************************************************************************************/

    objectID = FAVORITE_2_OBJECT_ID;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().StoreFavorite(OUT retFavID,IN objectID);

    CPPUNIT_ASSERT(ret == 0);             //favorite store success full
    CPPUNIT_ASSERT(6== retFavID); // favorite ID will auto increment with every new store

    /******************************************************************************************************/

    /*store one more object as favorite*/
    objectID = FAVORITE_3_OBJECT_ID;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().StoreFavorite(OUT retFavID,IN objectID);

    CPPUNIT_ASSERT(ret == 0);      //favorite store success full
    CPPUNIT_ASSERT(7 == retFavID); // favorite ID will auto increment with every new store

    /******************************************************************************************************/
    /*trace all available Favorites again*/
    vector<tFavoriteInfo> favoritesInfo;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetAllFavoriteInfo(favoritesInfo);

    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT(3 == favoritesInfo.size());

    ETG_TRACE_USR2(("GetAllFavorites after Restore, total count  : %d \n",favoritesInfo.size()));
    unsigned int iter;
    for(iter=0; iter<favoritesInfo.size(); iter++)
    {
        VARTRACE(favoritesInfo[iter])
    }
    /******************************************************************************************************/
}

void FavoritesManagerTest::UpdateFavoriteStatus(void)
{
        ENTRY_TEST

    tResult ret = 0;
    tFavoriteInfo favoriteInfo;

    ret = LocalSPM::GetDBManager().UpdateFavoriteStatus(5,false,true);
    CPPUNIT_ASSERT(ret == 0);
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(OUT favoriteInfo,IN 5);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT(FALSE == favoriteInfo.available);
    CPPUNIT_ASSERT(FALSE != favoriteInfo.active);

    ret = LocalSPM::GetDBManager().UpdateFavoriteStatus(7,false,false);
    CPPUNIT_ASSERT(ret == 0);
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(OUT favoriteInfo,IN 7);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT(FALSE == favoriteInfo.available);
    CPPUNIT_ASSERT(FALSE == favoriteInfo.active);

    ret = LocalSPM::GetDBManager().UpdateFavoriteStatus(6,true,true);
    CPPUNIT_ASSERT(ret == 0);
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(OUT favoriteInfo,IN 6);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT(FALSE != favoriteInfo.available);
    CPPUNIT_ASSERT(FALSE != favoriteInfo.active);

    ret = LocalSPM::GetDBManager().UpdateFavoriteStatus(5,true,false);
    CPPUNIT_ASSERT(ret == 0);
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(OUT favoriteInfo,IN 5);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT(FALSE != favoriteInfo.available);
    CPPUNIT_ASSERT(FALSE == favoriteInfo.active);

    ret = LocalSPM::GetDBManager().UpdateFavoriteStatus(6,false,false);
    CPPUNIT_ASSERT(ret == 0);
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(OUT favoriteInfo,IN 6);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT(FALSE == favoriteInfo.available);
    CPPUNIT_ASSERT(FALSE == favoriteInfo.active);

    ret = LocalSPM::GetDBManager().UpdateFavoriteStatus(7,true,true);
    CPPUNIT_ASSERT(ret == 0);
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(OUT favoriteInfo,IN 7);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT(FALSE != favoriteInfo.available);
    CPPUNIT_ASSERT(FALSE != favoriteInfo.active);

    tBoolean favChanged;
	tFavoriteID favoriteID = 7;

	ret = LocalSPM::GetCustomControl().GetFavoritesManager().UpdateFavoriteStatus(OUT favChanged,IN favoriteID);
	CPPUNIT_ASSERT(ret == 0);
}

void FavoritesManagerTest::DeActivateAllFavorites(void)
{
        ENTRY_TEST

    tResult ret = 0;

    //ReSet the Active flag of all the stored favorites in the DB
    ret = LocalSPM::GetDBManager().DeActivateAllFavorites();
    CPPUNIT_ASSERT(ret == 0);

    tFavoriteInfo favoriteInfo;

    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(OUT favoriteInfo,IN 5);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT(favoriteInfo.active == 0);

    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(OUT favoriteInfo,IN 6);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT(favoriteInfo.active == 0);

    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(OUT favoriteInfo,IN 7);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT(favoriteInfo.active == 0);
}

void FavoritesManagerTest::StoreArtist(void)
{
        ENTRY_TEST

    tResult ret = 0;
    tFavoriteID retFavID;

    /*store an known object in the database as favorite*/
    tObjectID objectID = FAVORITE_5_OBJECT_ID;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().StoreFavorite(OUT retFavID,IN objectID);

    CPPUNIT_ASSERT(ret == 0);      //favorite store success full
    CPPUNIT_ASSERT(8 == retFavID); // favorite ID will auto increment with every new store

    tFavoriteInfo favoriteInfo;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo( OUT favoriteInfo, IN retFavID);
    CPPUNIT_ASSERT(ret == 0);

    ETG_TRACE_USR1(("FavoritesManagerTest::StoreArtist -> stored:%128s,expected:%s", favoriteInfo.labelText, FAVORITE_5_LABEL));
    CPPUNIT_ASSERT_MESSAGE("Stored Artist label is not as expected !! ",!strcmp(favoriteInfo.labelText, FAVORITE_5_LABEL));    //verify artist stored
}

void FavoritesManagerTest::ActivateArtist(void)
{
        ENTRY_TEST

    tResult ret = 0;
    tFavoriteID retFavID;
    tFavoriteID favID = 8;

    ret = LocalSPM::GetCustomControl().GetFavoritesManager().ActivateFavorite(OUT retFavID, IN favID, LC_MAIN_AUDIO, LC_MAIN_AUDIO);

    CPPUNIT_ASSERT(ret == 0);             //favorite activation success full
    CPPUNIT_ASSERT(favID == retFavID);

    tFavoriteInfo favoriteInfo;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo( OUT favoriteInfo, IN favID);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT(FALSE != favoriteInfo.active);    //verify if active flag set on the favorite

    /*wait for playback to start*/
    sleep(2);

    /*Verify if PlayerManager is in Active state*/
    tBoolean isActive = FALSE;
    ret = LocalSPM::GetPlayerManager().GetActiveState(OUT isActive);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT_MESSAGE("Playermanager is not active !", isActive);

    /*Verify if PlayerManager::NowPlaying is same as the requested Favorite is in Active state*/
    tNowPlaying nowPlaying;
    ret = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
    CPPUNIT_ASSERT(ret == 0);

    VARTRACE(nowPlaying);
#ifdef TEST_VALIDATE_LABELS
    CPPUNIT_ASSERT_MESSAGE("Activated Artist's metaData is not matching nowPlaying Artist name!! ",!strcmp(nowPlaying.object.MetadataField2, FAVORITE_5_LABEL));    //verify Artist
#endif
}

void FavoritesManagerTest::StoreGenre(void)
{
        ENTRY_TEST

    tResult ret = 0;
    tFavoriteID retFavID;

    /*store an known object in the database as favorite*/
    tObjectID objectID = FAVORITE_6_OBJECT_ID;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().StoreFavorite(OUT retFavID,IN objectID);

    CPPUNIT_ASSERT(ret == 0);      //favorite store success full
    CPPUNIT_ASSERT(9 == retFavID); // favorite ID will auto increment with every new store

    tFavoriteInfo favoriteInfo;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo( OUT favoriteInfo, IN retFavID);
    CPPUNIT_ASSERT(ret == 0);

    ETG_TRACE_USR1(("FavoritesManagerTest::StoreGenre -> stored:%128s,expected:%s", favoriteInfo.labelText, FAVORITE_6_LABEL));
    CPPUNIT_ASSERT_MESSAGE("Stored Genre label is not as expected !! ",!strcmp(favoriteInfo.labelText, FAVORITE_6_LABEL));    //verify genre

}

void FavoritesManagerTest::ActivateGenre(void)
{
        ENTRY_TEST

    tResult ret = 0;
    tFavoriteID retFavID;
    tFavoriteID favID = 9;

    ret = LocalSPM::GetCustomControl().GetFavoritesManager().ActivateFavorite(OUT retFavID,IN favID,LC_MAIN_AUDIO,LC_MAIN_AUDIO);

    CPPUNIT_ASSERT(ret == 0);             //favorite activation success full
    CPPUNIT_ASSERT(favID == retFavID);

    tFavoriteInfo favoriteInfo;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo( OUT favoriteInfo, IN favID);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT(FALSE != favoriteInfo.active);    //verify if active flag set on the favorite

    /*wait for playback to start*/
    sleep(2);

    /*Verify if PlayerManager is in Active state*/
    tBoolean isActive = FALSE;
    ret = LocalSPM::GetPlayerManager().GetActiveState(OUT isActive);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT_MESSAGE("PlayerManager is not active !", isActive);

    /*Verify if PlayerManager::NowPlaying is same as the requested Favorite is in Active state*/
    tNowPlaying nowPlaying;
    ret = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
    CPPUNIT_ASSERT(ret == 0);

    VARTRACE(nowPlaying);
#ifdef TEST_VALIDATE_LABELS
    CPPUNIT_ASSERT_MESSAGE("Activated Genre's metadata not matching with nowPlaying's Genre's name",!strcmp(nowPlaying.object.MetadataField1, FAVORITE_6_LABEL));    //verify Genre
#endif
}


void FavoritesManagerTest::StoreAlbum(void)
{
        ENTRY_TEST

    tResult ret = 0;
    tFavoriteID retFavID;

    /*store an known object in the database as favorite*/
    tObjectID objectID = FAVORITE_7_OBJECT_ID;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().StoreFavorite(OUT retFavID,IN objectID);

    CPPUNIT_ASSERT(ret == 0);      //favorite store success full
    CPPUNIT_ASSERT(10 == retFavID); // favorite ID will auto increment with every new store

    tFavoriteInfo favoriteInfo;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo( OUT favoriteInfo, IN retFavID);
    CPPUNIT_ASSERT(ret == 0);

    ETG_TRACE_USR1(("FavoritesManagerTest::StoreAlbum -> stored:%128s,expected:%s", favoriteInfo.labelText, FAVORITE_7_LABEL));

#ifdef TEST_VALIDATE_LABELS
    CPPUNIT_ASSERT_MESSAGE("Stored album label is not as expected !! ",!strcmp(favoriteInfo.labelText, FAVORITE_7_LABEL));    //verify album
#endif
}

void FavoritesManagerTest::ActivateAlbum(void)
{
        ENTRY_TEST

    tResult ret = 0;
    tFavoriteID retFavID;
    tFavoriteID favID = 10;

    ret = LocalSPM::GetCustomControl().GetFavoritesManager().ActivateFavorite(OUT retFavID,IN favID,LC_MAIN_AUDIO,LC_MAIN_AUDIO);

    CPPUNIT_ASSERT(ret == 0);             //favorite activation success full
    CPPUNIT_ASSERT(favID == retFavID);

    tFavoriteInfo favoriteInfo;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo( OUT favoriteInfo, IN favID);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT(FALSE != favoriteInfo.active);    //verify if active flag set on the favorite

    /*wait for playback to start*/
    sleep(2);

    /*Verify if PlayerManager is in Active state*/
    tBoolean isActive = FALSE;
    ret = LocalSPM::GetPlayerManager().GetActiveState(OUT isActive);
    CPPUNIT_ASSERT(ret == 0);
    CPPUNIT_ASSERT_MESSAGE("PlayerManager is not active !", isActive);

    /*Verify if PlayerManager::NowPlaying is same as the requested Favorite is in Active state*/
    tNowPlaying nowPlaying;
    ret = LocalSPM::GetPlayerManager().GetNowPlaying(OUT nowPlaying);
    CPPUNIT_ASSERT(ret == 0);

    VARTRACE(nowPlaying);
#ifdef TEST_VALIDATE_LABELS
    CPPUNIT_ASSERT_MESSAGE("Activated Album's metadata not matching with noPlaying's album name!!",!strcmp(nowPlaying.object.MetadataField4, FAVORITE_7_LABEL));    //verify Album
#endif
}

void FavoritesManagerTest::DeviceRemoved(void)
{
        ENTRY_TEST

    tResult ret = 0;
    tFavoriteID favoriteID = 9;

    /* Get device ID */
    tDeviceID deviceID;
    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(ret == 0);

    //Force and set the available flag as true in the Favorites table.
	ret = LocalSPM::GetDBManager().UpdateFavoriteStatus(IN favoriteID, true, true);
	CPPUNIT_ASSERT(ret == 0);

	tFavoriteInfo favoriteInfo;
	InitFavoriteInfo(OUT favoriteInfo);
	ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(OUT favoriteInfo, IN favoriteID);
	CPPUNIT_ASSERT(ret == 0);

	//check for the [forcefully set] available and active flag as true in the Favorites table.
	CPPUNIT_ASSERT(FALSE != favoriteInfo.available);
	CPPUNIT_ASSERT(FALSE != favoriteInfo.active);

    ret = LocalSPM::GetCustomControl().GetFavoritesManager().OnDeviceUpdate(IN deviceID, /*tDeviceConnected*/ false);
	CPPUNIT_ASSERT(ret == 0);      // Device Removed Status updated Successfully

	ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(OUT favoriteInfo, IN favoriteID);
	CPPUNIT_ASSERT(ret == 0);

}

void FavoritesManagerTest::DeviceChanged(void)
{
        ENTRY_TEST

	tResult ret = 0;
	tFavoriteID favoriteID = 9;

    /* Get device ID */
    tDeviceID deviceID;
    ret = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, "USB");
    CPPUNIT_ASSERT(ret == 0);

	//Force and set the available flag as false in the Favorites table.
	ret = LocalSPM::GetDBManager().UpdateFavoriteStatus(IN favoriteID, false, false);
	CPPUNIT_ASSERT(ret == 0);

	tFavoriteInfo favoriteInfo;
	InitFavoriteInfo(OUT favoriteInfo);
	ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(OUT favoriteInfo, IN favoriteID);
	CPPUNIT_ASSERT(ret == 0);

	//check for the [forcefully set] available and active flag as false in the Favorites table.
	CPPUNIT_ASSERT(FALSE == favoriteInfo.available);
	CPPUNIT_ASSERT(FALSE == favoriteInfo.active);

    ret = LocalSPM::GetCustomControl().GetFavoritesManager().OnDeviceUpdate(IN deviceID, /*tDeviceConnected*/ true);
	CPPUNIT_ASSERT(ret == 0);      // Device Reinserted Status updated Successfully

	ret = LocalSPM::GetCustomControl().GetFavoritesManager().GetFavoriteInfo(OUT favoriteInfo, IN favoriteID);
	CPPUNIT_ASSERT(ret == 0);

	//check for the available status in the favorites table after calling OnDeviceChanged Function.
	CPPUNIT_ASSERT(FALSE != favoriteInfo.available);
}

void FavoritesManagerTest::UpdateAllFavoriteStatus(void)
{
    ENTRY_TEST

    tResult ret = 0;

    ret = LocalSPM::GetCustomControl().GetFavoritesManager().UpdateAllFavoriteStatus();
    CPPUNIT_ASSERT(ret == 0);
}

void FavoritesManagerTest::StoreDuplicateFavorite(void)
{
    ENTRY_TEST

    tResult ret = 0;
    tFavoriteID retFavID;

    /*store an known object as favorite which is already stored as favorite , duplicate favorite store*/
    tObjectID objectID = FAVORITE_7_OBJECT_ID;
    ret = LocalSPM::GetCustomControl().GetFavoritesManager().StoreFavorite(OUT retFavID,IN objectID);

    CPPUNIT_ASSERT(ret == 0);      //favorite store success full
    CPPUNIT_ASSERT(11 == retFavID); // favorite ID will auto increment with every new store
}

/*************************************************************/
