#ifndef _CustomControlTest_H_
#define _CustomControlTest_H_


#include <cppunit/extensions/HelperMacros.h>

#include <TypeDefinitions.h>
#include <TimeTrace.h>
class CustomControlTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( CustomControlTest );

    CPPUNIT_TEST( InitTestsuite );

    /* start player manager */
    CPPUNIT_TEST( Allocate );
    CPPUNIT_TEST( SourceActivityOn );

    /* normal methods */
    CPPUNIT_TEST( DiagnosisPlaySong );
    CPPUNIT_TEST( PlayMediaPlayerObject );
    CPPUNIT_TEST( ActiveMediaDeviceGet );
    CPPUNIT_TEST( ActiveMediaDeviceSet );
    CPPUNIT_TEST( SetActiveStreamingDevice );
    CPPUNIT_TEST( PlayObjectID );
    CPPUNIT_TEST( PlayItemFromIndexedList );

    /* Start PlayerManager and Test the Playback of FileList in various RepeatModes --begin */

    /* With OnlyMediaObjectsInFileLists - Enabled and DBFileBrowsingByDB - Disabled -> LTY_FILELIST_MEDIAOBJECTS... */
    CPPUNIT_TEST( EnableFileListsToContainOnlyMediaObjects );

    CPPUNIT_TEST( PlayItemFromFileList_RepeatModeList );
    CPPUNIT_TEST( PlayItemFromFileList_RepeatModeListWithSubLists );
    CPPUNIT_TEST( PlayItemFromFileList_RepeatModeAll );

    /* With OnlyMediaObjectsInFileLists & DBFileBrowsingByDB - Enabled -> LTY_BROWSELIST_MEDIAOBJECTS... */
    CPPUNIT_TEST( EnableBrowseList );
    CPPUNIT_TEST( Allocate );
    CPPUNIT_TEST( SourceActivityOn );

    CPPUNIT_TEST( PlayItemFromFileList_RepeatModeList );
    CPPUNIT_TEST( PlayItemFromFileList_RepeatModeListWithSubLists );
    CPPUNIT_TEST( PlayItemFromFileList_RepeatModeAll );

    /* With OnlyMediaObjectsInFileLists - Disabled and DBFileBrowsingByDB - Enabled -> LTY_BROWSELIST */
    CPPUNIT_TEST( DisableFileListsToContainOnlyMediaObjects );

    CPPUNIT_TEST( PlayItemFromFileListLTY_BROWSELIST_RepeatModeList );

    /* With DBFileBrowsingByDB & OnlyMediaObjectsInFileLists - Disabled -> LTY_FILELIST*/
    CPPUNIT_TEST( DisableBrowseList );
    CPPUNIT_TEST( Allocate );
    CPPUNIT_TEST( SourceActivityOn );

    CPPUNIT_TEST( PlayItemFromFileListLTY_FILELIST_RepeatModeList );
    CPPUNIT_TEST( PlayItemFromFileListLTY_FILELIST_UNSORTED_RepeatModeList ); //No normal use case, such a list is used only for indexing

    /* Start PlayerManager and Test the Playback of FileList in various RepeatModes --end */

    CPPUNIT_TEST( PlayItemFromListByTag );
    CPPUNIT_TEST( CreateQuickPlayListIterative );
    CPPUNIT_TEST( CreateQuickPlayList );
    CPPUNIT_TEST( CreateFolderQuickPlayList );
    CPPUNIT_TEST( CheckListSelection );
    CPPUNIT_TEST( CheckDeviceActivation );
    CPPUNIT_TEST( TimeoutOfStartupTimer );
    CPPUNIT_TEST( StartCheckListTimer );
    CPPUNIT_TEST( StopCheckListTimer );

    /* state machine methods - direct calls */
    CPPUNIT_TEST( HandleDeviceUpdated );
    CPPUNIT_TEST( HandleDeviceConnected );
    CPPUNIT_TEST( HandleDeviceNewDevice );
    CPPUNIT_TEST( HandleDeviceSameDevice );
    CPPUNIT_TEST( HandleDeviceRemoved );
    CPPUNIT_TEST( HandleDeviceActivated );
    CPPUNIT_TEST( HandleDeviceRepeatMode );

    /* stop PlayerManager */
    CPPUNIT_TEST( SourceActivityOff );
    CPPUNIT_TEST( DeAllocate );

    CPPUNIT_TEST_SUITE_END();

public:

    void InitTestsuite();

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    /*test cases*/	
    void Allocate();
    void DeAllocate();
    void SourceActivityOn();
    void SourceActivityOff();
    void PlayMediaPlayerObject();
    void ActiveMediaDeviceGet();
    void ActiveMediaDeviceSet();
    void SetActiveStreamingDevice();
    void PlayObjectID();
    void PlayItemFromIndexedList();
    void EnableBrowseList();
    void DisableBrowseList();
    void PlayItemFromFileList_RepeatModeList();
    void PlayItemFromFileList_RepeatModeListWithSubLists();
    void PlayItemFromFileList_RepeatModeAll();
    void PlayItemFromFileListLTY_FILELIST_RepeatModeList();
    void PlayItemFromFileListLTY_FILELIST_UNSORTED_RepeatModeList();
    void PlayItemFromFileListLTY_BROWSELIST_RepeatModeList();
    void EnableFileListsToContainOnlyMediaObjects();
    void DisableFileListsToContainOnlyMediaObjects();
    void PlayItemFromListByTag();
    void CreateQuickPlayListIterative();
    void CreateQuickPlayList();
    void CreateFolderQuickPlayList();
    void CheckListSelection();
    void CheckDeviceActivation();
    void TimeoutOfStartupTimer();
    void StartCheckListTimer();
    void StopCheckListTimer();
    void HandleDeviceUpdated();
    void HandleDeviceConnected();
    void HandleDeviceNewDevice();
    void HandleDeviceSameDevice();
    void HandleDeviceRemoved();
    void HandleDeviceActivated();
    void HandleDeviceRepeatMode();
    void DiagnosisPlaySong();

private:
    void CreateAndPlayListType(const tDeviceID deviceID, const tListType listType);
    void CreateAndStoreLastModeList(tListID &createdListID, const tDeviceID deviceID);

    tResult CheckPlaybackState(const tHMIPlaybackState stateToReach, const int timeoutInSec);
    tResult WaitForPlaytimeUpdate(int sec = 30);
    tResult WaitForListID(const tListID listID, int sec = 30);
    tResult WaitForObjectID(const tObjectID objectID, int sec = 30);

    TimeTrace ticks; /**< time object to trace the time taken by testcases*/

    pthread_cond_t   condition; /**< wait condition used for asynchronous test cases */
    pthread_mutex_t  mutex; /**< lock used during asynchronous test case execution*/

    void PlayItemFromIndexedList(const tDeviceID &deviceID);
    void PlayItemFromFileList(const tDeviceID &deviceID);

    /*ValidatePlaybackOfSelectedItem -It requests the CustomControl to Play the Item at the Given Index in the list.
     * Then it validates whether the Selected Item Plays,its ListType,postion etc.. are as expected
     */

    void ValidatePlaybackOfSelectedItem(const tListType expectedListType, const tListID listID, const tIndex listindex);
    bool GetAudioFileIndex(tIndex &index, const tListID listID, const tListSize listSize);

};

#endif  // _CustomControlTest_H_
