/*
 * PersonalizationProxy.cpp
 *
 *  Created on: Aug 23, 2017
 *      Author: gre5cob
 */


/* ETG definitions */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CUSTOM_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/PersonalizationProxy.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CUSTOM_CONTROL
#endif
#endif
#include "FunctionTracer.h"
#include "VarTrace.h"

#include "PersonalizationProxy.h"
#include "PersonalizationIpcIF.h"
#include "LocalSPM.h"


PersonalizationProxy& PersonalizationProxy::GetInstance(void)
{
    static PersonalizationProxy instance;
    return instance;
}

PersonalizationProxy::PersonalizationProxy()
{
    mSignalHandlers.clear();
    mSignalHandlers["PropertiesChanged"] = &PersonalizationProxy::PropertiesChanged;

    //Property Interface Names
    mInterfacenames.push_back("org.bosch.cm.persmidw");
}

PersonalizationProxy::~PersonalizationProxy()
{
    // TODO Auto-generated destructor stub
}


bool PersonalizationProxy::belongs(const char* messageName, const char* params)
{
    //ENTRY
    if( (!strcmp(messageName,"PropertiesChanged")))
    {
        tInterfaceName interfacename;
        LocalSPM::GetIPCProvider().GetInterfaceName(OUT interfacename, IN params);

        if (std::find(mInterfacenames.begin(), mInterfacenames.end(), interfacename) != mInterfacenames.end())
        {
            ETG_TRACE_USR4(("Property found for Personalization"));
                return true;
        }
    }
    return false;
}

bool PersonalizationProxy::belongs(tU32 serial) //Override for Virtual function in IPCProvider
{
    return false;
}

void PersonalizationProxy::RouteMethodAnswer(tU32 serial, const char* params)  //Override for Virtual function in IPCProvider
{
    ENTRY

}

void PersonalizationProxy::RouteMethodRequest(tU32 serial, const char* name, const char* params)  //Override for Virtual function in IPCProvider
{
    (void)serial;
    (void)name;
    (void)params;
}

void PersonalizationProxy::RouteError(tU32 serial, const char* error)  //Override for Virtual function in IPCProvider
{
    ENTRY
}


void PersonalizationProxy::RouteSignal(const char* name, const char* params)
{
    ENTRY

    ETG_TRACE_USR1(("PersonalizationProxy signal received %128s:%s",name,params));

    if( (!strcmp(name,"PropertiesChanged")))
    {
        (this->*mSignalHandlers[name])(params);
    }

}


tResult PersonalizationProxy::RegisterForPersonalizationSignals()
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    ret = LocalSPM::GetIPCProvider().IpcClient::SetFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.bosch.cm.persmidw'");
    return ret;
}

tResult PersonalizationProxy::UnRegisterForPersonalizationSignals()
{
    ENTRY

    tResult ret = MP_NO_ERROR;

    ret = LocalSPM::GetIPCProvider().IpcClient::RemoveFilter(GMPDBUS_BUS_SYSTEM,"type='signal',interface='org.bosch.cm.persmidw'");

    return ret;
}

void PersonalizationProxy::PropertiesChanged(const char* params)
{
    ENTRY
    ETG_TRACE_USR1(("PropertiesChanged params %s",params));

    //Find the UserID
    tUserID key = 0;

    int literalCount = 0;
    char *ptr = (char*) strchr(params,IPC_DBUS_PARAM_DELIMITER_INT);
    ETG_TRACE_USR4(("ptr:%p",ptr));
    while (ptr != NULL)
    {
        ptr = strchr(ptr + 1,IPC_DBUS_PARAM_DELIMITER_INT);
        literalCount++;
    }
    std::string strFromChar;
    strFromChar.append(params);
    std::istringstream ss(strFromChar);
    std::string token[literalCount];
    for (int index = 0; index < literalCount; index++)
    {
        std::getline(ss, token[index], IPC_DBUS_PARAM_DELIMITER_CHAR);
    }
    ETG_TRACE_USR4(("literalCount : %d",literalCount));
    for (int index = 0; index < literalCount-1; index ++)
    {
        if (token[index].compare("ActiveProfileInformationStatus") == 0)
        {
            ETG_TRACE_USR4(("Property name: ActiveProfileInformationStatus"));
            sscanf(token[index + 1].c_str(), "%d", &key);
            ETG_TRACE_USR1(("PropertiesChanged key is %d",key));

            LocalSPM::GetInstance().GetCustomControl().SetCurrentUser(IN key);
            break;
        }
    }

    if(!key)
    {
        ETG_TRACE_USR1(("PropertiesChanged ERROR: ProfileID not received from Personalization"));
    }

    return;

}

tResult PersonalizationProxy::ActiveProfileInformationGet()
{
    ENTRY
    tResult ret = MP_NO_ERROR;

    bool isError = false;
    string params;
    int reply_timeout = 1000;
    bool isSystemBus = true;

    DbusParam dbusParam;
    dbusParam.type = DBUS_TYPE_STRING;
    dbusParam.value.append(IPC_PERSONALIZATION_INTERFACE);
    DbusParam dbusParam1;
    dbusParam1.type = DBUS_TYPE_STRING;
    dbusParam1.value.append("ActiveProfileInformationStatus");
    DbusParamList dbusParamList;
    dbusParamList.push_back(dbusParam);
    dbusParamList.push_back(dbusParam1);

    string objectPath;
    tUserID key = 0;
    objectPath.append(IPC_PERSONALIZATION_OBJECT_PATH);
    ETG_TRACE_USR4(("Objectpath for ActiveProfileInformationStatus %s", objectPath.c_str()));


    const IpcMessageInfo ipcMessageInfo = { IPC_PERSONALIZATION_SERVICE, objectPath.c_str(), "org.freedesktop.DBus.Properties", "Get" };
    VARTRACE(ipcMessageInfo.destination);
    VARTRACE(ipcMessageInfo.object_path);
    VARTRACE(ipcMessageInfo.interface_name);
    VARTRACE(ipcMessageInfo.message_name);

    LocalSPM::GetIPCProvider().MethodCallWaitForReplyNoOverride(ipcMessageInfo, IN dbusParamList, isSystemBus, reply_timeout, isError, params);

    if (isError)
    {
        return MP_ERR_DBUS;
    }
    else if (params.empty())
    {
        return MP_ERR_NO_PROFILE;
    }


    ETG_TRACE_USR4(("Return params ptr:%s", params.c_str()));

    std::string strFromChar;
    strFromChar.append(params);
    std::istringstream ss(strFromChar);
    std::string token;

    std::getline(ss, token, IPC_DBUS_PARAM_DELIMITER_CHAR);

    sscanf(token.c_str(), "%d", &key);
    ETG_TRACE_USR1(("ActiveProfileInformationGet key is %d", key));

    LocalSPM::GetInstance().GetCustomControl().SetCurrentUser(IN key);

    if (!key)
    {
        ETG_TRACE_USR1(("ActiveProfileInformationGet ERROR: ProfileID not received from Personalization"));
    }

    return ret;
}
