/*
 * PersonalizationProxy.h
 *
 *  Created on: Aug 23, 2017
 *      Author: gre5cob
 */

#ifndef GENERICMEDIAPLAYER_CUSTOMCONTROL_SRC_PERSONALIZATIONPROXY_H_
#define GENERICMEDIAPLAYER_CUSTOMCONTROL_SRC_PERSONALIZATIONPROXY_H_

#include <map>
#include<sstream>
#include<iostream>
#include "IPCProvider.h"

class PersonalizationProxy : public IPCListener
{
public:
    /*
     * returns singleton instance of Personalization proxy class
     **/
    static PersonalizationProxy &GetInstance();

    PersonalizationProxy(void);
    virtual ~PersonalizationProxy();

    /*
    * To check for signalname in message
    */
   bool belongs(const char* messageName, const char* params) ;

   /*
    * Overridden to avoid pure virtual function
    */
   bool belongs(tU32 serial) ;

   /*
    * receives the dbus signal from the Personalization and taken necessary action
    */
   void RouteSignal(const char* name, const char* params) ;

   /*
    * Overridden to avoid pure virtual function
    */
   void RouteMethodAnswer(tU32 serial, const char* params) ;

   /*
    * Overridden to avoid pure virtual function
    */
   void RouteMethodRequest(tU32 serial, const char* name, const char* params) ;

   /*
    * Overridden to avoid pure virtual function
    */
   void RouteError(tU32 serial, const char* error) ;

    tResult RegisterForPersonalizationSignals();
    tResult UnRegisterForPersonalizationSignals();

    /*
    * Get the Property emitted from Personalization 
    */
    tResult ActiveProfileInformationGet();

private:
    /*Signal handlers*/
    void PropertiesChanged (const char* params);

    typedef void (PersonalizationProxy::*MessageHandler)(const char* params,bool isError); /**< signature of generic message/error handler function */
    typedef void (PersonalizationProxy::*SignalHandler)(const char* params); /**< signature of generic message handler function */

    map<tU32, MessageHandler> mMessageHandlers; /**< map of DBus serial and specific message handler function */
    map<string, SignalHandler> mSignalHandlers; /**< map of signal name and specific signal handler function */

    Lock mMessageHandlersMutex;                                       /**< lock for accessing mMessageHandlers map */
    vector<string> mInterfacenames;    /* Names of the Interface name for this component*/
};

#endif /* GENERICMEDIAPLAYER_CUSTOMCONTROL_SRC_PERSONALIZATIONPROXY_H_ */
