/**
 * @defgroup Configuration Configuration
 * @author Stefan Scherber, Matthias Thömel
 *
 * Public interface for which will be implemented by the customer
 * @{
 */

#ifndef CONFIGURATION_H_
#define CONFIGURATION_H_

#include <vector>

#include "ILocalSPM.h"
#include "TypeDefinitions.h"
#include "sortlib_helper.h"

/* project specific configuration file can use this macro to activate a file format */
#define SUPPORTED_FILE_TYPE(number,extension,format,type) \
    LocalSPM::GetDataProvider().SupportedFileTypeExtension_ ##number = extension; \
    LocalSPM::GetDataProvider().SupportedFileTypeFormat_ ##number = format; \
    LocalSPM::GetDataProvider().SupportedFileTypeType_ ##number = type;

/* project specific configuration file can use this macro to set a codec restriction */
#define CODEC_RESTRICTION(number,codec,profile,supported,max_level,max_width,max_height,max_bitrate,max_framerate) \
    LocalSPM::GetDataProvider().CodecRestrictionCodec_ ##number = codec; \
    LocalSPM::GetDataProvider().CodecRestrictionProfile_ ##number = profile; \
    LocalSPM::GetDataProvider().CodecRestrictionSupported_ ##number = supported; \
    LocalSPM::GetDataProvider().CodecRestrictionMaxLevel_ ##number = (float)max_level; \
    LocalSPM::GetDataProvider().CodecRestrictionMaxWidth_ ##number = max_width; \
    LocalSPM::GetDataProvider().CodecRestrictionMaxHeight_ ##number = max_height; \
    LocalSPM::GetDataProvider().CodecRestrictionMaxBitRate_ ##number = max_bitrate; \
    LocalSPM::GetDataProvider().CodecRestrictionMaxFrameRate_ ##number = max_framerate;


class Configuration : public ILocalSPM
{

public:
	Configuration(tComponentID componentId):ILocalSPM(componentId)
	{
	    init = false;
	};
	virtual ~Configuration(){};

public:	

    /**
     * loads early configurations into the data base to be usable by the data provider
     *
     * @return < 0: error, = 0: OK
     */
	virtual tResult PreLoadSettings(void)
	{
	    return -1; /* overload function not called, under customer an implementation should be available */
	}

    /**
     * loads all needed configurations into the data base to be usable by the data provider
     *
     * @return < 0: error, = 0: OK
     */
	virtual tResult LoadSettings(void)
	{
	    return -1; /* overload function not called, under customer an implementation should be available */
	}

    unsigned* SortlibGetRuleTable()
    {
        if (false == init)
        {
            CreateSortlibRuleTable();
            init = true;
        }
        return sortTable;
    }

protected:

  unsigned sortTable[SORTLIB_ARRAY_SIZE];   

  bool init;

  virtual void CreateSortlibRuleTable() = 0;

};

#endif /*CONFIGURATION_H_*/

/** @} */
