#ifndef _UTF8FileNameTest_H_
#define _UTF8FileNameTest_H_

#include <cppunit/extensions/HelperMacros.h>

#include <TypeDefinitions.h>
#include <TimeTrace.h>

/*lint -save -e578 */

class UTF8FileNameTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( UTF8FileNameTest );
    CPPUNIT_TEST( testParentDir );
	CPPUNIT_TEST( testParentDir2 );
	CPPUNIT_TEST( testAppendPath );
	CPPUNIT_TEST( testPureName );
    CPPUNIT_TEST( testGetCString );
    CPPUNIT_TEST( FastEndsWith );
    CPPUNIT_TEST( FastSplit );
    CPPUNIT_TEST_SUITE_END();

public:

    /*common to all test cases triggered before and after respectively*/
    void setUp();
    void tearDown();

    /*test cases*/
    void testParentDir();
	void testParentDir2();
	
	void testAppendPath();
	
	void testPureName();
    void testGetCString();

    void FastEndsWith();
    void FastSplit();

private:
    TimeTrace	 	 ticks;			/**< time object to trace the time taken by testcases*/

    pthread_cond_t   condition ;	/**< wait condition used for asynchronous test cases */
    pthread_mutex_t  mutex ;		/**< lock used during asynchronous test case execution*/
};

#endif  // _MEDIAPLAYERTEST_H_
