/*
 * FastUTF8.h
 *
 *  Created on: Dec 2, 2012
 *      Author: matthias
 */

#ifndef _FASTUTF8_H_
#define _FASTUTF8_H_

class FastUTF8 {

public:
	typedef unsigned char * tString;
	typedef unsigned char   tStringBuffer;

    /**
	 * checks if a utf8 file name ends with a specific string (extension)
	 *
	 * @param[in] string string with an utf8 file name
	 * @param[in] extension test string contains the extension to be searched in the string
	 *
	 * @return = 1: extension found
	 *         = 0: extension not found
	 */
	static const tString EndsWith(const tString fileName, const tString extension);
	static const tString EndsWithNC(const tString fileName, const tString extension);

	/**
	 * checks if a utf8 file name starts with a specific string (prefix)
     *
	 * @param[in] fileName string with an utf8 file name
	 * @param[in] prefix string
	 *
	 * @return = tString:pointer to end of the prefix match in the main string
	 *         = NULL: if string does not begin with the given prefix
	 */
	static const tString StartsWith(const tString fileName, const tString prefix);

    /**
	 * splits a string into base path and file name
	 *
	 * Attention: the fillName string will be modified (0 at last slash position)
	 *
	 * @param[out] fileName points to the start of the pure file name
	 * @param[in] fullName full utf8 file path
	 *
	 * @return pointer to the fullName which ends at last former slash (so it is the base path name)
	 */
	static const tString Split(tString &fileName, const tString fullName);
	static const tString Split(tString &fileName, const tString fullName, const tString separator);

    /**
     * splits a string into base path/file name and extension
     *
     * Attention: the fillName string will be modified (0 at last slash position)
     *
     * @param[out] extension points to the start of the extension
     * @param[in] fullName full utf8 file path
     *
     * @return pointer to the fullName which ends at last dot (.) (so it is the base path name)
     */
	static const tString SplitExtension(tString &extension, const tString fullName);

	static int Compare(tString c1, tString c2, int noCase);
	static int Compare(tString c1, tString c2);
	static int CompareNC(tString c1, tString c2);
	static tString Next(tString nextString);
	static tString Prev(tString prevString);
	static int Count(const tString fullName, const tString separator);
	static int isValid(tString nextString);
};

#endif /* _FASTUTF8_H_ */
