#ifndef _TYPE_DEFINITIONS_CPP_
#define _TYPE_DEFINITIONS_CPP_

#include <stdio.h>
#include <string.h>

#include <iostream>
#include <stdlib.h>
#include "TypeDefinitions.h"
#include "Lock.h"

/* only for module tests: */
int gIPODConnected = 1; // by default the devices are connected, set to zero in test main
int gMTPConnected = 1;

void InitTagTransfer(tTagTransfer &tagTransfer)
{
    memset(&tagTransfer, 0, sizeof(tTagTransfer));
}

void InitUntransferredTag(tUntransferredTag &untransferredTag)
{
    memset(&untransferredTag, 0, sizeof(tUntransferredTag));
}

void InitDeviceInfo(tDeviceInfo &deviceInfo)
{
    memset(&deviceInfo, 0, sizeof(tDeviceInfo));
    deviceInfo.deviceID = DEVICE_ID_NOT_SET;
    deviceInfo.indexedState = IDS_NOT_STARTED;
    deviceInfo.connectionState = CS_DISCONNECTED;
    deviceInfo.formerConnectionState = CS_DISCONNECTED;
    deviceInfo.numberOfAudioFiles = NUMBER_OF_FILES_NONE;
    deviceInfo.numberOfVideoFiles = NUMBER_OF_FILES_NONE;
    deviceInfo.numberOfImageFiles = NUMBER_OF_FILES_NONE;
    deviceInfo.disconnectReason = DR_REMOVED;
    deviceInfo.discType = DISC_NONE;
    deviceInfo.coverArtConStatus = UNKNOWN;
    deviceInfo.btLimitationActionState = BTLIMITATION_ACTION_STATE_INVALID;

}

void InitAppInfo(tAppInfo &appInfo)
{
    memset(&appInfo, 0, sizeof(tAppInfo));
   // appInfo.option = AIO_DEVICE_MODE_ONLY;
}


void InitDeviceProperty(tDeviceProperty &devProp)
{
    memset(&devProp, 0, sizeof(tDeviceProperty));
}

void InitMediaObjectInfo(tMediaObjectInfo &mediaObjectInfo)
{
    memset(&mediaObjectInfo, 0, sizeof(tMediaObjectInfo));
}

#if USE_IMAGE_OBJECT
void InitImageObject(tImageObject &ImageObject)
{
    memset(&ImageObject, 0, sizeof(tImageObject));
}
#endif

void InitListInfo(tListInfo &listInfo)
{
    memset(&listInfo, 0, sizeof(tListInfo));
    listInfo.listID = LIST_ID_NONE;
    listInfo.parent = LIST_ID_NONE;
    listInfo.next = LIST_ID_NONE;
    listInfo.listType = LTY_END_OF_EXTERNAL_LIST_TYPES;
    listInfo.deviceID = DEVICE_ID_NOT_SET;
    listInfo.playContinuation = PC_NO_REPEAT;
    listInfo.fileTypeSelection = FTS_AUDIO_VIDEO_PLAYLIST;
}

void InitMediaObject(tMediaObject &mediaObject)
{
    memset(&mediaObject, 0, sizeof(tMediaObject));
    mediaObject.deviceID = DEVICE_ID_NOT_SET;
    mediaObject.objectID = OBJECT_ID_NONE;
    mediaObject.fileFormat = FFT_UNKNOWN;
    mediaObject.fileType = FT_UNKNOWN;
    mediaObject.audioChannelFormat = ACF_UNKNOWN;
    mediaObject.notPlayable = FNP_PLAYABLE;
    mediaObject.totalPlaytime = PLAYTIME_NONE;
}

void InitNowShowing(tNowShowing &nowShowing)
{
    nowShowing.listID = 0;
    nowShowing.state = NP_NO_DEVICE;
    nowShowing.position = 0;
    InitMediaObject(nowShowing.object);
    nowShowing.nextFile[0] = '\0';
}

void InitUserContext(tUserContext &userContext)
{
    memset(&userContext, 0, sizeof(tUserContext));
}

void InitIndexingContext(tIndexingContext &indexingContext)
{
    memset(&indexingContext, 0, sizeof(tIndexingContext));
    indexingContext.deviceID = DEVICE_ID_NOT_SET;
    indexingContext.deviceType = DTY_UNKNOWN;
    indexingContext.indexingMode = IM_FULL_SCAN;
    indexingContext.flushFirstPlayableObject = false;
    indexingContext.flushFirstPlayableVideoObject = false;
    indexingContext.flushFirstPlayableImageObject = false;
}

void InitAlbumArtIndexingContext(tAlbumArtIndexingContext &indexingContext)
{
    //memset(&indexingContext, 0, sizeof(tAlbumArtIndexingContext));
    indexingContext.deviceID = DEVICE_ID_NOT_SET;
    indexingContext.listID = LIST_ID_NONE;
    indexingContext.startIndex = 0;
    indexingContext.sliceSize = 0;
    indexingContext.interimList = false;
    indexingContext.mediaObjectVector.clear();
    indexingContext.objectIndex = 0;
}

void InitFileTypeEntry(tFileTypeEntry &fileTypeEntry)
{
    memset(&fileTypeEntry, 0, sizeof(tFileTypeEntry));
}

void InitIndexingStateResult(tIndexingStateResult &indexingStateResult)
{
    memset(&indexingStateResult, 0, sizeof(tIndexingStateResult));
}

void InitDirectoryContext(tDirectoryContext &directoryContext)
{
    memset(&directoryContext, 0, sizeof(tDirectoryContext));
    directoryContext.listID = LIST_ID_NONE;
}

void InitScanContext(tScanContext &scanContext)
{
    //memset(&scanContext, 0, sizeof(tScanContext));
    scanContext.deviceID = DEVICE_ID_NOT_SET;
    scanContext.fingerprint[0] = 0;
    scanContext.lastFingerprint[0] = 0;
    scanContext.fingerprintStatus = FPS_NOT_AVAIL;
    scanContext.numberOfFiles = NUMBER_OF_FILES_NONE; //NCG3D-8166
    scanContext.firstPath[0] = 0;
    scanContext.firstElementRow = ROW_NUMBER_NONE;
    scanContext.deep = 0;
    scanContext.dirContext.clear();

    scanContext.firstAudioFileScanStatus = IGNORE_AVAILABILITY_CHECK;
    scanContext.firstScannedAudioFileName[0] = 0;
}

void InitFiles(tFiles &file)
{
    memset(&file, 0, sizeof(tFiles));
    file.type = FT_UNKNOWN;
    file.objectID = OBJECT_ID_NONE;
    file.fileFormat = FFT_UNKNOWN;
    file.notPlayable = FNP_PLAYABLE;
}

void InitFavoriteInfo(tFavoriteInfo &favoriteInfo)
{
    memset(&favoriteInfo, 0, sizeof(tFavoriteInfo));
}

void InitPETimeInfoStruct(tPETimeInfoStruct &info)
{
    memset(&info, 0, sizeof(tPETimeInfoStruct));

    info.position.bytes = BYTES_NONE;
    info.position.pct = PERCENTAGE_NONE;
    info.position.ms = MILLISECONDS_NONE;
    info.duration.bytes = BYTES_NONE;
    info.duration.ms = MILLISECONDS_NONE;
}
void InitDiPOLocationInfoType(tDiPOLocationInfoType &DiPOLocationInfoType)
{
    memset(&DiPOLocationInfoType, 0, sizeof(tDiPOLocationInfoType));
}

void InitDiPOGPRMCDataStatusValues(tDiPOGPRMCDataStatusValues &diPOGPRMCDataStatusValues)
{
    memset(&diPOGPRMCDataStatusValues, 0, sizeof(tDiPOGPRMCDataStatusValues));
}

void InitBTProfile(tBTProfile &BTProfile)
{
    memset(&BTProfile, 0, sizeof(tBTProfile));
}

void InitBTProfileInfo(tBTProfileInfo &BTProfileInfo)
{
    memset(&BTProfileInfo, 0, sizeof(tBTProfileInfo));
    BTProfileInfo.deviceID = DEVICE_ID_NOT_SET;
}

void InitDiPOCallStateItem(tDiPOCallStateItem &callStateItem)
{
    memset(&callStateItem, 0, sizeof(tDiPOCallStateItem));
    callStateItem.status = tDiPOCallStatus_init;
    callStateItem.direction = tDiPOCallDirection_init;
    callStateItem.service = tDiPOCallService_init;
    callStateItem.disconnectReason = tDiPOCallDisconnectReason_init;
}

void InitDiPONowPlaying(tDiPONowPlaying &DiPONowPlaying)
{
    memset(&DiPONowPlaying, 0, sizeof(tDiPONowPlaying));
}

void InitDiPOCommunications(tDiPOCommunications &communications)
{
    memset(&communications, 0, sizeof(tDiPOCommunications));
    communications.signalStrength = tDiPOCommunicationsSignalStrength_init;
    communications.registrationStatus = tDiPOCommunicationsRegistrationStatus_init;
}

tBoolean IsMassStorageDevice(const tDeviceType deviceType)
{
    tBoolean answer = false;

    if((DTY_USB == deviceType)
       ||
       (DTY_SD == deviceType)
       ||
       (DTY_FLASH == deviceType)
       ||
       (DTY_CDROM == deviceType))
    {
        answer = true;
    }

    return answer;
}

tBoolean IsAppleDevice(const tDeviceType deviceType)
{
    tBoolean answer = false;

    if((DTY_IPOD == deviceType)
       ||
       (DTY_IPHONE == deviceType))
    {
        answer = true;
    }

    return answer;
}

tBoolean IsProtocol_IAP1(const tInitDeviceProtocol protocol)
{
    return (protocol == IDP_IAP1 ||
            protocol == IDP_IAP1BT);
}

tBoolean IsProtocol_IAP2(const tInitDeviceProtocol protocol)
{
    return (protocol == IDP_IAP2 ||
            protocol == IDP_IAP2BT ||
            protocol == IDP_IAP2CARPLAY ||
            protocol == IDP_IAP2NATIVE_TRANSPORT ||
            protocol == IDP_IAP2CARPLAY_NATIVE_TRANSPORT ||
            protocol == IDP_IAP2_OVER_WIRELESS_CARPLAY ||
            protocol == IDP_IAP2CARLIFE_NATIVE_TRANSPORT);
}

tBoolean IsProtocol_IAP2HostMode(const tInitDeviceProtocol protocol)
{
    return (protocol == IDP_IAP2CARPLAY ||
            protocol == IDP_IAP2NATIVE_TRANSPORT ||
            protocol == IDP_IAP2CARPLAY_NATIVE_TRANSPORT ||
            protocol == IDP_IAP2CARLIFE_NATIVE_TRANSPORT);
}

tBoolean IsProtocol_IAP2CarPlay(const tInitDeviceProtocol protocol)
{
    return (protocol == IDP_IAP2CARPLAY ||
            protocol == IDP_IAP2CARPLAY_NATIVE_TRANSPORT );
}

tBoolean IsProtocol_IAP2CarLife(const tInitDeviceProtocol protocol)
{
    return (protocol == IDP_IAP2CARLIFE_NATIVE_TRANSPORT);
}

tBoolean IsProtocol_IAP2NativeTransport(const tInitDeviceProtocol protocol)
{
    return (protocol == IDP_IAP2NATIVE_TRANSPORT ||
            protocol == IDP_IAP2CARPLAY_NATIVE_TRANSPORT ||
            protocol == IDP_IAP2CARLIFE_NATIVE_TRANSPORT);
}

tBoolean IsProtocol_BT(const tInitDeviceProtocol protocol)
{
    return (protocol == IDP_IAP1BT ||
            protocol == IDP_IAP2BT);
}
tBoolean IsProtocol_IAP2OverWirelessCarplay(const tInitDeviceProtocol protocol)
{
    return (protocol == IDP_IAP2_OVER_WIRELESS_CARPLAY );
}


tBoolean IsDiPOCapability_HostMode(const tDiPOCaps caps)
{
    return (caps == DIPO_CAP_CARPLAY ||
            caps == DIPO_CAP_NATIVE_TRANSPORT ||
            caps == DIPO_CAP_CARPLAY_NATIVE_TRANSPORT);
}

tBoolean IsDiPOCapability_CarPlay(const tDiPOCaps caps)
{
    return (caps == DIPO_CAP_CARPLAY ||
            caps == DIPO_CAP_CARPLAY_NATIVE_TRANSPORT);
}

tBoolean IsDiPOCapability_NativeTransport(const tDiPOCaps caps)
{
    return (caps == DIPO_CAP_NATIVE_TRANSPORT ||
            caps == DIPO_CAP_CARPLAY_NATIVE_TRANSPORT);
}

tBoolean IsFileList(const tListType listType)
{
    tBoolean answer = false;

    switch(listType) {
    case LTY_FILELIST:
    case LTY_FILELIST_UNSORTED:
    case LTY_FILELIST_PLAYLIST:
    case LTY_FILELIST_MEDIAOBJECTS:
    case LTY_FILELIST_MEDIAOBJECTS_WITH_SUBFOLDERS:
    case LTY_BROWSELIST:
    case LTY_BROWSELIST_MEDIAOBJECTS:
    case LTY_BROWSELIST_MEDIAOBJECTS_WITH_SUBFOLDERS:
    case LTY_BROWSELIST_MEDIAOBJECTS_ALL:
    case LTY_MTP_FILELIST:
    case LTY_BLUETOOTH_FILELIST:
    case LTY_CD:
    case LTY_IMAGE_FOLDER_ITEM:
        answer = true;
        break;
    default:
        break;
    }

    return answer;
}

tBoolean IsPlayableList(const tListType listType)
{
    tBoolean answer = false;

    switch(listType) {
    case LTY_SONG:
    case LTY_GENRE_ARTIST_ALBUM_SONG:
    case LTY_GENRE_ARTIST_SONG:
    case LTY_GENRE_ALBUM_SONG:
    case LTY_YEAR_ALBUM_SONG:
    case LTY_GENRE_SONG:
    case LTY_ARTIST_ALBUM_SONG:
    case LTY_ARTIST_SONG:
    case LTY_ALBUM_SONG:
    case LTY_ALBUM:
    case LTY_PODCAST_EPISODE:
    case LTY_BOOKTITLE_CHAPTER:
    case LTY_AUTHOR_BOOKTITLE_CHAPTER:
    case LTY_COMPOSER_ALBUM_SONG:
    case LTY_COMPOSER_SONG:
    case LTY_PLAYLIST_SONG:
    case LTY_CURRENT_SELECTION:
    case LTY_FILELIST:
    case LTY_FILELIST_UNSORTED:
    case LTY_FILELIST_PLAYLIST:
    case LTY_FILELIST_MEDIAOBJECTS:
    case LTY_FILELIST_MEDIAOBJECTS_WITH_SUBFOLDERS:
    case LTY_BROWSELIST:
    case LTY_BROWSELIST_MEDIAOBJECTS:
    case LTY_BROWSELIST_MEDIAOBJECTS_WITH_SUBFOLDERS:
    case LTY_BROWSELIST_MEDIAOBJECTS_ALL:
    case LTY_MTP_FILELIST:
    case LTY_BLUETOOTH_FILELIST:
    case LTY_CD:
    case LTY_COMPILATION_SONG:
    case LTY_VIDEO_EPISODE:
    case LTY_EPISODE_OF_VIDEO:
    case LTY_IMAGE:
    case LTY_IMAGE_FOLDER_ITEM:
    case LTY_USER_FAVORITES_SONG:
        answer = true;
        break;
    default:
        break;
    }

    return answer;
}

tBoolean IsUserFavoriteList(const tListType listType)
{
    tBoolean answer = false;

    switch(listType) {
    case LTY_USER_FAVORITES_SONG:
    case LTY_USER_FAVORITES_SONG_SEARCH:
        answer = true;
        break;
    default:
        break;
    }
    return answer;
}

#endif // _TYPE_DEFINITIONS_CPP_

const char *errorText[MP_LAST_ERROR_CODE] = {0};

const char *errorString(int res)
{
    const char *unknown = "Unknown Error Number";

    if (res < 0) return unknown;
    if (res >= (int)(sizeof(errorText) / sizeof(char *))) return unknown;

    const char *strError = errorText[res];

    if (strError == NULL) return unknown;
    else return strError;
}

void InitErrorStrings(void)
{
    memset(errorText, 0, sizeof(errorText));
    errorText[MP_NO_ERROR] = "MP_NO_ERROR";
    errorText[MP_ERR_LC_UNDEFINED_LIST_ID] = "MP_ERR_LC_UNDEFINED_LIST_ID";
    errorText[MP_ERR_LC_NO_CTY_MATCH_TO_LTY] = "MP_ERR_LC_NO_CTY_MATCH_TO_LTY";
    errorText[MP_ERR_LC_NO_CTY_IMPLEMENTATION] = "MP_ERR_LC_NO_CTY_IMPLEMENTATION";
    errorText[MP_ERR_LC_NOT_IMPLEMENTED_LIST_TYPE] = "MP_ERR_LC_NOT_IMPLEMENTED_LIST_TYPE";
    errorText[MP_ERR_LC_NO_FURTHER_PARENT] = "MP_ERR_LC_NO_FURTHER_PARENT";
    errorText[MP_ERR_LC_GENERAL_ERROR] = "MP_ERR_LC_GENERAL_ERROR";
    errorText[MP_ERR_LC_UNDEFINED_INDEX] = "MP_ERR_LC_UNDEFINED_INDEX";
    errorText[MP_ERR_LC_PLAYLIST_NOT_FOUND] = "MP_ERR_LC_PLAYLIST_NOT_FOUND";
    errorText[MP_ERR_LC_PLAYLIST_FILE_CREATE] = "MP_ERR_LC_PLAYLIST_FILE_CREATE";
    errorText[MP_ERR_LC_INVALID_POSITION] = "MP_ERR_LC_INVALID_POSITION";
    errorText[MP_ERR_LC_UNDEFINED_OBJECTID] = "MP_ERR_LC_UNDEFINED_OBJECTID";
    errorText[MP_ERR_LC_LIST_IS_NOT_PLAYABLE] = "MP_ERR_LC_LIST_IS_NOT_PLAYABLE";
    errorText[MP_ERR_LC_NEXT_AT_END_OF_LIST] = "MP_ERR_LC_NEXT_AT_END_OF_LIST";
    errorText[MP_ERR_LC_PREV_AT_START_OF_LIST]= "MP_ERR_LC_PREV_AT_START_OF_LIST";
    errorText[MP_ERR_CC_UNABLE_TO_CREATE_LIST] = "MP_ERR_CC_UNABLE_TO_CREATE_LIST";
    errorText[MP_ERR_CC_DEVICE_RECOGNITION_TIMEOUT] = "MP_ERR_CC_DEVICE_RECOGNITION_TIMEOUT";
    errorText[MP_ERR_CC_DEVICE_NOT_CONNECTED] = "MP_ERR_CC_DEVICE_NOT_CONNECTED";
    errorText[MP_ERR_CC_INVALID_PARAM] = "MP_ERR_CC_INVALID_PARAM";
    errorText[MP_ERR_CC_UNSUPPORTED_DEVICE_TYPE] = "MP_ERR_CC_UNSUPPORTED_DEVICE_TYPE";
    errorText[SMF_ERR_UNKNOWN_EVENT] = "SMF_ERR_UNKNOWN_EVENT";
    errorText[MP_ERR_PM_INVALID_PARAM] = "MP_ERR_PM_INVALID_PARAM";
    errorText[MP_ERR_PM_NO_LIST_ID] = "MP_ERR_PM_NO_LIST_ID";
    errorText[MP_ERR_PM_NO_MEDIA_OBJECT] = "MP_ERR_PM_NO_MEDIA_OBJECT";
    errorText[MP_ERR_PM_NO_TOTAL_PLAYTIME] = "MP_ERR_PM_NO_TOTAL_PLAYTIME";
    errorText[MP_ERR_DISP_GEN_ERROR] = "MP_ERR_DISP_GEN_ERROR";
    errorText[MP_ERR_DISP_NO_MEM] = "MP_ERR_DISP_NO_MEM";
    errorText[MP_ERR_DISP_SM_NOT_REGISTERED] = "MP_ERR_DISP_SM_NOT_REGISTERED";
    errorText[MP_ERR_DISP_WRONG_ADRESS_FORMAT] = "MP_ERR_DISP_WRONG_ADRESS_FORMAT";
    errorText[MP_ERR_DISP_DBUS_NO_MEM] = "MP_ERR_DISP_DBUS_NO_MEM";
    errorText[MP_ERR_DISP_DBUS_NO_MEM_FOR_ARG] = "MP_ERR_DISP_DBUS_NO_MEM_FOR_ARG";
    errorText[MP_ERR_DISP_DBUS_SEND] = "MP_ERR_DISP_DBUS_SEND";
    errorText[MP_ERR_DISP_SPAWN_RECV_THREAD] = "MP_ERR_DISP_SPAWN_RECV_THREAD";
    errorText[MP_ERR_DISP_OPEN_DBUS] = "MP_ERR_DISP_WRONG_ADRESS_FORMAT";
    errorText[MP_ERR_IPOD_INVALID_PARAM] = "MP_ERR_IPOD_INVALID_PARAM";
    errorText[MP_ERR_IPOD_NO_DEVICE] = "MP_ERR_IPOD_NO_DEVICE";
    errorText[MP_ERR_IPOD_NO_ACCESS] = "MP_ERR_IPOD_NO_ACCESS";
    errorText[MP_ERR_IPOD_INIT] = "MP_ERR_IPOD_INIT";
    errorText[MP_ERR_IPOD_AUTHENTICATION] = "MP_ERR_IPOD_AUTHENTICATION";
    errorText[MP_ERR_IPOD_PLAY] = "MP_ERR_IPOD_PLAY";
    errorText[MP_ERR_IPOD_SELECT] = "MP_ERR_IPOD_SELECT";
    errorText[MP_ERR_IPOD_SEEK] = "MP_ERR_IPOD_SEEK";
    errorText[MP_ERR_IPOD_METADATA] = "MP_ERR_IPOD_METADATA";
    errorText[MP_ERR_IPOD_TIMER] = "MP_ERR_IPOD_TIMER";
    errorText[MP_ERR_IPOD_NO_ALBUMART] = "MP_ERR_IPOD_NO_ALBUMART";
    errorText[MP_ERR_IPOD_TIMEOUT] = "MP_ERR_IPOD_TIMEOUT";
    errorText[MP_ERR_IPOD_FILE_ACCESS] = "MP_ERR_IPOD_FILE_ACCESS";
    errorText[MP_ERR_IPOD_NO_MEM] = "MP_ERR_IPOD_NO_MEM";
    errorText[MP_ERR_IPOD_NO_FREE_SPACE] = "MP_ERR_IPOD_NO_FREE_SPACE";
    errorText[MP_ERR_IPOD_COMMAND] = "MP_ERR_IPOD_COMMAND";
    errorText[MP_ERR_DB_UNEXPECTED] = "MP_ERR_DB_UNEXPECTED";
    errorText[MP_ERR_DB_ALREADY_INITIALIZED] = "MP_ERR_DB_ALREADY_INITIALIZED";
    errorText[MP_ERR_DB_INITIALIZATION_FAILURE] = "MP_ERR_DB_INITIALIZATION_FAILURE";
    errorText[MP_ERR_DB_DATABASE_RECREATION_FAILURE] = "MP_ERR_DB_DATABASE_RECREATION_FAILURE";
    errorText[MP_ERR_DB_ALREADY_CONNECTED] = "MP_ERR_DB_ALREADY_CONNECTED";
    errorText[MP_ERR_DB_DATABASE_FILE_FAILURE] = "MP_ERR_DB_DATABASE_FILE_FAILURE";
    errorText[MP_ERR_DB_DATABASE_CONNECTION_FAILURE] = "MP_ERR_DB_DATABASE_CONNECTION_FAILURE";
    errorText[MP_ERR_DB_DATABASE_SCHEMA_FAILURE] = "MP_ERR_DB_DATABASE_SCHEMA_FAILURE";
    errorText[MP_ERR_DB_NOT_CONNECTED] = "MP_ERR_DB_NOT_CONNECTED";
    errorText[MP_ERR_DB_UNFINALIZED_STATEMENTS] = "MP_ERR_DB_UNFINALIZED_STATEMENTS";
    errorText[MP_ERR_DB_DATABASE_CLOSE_FAILURE] = "MP_ERR_DB_DATABASE_CLOSE_FAILURE";
    errorText[MP_ERR_DB_PREPARE_FAILURE] = "MP_ERR_DB_PREPARE_FAILURE";
    errorText[MP_ERR_DB_STEP_FAILURE] = "MP_ERR_DB_STEP_FAILURE";
    errorText[MP_ERR_DB_INTEGRITY_FAILURE] = "MP_ERR_DB_INTEGRITY_FAILURE";
    errorText[MP_ERR_DB_INVALID_SCHEMA_VERSION] = "MP_ERR_DB_INVALID_SCHEMA_VERSION";
    errorText[MP_ERR_DB_FINALIZE_FAILURE] = "MP_ERR_DB_FINALIZE_FAILURE";
    errorText[MP_ERR_DB_LIST_NOT_FOUND] = "MP_ERR_DB_LIST_NOT_FOUND";
    errorText[MP_ERR_DB_CREATE_LIST_CONTEXT] = "MP_ERR_DB_CREATE_LIST_CONTEXT";
    errorText[MP_ERR_DB_QUERY_FAILED] = "MP_ERR_DB_QUERY_FAILED";
    errorText[MP_ERR_DB_UNSUPPORTED_LIST_TYPE] = "MP_ERR_DB_UNSUPPORTED_LIST_TYPE";
    errorText[MP_ERR_DB_UNSUPPORTED_CAT_TYPE] = "MP_ERR_DB_UNSUPPORTED_CAT_TYPE";
    errorText[MP_ERR_DB_SELECT_FAILED] = "MP_ERR_DB_SELECT_FAILED";
    errorText[MP_ERR_DB_END_OF_LIST] = "MP_ERR_DB_END_OF_LIST";
    errorText[MP_ERR_DB_INSERT_FAILED] = "MP_ERR_DB_INSERT_FAILED";
    errorText[MP_ERR_DB_DELETE_FAILED] = "MP_ERR_DB_DELETE_FAILED";
    errorText[MP_ERR_DB_UPDATE_FAILED] = "MP_ERR_DB_UPDATE_FAILED";
    errorText[MP_ERR_DB_EXECUTE_FAILED] = "MP_ERR_DB_EXECUTE_FAILED";
    errorText[MP_ERR_DB_OPEN_FAILED] = "MP_ERR_DB_OPEN_FAILED";
    errorText[MP_ERR_DB_NOT_OPEN] = "MP_ERR_DB_NOT_OPEN";
    errorText[MP_ERR_DB_INVALID_HANDLE] = "MP_ERR_DB_INVALID_HANDLE";
    errorText[MP_ERR_DB_LIST_IS_NO_PLAYLIST] = "MP_ERR_DB_LIST_IS_NO_PLAYLIST";
    errorText[MP_ERR_DB_RESET_IN_SUPSEND] = "MP_ERR_DB_RESET_IN_SUPSEND";
    errorText[MP_ERR_DB_BEGIN_TRANSACTION_FAILED] = "MP_ERR_DB_BEGIN_TRANSACTION_FAILED";
    errorText[MP_ERR_DB_END_TRANSACTION_FAILED] = "MP_ERR_DB_END_TRANSACTION_FAILED";
    errorText[MP_ERR_DB_REGISTER_FAILED] = "MP_ERR_DB_REGISTER_FAILED";
    errorText[MP_ERR_DB_UNREGISTER_FAILED] = "MP_ERR_DB_UNREGISTER_FAILED";
    errorText[MP_ERR_DB_SEARCHKEYS_NOT_SUPPORTED] = "MP_ERR_DB_SEARCHKEYS_NOT_SUPPORTED";
    errorText[MP_ERR_DB_FILE_TYPE_NOT_FOUND] = "MP_ERR_DB_FILE_TYPE_NOT_FOUND";
    errorText[MP_ERR_TF_NOT_INIT] = "MP_ERR_TF_NOT_INIT";
    errorText[MP_ERR_SM_GENERAL_ERROR] = "MP_ERR_SM_GENERAL_ERROR";
    errorText[MP_ERR_SM_RESET_FAILED] = "MP_ERR_SM_RESET_FAILED";
    errorText[MP_ERR_SM_NO_INIT_TRANSITION_IN_STATEMACHINE_DEFINITION] = "MP_ERR_SM_NO_INIT_TRANSITION_IN_STATEMACHINE_DEFINITION";
    errorText[MP_ERR_SM_NO_CURRENT_STATE] = "MP_ERR_SM_NO_CURRENT_STATE";
    errorText[MP_ERR_SM_NO_EXTERNAL_QUEUE] = "MP_ERR_SM_NO_EXTERNAL_QUEUE";
    errorText[MP_ERR_SM_NO_INTERNAL_QUEUE] = "MP_ERR_SM_NO_INTERNAL_QUEUE";
    errorText[MP_ERR_SM_NO_DELAY_QUEUE] = "MP_ERR_SM_NO_DELAY_QUEUE";
    errorText[MP_ERR_SM_NO_MEM_FOR_QUEUE_MESSAGE] = "MP_ERR_SM_NO_MEM_FOR_QUEUE_MESSAGE";
    errorText[MP_ERR_SM_FOUND_NO_ANSWER_MESSAGE_TO_SEND] = "MP_ERR_SM_FOUND_NO_ANSWER_MESSAGE_TO_SEND";
    errorText[MP_ERR_SM_NO_MEM_FOR_DELAY_QUEUE_MESSAGE] = "MP_ERR_SM_NO_MEM_FOR_DELAY_QUEUE_MESSAGE";
    errorText[MP_ERR_SM_NO_DELAY_QUEUE_CREATED] = "MP_ERR_SM_NO_DELAY_QUEUE_CREATED";
    errorText[MP_ERR_SM_NO_MEM] = "MP_ERR_SM_NO_MEM";
    errorText[MP_ERR_SM_BLOCKED] = "MP_ERR_SM_BLOCKED";
    errorText[MP_ERR_QF_NO_FREE_QUEUE] = "MP_ERR_QF_NO_FREE_QUEUE";
    errorText[MP_ERR_QF_UNKNOWN_QUEUE] = "MP_ERR_QF_UNKNOWN_QUEUE";
    errorText[MP_ERR_UTF8_UNKNOWN_CHARACTER_FORMAT] = "MP_ERR_UTF8_UNKNOWN_CHARACTER_FORMAT";
    errorText[MP_ERR_DP_NO_ALBUM_ART_AVAIL] = "MP_ERR_DP_NO_ALBUM_ART_AVAIL";
    errorText[MP_ERR_DP_FORMAT_NOT_SUPPORTED] = "MP_ERR_DP_FORMAT_NOT_SUPPORTED";
    errorText[MP_ERR_DP_NO_DEVICE_FOUND] = "MP_ERR_DP_NO_DEVICE_FOUND";
    errorText[MP_ERR_DP_NO_ALBUM_ART_POINTER] = "MP_ERR_DP_NO_ALBUM_ART_POINTER";
    errorText[MP_ERR_DBUS] = "MP_ERR_DBUS";
    errorText[MP_ERR_UMOUNT_BUSY] = "MP_ERR_UMOUNT_BUSY";
    errorText[MP_ERR_UMOUNT_NOT_SUPPORTED] = "MP_ERR_UMOUNT_NOT_SUPPORTED";
    errorText[MP_ERR_UMOUNT_ERROR] = "MP_ERR_UMOUNT_ERROR";
    errorText[MP_ERR_ACTION_ERROR] = "MP_ERR_ACTION_ERROR";
    errorText[MP_ERR_MEDIA_ENGINE_GENERAL_ERROR] = "MP_ERR_MEDIA_ENGINE_GENERAL_ERROR";
    errorText[MP_ERR_MEDIA_ENGINE_STARTUP_ERROR] = "MP_ERR_MEDIA_ENGINE_STARTUP_ERROR";
    errorText[MP_ERR_DB_UPD_MYMEDIA_DB_STOPPED] = "MP_ERR_DB_UPD_MYMEDIA_DB_STOPPED";
    errorText[MP_ERR_DB_UPD_MYMEDIA_DB_SHUTDOWN] = "MP_ERR_DB_UPD_MYMEDIA_DB_SHUTDOWN";
    errorText[MP_ERR_DB_UPD_MYMEDIA_DB_RUNNING] = "MP_ERR_DB_UPD_MYMEDIA_DB_RUNNING";
    errorText[MP_ERR_DB_UPD_MYMEDIA_DB_UNKNOWN] = "MP_ERR_DB_UPD_MYMEDIA_DB_UNKNOWN";
    errorText[MP_ERR_CDDA_OPEN_SG] = "MP_ERR_CDDA_OPEN_SG";
    errorText[MP_ERR_CDDA_OPEN_SR] = "MP_ERR_CDDA_OPEN_SR";
    errorText[MP_ERR_CDDA_IOCTRL] = "MP_ERR_CDDA_IOCTRL";
    errorText[MP_ERR_CDDA_CDTEXT] = "MP_ERR_CDDA_CDTEXT";
    errorText[MP_ERR_CDDA_CD_NOT_MOUNTED] = "MP_ERR_CDDA_CD_NOT_MOUNTED";
    errorText[MP_ERR_CDDA_WRONG_URL] = "MP_ERR_CDDA_WRONG_URL";
    errorText[MP_ERR_CDDA_WRONG_TRACK_NO] = "MP_ERR_CDDA_WRONG_TRACK_NO";
    errorText[MP_ERR_BT_BROWSE_FAILED] = "MP_ERR_BT_BROWSE_FAILED";
}

int GenerateTempFileName(tFilename &tmpFile, const char * prefix, const char * path)
{
    /* create temp file */
    if (path == NULL) {
      return -1;
    }
    static int fileCounter = 0;
    static Lock lock;
    lock.lock();
    fileCounter++;
    snprintf(tmpFile, sizeof(tmpFile) - 1, "%s/%s_%06X", path, prefix, fileCounter);
    lock.unlock();
    return 0;
}

void InitBTPlayerInfo(tBTPlayerInfo &BTPlayerInfo)
{
    BTPlayerInfo.objectPath = "";
    BTPlayerInfo.isBrowsable = false;
    BTPlayerInfo.isSearchable = false;
    BTPlayerInfo.isDBAware = false;
    BTPlayerInfo.isSetBrowsedPlayerSuccess = false;
}
void InitPlayerAttributes(tPlayerAttributes &BTSupportAttributes)
{
    BTSupportAttributes.Shuffle.AttributeSupported = false;
    BTSupportAttributes.Shuffle.value = PBM_INVALID;
    BTSupportAttributes.Repeat.AttributeSupported = false;
    BTSupportAttributes.Repeat.value = RPT_INVALID;
}

//void InitVideoProperties(tMEVideoProperties &meVideoProperties)
//{
//    memset(&meVideoProperties, 0, sizeof(tMEVideoProperties));
//}

void InittWiFiAPCredentials(tWiFiAPCredentials &wifiAPCredentials)
{
    memset(&wifiAPCredentials,0,sizeof(tWiFiAPCredentials));
}

void InitDiPOPower(tDiPOPower &power)
{
    memset(&power, 0, sizeof(tDiPOPower));
    power.BatteryChargingState = tDiPOBatteryChargingState_init;
    power.AccessoryPowerMode = tDiPOAccessoryPowerMode_init;
}
tBoolean IsSRStorageDevice(const tDeviceType deviceType)
{
    tBoolean answer = false;

    if((DTY_USB == deviceType)
       ||
       (DTY_SD == deviceType))
    {
        answer = true;
    }

    return answer;
}

#ifdef IAP2_DEFAULT_ROUTEGUIDANCEDISPLAYCOMPONENT
void InitDiPORouteGuidanceUpdate(tDiPORouteGuidanceUpdate &RGUpdate)
{
    memset(&RGUpdate, 0, sizeof(tDiPORouteGuidanceUpdate));
    RGUpdate.DistanceRemainingDisplayUnits = tDiPoDistanceDisplayUnits_init;
    RGUpdate.DistanceToNextManeuverDisplayUnits = tDiPoDistanceDisplayUnits_init;
    RGUpdate.RouteGuidanceState = tDiPORouteGuidanceState_init;
    RGUpdate.ManeuverState = tDiPOManeuverState_init;
    RGUpdate.RouteGuidanceManeuverCurrentList.clear();
    //RGUpdate.RouteGuidanceManeuverCurrentList.ManeuverListSize = 0;
}
#else
void InitDiPORouteGuidanceUpdate(tDiPORouteGuidanceUpdate &RGUpdate)
{
    memset(&RGUpdate, 0, sizeof(tDiPORouteGuidanceUpdate));
    RGUpdate.RouteGuidanceDisplayComponentIDsAvailable = false;
    RGUpdate.RouteGuidanceDisplayComponentIDs.clear();
    RGUpdate.RouteGuidanceStateAvailable = false;
    RGUpdate.ManeuverStateAvailable = false;
    RGUpdate.CurrentRoadNameAvailable = false;
    strcpy(RGUpdate.CurrentRoadName, "");
    RGUpdate.DestinationNameAvailable = false;
    strcpy(RGUpdate.DestinationName, "");
    RGUpdate.EstimatedTimeOfArrivalAvailable = false;
    RGUpdate.EstimatedTimeOfArrival = 0;
    RGUpdate.TimeRemainingToDestinationAvailable = false;
    RGUpdate.TimeRemainingToDestination = 0;
    RGUpdate.DistanceRemainingAvailable = false;
    RGUpdate.DistanceRemaining = 0;
    RGUpdate.DistanceRemainingDisplayStrAvailable = false;
    strcpy(RGUpdate.DistanceRemainingDisplayStr, "");
    RGUpdate.DistanceRemainingDisplayUnitsAvailable = false;
    RGUpdate.DistanceToNextManeuverAvailable = false;
    RGUpdate.DistanceToNextManeuverDisplayStrAvailable = false;
    strcpy(RGUpdate.DistanceToNextManeuverDisplayStr, "");
    RGUpdate.DistanceToNextManeuverDisplayUnitsAvailable = false;
    RGUpdate.RouteGuidanceManeuverCurrentListAvailable = false;
    RGUpdate.RouteGuidanceManeuverCountAvailable = false;
    RGUpdate.RouteGuidanceManeuverCount = 0;
    RGUpdate.RouteGuidanceVisibleInAppAvailable = false;
    RGUpdate.SourceNameAvailable = false;
    RGUpdate.SourceSupportsRouteGuidance = false;
    RGUpdate.SourceSupportsRouteGuidanceAvailable = false;
    RGUpdate.DistanceRemainingDisplayUnits = tDiPoDistanceDisplayUnits_init;
    RGUpdate.DistanceToNextManeuverDisplayUnits = tDiPoDistanceDisplayUnits_init;
    RGUpdate.RouteGuidanceState = tDiPORouteGuidanceState_init;
    RGUpdate.ManeuverState = tDiPOManeuverState_init;
    RGUpdate.RouteGuidanceManeuverCurrentList.clear();
    //RGUpdate.RouteGuidanceManeuverCurrentList.ManeuverListSize = 0;
}
#endif

#ifdef IAP2_DEFAULT_ROUTEGUIDANCEDISPLAYCOMPONENT
void InitDiPORouteGuidanceManeuverUpdate(tDiPORouteGuidanceManeuverUpdate &RGManeuverUpdate)
{
    memset(&RGManeuverUpdate, 0, sizeof(tDiPORouteGuidanceManeuverUpdate));
    RGManeuverUpdate.DistanceBetweenManeuverDisplayUnits = tDiPoDistanceDisplayUnits_init;
    RGManeuverUpdate.ManeuverType = tDiPoManeuverType_init;
    RGManeuverUpdate.JunctionType = tDiPoJunctionType_init;
    RGManeuverUpdate.DrivingSide = tDiPODrivingSide_init;
}
#else
void InitDiPORouteGuidanceManeuverUpdate(tDiPORouteGuidanceManeuverUpdate &RGManeuverUpdate)
{
    memset(&RGManeuverUpdate, 0, sizeof(tDiPORouteGuidanceManeuverUpdate));
    RGManeuverUpdate.RouteGuidanceDisplayComponentIDsAvailable = false;
    RGManeuverUpdate.RouteGuidanceDisplayComponentIDs.clear();
    RGManeuverUpdate.IndexAvailable = false;
    RGManeuverUpdate.Index = 0;
    RGManeuverUpdate.ManeuverDescriptionAvailable = false;
    strcpy(RGManeuverUpdate.ManeuverDescription, "");
    RGManeuverUpdate.ManeuverTypeAvailable = false;
    RGManeuverUpdate.AfterManeuverRoadNameAvailable = false;
    strcpy(RGManeuverUpdate.AfterManeuverRoadName, "");
    RGManeuverUpdate.DistanceBetweenManeuverAvailable = false;
    RGManeuverUpdate.DistanceBetweenManeuver = 0;
    RGManeuverUpdate.DistanceBetweenManeuverDisplayStrAvailable = false;
    strcpy(RGManeuverUpdate.DistanceBetweenManeuverDisplayStr, "");
    RGManeuverUpdate.DistanceBetweenManeuverDisplayUnitsAvailable = false;
    RGManeuverUpdate.DrivingSideAvailable = false;
    RGManeuverUpdate.JunctionTypeAvailable = false;
    RGManeuverUpdate.JunctionElementAngleAvailable = false;
    RGManeuverUpdate.JunctionElementAngle.clear();
    RGManeuverUpdate.JunctionElementExitAngleAvailable = false;
    RGManeuverUpdate.JunctionElementExitAngle = 0;
    RGManeuverUpdate.DistanceBetweenManeuverDisplayUnits = tDiPoDistanceDisplayUnits_init;
    RGManeuverUpdate.ManeuverType = tDiPoManeuverType_init;
    RGManeuverUpdate.JunctionType = tDiPoJunctionType_init;
    RGManeuverUpdate.DrivingSide = tDiPODrivingSide_init;
}
#endif

void CodecStandardisation(tCodec &codecEnum, const tGeneralString codecName)
{

    if((strstr(codecName, "DX4")) || (strstr(codecName, "DX5")) || (strstr(codecName, "DX6")) || (strstr(codecName, "DivX"))) //DivX 4/5/6
    {
        codecEnum = CDC_DIVX;
    }
    else if(strstr(codecName, "XVID")) //XviD
    {
        codecEnum = CDC_XVID;
    }
    else if((strstr(codecName, "AVC")) || (strstr(codecName, "264"))) //H.264/AVC
    {
        codecEnum = CDC_AVC;
    }
    else if(strstr(codecName, "263")) //H.263
    {
        codecEnum = CDC_H263;
    }
    else if((0 == strncmp("MPEG-4", codecName, 6)) || (0 == strncmp("20", codecName, 2))) //MPEG-4
    {
        codecEnum = CDC_MPEG4;
    }
    else if((strstr(codecName, "MPEG2")) || (strstr(codecName, "MPEG Video"))) //MPEG-2
    {
        codecEnum = CDC_MPEG2;
    }
    else if((strstr(codecName, "VC-1")) || (0 == strncmp("Microsoft Windows Media 9", codecName, 25)) || (0 == strncmp("Windows Media Video", codecName, 19))) //WMV9/VC-1
    {
        codecEnum = CDC_WMV9;
    }
    else if(strstr(codecName, "WMV2")) //WMV8
    {
        codecEnum = CDC_WMV8;
    }
    else if(strstr(codecName, "WMV1")) //WMV7
    {
        codecEnum = CDC_WMV7;
    }
    else if(strstr(codecName, "VP8"))
    {
        codecEnum = CDC_VP8;
    }
    else if(strstr(codecName, "VP6")) //On2 VP6.2
    {
        codecEnum = CDC_VP6;
    }
    else if(strstr(codecName, "Sorenson")) //Sorenson Spark
    {
        codecEnum = CDC_SORENSON;
    }
    else if(strstr(codecName, "WMA")) //WMA
    {
        codecEnum = CDC_WMA;
    }
    else
    {
        codecEnum = CDC_OTHER;
    }

}

void InitDiPOSetRGDisplayInfo(tDiPORGDisplayComponentInfo &RGDisplayComponentInfo)
{
    RGDisplayComponentInfo.Identifier = 0;
    strcpy(RGDisplayComponentInfo.Name,"");
    RGDisplayComponentInfo.CurrentRoadNameLength = 127;
    RGDisplayComponentInfo.GuidanceManeuverCapacity = 1;
    RGDisplayComponentInfo.AfterManeuverRoadNameLength = 127;
    RGDisplayComponentInfo.DestinationNameLength = 127;
    RGDisplayComponentInfo.ManeuverDescriptionLength = 127;
}

void InitBTCoverArtInfo(tBTCoverArtInfo &BTCoverArtInfo)
{
    BTCoverArtInfo.objectID = OBJECT_ID_NONE;
    BTCoverArtInfo.coverArthandle = "";
    BTCoverArtInfo.mediaItemObjectPath = "";
}

void InitDiPODeviceTime(tDiPODeviceTime &deviceTime)
{
    deviceTime.s8DaylightSavingsOffsetMinutes = 0;
    deviceTime.u64SecondsSinceReferenceDate = 0;
    deviceTime.s16TimeZoneOffsetMinutes = 0;
}
