/*
 * SearchKeyboard.cpp
 *
 *  Created on: Feb 22, 2013
 *      Author: Dinesh
 */


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DB_MANAGER
#ifdef TARGET_BUILD
#include "trcGenProj/Header/SearchKeyboard.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_DB_MANAGER
#endif
#endif

#include "FunctionTracer.h"
#include "VarTrace.h"

#include "SearchKeyboard.h"
#include "sortlib.h"
#include <glib.h>
#include <string.h>


tBoolean SearchKeyboard::GetNonLatinCharacterSet(const tCharacter **characterSet, tUInt &size,tLanguageType language )
{
    tBoolean available = 0x01;
    switch(language)
    {
        case LNG_GREEK:
            *characterSet = greekCharacters;
            size = sizeof(greekCharacters)/sizeof(tCharacter);
            break;

        case LNG_RUSSIAN:
            *characterSet = russianCharacters;
            size = sizeof(russianCharacters)/sizeof(tCharacter);
            break;

        case LNG_ARABIC:
            *characterSet = arabicCharacters;
            size = sizeof(arabicCharacters)/sizeof(tCharacter);
            break;

        case LNG_KOREAN:
            *characterSet = koreanCharacters;
            size = sizeof(koreanCharacters)/sizeof(tCharacter);
            break;

        case LNG_JAPANESE:  /*  CMG3G-8461 Vertical Keyboard Extension*/
            *characterSet = japaneseCharacters;
            size = sizeof(japaneseCharacters)/sizeof(tCharacter);
            break;

        case LNG_THAI:  /*  CMG3G-8461 Vertical Keyboard Extension*/
            *characterSet = thaiCharacters;
            size = sizeof(thaiCharacters)/sizeof(tCharacter);
            break;

        case LNG_HEBREW:  /*  CMG3G-8461 Vertical Keyboard Extension*/
            *characterSet = hebrewCharacters;
            size = sizeof(hebrewCharacters)/sizeof(tCharacter);
            break;

        case LNG_DEVANAGARI:  /*  CMG3G-8461 Vertical Keyboard Extension*/
            *characterSet = devanagariCharacters;
            size = sizeof(devanagariCharacters)/sizeof(tCharacter);
            break;

        default:
            available = 0x00;
            size = 0x00;
            break;
    }
    return available;
}

tResult SearchKeyboard::CreateSearchKeyboard(vector<tSearchKeyboard> &searchKeyboardList,vector<tSearchKey> &searchKeys ,
                                            const tCharacter *characterSet ,tU16 noOfCharacters)
{
    ENTRY

    tSearchKeyboard skbItem;

    tU16 startIndex= 0x00; // start index of the list
    tU16 iterCharacterSet;
    tU16 iterSearchKey = 0x00;
    tU8  charSize = 0x00;

    /* reset the output vector */
    searchKeyboardList.clear();

    /*look for list entries which starts with latin character*/
    for (iterCharacterSet = 0 ; iterCharacterSet < noOfCharacters-1 ; iterCharacterSet++)
    {
        memset (&skbItem,0,sizeof (tSearchKeyboard));
        charSize = g_unichar_to_utf8(characterSet[iterCharacterSet].keyboardChar,skbItem.letter);
        skbItem.letter[charSize] = '\0';
#if 0
        ETG_TRACE_USR3(("characterSet[iterCharacterSet].keyboardChar=%c/%d, skbItem.letter=%4s, charSize=%d",
                (char)characterSet[iterCharacterSet].keyboardChar, characterSet[iterCharacterSet].keyboardChar,
                skbItem.letter, charSize));
#endif
        while(iterSearchKey < searchKeys.size())
        {
            tU32 unicodePoint = g_utf8_get_char_validated(searchKeys[iterSearchKey].letter,-1);

            // the previous call returned that the letter was NO UTF-8 character.
            // It could be an unicode character which has the upper bit set.
            // convert it to utf-8 and retry getting the unicode point
            if (unicodePoint == (gunichar)-1) {
                char utf8Letter[20];
                //int charSizeUtf8 = g_unichar_to_utf8((int)searchKeys[iterSearchKey].letter[0], utf8Letter);
                g_unichar_to_utf8((int)searchKeys[iterSearchKey].letter[0], utf8Letter);
                unicodePoint = g_utf8_get_char_validated(utf8Letter, -1);
            }
#if 0
            ETG_TRACE_USR3(("searchKeys[iterSearchKey=%d].letter=%4s(%02x,%02x), unicodePoint=%d",
                    iterSearchKey,
                    searchKeys[iterSearchKey].letter,
                    searchKeys[iterSearchKey].letter[0],
                    searchKeys[iterSearchKey].letter[1],
                    unicodePoint));
#endif
            unsigned int charPrio = sortlib_get_char_sort_prio(unicodePoint);
#if 0
            ETG_TRACE_USR3(("charPrio=%d", charPrio));
#endif
            if((charPrio == SORTLIB_DEFAULT_TABLE_VALUE) //consume character which don't have a prio assigned from sortlib table
               ||
               (charPrio < sortlib_get_char_sort_prio(characterSet[iterCharacterSet + 1].searchChar)))
            {
                if(!skbItem.available)
                {
                    skbItem.available = 0x01;
                    skbItem.startIndex = startIndex;
                    skbItem.endIndex = startIndex + searchKeys[iterSearchKey].count - 1;
                }
                else
                {
                    //extend the endindex foe the same item which is already added
                    skbItem.endIndex = skbItem.endIndex + searchKeys[iterSearchKey].count;
                }

                startIndex = skbItem.endIndex + 1;
                iterSearchKey++;
            } else {
#if 0
                ETG_TRACE_USR3(("while-loop-break at iterSearchKey=%d", iterSearchKey));
#endif
                break;
            }
        }
        searchKeyboardList.push_back(skbItem);
    }
    return MP_NO_ERROR;
}

/*
 * check if '#' has any entries which represents all characters above the first letter of the specific language
 * characters set
 * */
tBoolean IsHashCharValid(vector<tSearchKeyboard> &searchKeyboardList)
{
    if(searchKeyboardList.size())
        return searchKeyboardList[0].available;

    return 0x00;
}

/*
 * check if any one character in the keyboard has some list entries
 *
 * */
tBoolean IsCharactersAvailable(vector<tSearchKeyboard> &searchKeyboardList)
{
    if(searchKeyboardList.size() > 1)
    {
        for(unsigned int iter = 0x01 ; iter < searchKeyboardList.size()-1 ; iter++)
            if(searchKeyboardList[iter].available)
                return 0x01;
    }
    return 0x00;
}


/*1.if there are no non-latin character set available , just create return the latin character keyboard*/
/*2.if ther are only non-latin characters in Keyboard , then return KBD with only those character*/
/*3.there are both latin and non-latin kbd*/
tResult SearchKeyboard::GetSearchKeyboard(vector<tSearchKeyboard> &searchKeyboardList,vector<tSearchKey> &searchKeys ,tLanguageType language )
{
    ENTRY

    const tCharacter* nonLatinCharSet = NULL;
    vector<tSearchKeyboard> nonLatinSearchKBD;
    tUInt noOfCharacters;

    /*Get non latin character set */
    tBoolean nonLatinCharSetAvail = GetNonLatinCharacterSet(OUT &nonLatinCharSet, OUT noOfCharacters, IN language);
    VARTRACE(nonLatinCharSetAvail);

    /*** 1.if there are no non-latin character set available , just create return the latin character keyboard***/
    if(!nonLatinCharSetAvail)
	{
        if (LocalSPM::GetDataProvider().KeyboardWithHashAtEnd())
		{
			return CreateSearchKeyboard(OUT searchKeyboardList, IN searchKeys, LatinCharactersWithHashAtEnd,sizeof(LatinCharactersWithHashAtEnd)/sizeof(tCharacter) );
		}
		else
		{
			return CreateSearchKeyboard(OUT searchKeyboardList, IN searchKeys, latinCharacters,sizeof(latinCharacters)/sizeof(tCharacter) );
		}
    }

    /*we have non-latin character set , so create a search keyboard for non-latin characters*/
    CreateSearchKeyboard(OUT nonLatinSearchKBD, IN searchKeys, nonLatinCharSet,noOfCharacters);
    tBoolean nonLatinCharAvail = IsCharactersAvailable(nonLatinSearchKBD);
    tBoolean hashCharValid = IsHashCharValid(nonLatinSearchKBD);
    VARTRACE(nonLatinCharAvail);
    VARTRACE(hashCharValid);

    /*** 1.a we have latin character entries in the list when the non-latin language is set*/
    if(hashCharValid)
    {
        /*create and keep latin character key board in the beginning*/
        CreateSearchKeyboard(OUT searchKeyboardList, IN searchKeys, latinCharacters,sizeof(latinCharacters)/sizeof(tCharacter));
    }

    /*** 2.we have both latin and non-latin characters available  in the keyboard*/
    if(hashCharValid && nonLatinCharAvail)
    {
        /* append world icon : which will be in the middle of latin and non-latin kbd*/
        tSearchKeyboard skbItem;
        memset (&skbItem,0,sizeof (tSearchKeyboard));
        int charSize = g_unichar_to_utf8(0x2641,skbItem.letter);
        skbItem.letter[charSize] = '\0';
        searchKeyboardList.push_back(skbItem);

        /* start appending non-latin keyboard in the end*/
        searchKeyboardList.push_back(nonLatinSearchKBD.at(0));
    }

    /*** 3. append the non-latin character pairs to final KBD*/
    if(nonLatinCharAvail)
    {
        for (unsigned iter = 1 ; iter < nonLatinSearchKBD.size() ; iter++)
        {
            searchKeyboardList.push_back(nonLatinSearchKBD.at(iter));
        }
    }

    if(!searchKeyboardList.size())
    {
        ETG_TRACE_ERR(("Search Keyboard creation failed as there none of the list entry starts with valid known characters"));
        return -1;
    }

    return MP_NO_ERROR;
}
