/**
 * @addtogroup Common
 * @author Dinesh
 *
 * Holds complete letters represented via its unicode point 
 * @{
 */

#ifndef SEARCHKEYBOARDDATA_H_
#define SEARCHKEYBOARDDATA_H_

#include "BaseTypes.h"

typedef struct
{
    tU32 keyboardChar;
    tU32 searchChar;
}tCharacter;

const tCharacter latinCharacters[] =
{
    {'#',' '},
    {'A','a'},{'B','b'},{'C','c'},{'D','d'},{'E','e'},{'F','f'},{'G','g'},{'H','h'},{'I','i'},{'J','j'},{'K','k'},{'L','l'},{'M','m'},
    {'N','n'},{'O','o'},{'P','p'},{'Q','q'},{'R','r'},{'S','s'},{'T','t'},{'U','u'},{'V','v'},{'W','w'},{'X','x'},{'Y','y'},{'Z','z'},
    {0,0},
};

const tCharacter LatinCharactersWithHashAtEnd[] =
{
    {'A','a'},{'B','b'},{'C','c'},{'D','d'},{'E','e'},{'F','f'},{'G','g'},{'H','h'},{'I','i'},{'J','j'},{'K','k'},{'L','l'},{'M','m'},
    {'N','n'},{'O','o'},{'P','p'},{'Q','q'},{'R','r'},{'S','s'},{'T','t'},{'U','u'},{'V','v'},{'W','w'},{'X','x'},{'Y','y'},{'Z','z'},
    {'#','0'},{0,0},
};

const tCharacter greekCharacters[] = 
{
    {'#',' '},
    {913,945}, /* GREEK LETTER ALPHA*/		{914,946},	/* GREEK LETTER BETA*/
    {915,947}, /* GREEK LETTER GAMMA*/		{916,948},  /* GREEK LETTER DELTA*/
    {917,949}, /* GREEK LETTER EPSILON*/	{918,950},  /* GREEK LETTER ZETA*/
    {919,951}, /* GREEK LETTER ETA*/		{920,952},  /* GREEK LETTER THETA*/
    {921,953}, /* GREEK LETTER IOTA*/		{922,954},  /* GREEK LETTER KAPPA*/
    {923,955}, /* GREEK LETTER LAMDA*/		{924,956},  /* GREEK LETTER MU*/
    {925,957}, /* GREEK LETTER NU*/			{926,958},  /* GREEK LETTER XI*/
    {927,959}, /* GREEK LETTER OMICRON*/	{928,960},  /* GREEK LETTER PI*/
    {929,961}, /* GREEK LETTER RHO*/		{931,963},  /* GREEK LETTER SIGMA*/
    {932,964}, /* GREEK LETTER TAU*/		{933,965},  /* GREEK LETTER UPSILON*/
    {934,966}, /* GREEK LETTER PHI*/   		{935,967},  /* GREEK LETTER CHI*/
    {936,968}, /* GREEK LETTER PSI*/  		{937,969},  /* GREEK LETTER OMEGA*/
    {0,0}
};

// (Cyrillic)
const tCharacter russianCharacters[] = 	
{
    {'#',' '},
    {0x0410, 0x0430}, /*CYRILLIC LETTER A */	{0x0411, 0x0431}, /*CYRILLIC LETTER BE */
    {0x0412, 0x0432}, /*CYRILLIC LETTER VE */	{0x0413, 0x0433},  /*CYRILLIC LETTER GHE */
    {0x0414, 0x0434}, /*CYRILLIC LETTER DE */	{0x0415, 0x0435}, /*CYRILLIC LETTER IE */
    {0x0416, 0x0436}, /*CYRILLIC LETTER ZHE */	{0x0417, 0x0437}, /*CYRILLIC LETTER ZE */
    {0x0418, 0x0438}, /*CYRILLIC LETTER I */	{0x041A, 0x043A}, /*CYRILLIC LETTER KA */
    {0x041B, 0x043B}, /*CYRILLIC LETTER EL */	{0x041C, 0x043C}, /*CYRILLIC LETTER EM */
    {0x041D, 0x043D}, /*CYRILLIC LETTER EN */	{0x041E, 0x043E}, /*CYRILLIC LETTER 0 */
    {0x041F, 0x043F}, /*CYRILLIC LETTER PE */	{0x0420, 0x0440}, /*CYRILLIC LETTER ER */
    {0x0421, 0x0441}, /*CYRILLIC LETTER ES */	{0x0422, 0x0442}, /*CYRILLIC LETTER TE */
    {0x0423, 0x0443}, /*CYRILLIC LETTER U */	{0x0424, 0x0444}, /*CYRILLIC LETTER EF */
    {0x0425, 0x0445}, /*CYRILLIC LETTER HA */	{0x0426, 0x0446}, /*CYRILLIC LETTER TSE */
    {0x0427, 0x0447}, /*CYRILLIC LETTER CHE */	{0x0428, 0x0448}, /*CYRILLIC LETTER SHA */
    {0x0429, 0x0449}, /*CYRILLIC LETTER SHCHA */{0x042D, 0x044D}, /*CYRILLIC LETTER E */
    {0x042E, 0x044E}, /*CYRILLIC LETTER YU */	{0x042F, 0x044F}, /*CYRILLIC LETTER YA */
    {0,0}
};

const tCharacter arabicCharacters[] = 	
{      
    {'#',' '},
    {0x0627, 0x0623}, /*ARABIC LETTER ALEF WITH HAMZA */	{0x0628, 0x0628}, /*ARABIC LETTER BEH */
    {0x062A, 0x062A}, /*ARABIC LETTER TEH */	{0x062B, 0x062B},  /*ARABIC LETTER THEH */
    {0x062C, 0x062C}, /*ARABIC LETTER JEEM */	{0x062D, 0x062D}, /*ARABIC LETTER HAH */
    {0x062E, 0x062E}, /*ARABIC LETTER KHAH */	{0x062F, 0x062F}, /*ARABIC LETTER DAL */
    {0x0630, 0x0630}, /*ARABIC LETTER THAL */	{0x0631, 0x0631}, /*ARABIC LETTER REH */
    {0x0632, 0x0632}, /*ARABIC LETTER ZAIN */	{0x0633, 0x0633}, /*ARABIC LETTER SEEN */
    {0x0634, 0x0634}, /*ARABIC LETTER SHEEN */	{0x0635, 0x0635}, /*ARABIC LETTER SAD */
    {0x0636, 0x0636}, /*ARABIC LETTER DAD */	{0x0637, 0x0637}, /*ARABIC LETTER TAH */
    {0x0638, 0x0638}, /*ARABIC LETTER ZAH */	{0x0639, 0x0639}, /*ARABIC LETTER AIN */
    {0x063A, 0x063A}, /*ARABIC LETTER GHAIN */	{0x0641, 0x0641}, /*ARABIC LETTER FEH */
    {0x0642, 0x0642}, /*ARABIC LETTER QAF */	{0x0643, 0x0643}, /*ARABIC LETTER KAF */
    {0x0644, 0x0644}, /*ARABIC LETTER LAM */	{0x0645, 0x0645}, /*ARABIC LETTER MEEM */
    {0x0646, 0x0646}, /*ARABIC LETTER NOON */	{0x0647, 0x0647}, /*ARABIC LETTER HEH */
    {0x0648, 0x0648}, /*ARABIC LETTER WAW */	{0x064A, 0x064A}, /*ARABIC LETTER YEH */
    {0,0},
};

const tCharacter koreanCharacters[] =
{
    {'#',' '},
    {0x3131, 0xAC00}, /*HANGUL KIYEOK*/	{0x3134, 0xB098}, /* HANGUL NIEUN */
    {0x3137, 0xB2E4}, /*HANGUL TIKEUT*/	{0x3139, 0xB77C}, /* HANGUL RIEUL */
    {0x3141, 0xB9C8}, /*HANGUL MIEUM*/	{0x3142, 0xBC14}, /* HANGUL PIEUP */
    {0x3145, 0xC0AC}, /*HANGUL SIOS*/	{0x3147, 0xC544}, /* HANGUL IEUNG */
    {0x3148, 0xC790}, /*HANGUL CIEUC*/	{0x314A, 0xCC28}, /* HANGUL CHIEUCH */
    {0x314B, 0xCE74}, /*HANGUL KHIEUKH*/{0x314C, 0xD0C0}, /* HANGUL THIEUTH */
    {0x314D, 0xD30C}, /*HANGUL PHIEUPH*/{0x314E, 0xD558}, /* HANGUL HIEUH */
    {0,0},
};

const tCharacter japaneseCharacters[] =    /*43 Characters// // //  CMG3G-8461 Vertical Keyboard Extension*/
{
    {'#',' '},
    {0x3042, 0x3042}, /*HIRAGANA LETTER A*/      {0x3044, 0x3044}, /*HIRAGANA LETTER I*/
    {0x3046, 0x3046}, /*HIRAGANA LETTER U*/      {0x3048, 0x3048}, /*HIRAGANA LETTER E*/
    {0x304A, 0x304A}, /*HIRAGANA LETTER O*/      {0x304B, 0x304B}, /*HIRAGANA LETTER KA*/
    {0x304D, 0x304D}, /*HIRAGANA LETTER KI*/     {0x304F, 0x304F}, /*HIRAGANA LETTER KU*/
    {0x3051, 0x3051}, /*HIRAGANA LETTER KE*/     {0x3053, 0x3053}, /*HIRAGANA LETTER KO*/
    {0x3055, 0x3055}, /*HIRAGANA LETTER SA*/     {0x3057, 0x3057}, /*HIRAGANA LETTER SI*/
    {0x3059, 0x3059}, /*HIRAGANA LETTER SU*/     {0x305B, 0x305B}, /*HIRAGANA LETTER SE*/
    {0x305D, 0x305D}, /*HIRAGANA LETTER SO*/     {0x305F, 0x305F}, /*HIRAGANA LETTER TA*/
    {0x3061, 0x3061}, /*HIRAGANA LETTER TI*/     {0x3064, 0x3064}, /*HIRAGANA LETTER TU*/
    {0x3066, 0x3066}, /*HIRAGANA LETTER TE*/     {0x3068, 0x3068}, /*HIRAGANA LETTER TO*/
    {0x306A, 0x306A}, /*HIRAGANA LETTER NA*/     {0x306B, 0x306B}, /*HIRAGANA LETTER NI*/
    {0x306C, 0x306C}, /*HIRAGANA LETTER NU*/     {0x306D, 0x306D}, /*HIRAGANA LETTER NE*/
    {0x306E, 0x306E}, /*HIRAGANA LETTER NO*/     {0x306F, 0x306F}, /*HIRAGANA LETTER HA*/
    {0x3072, 0x3072}, /*HIRAGANA LETTER HI*/     {0x3075, 0x3075}, /*HIRAGANA LETTER HU*/
    {0x3078, 0x3078}, /*HIRAGANA LETTER HE*/     {0x307B, 0x307B}, /*HIRAGANA LETTER HO*/
    {0x307E, 0x307E}, /*HIRAGANA LETTER MA*/     {0x307F, 0x307F}, /*HIRAGANA LETTER MI*/
    {0x3080, 0x3080}, /*HIRAGANA LETTER MU*/     {0x3081, 0x3081}, /*HIRAGANA LETTER ME*/
    {0x3082, 0x3082}, /*HIRAGANA LETTER MO*/     {0x3089, 0x3089}, /*HIRAGANA LETTER RA*/
    {0x308A, 0x308A}, /*HIRAGANA LETTER RI*/     {0x308B, 0x308B}, /*HIRAGANA LETTER RU*/
    {0x308C, 0x308C}, /*HIRAGANA LETTER RE*/     {0x308D, 0x308D}, /*HIRAGANA LETTER RO*/
    {0x308F, 0x308F}, /*HIRAGANA LETTER WA*/     {0x3092, 0x3092}, /*HIRAGANA LETTER WO*/
    {0x3093, 0x3093}, /*HIRAGANA LETTER N*/
    {0,0},
};

const tCharacter thaiCharacters[] =    /*44 Characters// // //  CMG3G-8461 Vertical Keyboard Extension*/
{
    {'#',' '},
    {0x0E01, 0x0E01}, /*THAI CHARACTER KO KAI*/         {0x0E02, 0x0E02}, /*THAI CHARACTER KHO KHAI*/
    {0x0E04, 0x0E04}, /*THAI CHARACTER KHO KHWAI*/      {0x0E03, 0x0E03}, /*THAI CHARACTER KHO KHUAT*/
    {0x0E07, 0x0E07}, /*THAI CHARACTER NGO NGU*/        {0x0E08, 0x0E08}, /*THAI CHARACTER CHO CHlAN*/
    {0x0E09, 0x0E09}, /*THAI CHARACTER CHO CHING*/      {0x0E0A, 0x0E0A}, /*THAI CHARACTER CHO CHANG*/
    {0x0E0B, 0x0E0B}, /*THAI CHARACTER SO SO*/          {0x0E0C, 0x0E0C}, /*THAI CHARACTER CHO CHOE*/
    {0x0E0D, 0x0E0D}, /*THAI CHARACTER YO YING*/        {0x0E0E, 0x0E0E}, /*THAI CHARACTER DO CHADA*/
    {0x0E0F, 0x0E0F}, /*THAI CHARACTER TO PATAK*/       {0x0E10, 0x0E10}, /*THAI CHARACTER THO THAN*/
    {0x0E11, 0x0E11}, /*THAI CHARACTER THO NANGMONTHO*/ {0x0E12, 0x0E12}, /*THAI CHARACTER THO PHUTHAO*/
    {0x0E13, 0x0E13}, /*THAI CHARACTER NO NEN*/         {0x0E14, 0x0E14}, /*THAI CHARACTER DO DEK*/
    {0x0E15, 0x0E15}, /*THAI CHARACTER TO TAO*/         {0x0E16, 0x0E16}, /*THAI CHARACTER THO THUNG*/
    {0x0E17, 0x0E17}, /*THAI CHARACTER THO THAHAN*/     {0x0E18, 0x0E18}, /*THAI CHARACTER THO THONG*/
    {0x0E19, 0x0E19}, /*THAI CHARACTER NO NU*/          {0x0E1A, 0x0E1A}, /*THAI CHARACTER BO BAIMAI*/
    {0x0E1B, 0x0E1B}, /*THAI CHARACTER PO PLA*/         {0x0E1C, 0x0E1C}, /*THAI CHARACTER PHO PHUNG*/
    {0x0E1D, 0x0E1D}, /*THAI CHARACTER FO FA*/          {0x0E1E, 0x0E1E}, /*THAI CHARACTER PHO PHAN*/
    {0x0E1F, 0x0E1F}, /*THAI CHARACTER FO FAN*/         {0x0E20, 0x0E20}, /*THAI CHARACTER PHO SAMPHAO*/
    {0x0E21, 0x0E21}, /*THAI CHARACTER MO MA*/          {0x0E22, 0x0E22}, /*THAI CHARACTER YO YAK*/
    {0x0E23, 0x0E23}, /*THAI CHARACTER RO RUA*/         {0x0E24, 0x0E24}, /*THAI CHARACTER RU*/
    {0x0E25, 0x0E25}, /*THAI CHARACTER LO LING*/        {0x0E26, 0x0E26}, /*THAI CHARACTER LU*/
    {0x0E27, 0x0E27}, /*THAI CHARACTER WO WAEN*/        {0x0E28, 0x0E28}, /*THAI CHARACTER SO SALA*/
    {0x0E29, 0x0E29}, /*THAI CHARACTER SO RUSI*/        {0x0E2A, 0x0E2A}, /*THAI CHARACTER SO SUA*/
    {0x0E2B, 0x0E2B}, /*THAI CHARACTER HO HIP*/         {0x0E2C, 0x0E2C}, /*THAI CHARACTER LO CHULA*/
    {0x0E2D, 0x0E2D}, /*THAI CHARACTER O ANG*/          {0x0E2E, 0x0E2E}, /*THAI CHARACTER HO NOKHUK*/
    {0,0},
};

const tCharacter hebrewCharacters[] =    /*26 Characters// // //  CMG3G-8461 Vertical Keyboard Extension*/
{
    {'#',' '},
    {0x05D0, 0x05D0}, /*HEBREW LETTER ALEF*/     {0x05D2, 0x05D2}, /*HEBREW LETTER GIMEL*/
    {0x05D3, 0x05D3}, /*HEBREW LETTER DALET*/    {0x05D4, 0x05D4}, /*HEBREW LETTER HE*/
    {0x05D5, 0x05D5}, /*HEBREW LETTER VAV*/      {0x05D6, 0x05D6}, /*HEBREW LETTER ZAYIN*/
    {0x05D7, 0x05D7}, /*HEBREW LETTER HET*/      {0x05D8, 0x05D8}, /*HEBREW LETTER TET*/
    {0x05D9, 0x05D9}, /*HEBREW LETTER YOD*/      {0x05DB, 0x05DB}, /*HEBREW LETTER KAF  */
    {0x05DA, 0x05DA}, /*HEBREW LETTER FINAL KAF*/{0x05DC, 0x05DC}, /*HEBREW LETTER LAMED*/
    {0x05DE, 0x05DE}, /*HEBREW LETTER MEM*/      {0x05DD, 0x05DD}, /*HEBREW LETTER FINAL MEM*/
    {0x05E0, 0x05E0}, /*HEBREW LETTER NUN*/      {0x05DF, 0x05DF}, /*HEBREW LETTER FINAL NUN*/
    {0x05E1, 0x05E1}, /*HEBREW LETTER SAMEKH*/   {0x05E2, 0x05E2}, /*HEBREW LETTER AYIN*/
    {0x05E4, 0x05E4}, /*HEBREW LETTER PE*/       {0x05E3, 0x05E3}, /*HEBREW LETTER FINAL PE*/
    {0x05E6, 0x05E6}, /*HEBREW LETTER TSADI*/    {0x05E5, 0x05E5}, /*HEBREW LETTER FINAL TSADI*/
    {0x05E7, 0x05E7}, /*HEBREW LETTER QOF*/      {0x05E8, 0x05E8}, /*HEBREW LETTER RESH*/
    {0x05E9, 0x05E9}, /*HEBREW LETTER SHIN*/     {0x05EA, 0x05EA}, /*HEBREW LETTER TAV*/
    {0,0},
};

const tCharacter devanagariCharacters[] =    /*69 Characters// // //  CMG3G-8461 Vertical Keyboard Extension*/
{
    {'#',' '},
    {0x0904,0x0904}, /*DEVANAGARI LETTER SHORT A*/      {0x0905,0x0905}, /*DEVANAGARI LETTER A*/
    {0x0906,0x0906}, /*DEVANAGARI LETTER Aa*/           {0x0907,0x0907}, /*DEVANAGARI LETTER I*/
    {0x0908,0x0908}, /*DEVANAGARI LETTER Ii*/           {0x0909,0x0909}, /*DEVANAGARI LETTER U*/
    {0x090A,0x090A}, /*DEVANAGARI LETTER Uu*/           {0x090B,0x090B}, /*DEVANAGARI LETTER VOCALIC R*/
    {0x090C,0x090C}, /*DEVANAGARI LETTER VOCALIC L*/    {0x090D,0x090D}, /*DEVANAGARI LETTER CANDRA E*/
    {0x090E,0x090E}, /*DEVANAGARI LETTER SHORT E*/      {0x090F,0x090F}, /*DEVANAGARI LETTER E*/
    {0x0910,0x0910}, /*DEVANAGARI LETTER Ai*/           {0x0911,0x0911}, /*DEVANAGARI LETTER CANDRA O*/
    {0x0912,0x0912}, /*DEVANAGARI LETTER SHORT O*/      {0x0913,0x0913}, /*DEVANAGARI LETTER O*/
    {0x0914,0x0914}, /*DEVANAGARI LETTER Au*/           {0x0915,0x0915}, /*DEVANAGARI LETTER Ka*/
    {0x0916,0x0916}, /*DEVANAGARI LETTER Kha*/          {0x0917,0x0917}, /*DEVANAGARI LETTER Ga*/
    {0x0918,0x0918}, /*DEVANAGARI LETTER Gha*/          {0x0919,0x0919}, /*DEVANAGARI LETTER Nga*/
    {0x091A,0x091A}, /*DEVANAGARI LETTER Cha*/          {0x091B,0x091B}, /*DEVANAGARI LETTER Chha*/
    {0x091C,0x091C}, /*DEVANAGARI LETTER Ja*/           {0x091D,0x091D}, /*DEVANAGARI LETTER Jha*/
    {0x091E,0x091E}, /*DEVANAGARI LETTER Nya*/          {0x091F,0x091F}, /*DEVANAGARI LETTER Tta*/
    {0x0920,0x0920}, /*DEVANAGARI LETTER Ttha*/         {0x0921,0x0921}, /*DEVANAGARI LETTER Dda*/
    {0x0922,0x0922}, /*DEVANAGARI LETTER Ddha*/         {0x0923,0x0923}, /*DEVANAGARI LETTER Nna*/
    {0x0924,0x0924}, /*DEVANAGARI LETTER Tha*/          {0x0925,0x0925}, /*DEVANAGARI LETTER Thha*/
    {0x0926,0x0926}, /*DEVANAGARI LETTER Dha*/          {0x0927,0x0927}, /*DEVANAGARI LETTER Dhha*/
    {0x0928,0x0928}, /*DEVANAGARI LETTER Na*/           {0x0929,0x0929}, /*DEVANAGARI LETTER Nnna*/
    {0x092A,0x092A}, /*DEVANAGARI LETTER Pa*/           {0x092B,0x092B}, /*DEVANAGARI LETTER Fa*/
    {0x092C,0x092C}, /*DEVANAGARI LETTER Ba*/           {0x092D,0x092D}, /*DEVANAGARI LETTER Bha*/
    {0x092E,0x092E}, /*DEVANAGARI LETTER Ma*/           {0x092F,0x092F}, /*DEVANAGARI LETTER Ya*/
    {0x0930,0x0930}, /*DEVANAGARI LETTER Ra*/           {0x0931,0x0931}, /*DEVANAGARI LETTER Rra*/
    {0x0932,0x0932}, /*DEVANAGARI LETTER La*/           {0x0933,0x0933}, /*DEVANAGARI LETTER Lla*/
    {0x0934,0x0934}, /*DEVANAGARI LETTER Llla*/         {0x0935,0x0935}, /*DEVANAGARI LETTER Va*/
    {0x0936,0x0936}, /*DEVANAGARI LETTER Sha*/          {0x0937,0x0937}, /*DEVANAGARI LETTER Ssha*/
    {0x0938,0x0938}, /*DEVANAGARI LETTER Sa*/           {0x0939,0x0939}, /*DEVANAGARI LETTER Ha*/
    {0x0958,0x0958}, /*DEVANAGARI LETTER Qa*/           {0x0959,0x0959}, /*DEVANAGARI LETTER Khha*/
    {0x095A,0x095A}, /*DEVANAGARI LETTER Ghha*/         {0x095B,0x095B}, /*DEVANAGARI LETTER Za*/
    {0x095C,0x095C}, /*DEVANAGARI LETTER Ddda*/         {0x095D,0x095D}, /*DEVANAGARI LETTER Dddha*/
    {0x095E,0x095E}, /*DEVANAGARI LETTER Ffa*/          {0x095F,0x095F}, /*DEVANAGARI LETTER Yya*/
    {0x0960,0x0960}, /*DEVANAGARI LETTER VOCALIC Rr*/   {0x0961,0x0961}, /*DEVANAGARI LETTER VOCALIC Ll*/
    {0x097B,0x097B}, /*DEVANAGARI LETTER Gga*/          {0x097C,0x097C}, /*DEVANAGARI LETTER Jja*/
    {0x097D,0x097D}, /*DEVANAGARI LETTER GLOTTAL STOP*/ {0x097E,0x097E}, /*DEVANAGARI LETTER Ddda*/
    {0x097F,0x097F}, /*DEVANAGARI LETTER Bba*/
    {0,0},
};

#endif /* SEARCHKEYBOARDDATA_H_ */

/** @} */
