/**
 * @addtogroup Common
 * @author Dinesh
 *
 * Public interface for SearchKeyboard which provides character mapped List Slice boundaries
 * @{
 */

#ifndef SEARCHKEYBOARD_H_
#define SEARCHKEYBOARD_H_

#include "TypeDefinitions.h"
#include "SearchKeyboardData.h"
#include "LocalSPM.h"

class SearchKeyboard
{
    public:
        static SearchKeyboard& GetInstance(void) { static SearchKeyboard skb; return skb; }
        tResult GetSearchKeyboard(vector<tSearchKeyboard> &searchKeyboardList,vector<tSearchKey> &searchKeys,tLanguageType language );


    private:
        tResult CreateSearchKeyboard(vector<tSearchKeyboard> &searchKeyboardList,vector<tSearchKey> &searchKeys ,
                                        const tCharacter *characterSet,tU16 noOfCharacters);
        tBoolean GetNonLatinCharacterSet(const tCharacter **characterSet, tUInt &size,tLanguageType language );
};

#endif /* SEARCHKEYBOARD_H_ */

/** @} */
