/* File MediaPlayer_ErrorCodes.h
 * Brief This file holds the names of different error codes
 *
 * Author:
 *
 * Version
 *
 * Date
 *
 * This file holds the names of different error codes.
 *
 */

#ifndef __MEDIAPLAYER_ERRORCODES_H__ // only include this file once
#define __MEDIAPLAYER_ERRORCODES_H__

#define MEDIAPLAYER_SUCCESS                             (0)
#define MEDIAPLAYER_ERROR_MEM_ALLOC                     (1)
#define MEDIAPLAYER_ERROR_FILE_OPEN                     (2)
#define MEDIAPLAYER_ERROR_FILE_READ                     (3)
#define MEDIAPLAYER_ERROR_FILE_WRITE                    (4)
#define MEDIAPLAYER_ERROR_NULL_POINTER                  (5)

#define MEDIAPLAYER_ERROR_INVALID_LISTTYPE              (7)
#define MEDIAPLAYER_ERROR_DEVICE_NOT_FOUND              (8)
#define MEDIAPLAYER_ERROR_INVALID_FILEFORMAT            (9)
#define MEDIAPLAYER_ERROR_RANGE_OUT_BOUND               (10)
#define MEDIAPLAYER_ERROR_INVALID_FILTER_TYPE           (11)
#define MEDIAPLAYER_ERROR_FILE_DOES_NOT_EXISTS          (12)
#define MEDIAPLAYER_ERROR_INVALID_PARAM                 (13)
#define MEDIAPLAYER_ERROR_LIST_HANDLE_GEN               (14)
#define MEDIAPLAYER_ERROR_INVALID_HANDLE                (15)

#define MEDIAPLAYER_ERROR_CANNOT_DECODE_MEDIA           (17)
#define MEDIAPLAYER_ERROR_AUDIO_DEVICE_ALREADY_IN_USE   (18)
#define MEDIAPLAYER_ERROR_DB_QUERY                      (19)
#define MEDIAPLAYER_ERROR_ACTION_NOT_FOUND              (20)

#define MEDIAPLAYER_ERROR_INVALID_FILTER_TAG            (21)
#define MEDIAPLAYER_ERROR_LIST_SIZE_ZERO                (22)
#define MEDIAPLAYER_ERROR_INVALID_RELEASE_LIST_HANDLE   (23)
#define MEDIAPLAYER_ERROR_UNKNOWN_ERROR                 (24)
#define MEDIAPLAYER_ERROR_INVALID_OPERATION             (25)
#define MEDIAPLAYER_ERROR_RELEASE_LIST_NOWPLAYING       (26)
#define MEDIAPLAYER_ERROR_INDEXING_DEVICE_CHANGED       (27)

//iPod indexing checksum
#define MEDIAPLAYER_SUCCESS_INDEXING_NOT_REQUIRED       (28)
#define MEDIAPLAYER_ERROR_LAYER_SYNC                    (29)

#define MEDIAPLAYER_ERROR_BUSY                          (30)
#define MEDIAPLAYER_ERROR_INVALID_PAYLOAD               (31)
#define MEDIAPLAYER_ERROR_MISSING_SOURCE                (32)
#define MEDIAPLAYER_ERROR_INVALID_SOURCE                (33)
#define MEDIAPLAYER_ERROR_INVALID_STATE                 (34)
#define MEDIAPLAYER_ERROR_UNKNOWN                       (35)

// Synchronization locks error
#define MEDIAPLAYER_LOCK_TIMEOUT_ERROR                  (36)

// Bosch correction
// DBManager extension
// DBManager related error codes
#define MEDIAPLAYER_ERROR_DBMANAGER_NOT_INITIALIZED     (37)
#define MEDIAPLAYER_DBMANAGER_ALREADY_INITIALIZED       (38)
#define MEDIAPLAYER_DBMANAGER_INITIALIZATION_ERROR      (39)
#define MEDIAPLAYER_DBMANAGER_SYNCHRONIZATION_ERROR     (40)
#define MEDIAPLAYER_DBMANAGER_QUERY_ERROR               (41)
#define MEDIAPLAYER_DBMANAGER_TIMEOUT_ERROR             (42)
#define MEDIAPLAYER_DBMANAGER_SHUTDOWN_ERROR            (43)
#define MEDIAPLAYER_DBMANAGER_ALREADY_SHUTDOWN          (44)
#define MEDIAPLAYER_DBMANAGER_QUERY_INTERRUPTED         (45)
// Bosch correction
// Improved MyMedia context handling
#define MEDIAPLAYER_DBMANAGER_INVALID_CONTAINER         (46)
// End of Bosch correction
// Improved MyMedia context handling
// End of Bosch correction
// DBManager extension

#endif //__MEDIAPLAYER_ERRORCODES_H__  // only includes file if not previously included
