#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MediaPlayerShutdownTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif


#include "IpcTest.h"
#include "PlayerEngineIpcIF.h"
#include "Dispatcher.h"
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"

#include "FunctionTracer.h"

/*Global data common to all testcases*/
static char  mPEPath[20];              /**< dbus path of PlayerEngine obtained dynamically */

IpcTest::IpcTest()
{
    mCreateSerial = 0; //CID 17900 (#1 of 1): Uninitialized scalar field (UNINIT_CTOR)
    IpcBase::RegisterService((char *)MEDIAPLAYER_SERVICE, (char *)MEDIAPLAYER_PATH, (char *)MEDIAPLAYER_INTERFACE);

}

void IpcTest::setUp()
{
    pthread_mutex_init(&mutex,NULL);
    pthread_cond_init(&condition,NULL);
    ticks.begin();

    if(strcmp(mPEPath,""))
        OverridePath(IPC_PLAYER_ENGINE_INTERFACE,mPEPath);
}

void IpcTest::tearDown()
{
    ticks.elapsed();
    pthread_mutex_destroy(&mutex);
    pthread_cond_destroy(&condition);
}

void IpcTest::testPECreate()
{
    ENTRY

    /*Start dbus dispatcher thread and wait dispatch thread is started*/
    LocalSPM::GetThreadFactory().Do(this, 0, NULL);

    /* wait for thread to execute (WAIT will be released when thread fucntion starts)*/
    ASYNC_WAIT_START(1)

    /*create the player instance*/
    mCreateSerial = MethodCall(ipc_PlayerEngine_CreatePlayerInstance);

    /*wait for method answer for "CreatePlayerInstance" */
    ASYNC_WAIT_START(3)


    //CPPUNIT_ASSERT(!strcmp(mPEPath,"PlayerEngine/0");
}

void IpcTest::testPERegisterObserver()
{
    IpcClient::MethodCall(ipc_PlayerEngine_RegisterObserver,MEDIAPLAYER_SERVICE,MEDIAPLAYER_PATH,MEDIAPLAYER_INTERFACE);
    IpcClient::MethodCall(ipc_PlayerEngine_SwitchObserver,MEDIAPLAYER_SERVICE,MEDIAPLAYER_PATH,MEDIAPLAYER_INTERFACE);
}

void IpcTest::testPEPlayTrack()
{
    int value =  IpcClient::MethodCall(ipc_PlayerEngine_PlaySlot,"/home/tritonsu/Music/Kalimba.mp3");

    printf("value %d\n",value);
    //CPPUNIT_ASSERT(!strcmp(GetCurrentTrackName(),"Kalimba");
}

tBoolean IpcTest::SignalReceived(const char* name , const char* params)
{
    (void)name;
    (void)params;
    // debug printf("Dbus Signal -> name(%s):%s\n",name,params);
    return 0x00;
}

tBoolean IpcTest::MethodRequested(dbus_uint32_t serial, const char* name , const char* params)
{
    (void)serial;
    (void)name;
    (void)params;
    // debug printf("Dbus method callback -> serial(%d), name(%s):%s\n",serial,name,params);
    return 0x00;
}

tBoolean IpcTest::MethodAnswered(dbus_uint32_t serial , const char* params)
{
    if((mCreateSerial == serial) && params)
    {
        // MethodAnswer to CreatePlayerInstance method call will have the instance "Path"
        strncpy_r(mPEPath, params, sizeof(mPEPath)); //CID 17354 (#1 of 1): Copy into fixed size buffer (STRING_OVERFLOW)
        ASYNC_WAIT_RELEASE
        return 0x01;
    }
    return 0x00;
}

tBoolean IpcTest::Error(dbus_uint32_t serial , const char* error)
{
    fprintf(stderr, "Dbus Error -> serial(%d):%s\n",serial,error);
    return 0x00;
}

void IpcTest::IpcDispatcher(void *userPtr)
{
    ASYNC_WAIT_RELEASE

    (void)userPtr;
    IpcClient::SetFilter(GMPDBUS_BUS_SESSION,"type='method_call',interface='local.MediaPlayer'");
    IpcClient::SetFilter(GMPDBUS_BUS_SESSION,"type='method_return',interface='local.PlayerEngine.PlayerEngine'");
    IpcClient::SetFilter(GMPDBUS_BUS_SESSION,"type='signal',interface='local.PlayerEngine.PlayerEngine'");
    IpcClient::SetFilter(GMPDBUS_BUS_SESSION,"type='error',interface='local.PlayerEngine.PlayerEngine'");

    while(!IpcClient::DispatchMessages())
    ;
}

void IpcTest::Do(int param, void *userPtr)
{
    //thread function
    switch(param)
    {
        case 0:
        {
            IpcDispatcher(userPtr);
            break;
        }
        default:
            break;
    }
}
