/*
 * main.cpp
 *
 *  Created on: Jul 18, 2013
 *  Maintainer: Dinesh
 *              Generic MediaPlayer adaptations
 *
 *  Changes :-
 *      -   Added GUI based test runner using QxRunner & QxCppUnit
 *      -   extended with options for ipod/mtp stubs
 *      -   extended with option to run combination of specific tests with name separated by ':'
 */

#ifndef _main_cpp_
#define _main_cpp_

#ifndef TARGET_BUILD
//#define MP_ENABLE_CPPUNIT_GUI  /*enable or disable here the QxRunner based GUI to view and run the unit test with custom combinations*/
#endif


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/main.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include <unistd.h>
#include <iostream>
#include <exception>
#include <memory>
#include <string>
#include <map>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libgen.h>

#include <cppunit/CompilerOutputter.h>
#include <cppunit/TextOutputter.h>
#include <cppunit/XmlOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestResultCollector.h>
#include <cppunit/TestRunner.h>
#include <cppunit/TextTestProgressListener.h>
#include <cppunit/BriefTestProgressListener.h>
#include <cppunit/TestSuccessListener.h>
#include <cppunit/Portability.h>
#include "TypeDefinitions.h"

using namespace CPPUNIT_NS;
using std::cerr;
using std::cout;
using std::endl;
using std::exception;
using std::auto_ptr;
using std::string;
using std::map;
using std::make_pair;

static const int RET_OK = 0;
static const int RET_USAGE = -1;
static const int RET_BAD_OUTPUTTER = -2;
static const int RET_BAD_LISTENER = -3;
static const int RET_BAD_TEST = -4;

/*
####################################################################################################
######################### 1. GUI based TestRunner ##################################################
####################################################################################################
*/
#ifdef MP_ENABLE_CPPUNIT_GUI
#include <QApplication>
#include <qxcppunit/testrunner.h>
#include <cppunit/extensions/TestFactoryRegistry.h>

int main(int argc , char *argv[])
{
    gIPODConnected = 0;
    gMTPConnected = 0;

    extern int globalFakeTheIpod;
    globalFakeTheIpod = 1; //enable fake the iPod

    QApplication app(argc, argv);

    QxCppUnit::TestRunner runner;

    runner.addTest(CPPUNIT_NS::TestFactoryRegistry::getRegistry().makeTest());
    runner.run();

    return 0;
}
/*
####################################################################################################
######################### 2. Command line TestRunner ###############################################
####################################################################################################
*/

#else

/*
 * Copyright (c) 2008, Robert Emerson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Robert Emerson nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ROBERT EMERSON ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ROBERT EMERSON BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
typedef map<string, Outputter *> OutputterMap;
typedef map<string, TestListener *> ListenerMap;

void usage( char *image,
           const char *defaultTest,
           const OutputterMap &outputters,
           const ListenerMap &listeners)
{
  printf("Usage: %s  (-o outputter) (-p progress) (-t test) (-r count)\n",basename(image));
  printf("Usage: %s  [ -l | -h ]\n",basename(image));
  printf("A CppUnit command line test execution tool. \n");

  printf("Options:\n");
  {
      printf("    -o Output style. Choices: ");
      OutputterMap::const_iterator it = outputters.begin();
      while (it != outputters.end())
      {
          printf("%s ",it->first.c_str());
          ++it;
      }
      printf("Default: compiler\n");
  }
  {
      printf("    -p Progress style. Choices: ");
        ListenerMap::const_iterator it = listeners.begin();
      while (it != listeners.end())
      {
          printf("%s ",it->first.c_str());
          ++it;
      }
      printf("Default: dots\n");
  }

  printf("    -t Runs the given tests only separated by \":\" e.g MediaPlayerStartupTest:DBManagerTest:MediaPlayerShutdownTest. Default: \"%s\" \n",defaultTest);
  printf("    -r Repeat count. Default: 1 \n");
  printf("    -l List all available tests.\n");
  printf("    -h Print this usage message.\n");
  printf("    -i ipod connected \n");
  printf("    -m mtp connected \n");
  printf("    -f <result file> dump result in xml format to resultfile ; Default file: \"testresult.xml\"\n");

  return;
}

// Recursive dumps the given Test heirarchy to stdout
void dump(Test *test)
{
  if (0 == test) return;

  printf("%s\n",test->getName().c_str());
  if (0 == test->getChildTestCount()) return;

  for (int i = 0; i < test->getChildTestCount(); i++)
  {
    dump(test->getChildTestAt(i));
  }
  printf("************************************************************************************************\n");

  return;
}

// Recursively seeks the Test matching the given name, returns 0 otherwise.
Test *find(Test *test, const string &name)
{
    if (0 == test) return 0;

    if (name == test->getName()) return test;

    if (0 == test->getChildTestCount()) return 0;

    for (int i = 0; i < test->getChildTestCount(); i++)
    {
        Test *found = find(test->getChildTestAt(i), name);
        if (found) return found;
    }

    return 0;
}

int _return(int retValue)
{
#ifndef TARGET_BUILD
    return retValue;
#else
    _exit (retValue);
#endif
    return retValue;
}

int main(int argc, char **argv)
{
    //int retValue = RET_OK;
    TestResult result;
    TestResultCollector collector;
    result.addListener(&collector);

    OutputterMap allOutputters;
    allOutputters.insert(make_pair("compiler",new CompilerOutputter(&collector, cout)));
    allOutputters.insert(make_pair("text"    ,new TextOutputter(&collector, cout)));
    allOutputters.insert(make_pair("xml"     ,new XmlOutputter(&collector, cout)));
    allOutputters.insert(make_pair("none"    ,static_cast<Outputter *>(0)));
    Outputter *outputter = allOutputters.find("compiler")->second; //default outputter

    ListenerMap allListeners;
    allListeners.insert(make_pair("dots", new TextTestProgressListener()));
    allListeners.insert(make_pair("brief", new BriefTestProgressListener()));
    allListeners.insert(make_pair("none", static_cast<TestListener *>(0)));
    //TestListener *listener = allListeners.find("dots")->second; //default listener

    signed char flag = 0;
    string runTest = basename(argv[0]);

    /* default values */
    int repeat = 1;
    gIPODConnected = 0;
    gMTPConnected = 0;
    if (!find(TestFactoryRegistry::getRegistry().makeTest(), runTest))
    {
        runTest = "All Tests";
    }

#ifdef TARGET_BUILD
    /* open trace channel */
    et_vTraceOpen();
#endif
    int gXMLOutput = 0;
    char gXMLOutputName[1024];
    gXMLOutputName[0] = 0;

    while(1)
    {
        const char *shortOptions = (const char *)"r:t:o:p:f:imlh";

        flag = getopt(argc, argv, shortOptions);
        if (flag == -1) break;

        switch(flag)
        {

            case 'r':
                repeat = atoi(optarg);
                break;

            case 'o':
            {
                OutputterMap::const_iterator it = allOutputters.find(optarg);
                if (it == allOutputters.end())
                {
                    cerr << "Unknown outputter: " << optarg << endl;
                    //retValue = RET_BAD_OUTPUTTER;
                }
                else
                {
                    outputter = it->second;
                }
            }
            break;

            case 'p':
            {
                string progress(optarg);
                ListenerMap::const_iterator it = allListeners.find(optarg);
                if (it == allListeners.end())
                {
                    cerr << "Unknown listener: " << optarg << endl;
                    _return( RET_BAD_LISTENER);
                }
                //listener = it->second;
            }
            break;
            case 'l':
            {
                Test *all = TestFactoryRegistry::getRegistry().makeTest();
                dump(all);
                _return( RET_OK);
            }
            break; // not reached
            case 't':
                runTest = optarg;
                break;

         case 'i':
             gIPODConnected = 1;
             break;

         case 'm':
             gMTPConnected = 1;
             break;

            case 'f':
        	 gXMLOutput = 1;
        	 if (optarg)
        		 strncpy_r(gXMLOutputName, optarg, sizeof gXMLOutputName);  //CID 10137 (#1 of 1): Buffer not null terminated (BUFFER_SIZE_WARNING)
        	 else
        		 strncpy_r(gXMLOutputName, "testresult.xml", sizeof gXMLOutputName);
        	 break;

            case 'h':
         case '?':
            default:
                usage(argv[0], runTest.c_str(), allOutputters, allListeners);
                _return( RET_USAGE);
                break; // not reached
        }
    }
    if (!gIPODConnected)
    {
        extern int globalFakeTheIpod;
        globalFakeTheIpod = 1; //enable fake the iPod
    }

    extern int globalFakeTheCDDA;
    globalFakeTheCDDA = 1; //enable fake the CDDA

    /*multiple  tests/suites at a time*/
    TestSuite *run = new CppUnit::TestSuite( "MediaPlayerUnitTest" );

    std::stringstream ss(runTest);
    std::string testcaseName;
    while (std::getline(ss, testcaseName, ':'))
    {
        Test *testCase = find(TestFactoryRegistry::getRegistry().makeTest(), testcaseName);
        if (testCase == 0)
        {
            printf("Unknown test case: %s\n",testcaseName.c_str());
            continue;
        }
        run->addTest(testCase);
    }

    TestRunner runner;
    runner.addTest(run);

    for (int i = 0; i < repeat; i++)
    {
        runner.run(result);
    }

    std::fstream outputfile;
    if (gXMLOutput)
    {   
        outputfile.open(gXMLOutputName, std::fstream::out);
        outputter = new XmlOutputter(&collector, outputfile);
    }
    if (outputter)
    {
        printf("\n-----------------------\n"); //separate result string from previous output
        outputter->write();
    }

    // flush output(s)
    std::cout.flush();
    std::cerr.flush();
    outputfile.close();

#ifndef TARGET_BUILD
    return collector.testErrors() + collector.testFailures();
#else
    _exit ((collector.testErrors() + collector.testFailures()) ? 1 : 0);
#endif
}
#endif
#endif // _1_cppunit_cpp_
