#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/SMF_Validation.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include  <errno.h>
#include <memory.h>
#include <ListControl.h>

#include "SMF_Validation.h"
#include <FunctionTracer.h>
#include "CppUnitDefinitions.h"

void SMFTest::setUp()
{
    pthread_mutex_init(&mutex,NULL);
    pthread_cond_init(&condition,NULL);
    ticks.begin();
}

void SMFTest::tearDown()
{
    ticks.elapsed();
    pthread_mutex_destroy(&mutex);
    pthread_cond_destroy(&condition);
}

void SMFTest::Do(int param, void *userPtr)
{
    //thread function
    switch(param)
    {
        case 0:
        {
            SMF *smf = (SMF *)userPtr;
            while(mySMImpl::STATE_MACHINE_FINISHED != smf->StateMachine_Main()){};
            ASYNC_WAIT_RELEASE
            break;
        }
        default:
            break;
    }
}

void SMFTest::ReferenceStateMachineTest()
{
    printf("          ***Start %s***\n", __PRETTY_FUNCTION__);
    mySMImpl smf;

    int ret;
    char *Parameter = NULL;

    // create the reference state machine
    smf.Create();

    // do the init transitions
    smf.ExpectReset();
#if 1
    smf.ExpectSetString("State: topStateM: Enter");
    smf.ExpectSetString("Trans: StateM_Init: Guard");
    smf.ExpectSetString("Trans: StateM_Init: Action");
    smf.ExpectSetString("State: POWER_CYCLE: Enter");
    smf.ExpectSetString("Trans: INIT: Guard");
    smf.ExpectSetString("Trans: INIT: Action");
    smf.ExpectSetString("State: OFF: Enter");
#endif
    smf.ExpectSetString("OFF");
    smf.Init();
    smf.Expect(smf.GetCurrentState());
    CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

    /* register reference state machine to dispatcher */
    Dispatcher::GetInstance().Register(&smf);

    /* thread to run State Machine */
    LocalSPM::GetThreadFactory().Do(this, 0, (void *)&smf);

    for(int i=0; i<1; i++) {

        //OFF state is start

        /* test */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TO_PLAYER_ON: Guard");
        smf.ExpectSetString("State: OFF: Exit");
        smf.ExpectSetString("Trans: TO_PLAYER_ON: Action");
        smf.ExpectSetString("State: PLAYER: Enter");
        smf.ExpectSetString("Trans: INIT_PLAYER: Guard");
        smf.ExpectSetString("Trans: INIT_PLAYER: Action");
        smf.ExpectSetString("State: STOPPED: Enter");
#endif
        smf.ExpectSetString("STOPPED");
        ret = smf.SendEventByName("PLAYER_ON_EVENT", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        // test the default transition
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: DEFAULT_PLAYER: Guard");
        smf.ExpectSetString("Trans: DEFAULT_PLAYER: Action");
#endif
        smf.ExpectSetString("STOPPED");
        ret = smf.SendEventByName("PLAYER_ON_EVENT", Parameter); // SM is already in ON state: default transition (in Player) should be fired
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TO_OFF: Guard");
        smf.ExpectSetString("State: STOPPED: Exit");
        smf.ExpectSetString("State: PLAYER: Exit");
        smf.ExpectSetString("Trans: TO_OFF: Action");
        smf.ExpectSetString("State: OFF: Enter");
#endif
        smf.ExpectSetString("OFF");
        ret = smf.SendEventByName("OFF_EVENT", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: CATCH_OFF: Guard");
        smf.ExpectSetString("Trans: CATCH_OFF: Action");
#endif
        smf.ExpectSetString("OFF");
        ret = smf.SendEventByName("OFF_EVENT", Parameter); // SM is already in OFF state: catch off transition should be fired
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* set player to on, now test the sub compound states */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TO_PLAYER_ON: Guard");
        smf.ExpectSetString("State: OFF: Exit");
        smf.ExpectSetString("Trans: TO_PLAYER_ON: Action");
        smf.ExpectSetString("State: PLAYER: Enter");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: STOPPED: Enter");
#endif
        smf.ExpectSetString("STOPPED");
        //ret = smf.SendEvent(smf.PLAYER_ON_EVENT, userData);
        ret = smf.SendEventByName("PLAYER_ON_EVENT", "");
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* start playing media */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TO_PLAY: Guard");
        smf.ExpectSetString("State: STOPPED: Exit");
        smf.ExpectSetString("Trans: TO_PLAY: Action");
        smf.ExpectSetString("State: PLAYING: Enter");
        smf.ExpectSetString("RemoveMessageByName");
#endif
        smf.ExpectSetString("PLAYING");
        ret = smf.SendEventByName("PLAY_EVENT", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* test delay message */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: DELAY_TEST: Guard");
        smf.ExpectSetString("State: PLAYING: Exit");
        smf.ExpectSetString("State: PLAYER: Exit");
        smf.ExpectSetString("Trans: DELAY_TEST: Action");
        smf.ExpectSetString("State: DelayMessageCompound: Enter");
        smf.ExpectSetString("State: DelayMessage: Enter");
#endif
        smf.ExpectSetString("DelayMessage");
        ret = smf.SendEventByName("DELAY_TEST", Parameter); // go to the delay test state
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: DELAYMESSAGECOMPOUND2DELAYMESSAGECOMPOUNDSTOPEVENTDELAY: Guard");
        smf.ExpectSetString("Trans: DELAYMESSAGECOMPOUND2DELAYMESSAGECOMPOUNDSTOPEVENTDELAY: Action");
#endif
        smf.ExpectSetString("DelayMessage");
        ret = smf.SendEventByName("STOP_EVENT", Parameter); // this event should be put into the delay queue
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* now move from internal DelayMessage to its Compound. The delayed message should not be fired */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: DelayMessage2DelayMessageCompoundFirstStep: Guard");
        smf.ExpectSetString("State: DelayMessage: Exit");
        smf.ExpectSetString("Trans: DelayMessage2DelayMessageCompoundFirstStep: Action");
#endif
        smf.ExpectSetString("DelayMessageCompound");
        ret = smf.SendEventByName("TO_DELAY_COMPOUND", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* go back to the inner DelayMessage state */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: DelayMessageCompound2DelayMessageBackToInnerState: Guard");
        smf.ExpectSetString("Trans: DelayMessageCompound2DelayMessageBackToInnerState: Action");
        smf.ExpectSetString("State: DelayMessage: Enter");
        smf.ExpectSetString("Trans: DELAYMESSAGECOMPOUND2DELAYMESSAGECOMPOUNDSTOPEVENTDELAY: Guard");
        smf.ExpectSetString("Trans: DELAYMESSAGECOMPOUND2DELAYMESSAGECOMPOUNDSTOPEVENTDELAY: Action");
#endif
        smf.ExpectSetString("DelayMessage");
        ret = smf.SendEventByName("BACK_TO_DELAY_STATE", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* now fire the event to return to playing. The delayed event should be fired afterwards */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: RETURN_TO_PLAYING: Guard");
        smf.ExpectSetString("State: DelayMessage: Exit");
        smf.ExpectSetString("State: DelayMessageCompound: Exit");
        smf.ExpectSetString("Trans: RETURN_TO_PLAYING: Action");
        smf.ExpectSetString("State: PLAYER: Enter");
        smf.ExpectSetString("State: PLAYING: Enter");
        smf.ExpectSetString("RemoveMessageByName");
        smf.ExpectSetString("Trans: TO_STOP: Guard"); // from here the delayed message is processed
        smf.ExpectSetString("State: PLAYING: Exit");
        smf.ExpectSetString("Trans: TO_STOP: Action");
        smf.ExpectSetString("State: STOPPED: Enter");
#endif
        smf.ExpectSetString("STOPPED");
        ret = smf.SendEventByName("RETURN_TO_PLAYING", Parameter); // returns to playing state and issues all delayed message
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* after the RETURN_TO_PLAYING the delayed event STOP_EVENT will be processed, the reference sm should be in STOPPED state and must be sent back to PLAYING */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TO_PLAY: Guard");
        smf.ExpectSetString("State: STOPPED: Exit");
        smf.ExpectSetString("Trans: TO_PLAY: Action");
        smf.ExpectSetString("State: PLAYING: Enter");
        smf.ExpectSetString("RemoveMessageByName");
#endif
        smf.ExpectSetString("PLAYING");
        ret = smf.SendEventByName("PLAY_EVENT", Parameter); // returns to playing state and issues all delayed message
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* test more delay messages by default/DelayEvent definition */
        smf.ExpectReset();

        // bring it to the test state
#if 1
        smf.ExpectSetString("Trans: Playing2DelayAllMessages: Guard");
        smf.ExpectSetString("State: PLAYING: Exit");
        smf.ExpectSetString("State: PLAYER: Exit");
        smf.ExpectSetString("Trans: Playing2DelayAllMessages: Action");
        smf.ExpectSetString("State: DelayAllMessages: Enter");
#else
        smf.ExpectSetString("on");
#endif
        smf.ExpectSetString("DelayAllMessages");
        ret = smf.SendEventByName("DELAY_ALL_TEST", Parameter); // go to the delay test state
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        // now fire a event that will be delayed
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: DEFAULT_DelayAllMessages: Guard");
        smf.ExpectSetString("Trans: DEFAULT_DelayAllMessages: Action");
#else
        smf.ExpectSetString("on");
#endif
        smf.ExpectSetString("DelayAllMessages");
        ret = smf.SendEventByName("STOP_EVENT", Parameter); // this event should be put into the delay queue
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        // now fire another event that will be delayed, bring the state machine later on to OFF
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: DEFAULT_DelayAllMessages: Guard");
        smf.ExpectSetString("Trans: DEFAULT_DelayAllMessages: Action");
#else
        smf.ExpectSetString("on");
#endif
        smf.ExpectSetString("DelayAllMessages");
        ret = smf.SendEventByName("OFF_EVENT", Parameter); // this event should be put into the delay queue
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        // fire an event that will be removed by the exit of the DelayAllMessages state
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: DEFAULT_DelayAllMessages: Guard");
        smf.ExpectSetString("Trans: DEFAULT_DelayAllMessages: Action");
#else
        smf.ExpectSetString("on");
#endif
        smf.ExpectSetString("DelayAllMessages");
        ret = smf.SendEventByName("SEEK_BACKW_EVENT", Parameter); // this event should be put into the delay queue
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        // now fire the event that will leave the DelayAllMessages state
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: DelayAllMessages2Playing: Guard");
        smf.ExpectSetString("State: DelayAllMessages: Exit");
        smf.ExpectSetString("Trans: DelayAllMessages2Playing: Action");
        smf.ExpectSetString("State: PLAYER: Enter");
        smf.ExpectSetString("State: PLAYING: Enter");

        // now the additional deleayed event SEEK_BACKW_EVENT has to be removed from the external qeuue
        smf.ExpectSetString("RemoveMessageByName");

        // from here the delayed message is processed
        smf.ExpectSetString("Trans: TO_STOP: Guard");
        smf.ExpectSetString("State: PLAYING: Exit");
        smf.ExpectSetString("Trans: TO_STOP: Action");
        smf.ExpectSetString("State: STOPPED: Enter");

        // after that the delayed OFF_EVENT will be fired. it will lead to state OFF because we are in PLAYING
        smf.ExpectSetString("Trans: TO_OFF: Guard");
        smf.ExpectSetString("State: STOPPED: Exit");
        smf.ExpectSetString("State: PLAYER: Exit");
        smf.ExpectSetString("Trans: TO_OFF: Action");
        smf.ExpectSetString("State: OFF: Enter");
#else
        smf.ExpectSetString("on");
#endif
        smf.ExpectSetString("OFF");
        ret = smf.SendEventByName("RETURN_TO_PLAYING", Parameter); // returns to playing state and issues all delayed message
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        // after the RETURN_TO_PLAYING the delayed event STOP_EVENT and OFF_EVENT will be processed,
        // the reference sm should be in STOPPED state and must be sent back to PLAYING
        // step 1: goto STOPPED (via history)
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TO_PLAYER_ON: Guard");
        smf.ExpectSetString("State: OFF: Exit");
        smf.ExpectSetString("Trans: TO_PLAYER_ON: Action");
        smf.ExpectSetString("State: PLAYER: Enter");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: STOPPED: Enter");
#else
        smf.ExpectSetString("on");
#endif
        smf.ExpectSetString("STOPPED");
        ret = smf.SendEventByName("PLAYER_ON_EVENT", Parameter); // returns to stopped
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        // step 2: goto PLAYING (via event)
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TO_PLAY: Guard");
        smf.ExpectSetString("State: STOPPED: Exit");
        smf.ExpectSetString("Trans: TO_PLAY: Action");
        smf.ExpectSetString("State: PLAYING: Enter");
        smf.ExpectSetString("RemoveMessageByName");
#else
        smf.ExpectSetString("on");
#endif
        smf.ExpectSetString("PLAYING");
        ret = smf.SendEventByName("PLAY_EVENT", Parameter); // returns to playing state
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* test internal condition transition in player compound state */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TO_BACK: Guard");
        smf.ExpectSetString("State: PLAYING: Exit");
        smf.ExpectSetString("Trans: TO_BACK: Condition");
        smf.ExpectSetString("Trans: TRUE: Guard");
        smf.ExpectSetString("Trans: TRUE: Action");
        smf.ExpectSetString("1");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: PLAYING: Enter");
        smf.ExpectSetString("RemoveMessageByName");
#endif
        smf.ExpectSetString("PLAYING");
        ret = smf.SendEventByName("BACK_EVENT", "1");
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* start radio */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: SWITCH_RADIO_ON: Guard");
        smf.ExpectSetString("State: PLAYING: Exit");
        smf.ExpectSetString("State: PLAYER: Exit");
        smf.ExpectSetString("Trans: SWITCH_RADIO_ON: Action");
        smf.ExpectSetString("State: RADIO: Enter");
        smf.ExpectSetString("Trans: INIT_RADIO: Guard");
        smf.ExpectSetString("Trans: INIT_RADIO: Action");
        smf.ExpectSetString("State: TUNING: Enter");
        smf.ExpectSetString("Trans: INIT_TUNING: Guard");
        smf.ExpectSetString("Trans: INIT_TUNING: Action");
        smf.ExpectSetString("State: SEEK_FORWARD: Enter");
#endif
        smf.ExpectSetString("SEEK_FORWARD");
        ret = smf.SendEventByName("RADIO_ON_EVENT", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        //test MessageAnswer not consumed
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("START_PROCESSING: notConsumed");
        smf.ExpectSetString("SEEK_FORWARD");
#endif
        RequestResponseSM rrSMTestX;
        // old,useless rrSMTestX.SetAnswerTimeout(0);
        rrSMTestX.ExpectReset();
#if 1
        rrSMTestX.ExpectSetString("State: topRequest: Enter");
        rrSMTestX.ExpectSetString("Trans: initTopRequest: Guard");
        rrSMTestX.ExpectSetString("Trans: initTopRequest: Action");
        rrSMTestX.ExpectSetString("State: request: Enter");
        rrSMTestX.ExpectSetString("Trans: initRequest: Guard");
        rrSMTestX.ExpectSetString("Trans: initRequest: Action");
        rrSMTestX.ExpectSetString("State: waiting: Enter");
#if 0 // variant with ACTION_ERROR on notConsumed in CheckForInternalMessage (removed due to concurrent SMF redesign)
        rrSMTestX.ExpectSetString("Trans: waiting2finalRequestActionError: Guard");
        rrSMTestX.ExpectSetString("State: waiting: Exit");
        rrSMTestX.ExpectSetString("Trans: waiting2finalRequestActionError: Action");
#else // variant with ANSWER_TIMEOUT and ReleaseWainting sending the awaited SUCCESS_REQUEST:
        rrSMTestX.ExpectSetString("Trans: REQUEST2REQUEST_ANSWERTIMEOUT: Guard");
        rrSMTestX.ExpectSetString("Trans: REQUEST2REQUEST_ANSWERTIMEOUT: Action");
        rrSMTestX.ExpectSetString("Trans: waiting2finalRequestSuccessRequest: Guard");
        rrSMTestX.ExpectSetString("State: waiting: Exit");
        rrSMTestX.ExpectSetString("Trans: waiting2finalRequestSuccessRequest: Action");
#endif
        rrSMTestX.ExpectSetString("State: finalRequest: Enter");
#else
        rrSMTest.ExpectSetString("on");
#endif
        char sendMsgString[128];
        snprintf(sendMsgString, sizeof(sendMsgString), "%s::%s", smf.GetSMName(), "START_PROCESSING");
        ret = rrSMTestX.DoEventAnswer(sendMsgString, "0,0", NULL);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);

        CPPUNIT_ASSERT(rrSMTestX.GetExpectErrorCount() == 0);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* check internal conditional transition in higher compound state */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: internalCondTest: Guard");
        smf.ExpectSetString("State: SEEK_FORWARD: Exit");
        smf.ExpectSetString("State: TUNING: Exit");
        smf.ExpectSetString("State: RADIO: Exit");
        smf.ExpectSetString("Trans: internalCondTest: Condition");
        smf.ExpectSetString("Trans: FALSE: Guard");
        smf.ExpectSetString("Trans: FALSE: Action");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: RADIO: Enter");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: TUNING: Enter");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: SEEK_FORWARD: Enter");
#else
        smf.ExpectSetString("on");
#endif
        smf.ExpectSetString("SEEK_FORWARD");
        ret = smf.SendEventByName("INTERNAL_COND_TEST", "");
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* test the special conditional which goes to inner and external state */
        /* test: to external */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: StartCondInternal: Guard");
        smf.ExpectSetString("State: SEEK_FORWARD: Exit");
        smf.ExpectSetString("State: TUNING: Exit");
        smf.ExpectSetString("Trans: StartCondInternal: Condition");
        smf.ExpectSetString("Trans: TRUE: Guard");
        smf.ExpectSetString("State: RADIO: Exit");
        smf.ExpectSetString("Trans: TRUE: Action");
        smf.ExpectSetString("State: CompoundToTestInternalTransitions: Enter");
#endif
        smf.ExpectSetString("CompoundToTestInternalTransitions");
        ret = smf.SendEventByName("START_COND", "1");
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* go back to RADIO */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: BACK_TO_RADIO: Guard");
        smf.ExpectSetString("State: CompoundToTestInternalTransitions: Exit");
        smf.ExpectSetString("Trans: BACK_TO_RADIO: Action");
        smf.ExpectSetString("State: RADIO: Enter");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: TUNING: Enter");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: SEEK_FORWARD: Enter");
#endif
        smf.ExpectSetString("SEEK_FORWARD");
        ret = smf.SendEventByName("BACK_TO_RADIO", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* test: to internal */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: StartCondInternal: Guard");
        smf.ExpectSetString("State: SEEK_FORWARD: Exit");
        smf.ExpectSetString("State: TUNING: Exit");
        smf.ExpectSetString("Trans: StartCondInternal: Condition");
        smf.ExpectSetString("Trans: FALSE: Guard");
        smf.ExpectSetString("Trans: FALSE: Action");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: TUNING: Enter");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: SEEK_FORWARD: Enter");
#endif
        smf.ExpectSetString("SEEK_FORWARD");
        ret = smf.SendEventByName("START_COND", "0");
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* simulate tuned event (from tuner) */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TO_PLAYING: Guard");
        smf.ExpectSetString("State: SEEK_FORWARD: Exit");
        smf.ExpectSetString("State: TUNING: Exit");
        smf.ExpectSetString("Trans: TO_PLAYING: Action");
        smf.ExpectSetString("State: RADIO_PLAYING: Enter");
#endif
        smf.ExpectSetString("RADIO_PLAYING");
        ret = smf.SendEventByName("TUNED_EVENT", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* @@@ start testing the concurrency state machine */

        /* go from RADIO_PLAYING to concurrent State1_A, current state is still RADIO_PLAYING afterwards */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: RadioPlaying2State1_A: Guard");
        smf.ExpectSetString("Trans: RadioPlaying2State1_A: Action");
        smf.ExpectSetString("State: ConcurrentFrame: Enter");
        smf.ExpectSetString("State: ConcurrentThreadA: Enter");
        smf.ExpectSetString("State: State1_A: Enter");
#endif
        smf.ExpectSetString("RADIO_PLAYING");
        ret = smf.SendEventByName("RADIOPLAYING_STATE1_A", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* check if a concurrent internal transition is processed in the concurrent state */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: CONTHREADA2CONCTHREADA: Guard");
        smf.ExpectSetString("Trans: CONTHREADA2CONCTHREADA: Action");
#endif
        smf.ExpectSetString("RADIO_PLAYING");
        ret = smf.SendEventByName("CONCURRENT_INTERNAL", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* check if a concurrent AND top internal transition is processed */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: THREADA2THREADABOTH: Guard");
        smf.ExpectSetString("Trans: THREADA2THREADABOTH: Action");
        smf.ExpectSetString("Trans: POWER2POWERBOTH: Guard");
        smf.ExpectSetString("Trans: POWER2POWERBOTH: Action");
#endif
        smf.ExpectSetString("RADIO_PLAYING");
        ret = smf.SendEventByName("POWER_AND_CONC", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* go back to RADIO_PLAYING from concurrent State1_A, an Enter of RADIO_PLAYING is not called,
         * because SM is already in RADIO_PLAYING */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: State1_A2Radioplaying: Guard");
        smf.ExpectSetString("Trans: State1_A2Radioplaying: Action");
#endif
        smf.ExpectSetString("RADIO_PLAYING");
        ret = smf.SendEventByName("BACKTO_RADIOPLAYING", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* go to ConcurrentThreadA which must lead by INIT to State1_A */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: Radioplaying2ConcurrenThreadA: Guard");
        smf.ExpectSetString("Trans: Radioplaying2ConcurrenThreadA: Action");
        smf.ExpectSetString("Trans: INIT_THREAD_A: Guard");
        smf.ExpectSetString("Trans: INIT_THREAD_A: Action");
#endif
        smf.ExpectSetString("RADIO_PLAYING");
        ret = smf.SendEventByName("RADIOPLAYING_CONC_A", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* go back to RADIO_PLAYING */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: State1_A2Radioplaying: Guard");
        smf.ExpectSetString("Trans: State1_A2Radioplaying: Action");
#endif
        smf.ExpectSetString("RADIO_PLAYING");
        ret = smf.SendEventByName("BACKTO_RADIOPLAYING", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* go to ConcurrentThreadA which must lead by history to State1_A */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: Radioplaying2ConcurrenThreadA: Guard");
        smf.ExpectSetString("Trans: Radioplaying2ConcurrenThreadA: Action");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
#endif
        smf.ExpectSetString("RADIO_PLAYING");
        ret = smf.SendEventByName("RADIOPLAYING_CONC_A", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* finish ConcurrentThreadA */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: State1_A2FinalState: Guard");
        smf.ExpectSetString("State: State1_A: Exit");
        smf.ExpectSetString("Trans: State1_A2FinalState: Action");
        smf.ExpectSetString("State: FinalStateThreadA: Enter");
#endif
        smf.ExpectSetString("RADIO_PLAYING");
        ret = smf.SendEventByName("DONE_STATE1_A", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* goto ConcurrentFrame (which is part of top state) must not probe CuncurrentThreadA which is finished now */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: Radioplaying2ConcurrentFrame: Guard");
        smf.ExpectSetString("State: RADIO_PLAYING: Exit");
        smf.ExpectSetString("State: RADIO: Exit");
        smf.ExpectSetString("Trans: Radioplaying2ConcurrentFrame: Action");
#endif
        smf.ExpectSetString("ConcurrentFrame");
        ret = smf.SendEventByName("RADIOPLAYING_CONCURRENTFRAME", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* go back to RADIO_PLAYING from ConcurrentFrame */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: ConcurrentFrame2RadioPlaying: Guard");
        smf.ExpectSetString("State: ConcurrentFrame: Exit");
        smf.ExpectSetString("Trans: ConcurrentFrame2RadioPlaying: Action");
        smf.ExpectSetString("State: RADIO: Enter");
        smf.ExpectSetString("State: RADIO_PLAYING: Enter");
#endif
        smf.ExpectSetString("RADIO_PLAYING");
        ret = smf.SendEventByName("BACKTO_RADIOPLAYING", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* end testing concurrency state machine */

        /* restart media player */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: SWITCH_PLAYER_ON: Guard");
        smf.ExpectSetString("State: RADIO_PLAYING: Exit");
        smf.ExpectSetString("State: RADIO: Exit");
        smf.ExpectSetString("Trans: SWITCH_PLAYER_ON: Action");
        smf.ExpectSetString("State: PLAYER: Enter");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: PLAYING: Enter");
        smf.ExpectSetString("RemoveMessageByName");
#endif
        smf.ExpectSetString("PLAYING");
        ret = smf.SendEventByName("PLAYER_ON_EVENT", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* restart radio */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: SWITCH_RADIO_ON: Guard");
        smf.ExpectSetString("State: PLAYING: Exit");
        smf.ExpectSetString("State: PLAYER: Exit");
        smf.ExpectSetString("Trans: SWITCH_RADIO_ON: Action");
        smf.ExpectSetString("State: RADIO: Enter");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: RADIO_PLAYING: Enter");
#endif
        smf.ExpectSetString("RADIO_PLAYING");
        ret = smf.SendEventByName("RADIO_ON_EVENT", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* restart media player */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: SWITCH_PLAYER_ON: Guard");
        smf.ExpectSetString("State: RADIO_PLAYING: Exit");
        smf.ExpectSetString("State: RADIO: Exit");
        smf.ExpectSetString("Trans: SWITCH_PLAYER_ON: Action");
        smf.ExpectSetString("State: PLAYER: Enter");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: PLAYING: Enter");
        smf.ExpectSetString("RemoveMessageByName");
#endif
        smf.ExpectSetString("PLAYING");
        ret = smf.SendEventByName("PLAYER_ON_EVENT", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* test a direct jump from inside compound to inside compound */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: JUMP_TUNING: Guard");
        smf.ExpectSetString("State: PLAYING: Exit");
        smf.ExpectSetString("State: PLAYER: Exit");
        smf.ExpectSetString("Trans: JUMP_TUNING: Action");
        smf.ExpectSetString("listID=2, songID=11, position=2500, myString=Hello World");
        smf.ExpectSetString("State: RADIO: Enter");
        smf.ExpectSetString("State: TUNING: Enter");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: SEEK_FORWARD: Enter");
#endif
        smf.ExpectSetString("SEEK_FORWARD");
        {
            char cParameter[1024];
            smf.ParameterJUMP_TUNING_EVENT(cParameter, sizeof(cParameter), 2, 11, (const char *)"Hello World", 2500);
            ret = smf.SendEvent(smf.JUMP_TUNING_EVENT, cParameter);
        }
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* test self internal transition */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TO_FORWARD: Guard");
        smf.ExpectSetString("Trans: TO_FORWARD: Action");
#endif
        smf.ExpectSetString("SEEK_FORWARD");
        ret = smf.SendEventByName("SEEK_FORW_EVENT", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* switch to backward seek and test error handler callback with positive result */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TO_SEEK_BACK: Guard");
        smf.ExpectSetString("State: SEEK_FORWARD: Exit");
        smf.ExpectSetString("Trans: TO_SEEK_BACK: Action");
        smf.ExpectSetString("ErrorHandler");
        smf.ExpectSetString("ErrorHandler");
        smf.ExpectSetString("ErrorHandler");
        smf.ExpectSetString("State: SEEK_BACKWARD: Enter");
#endif
        smf.ExpectSetString("SEEK_BACKWARD");
        smf.mErrorHandlerRetryCounter = 3;
        ret = smf.SendEventByName("SEEK_BACKW_EVENT", "-1"); // parameter -1 forces error handler call
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* check if the State is part of state radio */
        CPPUNIT_ASSERT(smf.IsInState((tInteger)mySMImpl::RADIO) == 1);

        /* test inner transition hierarchy */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TUNING2TUNINGINTERNALINNERTRANSITION: Guard");
        smf.ExpectSetString("Trans: TUNING2TUNINGINTERNALINNERTRANSITION: Action");
#endif
        smf.ExpectSetString("SEEK_BACKWARD");
        ret = smf.SendEventByName("INNER_TRANSITION", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* test inner transition hierarchy */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: RADIO2RADIOINTERNALINNERTRANSITIONRADIO: Guard");
        smf.ExpectSetString("Trans: RADIO2RADIOINTERNALINNERTRANSITIONRADIO: Action");
#endif
        smf.ExpectSetString("SEEK_BACKWARD");
        ret = smf.SendEventByName("INNER_TRANSITION_RADIO", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* test inner transition hierarchy */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("INNER_TRANSITION_PLAYER: notConsumed");
#endif
        smf.ExpectSetString("SEEK_BACKWARD");
        ret = smf.SendEventByName("INNER_TRANSITION_PLAYER", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* test fork */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TO_FORK_A: Guard");
        smf.ExpectSetString("State: SEEK_BACKWARD: Exit");
        smf.ExpectSetString("State: TUNING: Exit");
        smf.ExpectSetString("State: RADIO: Exit");
        smf.ExpectSetString("Trans: TO_FORK_A: Action");
        smf.ExpectSetString("State: fork: Enter");
        smf.ExpectSetString("Trans: TO_FORK_B: Guard");
        smf.ExpectSetString("State: fork: Exit");
        smf.ExpectSetString("Trans: TO_FORK_B: Action");
        smf.ExpectSetString("State: RADIO: Enter");
        smf.ExpectSetString("State: TUNING: Enter");
        smf.ExpectSetString("State: SEEK_BACKWARD: Enter");
#endif
        smf.ExpectSetString("SEEK_BACKWARD");
        ret = smf.SendEventByName("FORKTEST_EVENT", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* test external self transition */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TO_BACKW: Guard");
        smf.ExpectSetString("State: SEEK_BACKWARD: Exit");
        smf.ExpectSetString("Trans: TO_BACKW: Action");
        smf.ExpectSetString("State: SEEK_BACKWARD: Enter");
#endif
        smf.ExpectSetString("SEEK_BACKWARD");
        ret = smf.SendEventByName("SEEK_BACKW_EVENT", "0"); // the 0 as parameter is the return value of the user call back function
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* test the true condition */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TO_PLAYER_OR_OFF: Guard");
        smf.ExpectSetString("State: SEEK_BACKWARD: Exit");
        smf.ExpectSetString("State: TUNING: Exit");
        smf.ExpectSetString("State: RADIO: Exit");
        smf.ExpectSetString("Trans: TO_PLAYER_OR_OFF: Condition");
        smf.ExpectSetString("Trans: TRUE: Guard");
        smf.ExpectSetString("Trans: TRUE: Action");
        smf.ExpectSetString("State: PLAYER: Enter");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: PLAYING: Enter");
        smf.ExpectSetString("RemoveMessageByName");
#endif
        smf.ExpectSetString("PLAYING");
        ret = smf.SendEventByName("PLAYER_OR_OFF_EVENT", "1");
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* switch back to history of tuning in order to test the condition false */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: JUMP_TUNING: Guard");
        smf.ExpectSetString("State: PLAYING: Exit");
        smf.ExpectSetString("State: PLAYER: Exit");
        smf.ExpectSetString("Trans: JUMP_TUNING: Action");
        smf.ExpectSetString("listID=2, songID=11, position=2500, myString=Hello World");
        smf.ExpectSetString("State: RADIO: Enter");
        smf.ExpectSetString("State: TUNING: Enter");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: SEEK_BACKWARD: Enter");
#endif
        smf.ExpectSetString("SEEK_BACKWARD");
        {
            char cParameter[1024];
            smf.ParameterJUMP_TUNING_EVENT(cParameter, sizeof(cParameter), 2, 11, (const char *)"Hello World", 2500);
            ret = smf.SendEvent(smf.JUMP_TUNING_EVENT, cParameter);
        }
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* test the false condition */
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TO_PLAYER_OR_OFF: Guard");
        smf.ExpectSetString("State: SEEK_BACKWARD: Exit");
        smf.ExpectSetString("State: TUNING: Exit");
        smf.ExpectSetString("State: RADIO: Exit");
        smf.ExpectSetString("Trans: TO_PLAYER_OR_OFF: Condition");
        smf.ExpectSetString("Trans: FALSE: Guard");
        smf.ExpectSetString("Trans: FALSE: Action");
        smf.ExpectSetString("State: OFF: Enter");
#endif
        smf.ExpectSetString("OFF");
        ret = smf.SendEventByName("PLAYER_OR_OFF_EVENT", "0");
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        char sendMessage[128];

        /* test the event / answer functionality via the time out mechanism */
        class RequestResponseSMLoopbackTest : public RequestResponseSM
        {
        };

        RequestResponseSMLoopbackTest rrLoopbackSMTest;

        rrLoopbackSMTest.ExpectReset();
#if 1
        rrLoopbackSMTest.ExpectSetString("State: topRequest: Enter");
        rrLoopbackSMTest.ExpectSetString("Trans: initTopRequest: Guard");
        rrLoopbackSMTest.ExpectSetString("Trans: initTopRequest: Action");
        rrLoopbackSMTest.ExpectSetString("State: request: Enter");
        rrLoopbackSMTest.ExpectSetString("Trans: initRequest: Guard");
        rrLoopbackSMTest.ExpectSetString("Trans: initRequest: Action");
        rrLoopbackSMTest.ExpectSetString("State: waiting: Enter");
        rrLoopbackSMTest.ExpectSetString("Trans: WAITING2WAITINGINTERNALLOOPBACKMESSAGE: Guard");
        rrLoopbackSMTest.ExpectSetString("Trans: WAITING2WAITINGINTERNALLOOPBACKMESSAGE: Action");
        rrLoopbackSMTest.ExpectSetString("Trans: REQUEST2REQUEST_ANSWERTIMEOUT: Guard");
        rrLoopbackSMTest.ExpectSetString("Trans: REQUEST2REQUEST_ANSWERTIMEOUT: Action");
        rrLoopbackSMTest.ExpectSetString("Trans: waiting2finalRequestSuccessRequest: Guard");
        rrLoopbackSMTest.ExpectSetString("State: waiting: Exit");
        rrLoopbackSMTest.ExpectSetString("Trans: waiting2finalRequestSuccessRequest: Action");
        rrLoopbackSMTest.ExpectSetString("State: finalRequest: Enter");

#else
        rrLoopbackSMTest.ExpectSetString("on");
#endif

        smf.ExpectReset();
        smf.ExpectSetString("OFF");
        snprintf(sendMessage, sizeof(sendMessage), "%s::%s", rrLoopbackSMTest.GetSMNameFull(), "LOOP_BACK_MESSAGE");
        ret = rrLoopbackSMTest.DoEventAnswer(sendMessage, (char *)NULL);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        CPPUNIT_ASSERT(rrLoopbackSMTest.GetExpectErrorCount() == 0);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* test the event / answer functionality via the time out mechanism */
        class RequestResponseSMTest : public RequestResponseSM
        {
            int HandleInitRequest()
            {
                return 0;
            }

            int HandleSuccessRequest(const char *allParameters)
            {
                // the request/expect state machine has a general SUCCESS_REQUEST message which is not
                // specialized to a service sate machined be called. so all kind of parameters must
                // be processed by hand in this method.
            	Expect(allParameters);
                return 0;
            }

        };

        RequestResponseSMTest rrSMTest;

        /* test a normal request / answer of a remote state machine */
        rrSMTest.ExpectReset();
#if 1
        rrSMTest.ExpectSetString("State: topRequest: Enter");
        rrSMTest.ExpectSetString("Trans: initTopRequest: Guard");
        rrSMTest.ExpectSetString("Trans: initTopRequest: Action");
        rrSMTest.ExpectSetString("State: request: Enter");
        rrSMTest.ExpectSetString("Trans: initRequest: Guard");
        rrSMTest.ExpectSetString("Trans: initRequest: Action");
        rrSMTest.ExpectSetString("State: waiting: Enter");
        rrSMTest.ExpectSetString("Trans: waiting2finalRequestSuccessRequest: Guard");
        rrSMTest.ExpectSetString("State: waiting: Exit");
        rrSMTest.ExpectSetString("Trans: waiting2finalRequestSuccessRequest: Action");
        rrSMTest.ExpectSetString("2,1");
        rrSMTest.ExpectSetString("State: finalRequest: Enter");
#else
        rrSMTest.ExpectSetString("on");
#endif

        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: startProcessing: Guard");
        smf.ExpectSetString("State: OFF: Exit");
        smf.ExpectSetString("Trans: startProcessing: Action");
        smf.ExpectSetString("startProcessing: i1=1, i2=2");
        smf.ExpectSetString("State: processing: Enter");
        smf.ExpectSetString("Trans: processed: Guard");
        smf.ExpectSetString("State: processing: Exit");
        smf.ExpectSetString("Trans: processed: Action");
        smf.ExpectSetString("State: OFF: Enter");
#endif
        smf.ExpectSetString("OFF");
        snprintf(sendMessage, sizeof(sendMessage), "%s::%s", smf.GetSMName(), "START_PROCESSING");
        ret = rrSMTest.DoEventAnswer(sendMessage, "1,2");
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        CPPUNIT_ASSERT(rrSMTest.GetExpectErrorCount() == 0);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /*
         * test a normal request / answer of a remote state machine but it will not answer, it will fire a timeout
         */

        rrSMTest.ExpectReset();
#if 1
        rrSMTest.ExpectSetString("State: topRequest: Enter");
        rrSMTest.ExpectSetString("Trans: initTopRequest: Guard");
        rrSMTest.ExpectSetString("Trans: initTopRequest: Action");
        rrSMTest.ExpectSetString("State: request: Enter");
        rrSMTest.ExpectSetString("Trans: initRequest: Guard");
        rrSMTest.ExpectSetString("Trans: initRequest: Action");
        rrSMTest.ExpectSetString("State: waiting: Enter");
        rrSMTest.ExpectSetString("Trans: waiting2finalRequestSuccessRequest: Guard");
        rrSMTest.ExpectSetString("State: waiting: Exit");
        rrSMTest.ExpectSetString("Trans: waiting2finalRequestSuccessRequest: Action");
        rrSMTest.ExpectSetString("0,0"); // these parameters are the init value 0 because the ReleaseWaiting does not send any values
        rrSMTest.ExpectSetString("State: finalRequest: Enter");
#else
        rrSMTest.ExpectSetString("on");
#endif

        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: startProcessing: Guard");
        smf.ExpectSetString("State: OFF: Exit");
        smf.ExpectSetString("Trans: startProcessing: Action");
        smf.ExpectSetString("startProcessing: i1=4, i2=4");
        smf.ExpectSetString("State: processing: Enter");
        smf.ExpectSetString("Trans: ANSWERTIMEOUT: Guard");
        smf.ExpectSetString("Trans: ANSWERTIMEOUT: Action");
        smf.ExpectSetString("Trans: processed: Guard");
        smf.ExpectSetString("State: processing: Exit");
        smf.ExpectSetString("Trans: processed: Action");
        smf.ExpectSetString("State: OFF: Enter");
#endif
        smf.ExpectSetString("OFF");

        /* switch off answer timer for request state machine */
        //useless rrSMTest.SetAnswerTimeout(0);

        /* send message */
        snprintf(sendMessage, sizeof(sendMessage), "%s::%s", smf.GetSMName(), "START_PROCESSING");
        ret = rrSMTest.DoEventAnswer(sendMessage, "4,4", NULL, 0); // the both 4's inhibit the endProcessing in the reference state machine
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        CPPUNIT_ASSERT(rrSMTest.GetExpectErrorCount() == 0);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* test the event / answer functionality a second time */
        rrSMTest.ExpectReset();
#if 1
        rrSMTest.ExpectSetString("State: topRequest: Enter");
        rrSMTest.ExpectSetString("Trans: initTopRequest: Guard");
        rrSMTest.ExpectSetString("Trans: initTopRequest: Action");
        rrSMTest.ExpectSetString("State: request: Enter");
        rrSMTest.ExpectSetString("Trans: initRequest: Guard");
        rrSMTest.ExpectSetString("Trans: initRequest: Action");
        rrSMTest.ExpectSetString("State: waiting: Enter");
        rrSMTest.ExpectSetString("Trans: waiting2finalRequestSuccessRequest: Guard");
        rrSMTest.ExpectSetString("State: waiting: Exit");
        rrSMTest.ExpectSetString("Trans: waiting2finalRequestSuccessRequest: Action");
        rrSMTest.ExpectSetString("1,1");
        rrSMTest.ExpectSetString("State: finalRequest: Enter");
#else
        rrSMTest.ExpectSetString("on");
#endif

        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: startProcessing: Guard");
        smf.ExpectSetString("State: OFF: Exit");
        smf.ExpectSetString("Trans: startProcessing: Action");
        smf.ExpectSetString("startProcessing: i1=1, i2=1");
        smf.ExpectSetString("State: processing: Enter");
        smf.ExpectSetString("Trans: processed: Guard");
        smf.ExpectSetString("State: processing: Exit");
        smf.ExpectSetString("Trans: processed: Action");
        smf.ExpectSetString("State: OFF: Enter");
#endif
        smf.ExpectSetString("OFF");

        /* switch off all answer timers */
        smf.SetAnswerTimeout(0);
        // useless rrSMTest.SetAnswerTimeout(0);

        /* send the test  message */
        snprintf(sendMessage, sizeof(sendMessage), "%s::%s", smf.GetSMName(), "START_PROCESSING");
        ret = rrSMTest.DoEventAnswer(sendMessage, "1,1", NULL, 0);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        CPPUNIT_ASSERT(rrSMTest.GetExpectErrorCount() == 0);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        /* test the event / answer functionality a third time with two integer parameter passing */
        rrSMTest.ExpectReset();
#if 1
        rrSMTest.ExpectSetString("State: topRequest: Enter");
        rrSMTest.ExpectSetString("Trans: initTopRequest: Guard");
        rrSMTest.ExpectSetString("Trans: initTopRequest: Action");
        rrSMTest.ExpectSetString("State: request: Enter");
        rrSMTest.ExpectSetString("Trans: initRequest: Guard");
        rrSMTest.ExpectSetString("Trans: initRequest: Action");
        rrSMTest.ExpectSetString("State: waiting: Enter");
        rrSMTest.ExpectSetString("Trans: waiting2finalRequestSuccessRequest: Guard");
        rrSMTest.ExpectSetString("State: waiting: Exit");
        rrSMTest.ExpectSetString("Trans: waiting2finalRequestSuccessRequest: Action");
        rrSMTest.ExpectSetString("42,23");
        rrSMTest.ExpectSetString("State: finalRequest: Enter");
#else
        rrSMTest.ExpectSetString("on");
#endif

        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: startProcessing: Guard");
        smf.ExpectSetString("State: OFF: Exit");
        smf.ExpectSetString("Trans: startProcessing: Action");
        smf.ExpectSetString("startProcessing: i1=23, i2=42");
        smf.ExpectSetString("State: processing: Enter");
        smf.ExpectSetString("Trans: processed: Guard");
        smf.ExpectSetString("State: processing: Exit");
        smf.ExpectSetString("Trans: processed: Action");
        smf.ExpectSetString("State: OFF: Enter");
#endif
        smf.ExpectSetString("OFF");
        snprintf(sendMessage, sizeof(sendMessage), "%s::%s", smf.GetSMName(), "START_PROCESSING");
        char parameters[32];
        smf.ParameterSTART_PROCESSING(parameters, sizeof(parameters)-1, 23, 42);
        ret = rrSMTest.DoEventAnswer(sendMessage, parameters);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        CPPUNIT_ASSERT(rrSMTest.GetExpectErrorCount() == 0);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        ETG_TRACE_USR1(("          ***Special Queue-Test SMFTest::ReferenceStateMachineTest***"));

        //check processing order of internal and external MQ in StateMachine_Main()
		smf.ExpectReset();
#if 1
		smf.ExpectSetString("Trans: CATCH_OFF: Guard");
		smf.ExpectSetString("Trans: CATCH_OFF: Action");

		smf.ExpectSetString("Trans: startProcessing: Guard");
		smf.ExpectSetString("State: OFF: Exit");
		smf.ExpectSetString("Trans: startProcessing: Action");
		smf.ExpectSetString("startProcessing: i1=23, i2=42");
		smf.ExpectSetString("State: processing: Enter");

		smf.ExpectSetString("Trans: CATCH_OFF: Guard");
		smf.ExpectSetString("Trans: CATCH_OFF: Action");

		smf.ExpectSetString("Trans: CATCH_OFF: Guard");
		smf.ExpectSetString("Trans: CATCH_OFF: Action");

		smf.ExpectSetString("Trans: processed: Guard");
		smf.ExpectSetString("State: processing: Exit");
		smf.ExpectSetString("Trans: processed: Action");
		smf.ExpectSetString("State: OFF: Enter");

		smf.ExpectSetString("Trans: startProcessing: Guard");
		smf.ExpectSetString("State: OFF: Exit");
		smf.ExpectSetString("Trans: startProcessing: Action");
		smf.ExpectSetString("startProcessing: i1=12, i2=49");
		smf.ExpectSetString("State: processing: Enter");
		smf.ExpectSetString("Trans: processed: Guard");
		smf.ExpectSetString("State: processing: Exit");
		smf.ExpectSetString("Trans: processed: Action");
		smf.ExpectSetString("State: OFF: Enter");

		smf.ExpectSetString("PROCESSED: notConsumed");
		smf.ExpectSetString("PROCESSED: notConsumed");
#endif
		smf.ExpectSetString("OFF");

		//mixed message/answer events
		ret = smf.SendEventByName("OFF_EVENT", "");
		CPPUNIT_ASSERT(ret == 0);
		sleep(1);

		smf.ParameterSTART_PROCESSING(parameters, sizeof(parameters) - 1, 23, 42);
		ret = smf.SendEventAnswerByName("START_PROCESSING", "ReferenceSM::PROCESSED", parameters);
		CPPUNIT_ASSERT(ret == 0);
		ret = smf.SendEventByName("OFF_EVENT", "");
		CPPUNIT_ASSERT(ret == 0);

		smf.ParameterSTART_PROCESSING(parameters, sizeof(parameters) - 1, 12, 49);
		ret = smf.SendEventAnswerByName("START_PROCESSING", "ReferenceSM::PROCESSED", parameters);
		CPPUNIT_ASSERT(ret == 0);
		ret = smf.SendEventByName("OFF_EVENT", "");
		CPPUNIT_ASSERT(ret == 0);

		sleep(3);
		smf.Expect(smf.GetCurrentState());
		CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);


        // DELAY_EVENT: test delay on root level [GMMY17-13023]
        //1. send ROOT_DELAY in non RADIO state to call DelayEvent
        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TO_RADIO_ON: Guard");
        smf.ExpectSetString("State: OFF: Exit");
        smf.ExpectSetString("Trans: TO_RADIO_ON: Action");
        smf.ExpectSetString("State: RADIO: Enter");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: TUNING: Enter");
        smf.ExpectSetString("Trans: history: Guard");
        smf.ExpectSetString("Trans: history: Action");
        smf.ExpectSetString("State: SEEK_BACKWARD: Enter");
#endif
        smf.ExpectSetString("SEEK_BACKWARD");
        ret = smf.SendEventByName("RADIO_ON_EVENT", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        // test delay on root level
        //2. send ROOT_DELAYED in RADIO state

        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: ROOTDELAY: Guard");
        smf.ExpectSetString("Trans: ROOTDELAY: Action");
#endif
        smf.ExpectSetString("SEEK_BACKWARD");
        ret = smf.SendEventByName("ROOT_DELAYED", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        // test delay on root level
        //3. return to OFF state and consume delayed message

        smf.ExpectReset();
#if 1
        smf.ExpectSetString("Trans: TO_OFF: Guard");
        smf.ExpectSetString("State: SEEK_BACKWARD: Exit");
        smf.ExpectSetString("State: TUNING: Exit");
        smf.ExpectSetString("State: RADIO: Exit");
        smf.ExpectSetString("Trans: TO_OFF: Action");
        smf.ExpectSetString("State: OFF: Enter");
        smf.ExpectSetString("Trans: ROOTDELAYCONSUMEDOFF: Guard");
        smf.ExpectSetString("Trans: ROOTDELAYCONSUMEDOFF: Action");
#endif
        smf.ExpectSetString("OFF");                             //delayed message consumed by OFF::rootDelayedConsumed
        ret = smf.SendEventByName("OFF_EVENT", Parameter);
        CPPUNIT_ASSERT(ret == 0);
        sleep(1);
        smf.Expect(smf.GetCurrentState());
        CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);

        //END loop
    }

    CPPUNIT_ASSERT(smf.GetExpectErrorCount() == 0);
    if (smf.GetExpectErrorCount()) {
        // debug printf("!!! EXPECT Errors: %d\n", smf.GetExpectErrorCount());
    }

    /* de-register reference state machine to dispatcher */
    Dispatcher::GetInstance().DeRegister(&smf);

    /* reset the expect strings*/
    smf.ExpectReset();

    /* send reference state machine to final state to end the thread */
    ret = smf.SendEventByName("DONE", (char *)NULL);

    // wait until thread ended
    ASYNC_WAIT_START(60);

    printf("break\n");

}

