#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MediaPlayerTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif
#include "FunctionTracer.h"

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "MediaPlayerTest.h"
#include "LocalSPM.h"
#include "CppUnitDefinitions.h"

#include <sys/types.h>
#include <sys/stat.h>
#include "ThreadFactoryTest.h"

MediaPlayerTest::MediaPlayerTest()
{
}

void MediaPlayerTest::setUp()
{
    pthread_mutex_init(&mutex,NULL);
    pthread_cond_init(&condition,NULL);
    ticks.begin();
}

void MediaPlayerTest::tearDown()
{
    ticks.elapsed();
    pthread_mutex_destroy(&mutex);
    pthread_cond_destroy(&condition);
}

void MediaPlayerTest::testClearMediaPlayerData()
{
    ENTRY_TEST

    tResult result = LocalSPM::GetDataProvider().ClearMediaPlayerData();

    CPPUNIT_ASSERT(result == 0);
}

void MediaPlayerTest::ReadAndWriteStringFormat()
{
    ENTRY_TEST

    char string1[16] = {0};
    char string2[16] = {0};
    char string3[16] = {0};
    char string4[16] = {0};
    char string5[16] = {0};
    int i1234 = 0;
    int i5678 = 0;
    int i9876 = 0;

    strcpy(string1, "string1");
    strcpy(string2, "string2");
    strcpy(string3, "");
    strcpy(string4, "string4");
    strcpy(string5, "string5");
    i1234 = 1234;
    i5678 = 5678;
    i9876 = 9876;

    #define string_format "t"
    #define int_format "i"

    /* reprint all values to a new buffer */
    char outputString[128];

    SMF::Marshal(outputString, sizeof(outputString)-1,
            string_format
            string_format
            int_format
            int_format
            string_format
            string_format
            int_format
            string_format
            ,

            string1,
            string2,
            i1234,
            i9876,
            string3,
            string4,
            i5678,
            string5
            );

    /* re scan the printed string */
    string1[0] = 0;
    string2[0] = 0;
    string3[0] = 0;
    string4[0] = 0;
    string5[0] = 0;
    i1234 = 0;
    i5678 = 0;
    i9876 = 0;

    SMF::UnMarshal(outputString,

            string_format
            string_format
            int_format
            int_format
            string_format
            string_format
            int_format
            string_format
            ,

            string1,
            string2,
            &i1234,
            &i9876,
            string3,
            string4,
            &i5678,
            string5
            );
    CPPUNIT_ASSERT(!strcmp(string1, "string1"));
    CPPUNIT_ASSERT(!strcmp(string2, "string2"));
    CPPUNIT_ASSERT(i1234 == 1234);
    CPPUNIT_ASSERT(i9876 == 9876);
    CPPUNIT_ASSERT(!strcmp(string3, ""));
    CPPUNIT_ASSERT(!strcmp(string4, "string4"));
    CPPUNIT_ASSERT(i5678 == 5678);
    CPPUNIT_ASSERT(!strcmp(string5, "string5"));
}

void MediaPlayerTest::strncpy_rTest()
{
    ENTRY_TEST

    char dest[100];

    strncpy(dest, "0123456789", sizeof(dest));

    /* try to add 10 time 10 chars */
    for(int i=0; i<10; i++) {
        strncat_r(dest, "0123456789", sizeof(dest));
    }

    /* check the length now */
    CPPUNIT_ASSERT(strcmp(dest, "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678") == 0);
    CPPUNIT_ASSERT(strlen_r(dest) == 99);
}

bool TimerCallBack(timer_t /*timerID*/ , void* /*instance*/,const void *userData)
{
    ENTRY_INTERNAL

    Lock *waitLock = (Lock *)userData; //lint !e1773

    /* release the waiting test */
    waitLock->unlock();

    return 0;
}

void MediaPlayerTest::timerTest()
{
    ENTRY_TEST

    /* loop over the times */
    int timeoutMS;
    timer_t timerID;
    Lock waitLock;
    ElapsedTimer measTime;
    int milliSeconds;
    int epsMS = 40;
    int timerErrors = 0;
    Timer timer;

    waitLock.setNotReantrant();

    for(timeoutMS=100; timeoutMS<2100; timeoutMS+=200) {

        /* get the wait lock */
        waitLock.lock();

        /* measure the current time */
        measTime.Restart();

        /* start the timer */
        timer.StartTimer(OUT timerID, IN (long)timeoutMS, 0L, IN this, IN &TimerCallBack, IN (void *)&waitLock);

        /* wait for end of timer */
        waitLock.lock();
        waitLock.unlock();

        /* measure the elapsed time */
        milliSeconds = measTime.ElapsedMS();

        /* cancel the timer ( not needed I think) */
        timer.CancelTimer(IN timerID);

        /* print and check the result */
        ETG_TRACE_USR2(("timer: %d ms; meas=%d ms", timeoutMS, milliSeconds));
        if (abs(milliSeconds - timeoutMS) > epsMS) {
            timerErrors++;
        }
    }

    CPPUNIT_ASSERT(timerErrors == 0);
}

#if 0 // thoemel: only for testing new charsets

#include <glib.h>
#include <taginfo.h>
using namespace std;
using namespace TagInfo;

void checkUTF8(const char *prefix, unsigned char *utf8String)
{
    hexDump(stdout, prefix, (char *)utf8String, strlen_r((char *)utf8String));

    /* check 1 */
    gboolean bRes;
    bRes = g_utf8_validate((gchar *)utf8String , -1, NULL);
    if (bRes == true) {
        printf("%s: g_utf8_validate()=true\n", __PRETTY_FUNCTION__);
    } else {
        printf("%s: g_utf8_validate()=false\n", __PRETTY_FUNCTION__);
    }

    /* check 2 */
    gchar *newLatinString;
    gsize bytes_read;
    gsize bytes_written;
    GError *geError = NULL;
    newLatinString = g_locale_from_utf8 ((gchar *)utf8String, -1, &bytes_read, &bytes_written, &geError);
    if (newLatinString) {
        printf("%s: g_locale_from_utf8()=ok\n", __PRETTY_FUNCTION__);
        hexDump(stdout, (const char *)"g_locale_from_utf8", (char *)newLatinString, strlen_r((char *)newLatinString));
    } else {
        printf("%s: g_locale_from_utf8()=error: %s\n", __PRETTY_FUNCTION__, geError->message);
    }

    /* check 3 */
    gchar *newFileName;
    newFileName = g_filename_from_utf8 ((gchar *)utf8String, -1, &bytes_read, &bytes_written, &geError);
    if (newFileName) {
        printf("%s: g_filename_from_utf8()=ok\n", __PRETTY_FUNCTION__);
        hexDump(stdout, (const char *)"g_filename_from_utf8", (char *)newFileName, strlen_r((char *)newFileName));
    } else {
        printf("%s: g_filename_from_utf8()=error: %s\n", __PRETTY_FUNCTION__, geError->message);
    }

    /* check 4 */
    gchar *newUTF8String;
    newUTF8String = g_convert((gchar *)utf8String, -1, "UTF-8", "ISO-8859-14", NULL, NULL, &geError);
    if (newUTF8String) {
        printf("%s: g_convert()=ok\n", __PRETTY_FUNCTION__);
        hexDump(stdout, (const char *)"g_convert", (char *)newUTF8String, strlen_r((char *)newUTF8String));
    } else {
        printf("%s: g_convert()=error: %s\n", __PRETTY_FUNCTION__, geError->message);
    }
}
#endif

#if 0 // todo: remove these tests later on if not needed anymore
#include <glib.h>

void printIt(const char *test, const char *prefix, char *buffer)
{
    if (!buffer) return;
    fprintf(stdout, "%s: %s: ", test, prefix);
    char *ascii = (char *)malloc(strlen_r(buffer)+1);
    for(int i=0; i<strlen_r(buffer); i++) {
        fprintf(stdout, "%02x ", (unsigned char)buffer[i]);
        ascii[i] = buffer[i];
        ascii[i+1] = 0;
    }
    fprintf(stdout, " - %s\n", ascii);
    free(ascii);
}


#include <taginfo.h>
using namespace std;
using namespace TagInfo;

void MediaPlayerTest::UTF8ConvertTest()
{
    ENTRY_TEST
    tURL URL;
    string target;
    Info * info;

    /* working file */
#ifndef TARGET_BUILD // run in ubuntu
    strncpy_r(OUT URL, IN get_current_dir_name(), IN sizeof(URL));
    strncat_r(OUT URL, IN "/Customer/Simulation/CustomControl/China/", IN sizeof(URL));
#else // run in target with data stored in view
    strncpy_r(OUT URL, IN "/opt/bosch/test/data/GMP/China/", IN sizeof(URL));
#endif
    strncat_r(OUT URL, IN "滴答.mp3", IN sizeof(URL));

    target = URL;
    info = Info::create_tag_info(target);
    if(info && info->read()) {
        printf("%s: create_tag_info()=ok\n", __PRETTY_FUNCTION__);
        printf("%s: get_title().isLatin1()=%d\n", __PRETTY_FUNCTION__, info->get_title().isLatin1());
        printf("%s: get_title().isAscii()=%d\n", __PRETTY_FUNCTION__, info->get_title().isAscii());

        checkUTF8("3 Byte GBK(false)", (unsigned char *)info->get_title().toCString(false));
        checkUTF8("3 Byte GBK(true)", (unsigned char *)info->get_title().toCString(true));
    } else {
        printf("%s: create_tag_info()=error\n", __PRETTY_FUNCTION__);
    }

    /* not working file */
#ifndef TARGET_BUILD // run in ubuntu
    strncpy_r(OUT URL, IN get_current_dir_name(), IN sizeof(URL));
    strncat_r(OUT URL, IN "/Customer/Simulation/CustomControl/China/", IN sizeof(URL));
#else // run in target with data stored in view
    strncpy_r(OUT URL, IN "/opt/bosch/test/data/GMP/China/", IN sizeof(URL));
#endif
    strncat_r(OUT URL, IN "今天.mp3", IN sizeof(URL));

    target = URL;
    info = Info::create_tag_info(target);
    if(info && info->read()) {
        printf("%s: create_tag_info()=ok\n", __PRETTY_FUNCTION__);
        printf("%s: get_title().isLatin1()=%d\n", __PRETTY_FUNCTION__, info->get_title().isLatin1());
        printf("%s: get_title().isAscii()=%d\n", __PRETTY_FUNCTION__, info->get_title().isAscii());

        checkUTF8("unknown coding(false)", (unsigned char *)info->get_title().toCString(false));
        checkUTF8("unknown coding(true)", (unsigned char *)info->get_title().toCString(true));
    } else {
        printf("%s: create_tag_info()=error\n", __PRETTY_FUNCTION__);
    }

    fflush(stdout);
    printf("debug\n");
    return;
}
#endif

#if 0

// thoemel: only for testing new charsets:
void MediaPlayerTest::UTF8CyrillicTest()
{
    ENTRY_TEST
    tURL URL;
    string target;
    Info * info;

    /* working file */
#ifndef TARGET_BUILD // run in ubuntu
    strncpy_r(OUT URL, IN get_current_dir_name(), IN sizeof(URL));
    strncat_r(OUT URL, IN "/Customer/Simulation/CustomControl/Cyrillic/", IN sizeof(URL));
#else // run in target with data stored in view
    strncpy_r(OUT URL, IN "/opt/bosch/test/data/GMP/Cyrillic/", IN sizeof(URL));
#endif
    strncat_r(OUT URL, IN "Ң҂ҒҢҲӂӒӢӲ_hex.mp3", IN sizeof(URL));

    target = URL;
    info = Info::create_tag_info(target);
    if(info && info->read()) {
        printf("%s: create_tag_info()=ok\n", __PRETTY_FUNCTION__);
        printf("%s: get_title().isLatin1()=%d\n", __PRETTY_FUNCTION__, info->get_title().isLatin1());
        printf("%s: get_title().isAscii()=%d\n", __PRETTY_FUNCTION__, info->get_title().isAscii());

        checkUTF8("3 Byte Cyrillic(false)", (unsigned char *)info->get_title().toCString(false));
        checkUTF8("3 Byte Cyrillic(true)", (unsigned char *)info->get_title().toCString(true));
    } else {
        printf("%s: create_tag_info()=error\n", __PRETTY_FUNCTION__);
    }

    fflush(stdout);
    printf("debug\n");
    return;
}
#endif

void MediaPlayerTest::UTF8ConvertTest() // dummy
{
    ENTRY_TEST

    /* this tests checks the utf8 fake function used for player engine and remote state machine communications */

    char testString[128];

    /* teststring with umlauts */
    strcpy(testString, "Matthias Thömel");

    /* fake the UTF8 conversion */
    tURL fakedUTF8String;
    toUtf8Fake(OUT fakedUTF8String, IN sizeof(fakedUTF8String), IN testString);


    /* unfake it */
    char resultString[128];

    /* fake the UTF8 conversion */
    fromUtf8Fake(OUT resultString, IN sizeof(resultString), IN fakedUTF8String);

    /* compare the result */
    CPPUNIT_ASSERT(strcmp(resultString, testString) == 0);
}

void MediaPlayerTest::UTF8Validation()
{
    ENTRY_TEST

    unsigned char UTF8String[] = {
            0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,
            0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,
            0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,
            0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,
            0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,
            0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,
            0xe9,0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,0xe9,
            0xab,0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,0xa3,
            0x9e,0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,0x98,
            0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,
            0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,
            0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,
            0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,
            0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,
            0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,
            0xe9,0xab,0x98,0xe9,0xa3,0x9e,0xe9,0xab,0x98,0xe9,0xab,0x98,0xe9,0xa3,0x9e,0
    };

    /* validate test */
    int isValid = FastUTF8::isValid(UTF8String); // only first letter

    CPPUNIT_ASSERT(isValid == 1);
}

void MediaPlayerTest::ThreadFactoryKillTest()
{
    ENTRY_TEST
    //int res;

    /* write a test script to temp */
    const char *testScript = "/tmp/thread_factory-test.sh";
    FILE *fp = fopen(testScript, "w");
    CPPUNIT_ASSERT(fp != NULL);

    fprintf(fp, "#!/bin/bash\n");
    fprintf(fp, "while :\n");
    fprintf(fp, "do\n");
    fprintf(fp, "echo \"FactoryTestLoop\" > /tmp/thread_factory-test.log\n");
    fprintf(fp, "sleep 1\n");
    fprintf(fp, "done\n");
    fclose(fp);
    chmod(testScript, S_IRWXU | S_IRWXG | S_IRWXO);
    system("sync");

    /* create the ThreadFactory test instance */
    ThreadFactoryTest TFTest;

    /* get no of threads are running */
    int threadsRunningInit = LocalSPM::GetThreadFactory().GetThreadsRunning();
    ETG_TRACE_USR1(("threadsRunningInit=%d", threadsRunningInit));

    /* loop over test */
    for(int i=0; i<LocalSPM::GetThreadFactory().GetMaxThreads()+2; i++) {

        /* start system call with endless loop */
        //res =
        TFTest.StartEndlessSystemCall(IN "bash /tmp/thread_factory-test.sh");

        /* check how much threads are running */
        int threadsRunning1 = LocalSPM::GetThreadFactory().GetThreadsRunning();
        ETG_TRACE_USR1(("threadsRunning1=%d", threadsRunning1));
        CPPUNIT_ASSERT((threadsRunningInit+1) == threadsRunning1);

        /* wait a moment */
        sleep(1);

        /* end the endless system call loop */
        //res =
        TFTest.KillEndlessSystemCall();

        /* check how much threads are running */
        int threadsRunning2 = LocalSPM::GetThreadFactory().GetThreadsRunning();
        ETG_TRACE_USR1(("threadsRunning2=%d", threadsRunning2));
        CPPUNIT_ASSERT((threadsRunning2+1) == threadsRunning1);

        /* check if the thread is really removed */
        sleep(1);
        system("ps -ef | grep _factory > /tmp/factoryTest.ps");
        fp = fopen("/tmp/factoryTest.ps", "r");
        CPPUNIT_ASSERT(fp != NULL);
        if (fp) {
            char cbuf[1024];
            char *cerr;
            int found = 0;
            while(1) {
                cerr = fgets(cbuf, sizeof(cbuf), fp);
                if (cerr == NULL) break;
                // ETG_TRACE_USR1(("cbuf=%s", cbuf));
                if (strstr(cbuf, testScript)) {
                    found = 1;
                }
            }
            fclose(fp);
            CPPUNIT_ASSERT(found == 0);
        }

        /* check if the test script was running at all */
        fp = fopen("/tmp/thread_factory-test.log", "r");
        CPPUNIT_ASSERT(fp != NULL);
        if (fp) {
            char cbuf[1024];
            char *cerr;
            cerr = fgets(cbuf, sizeof(cbuf), fp);
            CPPUNIT_ASSERT(cerr != NULL);
            CPPUNIT_ASSERT(strstr(cbuf, "FactoryTestLoop") != NULL);
            fclose(fp);
            remove("/tmp/thread_factory-test.log");
        }
    }
}
