/*
 * MediaPlayerShutdownTest.h
 *
 *  Created on: Sep 6, 2012
 *      Author: tritonsu
 */

#ifndef MEDIAPLAYERSHUTDOWNTEST_H_
#define MEDIAPLAYERSHUTDOWNTEST_H_

#include <cppunit/extensions/HelperMacros.h>

#include "TimeTrace.h"
#include "TypeDefinitions.h"


class MediaPlayerShutdownTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( MediaPlayerShutdownTest );
    CPPUNIT_TEST( testSPMStateChangeOff );
    CPPUNIT_TEST_SUITE_END(); //lint !e578

public:

    /*SPM test cases*/
    void testSPMStateChangeOff();

    /*common to all test cases triggered before and after each test case */
    void setUp();
    void tearDown();

private:
    TimeTrace        ticks;         /**< time object to trace the time taken by testcases*/
    pthread_cond_t   condition ;    /**< wait condition used for asynchronous test cases */
    pthread_mutex_t  mutex ;        /**< lock used during asynchronous test case execution*/

};

#endif /* MEDIAPLAYERSHUTDOWNTEST_H_ */
