/*
 * MediaPlayerShutdownTest.cpp
 *
 *  Created on: Sep 6, 2012
 *      Author: tritonsu
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MediaPlayerShutdownTest.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include "LocalSPM.h"
#include "Dispatcher.h"
#include "MediaPlayerInterface.h"
#include "CppUnitDefinitions.h"
#include "FunctionTracer.h"

#include "MediaPlayerShutdownTest.h"

void MediaPlayerShutdownTest::setUp()
{
    pthread_mutex_init(&mutex,NULL);
    pthread_cond_init(&condition,NULL);
    ticks.begin();
}

void MediaPlayerShutdownTest::tearDown()
{
    ticks.elapsed();
    pthread_mutex_destroy(&mutex);
    pthread_cond_destroy(&condition);
}

void MediaPlayerShutdownTest::testSPMStateChangeOff()
{
    ENTRY_TEST

    /*Request Media player to enter Off state*/
    tResult result = MediaPlayerInterface::GetInstance().StateChangeOff();
    CPPUNIT_ASSERT(result == 0);

    /* ask for current state */
    tSPMState spmState = LocalSPM::GetInstance().GetSPMState();
    CPPUNIT_ASSERT(SPM_STATE_OFF == spmState);

#ifndef TARGET_BUILD

    /* Execute the given line (kill all player engine instances) as a shell command */
    system("killall PlayerEngine");
    system("killall bt-daemon");

    for(int sec=30; sec; sec--) {
        /* check if the database is still open */
        system("lsof | grep MyMedia > /tmp/openDB.txt");
        FILE *fp = fopen("/tmp/openDB.txt", "r");
        result = 1;
        if (fp) {
            tGeneralString oneLine;
            oneLine[0] = 0;
            fgets(oneLine, sizeof(oneLine), fp);
            int len = strlen_r(oneLine);
            if (len < 1) {
                result = MP_NO_ERROR;
                break;
            }
            sleep(1);
            static int i = 0;
            ETG_TRACE_USR1(("db still open:%d %s", i++, oneLine));
            fclose(fp);
        } else {
            result = MP_NO_ERROR;
        }
    }

    CPPUNIT_ASSERT(result == MP_NO_ERROR);
#endif
}
