/*
 * MediaPlayerStartupTest.cpp
 *
 *  Created on: Sep 6, 2012
 *      Author: tritonsu
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MediaPlayerSPMRegression.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include "MediaPlayerSPMRegression.h"
#include "LocalSPM.h"
#include "Dispatcher.h"
#include "MediaPlayerInterface.h"
#include "CppUnitDefinitions.h"

#include "FunctionTracer.h"

void MediaPlayerSPMRegression::setUp()
{
    ticks.begin();
}

void MediaPlayerSPMRegression::tearDown()
{
    ticks.elapsed();
}


void MediaPlayerSPMRegression::InitTestsuite()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* before running this the MediaPlayerStartupTest must be run:this creates the test database  */

    /* Enable auto register on DB trigger (were disabled during MediaPlayerStartupTest) */
    res = LocalSPM::GetIndexer().AutoRegisterOnDBTrigger(IN TS_ON);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = LocalSPM::GetAlbumArtIndexer().AutoRegisterOnDBTrigger(IN TS_ON);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = LocalSPM::GetCustomControl().AutoRegisterOnDBTrigger(IN TS_ON);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = LocalSPM::GetPlayerManager().AutoRegisterOnDBTrigger(IN TS_ON);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void MediaPlayerSPMRegression::EndTestsuite()
{
    ENTRY_TEST

    tResult res = MP_NO_ERROR;

    /* Disable auto register on DB trigger */
    res = LocalSPM::GetIndexer().AutoRegisterOnDBTrigger(IN TS_OFF);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = LocalSPM::GetAlbumArtIndexer().AutoRegisterOnDBTrigger(IN TS_OFF);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = LocalSPM::GetCustomControl().AutoRegisterOnDBTrigger(IN TS_OFF);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    res = LocalSPM::GetPlayerManager().AutoRegisterOnDBTrigger(IN TS_OFF);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* Recreate the test database */
    res = LocalSPM::GetDataProvider().RecreateTestDatabase(true, true);
    CPPUNIT_ASSERT(MP_NO_ERROR == res);
}

void MediaPlayerSPMRegression::SPMRegressionOn()
{
    ENTRY

    tResult res = MP_NO_ERROR;

    /* Request MediaPlayer to enter NORMAL state */
    res = MediaPlayerInterface::GetInstance().StateChangeNormal();
    CPPUNIT_ASSERT(MP_NO_ERROR == res);

    /* ask for current state */
    tSPMState SPMState = LocalSPM::GetInstance().GetSPMState();
    CPPUNIT_ASSERT(SPM_STATE_NORMAL == SPMState);

    /* now allocate the media player and start playing */
    tAudioOutputDevice audioOutputDevice;
    strncpy_r(OUT audioOutputDevice, USB_ALSA_DEVICENAME, IN sizeof(audioOutputDevice));
    res = MediaPlayerInterface::GetInstance().SendAllocate(IN audioOutputDevice);
    CPPUNIT_ASSERT(res == 0);

    tSourceActivity sourceActivity = SA_ON;
    res = MediaPlayerInterface::GetInstance().SendSourceActivity(IN sourceActivity);
    CPPUNIT_ASSERT(res == 0);

    /* re-attach the device */
    vector<tDeviceInfo> deviceInfos;
    tDeviceInfo deviceInfoItem;
    tUndervoltage undervoltage = false;

    InitDeviceInfo(INOUT deviceInfoItem);
    deviceInfoItem.deviceType = DTY_USB;
    deviceInfoItem.connectionState = CS_DISCONNECTED;
    deviceInfoItem.disconnectReason = DR_REMOVED;
    deviceInfoItem.connectionType = DCT_USB;

    sprintf(deviceInfoItem.serialNumber,  "987654321");
    sprintf(deviceInfoItem.UUID,          "987654321");
    sprintf(deviceInfoItem.deviceVersion, "1.0");
    sprintf(deviceInfoItem.deviceName,    "USB");
    sprintf(deviceInfoItem.accessoryName, "/dev/sda");

#ifndef TARGET_BUILD
    strncpy_r(OUT deviceInfoItem.mountPoint, IN get_current_dir_name(), IN sizeof(deviceInfoItem.mountPoint));
    strncat_r(OUT deviceInfoItem.mountPoint, IN "/Customer/Simulation/CustomControl/test/", IN sizeof(deviceInfoItem.mountPoint));
#else
    strncpy_r(OUT deviceInfoItem.mountPoint, IN "/opt/bosch/test/data/GMP/test/", IN sizeof(deviceInfoItem.mountPoint));
#endif

    // set device to removed
    deviceInfos.push_back(deviceInfoItem);//holds at position 0 last notification
    deviceInfos.push_back(deviceInfoItem);//holds at position 1..end all connected devices
    res = MediaPlayerInterface::GetInstance().DeviceChanged(IN undervoltage, IN deviceInfos);
    CPPUNIT_ASSERT(res == 0);

    // set device to connected
    deviceInfos.clear();
    deviceInfoItem.connectionState  = CS_ATTACHED;
    deviceInfos.push_back(deviceInfoItem);//holds at position 0 last notification
    deviceInfos.push_back(deviceInfoItem);//holds at position 1..end all connected devices
    res = MediaPlayerInterface::GetInstance().DeviceChanged(IN undervoltage, IN deviceInfos);
    CPPUNIT_ASSERT(res == 0);

    /* set device id */
    tDeviceID deviceID = DEVICE_ID_NOT_SET;
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB, true);
    CPPUNIT_ASSERT(res == 0);

    /* wait until indexer has finished */
    int retry;
    sleep(1);
    for(retry=60; retry; retry--) {
        tIndexingState indexingState;
        res = LocalSPM::GetDBManager().GetIndexingState(OUT indexingState, IN deviceID);
        CPPUNIT_ASSERT(MP_NO_ERROR == res);

        tDeviceInfo deviceInfo;
        res = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
        CPPUNIT_ASSERT(res == 0); // CID 18110 (#1 of 1): Unused value (UNUSED_VALUE))

        if (indexingState == IDS_COMPLETE && deviceInfo.connected) break;
        sleep(1);
    }
    CPPUNIT_ASSERT(retry != 0);

    tBool activeSource = true;
    res = MediaPlayerInterface::GetInstance().ActiveMediaDeviceSet(IN deviceID, IN activeSource);
    CPPUNIT_ASSERT(res == 0);

    res = WaitForPlaytimeUpdate(10);
    CPPUNIT_ASSERT(res == 0);
}

void MediaPlayerSPMRegression::SPMRegressionOff()
{
    ENTRY

    tResult res = MP_NO_ERROR;

    const char * smf_comp = "iPodControlSM";
    SMF * SMFInvalid = (SMF *)&LocalSPM::GetInstance().GetIPODControl();

    ETG_TRACE_USR1(("SMFInvalid=%s", SMFInvalid->GetSMNameFull()));
    CPPUNIT_ASSERT(!strncmp(SMFInvalid->GetSMNameFull(), smf_comp, strlen_r(smf_comp)));

    bool isValidSMRegistered = Dispatcher::GetInstance().IsRegistered(SMFInvalid);
    CPPUNIT_ASSERT(isValidSMRegistered == true);

    tSourceActivity sourceActivity = SA_OFF;
    res = MediaPlayerInterface::GetInstance().SendSourceActivity(IN sourceActivity);
    CPPUNIT_ASSERT(res == 0);

    /* Call SendDeAllocate */
    res = MediaPlayerInterface::GetInstance().SendDeAllocate();
    CPPUNIT_ASSERT(res == 0);

    //reproduction GMMY17-10976
    //LocalSPM::GetIPODControl().Test(123);

    /*Request Media player to enter Off state*/
    tResult result = MediaPlayerInterface::GetInstance().StateChangeOff();
    CPPUNIT_ASSERT(result == 0);

    //verify GMMY17-12069
    bool isInvalidSMRegistered = Dispatcher::GetInstance().IsRegistered(SMFInvalid);
    CPPUNIT_ASSERT(isInvalidSMRegistered == false);

    /* ask for current state */
    tSPMState SPMState = LocalSPM::GetInstance().GetSPMState();
    CPPUNIT_ASSERT(SPM_STATE_OFF == SPMState);
}

tResult MediaPlayerSPMRegression::WaitForPlaytimeUpdate(int sec)
{
    tResult res = MP_NO_ERROR;

    tPlaytime elapsedPlaytime;
    tPlaytime elapsedPlaytimeCompare;
    tPlaytime totalPlaytime;
    tObjectID objectID = OBJECT_ID_NONE;
    int secMax = sec;

    for(; sec; sec--) {

        /* get the current playtime */
        res = MediaPlayerInterface::GetInstance().GetPlaytime(OUT elapsedPlaytime, OUT totalPlaytime, OUT objectID);
        if (res != MP_NO_ERROR) break;

        if(secMax == sec) { // if first run, store only the current play time as compare value
            elapsedPlaytimeCompare = elapsedPlaytime;
        } else { // if additional run, check if playtime changes
            if ((elapsedPlaytimeCompare != elapsedPlaytime) && (elapsedPlaytime != 0)) {
                break;
            }
        }
        sleep(1);
    }
    if(0 == sec) {
        res = MP_ERR_MISC_TIMEOUT;
    }
    return res;
}

void MediaPlayerSPMRegression::SPMRegression()
{
    ENTRY_TEST

    tResult res;

    /* now allocate the media player and start playing */
    tAudioOutputDevice audioOutputDevice;
    strncpy_r(OUT audioOutputDevice, USB_ALSA_DEVICENAME, IN sizeof(audioOutputDevice));
    res = MediaPlayerInterface::GetInstance().SendAllocate(IN audioOutputDevice);
    CPPUNIT_ASSERT(res == 0);

    tSourceActivity sourceActivity = SA_ON;
    res = MediaPlayerInterface::GetInstance().SendSourceActivity(IN sourceActivity);
    CPPUNIT_ASSERT(res == 0);

    sleep(2); //Wait a little bit until IPC is initialized by first Allocate call

    /* read current PlayerManager state and store it in member variables */
    tAllocateState allocateState;
    tAudioOutputDevice audioOutputDevice2;
    int retry;
    for(retry=10; retry; retry--) {
        res = LocalSPM::GetPlayerManager().GetAllocateState(OUT allocateState, OUT audioOutputDevice2);
        CPPUNIT_ASSERT(MP_NO_ERROR == res);
        if (ALS_ACTIVE == allocateState) {
            break;
        }
        sleep(2);
    }
    CPPUNIT_ASSERT(retry != 0);
    CPPUNIT_ASSERT(strcmp(audioOutputDevice, audioOutputDevice2) == 0);

    vector<tDeviceInfo> deviceInfo;
    tDeviceInfo deviceInfoList;
    tDeviceID deviceID = DEVICE_ID_NOT_SET;

    /* set device id */
    res = LocalSPM::GetDBManager().GetDevice(OUT deviceID, DTY_USB);
    CPPUNIT_ASSERT(res == 0);

    tBool activeSource = true;
    res = MediaPlayerInterface::GetInstance().ActiveMediaDeviceSet(IN deviceID, IN activeSource);
    CPPUNIT_ASSERT(res == 0);

    sleep(1);

    res = MediaPlayerInterface::GetInstance().ActiveMediaDeviceGet(deviceInfoList);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(!strcmp(deviceInfoList.deviceName, "USB"));

    tListID listID;
    tListSize listSize;
    tNumberOfMediaObjects numberOfMediaObjects;
    tNumberOfPlayLists numberOfPlayLists;
    tNumberOfFolders numberOfFolders;
    tPath path;

    /* set the path */
    strncpy_r(OUT path, IN "/", IN sizeof(path));

    res = MediaPlayerInterface::GetInstance().CreateMediaPlayerFileList(
            OUT listID,
            OUT listSize,
            OUT numberOfMediaObjects,
            OUT numberOfPlayLists,
            OUT numberOfFolders,
            IN path,
            IN deviceID);
    CPPUNIT_ASSERT(res == 0);

    /* play item from the file list created in the previous testcase */
    listSize = 0;
    res= MediaPlayerInterface::GetInstance().PlayItemFromList(OUT listSize , IN listID, 5, 0);
    CPPUNIT_ASSERT(res == 0);

    res = WaitForPlaytimeUpdate(30);
    CPPUNIT_ASSERT(res == 0);

    tNowPlaying nowPlaying;
    res= MediaPlayerInterface::GetInstance().GetNowPlaying(OUT nowPlaying);
    CPPUNIT_ASSERT(res == 0);
    CPPUNIT_ASSERT(!strcmp("/Garbage-Garbage-02-Queer.MP3",nowPlaying.object.fileName));

    /* regression test loop */
    ElapsedTimer measTime;
    int iRuns;
    int seconds;
    enum {maxSleepTime = 3};
#if 1 // normal for release-tests
    enum {testTimeS = 30};
    enum {maxRuns = 500};
    enum {endless = 0};
#else
    enum {testTimeS = 1800}; // 30 mins
    enum {maxRuns = 9999999};
    enum {endless = 1}; // <<-- !!!
#endif
    int sec;
    for(iRuns=0; iRuns<maxRuns; iRuns++) {
        ETG_TRACE_USR1(("iRuns=%d", iRuns));

        /* do a off/on cycle */
endless:

        /* shut down media player */
        SPMRegressionOff();

        /* wait a random time */
        sec = (int)(((float)rand()*maxSleepTime)/RAND_MAX);
        ETG_TRACE_USR2(("sleep after Off=%d", sec));
        sleep(sec);

        /* startup media player */
        SPMRegressionOn();

        /* wait a random time */
        sec = (int)(((float)rand()*maxSleepTime)/RAND_MAX);
        sleep(sec);
        ETG_TRACE_USR2(("sleep after On=%d", sec));

        /* loop endless? */
        if (endless) {
            goto endless;
        }

        /* measure the duration up to now for the complete test */
        seconds = measTime.ElapsedS();

        /* break the loop after test time is over */
        if (seconds >= testTimeS) {
            break;
        }
    }
}
