/*
 * CppUnitDefinitions.h
 *
 *  Created on: Sep 6, 2012
 *      Author: tritonsu
 */

#ifndef CPPUNITDEFINITIONS_H_
#define CPPUNITDEFINITIONS_H_

#define ASYNC_WAIT_START(t_seconds) {\
        struct timespec timeToWait;\
        struct timeval now;\
        gettimeofday(&now,NULL); \
        timeToWait.tv_nsec = now.tv_usec * 1000;timeToWait.tv_sec = now.tv_sec+t_seconds;\
        pthread_mutex_lock(&mutex);\
        pthread_cond_timedwait(&condition,&mutex,&timeToWait);/* debug printf("wait for async test to execute\n");*/ \
        pthread_mutex_unlock(&mutex);\
}\

#define ASYNC_WAIT_RELEASE  pthread_cond_signal (&condition);

#ifdef TARGET_BUILD
//extra solution because ETG preprocessing does not work if placed here - hence no extra trace output if tests run at target. since bug analysis for tests is done on ubuntu PC this is ok
#define GMPTEST_EXPECT_EQ(var1,var2)   CPPUNIT_ASSERT(var1 == var2);
#define GMPTEST_EXPECT_NE(var1,var2)   CPPUNIT_ASSERT(var1 != var2);
#define GMPTEST_EXPECT_GT(var1,var2)   CPPUNIT_ASSERT(var1 >  var2);
#define GMPTEST_EXPECT_GE(var1,var2)   CPPUNIT_ASSERT(var1 >= var2);
#define GMPTEST_EXPECT_LT(var1,var2)   CPPUNIT_ASSERT(var1 <  var2);
#define GMPTEST_EXPECT_LE(var1,var2)   CPPUNIT_ASSERT(var1 <= var2);
#else
//usable instead of CPPUNIT_ASSERT to get output within traces about failure
#define GMP_HYPHENS ETG_TRACE_FATAL(("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
#define GMPTEST_EXPECT_EQ(var1,var2)    if(var1 == var2){;}else{GMP_HYPHENS;ETG_TRACE_FATAL(("TEST FAILED: (EXPECT_EQ: var1==var2) %d == %d [Line:%d Fct:%s]",var1,var2,__LINE__, __PRETTY_FUNCTION__ ));GMP_HYPHENS;CPPUNIT_ASSERT(var1 == var2);}
#define GMPTEST_EXPECT_NE(var1,var2)    if(var1 != var2){;}else{GMP_HYPHENS;ETG_TRACE_FATAL(("TEST FAILED: (EXPECT_NE: var1!=var2) %d != %d [Line:%d Fct:%s]",var1,var2,__LINE__, __PRETTY_FUNCTION__ ));GMP_HYPHENS;CPPUNIT_ASSERT(var1 != var2);}   
#define GMPTEST_EXPECT_GT(var1,var2)    if(var1 >  var2){;}else{GMP_HYPHENS;ETG_TRACE_FATAL(("TEST FAILED: (EXPECT_GT: var1>var2)  %d > %d  [Line:%d Fct:%s]",var1,var2,__LINE__, __PRETTY_FUNCTION__ ));GMP_HYPHENS;CPPUNIT_ASSERT(var1 >  var2);}   
#define GMPTEST_EXPECT_GE(var1,var2)    if(var1 >= var2){;}else{GMP_HYPHENS;ETG_TRACE_FATAL(("TEST FAILED: (EXPECT_GE: var1>=var2) %d >= %d [Line:%d Fct:%s]",var1,var2,__LINE__, __PRETTY_FUNCTION__ ));GMP_HYPHENS;CPPUNIT_ASSERT(var1 >= var2);} 
#define GMPTEST_EXPECT_LT(var1,var2)    if(var1 <  var2){;}else{GMP_HYPHENS;ETG_TRACE_FATAL(("TEST FAILED: (EXPECT_LT: var1<var2)  %d < %d  [Line:%d Fct:%s]",var1,var2,__LINE__, __PRETTY_FUNCTION__ ));GMP_HYPHENS;CPPUNIT_ASSERT(var1 <  var2);}
#define GMPTEST_EXPECT_LE(var1,var2)    if(var1 <= var2){;}else{GMP_HYPHENS;ETG_TRACE_FATAL(("TEST FAILED: (EXPECT_LE: var1<=var2) %d <= %d [Line:%d Fct:%s]",var1,var2,__LINE__, __PRETTY_FUNCTION__ ));GMP_HYPHENS;CPPUNIT_ASSERT(var1 <= var2);}
/*tbd.:
#define GMPTEST_EXPECT_TRUE(condition)  
#define GMPTEST_EXPECT_FALSE(condition) 
*/
#endif

#endif /* CPPUNITDEFINITIONS_H_ */
