#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#ifdef TARGET_BUILD
#include "trcGenProj/Header/SimulationOutputWrapper.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TEST
#endif
#endif

#include "SimulationOutputWrapper.h"
#include "LocalSPM.h"
#include "FunctionTracer.h"
#include "VarTrace.h"
#include <unistd.h>  // necessary for get_current_dir_name

#define NAME_OF_MSGQ_FUNCTIONWRITES_TO "SimOutQ"

static pthread_t thread2 = 0;

SimulationOutputWrapper::SimulationOutputWrapper(tComponentID componentId) :
        OutputWrapper(componentId),
        fMsgQueuepointer(NULL), //CID 17947 (#1 of 1): Uninitialized pointer field (UNINIT_CTOR)
        mMessageQueue("SimulationOutoutWrapperQueue"),
        m_ntestId(0),
        m_nGetAlbuArtinfoAnswer(0)
{
            m_MsgSendNum = 0;
            m_MsgReceiveNum = 0;
            m_CountMsges = 0;
            m_pMsgQueue = NULL;
}

SimulationOutputWrapper::~SimulationOutputWrapper()
{
}

void SimulationOutputWrapper::sendMsgQueue(const char *EventString, int eventId, cTestData *testData)
{
    ENTRY

    /* is the receiver thread started? */
    if (0 == thread2)
    {
        /* if not, start it */
        pthread_create(&thread2, NULL, fEvent, this);
        sleep(1);
    }

    /* create the send buffer */
    tMessage *message = (tMessage *)mMessageQueue.CreateMessageBuffer(sizeof(tMessage));

    /* fill the message */
    memset(message, 0, sizeof(tMessage));
    strncpy_r(message->EventName, EventString, sizeof(message->EventName));
    message->type = eventId;
    message->testData = *testData;
    ETG_TRACE_USR4(("EventName=%s ", message->EventName));

    /* send it */
    mMessageQueue.Push(message, sizeof(tMessage), 0);

#if OLD_IMPL
    /* destroy the message buffer */
    mMessageQueue.DropMessage(message);
#endif
}

void* SimulationOutputWrapper::fEvent(void *oSimulatorPtr)
{
    ENTRY

    /* get the simulation output wrapper pointer */
    SimulationOutputWrapper *simulationOutputWrapper = (SimulationOutputWrapper *)oSimulatorPtr;

    /* endless */
    while(1) {

        /* wait for data */
        size_t messageSize;
        tMessage *message;
        message = (tMessage *)simulationOutputWrapper->mMessageQueue.WaitForMessage(&messageSize, 0); // endless

        /* got message? */
        if (message && messageSize == sizeof(tMessage)) {

            /* dispatch it to listener */
            EventDispatcher::poGetEventDispatcher()->u8EmitEvent(message->type, message->EventName,
                    (void *) &message->testData);

            /* delete the memory for the message */
            simulationOutputWrapper->mMessageQueue.DropMessage(message);

        } else {
            ETG_TRACE_ERR(("wrong message received"));
        }
    }

    return 0;
}

int SimulationOutputWrapper::test()
{
    ENTRY
    EventDispatcher::poGetEventDispatcher()->u8EmitEvent(m_ntestId,(void *)"TestData",NULL); //lint !e1773
    return 0;
}

void SimulationOutputWrapper::settestId(guint32 u32nId)
{
    ENTRY
    m_ntestId = u32nId;
}

tResult SimulationOutputWrapper::RequestAVActivation(const tSourceNr /*sourceNr*/, const tLogicalAVChannel /*logicalAVChannel*/,const tSource /*source*/, const tDeviceID /*deviceID*/)
{
    ENTRY

    tResult res;

    tAudioOutputDevice audioOutputDevice;
    strncpy(audioOutputDevice, "AdevInfo2Out", sizeof(audioOutputDevice)-1);
    res = LocalSPM::GetPlayerManager().SendAllocate(IN audioOutputDevice);
    if(res) return res;

    tSourceActivity sourceActivity = SA_ON;
    res = LocalSPM::GetPlayerManager().SendSourceActivity(IN sourceActivity);
    if(res) return res;

    return MP_NO_ERROR;
}

tResult SimulationOutputWrapper::UpdateDeviceConnection(const tDeviceID deviceID, const tConnectionReason connectionReason)
{
    ENTRY
    VARTRACE(deviceID);
    VARTRACE(connectionReason);

    tResult result;
    tDeviceInfo deviceInfo;

    result = LocalSPM::GetDBManager().GetDeviceInfo(OUT deviceInfo, IN deviceID);
    ETG_TRACE_USR1(("UpdateDeviceConnection: Connection reason: %d", connectionReason));

    if (MP_NO_ERROR == result)
    {
        VARTRACE(deviceInfo.connectionState);
        VARTRACE(deviceInfo.numberOfAudioFiles);
        VARTRACE(deviceInfo.numberOfVideoFiles);

        // if state is connected the audio manager is informed about device state
        if (deviceInfo.connectionState == CS_CONNECTED)
        {
            if(CR_ERROR == connectionReason)
            {
                if((deviceInfo.deviceID != DEVICE_ID_NOT_SET) && strlen(deviceInfo.mountPoint))
                {
                    if(IsMassStorageDevice(IN deviceInfo.deviceType))
                    {
                        /* Check if read request on root (mountPoint) is possible */
                        if(false == exists_directory(deviceInfo.mountPoint))
                        {
                            VARTRACE(deviceInfo.connectionCount);
                            result = LocalSPM::GetDBManager().MarkDeviceCommunicationError(IN deviceInfo.deviceID,IN deviceInfo.connectionCount,IN deviceInfo.deviceType);
                            if(MP_NO_ERROR == result)
                            {
                                result = LocalSPM::GetDBManager().DisconnectDeviceOnCommunicationError(IN deviceInfo.deviceID /*,IN connectionCount */);
                                if(result)
                                {
                                    ETG_TRACE_ERR(("Error disconnecting Device with Communication Error %d/%s", result, errorString(result)));
                                    result = MP_NO_ERROR;
                                }
                                else
                                {
                                    ETG_TRACE_ERR(("Disconnectied Device with Communication Error - deviceid = %d",deviceInfo.deviceID));
                                }
                            }
                            else
                            {
                                ETG_TRACE_ERR(("UpdateDeviceConnection:Error Marking DEVICE_COMMUNICATION_ERROR Error=%d/%s", result, errorString(result)));
                                result = MP_NO_ERROR;
                            }

                            ETG_TRACE_USR4(("UpdateDeviceConnection:device Not Accessible.Announcing not-playable."));
                        }
                        else
                        {
                            ETG_TRACE_USR4(("UpdateDeviceConnection:Mountpoint is accessible!.Discarded ARL_EN_REASON_ERROR"));
                        }
                    }
                    else
                    {
                        ETG_TRACE_FATAL(("Missing Handling of ARL_EN_REASON_ERROR for NON-MassStorage Devices"));
                    }
                }

            }
            else
            {
                ETG_TRACE_USR4(("UpdateDeviceConnection:do Nothing"));
            }
        }
    }
    return 0;
}

tResult SimulationOutputWrapper::RequestConnectedDevices()
{
    ENTRY

    tResult res;

    tDeviceInfo deviceInfoItem;
    vector<tDeviceInfo> deviceInfos;
    sleep(1);

    /*-------Add 1st device (USB:"/Customer/Simulation/CustomControl/test") -------------*/
    InitDeviceInfo(INOUT deviceInfoItem);
    deviceInfoItem.deviceType = DTY_USB;
    deviceInfoItem.connectionState = CS_ATTACHED;
    deviceInfoItem.disconnectReason = DR_REMOVED;
    sprintf(deviceInfoItem.serialNumber, "987654321");
    sprintf(deviceInfoItem.UUID, "987654321");
    sprintf(deviceInfoItem.deviceVersion, "1.0");
    sprintf(deviceInfoItem.deviceName, "USB");
    sprintf(deviceInfoItem.accessoryName, "/dev/sda");
    strncpy_r(OUT deviceInfoItem.mountPoint, IN get_current_dir_name(), IN sizeof(deviceInfoItem.mountPoint)); //lint !e1055 !e746 !e64
    strncat_r(OUT deviceInfoItem.mountPoint, IN "/Customer/Simulation/CustomControl/test", IN sizeof(deviceInfoItem.mountPoint));
    deviceInfoItem.partitionNumber      = 1;
    deviceInfoItem.fileSystemType = FSTY_FAT;
    deviceInfoItem.connectionType = DCT_USB;
    deviceInfoItem.productID = 5767;
    deviceInfoItem.totalSize = 33554432;
    deviceInfoItem.freeSize = 20971520;

    deviceInfos.push_back(deviceInfoItem);


    /*-------Add 2nd device (IPOD) -------------*/
/*
    InitDeviceInfo(INOUT deviceInfoItem);
    deviceInfoItem.deviceType = DTY_IPOD;
    deviceInfoItem.connectionState = CS_ATTACHED;
    deviceInfoItem.disconnectReason = DR_REMOVED;
    sprintf(deviceInfoItem.serialNumber, "987654321-1");
    sprintf(deviceInfoItem.UUID, "987654321-1");
    sprintf(deviceInfoItem.deviceVersion, "1.0");
    sprintf(deviceInfoItem.deviceName, "IPOD");
    sprintf(deviceInfoItem.accessoryName, "hw:3,0");
    sprintf(deviceInfoItem.mountPoint, "/dev/usb/hiddev0");
    deviceInfoItem.partitionNumber = 1;
    deviceInfoItem.fileSystemType = FSTY_HFS;
    deviceInfoItem.connectionType = DCT_USB;
    deviceInfoItem.productID = 4711 ;

    deviceInfos.push_back(deviceInfoItem);
*/

    //This adds the devices to the DB and triggers Indexing
    res = LocalSPM::GetDBManager().DeviceChanged(IN deviceInfos);

    return res;
}

tResult SimulationOutputWrapper::UpdatePlaytime()
{
    ENTRY
    cTestData ocTestData;
    ocTestData.eMSGTYPE = EV_UPDATEPLAYTIME;
    sendMsgQueue((const char *)"UpdatePlaytime",EV_UPDATEPLAYTIME, &ocTestData);
    return 0;
}

tResult SimulationOutputWrapper::UpdatePlaybackState()
{
    ENTRY
    cTestData ocTestData;
    ocTestData.eMSGTYPE = EV_UPDATEPLAYBACKSTATE;
    sendMsgQueue((const char *)"UpdatePlaybackState",EV_UPDATEPLAYBACKSTATE, &ocTestData);
    return 0;
}

tResult SimulationOutputWrapper::UpdateNowPlaying()
{
    ENTRY
    cTestData ocTestData;
    ocTestData.eMSGTYPE = EV_UPDATENOWPLAYING;
    sendMsgQueue((const char *)"UpdateNowPlaying",EV_UPDATENOWPLAYING, &ocTestData);
    return 0;
}

tResult SimulationOutputWrapper::SendGetMediaObjectAlbumArtAnswer(tImageData imageData, tImageSize imageSize, tUserContext userContext)
{
    ENTRY
    ETG_TRACE_USR1(("SendGetMediaObjectAlbumArtInfoAnswer - size : %d, UserContext.FuncitonID : %d ", imageSize, userContext.functionID));
    cTestData ocTestData;
    ocTestData.imageData = imageData;
    ocTestData.size = imageSize;
    ocTestData.eMSGTYPE = EV_GETMEDIAOBJECTALBUMARTANSWER;
    ocTestData.userContext = userContext;
    sendMsgQueue((const char *)"SendGetMediaObjectAlbumArtAnswer", EV_GETMEDIAOBJECTALBUMARTANSWER, &ocTestData );
    ETG_TRACE_USR1(("SendGetMediaObjectAlbumArtAnswer return "));
    return 0;
}

tResult SimulationOutputWrapper::SendGetMediaObjectAlbumArtError(tErrorCode /*errorCode*/, tUserContext /*userContext*/)
{
    ENTRY
    ETG_TRACE_USR1(("Simulation Output Wrapper SendGetMediaObjectAlbumArt Error "));
    return 0;
}

tResult SimulationOutputWrapper::SendGetMediaObjectAlbumArtInfoAnswer(tMimeType mimeType, tSize size, tUserContext userContext)
{
    ENTRY
        ETG_TRACE_USR1(("SendGetMediaObjectAlbumArtInfoAnswer - mimeType : %d, size : %d, UserContext.FuncitonID : %d ",mimeType, size, userContext.functionID));
        cTestData ocTestData;
        ocTestData.mimeType = mimeType;
        ocTestData.eMSGTYPE = EV_GETMEDIAOBJECTALBUMINFOANSWER;
        ocTestData.size = size;
        ocTestData.userContext = userContext;
        sendMsgQueue((const char *)"SendGetMediaObjectAlbumArtInfoAnswer", EV_GETMEDIAOBJECTALBUMINFOANSWER, &ocTestData);
        ETG_TRACE_USR1(("SendGetMediaObjectAlbumArtInfoAnswer return "));
        return 0;
}

tResult SimulationOutputWrapper::SendGetMediaObjectAlbumArtInfoError(tErrorCode /*errorCode*/, tUserContext /*userContext*/)
{
    ENTRY
        ETG_TRACE_USR1(("New Simulator SendGetMediaObjectAlbumArtInfo Error "));
        return 0;
}


//-->Roadmap 16014 'full text search'
void SimulationOutputWrapper::helperPackMethod_Send_onCreateMediaPlayerListSearchString(IN tenFctType eFctType, IN tListID listID, IN tListSize listSize, IN tDeviceID deviceID)
{
    ENTRY

    VARTRACE(eFctType)
    VARTRACE(listID)
    VARTRACE(listSize)
    VARTRACE(deviceID)

    if(testMsqQIsInUse())
    {
        int len, offset;
        int lenOfBuf = sizeof(tenFctType) + sizeof(tListID) + sizeof(tListSize) + sizeof(tDeviceID);
        char *pMsg = new char[lenOfBuf];


        if(pMsg)
        {
           //pack payload into buffer
            offset = 0;
            len = sizeof(tenFctType);
            memcpy((void*)(pMsg+offset), (void*)&eFctType, len);

            offset += len;
            len = sizeof(tListID);
            memcpy((void*)(pMsg+offset), (void*)&listID, len);

            offset += len;
            len = sizeof(tListSize);
            memcpy((void*)(pMsg+offset), (void*)&listSize, len);

            offset += len;
            len = sizeof(tDeviceID);
            memcpy((void*)(pMsg+offset), (void*)&deviceID, len);


            //send payload to queue
            if(SimulationOutputWrapper::ERROR == testMsgQSend(pMsg,lenOfBuf))
            {
                switch(eFctType)
                {
                    case eSend_onCreateMediaPlayerListSearchString_MethodReturnFirst:
                        ETG_TRACE_FATAL(("[ERROR] in Send_onCreateMediaPlayerListSearchString_MethodReturnFirst"));
                        break;
                    case eSend_onCreateMediaPlayerListSearchString_MethodReturnMiddle:
                        ETG_TRACE_FATAL(("[ERROR] in Send_onCreateMediaPlayerListSearchString_MethodReturnMiddle"));
                        break;
                    case eSend_onCreateMediaPlayerListSearchString_MethodReturnLast:
                        ETG_TRACE_FATAL(("[ERROR] in Send_onCreateMediaPlayerListSearchString_MethodReturnLast"));
                        break;
                    case eSend_onCreateMediaPlayerListSearchString_MethodReturnAbort:
                        ETG_TRACE_FATAL(("[ERROR] in Send_onCreateMediaPlayerListSearchString_MethodReturnAbort"));
                        break;
                     default:
                        ETG_TRACE_FATAL(("[ERROR] in Send_onCreateMediaPlayerListSearchString_MethodReturn... unexpected eFctType: %d",eFctType));
                        break;

                }
            }
            else
            {
                ETG_TRACE_USR4(("[INFO] function has written to queue"));
            }

            //delete buffer
            delete pMsg;
        }
        else
        {
            ETG_TRACE_USR4(("[INFO] function not writing to queue"));
        }
    }

 }




tResult SimulationOutputWrapper::Send_onCreateMediaPlayerListSearchString_MethodReturnFirst(IN tListID listIDParent, IN tListID listID, IN tListSize listSize, IN tDeviceID deviceID)
{
    ENTRY

    helperPackMethod_Send_onCreateMediaPlayerListSearchString(IN eSend_onCreateMediaPlayerListSearchString_MethodReturnFirst,
                                                              IN listID,
                                                              IN listSize,
                                                              IN deviceID);

    return 0;
}

tResult SimulationOutputWrapper::Send_onCreateMediaPlayerListSearchString_MethodReturnMiddle(IN tListID listIDParent,IN tListID listID, IN tListSize listSize, IN tDeviceID deviceID)
{
    ENTRY

    helperPackMethod_Send_onCreateMediaPlayerListSearchString(IN eSend_onCreateMediaPlayerListSearchString_MethodReturnMiddle,
                                                              IN listID,
                                                              IN listSize,
                                                              IN deviceID);

    return 0;

}

tResult SimulationOutputWrapper::Send_onCreateMediaPlayerListSearchString_MethodReturnLast(IN tListID listIDParent,IN tListID listID, IN tListSize listSize, IN tDeviceID deviceID)
{
    ENTRY

    helperPackMethod_Send_onCreateMediaPlayerListSearchString(IN eSend_onCreateMediaPlayerListSearchString_MethodReturnLast,
                                                              IN listID,
                                                              IN listSize,
                                                              IN deviceID);

    return 0;

}

tResult SimulationOutputWrapper::Send_onCreateMediaPlayerListSearchString_MethodReturnAbort(IN tListID listIDParent,IN tListID listID, IN tListSize listSize, IN tDeviceID deviceID)
{
    ENTRY


    helperPackMethod_Send_onCreateMediaPlayerListSearchString(IN eSend_onCreateMediaPlayerListSearchString_MethodReturnAbort,
                                                              IN listID,
                                                              IN listSize,
                                                              IN deviceID);

    return 0;

}



int  SimulationOutputWrapper::testMsgQSend(IN const void *pMsg, IN int iLength) //e.g. SimulationOutwrapper: function sends its parameter to test queue
{
    ENTRY

    ETG_TRACE_USR4(("Entering testMsgQSend"));
    int iRet = SimulationOutputWrapper::ERROR;

    if(m_pMsgQueue)
    {

        //Bugfix: Without this  SegmentationFault happens using framework_so
        void* Sendbuf = m_pMsgQueue->CreateMessageBuffer(iLength);
        memcpy(Sendbuf,pMsg,iLength);

        lockSimQ.lock(); //lock to care for members

        if(-1 != m_pMsgQueue->Push(Sendbuf, iLength, /*iPrio=*/0))
        {
            m_CountMsges++;
            m_MsgSendNum++;
            ETG_TRACE_USR4(("testMsgQSend:OK (m_MsgSendNum:%d iLength:%d m_CountMsges:%d)",m_MsgSendNum,iLength, m_CountMsges));
            iRet = SimulationOutputWrapper::OK;
        }
        else
        {
            ETG_TRACE_FATAL(("testMsgQSend:NOK"));
        }

        lockSimQ.unlock();

    }
    else
    {
        ETG_TRACE_FATAL(("testMsgQSend:NOK not yet created!"));
    }

    ETG_TRACE_USR4(("Leaving testMsgQSend"));
    return iRet;


}


void SimulationOutputWrapper::testMsgQDropRecBuf(OUT void *pu8Buffer)
{
    if(m_pMsgQueue)
    {
        m_pMsgQueue->DropMessage(pu8Buffer);
    }
}


void*  SimulationOutputWrapper::testMsgQWait(OUT unsigned int &uLength, IN unsigned int timeout_ms) //cpp unit test waits on this
{
    ENTRY

    ETG_TRACE_USR4(("Entering testMsgQWait"));
    void *pReceiveBuf = NULL;
    uLength = 0;

    if(m_pMsgQueue)
    {


        size_t msgSize;
        pReceiveBuf = m_pMsgQueue->WaitForMessage(&msgSize,timeout_ms);
        if(pReceiveBuf)
        {

            //copy to output buffer and drop ReceiveBuf
            uLength = msgSize;
        }

        if(uLength > 0)
        {
            lockSimQ.lock();
            //printf("Message Queue Receive Successful. Received Data %s\n",pu8Buffer);
            m_CountMsges--;
            lockSimQ.unlock();

            m_MsgReceiveNum++;

            ETG_TRACE_USR4(("testMsgQWait:Received OK (m_MsgReceiveNum:%d u32Length:%d m_CountMsges:%d)",m_MsgReceiveNum,uLength,m_CountMsges));


        }
        else
        {
            ETG_TRACE_USR4(("[INFO]testMsgQWait:NOK: u32Length:%d (timeout_ms:%d)",uLength,timeout_ms));
        }
    }
    else
    {
        ETG_TRACE_FATAL(("iMessageQueueWait:NOK not yet created!"));
    }

    ETG_TRACE_USR4(("Leaving iMessageQueueWait"));
    return pReceiveBuf;
}

int  SimulationOutputWrapper::testMsgQGetMsgsInQueue()
{
    ENTRY
    VARTRACE(m_CountMsges)
    return m_CountMsges;
}



int SimulationOutputWrapper::testMsgQInit()
{
    ENTRY
    int iRet = SimulationOutputWrapper::ERROR;

    if(NULL == m_pMsgQueue)
    {
        char cMsgQName[80];
        snprintf(cMsgQName,80,NAME_OF_MSGQ_FUNCTIONWRITES_TO);
        m_pMsgQueue = new MessageQueue(cMsgQName);
        if(m_pMsgQueue)
        {
            ETG_TRACE_USR4(("testMsgQInit:OK"));
            iRet = SimulationOutputWrapper::OK;
        }
        else
        {
            ETG_TRACE_FATAL(("testMsgQInit:NOK"));
        }
    }
    else
    {
        ETG_TRACE_FATAL(("testMsgQInit:NOK - already exists"));
    }

    VARTRACE(iRet)
    return iRet;
}

tBool SimulationOutputWrapper::testMsqQIsInUse()
{
    ENTRY
    tBool bRet= FALSE;
    if(m_pMsgQueue)
    {
        bRet = TRUE;
    }
    VARTRACE(bRet)
    return bRet;
}



int SimulationOutputWrapper::testMsqQDelete()
{
    ENTRY

    int iRet = SimulationOutputWrapper::ERROR;
    if(m_pMsgQueue)
    {
        unsigned int uNumOfMessage = (unsigned int)m_pMsgQueue->GetCurMessagesCount();
        unsigned int uNumbytesReceived;
        void *receivemsg = NULL;
        for(unsigned int i=0;i<uNumOfMessage;i++)
        {
            receivemsg = testMsgQWait(OUT uNumbytesReceived,IN 100 /*ms timout*/);

            if(receivemsg)
            {
                testMsgQDropRecBuf(receivemsg);
            }

        }
        uNumOfMessage = (unsigned int)m_pMsgQueue->GetCurMessagesCount();
        if(uNumOfMessage!=0)
        {
            ETG_TRACE_FATAL(("[WARNING] testMsqQDelete: message queue expected to be empty!"));
        }

        m_pMsgQueue->Flush();

        delete m_pMsgQueue;
        m_pMsgQueue = NULL; //check fro try here
        ETG_TRACE_USR4(("testMsqQDelete:OK"));
        iRet = SimulationOutputWrapper::OK;

    }
    else
    {
        ETG_TRACE_FATAL(("testMsqQDelete:NOK not yet created!"));
    }

    return iRet;
}

//<--Roadmap 16014 'full text search'


//-->Roadmap 16003 : CD Ripping With Gracenote

tResult SimulationOutputWrapper::Send_OnDeleteMediaContentMethodResult(IN tDeleteMediaContentType deleteMediaContentType, IN tFileOperationErrorCodes fileOperationErrorCodes, IN tU16 numofFilesDeleted  )
{
    ENTRY
    (void)deleteMediaContentType;
    ETG_TRACE_USR4(("[INFO] DeleteMediaContent operation deleted %d media files",numofFilesDeleted));
    switch(fileOperationErrorCodes)
    {
        case FILE_OPERATION_OK:
            ETG_TRACE_USR4(("[INFO] DeleteMediaContent operation completed successfully"));
            break;
        case FILEPERM_ISSUE:
            ETG_TRACE_FATAL(("[Error] DeleteMediaContent : FILEPERM_ISSUE"));
            break;
        case DATABASE_ERROR:
            ETG_TRACE_FATAL(("[Error] DeleteMediaContent : DATABASE_ERROR"));
            break;
        case DEVICE_NOT_EXISITS:
            ETG_TRACE_FATAL(("[Error] DeleteMediaContent : DEVICE_NOT_EXISITS"));
            break;
        case LISTTYPE_NOT_FOUND:
            ETG_TRACE_FATAL(("[Error] DeleteMediaContent : LISTTYPE_NOT_FOUND"));
            break;
        case FILE_OPERATION_ERROR:
            ETG_TRACE_FATAL(("[Error] DeleteMediaContent : FILE_OPERATION_ERROR"));
            break;
        case DEVICE_ERROR:
            ETG_TRACE_FATAL(("[Error] DeleteMediaContent : DEVICE_ERROR"));
            break;
        default:
            ETG_TRACE_FATAL(("[Error] DeleteMediaContent : Unexpected error code"));
            break;
    }


}

tResult SimulationOutputWrapper::Send_OnEditMetadataMethodResult(IN tEditMetadatatType editMetadatatType, IN tFileOperationErrorCodes fileOperationErrorCodes )
{
    ENTRY
    (void)editMetadatatType;



    switch(fileOperationErrorCodes)
    {
        case FILE_OPERATION_OK:
            ETG_TRACE_USR4(("[INFO] EditMetadata operation completed successfully"));
            break;
        case FILEPERM_ISSUE:
            ETG_TRACE_FATAL(("[Error] EditMetadata : FILEPERM_ISSUE"));
            break;
        case DATABASE_ERROR:
            ETG_TRACE_FATAL(("[Error] EditMetadata : DATABASE_ERROR"));
            break;
        case DEVICE_NOT_EXISITS:
            ETG_TRACE_FATAL(("[Error] EditMetadata : DEVICE_NOT_EXISITS"));
            break;
        case TAG_EDIT_ERROR:
            ETG_TRACE_FATAL(("[Error] EditMetadata : TAG EDIT ERROR"));
            break;
        case DEVICE_ERROR:
            ETG_TRACE_FATAL(("[Error] EditMetadata : DEVICE_ERROR"));
            break;
        case OBJECT_NOT_FOUND:
            ETG_TRACE_FATAL(("[Error] EditMetadata : OBJECT_NOT_FOUND"));
            break;
        default:
            ETG_TRACE_FATAL(("[Error] EditMetadata : Unexpected error code"));
            break;
    }

}


void SimulationOutputWrapper::StartFileOperation()
{
    m_Result = MP_NO_ERROR;
    isFileListOperationInProgress = true;
}
bool SimulationOutputWrapper::isFileOperationCompleted(tResult &res)
{
    res = m_Result;
    return !isFileListOperationInProgress;
}

tResult SimulationOutputWrapper::Send_OnAddFileNamesToPlaylistMethodResult(IN tResult playlistOperationErrorCodes )
{
    tResult res = MP_NO_ERROR;
    ETG_TRACE_USR4(("[INFO] AddFileNamesToPlaylist operation completed with error code %d",playlistOperationErrorCodes));
    m_Result = playlistOperationErrorCodes;
    isFileListOperationInProgress = false;
    return res;
}

tResult SimulationOutputWrapper::Send_OnDeleteEntriesFromPlaylistMethodResult(IN tResult playlistOperationErrorCodes )
{
    tResult res = MP_NO_ERROR;
    ETG_TRACE_USR4(("[INFO] DeleteEntriesFromPlaylist operation completed with error code %d",playlistOperationErrorCodes));
    m_Result = playlistOperationErrorCodes;
    isFileListOperationInProgress = false;
    return res;


}


//<--Roadmap 16003 : 'CD Ripping With Gracenote'


tResult SimulationOutputWrapper::UpdateRippingStatus()
{
    ENTRY

}

tResult SimulationOutputWrapper::UpdateAutoRipping()
{
    ENTRY

}
