/**
 * @defgroup SimulationConfiguration Configuration
 * @author Stefan Scherber, Matthias Thömel
 *
 * public interface for configuration of the simulations
 * @{
 */

#ifndef SIMULATION_CONFIGURATION_H_
#define SIMULATION_CONFIGURATION_H_

#include <vector>

#include "TypeDefinitions.h"
#include "Configuration.h"

typedef enum SubversionTypes_E
{
    eSubType_Undefined                   = 0,
    eSubType_NisScope1                   = 1,
    eSubType_NisScope2                   = 2,
    eSubType_NisScope2_1AIVI             = 3,
    eSubType_GMP_NisScope2_WO_iAP1          = 4,
    eSubType_GMP_NisSC2_1AIVI_WO_iAP1_VID   = 5,
    eSubType_GMP_NisScope3AIVI_WO_iAP1      = 6,
    eSubType_GMP_NisSC3AIVI_WO_iAP1_VID     = 7,
    eSubType_NisScope2_1RENAULT             = 8,
    eSubType_GMP_NisScope3RENAULT_WO_iAP1   = 9,
    eSubType_GMP_NisScope2_1RENAULT_WO_iAP1 = 10,
    eSubType_GMP_NisScope2_1AIVI_WO_iAP1    = 11,
    eSubType_NIS_PIVI                       = 12,
    eSubType_GMP_Nis_PIVI_WO_iAP1           = 13,
    eSubType_GMP_Nis_PIVI_WO_iAP1_VID       = 14,
    eSubType_NisSC2_1AIVI_VID               = 15,
    eSubType_NisScope3AIVI_VID              = 16,
    eSubType_Nis_PIVI_VID                   = 17,
    eSubTypeLastElem                        = 18
}teSubversionType;

typedef struct
{
    teSubversionType                  enSubType;
    std::string                       strBoundRegistryValue;
    std::string                       strDescription;
    tBool                             bUseRegistry; //is set then instead of the versions hardcoded - registry will be read to update values.
} trSubVersionValueDescription;

class SimulationConfiguration : public Configuration
{

public:
    SimulationConfiguration(tComponentID componentId);

    /**
    * This function sets early Generic MediaPlayer configuration values. 
    *
    */
    virtual tResult PreLoadSettings(void);
    
    /**
     * implements the configuration loading for the simulation by reading values from a file
     * and putting them to the data base.
     *
     * @return < 0: error, = 0: OK
     */
    tResult LoadSettings(void);

    teSubversionType GetSubversionEnum(const char* subversionString);

    void SupportVideoFileFormats();

    static trSubVersionValueDescription m_rSubVersionValueDescriptions[eSubTypeLastElem];//first implementation for NIS - later

protected:

      virtual void CreateSortlibRuleTable();
};

#endif /*SIMULATIONCONFIGURATION_H_*/

/** @} */
