
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TRACE
#ifdef TARGET_BUILD
#include "trcGenProj/Header/MediaPlayer_Trace_Interface.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_TRACE
#endif
#endif


#include "MediaPlayerInterface.h"
#include "VarTrace.h"
#include "LocalSPM.h"
#include "MediaPlayer_Trace_Interface.h"
#ifndef _FC_MEDIAPLAYER_ROOTDAEMON_CLIENT_H_
#include "FC_MediaPlayer_rootdaemon_client.h"
#endif

#define STRINGIZE(x) #x
#define STRINGIZE_VALUE_OF(x) STRINGIZE(x)




MediaplayerTraceInterface *pThis = NULL;

MediaplayerTraceInterface::MediaplayerTraceInterface()
{
    pThis = this;
    vRegisterTTFISService();
}

MediaplayerTraceInterface::~MediaplayerTraceInterface()
{
    vDeRegisterTTFISService();
}

#define FUNCTION_ID_PLAYBACKMODE 0x00
#define FUNCTION_ID_REPEATMODE 0x01
#define FUNCTION_ID_PLAYBACKSTATE 0x02
#define FUNCTION_ID_PLAYTIME 0x03
#define FUNCTION_ID_NOWPLAYING 0x04
#define FUNCTION_ID_NOWSHOWING 0x05
#define FUNCTION_ID_SLIDESHOWTIME 0x06
#define FUNCTION_ID_SLIDESHOWSTATE 0x07
#define FUNCTION_ID_ACTIVEDEVICE 0x08

#define FUNCTION_ID_GETDEVICECONNECTIONS 0x20
#define FUNCTION_ID_GETCURRENTFOLDERPATH 0x21

#define FUNCTION_ID_SETACTIVEDEVICE 0x40
#define FUNCTION_ID_REINDEXING 0x41
#define FUNCTION_ID_SWITCHTOOFF 0x42
#define FUNCTION_ID_SWITCHTONORMAL 0x43
#define FUNCTION_ID_DIAGNOSISPLAYSONG 0x44
#define FUNCTION_ID_TRACECONFIGURATION 0x45
#define FUNCTION_ID_PLAYMEDIAPLAYEROBJECT 0x46
#define FUNCTION_ID_CREATEMEDIAPLAYERFILELISTEXT 0x47
#define FUNCTION_ID_SETREPEATMODE 0x48
#define FUNCTION_ID_GETGMPVERSION 0x49
#define FUNCTION_ID_CHECK_DB_INTEGRITY 0x4A
#define FUNCTION_ID_PLAYBACK_ACTION 0x4B
#define FUNCTION_ID_ALLOCATE 0x4C
#define FUNCTION_ID_DEALLOCATE 0x4D
#define FUNCTION_ID_SOURCE_ACTIVITY 0x4E

#define FUNCTION_ID_IPOD_APPCONTROL_CONNECT 0x50
#define FUNCTION_ID_IPOD_APPCONTROL_COMMAND 0x51
#define FUNCTION_ID_IPOD_APPCONTROL_CLOSE 0x52
#define FUNCTION_ID_IPOD_APPCONTROL_DIPOACTIVEDEVICE 0x53
#define FUNCTION_ID_IPOD_APPCONTROL_DIPOROLESWITCH 0x54
#define FUNCTION_ID_IPOD_SET_HOSTMODE_CONNECTION_MAX 0x55
#define FUNCTION_ID_IPOD_APPCONTROL_SET_CALLCONTROL_CONFIG 0x56
#define FUNCTION_ID_IPOD_APPCONTROL_GET_CALLCONTROL_CONFIG 0x57
#define FUNCTION_ID_IPOD_APPCONTROL_INITIATE_CALL 0x58
#define FUNCTION_ID_IPOD_APPCONTROL_ACCEPT_CALL 0x59
#define FUNCTION_ID_IPOD_APPCONTROL_END_CALL 0x5A
#define FUNCTION_ID_IPOD_APPCONTROL_SWAP_CALL 0x5B
#define FUNCTION_ID_IPOD_APPLE_HID_COMMAND 0x5C

#define FUNCTION_ID_DIPOROLESWITCHREQUIRED 0x60
#define FUNCTION_ID_MEMORYTEST_START 0x61
#define FUNCTION_ID_MEMORYTEST_STOP  0x62

#define FUNCTION_ID_USE_MEDIA_ENGINE      0x70

#define FUNCTION_ID_SETVIDEOBRIGHTNESS  0x80
#define FUNCTION_ID_SETVIDEOHUE  0x81
#define FUNCTION_ID_SETVIDEOSATURATION  0x82
#define FUNCTION_ID_SETVIDEOCONTRAST  0x83
#define FUNCTION_ID_SETVIDEOBRIGHTNESSOFFSET  0x84
#define FUNCTION_ID_SETVIDEOSATURATIONOFFSET  0x85
#define FUNCTION_ID_SETVIDEOHUEOFFSET  0x86

#define FUNCTION_ID_DATABASE_STATUS  0x87

#define FUNCTION_ID_EJECT_INTERNAL_DVD  0xD1
#define FUNCTION_ID_SENDPLAYBACKSPEED  0xD2
#define FUNCTION_ID_ROOTDAEMONREQUEST_IAP_COMMON_WRITE  0xD3
#define FUNCTION_ID_ROOTDAEMONREQUEST_IAP_LOAD_MODULE 0xD4
#define FUNCTION_ID_ROOTDAEMONREQUEST_IAP_UNLOAD_MODULE  0xD5
#define FUNCTION_ID_ROOTDAEMONREQUEST_MANUAL_UDEVTRIGGER_ADDBLOCKDEVICES  0xD6
#define FUNCTION_ID_ROOTDAEMONREQUEST_MANUAL_UDEVTRIGGER_REMOVEBLOCKDEVICES  0xD7

void MediaplayerTraceInterface::Do(int functionID, void *ptr)
{
    tS32 result = 0;
    int cmdParm1 = 0;
    int cmdParm2 = 0;
    int cmdParm3 = 0;
    char cmdParmString[1024];
    LocalSPM::GetThreadFactory().SetName("MediaplayerTraceInterface");
    memset(cmdParmString, 0, sizeof cmdParmString);
    static vector<tMediaObjectPtr> memtestlist;
    static vector<char *> memtestlist1;

    if (ptr)
    {
        if ((functionID == FUNCTION_ID_DIAGNOSISPLAYSONG) || //special handling for DIAGNOSISPLAYSONG
            (functionID == FUNCTION_ID_CREATEMEDIAPLAYERFILELISTEXT) ||
            (functionID == FUNCTION_ID_ALLOCATE) ||
            (functionID >= FUNCTION_ID_IPOD_APPCONTROL_CONNECT && functionID <= FUNCTION_ID_IPOD_APPCONTROL_CLOSE) ||
            (functionID >= FUNCTION_ID_IPOD_APPCONTROL_INITIATE_CALL && functionID <= FUNCTION_ID_IPOD_APPCONTROL_END_CALL))
        {
            SMF::UnMarshal((char*)ptr, "it", &cmdParm1, &cmdParmString);
        }
        else
        {
            SMF::UnMarshal((char*)ptr, "iii", &cmdParm1, &cmdParm2, &cmdParm3);
        }
        delete[] (char*)ptr;
    }

    switch(functionID)
    {
        /***  Please do not change the following 8 functions. Will be used by Systemtest ***/
        case FUNCTION_ID_PLAYBACKMODE: {
            LocalSPM::GetThreadFactory().SetName("ID_PLAYBACKMODE");
            tPlaybackMode playbackMode;
            result = MediaPlayerInterface::GetInstance().GetPlaybackMode(playbackMode);
            if (result == 0)
            {
                ETG_TRACE_USR1(("CMD: PlaybackMode:"));
                VARTRACE(playbackMode)
            }
            else
            {
                ETG_TRACE_USR1(("CMD: PlaybackMode: Error: %d",result));
            }
            break;
        }
        case FUNCTION_ID_REPEATMODE: {
            LocalSPM::GetThreadFactory().SetName("ID_REPEATMODE");
            tRepeatMode repeatMode;
            result = MediaPlayerInterface::GetInstance().GetRepeatMode(repeatMode);
            if (result == 0)
            {
                ETG_TRACE_USR1(("CMD: RepeatMode:"));
                VARTRACE(repeatMode)
            }
            else
            {
                ETG_TRACE_USR1(("CMD: RepeatMode: Error: %d",result));
            }
            break;
        }
        case FUNCTION_ID_PLAYBACKSTATE: {
            LocalSPM::GetThreadFactory().SetName("ID_PLAYBACKSTATE");
            tHMIPlaybackState playbackState;
            result = MediaPlayerInterface::GetInstance().GetPlaybackState(playbackState);
            if (result == 0)
            {
                ETG_TRACE_USR1(("CMD: PlaybackState:"));
                VARTRACE(playbackState)
            }
            else
            {
                ETG_TRACE_USR1(("CMD: PlaybackState: Error: %d",result));
            }
            break;
        }

        case FUNCTION_ID_PLAYTIME: {
            LocalSPM::GetThreadFactory().SetName("ID_PLAYTIME");
            tPlaytime elapsedPlaytime;
            tPlaytime totalPlaytime;
            tObjectID objectID;
            result = MediaPlayerInterface::GetInstance().GetPlaytime(elapsedPlaytime, totalPlaytime, objectID);
            if (result == 0)
            {
                ETG_TRACE_USR1(("CMD: Elapsed playtime:"));
                VARTRACE(elapsedPlaytime)
                ETG_TRACE_USR1(("CMD: Total playtime:"));
                VARTRACE(totalPlaytime)
                ETG_TRACE_USR1(("CMD: objectID:"));
                VARTRACE(objectID)
            }
            else
            {
                ETG_TRACE_USR1(("CMD: Playtime: Error: %d",result));
            }
            break;
        }
        case FUNCTION_ID_NOWPLAYING: {
            LocalSPM::GetThreadFactory().SetName("ID_NOWPLAYING");
            tNowPlaying nowPlaying;
            result = MediaPlayerInterface::GetInstance().GetNowPlaying(nowPlaying);
            if (result == 0)
            {
                ETG_TRACE_USR1(("CMD: NowPlaying:"));
                ETG_TRACE_USR1(("Genre: %s", nowPlaying.object.MetadataField1));
                ETG_TRACE_USR1(("Artist: %s", nowPlaying.object.MetadataField2));
                ETG_TRACE_USR1(("Album: %s", nowPlaying.object.MetadataField4));
                ETG_TRACE_USR1(("Title: %s", nowPlaying.object.title));
                ETG_TRACE_USR1(("Track number: %d", nowPlaying.object.trackNumber));
                ETG_TRACE_USR1(("File name: %s", nowPlaying.object.fileName));
            }
            else
            {
                ETG_TRACE_USR1(("CMD: NowPlaying: Error: %d",result));
            }
            break;
        }
        case FUNCTION_ID_NOWSHOWING: {
            LocalSPM::GetThreadFactory().SetName("ID_NOWSHOWING");
            tNowShowing nowShowing;
            result = MediaPlayerInterface::GetInstance().GetNowShowing(nowShowing);
            if (result == 0)
            {
                ETG_TRACE_USR1(("CMD: NowShowing:"));
                VARTRACE(nowShowing.object.fileName)
            }
            else
            {
                ETG_TRACE_USR1(("CMD: NowShowing: Error: %d",result));
            }
            break;
        }
        case FUNCTION_ID_SLIDESHOWTIME: {
            LocalSPM::GetThreadFactory().SetName("ID_SLIDESHOWTIME");
            tSlideshowTime slideshowTime;
            result = MediaPlayerInterface::GetInstance().GetSlideshowTime(slideshowTime);
            if (result == 0)
            {
                ETG_TRACE_USR1(("CMD: SlideshowTime:"));
                VARTRACE(slideshowTime)
            }
            else
            {
                ETG_TRACE_USR1(("CMD: SlideshowTime: Error: %d",result));
            }
            break;
        }
        case FUNCTION_ID_SLIDESHOWSTATE: {
            LocalSPM::GetThreadFactory().SetName("ID_SLIDESHOWSTATE");
            tHMIPlaybackState playbackState;
            result = MediaPlayerInterface::GetInstance().GetSlideshowState(playbackState);
            if (result == 0)
            {
                ETG_TRACE_USR1(("CMD: SlideshowState:"));
                VARTRACE(playbackState)
            }
            else
            {
                ETG_TRACE_USR1(("CMD: SlideshowState: Error: %d",result));
            }
            break;
        }
        case FUNCTION_ID_ACTIVEDEVICE: {
            LocalSPM::GetThreadFactory().SetName("ID_ACTIVEDEVICE");
            tNumberOfDevices numberOfDevices;
            vector<tDeviceInfo> deviceInformation;
            result = MediaPlayerInterface::GetInstance().GetMediaplayerDeviceConnections(numberOfDevices, deviceInformation);
            if (result == 0)
            {
                tBool found = FALSE;
                vector<tDeviceInfo>::iterator it;
                for(it = deviceInformation.begin(); it < deviceInformation.end(); it++)
                {
                    if (FALSE != it->activeSource)
                    {
                        ETG_TRACE_USR1(("CMD: Active device:"));
                        found = TRUE;
                        VARTRACE(it->deviceName)
                        VARTRACE(it->deviceType)
                    }
                }
                if (FALSE == found)
                {
                    ETG_TRACE_USR1(("CMD: Active device: No active device found"));
                }
            }
            else
                VARTRACE(result);
            break;

        }
        /***  End. The following functions can be changed ***/


        case FUNCTION_ID_GETDEVICECONNECTIONS: {
            LocalSPM::GetThreadFactory().SetName("ID_GETDEVICECONNECTIONS");
            tNumberOfDevices numberOfDevices;
            vector<tDeviceInfo> deviceInformation;
            result = MediaPlayerInterface::GetInstance().GetMediaplayerDeviceConnections(numberOfDevices, deviceInformation);
            ETG_TRACE_USR1(("CMD: GetDeviceConnections:"));
            if (result == 0)
            {
                VARTRACE(numberOfDevices)
                VARTRACE(deviceInformation)
            }
            else
                VARTRACE(result);
            break;

        }
        case FUNCTION_ID_GETCURRENTFOLDERPATH: {
            LocalSPM::GetThreadFactory().SetName("ID_GETCURRENTFOLDERPATH");
            tPath currentFolderPath;
            tListID listID;
            result = MediaPlayerInterface::GetInstance().GetCurrentFolderPath(currentFolderPath, listID);
            if (result == 0)
            {
                ETG_TRACE_USR1(("CMD: Current folder path:"));
                VARTRACE(currentFolderPath)
                VARTRACE(listID)
            }
            else
            {
                ETG_TRACE_USR1(("CMD: Current folder path: Error"));
                VARTRACE(result);
            }
            break;

        }
        case FUNCTION_ID_SETACTIVEDEVICE: {
            LocalSPM::GetThreadFactory().SetName("ID_SETACTIVEDEVICE");
            tDeviceID deviceID = (tDeviceID)cmdParm1;
            VARTRACE(deviceID);
            tBool activeSource = TRUE;
            result = MediaPlayerInterface::GetInstance().ActiveMediaDeviceSet(IN deviceID, IN activeSource);
            if (result == 0)
            {
                ETG_TRACE_USR1(("CMD: Set active device:"));
            }
            else
            {
                ETG_TRACE_USR1(("CMD: Set active device: Error"));
                VARTRACE(result);
            }
            break;
        }
        case FUNCTION_ID_REINDEXING: {
            LocalSPM::GetThreadFactory().SetName("ID_REINDEXING");
            tDeviceID deviceID = (tDeviceID)cmdParm1;
            VARTRACE(deviceID);
            //result = iPodControlIAP::InitMicroChipHub(); //Test only
            result = MediaPlayerInterface::GetInstance().Reindexing(IN deviceID);
            if (result == 0)
            {
                ETG_TRACE_USR1(("CMD: Reindexing:"));
            }
            else
            {
                ETG_TRACE_USR1(("CMD: Reindexing: Error"));
                VARTRACE(result);
            }
            break;
        }
        case FUNCTION_ID_SWITCHTOOFF: {
            LocalSPM::GetThreadFactory().SetName("ID_SWITCHTOOFF");
            result = MediaPlayerInterface::GetInstance().StateChangeOff();
            if (result == 0)
            {
                ETG_TRACE_USR1(("CMD: State change off:"));
            }
            else
            {
                ETG_TRACE_USR1(("CMD: State change off: Error"));
                VARTRACE(result);
            }
            break;
        }
        case FUNCTION_ID_SWITCHTONORMAL: {
            LocalSPM::GetThreadFactory().SetName("ID_SWITCHTONORMAL");
            result = MediaPlayerInterface::GetInstance().StateChangeNormal();
            if (result == 0)
            {
                ETG_TRACE_USR1(("CMD: State change normal:"));
            }
            else
            {
                ETG_TRACE_USR1(("CMD: State change normal: Error"));
                VARTRACE(result);
            }
            break;
        }
        case FUNCTION_ID_DIAGNOSISPLAYSONG: {
            LocalSPM::GetThreadFactory().SetName("ID_DIAGNOSISPLAYSONG");
            ETG_TRACE_USR1(("CMD: DiagnosisPlaysong:"));
            tDeviceType deviceType = (tDeviceType)cmdParm1;
            VARTRACE(deviceType);
            VARTRACE(cmdParmString);
            result = MediaPlayerInterface::GetInstance().DiagnosisPlaySong(IN deviceType, IN cmdParmString);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_TRACECONFIGURATION:
        {
            LocalSPM::GetThreadFactory().SetName("ID_TRACECONFIGURATION");
            ETG_TRACE_USR1(("CMD: TraceConfiguration:"));
            LocalSPM::GetDataProvider().TraceMediaplayerConfigurations();
            break;
        }
        case FUNCTION_ID_PLAYMEDIAPLAYEROBJECT: {
            LocalSPM::GetThreadFactory().SetName("ID_PLAYMEDIAPLAYEROBJECT");
            ETG_TRACE_USR1(("CMD: PlayMediaPlayerObject:"));
            tObjectID objectID = (tObjectID)cmdParm1;
            VARTRACE(objectID);
            tPlayContinuation playContinuation = (tPlayContinuation)cmdParm2;
            VARTRACE(playContinuation);
            tListID listID;
            tListSize listSize;
            result = MediaPlayerInterface::GetInstance().PlayMediaPlayerObject(OUT listID, OUT listSize, IN objectID, IN playContinuation);
            VARTRACE(result);
            VARTRACE(listID);
            VARTRACE(listSize);
            break;
        }
        case FUNCTION_ID_CREATEMEDIAPLAYERFILELISTEXT: {
            LocalSPM::GetThreadFactory().SetName("ID_CREATEMEDIAPLAYERFILELISTEXT");
            ETG_TRACE_USR1(("CMD: CreateMediaPlayerFileListExt:"));
            tDeviceID deviceID = (tDeviceID)cmdParm1;
            VARTRACE(deviceID);
            VARTRACE(cmdParmString);
            tListID listID;
            tListSize listSize;
            tNumberOfMediaObjects numberOfMediaObjects;
            tNumberOfPlayLists numberOfPlayLists;
            tNumberOfFolders numberOfFolders;
            tPosition position;
            result = MediaPlayerInterface::GetInstance().CreateMediaPlayerFileListExt(OUT listID, OUT listSize, OUT numberOfMediaObjects, OUT numberOfPlayLists,
                OUT numberOfFolders, OUT position, IN cmdParmString, IN deviceID);
            VARTRACE(result);
            VARTRACE(listID);
            VARTRACE(listSize);
            VARTRACE(position);
            break;
        }
        case FUNCTION_ID_SETREPEATMODE: {
            LocalSPM::GetThreadFactory().SetName("ID_SETREPEATMODE");
            ETG_TRACE_USR1(("CMD: SendRepeatMode:"));
            tRepeatMode repeatMode = (tRepeatMode)cmdParm1;
            VARTRACE(repeatMode);
            result = MediaPlayerInterface::GetInstance().SendRepeatMode(IN repeatMode);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_GETGMPVERSION: {
            LocalSPM::GetThreadFactory().SetName("ID_GETGMPVERSION");
            ETG_TRACE_FATAL(("GMP version: %50s. Build date: %50s", STRINGIZE_VALUE_OF(VERSION_NUM_OF_GENMP), STRINGIZE_VALUE_OF(VERSION_DATE_OF_GENMP)));
            break;
        }
        case FUNCTION_ID_CHECK_DB_INTEGRITY: {
            LocalSPM::GetThreadFactory().SetName("ID_CHECK_DB_INTEGRITY");
            ETG_TRACE_USR1(("CMD: CheckDatabaseIntegrity:"));
            VARTRACE(cmdParm1);
            result = LocalSPM::GetDBManager().CheckDatabaseIntegrity(cmdParm1);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_PLAYBACK_ACTION: {
            LocalSPM::GetThreadFactory().SetName("ID_PLAYBACK_ACTION");
            ETG_TRACE_USR1(("CMD: PlaybackAction:"));
            tPlaybackAction playbackAction = (tPlaybackAction)cmdParm1;
            VARTRACE(playbackAction);
            tNextPrevSkipCount nextPrevSkipCount = (tNextPrevSkipCount)cmdParm2;
            VARTRACE(nextPrevSkipCount);
            result = MediaPlayerInterface::GetInstance().SendPlaybackAction(IN playbackAction, IN nextPrevSkipCount);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_ALLOCATE: {
            LocalSPM::GetThreadFactory().SetName("ID_ALLOCATE");
            ETG_TRACE_USR1(("CMD: Allocate:"));
            VARTRACE(cmdParm1);
            VARTRACE(cmdParmString);
            tAudioOutputDevice audioOutputDevice;
            if (!cmdParm1) { //first parameter=0 -> take last used ALSA device name for MP
                tAllocateState allocateState;
                result = LocalSPM::GetPlayerManager().GetAllocateState(OUT allocateState, OUT audioOutputDevice);
            }
            else {          //first parameter!=0 -> take ALSA device name from second parameter
                strncpy_r(audioOutputDevice, cmdParmString, sizeof(audioOutputDevice));
            }
            result = MediaPlayerInterface::GetInstance().SendAllocate(IN audioOutputDevice);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_DEALLOCATE: {
            LocalSPM::GetThreadFactory().SetName("ID_DEALLOCATE");
            ETG_TRACE_USR1(("CMD: Deallocate:"));
            result = MediaPlayerInterface::GetInstance().SendDeAllocate();
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_SOURCE_ACTIVITY: {
            LocalSPM::GetThreadFactory().SetName("ID_SOURCE_ACTIVITY");
            ETG_TRACE_USR1(("CMD: SourceActivity:"));
            tSourceActivity sourceActivity = (tSourceActivity)cmdParm1;
            VARTRACE(sourceActivity);
            result = MediaPlayerInterface::GetInstance().SendSourceActivity(IN sourceActivity);
            VARTRACE(result);
            break;
        }

        case FUNCTION_ID_IPOD_APPCONTROL_CONNECT:
        case FUNCTION_ID_IPOD_APPCONTROL_COMMAND:
        case FUNCTION_ID_IPOD_APPCONTROL_CLOSE: {
            LocalSPM::GetThreadFactory().SetName("CMD: iPodAppControl");
            ETG_TRACE_USR1(("CMD: iPodAppControl:"));
            tDeviceID deviceID = (tDeviceID)cmdParm1;
            VARTRACE(deviceID);
            VARTRACE(cmdParmString);
            tNumberOfDevices numberOfDevices;
            vector<tDeviceInfo> deviceInformation;
            result = MediaPlayerInterface::GetInstance().GetMediaplayerDeviceConnections(numberOfDevices, deviceInformation);
            if (result == 0)
            {
                tBool found = FALSE;
                vector<tDeviceInfo>::iterator it;
                for(it = deviceInformation.begin(); it < deviceInformation.end(); it++)
                {
                    if (it->deviceID == deviceID)
                    {
                        ETG_TRACE_USR1(("CMD: Found device:"));
                        found = TRUE;
                        VARTRACE(it->deviceName)
                        VARTRACE(it->mountPoint)
                        tProtocolName protocol = {0};
                        tBundleSeedID bundleSeedID = {0};
                        tSessionID sessionID = 1;
                        tUserContext userContext;
                        memset(&userContext, 0, sizeof userContext);
                        unsigned char commandBuffer[] = "TEST-COMMAND-DATAGRAM....1234";
                        if(functionID == FUNCTION_ID_IPOD_APPCONTROL_CONNECT) {
                            result = MediaPlayerInterface::GetInstance().SendAppControlConnect(it->mountPoint, protocol, bundleSeedID, cmdParmString, tAppLaunchOption_init);
                        } else if(functionID == FUNCTION_ID_IPOD_APPCONTROL_COMMAND) {
                            result = MediaPlayerInterface::GetInstance().SendAppControlCommand(it->mountPoint, cmdParmString, sessionID, sizeof(commandBuffer)-1, commandBuffer, userContext);
                        } else if(functionID == FUNCTION_ID_IPOD_APPCONTROL_CLOSE) {
                            result = MediaPlayerInterface::GetInstance().SendAppControlClose(it->mountPoint, cmdParmString, sessionID);
                        } else {
                            ETG_TRACE_ERR(("CMD: Invalid functionID"));
                        }
                        VARTRACE(result);
                        break;
                    }
                }
                if (FALSE == found)
                {
                    ETG_TRACE_USR1(("CMD: No active device found"));
                }
            } else {
                VARTRACE(result);
            }
            break;
        }
        case FUNCTION_ID_IPOD_APPCONTROL_DIPOACTIVEDEVICE: {
            LocalSPM::GetThreadFactory().SetName("ID_IPOD_APPCONTROL_DIPOACTIVEDEVICE");
            ETG_TRACE_USR1(("CMD: DiPOActiveDevice:"));
            tDeviceID deviceID = (tDeviceID)cmdParm1;
            VARTRACE(deviceID);
            tDiPOActive diPOActive = (tDiPOActive)cmdParm2;
            VARTRACE(diPOActive);
            tUserContext userContext;
            memset(&userContext,0, sizeof userContext);
            result = MediaPlayerInterface::GetInstance().DiPOActiveDevice(IN deviceID, IN diPOActive, IN userContext);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_IPOD_APPCONTROL_DIPOROLESWITCH: {
            LocalSPM::GetThreadFactory().SetName("ID_IPOD_APPCONTROL_DIPOROLESWITCH");
            ETG_TRACE_USR1(("CMD: DiPOActiveDevice:"));
            tDeviceID deviceID = (tDeviceID)cmdParm1;
            VARTRACE(deviceID);
            tDiPORoleStatus diPORoleStatus = (tDiPORoleStatus)cmdParm2;
            VARTRACE(diPORoleStatus);
            tUserContext userContext;
            memset(&userContext,0, sizeof userContext);
            result = MediaPlayerInterface::GetInstance().DiPORoleSwitchRequest(IN deviceID, IN diPORoleStatus, IN userContext);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_IPOD_SET_HOSTMODE_CONNECTION_MAX: {
            LocalSPM::GetThreadFactory().SetName("ID_IPOD_SET_HOSTMODE_CONNECTION_MAX");
            ETG_TRACE_USR1(("CMD: iPodControlSupportIAP2HostModeConnectionsMax:"));
            VARTRACE(cmdParm1);
            LocalSPM::GetDataProvider().iPodControlSupportIAP2HostModeConnectionsMax = cmdParm1;
            int countmax = LocalSPM::GetDataProvider().iPodControlSupportIAP2HostModeConnectionsMax();
            ETG_TRACE_USR1(("Configured iPodControlSupportIAP2HostModeConnectionsMax %d", countmax));
            break;
        }
        case FUNCTION_ID_IPOD_APPCONTROL_SET_CALLCONTROL_CONFIG: {
            LocalSPM::GetThreadFactory().SetName("ID_IPOD_APPCONTROL_SET_CALLCONTROL_CONFIG");
            ETG_TRACE_USR1(("CMD: AppControl SetCallControlsConfig:"));

            tDiPOCallControlsConfiguration callControlsConfig;
            callControlsConfig.value = (tU8)cmdParm1;
            VARTRACE(callControlsConfig.value);
            result = LocalSPM::GetDataProvider().SetDiPOCallControlsConfiguration(callControlsConfig);

            ETG_TRACE_USR1(("Set CallControlsConfig result %d", result));
            break;
        }
        case FUNCTION_ID_IPOD_APPCONTROL_GET_CALLCONTROL_CONFIG: {
            LocalSPM::GetThreadFactory().SetName("ID_IPOD_APPCONTROL_GET_CALLCONTROL_CONFIG");
            ETG_TRACE_USR1(("CMD: AppControl GetCallControlsConfig:"));

            tDiPOCallControlsConfiguration callControlsConfig;
            callControlsConfig.value = 0;
            callControlsConfig = LocalSPM::GetDataProvider().GetDiPOCallControlsConfiguration();
            ETG_TRACE_USR1(("Read CallControlsConfig value %d", callControlsConfig.value));
            ETG_TRACE_USR3(("Read CallControlsConfig:InitiateCallAvailable %d", callControlsConfig.bits.isInitiateCallAvailable));
            ETG_TRACE_USR3(("Read CallControlsConfig:AcceptCallAvailable %d", callControlsConfig.bits.isAcceptCallAvailable));
            ETG_TRACE_USR3(("Read CallControlsConfig:EndCallAvailable %d", callControlsConfig.bits.isEndCallAvailable));
            ETG_TRACE_USR3(("Read CallControlsConfig:SwapCallsAvailable %d", callControlsConfig.bits.isSwapCallsAvailable));
            ETG_TRACE_USR3(("Read CallControlsConfig:MergeCallsAvailable %d", callControlsConfig.bits.isMergeCallsAvailable));
            ETG_TRACE_USR3(("Read CallControlsConfig:HoldStatusUpdateAvailable %d", callControlsConfig.bits.isHoldStatusUpdateAvailable));
            ETG_TRACE_USR3(("Read CallControlsConfig:MuteStatusUpdateAvailable %d", callControlsConfig.bits.isMuteStatusUpdateAvailable));
            ETG_TRACE_USR3(("Read CallControlsConfig:SendDTMFAvailable %d", callControlsConfig.bits.isSendDTMFAvailable));

            break;
        }
        case FUNCTION_ID_IPOD_APPCONTROL_INITIATE_CALL: {
            LocalSPM::GetThreadFactory().SetName("ID_IPOD_APPCONTROL_INITIATE_CALL");
            ETG_TRACE_USR1(("CMD: AppControl DiPO InitiateCall:"));

            tDiPOInitiateCall initiateCall;
            tMountPoint USBSerialNumber = {0};
            strncpy_r(USBSerialNumber, cmdParmString, sizeof(tMountPoint));

            initiateCall.type = (tDiPOInitiateCallType)cmdParm1;
            initiateCall.service = DIPO_INITIATECALLSERVICE_TELEPHONY;
            strncpy_r(initiateCall.destinationID,"+91-111999333",sizeof(tGeneralString));
            strncpy_r(initiateCall.addressBookID,"Apple Phone Book",sizeof(tGeneralString));

            VARTRACE(USBSerialNumber);
            VARTRACE(initiateCall);
            result = MediaPlayerInterface::GetInstance().DiPOSendInitiateCall(USBSerialNumber,initiateCall);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_IPOD_APPCONTROL_ACCEPT_CALL: {
            LocalSPM::GetThreadFactory().SetName("ID_IPOD_APPCONTROL_ACCEPT_CALL");
            ETG_TRACE_USR1(("CMD: AppControl DiPO AcceptCall:"));

            tDiPOAcceptCall acceptCall;
            tMountPoint USBSerialNumber = {0};
            strncpy_r(USBSerialNumber, cmdParmString, sizeof(tMountPoint));

            acceptCall.acceptAction = (tDiPOAcceptAction)cmdParm1;
            strncpy_r(acceptCall.callUUID,"Apple Call UUID",sizeof(tGeneralString));

            VARTRACE(USBSerialNumber);
            VARTRACE(acceptCall);
            result = MediaPlayerInterface::GetInstance().DiPOSendAcceptCall(USBSerialNumber,acceptCall);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_IPOD_APPCONTROL_END_CALL: {
            LocalSPM::GetThreadFactory().SetName("ID_IPOD_APPCONTROL_END_CALL");
            ETG_TRACE_USR1(("CMD: AppControl DiPO EndCall:"));

            tDiPOEndCall endCall;
            tMountPoint USBSerialNumber = {0};
            strncpy_r(USBSerialNumber, cmdParmString, sizeof(tMountPoint));

            endCall.endAction = (tDiPOEndAction)cmdParm1;
            strncpy_r(endCall.callUUID,"Apple Call UUID",sizeof(tGeneralString));

            VARTRACE(USBSerialNumber);
            VARTRACE(endCall);
            result = MediaPlayerInterface::GetInstance().DiPOSendEndCall(USBSerialNumber,endCall);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_DIPOROLESWITCHREQUIRED: {
            LocalSPM::GetThreadFactory().SetName("ID_DIPOROLESWITCHREQUIRED");
            ETG_TRACE_USR1(("CMD: DiPORoleSwitchRequired:"));
            tDeviceID deviceID = (tDeviceID)cmdParm1;
            tMountPoint USBSerialNumber = {0};
            VARTRACE(deviceID);
            tBool DeviceCarplayCapability = cmdParm3;
            result = LocalSPM::GetOutputWrapper().DIPORoleSwitchRequired(IN deviceID,USBSerialNumber,DeviceCarplayCapability);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_USE_MEDIA_ENGINE: {
            LocalSPM::GetThreadFactory().SetName("ID_USE_MEDIA_ENGINE");
            ETG_TRACE_USR1(("CMD: UseMediaEngine:"));
            VARTRACE(cmdParm1);
            LocalSPM::GetDataProvider().UseMediaEngine = cmdParm1;
            int const useMediaEngine = LocalSPM::GetDataProvider().UseMediaEngine();
            ETG_TRACE_USR1(("MEDIA_ENGINE is %s", useMediaEngine ? "ACTIVE" : "DISABLED"));
            break;
        }
        case FUNCTION_ID_MEMORYTEST_START: {
            LocalSPM::GetThreadFactory().SetName("ID_MEMORYTEST_START");
            ETG_TRACE_USR1(("CMD: MemoryTestStart:"));
            VARTRACE(cmdParm1);
            VARTRACE(cmdParm2);
            VARTRACE(cmdParm3);
            if(cmdParm3 > 0) {
                int thres = (int)cmdParm3 * 1024;
                VARTRACE(thres);
                int trim = mallopt(M_TRIM_THRESHOLD, thres);
                VARTRACE(trim);
            }
            //mallopt(M_TRIM_THRESHOLD, 4 * 1024);
            int cnt = (long long)cmdParm1 * 1024 * 1024 / sizeof(tMediaObject);
            VARTRACE(cnt);
            VARTRACE(sizeof(tMediaObject));
            for(int i = 0; i < cnt; i++) {
                if(cmdParm2 > 0) {
                    char * p1 = new char[4];
                    p1[3] = 12;
                    memtestlist1.push_back(p1);
                }
                tMediaObjectPtr p = new tMediaObject;
                InitMediaObject(OUT *p);
                memtestlist.push_back(p);
            }
            //malloc_info(0, stdout);
            struct mallinfo minfo = mallinfo();
            VARTRACE(minfo.arena);
            VARTRACE(minfo.ordblks);
            VARTRACE(minfo.smblks);
            VARTRACE(minfo.hblks);
            VARTRACE(minfo.hblkhd);
            VARTRACE(minfo.usmblks);
            VARTRACE(minfo.fsmblks);
            VARTRACE(minfo.uordblks);
            VARTRACE(minfo.fordblks);
            VARTRACE(minfo.keepcost);
            break;
        }
        case FUNCTION_ID_MEMORYTEST_STOP: {
            LocalSPM::GetThreadFactory().SetName("ID_MEMORYTEST_STOP");
            ETG_TRACE_USR1(("CMD: MemoryTestStop:"));
            VARTRACE(cmdParm1);
            VARTRACE(cmdParm2);
            for (int i = 1; i < (int)memtestlist.size() - 1; i++) {
                delete memtestlist[i];
            }
            memtestlist.clear();
            if(cmdParm1 == 1) {
                for(unsigned int i = 0; i < memtestlist1.size(); i++) {
                    delete [] memtestlist1[i];
                }
                memtestlist1.clear();
            }
            if(cmdParm1 == 2) {
                size_t pad = (size_t)cmdParm2 * 1024 * 1024;
                VARTRACE(pad);
                malloc_trim(pad);
            }

            //malloc_info(0, stdout);
            struct mallinfo minfo = mallinfo();
            VARTRACE(minfo.arena);
            VARTRACE(minfo.ordblks);
            VARTRACE(minfo.smblks);
            VARTRACE(minfo.hblks);
            VARTRACE(minfo.hblkhd);
            VARTRACE(minfo.usmblks);
            VARTRACE(minfo.fsmblks);
            VARTRACE(minfo.uordblks);
            VARTRACE(minfo.fordblks);
            VARTRACE(minfo.keepcost);
            break;
        }
        case FUNCTION_ID_SETVIDEOBRIGHTNESS: {
            LocalSPM::GetThreadFactory().SetName("ID_SETVIDEOBRIGHTNESS");
            ETG_TRACE_USR1(("CMD: SendVideoProperty:"));
            tPropertyValue videoBrightness = (tPropertyValue)cmdParm1;
            VARTRACE(videoBrightness);
            result = MediaPlayerInterface::GetInstance().SendVideoProperty(IN VP_BRIGHTNESS,IN videoBrightness);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_SETVIDEOHUE: {
            LocalSPM::GetThreadFactory().SetName("ID_SETVIDEOHUE");
            ETG_TRACE_USR1(("CMD: SendVideoProperty:"));
            tPropertyValue videoHue = (tPropertyValue)cmdParm1;
            VARTRACE(videoHue);
            result = MediaPlayerInterface::GetInstance().SendVideoProperty(IN VP_HUE,IN videoHue);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_SETVIDEOSATURATION: {
            LocalSPM::GetThreadFactory().SetName("ID_SETVIDEOSATURATION");
            ETG_TRACE_USR1(("CMD: SendVideoProperty:"));
            tPropertyValue videoSaturation = (tPropertyValue)cmdParm1;
            VARTRACE(videoSaturation);
            result = MediaPlayerInterface::GetInstance().SendVideoProperty(IN VP_SATURATION,IN videoSaturation);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_SETVIDEOCONTRAST: {
            LocalSPM::GetThreadFactory().SetName("ID_SETVIDEOCONTRAST");
            ETG_TRACE_USR1(("CMD: SendVideoProperty:"));
            tPropertyValue videoContrast = (tPropertyValue)cmdParm1;
            VARTRACE(videoContrast);
            result = MediaPlayerInterface::GetInstance().SendVideoProperty(IN VP_CONTRAST,IN videoContrast);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_SETVIDEOBRIGHTNESSOFFSET: {
            LocalSPM::GetThreadFactory().SetName("ID_SETVIDEOBRIGHTNESSOFFSET");
            ETG_TRACE_USR1(("CMD: SendVideoProperty:"));
            tPropertyValue videoBrightnessOffset = (tPropertyValue)cmdParm1;
            VARTRACE(videoBrightnessOffset);
            result = MediaPlayerInterface::GetInstance().SendVideoProperty(IN VP_BRIGHTNESS_OFFSET,IN videoBrightnessOffset);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_SETVIDEOSATURATIONOFFSET: {
            LocalSPM::GetThreadFactory().SetName("ID_SETVIDEOSATURATIONOFFSET");
            ETG_TRACE_USR1(("CMD: SendVideoProperty:"));
            tPropertyValue videoSaturationOffset = (tPropertyValue)cmdParm1;
            VARTRACE(videoSaturationOffset);
            result = MediaPlayerInterface::GetInstance().SendVideoProperty(IN VP_SATURATION_OFFSET,IN videoSaturationOffset);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_SETVIDEOHUEOFFSET: {
            LocalSPM::GetThreadFactory().SetName("ID_SETVIDEOHUEOFFSET");
            ETG_TRACE_USR1(("CMD: SendVideoProperty:"));
            tPropertyValue videoHueOffset = (tPropertyValue)cmdParm1;
            VARTRACE(videoHueOffset);
            result = MediaPlayerInterface::GetInstance().SendVideoProperty(IN VP_HUE_OFFSET,IN videoHueOffset);
            VARTRACE(result);
            break;
        }
        //CID 79471, 184720: Missing break in switch
        case FUNCTION_ID_EJECT_INTERNAL_DVD:
        {
            LocalSPM::GetThreadFactory().SetName("ID_EJECT_INTERNAL_DVD");
            ETG_TRACE_USR1(("CMD: EjectInternalDvd:"));
            result = MediaPlayerInterface::GetInstance().RequestDiscOperation(1);
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_DATABASE_STATUS:
        {
            LocalSPM::GetThreadFactory().SetName("Database_Status");
            ETG_TRACE_USR1(("Database_Status-->"));
            result = MediaPlayerInterface::GetInstance().DatabaseStatistics();
            VARTRACE(result);
            break;
        }
        case FUNCTION_ID_SENDPLAYBACKSPEED:
        {
            LocalSPM::GetThreadFactory().SetName("ID_SENDPLAYBACKSPEED");
            ETG_TRACE_USR1(("CMD: sendplaybackspeed:"));
            tPEPlaybackDirection playbackDirection = (tPEPlaybackDirection)cmdParm1;
            VARTRACE(playbackDirection);
            tPlaybackSpeed playbackSpeed = (tPlaybackSpeed)cmdParm2;
            VARTRACE(playbackSpeed);
            result = MediaPlayerInterface::GetInstance().SendPlaybackSpeed(IN playbackDirection, IN playbackSpeed);
            VARTRACE(result);
            break;

        }

        case FUNCTION_ID_ROOTDAEMONREQUEST_IAP_COMMON_WRITE:
        {
            LocalSPM::GetThreadFactory().SetName("ID_ROOTDAEMONREQUEST_IAP_COMMON_WRITE");
            ETG_TRACE_USR1(("CMD: ROOTDAEMONREQUEST_IAP_COMMON_WRITE"));
            CmdData result;

            tAllParameters parameters;
            //                const char* otgPath;
            //                const char* key;
            //                const char* value;
            //                strncpy_r(OUT otgPath, IN "/sys/class/udc", IN sizeof("/sys/class/udc"));
            //                otgPath = "/sys/class/udc";
            //                key = "usb1/vbus_auto";
            //                value = "disable";
            strncpy_r(OUT parameters, IN "/sys/class/udc", IN sizeof(parameters));
            strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
            strncat_r(OUT parameters, IN "usb1/vbus_auto", IN sizeof(parameters));
            strncat_r(OUT parameters, IN GMP_COMMANDS_DELIM, IN sizeof(parameters));
            strncat_r(OUT parameters, IN "disable", IN sizeof(parameters));
            result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_COMMON_WRITE, IN parameters);
            ETG_TRACE_USR3(("GMP_IAP_COMMON_WRITE executed, result.errorNo %d",(int)result.errorNo));
            break;

        }
        case FUNCTION_ID_ROOTDAEMONREQUEST_IAP_LOAD_MODULE:
        {
            LocalSPM::GetThreadFactory().SetName("ID_ROOTDAEMONREQUEST_IAP_LOAD_MODULE");
            ETG_TRACE_USR1(("CMD: ROOTDAEMONREQUEST_IAP_LOAD_MODULE"));

            CmdData result;
            tAllParameters parameters;
            memset(parameters ,0 ,sizeof(parameters));
            strncpy_r(OUT parameters, IN MODULE_NAME_CONFIGFS, IN sizeof(parameters));
            result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_LOAD_MODULE, IN parameters);
            ETG_TRACE_USR3(("GMP_IAP_LOAD_MODULE executed, result.errorNo %d",(int)result.errorNo));
            break;

        }

        case FUNCTION_ID_ROOTDAEMONREQUEST_IAP_UNLOAD_MODULE:
        {
            LocalSPM::GetThreadFactory().SetName("ID_ROOTDAEMONREQUEST_IAP_UNLOAD_MODULE");
            ETG_TRACE_USR1(("CMD: ROOTDAEMONREQUEST_IAP_UNLOAD_MODULE"));

            CmdData result;
            tAllParameters parameters;
            memset(parameters ,0 ,sizeof(parameters));
            strncpy_r(OUT parameters, IN MODULE_NAME_CONFIGFS, IN sizeof(parameters));
            result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_IAP_UNLOAD_MODULE, IN parameters);
            ETG_TRACE_USR3(("GMP_IAP_UNLOAD_MODULE executed, result.errorNo %d",(int)result.errorNo));
            break;

        }

        case FUNCTION_ID_ROOTDAEMONREQUEST_MANUAL_UDEVTRIGGER_ADDBLOCKDEVICES:
        {
            LocalSPM::GetThreadFactory().SetName("ID_ROOTDAEMONREQUEST_MANUAL_UDEVTRIGGER_ADDBLOCKDEVICES");
            ETG_TRACE_USR1(("CMD: ROOTDAEMONREQUEST_MANUAL_UDEVTRIGGER_ADDBLOCKDEVICES"));

            CmdData result;
            result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_CMD_MANUAL_UDEVRELOADRULES);
            ETG_TRACE_USR3(("GMP_CMD_MANUAL_UDEVRELOADRULES executed, result.errorNo %d",(int)result.errorNo));

            if(result.errorNo == ERR_NONE)
            {
                char *commandStr[] = {(char *)"/bin/udevadm",(char *)"trigger",(char *)"--action",(char *)"add",(char *)"--type=devices",(char *)"-s",(char *)"block",NULL};
                int retStatus = executeCommand(commandStr);
                if(0 == retStatus)
                {
                    ETG_TRACE_USR3(("executeCommand() success for udevadm trigger --action add"));
                }
                else
                {
                    ETG_TRACE_ERR(("executeCommand() failed for udevadm trigger --action add. Error:%s",strerror(retStatus)));
                }
            }
            break;
        }

        case FUNCTION_ID_ROOTDAEMONREQUEST_MANUAL_UDEVTRIGGER_REMOVEBLOCKDEVICES:
        {
            LocalSPM::GetThreadFactory().SetName("ID_ROOTDAEMONREQUEST_MANUAL_UDEVTRIGGER_REMOVEBLOCKDEVICES");
            ETG_TRACE_USR1(("ROOTDAEMONREQUEST_MANUAL_UDEVTRIGGER_REMOVEBLOCKDEVICES"));

            CmdData result;
            result = execRootCommand(FC_MEDIAPLAYER_CLIENT_NAME,GMP_CMD_MANUAL_UDEVRELOADRULES);
            ETG_TRACE_USR3(("GMP_CMD_MANUAL_UDEVRELOADRULES executed, result.errorNo %d",(int)result.errorNo));

            if(result.errorNo == ERR_NONE)
            {
                char *commandStr[] = {(char *)"/bin/udevadm",(char *)"trigger",(char *)"--action",(char *)"remove",(char *)"--type=devices",(char *)"-s",(char *)"block",NULL};
                int retStatus = executeCommand(commandStr);
                if(0 == retStatus)
                {
                    ETG_TRACE_USR3(("executeCommand() success for udevadm trigger --action remove"));
                }
                else
                {
                    ETG_TRACE_ERR(("executeCommand() failed for udevadm trigger --action remove. Error:%s",strerror(retStatus)));
                }
            }
            break;

        }

        case FUNCTION_ID_IPOD_APPLE_HID_COMMAND:{
            LocalSPM::GetThreadFactory().SetName("ID_IPOD_APPLE_HID_COMMAND");
            ETG_TRACE_USR1(("CMD: Apple HID command from HMI:"));

            tPlaybackHIDCommand playbackHIDCommand = (tPlaybackHIDCommand)cmdParm1;
            tBTButtonEvent keyEvent = (tBTButtonEvent)cmdParm2;
            VARTRACE(playbackHIDCommand);
            VARTRACE(keyEvent);
            result = MediaPlayerInterface::GetInstance().SendAppleHIDCommand(IN playbackHIDCommand, IN keyEvent);
            VARTRACE(result);
            break;
        }

        default: {
            ETG_TRACE_USR1(("CMD: unknown trace command (%u)", functionID));
            break;
        }
    }

}

void MediaplayerTraceInterface::vRegisterTTFISService()
{
    OSAL_trIOCtrlLaunchChannel  oTraceChannel;
    OSAL_tIODescriptor _fdTrace = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
    oTraceChannel.enTraceChannel = TR_TTFIS_IPODCONTROL;
    oTraceChannel.pCallback = (OSAL_tpfCallback)MediaplayerTraceInterface::vHandleTraceCmd;
    tS32 s32Error = OSAL_s32IOControl (_fdTrace, OSAL_C_S32_IOCTRL_CALLBACK_REG, (intptr_t) &oTraceChannel);
    if (OSAL_OK == s32Error)
    {
        ETG_TRACE_USR4(("Trace registered"));
    }
    else
    {
        ETG_TRACE_ERR(("Trace registration failed with error %d", s32Error));
    }
}

void MediaplayerTraceInterface::vDeRegisterTTFISService()
{
   OSAL_trIOCtrlLaunchChannel oTraceChannel;
   OSAL_tIODescriptor _fdTrace = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
   oTraceChannel.enTraceChannel = TR_TTFIS_IPODCONTROL;
   oTraceChannel.pCallback = (OSAL_tpfCallback)MediaplayerTraceInterface::vHandleTraceCmd;
   tS32 s32Error = OSAL_s32IOControl (_fdTrace, OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t) &oTraceChannel);
   if (OSAL_OK != s32Error)
   {
   }
   else
   {
   }
   OSAL_s32IOClose(_fdTrace);
}

void MediaplayerTraceInterface::vHandleTraceCmd(tU8 * cpu8Buffer)
{
    ETG_TRACE_USR4(("vHandleTraceCmd(%u) entered****", *cpu8Buffer));


    if ( cpu8Buffer == OSAL_NULL )
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    else
    {

        // TTFIS msg length
        tU8 u8MsgLen = cpu8Buffer[0];

        for( tU8 u8loop = 1; u8loop <= u8MsgLen; u8loop++ )
        {
            ETG_TRACE_USR4(("cpu8Buffer[%u]=0x%x", u8loop, cpu8Buffer[u8loop]));
        }

        if(u8MsgLen >= 1)  // Check if bytes 1,2 are available
        {
            // Calculate 16 bit TTFIS Command Code
            tU8 u8CmdCode = cpu8Buffer[1];
            int cmdParm1 = 0;
            int cmdParm2 = 0;
            int cmdParm3 = 0;
            char *cmdParamString = NULL;

            const size_t size = sizeof(tAllParameters);
            char *parameterString = new char[size]; //lint -e429

            ETG_TRACE_USR4(("CMD: Code=0x%x (%u) ****", u8CmdCode, u8CmdCode));

            if ((u8CmdCode == FUNCTION_ID_DIAGNOSISPLAYSONG) || //special handling for DIAGNOSISPLAYSONG
                (u8CmdCode == FUNCTION_ID_CREATEMEDIAPLAYERFILELISTEXT) ||
                (u8CmdCode == FUNCTION_ID_ALLOCATE) ||
                (u8CmdCode >= FUNCTION_ID_IPOD_APPCONTROL_CONNECT && u8CmdCode <= FUNCTION_ID_IPOD_APPCONTROL_CLOSE) ||
                (u8CmdCode >= FUNCTION_ID_IPOD_APPCONTROL_INITIATE_CALL && u8CmdCode <= FUNCTION_ID_IPOD_APPCONTROL_END_CALL))
            {
                if(u8MsgLen >= 2)
                {
                    cmdParm1 = (int)cpu8Buffer[2] + (int)(cpu8Buffer[3] << 8) + (int)(cpu8Buffer[4] << 16) + (int)(cpu8Buffer[5] << 24);
                    ETG_TRACE_USR4(("CMD: Parameter0=0x%x (%u) ****", cmdParm1, cmdParm1));
                }
                if(u8MsgLen >= 6)
                {
                    cmdParamString = (char*) &(cpu8Buffer[6]);
                    ETG_TRACE_USR4(("CMD: Parameter1=%s", cmdParamString));
                }
                SMF::Marshal(parameterString, size - 1, "it", cmdParm1, cmdParamString);
            }
            else // default handling
            {
                if(u8MsgLen >= 2)
                {
                    cmdParm1 = (int)cpu8Buffer[2] + (int)(cpu8Buffer[3] << 8) + (int)(cpu8Buffer[4] << 16) + (int)(cpu8Buffer[5] << 24);
                    ETG_TRACE_USR4(("CMD: Parameter0=0x%x (%u) ****", cmdParm1, cmdParm1));
                }
                if(u8MsgLen >= 6)
                {
                    cmdParm2 = (int)cpu8Buffer[6] + (int)(cpu8Buffer[7] << 8) + (int)(cpu8Buffer[8] << 16) + (int)(cpu8Buffer[9] << 24);
                    ETG_TRACE_USR4(("CMD: Parameter1=0x%x (%u) ****", cmdParm2, cmdParm2));
                }
                if(u8MsgLen >= 10)
                {
                    cmdParm3 = (int)cpu8Buffer[10] + (int)(cpu8Buffer[11] << 8) + (int)(cpu8Buffer[12] << 16) + (int)(cpu8Buffer[13] << 24);
                    ETG_TRACE_USR4(("CMD: Parameter2=0x%x (%u) ****", cmdParm3, cmdParm3));
                }

                SMF::Marshal(parameterString, size - 1, "iii", cmdParm1, cmdParm2, cmdParm3);

            }
            LocalSPM::GetThreadFactory().Do(IN pThis, IN u8CmdCode, IN parameterString);

        }
    }
}
