/**
 * @author Stefan Scherber
 *
 * Implementation of CCAMediaPlayerApplication
 *
 */


/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_APPLICATION
#include "trcGenProj/Header/FC_MediaPlayer_main.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_APPLICATION
#endif

#include "FC_MediaPlayer_main.h"
#ifdef VARIANT_S_FTR_ENABLE_MP_GENERIC_MPLAY_FI
#include "FC_MediaPlayer_service_GenMediaPlayer.h"
#include "FC_MediaPlayer_AudioRoutingHandler.h"
#include "CCAGenOutputWrapper.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_MOST_MPLAY_FI
#include "FC_MediaPlayer_service_MediaPlayer.h"
#include "CCAOutputWrapper.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_AVMAN
#include "FC_MediaPlayer_clienthandler_AVManager.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_AVRCP
#include "FC_MediaPlayer_clienthandler_BluetoothSettings.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_TELEPHONE
#include "FC_MediaPlayer_clienthandler_Telephone.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_GENTELEPHONE
#include "FC_MediaPlayer_clienthandler_GenTelephone.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_CONN_MOST_FI
#include "FC_MediaPlayer_clienthandler_GenBTSettings.h"
#endif
#if defined (VARIANT_S_FTR_ENABLE_MP_GMSPI)
#include "FC_MediaPlayer_clienthandler_SPI.h"
#endif
#if defined(VARIANT_S_FTR_ENABLE_MP_SPI)
#include "FC_MediaPlayer_clienthandler_GenSPI.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_CMA
#include "FC_MediaPlayer_clienthandler_CMA.h"
#endif
#include "FC_MediaPlayer_clienthandler_DeviceManager.h"
#ifdef VARIANT_S_FTR_ENABLE_MP_FAVMAN
#include "FC_MediaPlayer_clienthandler_FavoritesManager.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_GMLANGW
#include "FC_MediaPlayer_clienthandler_GMLANGateway.h"
#endif
#include "FC_MediaPlayer_clienthandler_IpodAuth.h"
#include "FC_MediaPlayer_service_AppControl.h"
#ifdef VARIANT_S_FTR_ENABLE_MP_SVG_LAYER
#include "FC_MediaPlayer_service_MediaPlayer_Layer_Sync.h"
#endif
#include "MediaPlayer_Trace_Interface.h"
#ifdef VARIANT_S_FTR_ENABLE_GM_DIAGNOSIS
#include "FC_MediaPlayer_DefSetHandler.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_VIDEOMANAGER
#include "FC_MediaPlayer_clienthandler_Videomanager.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_GM
#include "GMConfiguration.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_JAC
#include "JACConfiguration.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_SUZ
#include "SUZConfiguration.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_PSA
#include "PSAConfiguration.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_CAF
#include "CAFConfiguration.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_NIS
#include "NISConfiguration.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_SPM
#include "FC_MediaPlayer_clienthandler_SPM.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_CHY
#include "CHYConfiguration.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_ABSOLUTE_VOLUME_SUPPORT
#include "FC_MediaPlayer_AudioDbusHandlingProxy.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_INF4CV
#include "INF4CVConfiguration.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_SMART
#include "SMARTConfiguration.h"
#endif
// MediaPlayer core headers
#include "MediaPlayerInterface.h"
#include "GMCustomControl.h"


// necessary for DB-Manager simulation
#include "LocalSPM.h"

#include "FunctionTracer.h"


#define EVENT_SHUTDOWN_NAME "SHUTDOWN_FC_MEDIAPLAYER"
#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

// Include message framework interface (AMT, msgfw)
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//Include FI interface of used service
#define MOST_FI_S_IMPORT_INTERFACE_MOST_DEVPRJFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_DEVPRJFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_DEVPRJFI_ERRORCODES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_DEVPRJFI_SERVICEINFO
//Included for most_fi libraries Functions declaration.
#ifdef VARIANT_S_FTR_ENABLE_MP_MOST_MPLAY_FI
#include "most_fi_if.h"
#endif

// Devicemanager dbus client header
#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_DBUS_CLIENT
#include "VD_DeviceManager_Client_DBus.h"
#endif

#include <fcntl.h>
#include <syslog.h>
#include <sys/capability.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <adit-components/libsugc.h>


// Static self reference to be used in function callbacks.
fc_mediaplayer_tclApp* fc_mediaplayer_tclApp::m_poMainAppInstance = NULL;


/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

#define GMPINTERFACETHREAD_NAME      "GMPInterface"
#define GMPINTERFACETHREAD_PRIO      0
#define GMPINTERFACETHREAD_STACKSIZE (tS32)5000000


#define INTERFACEQUEUESIZE 150

#ifdef VARIANT_S_FTR_ENABLE_NIS
const char *gmpConfigLibSugc = "mediaplayer-service";//the config value for libsugc library. Added for NCG3D-49611
LIBSUGC_API libsugc_error_t errorcode= (libsugc_error_t) 0;
#endif
/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/


/*******************************************************************************
*
* FUNCTION: fc_mediaplayer_tclApp::vInterfaceThread()
*
* DESCRIPTION: Interface thread.
*
*              Functions waits for new messages in the interface queue and calls the ahl vOnNewMessage method
*              callbacks.
*
*
*******************************************************************************/
tVoid fc_mediaplayer_tclApp::vInterfaceThread()
{

    amt_tclBaseMessage msgObject;
    while (true) //endless lopp. The thread is never terminated
    {
        tU32 u32Prio;
        tS32 s32MsgCount = OSAL_s32MessageQueueWait(hInterfaceQueueID, (tU8*)msgObject.prGetOSALMsgHandle(), sizeof(OSAL_trMessage), &u32Prio, OSAL_C_TIMEOUT_FOREVER);
        if( s32MsgCount > 0 )
        {
            //set the shared mem base pointer
            msgObject.pu8SharedMemBase = OSAL_pu8MessageContentGet(*msgObject.prGetOSALMsgHandle(), OSAL_EN_READWRITE);
            if(msgObject.u8GetType() == AMT_C_U8_CCAMSGTYPE_SVCDATA)
            {
                amt_tclServiceData oServiceData(&msgObject);
                tU16 u16ServiceId = oServiceData.u16GetServiceID();
                tU16 u16FunctionID = oServiceData.u16GetFunctionID();
                ETG_TRACE_SYS(("fc_mediaplayer_tclApp: Received message with service %x and function %x from interface queue!", u16ServiceId, u16FunctionID));
            }
            else
            {
                ETG_TRACE_ERR(("fc_mediaplayer_tclApp: Invalid message type %x received from interface queue",msgObject.u8GetType()));
            }
            ahl_tclBaseOneThreadApp::vOnNewMessage(&msgObject);
        }
    }
}

/*******************************************************************************
*
* FUNCTION: fc_mediaplayer_tclApp::vStartInterfaceThread
*
* DESCRIPTION: Static interface thread start function
*
*
*
*******************************************************************************/
tVoid fc_mediaplayer_tclApp::vStartInterfaceThread (tVoid* pvArg)
{
    if (!pvArg)
        FATAL_M_ASSERT_ALWAYS();
    fc_mediaplayer_tclApp* pMediaPlayerApp = (fc_mediaplayer_tclApp*)pvArg;
    pMediaPlayerApp->vInterfaceThread();
}

/*******************************************************************************
*
* FUNCTION: fc_mediaplayer_tclApp::vOnNewMessage (amt_tclBaseMessage* poMessage)
*
* DESCRIPTION: Overwrites default vOnNewMessage function.
*
*              Stores received message in interface queue. If necessary a priorisation is possible
*              callbacks.
*
*
*******************************************************************************/
tVoid fc_mediaplayer_tclApp::vOnNewMessage (amt_tclBaseMessage* poMessage)
{
    OSAL_trMessage* pMsg = poMessage->prGetOSALMsgHandle();
    if (hInterfaceThreadID != OSAL_ERROR && hInterfaceQueueID != OSAL_C_INVALID_HANDLE)
    {
        if ((pMsg != NULL) && (pMsg->enLocation != OSAL_EN_MEMORY_INVALID))
        {
            if(poMessage->u8GetType() == AMT_C_U8_CCAMSGTYPE_SVCDATA)
            {
                amt_tclServiceData oServiceData(poMessage);
                tU16 u16ServiceId = oServiceData.u16GetServiceID();
                tU16 u16FunctionID = oServiceData.u16GetFunctionID();

                // special handling for STOPMEDIAPLAYBACK answer from SPI, because answer must be received during synchronous IIL call
#if defined (VARIANT_S_FTR_ENABLE_MP_GMSPI)
                if (CCA_C_U16_SRV_FB_DEVICEPROJECTION == u16ServiceId &&
                    MOST_DEVPRJFI_C_U16_STOPMEDIAPLAYBACK == u16FunctionID)
                {
                    tU8 u8OpCode = oServiceData.u8GetOpCode();
                    if (AMT_C_U8_CCAMSG_OPCODE_METHODRESULT == u8OpCode)
                    {
                        this->GetCCAClientHandlerSPI().onStopMediaPlaybackResult(&oServiceData);
                    }
                    else if (AMT_C_U8_CCAMSG_OPCODE_ERROR == u8OpCode)
                    {
                        this->GetCCAClientHandlerSPI().onStopMediaPlaybackError(&oServiceData);
                    }
                    else
                    {
                        ETG_TRACE_FATAL(("fc_mediaplayer_tclApp: Invalid opcode from SPI!"));
                    }

                }
                else  //default handling
                {
#endif
                    tU32  u32Prio = OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 5;
                    if ( u16ServiceId == CCA_C_U16_SRV_AUD_SRC_ROUTE ||
                         u16ServiceId == CCA_C_U16_SRV_STREAMROUTER ||
#ifdef VARIANT_S_FTR_ENABLE_SUZ //fix for CP not launched on startup
                         u16ServiceId == CCA_C_U16_SRV_SMARTPHONEINTEGRATION && (MIDW_SMARTPHONEINTFI_C_U16_DIPOROLESWITCHREQUIRED == u16FunctionID) ||
#endif
                         u16ServiceId == CCA_C_U16_SRV_FB_MEDIAPLAYER && (u16FunctionID == 0x100 || u16FunctionID == 0x101 || u16FunctionID == 0x102 || u16FunctionID == 0x103) ||
                         u16ServiceId == CCA_C_U16_SRV_IPOD_APP_CONTROL && (u16FunctionID == 0x109 || u16FunctionID == 0x110 || u16FunctionID == 0x120 || u16FunctionID == 0x121))
                    {
                        ETG_TRACE_SYS(("fc_mediaplayer_tclApp: Send message service %x and function %x with high priority to interface queue!", u16ServiceId, u16FunctionID));
                        u32Prio = OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 3;
                    }
                    else if ( u16ServiceId == CCA_C_U16_SRV_DEVICEMANAGER)
                    {
                        ETG_TRACE_SYS(("fc_mediaplayer_tclApp: Send message service %x and function %x with normal priority to interface queue!", u16ServiceId, u16FunctionID));
                        u32Prio = OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 4;
                    }
                    else
                    {
                        ETG_TRACE_SYS(("fc_mediaplayer_tclApp: Send message service %x and function %x with low priority to interface queue!", u16ServiceId, u16FunctionID));
                        u32Prio = OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 5;
                    }


                    if (OSAL_s32MessageQueuePost(hInterfaceQueueID, (tCU8*)pMsg, sizeof(OSAL_trMessage), u32Prio) == OSAL_ERROR)
                    {
                        ETG_TRACE_FATAL(("fc_mediaplayer_tclApp: Cannot send message into interface queue!"));
                    }
#if defined (VARIANT_S_FTR_ENABLE_MP_GMSPI)
                }
#endif
            }
            else
            {
                ETG_TRACE_ERR(("fc_mediaplayer_tclApp: Invalid message type %x received",poMessage->u8GetType()));
                if (OSAL_s32MessageQueuePost(hInterfaceQueueID, (tCU8*)pMsg, sizeof(OSAL_trMessage), OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST + 5) == OSAL_ERROR)
                {
                    ETG_TRACE_FATAL(("fc_mediaplayer_tclApp: Cannot send message into interface queue!"));
                }
            }


        }
    }
    else
    {
        ETG_TRACE_SYS(("fc_mediaplayer_tclApp: Interface does not exist. Call base class method!"));
        ahl_tclBaseOneThreadApp::vOnNewMessage(poMessage);
    }

}

/*******************************************************************************
*
* FUNCTION: ahl_fc_mediaplayer_tclApp::ahl_fc_mediaplayer_tclApp()
*
* DESCRIPTION: Constructor.
*
*              Initialize static self reference to be used in function
*              callbacks.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_mediaplayer_tclApp::fc_mediaplayer_tclApp():ahl_tclBaseOneThreadApp() //finished: 100%
{
  ENTRY

  // Create interface queue and thread
  hInterfaceQueueID = OSAL_C_INVALID_HANDLE;
  hInterfaceThreadID = OSAL_ERROR;

  // create interface queue
  if (OSAL_s32MessageQueueCreate("GMPInterfaceQueue", INTERFACEQUEUESIZE, sizeof(OSAL_trMessage), OSAL_EN_READWRITE, &hInterfaceQueueID)==OSAL_ERROR)
  {
    ETG_TRACE_FATAL(("fc_mediaplayer_tclApp: Interface queue cannot be created!"));
  }
  else
  {
      // create interface thread

      OSAL_trThreadAttribute  rAttr = { const_cast<tString>(GMPINTERFACETHREAD_NAME),
                                        GMPINTERFACETHREAD_PRIO,
                                        GMPINTERFACETHREAD_STACKSIZE,
                                       (OSAL_tpfThreadEntry)vStartInterfaceThread /*entry function*/,
                                       (tVoid *)this /*arg to entry function*/ };

/*
      rAttr.szName = (const char*) GMPINTERFACETHREAD_NAME; //lint !e158
      rAttr.s32StackSize = GMPINTERFACETHREAD_STACKSIZE; // not required
      rAttr.u32Priority = GMPINTERFACETHREAD_PRIO; // not required
      rAttr.pfEntry = (OSAL_tpfThreadEntry)vStartInterfaceThread;
      rAttr.pvArg = (tPVoid)this;
*/

      hInterfaceThreadID = OSAL_ThreadSpawn(&rAttr);
      if ( hInterfaceThreadID == OSAL_ERROR )
      {
        ETG_TRACE_FATAL(("fc_mediaplayer_tclApp: Interface thread cannot be created!"));
      }
  }

  fc_mediaplayer_tclApp::m_poMainAppInstance = this;
  #ifdef VARIANT_S_FTR_ENABLE_MP_GENERIC_MPLAY_FI
  m_poAudioRoutingHandler = NULL;
  #endif
  #ifdef VARIANT_S_FTR_ENABLE_MP_AVMAN
  m_poClientHandlerAVManager = NULL;
  #endif
  #ifdef VARIANT_S_FTR_ENABLE_MP_AVRCP
  m_poClientHandlerBTSettings = NULL;
  #endif
  #ifdef VARIANT_S_FTR_ENABLE_CONN_MOST_FI
  m_poClientHandlerGenBTSettings = NULL;
  #endif
  #ifdef VARIANT_S_FTR_ENABLE_MP_TELEPHONE
  m_poClientHandlerTelephone = NULL;
  #endif
  #ifdef VARIANT_S_FTR_ENABLE_MP_GENTELEPHONE
  m_poClientHandlerGenTelephone = NULL;
  #endif
  #ifdef VARIANT_S_FTR_ENABLE_MP_CMA
  m_poClientHandlerCMA = NULL;
  #endif
  m_poClientHandlerDeviceManager = NULL;
  #ifdef VARIANT_S_FTR_ENABLE_MP_GMLANGW
  m_poClientHandlerGMLANGateway = NULL;
  #endif
  #if defined (VARIANT_S_FTR_ENABLE_MP_GMSPI) || defined(VARIANT_S_FTR_ENABLE_MP_SPI)
  m_poClientHandlerSPI = NULL;
  #endif
  #ifdef VARIANT_S_FTR_ENABLE_MP_FAVMAN
  m_poClientHandlerFavoritesManager = NULL;
  #endif
  m_poClientHandlerIPodAuthentication = NULL;
  m_poMediaPlayer = NULL;
  m_poAppControl = NULL;
  #ifdef VARIANT_S_FTR_ENABLE_MP_SVG_LAYER
  m_poLayerSync = NULL;
  #endif
  #ifdef VARIANT_S_FTR_ENABLE_GM_DIAGNOSIS
  m_poDefSetHandler = NULL;
  m_poDiaglibService = NULL;
  #endif
  #ifdef VARIANT_S_FTR_ENABLE_MP_SPM
  m_poClientHandlerSPM = NULL;
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_VIDEOMANAGER
m_poVideoManagerClientHandler = NULL;
#endif


  m_poCustomControl = NULL;
  m_poOutputWrapper = NULL;
  m_poConfiguration = NULL;
  mTraceInterface = NULL;
}


/*******************************************************************************
*
* FUNCTION: ahl_fc_mediaplayer_tclApp::~ahl_fc_mediaplayer_tclApp()
*
* DESCRIPTION: Destructor.
*
*              Invalidate static self reference.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_mediaplayer_tclApp::~fc_mediaplayer_tclApp() //finished: 100%
{
    ENTRY
    fc_mediaplayer_tclApp::m_poMainAppInstance = NULL;
}

tBool fc_mediaplayer_tclApp::bRequestTimeOnStateChangeAutomatically() const
{
    ENTRY
    return TRUE;
}

/*******************************************************************************
*
* FUNCTION: tBool fc_mediaplayer_tclApp::bOnInit()
*
* DESCRIPTION: This function is called by the CCA framework before starting any
*              CCA message related communication action. As default this
*              function always returns TRUE. The user has to implement all his
*              local application initialization (create client and service
*              handler, create worker threads, allocate application memory,...).
*              If returns TRUE, initialization could be successfully performed
*              and framework will register application, else, a reset of the
*              system is forced immediately.
*
*              This function is the counterpart of vOnApplicationClose().
*
* PARAMETER: None.
*
* RETURNVALUE: TRUE  = Application successfully initialized.
*              FALSE = Application NOT successfully initialized.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::bOnInit().
*******************************************************************************/
tBool fc_mediaplayer_tclApp::bOnInit() //finished: 80 %
{
    ENTRY
    tBool bSuccess = TRUE;

    #ifdef VARIANT_S_FTR_ENABLE_MP_GENERIC_MPLAY_FI
    m_poAudioRoutingHandler = OSAL_NEW fc_mediaplayer_tclAudioRoutingHandler(this);
    if (NULL == m_poAudioRoutingHandler)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }
    #endif
    #ifdef VARIANT_S_FTR_ENABLE_MP_VIDEOMANAGER
    m_poVideoManagerClientHandler = OSAL_NEW fc_mediaplayer_tclClientHandler_Videomanager(this);
    if (NULL == m_poVideoManagerClientHandler)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }
    #endif

    #ifdef VARIANT_S_FTR_ENABLE_MP_AVMAN
    m_poClientHandlerAVManager = OSAL_NEW fc_mediaplayer_tclClientHandler_AVManager(this);
    if (NULL == m_poClientHandlerAVManager)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }
    #endif

    #ifdef VARIANT_S_FTR_ENABLE_MP_AVRCP
    m_poClientHandlerBTSettings = OSAL_NEW fc_mediaplayer_tclClientHandler_BTSettings(this);
    if (NULL == m_poClientHandlerBTSettings)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }
    #endif
    #ifdef VARIANT_S_FTR_ENABLE_MP_SPM
    m_poClientHandlerSPM  = OSAL_NEW fc_mediaplayer_tclClientHandler_SPM(this);
    if (NULL == m_poClientHandlerSPM)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }
    #endif

    #ifdef VARIANT_S_FTR_ENABLE_CONN_MOST_FI
    m_poClientHandlerGenBTSettings = OSAL_NEW fc_mediaplayer_tclClientHandler_GenBTSettings(this);
    if (NULL == m_poClientHandlerGenBTSettings)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }
    #endif

    #ifdef VARIANT_S_FTR_ENABLE_MP_TELEPHONE
    m_poClientHandlerTelephone = OSAL_NEW fc_mediaplayer_tclClientHandler_Telephone(this);
    if (NULL == m_poClientHandlerTelephone)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }
    #endif

    #ifdef VARIANT_S_FTR_ENABLE_MP_GENTELEPHONE
    m_poClientHandlerGenTelephone = OSAL_NEW fc_mediaplayer_tclClientHandler_GenTelephone(this);
    if (NULL == m_poClientHandlerGenTelephone)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }
    #endif

    #ifdef VARIANT_S_FTR_ENABLE_MP_CMA
    m_poClientHandlerCMA = OSAL_NEW fc_mediaplayer_tclClientHandler_CMA(this);
    if (NULL == m_poClientHandlerCMA)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }
    #endif

    m_poClientHandlerDeviceManager = OSAL_NEW fc_mediaplayer_tclClientHandler_DeviceManager(this);
    if (NULL == m_poClientHandlerDeviceManager)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }

    #ifdef VARIANT_S_FTR_ENABLE_MP_FAVMAN
    m_poClientHandlerFavoritesManager = OSAL_NEW fc_mediaplayer_tclClientHandler_FavoritesManager(this);
    if (NULL == m_poClientHandlerFavoritesManager)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }
    #endif

    m_poClientHandlerIPodAuthentication = OSAL_NEW fc_mediaplayer_tclClientHandler_IPodAuthentication(this);
    if (NULL == m_poClientHandlerIPodAuthentication)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }

    #ifdef VARIANT_S_FTR_ENABLE_MP_GMLANGW
    m_poClientHandlerGMLANGateway = OSAL_NEW fc_mediaplayer_tclClientHandler_GMLANGateway(this);
    if (NULL == m_poClientHandlerGMLANGateway)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }
    #endif

    #if defined (VARIANT_S_FTR_ENABLE_MP_GMSPI) || defined(VARIANT_S_FTR_ENABLE_MP_SPI)
    m_poClientHandlerSPI = OSAL_NEW fc_mediaplayer_tclClientHandler_SPI(this);
    if (NULL == m_poClientHandlerSPI)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }
    #endif

    #ifdef VARIANT_S_FTR_ENABLE_GM_DIAGNOSIS
    m_poDiaglibService = OSAL_NEW diaglib::tclServiceDiaglib(this, 1);
    if (NULL == m_poDiaglibService)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }

    m_poDefSetHandler = OSAL_NEW FC_MediaPlayer_tclDefSetHandler(m_poDiaglibService);
    if (NULL == m_poDefSetHandler)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }
    #endif

    m_poMediaPlayer = OSAL_NEW fc_mediaplayer_tclService_MediaPlayer(this);
    if (NULL == m_poMediaPlayer)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }

    m_poAppControl = OSAL_NEW fc_mediaplayer_tclService_AppControl(this);
    if (NULL == m_poAppControl)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }

    #ifdef VARIANT_S_FTR_ENABLE_MP_SVG_LAYER
    m_poLayerSync = OSAL_NEW fc_mediaplayer_tclService_MediaPlayer_Layer_Sync(this);
    if (NULL == m_poLayerSync)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }
    #endif

    #ifdef VARIANT_S_FTR_ENABLE_ABSOLUTE_VOLUME_SUPPORT
    m_poAudioDbusHandlingProxy = OSAL_NEW AudioDbusHandlingProxy();
    if (NULL == m_poAudioDbusHandlingProxy)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }
    #endif

    MediaPlayerInterface::GetInstance().UnregisterAll();

    /* Create custom specific configuration component. Build system (xml) chooses the correct file */
    CustomerConfiguration* configuration = new CustomerConfiguration(COMPONENT_ID_CONFIGURATION);
    if (NULL == configuration)
    {
        bSuccess = FALSE;
        delete configuration;
        FATAL_M_ASSERT_ALWAYS();
    }
    else
    {
        MediaPlayerInterface::GetInstance().Register(configuration);
    }

    GMCustomControl* control = new GMCustomControl(COMPONENT_ID_CUSTOMCONTROL);
    if (NULL == control)
    {
        bSuccess = FALSE;
        delete control;
        FATAL_M_ASSERT_ALWAYS();
    }
    else
    {
        MediaPlayerInterface::GetInstance().Register(control);
    }

    m_poOutputWrapper = new CCAOutputWrapper(COMPONENT_ID_OUTPUTWRAPPER, this);
    if (NULL == m_poOutputWrapper)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }
    else
    {
        MediaPlayerInterface::GetInstance().Register(m_poOutputWrapper);
    }

    tResult result = MediaPlayerInterface::GetInstance().CreateMediaPlayer();
    if (0 != result)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }

    // create Trace interface to test IPOD
    mTraceInterface = new MediaplayerTraceInterface();


    return bSuccess;
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_mediaplayer_tclApp::vOnApplicationClose()
*
* DESCRIPTION: This function is called by the CCA framework to indicate the
*              imminent shutdown of the application.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnApplicationClose().
*******************************************************************************/
tVoid fc_mediaplayer_tclApp::vOnApplicationClose() //finished:100%
{
    ENTRY
    ahl_tclBaseOneThreadApp::vOnApplicationClose();
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_mediaplayer_tclApp::vOnLoadSettings()
*
* DESCRIPTION: This function is called by the CCA framework to trigger the
*              loading of last mode settings. The user has to load the
*              previously stored last mode settings from persistent memory.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnLoadSettings().
*******************************************************************************/
tVoid fc_mediaplayer_tclApp::vOnLoadSettings() //finished: 100%
{
    ENTRY
    tResult result = MediaPlayerInterface::GetInstance().StateChangeNormal();
    if (0 != result)
        FATAL_M_ASSERT_ALWAYS();
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_mediaplayer_tclApp::vOnSaveSettings()
*
* DESCRIPTION: This function is called by the CCA framework to trigger the
*              storage of last mode settings. The user has to store the last
*              mode settings to persistent memory.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnSaveSettings().
*******************************************************************************/
tVoid fc_mediaplayer_tclApp::vOnSaveSettings() //finished: 100%
{
    ENTRY
    tResult result = MediaPlayerInterface::GetInstance().StateChangeOff();
    if (0 != result)
        FATAL_M_ASSERT_ALWAYS();
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_mediaplayer_tclApp::vOnTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called by the CCA framework on the expiration
*              of a previously via function bStartTimer() started timer. The
*              expired timer is forwarded to the respective service or
*              client-handler via a call of vProcessTimer().
*
*              The function is called from this applications context and
*              therefore no interthread programming rules must be considered
*              and the application methods and/or member variables can be
*              accessed without using the static self reference
*              'm_poMainAppInstance'.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnTimer().
*******************************************************************************/
tVoid fc_mediaplayer_tclApp::vOnTimer(tU16 /*u16TimerId*/) //finished: 100%
{
    // Timer is currently not started
    ENTRY
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_mediaplayer_tclApp::vOnLoopback
*                 (tU16 u16ServiceID, amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called by the CCA framework if a message from
*              one if this applications services is received (so called self
*              or loopback messages). The message is forwarded to the respective
*              service via a call of vOnLoopbackService().
*
* PARAMETER: [IN] u16ServiceID = Identifier of the service from where the
*                                message was sent.
*
*            [IN] poMessage = Message object.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnLoopback().
*******************************************************************************/
tVoid fc_mediaplayer_tclApp::vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* /*poMessage*/) //finished: 100%
{
    ENTRY

    switch(u16ServiceID)
    {
        case CCA_C_U16_SRV_FB_MEDIAPLAYER:
        {
            if(NULL != m_poMediaPlayer)
            {
                //m_poMediaPlayer->vOnLoopbackService(poMessage);
            }
            else
            {
                NORMAL_M_ASSERT_ALWAYS();
            }
            break;
        }
        default:
        {
            ETG_TRACE_ERR(("vOnLoopback(). Unknown ServiceID %u.", u16ServiceID));
        }
    }
}

/*
* Function is called by fc_mediaplayer_tclClientHandler_CMA and fc_mediaplayer_tclClientHandler_FavoritesManager
* Checks if MediaPlayer is visible on MOST by calling MediaplayerServiceVisible of fc_mediaplayer_tclClientHandler_CMA and
* if FavoriteManager service is available by calling bIfServiceAvailable of  fc_mediaplayer_tclClientHandler_FavoritesManager.
* If both functions return TRUE function RegisterFavoritesProvider of fc_mediaplayer_tclClientHandler_FavoritesManager
* is called
*
*/
#if defined(VARIANT_S_FTR_ENABLE_MP_CMA) && defined(VARIANT_S_FTR_ENABLE_MP_FAVMAN)
tVoid fc_mediaplayer_tclApp::RegisterFavoriteProvider() //finished: 50%
{
    ENTRY
    if (m_poClientHandlerCMA && m_poClientHandlerFavoritesManager && TRUE == m_poClientHandlerCMA->MediaplayerServiceVisible() && TRUE == m_poClientHandlerFavoritesManager->bIfServiceAvailable())
    {
        m_poClientHandlerFavoritesManager->RegisterFavoritesProvider();
    }
}
#endif

/*
Dummy implementation of IPodControl application. Can be removed as soon as the regsitry is adapted to Generc MediaPlayer
*/

class fc_ipodcontrol_tclApp : public ahl_tclBaseOneThreadApp
{
    public:
    fc_ipodcontrol_tclApp();
    ~fc_ipodcontrol_tclApp();
    tBool bOnInit();
    tVoid vOnLoadSettings();
    tVoid vOnSaveSettings();
};

fc_ipodcontrol_tclApp::fc_ipodcontrol_tclApp():ahl_tclBaseOneThreadApp()
{
}


fc_ipodcontrol_tclApp::~fc_ipodcontrol_tclApp()
{
}

tBool fc_ipodcontrol_tclApp::bOnInit()
{
       return TRUE;
}

tVoid fc_ipodcontrol_tclApp::vOnLoadSettings()
{
}

tVoid fc_ipodcontrol_tclApp::vOnSaveSettings()
{
}

//#ifdef SYSTEM_S_USE_BPSTL
//extern tBool exh_bInitExceptionHandling(tVoid);
//#endif

extern "C" OSAL_DECL tS32 vStartApp(tS32 cPar, tString aPar[]) // finished: 50%
{
    ENTRY

    (tVoid)cPar;
    (tVoid)aPar;
    tS32 bRetVal = OSAL_OK;
    OSAL_tEventHandle  hEvShutdown = 0;
    OSAL_tEventMask    hEvRequest  = 0x00000001;
#ifdef VARIANT_S_FTR_ENABLE_NIS
     //fix for NCG3D-49611
     //the below api(if successful) will give requested capabilities specified in /etc/libsugc.conf and  also
     //change the user to username specified in the conf file
     //libsugc library documentation is attached in the ticket
     errorcode = libsugc_apply_cfg(gmpConfigLibSugc);//the config value "mediaplayer-service" should be same as in the config file
     if(errorcode == LIBSUGC_OK)
     {
         ETG_TRACE_FATAL(("fc_mediaplayer_tclApp libsugc_apply_cfg Successful"))
     }
     else
     {
         ETG_TRACE_FATAL(("fc_mediaplayer_tclApp libsugc_apply_cfg Failed with error code %d",errorcode))
#ifdef OSAL_GEN4
         NORMAL_M_ASSERT_ALWAYS();
#else
         FATAL_M_ASSERT_ALWAYS();
#endif
     }
#endif

    /* set the effective user and group ID */
    setlogmask(LOG_UPTO(LOG_INFO));
    if(setregid(getegid(), getegid()) != 0)
    {
        syslog(LOG_ERR, "fc_mediaplayer_tclApp: setregid(%d) failed: %s", getegid(), strerror(errno));
    } else {
        syslog(LOG_INFO, "fc_mediaplayer_tclApp: setregid(%d) ok", getegid());
    }
    if(setreuid(geteuid(), geteuid()) != 0)
    {
        syslog(LOG_ERR, "fc_mediaplayer_tclApp: setreuid(%d) failed: %s", getegid(), strerror(errno));
    } else {
        syslog(LOG_INFO, "fc_mediaplayer_tclApp: setreuid(%d) ok", getegid());
    }

    et_vTraceOpen();
    et_vTraceBuffer(TR_TTFIS_SYSMANAGER, TR_LEVEL_DATA, 9, "START MEDIAPLAYER ");
    scd_init();

    if (OSAL_s32EventCreate(EVENT_SHUTDOWN_NAME, &hEvShutdown) == OSAL_ERROR)
    {
        ETG_TRACE_FATAL(("fc_mediaplayer_tclApp: Creation of SPM shutdown event failed!!!"));
        NORMAL_M_ASSERT_ALWAYS();
    }

    // Activate Exception Handling
    /*bRetVal = exh_bInitExceptionHandling();
    if (bRetVal != TRUE)
    {
        ETG_TRACE_FATAL(("fc_mediaplayer_tclApp: exh_bInitExceptionHandling failed"));
        NORMAL_M_ASSERT_ALWAYS();
    }*/

#ifdef VARIANT_S_FTR_ENABLE_PROCESS_READS_ITS_REGISTRY
    OSAL_tIODescriptor  regHandle;
    if((regHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY,OSAL_EN_READWRITE)) != OSAL_ERROR )
    {
        //[GMP] take care that  ai_mediaplayer/config/packages/pkg_mediaplayer.xml installs this
        //[MMP] take care that ai_mediaplayer/MultiMediaPlayer/2_config/packages/pkg_mediaplayer.xml installs this
        if((OSAL_s32IOControl(regHandle, OSAL_C_S32_IOCTRL_BUILD_REG,(intptr_t) "/dev/root/opt/bosch/base/registry/ccamediaplayer.reg")) == OSAL_OK)
        {
            ETG_TRACE_FATAL(("[OK]  REGISTRY loaded: /dev/root/opt/bosch/base/registry/ccamediaplayer.reg"));
        }
        else
        {
            ETG_TRACE_FATAL(("[NOK] REGISTRY failed to load: /dev/root/opt/bosch/base/registry/ccamediaplayer.reg"));
            ETG_TRACE_ERRMEM(("[NOK] REGISTRY failed to load: /dev/root/opt/bosch/base/registry/ccamediaplayer.reg"));
        }
    }
    OSAL_s32IOClose(regHandle);
#endif




    fc_mediaplayer_tclApp *poMediaPlayerApp = new fc_mediaplayer_tclApp;
    if (NULL != poMediaPlayerApp)
    {
        if (!poMediaPlayerApp->bInitInstance(0, CCA_C_U16_APP_MEDIAPLAYER))
        {
            ETG_TRACE_FATAL(("poMediaPlayerApp->bInitInstance() failed!"));
            FATAL_M_ASSERT_ALWAYS();
        }
        else
        {
            ETG_TRACE_SYS(("poMediaPlayerApp->bInitInstance() success!"));
        }
    }

    fc_ipodcontrol_tclApp *poIPODControlApp = new fc_ipodcontrol_tclApp;

    if (NULL != poIPODControlApp)
    {
        if (!poIPODControlApp->bInitInstance(0, CCA_C_U16_APP_IPODCONTROL))
        {
            ETG_TRACE_FATAL(("poIPODControlApp->bInitInstance() failed!"));
            FATAL_M_ASSERT_ALWAYS();
        }
        else
        {
            ETG_TRACE_SYS(("poIPODControlApp->bInitInstance() success!"));
        }
    }

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_DBUS_CLIENT
    DeviceManagerDBusClient::GetInstance().InitDBusClient();
#endif

    // Wait for Shutdown-Signal. However, will never called in GM system
    OSAL_s32EventWait(hEvShutdown, hEvRequest, OSAL_EN_EVENTMASK_OR, OSAL_C_TIMEOUT_FOREVER, &hEvRequest);
    if (poMediaPlayerApp != NULL)
    {
        poMediaPlayerApp->vDeinitInstance();
        delete poMediaPlayerApp;
    }

#ifdef VARIANT_S_FTR_ENABLE_DEVMGR_DBUS_CLIENT
    DeviceManagerDBusClient::GetInstance().StopDBusClient();
#endif

    OSAL_s32EventClose(hEvShutdown);
    OSAL_s32EventDelete(EVENT_SHUTDOWN_NAME);
    et_vTraceClose();
    delete poIPODControlApp;
    return OSAL_OK;
}

