
#ifndef __FC_MEDIAPLAYER_SERVICE_APPCONTROLFI_H__
#define __FC_MEDIAPLAYER_SERVICE_APPCONTROLFI_H__

/**
 * @defgroup CCAServiceAppControl CCAServiceAppControl
 * @ingroup MediaPlayer
 * @author Stefan Scherber
 *
 * Public interface for CCAServiceAppControl
 * @{
 */

// Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION_DEMO
#include "ahl_if.h"

// Include message framework interface (AMT, msgfw).
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

//Include public FI interface of this service.
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_APPCONTROLFI_FUNCTIONIDS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_APPCONTROLFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_APPCONTROLFI_ERRORCODES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_APPCONTROLFI_SERVICEINFO
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_APPCONTROLFI_STDVISITORS

#include "mplay_fi_if.h"
#include "TypeDefinitions.h"


class ahl_tclBaseOneThreadService;
/**
 * This class implements the CCAServiceAppControl component.
 */
class fc_mediaplayer_tclService_AppControl:public ahl_tclBaseOneThreadService
{
private:
    fc_mediaplayer_tclApp* m_poMainAppInstance;

    tUserContext userContextForRequestAudio;
    tUSBSerial m_sCurrentRoleSwitchUSBSerialNumber;

public:

    /**
    * Constructor of the service class
    * @param[in] poMainAppl Pointer to the CCA application
    * @return
    */
    fc_mediaplayer_tclService_AppControl(fc_mediaplayer_tclApp* poMainAppl);

    /**
    * Destructore of the service class
    * @return
    */
    virtual ~fc_mediaplayer_tclService_AppControl();

    void updateClients(tU16 u16FunctionId)
    {
        eUpdateClients(u16FunctionId);
    };

private:

    /**
    * This function is called when method Connect is received
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onConnect(amt_tclServiceData* poMessage);

    /**
    * This function is called when method Command is received
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onCommand(amt_tclServiceData* poMessage);

    /**
    * This function is called when method Close is received
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onClose (amt_tclServiceData* poMessage);

    /**
    * This function is called when method StartAudio is received
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onStartAudio (amt_tclServiceData* poMessage);

    /**
    * This function is called when method StopAudio is received
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onStopAudio (amt_tclServiceData* poMessage);


    /**
    * This function is called when method CommandToApp is received
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onCommandToApp (amt_tclServiceData* poMessage);

    /**
    * This function is called when method GetMediaObjectAlbumArtInfo is received
    * This function stores sourceID, registerID, functionID and cmdCounter in a variable of type tUserContext
    * and calls GetMediaObjectAlbumArtInfo of DataProvider with albumArt, sizeX=160, sizeY=160, mimeType=MMT_PNG and the variable with the userContext.
    * The answer message is NOT sent back within this function.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onGetMediaObjectAlbumArtInfo (amt_tclServiceData* poMessage);

    /**
    * This function is called when method GetMediaObjectAlbumArt is received
    * This function stores sourceID, registerID, functionID and cmdCounter in a variable of type tUserContext
    * and calls GetMediaObjectAlbumArt of DataProvider with albumArt, sizeX=160, sizeY=160, mimeType=MMT_PNG and the variable with the userContext.
    * The answer message is NOT sent back within this function.
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onGetMediaObjectAlbumArt (amt_tclServiceData* poMessage);


public:

    /**
     * This function is called by MediaPlayer core when the result of GetMediaObjectAlbumArtInfo is calculated
     * The function convert parameters, and sends the answer to the client stored in userContext
     * Convert mimeType enum to string ("image/png", "image/x-ms-bmp", "image/gif", "image/jpeg")
     * @param[in] mimeType MIME image subtype
     * @param[in] size size of image in bytes
     * @param[in] userContext client information
     * @return < 0: error, = 0: OK
     */
    tResult SendGetMediaObjectAlbumArtInfoAnswer(tMimeType mimeType, tImageSize size, tUserContext userContext);


    /**
     * This function is called by MediaPlayer when the result of GetMediaObjectAlbumArt is calculated
     * The function convert parameters, and sends the answer to the client stored in userContext
     * @param[in] imageData image data
     * @param[in] imageSize size of image in bytes
     * @param[in] userContext  client information
     * @return < 0: error, = 0: OK
     */
    tResult SendGetMediaObjectAlbumArtAnswer(tImageData imageData, tImageSize imageSize, tUserContext userContext);

    /**
     * This function is called by MediaPlayer when the result of Command is calculated
     * @param[in] mountPoint a string containing the iPhone device HID name.
     * @param[in] appName a string containing App name of the IAP application.
     * @param[in] sessionID The session ID of the connected IAP application.
     * @param[in] userContext  client information
     * @return < 0: error, = 0: OK
     */
    tResult SendCommandAnswer(const tMountPoint mountPoint, const tAppName appName, const tSessionID sessionID,const tUserContext userContext);

    /**
     * This function is called by MediaPlayer when an error message shall be sent back
     * The function sends an error messgage back to client to the client stored in userContext
     * @param[in] userContext  client information
     * @return < 0: error, = 0: OK
     */
    tResult SendError(tErrorCode errorCode, tUserContext userContext);


    tVoid onDiPOActiveDevice (amt_tclServiceData* poMessage);
    tVoid onDiPORoleSwitchRequest (amt_tclServiceData* poMessage); //Roadmap 15014_MySpinSupport_without_CarPlay
    tVoid onDiPOTransferGPSData (amt_tclServiceData* poMessage);
    tVoid onDiPOTransferDRData (amt_tclServiceData* poMessage);

    tVoid onDiPORequestAudioDevice (amt_tclServiceData* poMessage);
    tVoid onDiPOReleaseAudioDevice (amt_tclServiceData* poMessage);

    tVoid onDiPORequestPlaybackAction(amt_tclServiceData* poMessage); // Roadmap 15014_MySpinSupport_without_CarPlay

    tVoid onDiPOStartIAP2OverCarplayWiFi(amt_tclServiceData* poMessage); //CARPLAY WIFI:

    tVoid onDiPOStartRG (amt_tclServiceData* poMessage);
    tVoid onDiPOStopRG (amt_tclServiceData* poMessage);
    tVoid onDiPOStartRG2 (amt_tclServiceData* poMessage);
    tVoid onDiPOStopRG2 (amt_tclServiceData* poMessage);
    tVoid onDiPOSetRGDisplayComponentInfo(amt_tclServiceData* poMessage);

    /**
     * This function is handler for CCA message DIPOSETCALLCONTROLSCONFIGURATION to set the Route Guidance Display Configurations in Media Player.
     * @param[in] poMessage; cca message data.
     * @return void
     */
    tVoid onDiPOSetCallControlsConfiguration (amt_tclServiceData* poMessage);

    /**
     * This function is handler for CCA message DIPOINITIATECALL to send the InitiateCall message to Apple device.
     * @param[in] poMessage; cca message data.
     * @return void
     */
    tVoid onDiPOInitiateCall (amt_tclServiceData* poMessage);

     /**
     * This function is handler for CCA message DIPOACCEPTCALL to send the AcceptCall message to Apple device.
     * @param[in] poMessage; cca message data.
     * @return void
    */
    tVoid onDiPOAcceptCall (amt_tclServiceData* poMessage);

     /**
     * This function is handler for CCA message DIPOENDCALL to send the EndCall message to Apple device.
     * @param[in] poMessage; cca message data.
     * @return void
     */
    tVoid onDiPOEndCall (amt_tclServiceData* poMessage);

    /**
     * This function is handler for CCA message SWAPCALLS to send the SwapCall message to Apple device.
     * use onDiPOSwapCalls instead of this function.
     * @param[in] poMessage; cca message data.
     * @return void
     */
    tVoid onSwapCalls(amt_tclServiceData* poMessage);

    /**
     * This function is handler for CCA message DIPOSWAPCALLS to send the AcceptCall message to Apple device.
     * @param[in] poMessage; cca message data.
     * @return void
     */
    tVoid onDiPOSwapCalls(amt_tclServiceData* poMessage);

    /**
     * This function is handler for CCA message DIPOREQUESTBLUETOOTHAUDIODEVICE to request or release BT audio device.
     * @param[in] poMessage; cca message data.
     * @return void
     */
     tVoid onDiPORequestBluetoothAudioDevice(amt_tclServiceData* poMessage);

    tResult SendDiPOActiveDeviceAnswer(const tDiPOResponse diPOResponse, const tUserContext userContext);
    tResult SendDiPORoleSwitchRequestAnswer(const tDiPOResponse diPOResponse, const tUserContext userContext);
    tResult SendDiPOTransferGPSDataAnswer(const tDiPOResponse diPOResponse, const tUserContext userContext);
    tResult SendDiPOTransferDRDataAnswer(const tDiPOResponse diPOResponse, const tUserContext userContext);

    tResult SendDiPORequestAudioDeviceAnswer(const tDeviceID deviceID, const tAudioOutputDevice audioOutputDevice);
    tResult SendDiPORequestAudioDeviceError(const tDeviceID deviceID);


protected:

    void ConvertDeviceInfoToAppControl(mplay_fi_tcl_DiPODeviceInfoItem &appControlDeviceInfo ,const tDeviceInfo &deviceInfo);
    void ConvertDeviceTagToAppControl(tU8 &deviceTag, const tDeviceID deviceID);
    void ConvertDeviceTypeToAppControl(mplay_fi_tcl_e8_DiPODeviceType &appControlDeviceType, const tDeviceType deviceType);
    void ConvertDiPOResponseToAppControl(mplay_fi_tcl_e8_DiPOResponse &diPOResponseAppControl, const tDiPOResponse diPOResponse);
    void ConvertDiPORoleStatusToInternal(tDiPORoleStatus &diPORoleStatusInternal, const mplay_fi_tcl_e8_DiPORoleStatus diPORoleStats); //Roadmap 15014_MySpinSupport_without_CarPlay
    void ConvertConnectionTypeToAppControl(mplay_fi_tcl_e8_DiPOConnectionType &appControlConnectionType, const tConnectionType connectionType);
    void ConvertAppLaunchOptionToInternal(tAppLaunchOption &appLaunchOptionInternal, const mplay_fi_tcl_e8_AppLaunchOption appLaunchOption); //Roadmap 15014_MySpinSupport_without_CarPlay
    void ConvertDiPOCapsToAppControl(mplay_fi_tcl_e8_DiPOCaps &diPOCapsAppControl, const tDiPOCaps diPOCaps);
    void ConvertPlaybackActionToInternal(tPlaybackAction &internalPlaybackAction, const mplay_fi_tcl_e8_DiPOPlaypackAction playbackAction);

    void ConvertPlaybackStateToAppControl(mplay_fi_tcl_e8_DiPOPlaybackStatus &playbackstateAppControl, const tHMIPlaybackState playbackState);
    void ConvertPlaybackModeToAppControl(mplay_fi_tcl_e8_DiPOPlaybackShuffleMode &appControlPlaybackMode, const tPlaybackMode playbackMode);
    void ConvertRepeatModeToAppControl(mplay_fi_tcl_e8_DiPOPlaybackRepeatMode &appControlRepeatMode, const tRepeatMode repeatMode);
    void ConvertDiPOCallStatusToAppControl(mplay_fi_tcl_e8_DiPOCallStateUpdateStatus &eStatus, const tDiPOCallStatus status);
    void ConvertDiPOCallDirectionToAppControl(mplay_fi_tcl_e8_DiPOCallStateUpdateDirection &eDirection, const tDiPOCallDirection direction);
    void ConvertDiPOCallServiceToAppControl(mplay_fi_tcl_e8_DiPOCallStateUpdateService &eService, const tDiPOCallService service);
    void ConvertDiPOCallDisconnectReasonToAppControl(mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason &eDisconnectReason, const tDiPOCallDisconnectReason disconnectReason);
    void ConvertDiPOCommunicationsSignalStrengthToAppControl(mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength &eSignalStrength, const tDiPOCommunicationsSignalStrength signalStrength);
    void ConvertDiPOCommunicationsRegistrationStatusToAppControl(mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus &eRegistrationStatus, const tDiPOCommunicationsRegistrationStatus registrationStatus);
    void ConvertDeviceStateToAppControl(mplay_fi_tcl_e8_DiPODeviceStatus &eDeviceStatus,  const tDeviceState deviceState);
    void ConvertConnectionStateToAppControl(mplay_fi_tcl_e8_DiPOConnectionState &appControlConnectionState, const tConnectionState connectionState);


    void ConvertDiPOAccessoryPowerModeToAppControl(mplay_fi_tcl_e8_AccessoryPowerMode &e8AccessoryPowerMode, const tDiPOAccessoryPowerMode AccessoryPowerMode);
    void ConvertDiPOBatteryChargingStateToAppControl(mplay_fi_tcl_e8_BatteryChargingState &e8BatteryChargingState, const tDiPOBatteryChargingState BatteryChargingState);
    void ConvertDiPORouteGuidanceStateToAppControl(mplay_fi_tcl_e8_RouteGuidanceState &e8RouteGuidanceState, const tDiPORouteGuidanceState RouteGuidanceState);
    void ConvertDiPOManeuverStateManeuverStateToAppControl(mplay_fi_tcl_e8_ManeuverState &e8ManeuverState, const tDiPOManeuverState ManeuverState);
    void ConvertDiPoDistanceDisplayUnitsToAppControl(mplay_fi_tcl_e8_DistanceDisplayUnits &e8DistanceDisplayUnits, const tDiPoDistanceDisplayUnits DistanceDisplayUnits);
    void ConvertDiPoManeuverTypeToAppControl(mplay_fi_tcl_e8_ManeuverType &e8ManeuverType, const tDiPoManeuverType ManeuverType);
    void ConvertDiPoDrivingSideToAppControl(mplay_fi_tcl_e8_DrivingSide &e8DrivingSide, const tDiPODrivingSide DrivingSide);
    void ConvertDiPoJunctionTypeToAppControl(mplay_fi_tcl_e8_JunctionType &e8JunctionType, const tDiPoJunctionType JunctionType);
    void ConvertManeuverListToAppControl(mplay_fi_tcl_RouteGuidanceManeuverCurrentList &u16RouteGuidanceManeuverCurrentList, const tManeuverList RouteGuidanceManeuverCurrentList);
    void ConvertAppInfoToInternal(tAppInfo &appInfo, const mplay_fi_tcl_AppInfo info);
    void ConvertInitiateCallTypeToInternal(tDiPOInitiateCallType &initiateCallType, mplay_fi_tcl_e_InitiateCallType callType);
    void ConvertInitiateCallServiceToInternal(tDiPOInitiateCallSevice &initiateCallService, mplay_fi_tcl_e_InitiateCallService callService);
    void ConvertAcceptCallActionToInternal(tDiPOAcceptAction &acceptCallAction, mplay_fi_tcl_e_AcceptAction acceptAction);
    void ConvertEndCallActionToInternal(tDiPOEndAction &endCallAction, mplay_fi_tcl_e_EndAction endAction);
protected:

    /**
    * This function shall be called when an error is sent inside a handler function
    * @param[in] rServiceMethodStart Reference to the received message
    * @param[in] u16ErrorCode  Error code
    * @return void
    */
    tVoid vPostError(amt_tclServiceData &rServiceMethodStart, tU16 u16ErrorCode = AMT_C_U16_ERROR_INTERNAL_FAILURE);
    /* ToDo copy to cpp file
    {
        // create error message and set error value
        amt_tclServiceDataError oError(rServiceMethodStart, u16ErrorCode);

         ail_tenCommunicationError ailResult = _poMainAppl->enPostMessage(&oError, TRUE);
        if (AIL_EN_N_NO_ERROR != ailResult)
        {
            // fatal error, because a server can post in all use cases
            ETG_TRACE_FATAL(("enPostMessage failed: %d", ailResult));
        }
    };
*/
    /**
    * This function shall be called when an answer message is sent inside a handler function
    * @param[in] rBaseMessage    Reference to the message related FI data object. All message specific parameters are already set
    *                            The parameters of the CCA header are set inside this functions. This function also deletes
    *                            the FI data object.
    * @param[in] rServiceMethodStart Reference to the received message
    * @return void
    */
    tVoid vPostResult(mplay_appcontrolfi_tclMsgBaseMessage &rBaseMessage, amt_tclServiceData &rServiceMethodStart);



    /**
    * This function is called by the CCA framework to request ANY
    * property which is offered by this service. For each property
    * accessed via parameter 'u16FunctionId' the user has to prepare
    * the corresponding FI data object which is then copied to the
    * referenced parameter 'roOutMsg'.

    * @param[in] u16FunctionId = Function ID of the requested property.
    * @param[out] roOutMsg = Reference to the service data object to which the content of the prepared FI data object should be copied to.
    * @param[in] poInMsg = Selector message which is used to select dedicated content to be copied to 'roOutMsg' instead of updating the entire FI data object.
    * @return: TRUE = Status message for property successfully generated. FALSE = Failed to generate status message for property.
    */
    virtual tBool bStatusMessageFactory(tU16 u16FunctionId, amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);

    /**
    * This function is called by the CCA framework when it has
    * received a message for a property with Opcode 'SET' or 'PURESET'
    * and there is no dedicated handler function defined in the
    * message map for this pair of FID and opcode. The user has to
    * set the application specific property to the requested value
    * and the CCA framework then cares about informing the requesting
    * client as well as other registered clients.
    *
    * @param[in] poMessage = Property to be set.
    * @param[out] bPropertyChanged = Property changed flag to be set to TRUE if property has changed. Otherwise to be set to FALSE (default).
    * @param[out] u16Error = Error code to be set if a CCA error occurs, otherwise don't touch.
    *
    * @return: TRUE = Send 'STATUS' message to the requesting client if opcode
    *                 was 'SET'. Send 'STATUS' message to other registered
    *                 clients as well if [OUT] parameter 'bPropertyChanged'
    *                 is set to TRUE.
    *                  FALSE = Send an error message to the requesting client.
    */
    virtual tBool bProcessSet(amt_tclServiceData* poMessage, tBool& bPropertyChanged, tU16& u16Error);

   /**
    * Message map definition macro
    */
    DECLARE_MSG_MAP(fc_mediaplayer_tclService_AppControl)


};

/** @} */

#endif /*__FC_MEDIAPLAYER_SERVICE_APPCONTROLFI_H__*/
