#ifndef _FC_MEDIAPLAYER_MAIN_H_
#define _FC_MEDIAPLAYER_MAIN_H_


/**
 * @defgroup CCAMediaPlayerApplication CCAMediaPlayerApplication
 * @ingroup MediaPlayer
 * @author Stefan Scherber
 *
 * Public interface for CCAMediaPlayerApplication
 * @{
 */

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#ifdef VARIANT_S_FTR_ENABLE_GM_DIAGNOSIS
#define DIAGLIB_INCLUDE_GENERIC
#include "diaglib_if.h"
#endif

/**
 *  class definitions.
 */
class ahl_tclBaseOneThreadApp;
#ifdef VARIANT_S_FTR_ENABLE_MP_AVMAN
class fc_mediaplayer_tclClientHandler_AVManager;
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_AVRCP
class fc_mediaplayer_tclClientHandler_BTSettings;
#endif
#ifdef VARIANT_S_FTR_ENABLE_CONN_MOST_FI
class fc_mediaplayer_tclClientHandler_GenBTSettings;
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_TELEPHONE
class fc_mediaplayer_tclClientHandler_Telephone;
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_GENTELEPHONE
class fc_mediaplayer_tclClientHandler_GenTelephone;
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_CMA
class fc_mediaplayer_tclClientHandler_CMA;
#endif
class fc_mediaplayer_tclClientHandler_DeviceManager;
#ifdef VARIANT_S_FTR_ENABLE_MP_FAVMAN
class fc_mediaplayer_tclClientHandler_FavoritesManager;
#endif
class fc_mediaplayer_tclClientHandler_IPodAuthentication;
#ifdef VARIANT_S_FTR_ENABLE_MP_GMLANGW
class fc_mediaplayer_tclClientHandler_GMLANGateway;
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_MOST_MPLAY_FI
class fc_mediaplayer_tclService_MediaPlayer;
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_GENERIC_MPLAY_FI
class fc_mediaplayer_tclService_MediaPlayer;
class fc_mediaplayer_tclAudioRoutingHandler;
#endif

#ifdef VARIANT_S_FTR_ENABLE_MP_VIDEOMANAGER
class fc_mediaplayer_tclClientHandler_Videomanager ;
#endif
class fc_mediaplayer_tclService_AppControl;
#ifdef VARIANT_S_FTR_ENABLE_MP_SVG_LAYER
class fc_mediaplayer_tclService_MediaPlayer_Layer_Sync;
#endif
class MediaplayerTraceInterface;

#if defined (VARIANT_S_FTR_ENABLE_MP_GMSPI) || defined(VARIANT_S_FTR_ENABLE_MP_SPI)
class fc_mediaplayer_tclClientHandler_SPI;
#endif



#ifdef VARIANT_S_FTR_ENABLE_GM_DIAGNOSIS
class FC_MediaPlayer_tclDefSetHandler;
#endif
#ifdef VARIANT_S_FTR_ENABLE_MP_SPM
class fc_mediaplayer_tclClientHandler_SPM;
#endif
#ifdef VARIANT_S_FTR_ENABLE_ABSOLUTE_VOLUME_SUPPORT
class AudioDbusHandlingProxy;
#endif

class OutputWrapper;
class CustomControl;
class Configuration;


/**
 * This class implements the CCAMediaPlayerApplication component.
 */
class fc_mediaplayer_tclApp : public ahl_tclBaseOneThreadApp
{
        /**
        * static pointer to CCAMediaPlayerApplication instance
        */
        static fc_mediaplayer_tclApp* m_poMainAppInstance;

    public:

           /**
        * Interface thread function
        * Reads from the interface queue and calls AHL default OnNewMessage method
        * @return
        */
        tVoid vInterfaceThread();

           /**
        * Starts interface thread
        * @param[in] pvArg Pointer to the CCA application
        * @return
        */
        static tVoid vStartInterfaceThread (tVoid* pvArg);

           /**
        * is called when an new message is received.
        * Stores the message in the interface queue
        * @param[in] poMessage new message
        * @return
        */
        virtual tVoid vOnNewMessage (amt_tclBaseMessage* poMessage);

        /**
        * Constructor of the application class
        * Sets the static pointer m_poMainAppInstance
        * @return
        */
        fc_mediaplayer_tclApp(tVoid);


        /**
        * Destructor of the application class
        * Sets the static pointer m_poMainAppInstance to NULL
        * @return
        */
        virtual ~fc_mediaplayer_tclApp(tVoid);

        virtual tBool bRequestTimeOnStateChangeAutomatically() const;

        /**************************************************************************
        * Assingment Operater, will not be implemented.
        * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
        * 'fc_mediaplayer_tclApp' which has no assignment operator.
        * NOTE: This is a technique to disable the assignment operator for this
        * class. So if an attempt for the assignment is made compiler complains.
        **************************************************************************/
        fc_mediaplayer_tclApp& operator= (const fc_mediaplayer_tclApp &oFC_MediaPlayer);

        /**************************************************************************
        * Copy Constructor, will not be implemented.
        * Avoids Lint Prio 3 warning:Info 1733: new in constructor for class
        * 'fc_mediaplayer_tclApp' which has no copy constructor.
        * NOTE: This is a technique to disable the copy constructor for this
        * class. So if an attempt for the assignment is made compiler complains.
        **************************************************************************/
        fc_mediaplayer_tclApp(const fc_mediaplayer_tclApp &oFC_MediaPlayer);


        // Overriding ahl_tclBaseOneThreadApp methods.

        /**
        * Function is called by framework during startup
        * creates all service and client handler classes
        * gets the instance of the local SPM by calling method LocalSPM::GetInstance(void)
        * calls method CreateMediaPlayer of LocalSPM
        * @return TRUE if successfull else FALSE
        */
        virtual tBool bOnInit();

        /**
        * Function is called by framework during shutdown. Not used in GM program
        * deletes all service and client handler classes
        * @return void
        */
        virtual tVoid vOnApplicationClose();

        /**
        * Is called by framework when a timer is elapsed
        * Nothing to do
        * @return void
        */
        virtual tVoid vOnTimer(tU16 nTimerId);

        /**
        * Is called by framework when system changes to NORMAL
        * calls StateChangeNormal of local SPM
        * @return void
        */
        virtual tVoid vOnLoadSettings();

        /**
        * Is called by framework when system changes to OFF
        * calls StateChangeOff of local SPM
        * @return void
        */
        virtual tVoid vOnSaveSettings();


        using ahl_tclBaseOneThreadApp::vOnLoopback;

        /**
        * Is called by framework when a loopback message is received
        * Nothing to do
        * @return void
        */
        virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

        /**
        * Function is called by fc_mediaplayer_tclClientHandler_CMA and fc_mediaplayer_tclClientHandler_FavoritesManager
        * Checks if MediaPlayer is visible on MOST by calling MediaplayerServiceVisible of fc_mediaplayer_tclClientHandler_CMA and
        * if FavoriteManager service is available by calling bIfServiceAvailable of  fc_mediaplayer_tclClientHandler_FavoritesManager.
        * If both functions return TRUE function RegisterFavoritesProvider of fc_mediaplayer_tclClientHandler_FavoritesManager
        * is called
        * @return void
        */
        #if defined(VARIANT_S_FTR_ENABLE_MP_CMA) && defined(VARIANT_S_FTR_ENABLE_MP_FAVMAN)
        tVoid RegisterFavoriteProvider();
        #endif

        /**
         * Method to get get the instance of CCAClientHandlerAVManager
         * It is not allowed to call this function before bOnInit was called. -> NORMAL_ASSERT
         * @return reference to instance
         */
        #ifdef VARIANT_S_FTR_ENABLE_MP_AVMAN
        fc_mediaplayer_tclClientHandler_AVManager &GetCCAClientHandlerAVManager(void)
        {
            NORMAL_M_ASSERT(NULL != m_poClientHandlerAVManager);
            return *m_poClientHandlerAVManager;
        };
        #endif

        /**
         * Method to get get the instance of CCAClientHandlerBTSettings
         * It is not allowed to call this function before bOnInit was called. -> NORMAL_ASSERT
         * @return reference to instance
         */
        #ifdef VARIANT_S_FTR_ENABLE_MP_AVRCP
        fc_mediaplayer_tclClientHandler_BTSettings &GetCCAClientHandlerBTSettings(void)
        {
            NORMAL_M_ASSERT(NULL != m_poClientHandlerBTSettings);
            return *m_poClientHandlerBTSettings;
        };
        #endif

        #ifdef VARIANT_S_FTR_ENABLE_CONN_MOST_FI
        fc_mediaplayer_tclClientHandler_GenBTSettings &GetCCAClientHandlerGenBTSettings(void)
        {
            NORMAL_M_ASSERT(NULL != m_poClientHandlerGenBTSettings);
            return *m_poClientHandlerGenBTSettings;
        };
        #endif

        #ifdef VARIANT_S_FTR_ENABLE_MP_TELEPHONE
        fc_mediaplayer_tclClientHandler_Telephone &GetCCAClientHandlerTelephone(void)
        {
            NORMAL_M_ASSERT(NULL != m_poClientHandlerTelephone);
            return *m_poClientHandlerTelephone;
        };

        #endif

        /**
         * Method to get get the instance of CCAClientHandlerSPM
         * It is not allowed to call this function before bOnInit was called. -> NORMAL_ASSERT
         * @return reference to instance
         */
        #ifdef VARIANT_S_FTR_ENABLE_MP_SPM
        fc_mediaplayer_tclClientHandler_SPM &GetCCAClientHandlerSPM(void)
        {
            NORMAL_M_ASSERT(NULL != m_poClientHandlerSPM);
            return *m_poClientHandlerSPM;
        };
        #endif

        #ifdef VARIANT_S_FTR_ENABLE_MP_GENTELEPHONE
        fc_mediaplayer_tclClientHandler_GenTelephone &GetCCAClientHandlerGenTelephone(void)
        {
            NORMAL_M_ASSERT(NULL != m_poClientHandlerGenTelephone);
            return *m_poClientHandlerGenTelephone;
        };

        #endif

        /**
         * Method to get get the instance of CCAClientHandlerCMA
         * It is not allowed to call this function before bOnInit was called. -> NORMAL_ASSERT
         * @return reference to instance
         */
        #ifdef VARIANT_S_FTR_ENABLE_MP_CMA
        fc_mediaplayer_tclClientHandler_CMA &GetCCAClientHandlerCMA(void)
        {
            NORMAL_M_ASSERT(NULL != m_poClientHandlerCMA);
            return *m_poClientHandlerCMA;
        };
        #endif
        /**
         * Method to get get the instance of CCAClientHandlerDeviceManager
         * It is not allowed to call this function before bOnInit was called. -> NORMAL_ASSERT
         * @return reference to instance
         */
        fc_mediaplayer_tclClientHandler_DeviceManager &GetCCAClientHandlerDeviceManager(void)
        {
            NORMAL_M_ASSERT(NULL != m_poClientHandlerDeviceManager);
            return *m_poClientHandlerDeviceManager;
        };

        /**
         * Method to get get the instance of CCAClientHandlerFavoritesManager
         * It is not allowed to call this function before bOnInit was called. -> NORMAL_ASSERT
         * @return reference to instance
         */
        #ifdef VARIANT_S_FTR_ENABLE_MP_FAVMAN
        fc_mediaplayer_tclClientHandler_FavoritesManager &GetCCAClientHandlerFavoritesManager(void)
        {
            NORMAL_M_ASSERT(NULL != m_poClientHandlerFavoritesManager);
            return *m_poClientHandlerFavoritesManager;
        };
        #endif

        /**
         * Method to get get the instance of CCAClientHandlerSPI
         * It is not allowed to call this function before bOnInit was called. -> NORMAL_ASSERT
         * @return reference to instance
         */
        #if defined (VARIANT_S_FTR_ENABLE_MP_GMSPI) || (VARIANT_S_FTR_ENABLE_MP_SPI)
        fc_mediaplayer_tclClientHandler_SPI &GetCCAClientHandlerSPI(void)
        {
            NORMAL_M_ASSERT(NULL != m_poClientHandlerSPI);
            return *m_poClientHandlerSPI;
        };
        #endif


        /**
         * Method to get get the instance of CCAClientHandlerIPodAuthentication
         * It is not allowed to call this function before bOnInit was called. -> NORMAL_ASSERT
         * @return reference to instance
         */
        fc_mediaplayer_tclClientHandler_IPodAuthentication &GetCCAClientHandlerIPodAuthentication(void)
        {
            NORMAL_M_ASSERT(NULL != m_poClientHandlerIPodAuthentication);
            return *m_poClientHandlerIPodAuthentication;
        };

        /**
         * Method to get get the instance of CCAServiceMediaPlayer
         * It is not allowed to call this function before bOnInit was called. -> NORMAL_ASSERT
         * @return reference to instance
         */
        fc_mediaplayer_tclService_MediaPlayer &GetCCACCAServiceMediaPlayer(void)
        {
            NORMAL_M_ASSERT(NULL != m_poMediaPlayer);
            return *m_poMediaPlayer;
        };

        /**
         * Method to get get the instance of AudioRoutingHandler
         * It is not allowed to call this function before bOnInit was called. -> NORMAL_ASSERT
         * @return reference to instance
         */
        #ifdef VARIANT_S_FTR_ENABLE_MP_GENERIC_MPLAY_FI
        fc_mediaplayer_tclAudioRoutingHandler &GetAudioRoutingHandler(void)
        {
            NORMAL_M_ASSERT(NULL != m_poAudioRoutingHandler);
            return *m_poAudioRoutingHandler;
        };
        #endif
        #ifdef VARIANT_S_FTR_ENABLE_MP_VIDEOMANAGER
        fc_mediaplayer_tclClientHandler_Videomanager &GetVideoManagerClientHandler(void)
        {
            NORMAL_M_ASSERT(NULL != m_poVideoManagerClientHandler);
            return *m_poVideoManagerClientHandler;
        };
        #endif
        /**
         * Method to get get the instance of CCAServiceAppControl
         * It is not allowed to call this function before bOnInit was called. -> NORMAL_ASSERT
         * @return reference to instance
         */
        fc_mediaplayer_tclService_AppControl &GetCCACCAServiceAppControl(void)
        {
            NORMAL_M_ASSERT(NULL != m_poAppControl);
            return *m_poAppControl;
        };

        /**
         * Method to get get the instance of CCAServiceLayerSync
         * It is not allowed to call this function before bOnInit was called. -> NORMAL_ASSERT
         * @return reference to instance
         */
        #ifdef VARIANT_S_FTR_ENABLE_MP_SVG_LAYER
        fc_mediaplayer_tclService_MediaPlayer_Layer_Sync &GetCCAServiceLayerSync (void)
        {
            NORMAL_M_ASSERT(NULL != m_poLayerSync);
            return *m_poLayerSync;
        };
        #endif

        /**
         * Method to get get the instance of OutputWrapper
         * It is not allowed to call this function before bOnInit was called. -> NORMAL_ASSERT
         * @return reference to instance
         */
        OutputWrapper &GetOutputWrapper (void)
        {
            NORMAL_M_ASSERT(NULL != m_poOutputWrapper);
            return *m_poOutputWrapper;
        };

        /**
         * Method to get get the instance of AudioDbusHandlingProxy
         * It is not allowed to call this function before bOnInit was called. -> NORMAL_ASSERT
         * @return reference to instance
         */
        #ifdef VARIANT_S_FTR_ENABLE_ABSOLUTE_VOLUME_SUPPORT
        AudioDbusHandlingProxy &GetAudioDbusHandlingProxy(void)
        {
            NORMAL_M_ASSERT(NULL != m_poAudioDbusHandlingProxy);
            return *m_poAudioDbusHandlingProxy;
        };
        #endif

      private:

        #ifdef VARIANT_S_FTR_ENABLE_MP_GENERIC_MPLAY_FI
        fc_mediaplayer_tclAudioRoutingHandler* m_poAudioRoutingHandler;
        #endif
        #ifdef VARIANT_S_FTR_ENABLE_MP_VIDEOMANAGER
        fc_mediaplayer_tclClientHandler_Videomanager* m_poVideoManagerClientHandler;
        #endif
        #ifdef VARIANT_S_FTR_ENABLE_MP_AVMAN
        fc_mediaplayer_tclClientHandler_AVManager* m_poClientHandlerAVManager;
        #endif
        #ifdef VARIANT_S_FTR_ENABLE_MP_AVRCP
        fc_mediaplayer_tclClientHandler_BTSettings* m_poClientHandlerBTSettings;
        #endif
        #ifdef VARIANT_S_FTR_ENABLE_CONN_MOST_FI
        fc_mediaplayer_tclClientHandler_GenBTSettings* m_poClientHandlerGenBTSettings;
        #endif
        #ifdef VARIANT_S_FTR_ENABLE_MP_TELEPHONE
        fc_mediaplayer_tclClientHandler_Telephone* m_poClientHandlerTelephone;
        #endif
        #ifdef VARIANT_S_FTR_ENABLE_MP_SPM
        fc_mediaplayer_tclClientHandler_SPM* m_poClientHandlerSPM;
        #endif
        #ifdef VARIANT_S_FTR_ENABLE_MP_GENTELEPHONE
        fc_mediaplayer_tclClientHandler_GenTelephone* m_poClientHandlerGenTelephone;
        #endif
        #ifdef VARIANT_S_FTR_ENABLE_MP_CMA
        fc_mediaplayer_tclClientHandler_CMA* m_poClientHandlerCMA;
        #endif

        #ifdef VARIANT_S_FTR_ENABLE_MP_GMLANGW
        fc_mediaplayer_tclClientHandler_GMLANGateway* m_poClientHandlerGMLANGateway;
        #endif

        #if defined (VARIANT_S_FTR_ENABLE_MP_GMSPI) || (VARIANT_S_FTR_ENABLE_MP_SPI)
        fc_mediaplayer_tclClientHandler_SPI* m_poClientHandlerSPI;
        #endif


        #ifdef VARIANT_S_FTR_ENABLE_MP_FAVMAN
        fc_mediaplayer_tclClientHandler_FavoritesManager* m_poClientHandlerFavoritesManager;
        #endif

        #ifdef VARIANT_S_FTR_ENABLE_MP_SVG_LAYER
        fc_mediaplayer_tclService_MediaPlayer_Layer_Sync* m_poLayerSync;
        #endif

        #ifdef VARIANT_S_FTR_ENABLE_GM_DIAGNOSIS
        FC_MediaPlayer_tclDefSetHandler* m_poDefSetHandler;
        diaglib::tclServiceDiaglib* m_poDiaglibService;
        #endif

        #ifdef VARIANT_S_FTR_ENABLE_ABSOLUTE_VOLUME_SUPPORT
        AudioDbusHandlingProxy* m_poAudioDbusHandlingProxy;
        #endif
        fc_mediaplayer_tclClientHandler_DeviceManager* m_poClientHandlerDeviceManager;
        fc_mediaplayer_tclClientHandler_IPodAuthentication* m_poClientHandlerIPodAuthentication;
        fc_mediaplayer_tclService_MediaPlayer* m_poMediaPlayer;
        fc_mediaplayer_tclService_AppControl* m_poAppControl;

        CustomControl *m_poCustomControl;
        OutputWrapper *m_poOutputWrapper;
        Configuration *m_poConfiguration;

        MediaplayerTraceInterface *mTraceInterface;

        // members for interface thread and queue
        OSAL_tMQueueHandle hInterfaceQueueID;
        OSAL_tThreadID hInterfaceThreadID;

};

/** @} */

#endif //_FC_MEDIAPLAYER_MAIN_H_

