
#ifndef __FC_MEDIAPLAYER_CLIENTHANDLER_IPODAUTH_H__
#define __FC_MEDIAPLAYER_CLIENTHANDLER_IPODAUTH_H__

/**
 * @defgroup CCAClientHandlerIPodAuthentication CCAClientHandlerIPodAuthentication
 * @ingroup MediaPlayer
 * @author Stefan Scherber
 * 
 * Public interface for CCAClientHandlerIPodAuthentication
 * @{
 */

// Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

// Include message framework interface (AMT, msgfw)
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//Include FI interface of used service
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_IPODAUTHFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_IPODAUTHFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_IPODAUTHFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_IPODAUTHFI_SERVICEINFO
#include "midw_fi_if.h"

class ahl_tclBaseOneThreadClientHandler;

/** 
 * This class implements the CCAClientHandlerIPodAuthentication component. 
 */
class fc_mediaplayer_tclClientHandler_IPodAuthentication:public ahl_tclBaseOneThreadClientHandler
{

public:

	/** 
	* Constructor of the service class
	* _tclRegisterPair.bAddPair(AMT_C_U32_STATE_OFF, AMT_C_U32_STATE_NORMAL) and
	* _tclUnregisterPair.bAddPair(AMT_C_U32_STATE_NORMAL, AMT_C_U32_STATE_OFF) must be called.
	* @param[in] poMainAppl Pointer to the CCA application
	* @return  
	*/
    fc_mediaplayer_tclClientHandler_IPodAuthentication(fc_mediaplayer_tclApp* poMainAppl);

	/** 
	* Destructor of the service class
	* @return  
	*/
    virtual ~fc_mediaplayer_tclClientHandler_IPodAuthentication();
	
	/** 
	* Called by framework when service is available
	* calls vRegisterProperties of clienthandler DeviceHandler
	* @return  
	*/
    virtual tVoid vOnServiceAvailable();

	/** 
	* Called by framework when service is unavailable
	* calls vDeregisterProperties of clienthandler DeviceHandler
	* @return  
	*/
    virtual tVoid vOnServiceUnavailable();

	/** 
	* Message AuthenticationInit methodstart is sent synchronous to IPOD authentication server
	* @param[in] bInit if TRUE initialize authentication; if true deinitalize authentication
	* @return IPOD_OK or IPOD_ERROR
	*/
	tS32 AuthenticationInit(tBool bInit);

	/** 
	* Message AccessoryCertificate get is sent synchronous to IPOD authentication server
	* @param[out] certLength  length of certificate
	* @param[out] certData certificate
	* @return IPOD_OK or IPOD_ERROR
	*/
	tS32 AccessoryCertificate(tU16 *certLength, tU8 *certData);

	/** 
	* Message iPodCertificate methodstart is sent synchronous to IPOD authentication server
	* @param[in] certLen  length of certificate
	* @param[in] certData certificate
	* @return IPOD_OK or IPOD_ERROR
	*/
	tS32 IPodCertificate(tU16 certLen, tU8 *certData);

	/** 
	* Message SetSignature methodstart is sent synchronous to IPOD authentication server
	* @param[in] sigDataLen  length of signature
	* @param[in] sigData signature
	* @return IPOD_OK or IPOD_ERROR
	*/
	tS32 SetSignature(tU16 sigDataLen, tU8 *sigData);

	/** 
	* Message GenSignature methodstart is sent synchronous to IPOD authentication server
	* @param[in] ResponseBuffer  challange data from the IPOD
	* @param[out] SignatureDataLength length of the signature
	* @param[out] SignatureData signature
	* @return IPOD_OK or IPOD_ERROR
	*/
	tS32 GenSignature(const tU8  *ResponseBuffer, tU16 *SignatureDataLength, tU8 *SignatureData);

	/** 
	* Message GetChallenge methodstart is sent synchronous to IPOD authentication server
	* @param[out] ChallengeDataLength  challange data length
	* @param[out] ChallengeData challange
	* @return IPOD_OK or IPOD_ERROR
	*/
	tS32 GetChallenge(tU16 *ChallengeDataLength, tU8 *ChallengeData);

	/** 
	* Message DeviceID get is sent synchronous to IPOD authentication server
	* @param[out] DeviceID device ID
	* @return IPOD_OK or IPOD_ERROR
	*/
	tS32 DeviceID (tU32 *DeviceID);

	/** 
	* Message FirmwareVersion get is sent synchronous to IPOD authentication server
	* @param[out] majorVer  Major version of firmware
	* @param[out] minorVer  Minor version of firmware
	* @return IPOD_OK or IPOD_ERROR
	*/
	tS32 FirmwareVersion (tU8 *majorVer, tU8 *minorVer);

	/** 
	* Message AuthenticationProtocolVersion get is sent synchronous to IPOD authentication server
	* @param[out] majorVer  Major version of protocol
	* @param[out] minorVer  Minor version of protocol
	* @return IPOD_OK or IPOD_ERROR
	*/
	tS32 AuthenticationProtocolVersion (tU8 *majorVer, tU8 *minorVer);

	/** 
	* Message iPodAuthenticationSelftest method start is sent synchronous to IPOD authentication server
	* @return IPOD_OK: passed or IPOD_ERROR: failed
	*/
	tS32 IPodAuthenticationSelftest (tU8 *certificate, tU8 *private_key, tU8 *ram_check, tU8 *checksum);

private:	

    private:

    fc_mediaplayer_tclApp *mpoMainAppl;

    /***************************************************************************
    ** FUNCTION:  tBool bSentMsg(T1 &OutMsg, T2 &InMsg)
    ***************************************************************************/
    /*!
    * \brief   Template function to handle cca messages to VD_Auth CP service
    * \param   [T1 &OutMsg] msg reference to CP, [T2 &InMsg] msg reference from CP
    * \retval  NONE
    * \date 31.01.2011 \author Deuper (TMS CM-AI/PJ-GM55)
    **************************************************************************/
    template<typename T1, typename T2>
    tBool bSentMsg(T1 &OutMsg, T2 &InMsg);


protected:

   /**
    * Message map definition macro
    */
   DECLARE_MSG_MAP(fc_mediaplayer_tclClientHandler_IPodAuthentication)


};

/** @} */


#endif // __FC_MEDIAPLAYER_CLIENTHANDLER_IPODAUTH_H__
