
#ifndef __FC_MEDIAPLAYER_CLIENTHANDLER_DEVICEMANAGER_H__
#define __FC_MEDIAPLAYER_CLIENTHANDLER_DEVICEMANAGER_H__

/**
 * @defgroup CCAClientHandlerDeviceManager CCAClientHandlerDeviceManager
 * @ingroup MediaPlayer
 * @author Stefan Scherber
 *
 * Public interface for CCAClientHandlerDeviceManager
 * @{
 */

// Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#define VARIANT_S_FTR_ENABLE_DEVMGR_GEN3_CCA //use FI embedded in mplay_fi    //@todo shift this to _prod.xml
#define VD_DEVICEMANAGER_S_IMPORT_INTERFACE_MSG
#include "../../../../VD_DeviceManager/VD_DeviceManager_interface.h"  //@todo add path to _prod.xml

#include "TypeDefinitions.h"

class ahl_tclBaseOneThreadClientHandler;

/**
 * This class implements the CCAClientHandlerDeviceManager component.
 */
class fc_mediaplayer_tclClientHandler_DeviceManager:public ahl_tclBaseOneThreadClientHandler
{

public:

    /**
    * Constructor of the service class
    * _tclRegisterPair.bAddPair(AMT_C_U32_STATE_OFF, AMT_C_U32_STATE_NORMAL) and
    * _tclUnregisterPair.bAddPair(AMT_C_U32_STATE_NORMAL, AMT_C_U32_STATE_OFF) must be called.
    * It is not allowed to call vAddAutoRegisterForProperty.
    * This function will be called as soon as iPod Authentication Service is available.
    * @param[in] poMainAppl Pointer to the CCA application
    * @return
    */
    fc_mediaplayer_tclClientHandler_DeviceManager(fc_mediaplayer_tclApp* poMainAppl);

    /**
    * Destructore of the service class
    * @return
    */
    virtual ~fc_mediaplayer_tclClientHandler_DeviceManager();

    /**
    * Function is called by iPod Authentication Service class as soon as the service is available
    * This function calls vAddAutoRegisterForProperty(MIDW_DEVICEMANAGERFI_C_U16_DEVMANAGERNOTIFYCONNECTION)
    * @return
    */
    void vRegisterProperties();

    /**
    * Function is called by iPod Authentication Service class as soon as the service is not available anymore
    * This function calls vRemoveAutoRegisterForProperty(MIDW_DEVICEMANAGERFI_C_U16_DEVMANAGERNOTIFYCONNECTION)
    * @return
    */
    void vDeregisterProperties();

    /**
    * Function to requests for all the connected devices from the device manager
    *
    * @return
    */
    void vRequestConnectedDevices();

    /**
    * function to send eject command to devicemanager
    * @param[in] enOpticalDiscEjectCmd: specify if eject or insert command is send to VD_DeviceManager - see definition of tDMOpticalDiscEjectCmd
    */
   tVoid SendEjectOpticalDisc(IN const tDMOpticalDiscEjectCmd enOpticalDiscEjectCmd); //Roadmap 15002_CDAudio_DetectionAndDiagnosis

    /**
    * Function to send DVD Drive Info to Devicemanager
    *
    * @return
    */
    void vUpdateDVDDriveInfo();

    /**
    * Function to Get NotifyConnection property from Device Manager
    *
    * @return
    */
    void RequestDeviceManagerNotifyConnection();


private:

    /**
    * This function is called when status DeviceManagerNotifyConnection is received
    * Parameter is converted from vector<midw_fi_tcl_DevManager_DeviceProperty  to a vector<tDeviceProperty>
    *   Iterate over all elements
    *   midw_fi_tclString DeviceSerialNo is casted to tDeviceSerialNumber serialNumber
    *   midw_fi_tclString USBPortNo is casted to tUSBPortNumber USBPortNumber;
    *   midw_fi_tcl_e8_Device DeviceType is converted to tDeviceType type using ConvertDeviceTypeToInternal
    *   midw_fi_tclString DeviceVersion is casted to tDeviceVersion version
    *   midw_fi_tclString DeviceName is casted to  tDeviceName name
    *   midw_fi_tclString AccessoryName is casted to tAccessoryName accessoryName
    *   midw_fi_tclString MountPoint is casted to tMountPoint mountPoint
    *   midw_fi_tcl_e8_DeviceConnectStatus DeviceConnectStstaus is converted to tDMConnectStatus connectStatus using ConvertDeviceConnectionStatusToInternal
    * Function tResult DeviceChanged(vector<tDeviceProperty> of DBManager is called
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onDeviceManagerNotifyConnection(amt_tclServiceData* poMessage); //Roadmap 13024


    /**
    * This function is called when status DeviceManagerSlotStateNotification is received
    * @param[in] poMessage Message
    * @return void
    */

    tVoid onDeviceManagerNotifySlotStateOpticalDisc(amt_tclServiceData* poMessage); //Roadmap 15002_CDAudio_DetectionAndDiagnosis

    /**
     *
     *   checks if device is empty
     *   (call to register at VD_DeviceManager results in receiving empty device)
     * @param[in] it iterator pointing to deviceProperty
     * @return FALSE: filled device  TRUE: empty device
     */
    tBool isDeviceEmpty(const tDeviceProperty deviceProperty);

    /**
     *
     *   This function gives the list of all connected devices at a particular point
     * @param[in]
     *
     */
    tVoid onRequestConnectedDevicesMethodResult(amt_tclServiceData* poMessage);

    /**
     *
     *   This function gives the CDInfo of an Optical Drive-
     *   T_e8DeviceState DeviceState
     *   T_String DriveVersion
     * @param[in]
     *
     */
    tVoid onDeviceManagerNotifyCDInfo(amt_tclServiceData* poMessage);

protected:

    typedef enum
    {
        eOnDeviceManagerNotifyConnection       = 0,
        eOnRequestConnectedDevicesMethodResult = 1

    }tenFctType;

    static const tU16 u16MajorVersionOptimisedInterface = 3;


    /**
     * function converts midw_fi_tcl_e8_Device to tDeviceType
     *   FI_EN_DTY_UNKNOWN -> DTY_UNKNOWN
     *   FI_EN_DTY_USB -> DTY_USB
     *   FI_EN_DTY_SDCARD -> DTY_SD
     *   FI_EN_DTY_IPOD -> DTY_IPOD
     *   FI_EN_DTY_IPHONE -> DTY_IPHONE
     *   FI_EN_DTY_MTP -> DTY_MTP
     *   FI_EN_DTY_MSZUNE -> DTY_MSZUNE
     */
    void ConvertDeviceTypeToInternal(tDeviceType &deviceTypeInternal, const FIDEVMGR_E8_DEVICE deviceType, tDeviceUnsupportedReason deviceUnsupportedReason, tMountPoint deviceMountpointInternal);

    /**
     * function converts tDeviceType to tConnectionType
     *   DTY_UNKNOWN -> DCT_UNKNOWN
     *   DTY_USB -> DCT_USB
     *   DTY_SD -> DCT_USB
     *   DTY_IPOD -> DCT_USB
     *   DTY_IPHONE -> DCT_USB
     *   DTY_MTP -> DCT_USB
     *   DTY_MSZUNE -> DCT_USB
     *   DTY_CDROM -> DCT_CDROM
     *   DTY_CDDA -> DCT_CDROM
     */
    void ConvertDeviceTypeToConnectionType (tConnectionType &connectionType, const tDeviceType deviceTypeInternal);

    /**
     * function converts midw_fi_tcl_e8_DeviceConnectStatus to tDMConnectStatus
     *   FI_EN_FSTY_UNKNOWN -> FSTY_UNKNOWN
     *   FI_EN_FSTY_FAT -> FSTY_FAT
     *   FI_EN_FSTY_NTFS -> FSTY_NTFS
     *   FI_EN_FSTY_EXT4->FSTY_EXT4
     *   FI_EN_FSTY_HFS->FSTY_HFS
     *   FI_EN_FSTY_EXFAT->FSTY_EXFAT
     *   FI_EN_FSTY_ISO9660->FSTY_ISO9660
     *   FI_EN_FSTY_UDF->FSTY_UDF
     */
    void ConvertFileSystemTypeToInternal(tFileSystemType &fileSystemTypeInternal, const FIDEVMGR_E8_FILESYSTEM fileSystemType);

    /**
     * function converts midw_fi_tcl_e8_DeviceConnectStatus to tDMConnectStatus
     *   FI_EN_USB_DEV_UNDEFINED -> DM_CS_UNDEFINED
     *   FI_EN_USB_DEV_WARNING -> DM_CS_WARNING
     *   FI_EN_USB_DEV_CONNECTED -> DM_CS_CONNECTED
     *   FI_EN_USB_DEV_REMOVED_BY_USR -> DM_CS_REMOVED_BY_USR
     *   FI_EN_USB_DEV_UNAVAIL_BAT_LOWVOLT -> DM_CS_UNAVAIL_BAT_LOWVOLT
     *   FI_EN_USB_DEV_UNAVAIL_HW_MALFUNC -> DM_CS_UNAVAIL_HW_MALFUNC
     *   FI_EN_USB_DEV_UNAVAIL_OVERTEMP -> DM_CS_UNAVAIL_CDROM_OVERTEMP
     */
    void ConvertDeviceConnectionStatusToInternal(tDMConnectStatus &deviceConnectionStatusInternal, const FIDEVMGR_E8_DEVICECONNECTSTATUS DeviceConnectStatus);

    /**
     * function converts tDeviceType to tConnectionType
     *   DM_CS_UNDEFINED -> CS_DISCONNECTED / DR_REMOVED
     *   DM_CS_WARNING -> CS_DISCONNECTED / DR_REMOVED
     *   DM_CS_CONNECTED -> CS_ATTACHED / DR_REMOVED
     *   DM_CS_REMOVED_BY_USR -> CS_DISCONNECTED / DR_REMOVED
     *   DM_CS_UNAVAIL_BAT_LOWVOLT -> CS_UNDERVOLTAGE / DR_HW_MALFUNC
     *   DM_CS_UNAVAIL_HW_MALFUNC -> CS_DISCONNECTED / DR_HW_MALFUNC
     *   DM_CS_UNAVAIL_CDROM_OVERTEMP -> CS_OVERTEMP / DR_TEMPERATURE
     */
    void ConvertDMConnectStatusToConnectionState(tConnectionState &connectionStateInternal, tDisconnectReason &disconnectReasonInternal, const tDMConnectStatus connectStatus);

    /**
     * function converts a vector of tDeviceProperty to a vector of tDeviceInfo
     */
    void ConvertDevicePropertiesToDeviceInfos(vector<tDeviceInfo> &deviceInfos, const vector<tDeviceProperty> deviceProperties);


    /**
     * function converts SlotStatis FI to internal
     */
    void ConvertOpticalDiscStatusToInternal(OUT tDMOpticalDiscSlotState &opticalDiscStatusInternal, IN const mplay_fi_tcl_e8_SlotStateOpticalDiscType enSlotStateOpticalDisc) ;//Roadmap 15002_CDAudio_DetectionAndDiagnosis

    /**
     * function traces devicePropertyItem - added to support new Interface behaviour of VD_DVM where last change is not in first elem of propoerty vecor but all entries have to be taken into account
     * That's why with the new interface the whole vector send to VD_DVM is traced
     */
    tVoid TraceDevicePropertyItem(tenFctType eFcType, const tDeviceProperty &devicePropertyItem, unsigned int index) const;


   /*!
        * \brief onOpticalDiscEjectMethodResult( tVoid )
        *
        * Used to get cca method result from VD_DeviceManager after having sen dejectOpticalDisc
        *
        *
        */
    tVoid onOpticalDiscEjectMethodResult(IN  amt_tclServiceData* poMessage );//Roadmap 15002_CDAudio_DetectionAndDiagnosis

    /**
         * function converts DeviceState for Optical drive FI to internal
         */
    void ConvertOpticalDeviceStateToInternal(OUT tenOpticalDeviceState &DeviceState, IN const mplay_fi_tcl_e8DeviceState oFiOpticalDeviceState);

    /**
         * function converts UnsupportedReason FI to internal
         */
    void ConvertDeviceUnsupportedReasonTypeToInternal(OUT tDeviceUnsupportedReason &deviceUnsupportedReasonInternal, IN const FISHARED_E8_UNSUPPORTEDREASON deviceUnsupportedReason);

   /**
    * Message map definition macro
    */
   DECLARE_MSG_MAP(fc_mediaplayer_tclClientHandler_DeviceManager)


};

/** @} */


#endif // __FC_MEDIAPLAYER_CLIENTHANDLER_DEVICEMANAGER_H__
