#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#include "TraceDefinitions.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_IPOD_CONTROL
#ifdef TARGET_BUILD
#include "trcGenProj/Header/auth_msc.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_IPOD_CONTROL
#endif
#endif

#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <endian.h>
#include <byteswap.h>
#include <time.h>
#include <errno.h>
#include <libusb-1.0/libusb.h>
#include "auth_msc.h"
#include <authentication.h>

#define usb_interface interface
struct command_block_wrapper {
	uint8_t dCBWSignature[4];
	uint32_t dCBWTag;
	uint32_t dCBWDataTransferLength;
	uint8_t bmCBWFlags;
	uint8_t bCBWLUN;
	uint8_t bCBWCBLength;
	uint8_t CBWCB[16];
};

// Section 5.2: Command Status Wrapper (CSW)
struct command_status_wrapper {
	uint8_t dCSWSignature[4];
	uint32_t dCSWTag;
	uint32_t dCSWDataResidue;
	uint8_t bCSWStatus;
};

#define htons(A) ((((unsigned short)(A) & 0xff00) >> 8) | \
	(((unsigned short)(A) & 0x00ff) << 8))
#define SMSC_VENDOR_SPECIFIC_COMMAND           0xCF
//#define k_vendor_misc_host_command             0x54
//#define K_VENDOR_I2C_BRIDGE_COMMAND            0x20
//#define K_VENDOR_I2C_BRIDGE_RESPONSE           0x21
//#define SMSC_READ_NVRAM                        0x03
#define K_VENDOR_I2C_BRIDGE_READ_STREAM		   0x22
#define K_VENDOR_I2C_BRIDGE_WRITE_STREAM	   0x23
//#define K_VENDOR_I2C_BRIDGE_SET_GPIO_1		   0x24

#define RETRY_MAX                     5
#define REQUEST_SENSE_LENGTH          0x12

#pragma pack(1)
typedef struct {
	unsigned char subCode;
	unsigned char slave_addr;
	unsigned char slave_addr_r;
	unsigned short data_len;
	unsigned char cmd_len;
	unsigned char cmd_data[9];
} Param_I2C_Read_Write_Stream_Type;
typedef struct {
	unsigned char subCode;
	unsigned char flag;     //lint -e754
} Param_I2C_SET_GPIO_1_Type;
typedef struct {
	unsigned char subCode;  //lint -e754
	unsigned char command;  //lint -e754
	unsigned char offset;   //lint -e754
	unsigned char length;   //lint -e754
} CDB_SMSC_NVRAM;
typedef struct {
	unsigned char subCode;  //lint -e754
	unsigned char cmd2[2];  //lint -e754
	unsigned char slave_addr;   //lint -e754
	unsigned short length;  //lint -e754
} I2C_SPI_READ_COMMAND;
typedef struct
{
	unsigned char OperationCode;
	union {
		CDB_SMSC_NVRAM nvParams;    //lint -e754
		I2C_SPI_READ_COMMAND spiReadParams; //lint -e754
		Param_I2C_Read_Write_Stream_Type i2cStream;
		Param_I2C_SET_GPIO_1_Type i2cSetGPIO_1;
	} SMSC_VENDOR_CMD;
} CDB_SMSC;
#pragma pack()

static uint8_t init_data[] = {
0x14,0x28,0x00,0x3B,0x2F,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1C,0xF3,0x69,0x00,
0x03,0x00,0x00,0x00,0x1C,0xF3,0x69,0x00,
0x2F,0x00,0x00,0x00,0x3B,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x01,0x10,0x00,0x11,
0x2F,0x00,0x00,0x00,0x18,0x00,0x00,0x00,
0x70,0xB2,0xAC,0x00,0xF4,0xF2,0x69,0x00,
0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x78,0x01,0xA2,0x00,0x00,0x00,0x00,0x00,
0x50,0x01,0xA2,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xD0,0x72,0xA7,0x00,
0x30,0xB6,0xA9,0x00,0x01,0x01,0x69,0x00,
0x2F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xE0,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x78,0x01,0x00,0x00,0x00,0x00,0x01,0x01,
0x3C,0xF2,0x69,0x00,0x00,0x00,0x00,0x00,
0xBC,0xF3,0x69,0x00,0x1D,0x04,0x4C,0x77,
0xF2,0xB5,0xC8,0x02,0xFE,0xFF,0xFF,0xFF,
0xFA,0x36,0x48,0x77,0xF2,0x32,0x48,0x77,
0x00,0x00,0x00,0x00,0xD0,0x72,0xA7,0x00,
0x08,0x03,0x00,0x00,0x70,0xF3,0x69,0x00,
0x00,0x00,0x00,0x00,0xC8,0x72,0xA7,0x00,
0x50,0xF3,0x69,0x00,0x28,0xE5,0x47,0x77,
0x00,0x00,0xA2,0x00,0x00,0x00,0x00,0x00,
0xD0,0x72,0xA7,0x00,0x60,0xF3,0x69,0x00,
0xFF,0xE4,0x47,0x77,0xD0,0x72,0xA7,0x00,
0x00,0x00,0x00,0x00,0x78,0xF3,0x69,0x00,
0xB0,0xCA,0x5F,0x75,0x70,0xF3,0x69,0x00,
0x88,0x91,0x3A,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xC8,0xF3,0x69,0x00,
0x30,0x11,0x2C,0x69,0x10,0x31,0x74,0x02,
0x00,0x00,0x00,0xC0,0x03,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0x00
};
static uint8_t init_data1[] = {
0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00
};

static uint8_t init_data2[] = {
0x0F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00
};

static uint8_t cdb_length[256] = {
//	 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
	06,06,06,06,06,06,06,06,06,06,06,06,06,06,06,06,  //  0
	06,06,06,06,06,06,06,06,06,06,06,06,06,06,06,06,  //  1
	10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,  //  2
	10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,  //  3
	10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,  //  4
	10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,  //  5
	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,  //  6
	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,  //  7
	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,  //  8
	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,  //  9
	12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,  //  A
	12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,  //  B
	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,  //  C
	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,  //  D
	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,  //  E
	00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,  //  F
};

/* Forward declaration of internal functions */
static S32 configure(void);
static S32 gpio_pullup(void);
static S32 gpio_pulldown(void);
static int send_mass_storage_command(libusb_device_handle *p_handle, uint8_t endpoint, uint8_t lun,uint8_t *cdb, uint8_t direction, int data_length, uint32_t *ret_tag);
static int get_mass_storage_status(libusb_device_handle *p_handle, uint8_t endpoint, uint32_t expected_tag);
static void get_sense(libusb_device_handle *p_handle, uint8_t endpoint_in, uint8_t endpoint_out);
static S32 msc_write_data(U8 *cdb,U8 *buf, U32 len);
static S32 msc_read_data(U8 *cdb,U8 *buf, U32 len);
LOCAL void AUTH_OSSleep(U32 sleep_ms);

U8 g_endpoint_in = 0, g_endpoint_out = 0;	// default IN and OUT endpoints
libusb_device_handle *g_handle=NULL;
S32 iface_detached;

S32 AUTH_init_cp(void)
{
	ETG_TRACE_USR3(("AUTH_init_cp"));
	S32 rc=0;
	if(g_handle==NULL)
	{
		ETG_TRACE_USR3(("AUTH_init_cp"));

		U16 vid=0x0424,pid=0x4040;
		S32 i, j, k;
		S32 iface, nb_ifaces;
		libusb_device *dev;
		struct libusb_config_descriptor *conf_desc;
		const struct libusb_endpoint_descriptor *endpoint;
		rc=libusb_init(NULL);
		if (rc == 0)
		{
			g_handle = libusb_open_device_with_vid_pid(NULL, vid, pid);
			if (g_handle != NULL) {
			
				dev = libusb_get_device(g_handle);
				printf("hello");
				rc=libusb_get_config_descriptor(dev, 0, &conf_desc);
				printf("hello1\n");
				if(rc == 0)
				{
					nb_ifaces = conf_desc->bNumInterfaces;
					
					for (i=0; i<nb_ifaces; i++) 
					{
						for (j=0; j<conf_desc->usb_interface[i].num_altsetting; j++) 
						{
						
							for (k=0; k < conf_desc->usb_interface[i].altsetting[j].bNumEndpoints; k++) 
							{
								endpoint = &conf_desc->usb_interface[i].altsetting[j].endpoint[k];
								printf("       endpoint[%d].address: %02X\n", k, endpoint->bEndpointAddress);
								// Use the first interrupt or bulk IN/OUT endpoints as default for testing
								if ((endpoint->bmAttributes & LIBUSB_TRANSFER_TYPE_MASK) & (LIBUSB_TRANSFER_TYPE_BULK | LIBUSB_TRANSFER_TYPE_INTERRUPT)) 
								{
									if (endpoint->bEndpointAddress & LIBUSB_ENDPOINT_IN)
									{
										if (!g_endpoint_in)
											g_endpoint_in = endpoint->bEndpointAddress;
									} else {
										if (!g_endpoint_out)
											g_endpoint_out = endpoint->bEndpointAddress;
									}
								}
							}	
						}			
					}
					libusb_free_config_descriptor(conf_desc);
					for (iface = 0; iface < nb_ifaces; iface++)
					{
						printf("\nClaiming interface %d...\n", iface);
						rc = libusb_claim_interface(g_handle, iface);
						if ((rc != LIBUSB_SUCCESS) && (iface == 0)) {
							// Maybe we need to detach the driver
							printf("   Failed. Trying to detach driver...\n");
							libusb_detach_kernel_driver(g_handle, iface);
							iface_detached = iface;
							printf("   Claiming interface again...\n");
							rc = libusb_claim_interface(g_handle, iface);
						}
						if (rc != LIBUSB_SUCCESS) {
							printf("   Failed.\n");
						}
					}
					for (iface = 0; iface<nb_ifaces; iface++) 
					{
						printf("Releasing interface %d...\n", iface);
						libusb_release_interface(g_handle, iface);
					}
				}
				ETG_TRACE_USR3(("AUTH_init_cp SUCCESS"));
				//printf("\ng_handle %d",g_handle);
				printf("\nendpoint_in :%d",g_endpoint_in);
				printf("\nendpoint_out :%d",g_endpoint_out);
				
			}
			else
			{
			ETG_TRACE_ERR(("AUTH_init_cp Not able to open the device"));
			rc = -1;
			}
		}else
		{
			printf("libusb_init failed");
			ETG_TRACE_ERR(("AUTH_init_cp libusb_init failed"));
		}
	}
	return rc;
}


S32  AUTH_deinit_cp(void)
{
	ETG_TRACE_USR3(("AUTH_deinit_cp"));
	S32 rc=0;
	if(g_handle!=NULL)
	{
		if (iface_detached >= 0) 
		{
			printf("Re-attaching kernel driver...\n");
			libusb_attach_kernel_driver(g_handle, iface_detached);
		}
		printf("Closing device...\n");
		libusb_close(g_handle);
		g_handle = NULL;
		//libusb_exit(NULL);
	}
	ETG_TRACE_USR3(("AUTH_deinit_cp"));
	return rc;
}



static int get_mass_storage_status(libusb_device_handle *p_handle, uint8_t endpoint, uint32_t expected_tag)
{
	int i,  size,r;
	struct command_status_wrapper csw;
	
	// The device is allowed to STALL this transfer. If it does, you have to
	// clear the stall and try again.
	i = 0;
	do {
		r = libusb_bulk_transfer(p_handle, endpoint, (unsigned char*)&csw, 13, &size, 1000);
		if (r == LIBUSB_ERROR_PIPE) {
			libusb_clear_halt(p_handle, endpoint);
		}
		i++;
	} while ((r == LIBUSB_ERROR_PIPE) && (i<RETRY_MAX));
	printf("\nCSW:");
	printf("\ndCSWSignature :0x%x",*(int*)csw.dCSWSignature);
	printf("\ndCSWTag :0x%x",csw.dCSWTag);
	printf("\ndCSWDataResidue :0x%x",csw.dCSWDataResidue);
	printf("\ndCSWStatus :0x%x\n",csw.bCSWStatus);
	if (r != LIBUSB_SUCCESS) {
		printf("   get_mass_storage_status: %d\n", r);
		printf("error :%d",r);
		return -1;
	}
	if (size != 13) {
		printf("   get_mass_storage_status: received %d bytes (expected 13)\n", size);
		printf("error :%d",r);
		return -1;
	}
	if (csw.dCSWTag != expected_tag) {
		printf("   get_mass_storage_status: mismatched tags (expected %08X, received %08X)\n",
			expected_tag, csw.dCSWTag);
		printf("error :%d",r);
		return -1;
	}
	// For this test, we ignore the dCSWSignature check for validity...
	printf("   Mass Storage Status: %02X (%s)\n", csw.bCSWStatus, csw.bCSWStatus?"FAILED":"Success");
	if (csw.dCSWTag != expected_tag)
		return -1;
	if (csw.bCSWStatus) {
		// REQUEST SENSE is appropriate only if bCSWStatus is 1, meaning that the
		// command failed somehow.  Larger values (2 in particular) mean that
		// the command couldn't be understood.
		if (csw.bCSWStatus == 1)
			return -2;	// request Get Sense
		else
			return -1;
	}

	// In theory we also should check dCSWDataResidue.  But lots of devices
	// set it wrongly.
	return 0;
}

static void get_sense(libusb_device_handle *p_handle, uint8_t endpoint_in, uint8_t endpoint_out)
{
	printf("\nEntering get_sense");
	uint8_t cdb[16];	// SCSI Command Descriptor Block
	uint8_t sense[18];
	uint32_t expected_tag;
	

	// Request Sense
	printf("Request Sense:\n");
	memset(sense, 0, sizeof(sense));
	memset(cdb, 0, sizeof(cdb));
	cdb[0] = 0x03;	// Request Sense
	cdb[4] = REQUEST_SENSE_LENGTH;
	send_mass_storage_command(p_handle, endpoint_out, 0, cdb, LIBUSB_ENDPOINT_IN, REQUEST_SENSE_LENGTH, &expected_tag);
	//libusb_bulk_transfer(p_handle, endpoint_in, (unsigned char*)&sense, REQUEST_SENSE_LENGTH, &size, 1000);
	

	if ((sense[0] != 0x70) && (sense[0] != 0x71)) {
		printf("   ERROR No sense data\n");
	} else {
		printf("   ERROR Sense: %02X %02X %02X\n", sense[2]&0x0F, sense[12], sense[13]);
	}
	// Strictly speaking, the get_mass_storage_status() call should come
	// before these perr() lines.  If the status is nonzero then we must
	// assume there's no data in the buffer.  For xusb it doesn't matter.
	get_mass_storage_status(p_handle, endpoint_in, expected_tag);
	printf("\n Leaving get_sense");
}

static int send_mass_storage_command(libusb_device_handle *p_handle, uint8_t endpoint, uint8_t lun,
	uint8_t *cdb, uint8_t direction, int data_length, uint32_t *ret_tag)
{
	static uint32_t tag = 0x23571113;
	uint8_t cdb_len;
	int i, r=IPOD_AUTH_OK, size;
	struct command_block_wrapper cbw;

	if (cdb == NULL) {
		return -1;
	}

	if (endpoint & LIBUSB_ENDPOINT_IN) {
		printf("send_mass_storage_command: cannot send command on IN endpoint\n");
		return -1;
	}
	
	if(cdb[0]!=0xcf)
	{
		cdb_len = cdb_length[cdb[0]];
		if ((cdb_len == 0) || (cdb_len > sizeof(cbw.CBWCB))) {
			printf("send_mass_storage_command: don't know how to handle this command (%02X, length %d)\n",
				cdb[0], cdb_len);
			return -1;
		}
	}else
	{
		cdb_len=16;
	}
	memset(&cbw, 0, sizeof(cbw));
	cbw.dCBWSignature[0] = 'U';
	cbw.dCBWSignature[1] = 'S';
	cbw.dCBWSignature[2] = 'B';
	cbw.dCBWSignature[3] = 'C';
	*ret_tag = tag;
	cbw.dCBWTag = tag;
	cbw.dCBWDataTransferLength = data_length;
	cbw.bmCBWFlags = direction;
	cbw.bCBWLUN = lun;
	// Subclass is 1 or 6 => cdb_len

	cbw.bCBWCBLength = cdb_len;
	memcpy(cbw.CBWCB, cdb, cdb_len);
	printf("\nCBW:");
	printf("\nbCBWSignature:0x%x",*((int*)cbw.dCBWSignature));
	printf("\nbCBWTag:0x%x",cbw.dCBWTag);
	printf("\nbCBWDataTransferLength:0x%x",cbw.dCBWDataTransferLength);
	printf("\ncbw.bmCBWFlags:0x%x",cbw.bmCBWFlags);
	printf("\ncbw.bCBWLUN:0x%x",cbw.bCBWLUN);
	printf("\ncbw.bCBWCBLength:0x%x",cbw.bCBWCBLength);
	printf("\ncbw.CBWCB:0x");
#if 0
	for(i=0;i<cdb_len;i++)
	{
		printf("%x,",cbw.CBWCB[i]);
	}
	printf("\n");
#endif
	i = 0;
	do {
		// The transfer length must always be exactly 31 bytes.
		r = libusb_bulk_transfer(p_handle, endpoint, (unsigned char*)&cbw, 31, &size, 1000);
		if (r == LIBUSB_ERROR_PIPE) {
			libusb_clear_halt(p_handle, endpoint);
		}
		i++;
	} while ((r == LIBUSB_ERROR_PIPE) && (i<RETRY_MAX));
	if (r != LIBUSB_SUCCESS) {
		printf("\nsend_mass_storage_command: %d\n", r);
		return IPOD_AUTH_ERROR;
	}

	printf("\nsent %d CDB bytes\n", cdb_len);
	return r;
}

static int send_CDB(libusb_device_handle *p_handle, uint8_t endpoint, uint8_t lun,
	uint8_t *cdb, uint8_t direction, int data_length,uint8_t cdb_len)
{
		static uint32_t tag = 0x23571113;
		struct command_block_wrapper cbw;
		int i, r=IPOD_AUTH_OK, size;
		if (cdb == NULL) {
		return -1;
		}
		if (endpoint & LIBUSB_ENDPOINT_IN) {
		printf("send_mass_storage_command: cannot send command on IN endpoint\n");
		return -1;
		}
		memset(&cbw, 0, sizeof(cbw));
		cbw.dCBWSignature[0] = 'U';
		cbw.dCBWSignature[1] = 'S';
		cbw.dCBWSignature[2] = 'B';
		cbw.dCBWSignature[3] = 'C';
		cbw.dCBWTag = tag;
		cbw.dCBWDataTransferLength = data_length;
		cbw.bmCBWFlags = direction;
		cbw.bCBWLUN = lun;
		cbw.bCBWCBLength = cdb_len;
		memcpy(cbw.CBWCB, cdb, cdb_len);
		printf("\nCBW:");
		printf("\nbCBWSignature:0x%x",*((int*)cbw.dCBWSignature));
		printf("\nbCBWTag:0x%x",cbw.dCBWTag);
		printf("\nbCBWDataTransferLength:0x%x",cbw.dCBWDataTransferLength);
		printf("\ncbw.bmCBWFlags:0x%x",cbw.bmCBWFlags);
		printf("\ncbw.bCBWLUN:0x%x",cbw.bCBWLUN);
		printf("\ncbw.bCBWCBLength:0x%x",cbw.bCBWCBLength);
		printf("\ncbw.CBWCB:0x");
#if 0
		for(i=0;i<cdb_len;i++)
		{
			printf("%x,",cbw.CBWCB[i]);
		}
		printf("\n");
#endif
		i = 0;
		do {
			// The transfer length must always be exactly 31 bytes.
			r = libusb_bulk_transfer(p_handle, endpoint, (unsigned char*)&cbw, 31, &size, 1000);
			if (r == LIBUSB_ERROR_PIPE) {
				libusb_clear_halt(p_handle, endpoint);
			}
			i++;
		} while ((r == LIBUSB_ERROR_PIPE) && (i<RETRY_MAX));
		if (r != LIBUSB_SUCCESS) {
			printf("\nsend_mass_storage_command: %d\n", r);
			return -1;
		}

		printf("\nsent %d CDB bytes\n", cdb_len);
		return r;
}

S32 msc_write_data(U8 *cdb,U8 *buf, U32 len)
{
	int r=IPOD_AUTH_OK, size=0,i=0;
	uint8_t lun=0;
	uint32_t expected_tag=0x23571113;
	r=send_CDB(g_handle,g_endpoint_out,lun,cdb, LIBUSB_ENDPOINT_OUT,len, sizeof(CDB_SMSC));
	if(r==IPOD_AUTH_OK)
	{
		do 
		{
			// The transfer length must always be exactly 31 bytes.
			r=libusb_bulk_transfer(g_handle, g_endpoint_out, buf,len, &size, 5000);
			if (r == LIBUSB_ERROR_PIPE) 
			{
				libusb_clear_halt(g_handle, g_endpoint_out);
			}
			i++;
		} while ((r == LIBUSB_ERROR_PIPE) && (i<RETRY_MAX));
		if (r != LIBUSB_SUCCESS) 
		{
			printf("\n write is failed: %d\n", r);
			return IPOD_AUTH_ERROR;
		}
		r=get_mass_storage_status(g_handle, g_endpoint_in, expected_tag);
		if(r!=IPOD_AUTH_OK)
		{
			if ( r == -2) {
				get_sense(g_handle, g_endpoint_in, g_endpoint_out);
			}
			r=IPOD_AUTH_ERROR;
		}
		else
		{
			if(size!=len)
			{
				ETG_TRACE_USR3(("expected size is not matching :%d",size));
				r=IPOD_AUTH_ERROR;
			}
		}
	}else
	{
		r=IPOD_AUTH_ERROR;
	}
	return r;
}

S32 msc_read_data(U8 *cdb,U8 *buf, U32 len)
{
    ETG_TRACE_USR3(("%d", len));
	printf("> msc_read_data\n");
	int r=IPOD_AUTH_OK, size=0;
	uint8_t lun=0;
	uint8_t i=0;
	uint32_t expected_tag=0x23571113;
	r=send_CDB(g_handle, g_endpoint_out, lun,cdb, LIBUSB_ENDPOINT_IN, len, sizeof(CDB_SMSC));
	if(r==IPOD_AUTH_OK)
	{
		do 
		{
			// The transfer length must always be exactly 31 bytes.
			r=libusb_bulk_transfer(g_handle, g_endpoint_in, buf, len, &size, 5000);
			if (r == LIBUSB_ERROR_PIPE) 
			{
				libusb_clear_halt(g_handle, g_endpoint_in);
			}
			i++;
		} while ((r == LIBUSB_ERROR_PIPE) && (i<RETRY_MAX));
		if (r != LIBUSB_SUCCESS) 
		{
			ETG_TRACE_USR3(("read is failed: %d", r));
			return IPOD_AUTH_ERROR;
		}
		r=get_mass_storage_status(g_handle, g_endpoint_in, expected_tag);
		if(r!=0)
		{
			if ( r == -2) {
				get_sense(g_handle, g_endpoint_in, g_endpoint_out);
			}
			r=IPOD_AUTH_ERROR;
		}else
		{
			if(size!=len)
			{
				ETG_TRACE_USR3(("expected size is not read :%d",size));
				r=IPOD_AUTH_ERROR;
			}
		}
		/*for(i=0;i<len;i++)
		{
			printf("%d",(U8)buf[i]);
		}*/
		printf("< msc_read_data\n");
	}else
	{
		r=IPOD_AUTH_ERROR;
	}
		
	return r;
}

S32 AUTH_reset_cp()
{
	ETG_TRACE_USR3(("AUTH_reset_cp"));
int r=IPOD_AUTH_OK;
	r=configure();
	if(r==IPOD_AUTH_OK)
	{
		r=gpio_pulldown();
		if(r==IPOD_AUTH_OK)
		{
			r=gpio_pullup();
			if(r==IPOD_AUTH_OK)
			{
				AUTH_OSSleep(1000);
			}
		}
	}		
	
	return r;
	
}

S32 AUTH_read_cp(S32 read_addr, VP buf, U32 length)
{
	ETG_TRACE_USR3(("AUTH_read_cp"));
	int r=IPOD_AUTH_OK;
	CDB_SMSC      *Cdb=NULL;
	Cdb =(CDB_SMSC*)malloc(sizeof(CDB_SMSC));
	if(Cdb==NULL)
	{
		printf("Error in allocation");
		return IPOD_AUTH_ERR_NOMEM;
	}
	//cf,20,00,00,00,00,00,00,00,00,00,00,00,00,00,00"
	// intialiaze
	memset(Cdb, 0, sizeof(CDB_SMSC));
	//commands	
	Cdb->OperationCode    = SMSC_VENDOR_SPECIFIC_COMMAND;
	Cdb->SMSC_VENDOR_CMD.i2cStream.subCode      = K_VENDOR_I2C_BRIDGE_READ_STREAM;
	Cdb->SMSC_VENDOR_CMD.i2cStream.data_len = htons(length);
	Cdb->SMSC_VENDOR_CMD.i2cStream.cmd_len = 1;
	Cdb->SMSC_VENDOR_CMD.i2cStream.cmd_data[0] = read_addr;
	Cdb->SMSC_VENDOR_CMD.i2cStream.slave_addr =0x22;
	Cdb->SMSC_VENDOR_CMD.i2cStream.slave_addr_r = 0x23;
	r=msc_read_data((U8*)Cdb,(U8*)buf,length);
	free(Cdb);
	return r;
} 

S32 AUTH_write_cp(S32 read_addr, VP buf, U32 length)
{
	ETG_TRACE_USR3(("AUTH_write_cp"));
	int r=IPOD_AUTH_OK;
	CDB_SMSC      *Cdb=NULL;
	Cdb =(CDB_SMSC*)malloc(sizeof(CDB_SMSC));
	if(Cdb==NULL)
	{
		printf("Error in allocation");
		return IPOD_AUTH_ERR_NOMEM;
	}
	//cf,20,00,00,00,00,00,00,00,00,00,00,00,00,00,00"
	// intialiaze
	memset(Cdb, 0, sizeof(CDB_SMSC));
	//commands	
	Cdb->OperationCode    = SMSC_VENDOR_SPECIFIC_COMMAND;
	Cdb->SMSC_VENDOR_CMD.i2cStream.subCode      = K_VENDOR_I2C_BRIDGE_WRITE_STREAM;
	Cdb->SMSC_VENDOR_CMD.i2cStream.data_len = htons(length);
	Cdb->SMSC_VENDOR_CMD.i2cStream.cmd_len = 1;
	Cdb->SMSC_VENDOR_CMD.i2cStream.cmd_data[0] = read_addr;
	Cdb->SMSC_VENDOR_CMD.i2cStream.slave_addr =0x22;
	//Cdb->SMSC_VENDOR_CMD.i2cStream.slave_addr_r = 0x23;
	r=msc_write_data((U8*)Cdb,(U8*)buf,length);
	free(Cdb);
	return r;
} 
static S32 configure()
{
	int r=IPOD_AUTH_OK;
	CDB_SMSC      *Cdb=NULL;
	Cdb =(CDB_SMSC*)malloc(sizeof(CDB_SMSC));
	if(Cdb==NULL)
	{
		printf("Error in allocation");
		return IPOD_AUTH_ERR_NOMEM;
	}
	memset(Cdb, 0, sizeof(CDB_SMSC));
	Cdb->OperationCode    = SMSC_VENDOR_SPECIFIC_COMMAND;
	Cdb->SMSC_VENDOR_CMD.i2cSetGPIO_1.subCode      = 0x20;
	r=msc_write_data((U8*)Cdb,init_data,sizeof(init_data));
	free(Cdb);
	return r;
}

static S32 gpio_pullup()
{
	int r=IPOD_AUTH_OK;
	CDB_SMSC      *Cdb=NULL;
	Cdb =(CDB_SMSC*)malloc(sizeof(CDB_SMSC));
	if(Cdb==NULL)
	{
		printf("Error in allocation");
		return IPOD_AUTH_ERR_NOMEM;
	}
	memset(Cdb, 0, sizeof(CDB_SMSC));
	Cdb->OperationCode    = SMSC_VENDOR_SPECIFIC_COMMAND;
	Cdb->SMSC_VENDOR_CMD.i2cSetGPIO_1.subCode      = 0x20;
	r=msc_write_data((U8*)Cdb,init_data2,sizeof(init_data2));
	free(Cdb);
	return r;
}

static S32 gpio_pulldown()
{
	int r=IPOD_AUTH_OK;
	CDB_SMSC      *Cdb=NULL;
	Cdb =(CDB_SMSC*)malloc(sizeof(CDB_SMSC));
	if(Cdb==NULL)
	{
		printf("Error in allocation");
		return IPOD_AUTH_ERR_NOMEM;
	}
	memset(Cdb, 0, sizeof(CDB_SMSC));
	Cdb->OperationCode    = SMSC_VENDOR_SPECIFIC_COMMAND;
	Cdb->SMSC_VENDOR_CMD.i2cSetGPIO_1.subCode      = 0x20;
	msc_write_data((U8*)Cdb,init_data1,sizeof(init_data1));
	free(Cdb);
	return r;
}

LOCAL void AUTH_OSSleep(U32 sleep_ms)
{
    S32 s32ReturnValue = IPOD_AUTH_ERROR;
    struct timespec req;
    struct timespec remain;

    /* Initialize the structure */
    memset(&req, 0, sizeof(req));
    memset(&remain, 0, sizeof(remain));


    req.tv_sec = sleep_ms / IPOD_AUTH_MSEC;
    req.tv_nsec = (sleep_ms % IPOD_AUTH_MSEC) * IPOD_AUTH_NSEC;

    while(1)
    {
        s32ReturnValue = nanosleep(&req, &remain);

        if (s32ReturnValue == 0)
        {
            break;
        }
        else
        {
            if (errno == EINTR)
            {
                req.tv_sec = remain.tv_sec ;
                req.tv_nsec = remain.tv_nsec;
            }
            else
            {
                break;
            }
        }
    }// end while

}
