/*!
*******************************************************************************
* \file              ipodauth_tclRegistry.cpp
*******************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   VD-IPod authentication
*  - DESCRIPTION:    Registry handler.
*  - COPYRIGHT:      &copy; 2011 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 14.03.2011 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "ipodauth_tclRegistry.h"
#include "ipodauth_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_IPODAUTH_APP
#include "trcGenProj/Header/ipodauth_tclRegistry.cpp.trc.h"
#endif

/******************************************************************************
| defines and macros (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function prototype (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function implementation (scope: external-interfaces)
|----------------------------------------------------------------------------*/

/******************************************************************************
** FUNCTION:  ipodauth_tclRegistry::ipodauth_tclRegistry(tCString cszRegKe..)
******************************************************************************/

ipodauth_tclRegistry::ipodauth_tclRegistry
(
   tCString cszRegKey
   , ipodauth_enRegAccess enAccess
): reg_tclRegKey(cszRegKey)
{
   // Depending on access type open the 
   switch (enAccess)
   {
      case IPODAUTH_EN_CREAT:
      {
         if (FALSE == bCreate(cszRegKey)) //lint !e1506
         {
            ETG_TRACE_ERR(("[%d]Failed to create the registry: %s."
               , ETG_ENUM(OSAL_ERROR, OSAL_u32ErrorCode()), cszRegKey));
         }
      }
      break;

      case IPODAUTH_EN_RDWR:
      {
         if (FALSE == bOpen(cszRegKey)) //lint !e1506
         {
            ETG_TRACE_ERR(("[%d]Failed to create the registry: %s."
               , ETG_ENUM(OSAL_ERROR, OSAL_u32ErrorCode()), cszRegKey));
         }
      }
      break;
      default:
      {
         // Do nothing. ;-)
      }
      break;
   }  // switch (enAccess)

}  // ipodauth_tclRegistry::ipodauth_tclRegistry(tCString cszRegKey, ipodauth..

/******************************************************************************
** FUNCTION:  virtual ipodauth_tclRegistry::~ipodauth_tclRegistry()
******************************************************************************/

/*virtual*/
ipodauth_tclRegistry::~ipodauth_tclRegistry()
{}

/******************************************************************************
** FUNCTION:  virtual tBool ipodauth_tclRegistry::bAdd(tCString cszRegSubKey,..
******************************************************************************/

/*virtual*/
tBool ipodauth_tclRegistry::bAdd(tCString cszRegSubKey, tU32 u32Value)
{
   tBool bRetVal  =  FALSE;

   // Check for null ptr & then set the sub key.
   if ((OSAL_NULL != cszRegSubKey) && (TRUE == bSetU32(cszRegSubKey, u32Value)))
   {
      bRetVal  =  TRUE;
   }  // if ((OSAL_NULL != cszRegSubKey) && (TRUE == bSetU32(cszRegSubKey, u3..
   else
   {
      ETG_TRACE_ERR(("Failed to set the value :%d to sub key:%s!!!", u32Value
         , cszRegSubKey));
   }  // End of if-else; if ((OSAL_NULL != cszRegSubKey) && (TRUE == bSetU32(c..

   return bRetVal;
}  // tBool ipodauth_tclRegistry::bAdd(tCString cszRegSubKey, tU32 u32Value)


/******************************************************************************
** FUNCTION:  virtual tBool ipodauth_tclRegistry::bAdd(tCString cszRegSubKey,..
******************************************************************************/

/*virtual*/
tBool ipodauth_tclRegistry::bAdd(tCString cszRegSubKey, tCString cszValue)
{
   tBool bRetVal  =  FALSE;

   // Check for null ptr & then set the sub key.
   if ((OSAL_NULL != cszRegSubKey) && (OSAL_NULL != cszValue))
   {
      if (TRUE == bSetString(cszRegSubKey, (tChar*)cszValue, OSAL_u32StringLength(cszValue))) //lint !e1773
      {
         bRetVal  =  TRUE;
      }
      else
      {
         ETG_TRACE_ERR(("Failed to set the string value to sub key:%s!!!"
            , cszRegSubKey));
      } 
      
   }  // if ((OSAL_NULL != cszRegSubKey) && (TRUE == bSetU32(cszRegSubKey, u3..
    
   return bRetVal;
}  // tBool ipodauth_tclRegistry::bAdd(tCString cszRegSubKey, tU32 u32Value)

////////////////////////////////////////////////////////////////////////////////
// <EOF>
