/*!
********************************************************************************
* \file              ipodauth_tclMainApp.cpp
********************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   VD-iPod Authentication
*  - DESCRIPTION:    Main VD-iPodAuth Application - based on eXtended CCA
*  - COPYRIGHT:      &copy; 2010 Robert Bosch GmbH, Hildesheim
********************************************************************************
* \date 14.03.2011 \version 1.3 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - Modified the diaglib interface to reduce dependency in Main application.
*
* \date 10.03.2011 \version 1.2 \author Ramkumar Muniraj (RBEI/ECV1)
* - Added interface for Diagnosis Diaglib.
*
* \date 13.01.2011 \version 1.1 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - Migrated codebase to use Infotainment Helper Library (IHL).
*
* \date 18.10.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
*******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

// Includes to utilize the BP STL exceptional handler
//#define SYSTEM_S_IMPORT_INTERFACE_EXH
#include <functional>
//#include <stl_pif.h>
//using namespace bpstl;
using namespace std;

#include "ipodauth_tclMainApp.h"
#include "ipodauth_tcliPodAuthService.h"
#include "ipodauth_tclImpTraceStreamable.h"
#include "ipodauth_Trace.h"
#include "ipodauth_tclDiagLibHandler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_IPODAUTH_APP
#include "trcGenProj/Header/ipodauth_tclMainApp.cpp.trc.h"
#endif

/******************************************************************************
| gcov related headers & defines for code/test coverage.
|----------------------------------------------------------------------------*/

#ifdef GCOV_ENABLED

#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>

#ifdef __cplusplus
extern "C" tVoid __gcov_flush(tVoid);
#endif

#endif   // #ifdef GCOV_ENABLED

/******************************************************************************
| defines and macros (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/*static*/
ihl_tclTraceStreamable* ipodauth_tclMainApp::m_poTraceStreamer  =  OSAL_NULL;

/******************************************************************************
| function prototype (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function implementation (scope: external-interfaces)
|----------------------------------------------------------------------------*/
#define EVENT_SHUTDOWN_NAME "SHUTDOWN_IPODAUTH"
#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

/******************************************************************************
** FUNCTION:  ipodauth_tclMainApp::ipodauth_tclMainApp()
******************************************************************************/
ipodauth_tclMainApp::ipodauth_tclMainApp():ahl_tclBaseOneThreadApp()
, m_poiPodAuthService(OSAL_NULL), m_poiPodDiagLibHandler(OSAL_NULL)
{
   ETG_TRACE_USR1(("ipodauth_tclMainApp() entered."));
}  // ipodauth_tclMainApp::ipodauth_tclMainApp()

/******************************************************************************
** FUNCTION:  ipodauth_tclMainApp::~ipodauth_tclMainApp()
******************************************************************************/

/*virtual*/
ipodauth_tclMainApp::~ipodauth_tclMainApp()
{
   ETG_TRACE_USR1(("~ipodauth_tclMainApp() entered."));

   try //_BP_TRY_BEGIN // Currently disabled - try-catch construct giving Lint Prio1
   {
      // Clean up the resources.
      vCleanup();
   }    // _BP_TRY_BEGIN
   catch(...) //_BP_CATCH_ALL
   {
   }  // _BP_CATCH_ALL
   //_BP_CATCH_END

   m_poiPodAuthService     =  OSAL_NULL;
   m_poiPodDiagLibHandler  =  OSAL_NULL;
   m_poTraceStreamer       =  OSAL_NULL;

}  // ipodauth_tclMainApp::~ipodauth_tclMainApp()

/******************************************************************************
** FUNCTION:  tBool ipodauth_tclMainApp::bOnInit()
******************************************************************************/

/*virtual*/
tBool ipodauth_tclMainApp::bOnInit()
{
   ETG_TRACE_USR2(("bOnInit() entered."));
   tBool bSucc =  TRUE;

   m_poiPodAuthService =  OSAL_NEW ipodauth_tcliPodAuthService(this);

   if (OSAL_NULL != m_poiPodAuthService)
   {
      ETG_TRACE_USR4(("iPod Authentication service object address: 0x%x"
         , m_poiPodAuthService));
   }
   else
   {
      ETG_TRACE_ERR(("Failed to create the iPod Authentication Service."));
      bSucc =  FALSE;
      NORMAL_M_ASSERT_ALWAYS();
   }  // End of if-else; if (OSAL_NULL != m_poiPodAuthService)

   m_poiPodDiagLibHandler  =  OSAL_NEW ipodauth_tclDiagLibHandler(this);

   if (OSAL_NULL != m_poiPodDiagLibHandler)
   {
      ETG_TRACE_USR4(("iPod DiagLib object address: 0x%x", m_poiPodDiagLibHandler));
   }
   else
   {
      ETG_TRACE_ERR(("Failed to create the iPod Diaglib handler."));
      bSucc =  FALSE;
   }  // End of if-else; if (OSAL_NULL != m_poiPodAuthService)

   m_poTraceStreamer =  OSAL_NEW ipodauth_tclImpTraceStreamable(this);

   if (OSAL_NULL != m_poTraceStreamer)
   {
      ETG_TRACE_USR4(("Trace Cmd Streamer object address: 0x%x", m_poTraceStreamer));

      // Setup the commands.
      m_poTraceStreamer->vSetupCmds();

      // Plug in the Trace channel
      vPlugTraceIn(IPODAUTH_TRACE_CHANNEL, (OSAL_tpfCallback)vHandleTraceCmd);
   }
   else
   {
      ETG_TRACE_ERR(("Failed to create the Trace Cmd Streamer."));
      bSucc =  FALSE;
   }  // End of if-else; if (OSAL_NULL != m_poTraceStreamer)

   ETG_TRACE_USR2(("Status: %d, bOnInit() exited.", ETG_CENUM(ipodauth_tenSuccess, bSucc)));

   return bSucc;
}  // tBool ipodauth_tclMainApp::bOnInit()

/******************************************************************************
** FUNCTION:  tVoid ipodauth_tclMainApp::vOnApplicationClose()
******************************************************************************/

/*virtual*/
tVoid ipodauth_tclMainApp::vOnApplicationClose()
{
   ETG_TRACE_USR3(("vOnApplicationClose() entered."));

   // Clean up the resources & call base class app close.
   vCleanup();

   ahl_tclBaseOneThreadApp::vOnApplicationClose();

   ETG_TRACE_USR3(("vOnApplicationClose() exited."));
}  // tVoid ipodauth_tclMainApp::vOnApplicationClose()

/******************************************************************************
** FUNCTION:  tVoid ipodauth_tclMainApp::vCleanup()
******************************************************************************/

tVoid ipodauth_tclMainApp::vCleanup()
{
   ETG_TRACE_USR3(("vCleanup() entered."));

   OSAL_DELETE m_poiPodAuthService;
   m_poiPodAuthService =  OSAL_NULL;

   OSAL_DELETE m_poiPodDiagLibHandler;
   m_poiPodDiagLibHandler =  OSAL_NULL;

   OSAL_DELETE m_poTraceStreamer;
   m_poTraceStreamer =  OSAL_NULL;

   ETG_TRACE_USR3(("vCleanup() exited."));
}  // tVoid ipodauth_tclMainApp::vCleanup()

/******************************************************************************
** FUNCTION:  tVoid ipodauth_tclMainApp::vHandleTraceCmd(tU8 const* const cpu8B..
******************************************************************************/

/*static*/
tVoid ipodauth_tclMainApp::vHandleTraceCmd(tU8 const* const cpu8Buffer)
{
   ETG_TRACE_USR4(("Recieved a Trace command."));

   if ((OSAL_NULL != ipodauth_tclMainApp::m_poTraceStreamer)
      && (OSAL_NULL != cpu8Buffer) && (0 < cpu8Buffer[0]))
   {
      tBool bStat  = ipodauth_tclMainApp::m_poTraceStreamer->bStream(cpu8Buffer);

      ETG_TRACE_USR4(("Trace streaming status: %d", ETG_CENUM(ipodauth_tenSuccess, bStat)));
   }
   else
   {
      ETG_TRACE_ERR(("Trace Streamer unavailable."));
   }
}  // tVoid ipodauth_tclMainApp::vHandleTraceCmd(tU8 const* const cpu8Buffer)

////////////////////////////////////////////////////////////////////////////////

//#ifdef SYSTEM_S_USE_BPSTL
//extern tBool exh_bInitExceptionHandling(tVoid);
//#endif

extern "C" OSAL_DECL tS32 vStartApp(tS32 cPar, tString aPar[]) // finished: 50%
{
    (tVoid)cPar;
    (tVoid)aPar;

    OSAL_tEventHandle  hEvShutdown = 0;
    OSAL_tEventMask    hEvRequest  = 0x00000001;

    et_vTraceOpen();
    et_vTraceBuffer(TR_TTFIS_SYSMANAGER, TR_LEVEL_DATA, 9, "START IPODAUTH ");
    scd_init();

    if (OSAL_s32EventCreate(EVENT_SHUTDOWN_NAME, &hEvShutdown) == OSAL_ERROR)
    {
        ETG_TRACE_FATAL(("ipodauth_tclMainApp: Creation of SPM shutdown event failed!!!"));
        NORMAL_M_ASSERT_ALWAYS();
    }


#ifdef VARIANT_S_FTR_ENABLE_PROCESS_READS_ITS_REGISTRY
    OSAL_tIODescriptor  regHandle;
    if((regHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY,OSAL_EN_READWRITE)) != OSAL_ERROR )
    {
        //[GMP] take care that  ai_mediaplayer/config/packages/pkg_mediaplayer.xml installs this
        //[MMP] take care that ai_mediaplayer/MultiMediaPlayer/2_config/packages/pkg_mediaplayer.xml installs this
        if((OSAL_s32IOControl(regHandle, OSAL_C_S32_IOCTRL_BUILD_REG,(intptr_t) "/dev/root/opt/bosch/base/registry/vd_ipodauth.reg")) == OSAL_OK)
        {
            ETG_TRACE_FATAL(("[OK]  REGISTRY loaded: /dev/root/opt/bosch/base/registry/vd_ipodauth.reg"));
        }
        else
        {
            ETG_TRACE_FATAL(("[NOK] REGISTRY failed to load: /dev/root/opt/bosch/base/registry/vd_ipodauth.reg"));
            ETG_TRACE_ERRMEM(("[NOK] REGISTRY failed to load: /dev/root/opt/bosch/base/registry/vd_ipodauth.reg"));
        }
    }
    OSAL_s32IOClose(regHandle);
#endif


    // Activate Exception Handling
    /*tBool bRetVal = exh_bInitExceptionHandling();
    if (bRetVal != TRUE)
    {
        ETG_TRACE_FATAL(("ipodauth_tclMainApp: exh_bInitExceptionHandling failed"));
        NORMAL_M_ASSERT_ALWAYS();
    }*/

    ipodauth_tclMainApp *poApp = new ipodauth_tclMainApp;
    if (NULL != poApp)
    {
        if (!poApp->bInitInstance(0, CCA_C_U16_APP_IPODAUTH))
        {
            ETG_TRACE_FATAL(("poApp->bInitInstance() failed!"));
            NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
            ETG_TRACE_SYS(("poApp->bInitInstance() success!"));
        }
    }

    // Wait for Shutdown-Signal. However, will never called in GM system
    OSAL_s32EventWait(hEvShutdown, hEvRequest, OSAL_EN_EVENTMASK_OR, OSAL_C_TIMEOUT_FOREVER, &hEvRequest);
    if (poApp != NULL)
    {
        poApp->vDeinitInstance();
        delete poApp;
    }


    OSAL_s32EventClose(hEvShutdown);
    OSAL_s32EventDelete(EVENT_SHUTDOWN_NAME);
    et_vTraceClose();

    return OSAL_OK;
}

// <EOF>
