/*!
********************************************************************************
* \file              ipodauth_tclDiagRoutineCtrlHandler.h
********************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   VD-iPod Authentication
*  - DESCRIPTION:    Implementation of a Dignosis RoutineControl Listener
*  - COPYRIGHT:      &copy; 2011 Robert Bosch GmbH, Hildesheim
********************************************************************************
* \date 14.03.2011 \version 1.2 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - Doxygen document adaptations.
*
* \date 10.03.2011 \version 1.1 \author Ramkumar Muniraj (RBEI/ECV1)
* - Modified for Ipod Self test. 
*
* \date 12.11.2010 \version 1.0 \author TMS Plischke 
* \bug No known bugs
*******************************************************************************/

#ifndef IPOD_TCLDIAGROUTINEHANDLER_H_
#define IPOD_TCLDIAGROUTINEHANDLER_H_

/*******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|-----------------------------------------------------------------------------*/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>

#define DIAGLIB_INCLUDE_ID_SPEC_TYPES
#define DIAGLIB_INCLUDE_GENERIC
#include <diaglib_if.h>
using namespace diaglib;

/*******************************************************************************
| defines and macros (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| typedefs (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| forward declarations
|-----------------------------------------------------------------------------*/

/*! 
 * \class ipodauth_tclDiagRoutineCtrlHandler
 * \brief VD-iPodAuth diag routine control handler.
 *
 * \note Message are received by implementing ListenerInterfaces and registering 
 * them with diagnosis library.
 */

class ipodauth_tclDiagRoutineCtrlHandler: public tclRoutineControlListenerIF
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ipodauth_tclDiagRoutineCtrlHandler::ipodauth_tclDiagRoutine..
   ***************************************************************************/
   /*!
    * \brief   Parameterized Constructor, based on Dependency Injection 
    *          Principle (DIP)
    * \param   [cpoDiaglibService]: (->I) Pointer to diaglib service.
    * \retval  NONE
    * \date 10.03.2011 \author Ramkumar Muniraj (RBEI/ECV1)
    **************************************************************************/
   ipodauth_tclDiagRoutineCtrlHandler(tclServiceDiaglib* const cpoDiaglibService);

   /***************************************************************************
   ** FUNCTION:  virtual ipodauth_tclDiagRoutineCtrlHandler::~ipodauth_tclDia..
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 10.03.2011 \author Ramkumar Muniraj (RBEI/ECV1)
    **************************************************************************/
   virtual ~ipodauth_tclDiagRoutineCtrlHandler();

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/
protected:

   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/
   
   /***************************************************************************
   ** FUNCTION:  tU32 ipodauth_tclDiagRoutineCtrlHandler::vOnGetRoutineResult...
   ***************************************************************************/
   /*!
   * \brief Incoming Get Routine result event handler
   *
   * Is called on incoming "Get Routine Result" requests. Components reaction 
   * should be one of the following:
   * \li You found the routine results: Send back a RoutineResult message 
   *     containing poMsgContext, tenRoutineCtrlResult (PASSED or 
   *     FAILED)and the result vector as specififed in the ID spec.
   * \li You can't find the routine results: Send back a RoutineResult 
   *     message containing poMsgContext, tenRoutineCtrlResult 
   *     (NO_RESULT_AVAILABLE) and an ResultVector containing exactly one 
   *     parameter of type U8_ERROR and the value ROUTINE_NEVER_RAN or 
   *     ROUTINE_STILL_RUNNING.
   *
   * \param   [u32RoutineId]: (I)   Routine control ID of the incoming request
   * \param   [poMsgContext]: (->I) Internal message context. Just return 
   *          exactly this context when you answer to this request.
   * \return  [tU32] ResultCode,  0 always.
   * \date 10.03.2011 \author Ramkumar Muniraj (RBEI/ECV1)
   **************************************************************************/
   virtual tU32 vOnGetRoutineResult(tU32 /*u32RoutineId*/
      , tContext /*MsgContext*/){ return 0; };

   /***************************************************************************
   ** FUNCTION:  tU32 ipodauth_tclDiagRoutineCtrlHandler::vOnRoutineControlA...
   ***************************************************************************/
   /*!
    * \brief Incoming Routine control abort event handler
    *
    * Is called on incoming "Abort routine control" requests. Components 
    * reaction should be one of the following:
    * \li The routine is running: Inform the routine (Worker Thread) that is 
    *     supposed to stop. After it stopped in fact or immediately before it 
    *     does send a RoutineResult message containig the following: 
    *     poMsgContext, tenRoutineCtrlResult (ABORTED) and an empty 
    *     result vector.
    * \li The routine is NOT running: Send back a RoutineResult message 
    *     containing poMsgContext, tenRoutineCtrlResult 
    *     (COULD_NOT_BE_ABORTED) and a ResultVector containing exactly one 
    *     parameter of type U8_ERROR and the value ROUTINE_NOT_RUNNING.
    *
    * \param   [u32RoutineId]:   (I)   RoutineID diagnosis wants to be aborted
    * \param   [poMsgContext]:   (->I) Internal message context. Just return 
    *          exactly this context when you answer to this request.
    * \return  [tU32] ResultCode, 0 always.
    * \date 10.03.2011 \author Ramkumar Muniraj (RBEI/ECV1)
    **************************************************************************/
   virtual tU32 vOnRoutineControlAbort(tU32 /*u32RoutineId*/
      , tContext /*MsgContext*/){ return 0; };

   /***************************************************************************
   ** FUNCTION:  tU32 ipodauth_tclDiagRoutineCtrlHandler::vOnRoutineControlS...
   ***************************************************************************/
   /*!
    * \brief Incoming Routine control start event handler
    *
    * Is called on incoming "Start routine control" requests. Components 
    * reaction should be one of the following:
    * \li Start long running test and answer with ROUTINE_CONTROL_STARTED
    * \li Execute short running test (one second or less) and respond with
    *     ROUTINE_CONTROL_OK and result
    * \li In case of error answer with ROUTINE_CONTROL_NOT_OK and provide
    *     internal error code in vector.
    *
    * \param   [u32RoutineId]:(I)   Routine ID diagnosis wants to be started
    * \param   [u32Bitmask]:  (I)   Bitmask containing flags that specify how the 
    *          routine should be runned. The ID dependent part of this 
    *          bitmask is described in the ID spec.
    * \param   [rfcoParamVector]:(I)   Parameter vector for the routine that 
    *          should be started. Defined in the ID spec.
    * \param   [poMsgContext]:   (->I) Internal message context. 
    *          Just return exactly this context when you answer to this request.
    * \return  [tU32] ResultCode
    * \date 10.03.2011 \author Ramkumar Muniraj (RBEI/ECV1)
    **************************************************************************/
   virtual tU32 vOnRoutineControlStart(tU32 u32RoutineId, tU32 /*u32Bitmask*/
      , const tclParameterVector& /*rfcoParamVector*/, tContext MsgContext);

   /***************************************************************************
   ** FUNCTION:  ipodauth_tclDiagRoutineCtrlHandler::ipodauth_tclDiagRoutine...
   ***************************************************************************/
   /*!
    * \brief   Default Constructor
    * \param   NONE
    * \retval  NONE
    * \note    Default constructor is declared protected to disable it. So 
    *          that any attempt to create without parameter will be caught by 
    *          the compiler.
    * \date 14.03.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ipodauth_tclDiagRoutineCtrlHandler();

   /***************************************************************************
   ** FUNCTION:  ipodauth_tclDiagRoutineCtrlHandler::ipodauth_tclDiagRoutin..
   ***************************************************************************/
   /*!
    * \brief   Copy Constructor
    * \param   [rfcoiPodRC]: (I) Const reference to object to be copied
    * \retval  NONE
    * \note    Default copy constructor is declared protected to disable it. So 
    *          that any attempt to copy will be caught by the compiler.
    * \date 14.03.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ipodauth_tclDiagRoutineCtrlHandler(const ipodauth_tclDiagRoutineCtrlHandler &rfcoiPodRC);

   /***************************************************************************
   ** FUNCTION:  ipodauth_tclDiagRoutineCtrlHandler& ipodauth_tclDiagRoutineC..
   ***************************************************************************/
   /*!
    * \brief   Assignment Operator
    * \param   [rfcoiPodRC]: (I) Const reference to object to be copied
    * \retval  [ipodauth_tclDiagRoutineCtrlHandler&]: Reference to this pointer.
    * \note    Assignment operator is declared protected to disable it. So 
    *          that any attempt for assignment will be caught by the compiler.
    * \date 14.03.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ipodauth_tclDiagRoutineCtrlHandler& operator=(const ipodauth_tclDiagRoutineCtrlHandler &rfcoiPodRC);

   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/
private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  tU32 ipodauth_tclDiagRoutineCtrlHandler::u32ProcessSelfTest..
   ***************************************************************************/
   /*!
    * \brief   Function to process the self test request.
    * \param   [MsgContext]: (I) Message context.
    * \retval  NONE
    * \date 14.03.2011 \author Ramkumar Muniraj (RBEI/ECV1)
    **************************************************************************/
   tU32 u32ProcessSelfTestRequest(tContext MsgContext);

   /*!
   * \addtogroup tclMem
   */
   /*! @{*/

   tclServiceDiaglib* m_poDiaglibService;      ///< DiagLib service pointer.
   tclRoutineControlIF*  m_poRoutineCtrlIf;    ///< DiagLib routine control IF pointer.
   
   /*! @}*/
   
   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/
}; // class ipodauth_tclDiagRoutineCtrlHandler: public tclRoutineControlListene..

#endif // #ifndef IPOD_TCLDIAGROUTINEHANDLER_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
