/*!
********************************************************************************
* \file              ipodauth_tclDiagLibHandler.h
********************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   VD-iPod Authentication
*  - DESCRIPTION:    Implementation of a Diagnosis Dialib handlers.
*  - COPYRIGHT:      &copy; 2011 Robert Bosch GmbH, Hildesheim
********************************************************************************
* \date 14.03.2011 \version 1.2 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - DiagLib service changed from main app to Diaglib handler.
* - Doxygen document adaptations.
*
* \date 10.03.2011 \version 1.0 \author Ramkumar Muniraj (RBEI/ECV1)
* \bug No known bugs
*******************************************************************************/

#ifndef IPOD_TCLDIAGLIBHANDLER_H_
#define IPOD_TCLDIAGLIBHANDLER_H_

/*******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|-----------------------------------------------------------------------------*/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>

#define DIAGLIB_INCLUDE_GENERIC
#include <diaglib_if.h>
using namespace diaglib;

/*******************************************************************************
| defines and macros (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| typedefs (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| forward declarations
|-----------------------------------------------------------------------------*/

class ipodauth_tclDiagRoutineCtrlHandler;
class ipodauth_tclDiagDataIDHandler;

/*! 
 * \class ipodauth_tclDiagLibHandler
 * \brief DiagLib handler class
 *
 */

class ipodauth_tclDiagLibHandler
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ipodauth_tclDiagLibHandler::ipodauth_tclDiagLibHandlerahl_t..
   ***************************************************************************/
    /*!
    * \brief   Parameterized Constructor, based on Dependency Injection 
    *          Principle (DIP)
    * \param   [cpoApp]: (->I) Pointer to main application
    * \retval  NONE
    * \date 14.03.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ipodauth_tclDiagLibHandler(ahl_tclBaseOneThreadApp* const cpoApp);

   /***************************************************************************
   ** FUNCTION:  virtual ipodauth_tclDiagLibHandler::~ipodauth_tclDiagLibHand..
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 10.03.2011 \author Ramkumar Muniraj (RBEI/ECV1)
    **************************************************************************/
   virtual ~ipodauth_tclDiagLibHandler();

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/
protected:

   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ipodauth_tclDiagLibHandler::ipodauth_tclDiagLibHandler...
   ***************************************************************************/
   /*!
    * \brief   Default Constructor
    * \param   NONE
    * \retval  NONE
    * \note    Default constructor is declared protected to disable it. So 
    *          that any attempt to create without parameter will be caught by 
    *          the compiler.
    * \date 14.03.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ipodauth_tclDiagLibHandler();

   /***************************************************************************
   ** FUNCTION:  ipodauth_tclDiagDataIDHandler::ipodauth_tclDiagDataIDHandler..
   ***************************************************************************/
   /*!
    * \brief   Copy Constructor
    * \param   [rfcoDiagLib]: (I) Const reference to object to be copied
    * \retval  NONE
    * \note    Default copy constructor is declared protected to disable it. So 
    *          that any attempt to copy will be caught by the compiler.
    * \date 14.03.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ipodauth_tclDiagLibHandler(const ipodauth_tclDiagLibHandler &rfcoiPodRC);

   /***************************************************************************
   ** FUNCTION:  ipodauth_tclDiagLibHandler& ipodauth_tclDiagLibHandler..
   ***************************************************************************/
   /*!
    * \brief   Assignment Operator
    * \param   [rfcoDiagLib]: (I) Const reference to object to be copied
    * \retval  [ipodauth_tclDiagLibHandler&]: Reference to this pointer.
    * \note    Assignment operator is declared protected to disable it. So 
    *          that any attempt for assignment will be caught by the compiler.
    * \date 14.03.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ipodauth_tclDiagLibHandler& operator=(const ipodauth_tclDiagLibHandler &rfcoDiagLib);

   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/
private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/
   
   /*!
   * \addtogroup tclMem
   */
   /*! @{*/

   tclServiceDiaglib* m_poDiagLibService;                   ///< Diaglib service
   ipodauth_tclDiagRoutineCtrlHandler* m_poDiagRoutineCtrl; ///< Diaglib routine control
   ipodauth_tclDiagDataIDHandler* m_poDiagDataID;           ///< Diaglib data id
   
   /*! @}*/

   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/                                     
}; // class ipodauth_tclDiagLibHandler

#endif // IPOD_TCLDIAGLIBHANDLER_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
