/*!
********************************************************************************
* \file              ipodauth_tclDiagDataIDHandler.h
********************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   VD-iPod Authentication
*  - DESCRIPTION:    Implementation of a Dignosis Diaglib Data ID Listener
*  - COPYRIGHT:      &copy; 2011 Robert Bosch GmbH, Hildesheim
********************************************************************************
* \date 14.03.2011 \version 1.2 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - Doxygen document adaptations.
*
* \date 10.03.2011 \version 1.1 \author Ramkumar Muniraj (RBEI/ECV1)
* - Modified to get Ipod Firmware version. 
*
* \date 12.11.2010 \version 1.0 \author TMS Plischke 
* \bug No known bugs
*******************************************************************************/

#ifndef IPODAUTH_TCLDIAGDATAIDHANDLER_H
#define IPODAUTH_TCLDIAGDATAIDHANDLER_H

/*******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|-----------------------------------------------------------------------------*/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>

#define DIAGLIB_INCLUDE_ID_SPEC_TYPES
#define DIAGLIB_INCLUDE_GENERIC
#include <diaglib_if.h>
using namespace diaglib;

/*******************************************************************************
| defines and macros (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| typedefs (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| forward declarations
|-----------------------------------------------------------------------------*/

/*! 
 * \class ipodauth_tclDiagRoutineCtrlHandler
 * \brief VD-iPodAuth diag routine control handler.
 *
 * \note Message are received by implementing ListenerInterfaces and registering 
 * them with diagnosis library. 
 */

class ipodauth_tclDiagDataIDHandler: public tclDiagnosisDataListenerIF
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ipodauth_tclDiagDataIDHandler::ipodauth_tclDiagDataIDHandler..
   ***************************************************************************/
   /*!
    * \brief   Parameterized Constructor, based on Dependency Injection 
    *          Principle (DIP)
    * \param   [cpoDiaglibService]: (->I) Pointer to diaglib service.
    * \retval  NONE
    * \date 10.03.2011 \author Ramkumar Muniraj (RBEI/ECV1)
    **************************************************************************/
   ipodauth_tclDiagDataIDHandler(tclServiceDiaglib* const cpoDiaglibService);

   /***************************************************************************
   ** FUNCTION:  virtual ipodauth_tclDiagDataIDHandler::~ipodauth_tclDiagData..
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 10.03.2011 \author Ramkumar Muniraj (RBEI/ECV1)
    **************************************************************************/
   virtual ~ipodauth_tclDiagDataIDHandler();

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/
protected:

   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  virtual tU32 ipodauth_tclDiagDataIDHandler::vOnDiagnosisData..
   ***************************************************************************/
   /*!
   * \brief Incoming diagnosis data event handler
   *
   * Is called on incoming diagnostic read requests. Components reaction 
   * should be one of the following:
   *
   * \param    [u32DiagDataId]:  (I)   Diagnosis data ID of the incoming request
   * \param    [poMsgContext]:   (->I) Internal message context. Just return 
   *           exactly this context when you answer to this request.
   *
   * \return   [tU32] ResultCode, currently not checked. Please return 0.
   **************************************************************************/
   virtual tU32 vOnDiagnosisDataRead(tU32 u32DiagDataId, tContext MsgContext);

   /***************************************************************************
   ** FUNCTION:  virtual tU32 ipodauth_tclDiagDataIDHandler::vOnDiagnosisData..
   ***************************************************************************/
   /*!
   * \brief Incoming diagnosis data event handler
   *
   * Is called on incoming diagnostic write requests. Components reaction 
   * should be one of the following:
   *
   * \param    [u32DiagDataId]:  (I)   Diagnosis data ID of the incoming request
   * \param    [rfcoParamVector]: (I)  Parameters as specified in the IDspec
   * \param    [poMsgContext]:   (->I) Internal message context. 
   *           Just return exactly this context when you answer to this request.
   *
   * \return   [tU32] ResultCode, currently not checked. Please return 0.
   **************************************************************************/
   virtual tU32 vOnDiagnosisDataWrite(tU32 /*u32DiagDataId*/
      , const tclParameterVector& /*rfcoParamVector*/, tContext /*MsgContext*/);

   /***************************************************************************
   ** FUNCTION:  ipodauth_tclDiagDataIDHandler::ipodauth_tclDiagDataIDHandler...
   ***************************************************************************/
   /*!
    * \brief   Default Constructor
    * \param   NONE
    * \retval  NONE
    * \note    Default constructor is declared protected to disable it. So 
    *          that any attempt to create without parameter will be caught by 
    *          the compiler.
    * \date 14.03.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ipodauth_tclDiagDataIDHandler();

   /***************************************************************************
   ** FUNCTION:  ipodauth_tclDiagDataIDHandler::ipodauth_tclDiagDataIDHandler..
   ***************************************************************************/
   /*!
    * \brief   Copy Constructor
    * \param   [rfcoiPodRC]: (I) Const reference to object to be copied
    * \retval  NONE
    * \note    Default copy constructor is declared protected to disable it. So 
    *          that any attempt to copy will be caught by the compiler.
    * \date 14.03.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ipodauth_tclDiagDataIDHandler(const ipodauth_tclDiagDataIDHandler &rfcoiPodRC);

   /***************************************************************************
   ** FUNCTION:  ipodauth_tclDiagDataIDHandler& ipodauth_tclDiagDataIDHandler..
   ***************************************************************************/
   /*!
    * \brief   Assignment Operator
    * \param   [rfcoiPodRC]: (I) Const reference to object to be copied
    * \retval  [ipodauth_tclDiagDataIDHandler&]: Reference to this pointer.
    * \note    Assignment operator is declared protected to disable it. So 
    *          that any attempt for assignment will be caught by the compiler.
    * \date 14.03.2011 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ipodauth_tclDiagDataIDHandler& operator=(const ipodauth_tclDiagDataIDHandler &rfcoiPodRC);

   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/
private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  tU32 ipodauth_tclDiagDataIDHandler::u32ProcessIpodFirmwareRe..
   ***************************************************************************/
   /*!
    * \brief   Function to process the self test request.
    * \param   [MsgContext]: (I) Message context.
    * \retval  NONE
    * \date 14.03.2011 \author Ramkumar Muniraj (RBEI/ECV1)
    **************************************************************************/
   tU32 u32ProcessIpodFirmwareRequest(tContext MsgContext);
   
   /*!
   * \addtogroup tclMem
   */
   /*! @{*/

   tclServiceDiaglib* m_poDiaglibService;   ///< DiagLib service pointer.
   tclDiagnosisDataIF* m_poDataIDIf;        ///< DiagLib data id IF pointer.
   
   /*! @}*/
   
   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/   
};
#endif // IPODAUTH_TCLDIAGDATAIDHANDLER_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>
