/*!
*******************************************************************************
* \file              ipodauth_tcliPodAuthService.h
*******************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   Infotainment - Virtual Device iPod Authentication
*  - DESCRIPTION:    iPod Authentication wrapper interface to abstract the old
*                    and the new ADIT iPod Authentication interface.
*  - COPYRIGHT:      &copy; 2010 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 21.04.2011 \version 1.1 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - Updation of macro name IPODAUTH_S32GETSIGNDATA -> IPODAUTH_GETSIGNDATA due
* to return value change.
*
* \date 10.11.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

#ifndef IPODAUTH_WRAPPER_H_
#define IPODAUTH_WRAPPER_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

//#include <adit_typedef.h>
//#include <iap_transport_authentication.h>

#include <ipodcommon.h>
#include <iap_common.h>
#include <authentication.h>

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

#define IPODAUTH_ACC_CERTIF_MAX_LEN       IPOD_AUTH_CP_MAX_CERTLENGTH   // 1920 bytes
#define IPODAUTH_CP_SIGN_MAX_LEN          IPOD_AUTH_CP_SIGN_DATA_SIZE   // 128 bytes
#define IPODAUTH_CP_CHALLENGE_MAX_LEN     20                            // 20 bytes
#define IPODAUTH_CP_IPOD_CERTIF_MAX_LEN   1024                          // 1024 bytes


#ifndef AUTHENTICATION_IMPORTAL_H

#define IPODAUTH_S32INIT()                         IPOD_OK     // iPodInitAuthentication()
#define IPODAUTH_S32DEINIT()                       IPOD_OK     // iPodDeinitAuthentication()
#define IPODAUTH_GETCERTIFICATE(o1, o2)            IPOD_ERROR  // iPodGetAuthenticateCertificate(o1, o2)
#define IPODAUTH_S32GETSIGNDATA(i1, i2, o1, o2)    IPOD_ERROR  // iPodGetSignatureData(i1, i2, o1, o2)
#define IPODAUTH_S32GETDEVICEID(o1)                iPodAuthenticationGetDeviceID(o1)
#define IPODAUTH_S32GETFIRMWAREVERSION(o1, o2)     iPodAuthenticationGetFirmwareVersion(o1, o2)
#define IPODAUTH_S32GETPROTOCOLVERSION(o1, o2)     iPodAuthenticationGetProtocolVersion(o1, o2)
#define IPODAUTH_S32SELFTEST(o1, o2, o3, o4)       iPodAuthenticationSelftest(o1, o2, o3, o4)
#define IPODAUTH_S32SETCERTIFICATE(i1, i2)         IPOD_ERROR  // iPodSetAuthenticateCertificate(i1, i2)
#define IPODAUTH_S32GETCHALLENGEDATA(o1, o2)       IPOD_ERROR  // iPodGetiPodAuthenticationChallengeData(o1, o2)
#define IPODAUTH_S32SETSIGNATURE(i1, i2)           IPOD_ERROR  // iPodGetiPodAuthenticationSignature(i1, i2)

#else

#define IPODAUTH_S32INIT()                         AuthenticationInit()
#define IPODAUTH_S32DEINIT()                       AuthenticationDeinit()
#define IPODAUTH_GETCERTIFICATE(o1, o2)            AuthenticationGetCertificate(o1, o2)
#define IPODAUTH_S32GETSIGNDATA(i1, i2, o1, o2)    AuthenticationGetSignatureData(i1, i2, o1, o2)
#define IPODAUTH_S32GETDEVICEID(o1)                AuthenticationGetDeviceID(o1)
#define IPODAUTH_S32GETFIRMWAREVERSION(o1, o2)     AuthenticationGetFirmwareVersion(o1, o2)
#define IPODAUTH_S32GETPROTOCOLVERSION(o1, o2)     AuthenticationGetProtocolVersion(o1, o2)
#define IPODAUTH_S32SELFTEST(o1, o2, o3, o4)       AuthenticationSelftest(o1, o2, o3, o4)
#define IPODAUTH_S32SETCERTIFICATE(i1, i2)         AuthenticationSetCertificate(i1, i2)
#define IPODAUTH_S32GETCHALLENGEDATA(o1, o2)       AuthenticationGetChallengeData(o1, o2)
#define IPODAUTH_S32SETSIGNATURE(i1, i2)           AuthenticationGetSignature(i1, i2)

#endif   // #ifndef AUTHENTICATION_IMPORTAL_H

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif   // #ifndef IPODAUTH_WRAPPER_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
