/*-----------------------------------------------------------------------------*
 * ReaderKDS.h                                                      *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: GMPr                                              *
 * PROJECT     : GM G3G                                                   *
 * COPYRIGHT   : (c) 2014-2016  Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file ReaderKDS.h
 *
 * \brief Implementation to open, read and close persistent configuration
 *
 * \version 05.03.2014, Koechling Christian (CM-AI/ECD1), version 1.0
 
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2016
 */

#ifndef READER_KDS_H
#define READER_KDS_H  

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class ReaderKDS
 */

class ReaderKDS
{
    public:

        /*!
         * \brief Default constructor
         */
        ReaderKDS();

        /*!
         * \brief Destructor
         */
        virtual ~ReaderKDS();

        /*!
         * \brief 
         */
        tBool bReadKDS(IN tU16 u16EntryID, IN tU16 u16EntryLength, OUT  tU8 (&f_u8Array)[KDS_MAX_ENTRY_LENGTH]);

    private:
        
        OSAL_tIODescriptor m_oFileDescrKDS;

};
// class ReaderKDS

#endif // READER_KDS_H

////////////////////////////////////////////////////////////////////////////////
// <EOF>
