/*
 * FC_MediaPlayer_clienthandler_SPM.cpp
 *
 *  Created on: Nov 7, 2013
 *      Author: din3kor
 */

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CLIENTHANDLER_SPM
#include "trcGenProj/Header/FC_MediaPlayer_clienthandler_SPM.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_CLIENTHANDLER_SPM
#endif

#include "FC_MediaPlayer_main.h"
#include "FC_MediaPlayer_clienthandler_SPM.h"
#include "MediaPlayerInterface.h"
#include "FunctionTracer.h"
#include "LocalSPM.h"
#include "VarTrace.h"

#define SPM_SERVICE_FI_MAJOR_VERSION  1//SPM_COREFI_C_U16_SERVICE_MAJORVERSION
#define SPM_SERVICE_FI_MINOR_VERSION  2//SPM_COREFI_C_U16_SERVICE_MINORVERSION

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_mediaplayer_tclClientHandler_SPM, ahl_tclBaseWork)
#ifdef VARIANT_S_FTR_ENABLE_SUZ
ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_SYSPWRMODE,AMT_C_U8_CCAMSG_OPCODE_STATUS,vUpdateSysPwrMode)
#endif

ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_SYSTEMSTATE,AMT_C_U8_CCAMSG_OPCODE_STATUS,onSystemStateChange)
END_MSG_MAP()

/*******************************************************************************
 *
 * FUNCTION: fc_mediaplayer_tclClientHandler_SPM::fc_mediaplayer_tclClientHandler_SPM(fc_mediaplayer_tclApp* poMainAppl)
 *
 * DESCRIPTION: Constructor.
 *
 *              Create an object of the base class
 *              ahl_tclBaseOneThreadClientHandler with a pointer to this
 *              application, the to be used service identifier and the service
 *              version as parameters.
 *
 * PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
fc_mediaplayer_tclClientHandler_SPM::
fc_mediaplayer_tclClientHandler_SPM(fc_mediaplayer_tclApp* poMainAppl) //finished: 100%
: ahl_tclBaseOneThreadClientHandler(
        /* Application Pointer          */ poMainAppl,
        /* ID of used Service           */ CCA_C_U16_SRV_SPM,//Preethika check
        /* MajorVersion of used Service */ SPM_SERVICE_FI_MAJOR_VERSION,//Preethika check
        /* MinorVersion of used Service */ SPM_SERVICE_FI_MINOR_VERSION )//Preethika check
{
    ENTRY
    m_poMainAppInstance = poMainAppl;
#ifdef VARIANT_S_FTR_ENABLE_SUZ
    vAddAutoRegisterForProperty(SPM_COREFI_C_U16_SYSPWRMODE);
#endif


    vAddAutoRegisterForProperty(SPM_COREFI_C_U16_SYSTEMSTATE);

}
/*******************************************************************************
 *
 * FUNCTION: fc_mediaplayer_tclClientHandler_SPM::
 *             ~fc_mediaplayer_tclClientHandler_SPM(tVoid)
 *
 * DESCRIPTION: Destructor.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
fc_mediaplayer_tclClientHandler_SPM::~fc_mediaplayer_tclClientHandler_SPM(tVoid)
{
    ENTRY
}
void fc_mediaplayer_tclClientHandler_SPM::onSystemStateChange(amt_tclServiceData* poMessage)
{
    ENTRY
    tResult ret = MP_NO_ERROR;
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    spm_corefi_tclMsgSystemStateStatus  oSPMSystemStateStatus;
    if (oVisitorMsg.s32GetData(oSPMSystemStateStatus, SPM_SERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4(("Received SPMSystemState %d", oSPMSystemStateStatus.SystemState.enType));

        switch (oSPMSystemStateStatus.SystemState.enType)
        {
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_BACKGROUND:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_PREPARE_SHUTDOWN:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SHUTDOWN:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SUSPEND:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OFF:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOWNLOAD:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOOR_OPEN:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_IGNITION:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STATE_PROFILE:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_RESTRICTED:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_DIAG:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_TEL:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_SWDL:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_CUSTOMER_SWDL:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OVERTEMP:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SAFE:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STATE_MAX:
            {
                   LocalSPM::GetDataProvider().SetIpodMuteStatus(false);
                   LocalSPM::GetDataProvider().SetSPMStandByModeStatus(true);
                   tDeviceInfo deviceInfo;
                   InitDeviceInfo(deviceInfo);
                   ret = MediaPlayerInterface::GetInstance().ActiveMediaDeviceGet(OUT deviceInfo);
                   if((MP_NO_ERROR == ret) && IsAppleDevice(deviceInfo.deviceType))
                   {
                       ret = MediaPlayerInterface::GetInstance().SendSourceActivity(SA_PAUSE);
                   }
                   VARTRACE(LocalSPM::GetDataProvider().GetSPMStandByModeStatus());
            }
            break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_ON:
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON:
            {
                   LocalSPM::GetDataProvider().SetSPMStandByModeStatus(false);
                   VARTRACE(LocalSPM::GetDataProvider().GetSPMStandByModeStatus());
                   LocalSPM::GetDataProvider().SetIpodMuteStatus(false);
                   VARTRACE(LocalSPM::GetDataProvider().GetIpodMuteStatus());
            }
            break;
            default:
            {
                   LocalSPM::GetDataProvider().SetSPMStandByModeStatus(false);
            }
            break;
        }
    }
    else
    {
        ETG_TRACE_ERR(("OSAL Error encountered"));
    }
    oSPMSystemStateStatus.vDestroy();

}

void fc_mediaplayer_tclClientHandler_SPM::vUpdateSysPwrMode(amt_tclServiceData* poMessage)
{
    ENTRY
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    spm_corefi_tclMsgSysPwrModeStatus oSPMSysPwrStateStatus;
    if (oVisitorMsg.s32GetData(oSPMSysPwrStateStatus, SPM_SERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
        ETG_TRACE_USR4(("Received SPMSysPowerMode %d", oSPMSysPwrStateStatus.SysPwrMode.enType));
        //FC_Bluetooth_tclService_BluetoothSettings *poBtSettings = FC_Bluetooth_tclService_BluetoothSettings::poGetInstance();
        //m_u32BTState = (tU32) oBTStateStatus.BtState.enType;

        switch (oSPMSysPwrStateStatus.SysPwrMode.enType)
        {
            case spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_UNDEFINED:
                ETG_TRACE_USR4(("Received SPMSysPowerMode %d", ETG_CENUM(tSPMSysPwrState, SPM_SYSPWRMODE_UNDEFINED)));
                LocalSPM::GetDataProvider().vUpdateSPMSysPwrMode(SPM_SYSPWRMODE_UNDEFINED);
                break;
            case spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_OFF:
                ETG_TRACE_USR4(("Received SPMSysPowerMode %d", ETG_CENUM(tSPMSysPwrState, SPM_SYSPWRMODE_OFF)));
                LocalSPM::GetDataProvider().vUpdateSPMSysPwrMode(SPM_SYSPWRMODE_OFF);
                break;
            case spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_ACCESSORY:
                ETG_TRACE_USR4(("Received SPMSysPowerMode %d", ETG_CENUM(tSPMSysPwrState, SPM_SYSPWRMODE_ACCESSORY)));
                LocalSPM::GetDataProvider().vUpdateSPMSysPwrMode(SPM_SYSPWRMODE_ACCESSORY);
                break;
            case spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_RUN:
                ETG_TRACE_USR4(("Received SPMSysPowerMode %d", ETG_CENUM(tSPMSysPwrState, SPM_SYSPWRMODE_RUN)));
                LocalSPM::GetDataProvider().vUpdateSPMSysPwrMode(SPM_SYSPWRMODE_RUN);
                break;
            case spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_CRANK:
                ETG_TRACE_USR4(("Received SPMSysPowerMode %d", ETG_CENUM(tSPMSysPwrState, SPM_SYSPWRMODE_CRANK)));
                LocalSPM::GetDataProvider().vUpdateSPMSysPwrMode(SPM_SYSPWRMODE_CRANK);
                break;
            default:
                ETG_TRACE_USR2(("Received SPMSysPowerMode %d", ETG_CENUM(tSPMSysPwrMode, SPM_SYSPWRMODE_UNDEFINED)));
                LocalSPM::GetDataProvider().vUpdateSPMSysPwrMode(SPM_SYSPWRMODE_RUN);
                break;
        }
    }
    else
    {
        ETG_TRACE_ERR(("OSAL Error encountered"));
    }
    oSPMSysPwrStateStatus.vDestroy();
}


/*******************************************************************************
 *
 * FUNCTION: fc_bluetooth_tclClientHandler_SpmCore::
 *           vOnServiceAvailable()
 *
 * DESCRIPTION: This function is called by the CCA framework when the service
 *              this client-handler has registered for has become available.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
 *******************************************************************************/
void fc_mediaplayer_tclClientHandler_SPM::vOnServiceAvailable()
{
    ENTRY
    LocalSPM::GetDataProvider().vUpdateSPMSysPwrMode(SPM_SYSPWRMODE_RUN);
    LocalSPM::GetDataProvider().SetSPMStandByModeStatus(false);

}

/*******************************************************************************
 *
 * FUNCTION: fc_bluetooth_tclClientHandler_SpmCore::
 *           vOnServiceUnavailable()
 *
 * DESCRIPTION: This function is called by the CCA framework when the service
 *              this client-handler has registered for has become unavailable.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable()
 *******************************************************************************/
void fc_mediaplayer_tclClientHandler_SPM::vOnServiceUnavailable()
{
    ENTRY
    LocalSPM::GetDataProvider().vUpdateSPMSysPwrMode(SPM_SYSPWRMODE_OFF);
    LocalSPM::GetDataProvider().SetSPMStandByModeStatus(false);
}
