/**
 * @author Stefan Scherber
 *
 * Implentation of CCAClientHandlerSPI
 *
 */

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_APPLICATION
#include "trcGenProj/Header/FC_MediaPlayer_clienthandler_GenSPI.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_APPLICATION
#endif

#include "FC_MediaPlayer_main.h"
#include "FC_MediaPlayer_clienthandler_GenSPI.h"
#include "FunctionTracer.h"
#include "VarTrace.h"



/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

                                             // Version defines for used service
#define SPI_FI_MAJOR_VERSION  MIDW_SMARTPHONEINTFI_C_U16_SERVICE_MAJORVERSION
#define SPI_FI_MINOR_VERSION  MIDW_SMARTPHONEINTFI_C_U16_SERVICE_MINORVERSION

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_mediaplayer_tclClientHandler_SPI, ahl_tclBaseWork)
    ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_DIPOROLESWITCHREQUIRED,AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,onDIPORoleSwitchRequiredResult)
    ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_DIPOROLESWITCHREQUIRED,AMT_C_U8_CCAMSG_OPCODE_ERROR,onDIPORoleSwitchRequiredError)
    ON_MESSAGE_SVCDATA(MIDW_SMARTPHONEINTFI_C_U16_GETWIFICREDENTIALS,AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,onGetWiFiCredentialsResult)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_mediaplayer_tclClientHandler_SPI::
*             fc_mediaplayer_tclClientHandler_SPI(fc_mediaplayer_tclApp* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_mediaplayer_tclClientHandler_SPI::
  fc_mediaplayer_tclClientHandler_SPI(fc_mediaplayer_tclApp* poMainAppl) //finished 100%
    : ahl_tclBaseOneThreadClientHandler(
      /* Application Pointer          */ poMainAppl,
      /* ID of used Service           */ CCA_C_U16_SRV_SMARTPHONEINTEGRATION,
      /* MajorVersion of used Service */ SPI_FI_MAJOR_VERSION,
      /* MinorVersion of used Service */ SPI_FI_MINOR_VERSION )
{
    ENTRY
    _tclRegisterPair.bAddPair(AMT_C_U32_STATE_OFF, AMT_C_U32_STATE_NORMAL);
    _tclUnregisterPair.bAddPair(AMT_C_U32_STATE_NORMAL, AMT_C_U32_STATE_OFF);
    lastDeviceID = 0;
    deviceIDforWIFICredential = 0;
    isSPIServiceAvailable = false;
}

/*******************************************************************************
*
* FUNCTION: fc_mediaplayer_tclClientHandler_SPI::
*             ~fc_mediaplayer_tclClientHandler_SPI(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_mediaplayer_tclClientHandler_SPI::
  ~fc_mediaplayer_tclClientHandler_SPI(tVoid) //finished 100%
{
    ENTRY
    isSPIServiceAvailable = false;
}

tVoid fc_mediaplayer_tclClientHandler_SPI::vOnServiceAvailable()
{
    ENTRY
    isSPIServiceAvailable = true;
}

tVoid fc_mediaplayer_tclClientHandler_SPI::vOnServiceUnavailable()
{
    ENTRY
    isSPIServiceAvailable = false;
}

tResult fc_mediaplayer_tclClientHandler_SPI::SendDIPORoleSwitchRequired(const tDeviceID deviceID, const tMountPoint USBSerialNumber,const tBool DeviceCarplayCapability)
{
    ENTRY
    VARTRACE(deviceID)
    VARTRACE(DeviceCarplayCapability)
    tResult result = MP_NO_ERROR;
    if(isSPIServiceAvailable)
    {
        midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodStart startMessage;
        startMessage.u8DeviceTag = (tU8) deviceID;
        startMessage.USBSerialNumber.bSet(USBSerialNumber,midw_fi_tclString::FI_EN_UTF8);

        startMessage.DeviceCarplayCapability = DeviceCarplayCapability;

        // store last send device id if error message is received
        lastDeviceID = deviceID;

        fi_tclVisitorMessage oVisitorMsgOutput(startMessage, SPI_FI_MAJOR_VERSION);
        vInitServiceData(oVisitorMsgOutput, 0, MIDW_SMARTPHONEINTFI_C_U16_DIPOROLESWITCHREQUIRED, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
        ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
        if (AIL_EN_N_NO_ERROR != enResult)
        {
            ETG_TRACE_ERR (("Unable to send DIPORoleSwitchRequired to SPI"));
            result = -1;
        }
        startMessage.vDestroy();
    }
    else
    {
        ETG_TRACE_USR4(("SPI Service not available.Unable to send DIPORoleSwitchRequired to SPI"));
        result = -1;
    }

    VARTRACE(result)
    return result;
}

tVoid fc_mediaplayer_tclClientHandler_SPI::onDIPORoleSwitchRequiredResult(amt_tclServiceData* poMessage)
{
    ENTRY
    midw_smartphoneintfi_tclMsgDiPORoleSwitchRequiredMethodResult resultMessage;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(resultMessage, SPI_FI_MAJOR_VERSION))
    {
        tDeviceID deviceID = resultMessage.u8DeviceTag;
        tDiPOSwitchReqResponse diPOSwitchReqResponse;
        tAppInfo appInfo;
        tMountPoint USBSerialNumber;

        strncpy_r(USBSerialNumber,resultMessage.USBSerialNumber.szGet(midw_fi_tclString::FI_EN_UTF8),sizeof(USBSerialNumber));

        VARTRACE(deviceID);
        VARTRACE(USBSerialNumber);
        if(!deviceID)
        {
            MediaPlayerInterface::GetInstance().GetDeviceID(deviceID,USBSerialNumber);
        }


        VARTRACE(deviceID);
        ConvertDiPOSwitchReqResponseToInternal(diPOSwitchReqResponse, resultMessage.e8DiPOSwitchReqResponse);
        ConvertAppInfoToInternal(appInfo,resultMessage.rEAPAppInfo);

        MediaPlayerInterface::GetInstance().DiPORoleSwitchRequiredResult(IN deviceID, IN diPOSwitchReqResponse,appInfo);
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    resultMessage.vDestroy();
}

tVoid fc_mediaplayer_tclClientHandler_SPI::onDIPORoleSwitchRequiredError(amt_tclServiceData* /*poMessage*/)
{
    ENTRY
    tDiPOSwitchReqResponse diPOSwitchReqResponse = DIPO_ROLE_SWITCH_NOT_REQUIRED;
    MediaPlayerInterface::GetInstance().DiPORoleSwitchRequiredResult(IN lastDeviceID, IN diPOSwitchReqResponse);
}

tResult fc_mediaplayer_tclClientHandler_SPI::SendGetWiFiCredentials(const tDeviceID deviceId, const tMACAddress appleDeviceMACAddress)
{
    ENTRY

    tResult result = MP_NO_ERROR;
    if(isSPIServiceAvailable)
    {
        deviceIDforWIFICredential = deviceId;
        midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodStart startMessage;

        startMessage.BTMACAddress.bSet(appleDeviceMACAddress,midw_fi_tclString::FI_EN_UTF8);

        fi_tclVisitorMessage oVisitorMsgOutput(startMessage, SPI_FI_MAJOR_VERSION);
        vInitServiceData(oVisitorMsgOutput, 0, MIDW_SMARTPHONEINTFI_C_U16_GETWIFICREDENTIALS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
        ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oVisitorMsgOutput, TRUE);
        if (AIL_EN_N_NO_ERROR != enResult)
        {
            ETG_TRACE_ERR (("Unable to send GetWiFiCredentials to SPI"));
            result = -1;
        }
        startMessage.vDestroy();
    }
    else
    {
        ETG_TRACE_USR4(("SPI Service not available.Unable to send GetWiFiCredentials to SPI"));
        result = -1;
    }

    VARTRACE(result)
    return result;
}

tVoid fc_mediaplayer_tclClientHandler_SPI::onGetWiFiCredentialsResult(amt_tclServiceData* poMessage)
{
    ENTRY
    midw_smartphoneintfi_tclMsgGetWiFiCredentialsMethodResult resultMessage;
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    if (OSAL_ERROR != oVisitorMsg.s32GetData(resultMessage, SPI_FI_MAJOR_VERSION))
    {
        // Fix for 750919 : CPW session does not start very first time
        // If GetWiFiCredentials is updated with error, current iAP BT session is to be ended and SPP to be disconnected
        bool bError = false;
        VARTRACE(resultMessage.ErrorCode.enType);
        if(midw_fi_tcl_e8_ErrorType::FI_EN_NO_ERROR != resultMessage.ErrorCode.enType)
        {
            bError = true;
        }

        midw_fi_tcl_WiFiAPCredentials accessoryWiFiAPCredentials = resultMessage.AccessoryWiFiAPCredentials;
        tWiFiAPCredentials wifiCredentials;
        ConvertAccessoryCredentialsToInternal(wifiCredentials,accessoryWiFiAPCredentials);

        MediaPlayerInterface::GetInstance().GetWiFiCredentialsResult(deviceIDforWIFICredential, wifiCredentials, bError);
    }
    else
    {
        NORMAL_M_ASSERT_ALWAYS();
    }
    resultMessage.vDestroy();
}

void fc_mediaplayer_tclClientHandler_SPI::ConvertAccessoryCredentialsToInternal(tWiFiAPCredentials &wifiCredentials, const midw_fi_tcl_WiFiAPCredentials accessoryWiFiAPCredentials)
{
    ENTRY

    InittWiFiAPCredentials(wifiCredentials);
    strncpy(wifiCredentials.passPhrase, accessoryWiFiAPCredentials.PassPhrase.szGet(midw_fi_tclString::FI_EN_UTF8), sizeof(wifiCredentials.passPhrase) -1);
    strncpy(wifiCredentials.ssid, accessoryWiFiAPCredentials.SSID.szGet(midw_fi_tclString::FI_EN_UTF8), sizeof(wifiCredentials.ssid) -1);

    wifiCredentials.channelNumber = accessoryWiFiAPCredentials.ChannelNo;

    switch(accessoryWiFiAPCredentials.SecurityType.enType)
    {
        case midw_fi_tcl_e8_WiFiSecurityType::FI_EN_NONE:
            wifiCredentials.securityType = WIFI_SECURITY_NONE;
            break;
        case midw_fi_tcl_e8_WiFiSecurityType::FI_EN_WEP:
            wifiCredentials.securityType = WIFI_SECURITY_WEP;
            break;
        case midw_fi_tcl_e8_WiFiSecurityType::FI_EN_WPA_PERSONAL:
            wifiCredentials.securityType = WIFI_SECURITY_WPA_PERSONAL;
            break;
        case midw_fi_tcl_e8_WiFiSecurityType::FI_EN_WPA2_PERSONAL:
            wifiCredentials.securityType = WIFI_SECURITY_WPA2_PERSONAL;
            break;
        default:
            wifiCredentials.securityType = WIFI_SECURITY_NONE;
    }

    ETG_TRACE_USR3((" accessoryWiFiAPCredentials.PassPhrase.szGet = %s",accessoryWiFiAPCredentials.PassPhrase.szGet(midw_fi_tclString::FI_EN_UTF8) ));
    ETG_TRACE_USR3((" accessoryWiFiAPCredentials.SSID.szGet = %s",accessoryWiFiAPCredentials.SSID.szGet(midw_fi_tclString::FI_EN_UTF8) ));
    ETG_TRACE_USR3((" accessoryWiFiAPCredentials.ChannelNo = %d",accessoryWiFiAPCredentials.ChannelNo ));
    ETG_TRACE_USR3((" accessoryWiFiAPCredentials.SecurityType.enType = %d", accessoryWiFiAPCredentials.SecurityType.enType));
}

void fc_mediaplayer_tclClientHandler_SPI::ConvertDiPOSwitchReqResponseToInternal(tDiPOSwitchReqResponse &diPOSwitchReqResponseInternal, const midw_fi_tcl_e8_DiPOSwitchReqResponse diPOSwitchReqResponse)
{
    ENTRY_INTERNAL
    switch(diPOSwitchReqResponse.enType)
    {
    case midw_fi_tcl_e8_DiPOSwitchReqResponse::FI_EN_E8DIPO_ROLE_SWITCH_NOT_REQUIRED:
        diPOSwitchReqResponseInternal = DIPO_ROLE_SWITCH_NOT_REQUIRED;
        break;
    case midw_fi_tcl_e8_DiPOSwitchReqResponse::FI_EN_E8DIPO_ROLE_SWITCH_REQUIRED: // deprecated!
        diPOSwitchReqResponseInternal = DIPO_ROLE_SWITCH_REQUIRED_FOR_CARPLAY;
        break;
    case midw_fi_tcl_e8_DiPOSwitchReqResponse::FI_EN_E8DIPO_ROLE_SWITCH_REQUIRED_FOR_NATIVE_TRANSPORT:
        diPOSwitchReqResponseInternal = DIPO_ROLE_SWITCH_REQUIRED_FOR_NATIVE_TRANSPORT;
        break;
    case midw_fi_tcl_e8_DiPOSwitchReqResponse::FI_EN_E8DIPO_ROLE_SWITCH_REQUIRED_FOR_CARPLAY_AND_NATIVE_TRANSPORT:
        diPOSwitchReqResponseInternal = DIPO_ROLE_SWITCH_REQUIRED_FOR_CARPLAY_AND_NATIVE_TRANSPORT;
        break;
    case midw_fi_tcl_e8_DiPOSwitchReqResponse::FI_EN_E8DIPO_ROLE_SWITCH_REQUIRED_FOR_CARLIFE_AND_NATIVE_TRANSPORT:
        diPOSwitchReqResponseInternal = DIPO_ROLE_SWITCH_REQUIRED_FOR_CARLIFE_AND_NATIVE_TRANSPORT;
        break;
    default:
        diPOSwitchReqResponseInternal = DIPO_ROLE_SWITCH_NOT_REQUIRED;
        ETG_TRACE_ERR(("Invalid tDiPOSwitchReqResponse type"));
        break;
    }
}

void fc_mediaplayer_tclClientHandler_SPI::ConvertAppInfoToInternal(tAppInfo &appInfo, const midw_fi_tcl_EAPAppInfo info) //finished: 100%
{
     InitAppInfo(appInfo);
     strncpy(appInfo.AppName, info.szAppName.szGet(midw_fi_tclString::FI_EN_UTF8), sizeof(appInfo.AppName) -1);
     strncpy(appInfo.ProtocolName, info.szProtocol.szGet(midw_fi_tclString::FI_EN_UTF8), sizeof(appInfo.ProtocolName) -1);
     strncpy(appInfo.BundleID, info.szBundleID.szGet(midw_fi_tclString::FI_EN_UTF8), sizeof(appInfo.BundleID) -1);
}

