/**
 * @defgroup CCAClientHandlerSPM CCAClientHandlerBluetoothSPM
 * @ingroup MediaPlayer
 * @author Preethika
 *
 * Public interface for CCAClientHandler SPM
 * @{
 */

#ifndef FC_MEDIAPLAYER_CLIENTHANDLER_SPM_H_
#define FC_MEDIAPLAYER_CLIENTHANDLER_SPM_H_

// Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

// Include message framework interface (AMT, msgfw).
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//Include public FI interface of this service.
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_TYPES
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_SERVICEINFO
#include "spm_fi_if.h"

#include "TypeDefinitions.h"

class ahl_tclBaseOneThreadClientHandler;
class fc_mediaplayer_tclApp;

/**
 * This class implements the CCAClientHandlerSPM component.
 */
class fc_mediaplayer_tclClientHandler_SPM:public ahl_tclBaseOneThreadClientHandler
{
private:
    fc_mediaplayer_tclApp* m_poMainAppInstance;



public:

    /**
     * Constructor of the service class
     */
    fc_mediaplayer_tclClientHandler_SPM(fc_mediaplayer_tclApp* poMainAppl);

    /**
     * Destructor of the service class
     * @return
     */
    virtual ~fc_mediaplayer_tclClientHandler_SPM();

    /**
     * Function to get the State of the SPM
     */
    virtual void vOnServiceAvailable();
    virtual void vOnServiceUnavailable();




    /*Get the property update for the SPM property SysPwrMode */
    void vUpdateSysPwrMode(amt_tclServiceData* poMessage);

    void onSystemStateChange(amt_tclServiceData* poMessage);

protected:


    /**
     * Message map definition macro
     */
    DECLARE_MSG_MAP(fc_mediaplayer_tclClientHandler_SPM)


};

/** @} */


#endif /* FC_MEDIAPLAYER_CLIENTHANDLER_SPM_H_ */
