/**
 * @defgroup CCAClientHandlerBluetoothSettings CCAClientHandlerBluetoothSettings
 * @ingroup MediaPlayer
 * @author Dinesh
 *
 * Public interface for CCAClientHandler Bluetooth Settings
 * @{
 */

#ifndef FC_MEDIAPLAYER_CLIENTHANDLER_GenBTSETTINGS_H_
#define FC_MEDIAPLAYER_CLIENTHANDLER_GenBTSETTINGS_H_

// Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

// Include message framework interface (AMT, msgfw).
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//Include public FI interface of this service.
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_ERRORCODES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_SERVICEINFO
#include "conn_most_fi_if.h"

#include "TypeDefinitions.h"
#include <map>

class ahl_tclBaseOneThreadClientHandler;
class fc_mediaplayer_tclApp;

/**
 * This class implements the CCAClientHandlerBluetoothSettings component.
 */
class fc_mediaplayer_tclClientHandler_GenBTSettings:public ahl_tclBaseOneThreadClientHandler
{
private:
    fc_mediaplayer_tclApp* m_poMainAppInstance;

    /**
     * Internal SPP connection state enum to handle the SPP connection and disconnection.
     */
    typedef enum
    {
        SPP_REQUESTED,
        SPP_RESPONSE_RECEIVED,
        SPP_CONNECTED,
        SPP_DISCONNECTED,
        SPP_STATUS_UNKNOWN = 99
    }tSPPConnectionStatus;


    /**
     * Type which represents the BTDevice information with fields relavant for GMP     *
     */
    typedef struct
    {
        tU8 deviceHandle;
        char deviceName[128];
        char deviceAddress[12+1];
        char deviceRFCommID[128];
        tBool isConnected;
        tDeviceVersion deviceVersion;
        tDisconnectReason disconnectReason;
        tBool isAVPConnected;
        tBool isHFPConnected;
        tBool isAvrcpBrowsable;
        tBool isAppleDevice;
        tProductID productID;
        tBool isConnectedOverUSB;
        tBool isSPPProfileSupported;
        tBool isVendorInfoPresent;
        tBool isIAP2BTForAPP;
        tBTLimitationActionState btLimitationActionState;
        tSPPConnectionStatus sppConnectionStatus;
    }tBluetoothDevice;
    /**
    * This function is called to initialize tBluetoothDevice
    * @return void
    */
    void InitBluetoothDevice(tBluetoothDevice &btDevice);
    /**
     * map of known device with device handle as key and device information as value
     */
    map <tU8, tBluetoothDevice> mKnownDevices;

public:

    /**
    * Constructor of the service class
    * _tclRegisterPair.bAddPair(AMT_C_U32_STATE_OFF, AMT_C_U32_STATE_NORMAL) and
    * _tclUnregisterPair.bAddPair(AMT_C_U32_STATE_NORMAL, AMT_C_U32_STATE_OFF) must be called.
    * @param[in] poMainAppl Pointer to the CCA application
    * @return
    */
    fc_mediaplayer_tclClientHandler_GenBTSettings(fc_mediaplayer_tclApp* poMainAppl);

    /**
    * Destructor of the service class
    * @return
    */
    virtual ~fc_mediaplayer_tclClientHandler_GenBTSettings();
    tResult GetBTLimitationModeForMountPoint(const tDeviceSerialNumber serialNumber,tBTLimitationActionState& btLimitation);
    tResult AddOobPairedDevice(const tDeviceID deviceID,const tMACAddress deviceAddress,const tDeviceName deviceName, const tLinkKey linkKey,const tBTOobType oobType);
    tResult DisconnectSPPService(const tMACAddress deviceAddress);
private:

    /**
    * This function is called when result message of GetDeviceInfo is received
    *
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onGetDeviceInfoMethodResult(amt_tclServiceData* poMessage);

    /**
    * This function is called when status message of DeviceList property is received
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onDeviceListStatusExtended(amt_tclServiceData* poMessage);
    tVoid onDeviceListStatus(amt_tclServiceData* poMessage);

    tResult ConnectSPPService(tU8 u8DeviceHandle,tUUID uuid);
    tVoid onConnectSPPServiceMethodResult(amt_tclServiceData* poMessage);
    tVoid onConnectSPPServiceMethodError(amt_tclServiceData* poMessage);

    tVoid onSPPServiceConnection(amt_tclServiceData* poMessage);

    tVoid onDisconnectSPPServiceMethodResult(amt_tclServiceData* poMessage);
    tVoid onDisconnectSPPServiceMethodError(amt_tclServiceData* poMessage);

    /**
    * This function is called when status message of VehicleBTAddress property is received
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onVehicleBTAddress(amt_tclServiceData* poMessage);

    /**
    * This function is called when status message of VehicleBTFriendlyName property is received
    * @param[in] poMessage Message
    * @return void
    */
    tVoid onVehicleBTFriendlyName(amt_tclServiceData* poMessage);

    /**
     * Trigger GetDeviceInfo method request to BTSettings
     * @param[in] u8DeviceHandle device handle of the BT Device reported via DeviceList status
     * @return void
     */
    tResult SendGetDeviceInfoMethod(tU8 u8DeviceHandle);


    tVoid onBluetoothAudioSource(amt_tclServiceData* poMessage);

    tVoid onBluetoothLimitationMode(amt_tclServiceData* poMessage);
    tBTTechnology convertBtTechnology(most_fi_tcl_e8_BTTechnology most_btTechnology);
    tBTCommunicationChannel convertBtCommunicationChannel(most_fi_tcl_e8_BTCommunicationChannel most_btCommunicationChannel);
    tBTLimitationActionState convertBtLimitationActionState(most_fi_tcl_e8_BTLimitationActionState most_btLimitationActionState);

    /**
     * The function UpdateDeviceInfo will update the tDeviceInfo from the mKnowndevice list and
     * inform device information  to GMP via generic device notification interface.
     * @return tResult
     */
    tResult UpdateDeviceInfo(tU8 u8DeviceHandle,bool isIAPBTUpdate = false);

    tVoid vOnServiceAvailable();
    tVoid vOnServiceUnavailable();

    tVoid GetDeviceListExtended();

    tVoid GetSPPServiceConnection();

    tVoid onAddOobPairedDeviceMethodResult(amt_tclServiceData* poMessage);

    tVoid onAddOobPairedDeviceMethodError(amt_tclServiceData* poMessage);

    tDeviceID mOobbtDeviceID;


protected:


   /**
    * Message map definition macro
    */
   DECLARE_MSG_MAP(fc_mediaplayer_tclClientHandler_GenBTSettings)


};

/** @} */


#endif /* FC_MEDIAPLAYER_CLIENTHANDLER_BLUETOOTHSETTINGS_H_ */
